/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming.ui;

import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.spark.sql.streaming.ui.StreamingQueryDataSource;
import org.apache.spark.sql.streaming.ui.StreamingQueryTab;
import org.apache.spark.sql.streaming.ui.StreamingQueryUIData;
import org.apache.spark.sql.streaming.ui.StructuredStreamingRow;
import org.apache.spark.sql.streaming.ui.UIUtils$;
import org.apache.spark.ui.PagedDataSource;
import org.apache.spark.ui.PagedTable;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;

@ScalaSignature(bytes="\u0006\u0001\u0005Uc\u0001B\u000f\u001f\u0001-B\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u000f\"A!\n\u0001B\u0001B\u0003%1\n\u0003\u0005[\u0001\t\u0005\t\u0015!\u0003\\\u0011!\u0019\u0007A!A!\u0002\u0013!\u0007\u0002C4\u0001\u0005\u0003\u0005\u000b\u0011B.\t\u0011!\u0004!\u0011!Q\u0001\nmCQ!\u001b\u0001\u0005\u0002)D!b\u001d\u0001\u0011\u0002\u0003\r\t\u0015!\u0003u\u0011\u001dQ\bA1A\u0005\nmDa\u0001 \u0001!\u0002\u0013Y\u0006bB?\u0001\u0005\u0004%IA \u0005\u0007\u007f\u0002\u0001\u000b\u0011\u00023\t\u0013\u0005\u0005\u0001A1A\u0005\n\u0005\r\u0001bBA\u0003\u0001\u0001\u0006Ia\u001e\u0005\t\u0003\u000f\u0001!\u0019!C\u0005w\"9\u0011\u0011\u0002\u0001!\u0002\u0013Y\u0006\"CA\u0006\u0001\t\u0007I\u0011BA\u0007\u0011!\ti\u0002\u0001Q\u0001\n\u0005=\u0001BBA\u0010\u0001\u0011\u00053\u0010\u0003\u0004\u0002\"\u0001!\te\u001f\u0005\u0007\u0003G\u0001A\u0011I>\t\r\u0005\u0015\u0002\u0001\"\u0011|\u0011\u001d\t9\u0003\u0001C!\u0003SAa!a\f\u0001\t\u0003Z\bbBA\u0019\u0001\u0011\u0005\u00131\u0007\u0005\b\u0003w\u0001A\u0011IA\u001f\u0011\u001d\ti\u0005\u0001C!\u0003\u001f\u0012\u0001d\u0015;sK\u0006l\u0017N\\4Rk\u0016\u0014\u0018\u0010U1hK\u0012$\u0016M\u00197f\u0015\ty\u0002%\u0001\u0002vS*\u0011\u0011EI\u0001\ngR\u0014X-Y7j]\u001eT!a\t\u0013\u0002\u0007M\fHN\u0003\u0002&M\u0005)1\u000f]1sW*\u0011q\u0005K\u0001\u0007CB\f7\r[3\u000b\u0003%\n1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u00173!\ti\u0003'D\u0001/\u0015\u0005y\u0013!B:dC2\f\u0017BA\u0019/\u0005\u0019\te.\u001f*fMB\u00191'N\u001c\u000e\u0003QR!a\b\u0013\n\u0005Y\"$A\u0003)bO\u0016$G+\u00192mKB\u0011\u0001(O\u0007\u0002=%\u0011!H\b\u0002\u0017'R\u0014Xo\u0019;ve\u0016$7\u000b\u001e:fC6Lgn\u001a*po\u00069!/Z9vKN$\bCA\u001fE\u001b\u0005q$BA A\u0003\u0011AG\u000f\u001e9\u000b\u0005\u0005\u0013\u0015aB:feZdW\r\u001e\u0006\u0002\u0007\u0006)!.\u0019<bq&\u0011QI\u0010\u0002\u0013\u0011R$\boU3sm2,GOU3rk\u0016\u001cH/\u0001\u0004qCJ,g\u000e\u001e\t\u0003q!K!!\u0013\u0010\u0003#M#(/Z1nS:<\u0017+^3ssR\u000b'-\u0001\u0003eCR\f\u0007c\u0001'U/:\u0011QJ\u0015\b\u0003\u001dFk\u0011a\u0014\u0006\u0003!*\na\u0001\u0010:p_Rt\u0014\"A\u0018\n\u0005Ms\u0013a\u00029bG.\fw-Z\u0005\u0003+Z\u00131aU3r\u0015\t\u0019f\u0006\u0005\u000291&\u0011\u0011L\b\u0002\u0015'R\u0014X-Y7j]\u001e\fV/\u001a:z+&#\u0015\r^1\u0002\u0011Q\f'\r\\3UC\u001e\u0004\"\u0001\u00181\u000f\u0005us\u0006C\u0001(/\u0013\tyf&\u0001\u0004Qe\u0016$WMZ\u0005\u0003C\n\u0014aa\u0015;sS:<'BA0/\u0003!I7/Q2uSZ,\u0007CA\u0017f\u0013\t1gFA\u0004C_>dW-\u00198\u0002\u0011\t\f7/\u001a)bi\"\fqa];c!\u0006$\b.\u0001\u0004=S:LGO\u0010\u000b\tW2lgn\u001c9reB\u0011\u0001\b\u0001\u0005\u0006w!\u0001\r\u0001\u0010\u0005\u0006\r\"\u0001\ra\u0012\u0005\u0006\u0015\"\u0001\ra\u0013\u0005\u00065\"\u0001\ra\u0017\u0005\u0006G\"\u0001\r\u0001\u001a\u0005\u0006O\"\u0001\ra\u0017\u0005\u0006Q\"\u0001\raW\u0001\u0004q\u0012\"\u0004#B\u0017v7\u0012<\u0018B\u0001</\u0005\u0019!V\u000f\u001d7fgA\u0011Q\u0006_\u0005\u0003s:\u00121!\u00138u\u0003)\u0019xN\u001d;D_2,XN\\\u000b\u00027\u0006Y1o\u001c:u\u0007>dW/\u001c8!\u0003!\u0019xN\u001d;EKN\u001cW#\u00013\u0002\u0013M|'\u000f\u001e#fg\u000e\u0004\u0013\u0001\u00039bO\u0016\u001c\u0016N_3\u0016\u0003]\f\u0011\u0002]1hKNK'0\u001a\u0011\u0002\u001bA\f'/Y7fi\u0016\u0014\b+\u0019;i\u00039\u0001\u0018M]1nKR,'\u000fU1uQ\u0002\n\u0011#\u001a8d_\u0012,GmU8si\u000e{G.^7o+\t\ty\u0001\u0005\u0003\u0002\u0012\u0005mQBAA\n\u0015\u0011\t)\"a\u0006\u0002\t1\fgn\u001a\u0006\u0003\u00033\tAA[1wC&\u0019\u0011-a\u0005\u0002%\u0015t7m\u001c3fIN{'\u000f^\"pYVlg\u000eI\u0001\bi\u0006\u0014G.Z%e\u00035!\u0018M\u00197f\u0007N\u001c8\t\\1tg\u0006\t\u0002/Y4f'&TXMR8s[\u001aKW\r\u001c3\u0002'A\fw-\u001a(v[\n,'OR8s[\u001aKW\r\u001c3\u0002\u0011A\fw-\u001a'j].$2aWA\u0016\u0011\u0019\ti\u0003\u0007a\u0001o\u0006!\u0001/Y4f\u0003A9wNQ;ui>tgi\u001c:n!\u0006$\b.\u0001\u0006eCR\f7k\\;sG\u0016,\"!!\u000e\u0011\tM\n9dN\u0005\u0004\u0003s!$a\u0004)bO\u0016$G)\u0019;b'>,(oY3\u0002\u000f!,\u0017\rZ3sgV\u0011\u0011q\b\t\u0005\u0019R\u000b\t\u0005\u0005\u0003\u0002D\u0005%SBAA#\u0015\r\t9EL\u0001\u0004q6d\u0017\u0002BA&\u0003\u000b\u0012AAT8eK\u0006\u0019!o\\<\u0015\t\u0005}\u0012\u0011\u000b\u0005\u0007\u0003'b\u0002\u0019A\u001c\u0002\u000bE,XM]=")
public class StreamingQueryPagedTable
implements PagedTable<StructuredStreamingRow> {
    private final HttpServletRequest request;
    private final StreamingQueryTab parent;
    private final Seq<StreamingQueryUIData> data;
    private final String tableTag;
    private final boolean isActive;
    private final /* synthetic */ Tuple3 x$4;
    private final String sortColumn;
    private final boolean sortDesc;
    private final int pageSize;
    private final String parameterPath;
    private final String encodedSortColumn;

    public Seq<Node> table(int page) {
        return PagedTable.table$((PagedTable)this, (int)page);
    }

    public Seq<Node> pageNavigation(int page, int pageSize, int totalPages, String navigationId) {
        return PagedTable.pageNavigation$((PagedTable)this, (int)page, (int)pageSize, (int)totalPages, (String)navigationId);
    }

    public String pageNavigation$default$4() {
        return PagedTable.pageNavigation$default$4$((PagedTable)this);
    }

    public String getParameterOtherTable(HttpServletRequest request, String tableTag) {
        return PagedTable.getParameterOtherTable$((PagedTable)this, (HttpServletRequest)request, (String)tableTag);
    }

    public Tuple3<String, Object, Object> getTableParameters(HttpServletRequest request, String tableTag, String defaultSortColumn) {
        return PagedTable.getTableParameters$((PagedTable)this, (HttpServletRequest)request, (String)tableTag, (String)defaultSortColumn);
    }

    public void isSortColumnValid(Seq<Tuple3<String, Object, Option<String>>> headerInfo, String sortColumn) {
        PagedTable.isSortColumnValid$((PagedTable)this, headerInfo, (String)sortColumn);
    }

    public Seq<Node> headerRow(Seq<Tuple3<String, Object, Option<String>>> headerInfo, boolean desc, int pageSize, String sortColumn, String parameterPath, String tableTag, String headerId) {
        return PagedTable.headerRow$((PagedTable)this, headerInfo, (boolean)desc, (int)pageSize, (String)sortColumn, (String)parameterPath, (String)tableTag, (String)headerId);
    }

    private String sortColumn() {
        return this.sortColumn;
    }

    private boolean sortDesc() {
        return this.sortDesc;
    }

    private int pageSize() {
        return this.pageSize;
    }

    private String parameterPath() {
        return this.parameterPath;
    }

    private String encodedSortColumn() {
        return this.encodedSortColumn;
    }

    public String tableId() {
        return new StringBuilder(6).append(this.tableTag).append("-table").toString();
    }

    public String tableCssClass() {
        return "table table-bordered table-sm table-striped table-head-clickable table-cell-width-limited";
    }

    public String pageSizeFormField() {
        return new StringBuilder(9).append(this.tableTag).append(".pageSize").toString();
    }

    public String pageNumberFormField() {
        return new StringBuilder(5).append(this.tableTag).append(".page").toString();
    }

    public String pageLink(int page) {
        return new StringBuilder(19).append(this.parameterPath()).append("&").append(this.pageNumberFormField()).append("=").append(page).append("&").append(this.tableTag).append(".sort=").append(this.encodedSortColumn()).append("&").append(this.tableTag).append(".desc=").append(this.sortDesc()).append("&").append(this.pageSizeFormField()).append("=").append(this.pageSize()).append("#").append(this.tableTag).toString();
    }

    public String goButtonFormPath() {
        return new StringBuilder(15).append(this.parameterPath()).append("&").append(this.tableTag).append(".sort=").append(this.encodedSortColumn()).append("&").append(this.tableTag).append(".desc=").append(this.sortDesc()).append("#").append(this.tableTag).toString();
    }

    public PagedDataSource<StructuredStreamingRow> dataSource() {
        return new StreamingQueryDataSource(this.data, this.sortColumn(), this.sortDesc(), this.pageSize(), this.isActive);
    }

    public Seq<Node> headers() {
        Seq headerAndCss = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"Name", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$), new Tuple3((Object)"Status", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$), new Tuple3((Object)"ID", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$), new Tuple3((Object)"Run ID", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$), new Tuple3((Object)"Start Time", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$), new Tuple3((Object)"Duration", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$), new Tuple3((Object)"Avg Input /sec", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$), new Tuple3((Object)"Avg Process /sec", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$), new Tuple3((Object)"Latest Batch", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$)}))).$plus$plus((GenTraversableOnce)(!this.isActive ? Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"Error", (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)None$.MODULE$)})) : Nil$.MODULE$), Seq$.MODULE$.canBuildFrom());
        this.isSortColumnValid((Seq<Tuple3<String, Object, Option<String>>>)headerAndCss, this.sortColumn());
        return this.headerRow((Seq<Tuple3<String, Object, Option<String>>>)headerAndCss, this.sortDesc(), this.pageSize(), this.sortColumn(), this.parameterPath(), this.tableTag, this.tableTag);
    }

    public Seq<Node> row(StructuredStreamingRow query) {
        StreamingQueryUIData streamingQuery = query.streamingUIData();
        String statisticsLink = new StringOps(Predef$.MODULE$.augmentString("%s/%s/statistics?id=%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{org.apache.spark.ui.UIUtils$.MODULE$.prependBaseUri(this.request, this.parent.basePath(), org.apache.spark.ui.UIUtils$.MODULE$.prependBaseUri$default$3()), this.parent.prefix(), streamingQuery.summary().runId()}));
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)UIUtils$.MODULE$.getQueryName(streamingQuery));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)UIUtils$.MODULE$.getQueryStatus(streamingQuery));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)streamingQuery.summary().id());
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf5 = new NodeBuffer();
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("href", statisticsLink, (MetaData)$md);
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)streamingQuery.summary().runId());
        $buf5.$amp$plus((Object)new Elem(null, "a", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.formatDate(streamingQuery.summary().startTimestamp()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.formatDurationVerbose(query.duration()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf8));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)UIUtils$.MODULE$.withNoProgress(streamingQuery, (Function0 & Serializable & scala.Serializable)() -> Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)BoxesRunTime.boxToDouble((double)query.avgInput())), "%.2f"), "NaN"));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf9));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)UIUtils$.MODULE$.withNoProgress(streamingQuery, (Function0 & Serializable & scala.Serializable)() -> Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)BoxesRunTime.boxToDouble((double)query.avgProcess())), "%.2f"), "NaN"));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf10));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)UIUtils$.MODULE$.withNoProgress(streamingQuery, (JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> streamingQuery.lastProgress().batchId(), "NaN"));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf11));
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)this.details$1(streamingQuery.summary().exception().getOrElse((Function0 & Serializable & scala.Serializable)() -> "-")));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
    }

    private final Seq details$1(Object detail) {
        if (this.isActive) {
            return (Seq)Seq$.MODULE$.empty();
        }
        String detailString = (String)detail;
        boolean isMultiline = detailString.indexOf(10) >= 0;
        String summary = StringEscapeUtils.escapeHtml4((String)(isMultiline ? detailString.substring(0, detailString.indexOf(10)) : detailString));
        Seq details = org.apache.spark.ui.UIUtils$.MODULE$.detailsUINode(isMultiline, detailString);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)summary);
        $buf.$amp$plus((Object)details);
        return new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
    }

    public StreamingQueryPagedTable(HttpServletRequest request, StreamingQueryTab parent, Seq<StreamingQueryUIData> data, String tableTag, boolean isActive, String basePath, String subPath) {
        this.request = request;
        this.parent = parent;
        this.data = data;
        this.tableTag = tableTag;
        this.isActive = isActive;
        PagedTable.$init$((PagedTable)this);
        Tuple3<String, Object, Object> tuple3 = this.getTableParameters(request, tableTag, "Start Time");
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String sortColumn = (String)tuple3._1();
        boolean sortDesc = BoxesRunTime.unboxToBoolean((Object)tuple3._2());
        int pageSize = BoxesRunTime.unboxToInt((Object)tuple3._3());
        Tuple3 tuple32 = new Tuple3((Object)sortColumn, (Object)BoxesRunTime.boxToBoolean((boolean)sortDesc), (Object)BoxesRunTime.boxToInteger((int)pageSize));
        this.x$4 = tuple32;
        this.sortColumn = (String)this.x$4._1();
        this.sortDesc = BoxesRunTime.unboxToBoolean((Object)this.x$4._2());
        this.pageSize = BoxesRunTime.unboxToInt((Object)this.x$4._3());
        this.parameterPath = new StringBuilder(3).append(basePath).append("/").append(subPath).append("/?").append(this.getParameterOtherTable(request, tableTag)).toString();
        this.encodedSortColumn = URLEncoder.encode(this.sortColumn(), StandardCharsets.UTF_8.name());
    }
}

