/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.bucketing;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.physical.HashPartitioning;
import org.apache.spark.sql.catalyst.plans.physical.Partitioning;
import org.apache.spark.sql.execution.FileSourceScanExec;
import org.apache.spark.sql.execution.FilterExec;
import org.apache.spark.sql.execution.ProjectExec;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.joins.BaseJoinExec;
import org.apache.spark.sql.execution.joins.ShuffledHashJoinExec;
import org.apache.spark.sql.execution.joins.SortMergeJoinExec;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public final class ExtractJoinWithBuckets$ {
    public static ExtractJoinWithBuckets$ MODULE$;

    static {
        new ExtractJoinWithBuckets$();
    }

    private boolean hasScanOperation(SparkPlan plan) {
        SparkPlan sparkPlan;
        while (true) {
            if ((sparkPlan = plan) instanceof FilterExec) {
                FilterExec filterExec = (FilterExec)sparkPlan;
                plan = filterExec.child();
                continue;
            }
            if (!(sparkPlan instanceof ProjectExec)) break;
            ProjectExec projectExec = (ProjectExec)sparkPlan;
            plan = projectExec.child();
        }
        boolean bl = sparkPlan instanceof FileSourceScanExec;
        return bl;
    }

    private Option<BucketSpec> getBucketSpec(SparkPlan plan) {
        return plan.collectFirst((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                FileSourceScanExec fileSourceScanExec;
                A1 A1 = x1;
                Object object = A1 instanceof FileSourceScanExec && (fileSourceScanExec = (FileSourceScanExec)A1).relation().bucketSpec().nonEmpty() && fileSourceScanExec.optionalNumCoalescedBuckets().isEmpty() ? fileSourceScanExec.relation().bucketSpec().get() : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x1) {
                FileSourceScanExec fileSourceScanExec;
                SparkPlan sparkPlan = x1;
                boolean bl = sparkPlan instanceof FileSourceScanExec && (fileSourceScanExec = (FileSourceScanExec)sparkPlan).relation().bucketSpec().nonEmpty() && fileSourceScanExec.optionalNumCoalescedBuckets().isEmpty();
                return bl;
            }
        });
    }

    private boolean satisfiesOutputPartitioning(Seq<Expression> keys, Partitioning partitioning) {
        HashPartitioning hashPartitioning;
        Seq exprs;
        Partitioning partitioning2 = partitioning;
        boolean bl = partitioning2 instanceof HashPartitioning && (exprs = (hashPartitioning = (HashPartitioning)partitioning2).expressions()).length() == keys.length() ? exprs.forall((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)keys.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.semanticEquals(e))))) : false;
        return bl;
    }

    private boolean isApplicable(BaseJoinExec j) {
        return (j instanceof SortMergeJoinExec || j instanceof ShuffledHashJoinExec) && this.hasScanOperation(j.left()) && this.hasScanOperation(j.right()) && this.satisfiesOutputPartitioning(j.leftKeys(), j.left().outputPartitioning()) && this.satisfiesOutputPartitioning(j.rightKeys(), j.right().outputPartitioning());
    }

    private boolean isDivisible(int numBuckets1, int numBuckets2) {
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(package$.MODULE$.min(numBuckets1, numBuckets2), package$.MODULE$.max(numBuckets1, numBuckets2));
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        int small = sp2._1$mcI$sp();
        int large = sp2._2$mcI$sp();
        Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(small, large);
        Tuple2.mcII.sp sp4 = sp3;
        int small2 = sp4._1$mcI$sp();
        int large2 = sp4._2$mcI$sp();
        return numBuckets1 != numBuckets2 && large2 % small2 == 0;
    }

    public Option<Tuple3<BaseJoinExec, Object, Object>> unapply(SparkPlan plan) {
        None$ none$;
        BaseJoinExec baseJoinExec;
        SparkPlan sparkPlan = plan;
        if (sparkPlan instanceof BaseJoinExec && this.isApplicable(baseJoinExec = (BaseJoinExec)((Object)sparkPlan))) {
            Option<BucketSpec> leftBucket = this.getBucketSpec(baseJoinExec.left());
            Option<BucketSpec> rightBucket = this.getBucketSpec(baseJoinExec.right());
            none$ = leftBucket.isDefined() && rightBucket.isDefined() && this.isDivisible(((BucketSpec)leftBucket.get()).numBuckets(), ((BucketSpec)rightBucket.get()).numBuckets()) ? new Some((Object)new Tuple3((Object)baseJoinExec, (Object)BoxesRunTime.boxToInteger((int)((BucketSpec)leftBucket.get()).numBuckets()), (Object)BoxesRunTime.boxToInteger((int)((BucketSpec)rightBucket.get()).numBuckets()))) : None$.MODULE$;
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private ExtractJoinWithBuckets$() {
        MODULE$ = this;
    }
}

