/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.command.ShowTablesCommand$;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.util.PartitioningUtils$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005}h\u0001B\u0012%\u0001FB\u0001\"\u0013\u0001\u0003\u0016\u0004%\tA\u0013\u0005\t3\u0002\u0011\t\u0012)A\u0005\u0017\"A!\f\u0001BK\u0002\u0013\u0005!\n\u0003\u0005\\\u0001\tE\t\u0015!\u0003L\u0011!a\u0006A!f\u0001\n\u0003i\u0006\u0002C1\u0001\u0005#\u0005\u000b\u0011\u00020\t\u0011\t\u0004!Q3A\u0005\u0002\rD\u0001B\u001f\u0001\u0003\u0012\u0003\u0006I\u0001\u001a\u0005\u0006w\u0002!\t\u0001 \u0005\n\u0003\u000b\u0001!\u0019!C!\u0003\u000fA\u0001\"a\n\u0001A\u0003%\u0011\u0011\u0002\u0005\b\u0003S\u0001A\u0011IA\u0016\u0011%\t\t\u0005AA\u0001\n\u0003\t\u0019\u0005C\u0005\u0002N\u0001\t\n\u0011\"\u0001\u0002P!I\u0011Q\r\u0001\u0012\u0002\u0013\u0005\u0011q\n\u0005\n\u0003O\u0002\u0011\u0013!C\u0001\u0003SB\u0011\"!\u001c\u0001#\u0003%\t!a\u001c\t\u0013\u0005M\u0004!!A\u0005B\u0005U\u0004\"CAC\u0001\u0005\u0005I\u0011AAD\u0011%\ty\tAA\u0001\n\u0003\t\t\nC\u0005\u0002\u001e\u0002\t\t\u0011\"\u0011\u0002 \"I\u0011Q\u0016\u0001\u0002\u0002\u0013\u0005\u0011q\u0016\u0005\n\u0003g\u0003\u0011\u0011!C!\u0003k;\u0011\"!/%\u0003\u0003E\t!a/\u0007\u0011\r\"\u0013\u0011!E\u0001\u0003{Caa_\r\u0005\u0002\u0005-\u0007\"CAg3\u0005\u0005IQIAh\u0011%\t\t.GA\u0001\n\u0003\u000b\u0019\u000eC\u0005\u0002^f\t\n\u0011\"\u0001\u0002j!I\u0011q\\\r\u0012\u0002\u0013\u0005\u0011q\u000e\u0005\n\u0003CL\u0012\u0011!CA\u0003GD\u0011\"!=\u001a#\u0003%\t!!\u001b\t\u0013\u0005M\u0018$%A\u0005\u0002\u0005=\u0004\"CA{3\u0005\u0005I\u0011BA|\u0005E\u0019\u0006n\\<UC\ndWm]\"p[6\fg\u000e\u001a\u0006\u0003K\u0019\nqaY8n[\u0006tGM\u0003\u0002(Q\u0005IQ\r_3dkRLwN\u001c\u0006\u0003S)\n1a]9m\u0015\tYC&A\u0003ta\u0006\u00148N\u0003\u0002.]\u00051\u0011\r]1dQ\u0016T\u0011aL\u0001\u0004_J<7\u0001A\n\u0006\u0001Ib\u0004I\u0012\t\u0003gij\u0011\u0001\u000e\u0006\u0003kY\nq\u0001\\8hS\u000e\fGN\u0003\u00028q\u0005)\u0001\u000f\\1og*\u0011\u0011\bK\u0001\tG\u0006$\u0018\r\\=ti&\u00111\b\u000e\u0002\f\u0019><\u0017nY1m!2\fg\u000e\u0005\u0002>}5\tA%\u0003\u0002@I\ty!+\u001e8oC\ndWmQ8n[\u0006tG\r\u0005\u0002B\t6\t!IC\u0001D\u0003\u0015\u00198-\u00197b\u0013\t)%IA\u0004Qe>$Wo\u0019;\u0011\u0005\u0005;\u0015B\u0001%C\u00051\u0019VM]5bY&T\u0018M\u00197f\u00031!\u0017\r^1cCN,g*Y7f+\u0005Y\u0005cA!M\u001d&\u0011QJ\u0011\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005=3fB\u0001)U!\t\t&)D\u0001S\u0015\t\u0019\u0006'\u0001\u0004=e>|GOP\u0005\u0003+\n\u000ba\u0001\u0015:fI\u00164\u0017BA,Y\u0005\u0019\u0019FO]5oO*\u0011QKQ\u0001\u000eI\u0006$\u0018MY1tK:\u000bW.\u001a\u0011\u0002-Q\f'\r\\3JI\u0016tG/\u001b4jKJ\u0004\u0016\r\u001e;fe:\fq\u0003^1cY\u0016LE-\u001a8uS\u001aLWM\u001d)biR,'O\u001c\u0011\u0002\u0015%\u001cX\t\u001f;f]\u0012,G-F\u0001_!\t\tu,\u0003\u0002a\u0005\n9!i\\8mK\u0006t\u0017aC5t\u000bb$XM\u001c3fI\u0002\nQ\u0002]1si&$\u0018n\u001c8Ta\u0016\u001cW#\u00013\u0011\u0007\u0005cU\r\u0005\u0002go:\u0011q\r\u001e\b\u0003QJt!![9\u000f\u0005)\u0004hBA6p\u001d\tagN\u0004\u0002R[&\tq&\u0003\u0002.]%\u00111\u0006L\u0005\u0003S)J!!\u000f\u0015\n\u0005MD\u0014aB2bi\u0006dwnZ\u0005\u0003kZ\fAbQ1uC2|w\rV=qKNT!a\u001d\u001d\n\u0005aL(A\u0005+bE2,\u0007+\u0019:uSRLwN\\*qK\u000eT!!\u001e<\u0002\u001dA\f'\u000f^5uS>t7\u000b]3dA\u00051A(\u001b8jiz\"r! @\u0000\u0003\u0003\t\u0019\u0001\u0005\u0002>\u0001!)\u0011*\u0003a\u0001\u0017\")!,\u0003a\u0001\u0017\"9A,\u0003I\u0001\u0002\u0004q\u0006b\u00022\n!\u0003\u0005\r\u0001Z\u0001\u0007_V$\b/\u001e;\u0016\u0005\u0005%\u0001CBA\u0006\u0003+\tYB\u0004\u0003\u0002\u000e\u0005EabA)\u0002\u0010%\t1)C\u0002\u0002\u0014\t\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0018\u0005e!aA*fc*\u0019\u00111\u0003\"\u0011\t\u0005u\u00111E\u0007\u0003\u0003?Q1!!\t9\u0003-)\u0007\u0010\u001d:fgNLwN\\:\n\t\u0005\u0015\u0012q\u0004\u0002\n\u0003R$(/\u001b2vi\u0016\fqa\\;uaV$\b%A\u0002sk:$B!!\f\u00028A1\u00111BA\u000b\u0003_\u0001B!!\r\u000245\t\u0001&C\u0002\u00026!\u00121AU8x\u0011\u001d\tI\u0004\u0004a\u0001\u0003w\tAb\u001d9be.\u001cVm]:j_:\u0004B!!\r\u0002>%\u0019\u0011q\b\u0015\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0002\t\r|\u0007/\u001f\u000b\n{\u0006\u0015\u0013qIA%\u0003\u0017Bq!S\u0007\u0011\u0002\u0003\u00071\nC\u0004[\u001bA\u0005\t\u0019A&\t\u000fqk\u0001\u0013!a\u0001=\"9!-\u0004I\u0001\u0002\u0004!\u0017AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003#R3aSA*W\t\t)\u0006\u0005\u0003\u0002X\u0005\u0005TBAA-\u0015\u0011\tY&!\u0018\u0002\u0013Ut7\r[3dW\u0016$'bAA0\u0005\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\r\u0014\u0011\f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\tYGK\u0002_\u0003'\nabY8qs\u0012\"WMZ1vYR$C'\u0006\u0002\u0002r)\u001aA-a\u0015\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t9\b\u0005\u0003\u0002z\u0005\rUBAA>\u0015\u0011\ti(a \u0002\t1\fgn\u001a\u0006\u0003\u0003\u0003\u000bAA[1wC&\u0019q+a\u001f\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005%\u0005cA!\u0002\f&\u0019\u0011Q\u0012\"\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005M\u0015\u0011\u0014\t\u0004\u0003\u0006U\u0015bAAL\u0005\n\u0019\u0011I\\=\t\u0013\u0005mE#!AA\u0002\u0005%\u0015a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\"B1\u00111UAU\u0003'k!!!*\u000b\u0007\u0005\u001d&)\u0001\u0006d_2dWm\u0019;j_:LA!a+\u0002&\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\rq\u0016\u0011\u0017\u0005\n\u000373\u0012\u0011!a\u0001\u0003'\u000ba!Z9vC2\u001cHc\u00010\u00028\"I\u00111T\f\u0002\u0002\u0003\u0007\u00111S\u0001\u0012'\"|w\u000fV1cY\u0016\u001c8i\\7nC:$\u0007CA\u001f\u001a'\u0011I\u0012q\u0018$\u0011\u0013\u0005\u0005\u0017qY&L=\u0012lXBAAb\u0015\r\t)MQ\u0001\beVtG/[7f\u0013\u0011\tI-a1\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>tG\u0007\u0006\u0002\u0002<\u0006AAo\\*ue&tw\r\u0006\u0002\u0002x\u0005)\u0011\r\u001d9msRIQ0!6\u0002X\u0006e\u00171\u001c\u0005\u0006\u0013r\u0001\ra\u0013\u0005\u00065r\u0001\ra\u0013\u0005\b9r\u0001\n\u00111\u0001_\u0011\u001d\u0011G\u0004%AA\u0002\u0011\fq\"\u00199qYf$C-\u001a4bk2$HeM\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%i\u00059QO\\1qa2LH\u0003BAs\u0003[\u0004B!\u0011'\u0002hB9\u0011)!;L\u0017z#\u0017bAAv\u0005\n1A+\u001e9mKRB\u0001\"a< \u0003\u0003\u0005\r!`\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002zB!\u0011\u0011PA~\u0013\u0011\ti0a\u001f\u0003\r=\u0013'.Z2u\u0001")
public class ShowTablesCommand
extends LogicalPlan
implements RunnableCommand,
scala.Serializable {
    private final Option<String> databaseName;
    private final Option<String> tableIdentifierPattern;
    private final boolean isExtended;
    private final Option<Map<String, String>> partitionSpec;
    private final Seq<Attribute> output;
    private Map<String, SQLMetric> metrics;
    private volatile boolean bitmap$0;

    public static Option<Map<String, String>> $lessinit$greater$default$4() {
        return ShowTablesCommand$.MODULE$.$lessinit$greater$default$4();
    }

    public static boolean $lessinit$greater$default$3() {
        return ShowTablesCommand$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple4<Option<String>, Option<String>, Object, Option<Map<String, String>>>> unapply(ShowTablesCommand showTablesCommand) {
        return ShowTablesCommand$.MODULE$.unapply(showTablesCommand);
    }

    public static Option<Map<String, String>> apply$default$4() {
        return ShowTablesCommand$.MODULE$.apply$default$4();
    }

    public static boolean apply$default$3() {
        return ShowTablesCommand$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple4<Option<String>, Option<String>, Object, Option<Map<String, String>>>, ShowTablesCommand> tupled() {
        return ShowTablesCommand$.MODULE$.tupled();
    }

    public static Function1<Option<String>, Function1<Option<String>, Function1<Object, Function1<Option<Map<String, String>>, ShowTablesCommand>>>> curried() {
        return ShowTablesCommand$.MODULE$.curried();
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Seq<LogicalPlan> children() {
        return Command.children$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        ShowTablesCommand showTablesCommand = this;
        synchronized (showTablesCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public Option<String> databaseName() {
        return this.databaseName;
    }

    public Option<String> tableIdentifierPattern() {
        return this.tableIdentifierPattern;
    }

    public boolean isExtended() {
        return this.isExtended;
    }

    public Option<Map<String, String>> partitionSpec() {
        return this.partitionSpec;
    }

    public Seq<Attribute> output() {
        return this.output;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        Seq seq;
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        String db = (String)this.databaseName().getOrElse((Function0 & Serializable & scala.Serializable)() -> catalog.getCurrentDatabase());
        if (this.partitionSpec().isEmpty()) {
            Seq tables = (Seq)this.tableIdentifierPattern().map((Function1 & Serializable & scala.Serializable)x$25 -> catalog.listTables(db, x$25)).getOrElse((Function0 & Serializable & scala.Serializable)() -> catalog.listTables(db));
            seq = (Seq)tables.map((Function1 & Serializable & scala.Serializable)tableIdent -> {
                Row row;
                String database = (String)tableIdent.database().getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
                String tableName = tableIdent.table();
                boolean isTemp = catalog.isTemporaryTable(tableIdent);
                if (this.isExtended()) {
                    String information = catalog.getTempViewOrPermanentTableMetadata(tableIdent).simpleString();
                    row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{database, tableName, BoxesRunTime.boxToBoolean((boolean)isTemp), new StringBuilder(1).append(information).append("\n").toString()}));
                } else {
                    row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{database, tableName, BoxesRunTime.boxToBoolean((boolean)isTemp)}));
                }
                return row;
            }, Seq$.MODULE$.canBuildFrom());
        } else {
            CatalogTable table = catalog.getTableMetadata(new TableIdentifier((String)this.tableIdentifierPattern().get(), (Option)new Some((Object)db)));
            DDLUtils$.MODULE$.verifyPartitionProviderIsHive(sparkSession, table, "SHOW TABLE EXTENDED");
            TableIdentifier tableIdent2 = table.identifier();
            Map normalizedSpec = PartitioningUtils$.MODULE$.normalizePartitionSpec((Map)this.partitionSpec().get(), table.partitionSchema(), tableIdent2.quotedString(), sparkSession.sessionState().conf().resolver());
            CatalogTablePartition partition = catalog.getPartition(tableIdent2, normalizedSpec);
            String database = (String)tableIdent2.database().getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
            String tableName = tableIdent2.table();
            boolean isTemp = catalog.isTemporaryTable(tableIdent2);
            String information = partition.simpleString();
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{database, tableName, BoxesRunTime.boxToBoolean((boolean)isTemp), new StringBuilder(1).append(information).append("\n").toString()}))}));
        }
        return seq;
    }

    public ShowTablesCommand copy(Option<String> databaseName, Option<String> tableIdentifierPattern, boolean isExtended, Option<Map<String, String>> partitionSpec) {
        return new ShowTablesCommand(databaseName, tableIdentifierPattern, isExtended, partitionSpec);
    }

    public Option<String> copy$default$1() {
        return this.databaseName();
    }

    public Option<String> copy$default$2() {
        return this.tableIdentifierPattern();
    }

    public boolean copy$default$3() {
        return this.isExtended();
    }

    public Option<Map<String, String>> copy$default$4() {
        return this.partitionSpec();
    }

    public String productPrefix() {
        return "ShowTablesCommand";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.databaseName();
                break;
            }
            case 1: {
                object = this.tableIdentifierPattern();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.isExtended());
                break;
            }
            case 3: {
                object = this.partitionSpec();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ShowTablesCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ShowTablesCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        ShowTablesCommand showTablesCommand = (ShowTablesCommand)x$1;
        Option<String> option = this.databaseName();
        Option<String> option2 = showTablesCommand.databaseName();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<String> option3 = this.tableIdentifierPattern();
        Option<String> option4 = showTablesCommand.tableIdentifierPattern();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        if (this.isExtended() != showTablesCommand.isExtended()) return false;
        Option<Map<String, String>> option5 = this.partitionSpec();
        Option<Map<String, String>> option6 = showTablesCommand.partitionSpec();
        if (option5 == null) {
            if (option6 != null) {
                return false;
            }
        } else if (!option5.equals(option6)) return false;
        if (!showTablesCommand.canEqual(this)) return false;
        return true;
    }

    public ShowTablesCommand(Option<String> databaseName, Option<String> tableIdentifierPattern, boolean isExtended, Option<Map<String, String>> partitionSpec) {
        Nil$ nil$;
        this.databaseName = databaseName;
        this.tableIdentifierPattern = tableIdentifierPattern;
        this.isExtended = isExtended;
        this.partitionSpec = partitionSpec;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
        if (isExtended) {
            String x$1 = "information";
            StringType$ x$2 = StringType$.MODULE$;
            boolean x$3 = false;
            Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, (DataType)x$2, x$3, x$4);
            Seq x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, (DataType)x$2, x$3, x$4);
            AttributeReference attributeReference = new AttributeReference(x$1, (DataType)x$2, x$3, x$4, x$5, x$6);
            nil$ = Nil$.MODULE$.$colon$colon((Object)attributeReference);
        } else {
            nil$ = Nil$.MODULE$;
        }
        Nil$ tableExtendedInfo = nil$;
        String x$7 = "database";
        StringType$ x$8 = StringType$.MODULE$;
        boolean x$9 = false;
        Metadata x$10 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$11 = AttributeReference$.MODULE$.apply$default$5(x$7, (DataType)x$8, x$9, x$10);
        Seq x$12 = AttributeReference$.MODULE$.apply$default$6(x$7, (DataType)x$8, x$9, x$10);
        AttributeReference attributeReference = new AttributeReference(x$7, (DataType)x$8, x$9, x$10, x$11, x$12);
        String x$13 = "tableName";
        StringType$ x$14 = StringType$.MODULE$;
        boolean x$15 = false;
        Metadata x$16 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$17 = AttributeReference$.MODULE$.apply$default$5(x$13, (DataType)x$14, x$15, x$16);
        Seq x$18 = AttributeReference$.MODULE$.apply$default$6(x$13, (DataType)x$14, x$15, x$16);
        AttributeReference attributeReference2 = new AttributeReference(x$13, (DataType)x$14, x$15, x$16, x$17, x$18);
        String x$19 = "isTemporary";
        BooleanType$ x$20 = BooleanType$.MODULE$;
        boolean x$21 = false;
        Metadata x$22 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$23 = AttributeReference$.MODULE$.apply$default$5(x$19, (DataType)x$20, x$21, x$22);
        Seq x$24 = AttributeReference$.MODULE$.apply$default$6(x$19, (DataType)x$20, x$21, x$22);
        AttributeReference attributeReference3 = new AttributeReference(x$19, (DataType)x$20, x$21, x$22, x$23, x$24);
        this.output = tableExtendedInfo.$colon$colon((Object)attributeReference3).$colon$colon((Object)attributeReference2).$colon$colon((Object)attributeReference);
    }
}

