/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import java.net.URI;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.NoSuchPartitionException;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.command.TruncateTableCommand$;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.util.PartitioningUtils$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.math.BigInt$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005eg\u0001\u0002\r\u001a\u0001\u001aB\u0001B\u0010\u0001\u0003\u0016\u0004%\ta\u0010\u0005\t\t\u0002\u0011\t\u0012)A\u0005\u0001\"AQ\t\u0001BK\u0002\u0013\u0005a\t\u0003\u0005c\u0001\tE\t\u0015!\u0003H\u0011\u0015\u0019\u0007\u0001\"\u0001e\u0011\u0015A\u0007\u0001\"\u0011j\u0011\u0015Y\b\u0001\"\u0003}\u0011%\tY\u0003AA\u0001\n\u0003\ti\u0003C\u0005\u00024\u0001\t\n\u0011\"\u0001\u00026!I\u00111\n\u0001\u0012\u0002\u0013\u0005\u0011Q\n\u0005\n\u0003#\u0002\u0011\u0011!C!\u0003'B\u0011\"!\u001a\u0001\u0003\u0003%\t!a\u001a\t\u0013\u0005=\u0004!!A\u0005\u0002\u0005E\u0004\"CA?\u0001\u0005\u0005I\u0011IA@\u0011%\ti\tAA\u0001\n\u0003\ty\tC\u0005\u0002\u001a\u0002\t\t\u0011\"\u0011\u0002\u001c\u001eI\u0011qT\r\u0002\u0002#\u0005\u0011\u0011\u0015\u0004\t1e\t\t\u0011#\u0001\u0002$\"11M\u0005C\u0001\u0003cC\u0011\"a-\u0013\u0003\u0003%)%!.\t\u0013\u0005]&#!A\u0005\u0002\u0006e\u0006\"CA`%\u0005\u0005I\u0011QAa\u0011%\tyMEA\u0001\n\u0013\t\tN\u0001\u000bUeVt7-\u0019;f)\u0006\u0014G.Z\"p[6\fg\u000e\u001a\u0006\u00035m\tqaY8n[\u0006tGM\u0003\u0002\u001d;\u0005IQ\r_3dkRLwN\u001c\u0006\u0003=}\t1a]9m\u0015\t\u0001\u0013%A\u0003ta\u0006\u00148N\u0003\u0002#G\u00051\u0011\r]1dQ\u0016T\u0011\u0001J\u0001\u0004_J<7\u0001A\n\u0006\u0001\u001d\nTg\u000f\t\u0003Q=j\u0011!\u000b\u0006\u0003U-\nq\u0001\\8hS\u000e\fGN\u0003\u0002-[\u0005)\u0001\u000f\\1og*\u0011a&H\u0001\tG\u0006$\u0018\r\\=ti&\u0011\u0001'\u000b\u0002\f\u0019><\u0017nY1m!2\fg\u000e\u0005\u00023g5\t\u0011$\u0003\u000253\ty!+\u001e8oC\ndWmQ8n[\u0006tG\r\u0005\u00027s5\tqGC\u00019\u0003\u0015\u00198-\u00197b\u0013\tQtGA\u0004Qe>$Wo\u0019;\u0011\u0005Yb\u0014BA\u001f8\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003%!\u0018M\u00197f\u001d\u0006lW-F\u0001A!\t\t%)D\u0001.\u0013\t\u0019UFA\bUC\ndW-\u00133f]RLg-[3s\u0003)!\u0018M\u00197f\u001d\u0006lW\rI\u0001\u000ea\u0006\u0014H/\u001b;j_:\u001c\u0006/Z2\u0016\u0003\u001d\u00032A\u000e%K\u0013\tIuG\u0001\u0004PaRLwN\u001c\t\u0003\u0017~s!\u0001\u0014/\u000f\u00055SfB\u0001(Z\u001d\ty\u0005L\u0004\u0002Q/:\u0011\u0011K\u0016\b\u0003%Vk\u0011a\u0015\u0006\u0003)\u0016\na\u0001\u0010:p_Rt\u0014\"\u0001\u0013\n\u0005\t\u001a\u0013B\u0001\u0011\"\u0013\tqr$\u0003\u0002/;%\u00111,L\u0001\bG\u0006$\u0018\r\\8h\u0013\tif,\u0001\u0007DCR\fGn\\4UsB,7O\u0003\u0002\\[%\u0011\u0001-\u0019\u0002\u0013)\u0006\u0014G.\u001a)beRLG/[8o'B,7M\u0003\u0002^=\u0006q\u0001/\u0019:uSRLwN\\*qK\u000e\u0004\u0013A\u0002\u001fj]&$h\bF\u0002fM\u001e\u0004\"A\r\u0001\t\u000by*\u0001\u0019\u0001!\t\u000b\u0015+\u0001\u0019A$\u0002\u0007I,h\u000e\u0006\u0002koB\u00191\u000e]:\u000f\u00051tgB\u0001*n\u0013\u0005A\u0014BA88\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u001d:\u0003\u0007M+\u0017O\u0003\u0002poA\u0011A/^\u0007\u0002;%\u0011a/\b\u0002\u0004%><\b\"\u0002\u0011\u0007\u0001\u0004A\bC\u0001;z\u0013\tQXD\u0001\u0007Ta\u0006\u00148nU3tg&|g.A\u0006oK^\f5\r\\#oiJLHcB?\u0002\u0010\u0005e\u00111\u0005\t\u0004}\u0006-Q\"A@\u000b\t\u0005\u0005\u00111A\u0001\u000ba\u0016\u0014X.[:tS>t'\u0002BA\u0003\u0003\u000f\t!AZ:\u000b\u0007\u0005%\u0011%\u0001\u0004iC\u0012|w\u000e]\u0005\u0004\u0003\u001by(\u0001C!dY\u0016sGO]=\t\u000f\u0005Eq\u00011\u0001\u0002\u0014\u0005)1oY8qKB\u0019a0!\u0006\n\u0007\u0005]qPA\u0007BG2,e\u000e\u001e:z'\u000e|\u0007/\u001a\u0005\b\u000379\u0001\u0019AA\u000f\u0003\u001d\t7\r\u001c+za\u0016\u00042A`A\u0010\u0013\r\t\tc \u0002\r\u0003\u000edWI\u001c;ssRK\b/\u001a\u0005\b\u0003\u00039\u0001\u0019AA\u0013!\rq\u0018qE\u0005\u0004\u0003Sy(\u0001\u0003$t\u0003\u000e$\u0018n\u001c8\u0002\t\r|\u0007/\u001f\u000b\u0006K\u0006=\u0012\u0011\u0007\u0005\b}!\u0001\n\u00111\u0001A\u0011\u001d)\u0005\u0002%AA\u0002\u001d\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u00028)\u001a\u0001)!\u000f,\u0005\u0005m\u0002\u0003BA\u001f\u0003\u000fj!!a\u0010\u000b\t\u0005\u0005\u00131I\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u00128\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0013\nyDA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002P)\u001aq)!\u000f\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t)\u0006\u0005\u0003\u0002X\u0005\u0005TBAA-\u0015\u0011\tY&!\u0018\u0002\t1\fgn\u001a\u0006\u0003\u0003?\nAA[1wC&!\u00111MA-\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011\u000e\t\u0004m\u0005-\u0014bAA7o\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111OA=!\r1\u0014QO\u0005\u0004\u0003o:$aA!os\"I\u00111P\u0007\u0002\u0002\u0003\u0007\u0011\u0011N\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\u0005\u0005CBAB\u0003\u0013\u000b\u0019(\u0004\u0002\u0002\u0006*\u0019\u0011qQ\u001c\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\f\u0006\u0015%\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!%\u0002\u0018B\u0019a'a%\n\u0007\u0005UuGA\u0004C_>dW-\u00198\t\u0013\u0005mt\"!AA\u0002\u0005M\u0014AB3rk\u0006d7\u000f\u0006\u0003\u0002\u0012\u0006u\u0005\"CA>!\u0005\u0005\t\u0019AA:\u0003Q!&/\u001e8dCR,G+\u00192mK\u000e{W.\\1oIB\u0011!GE\n\u0005%\u0005\u00156\bE\u0004\u0002(\u00065\u0006iR3\u000e\u0005\u0005%&bAAVo\u00059!/\u001e8uS6,\u0017\u0002BAX\u0003S\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83)\t\t\t+\u0001\u0005u_N#(/\u001b8h)\t\t)&A\u0003baBd\u0017\u0010F\u0003f\u0003w\u000bi\fC\u0003?+\u0001\u0007\u0001\tC\u0003F+\u0001\u0007q)A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005\r\u00171\u001a\t\u0005m!\u000b)\rE\u00037\u0003\u000f\u0004u)C\u0002\u0002J^\u0012a\u0001V;qY\u0016\u0014\u0004\u0002CAg-\u0005\u0005\t\u0019A3\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GCAAj!\u0011\t9&!6\n\t\u0005]\u0017\u0011\f\u0002\u0007\u001f\nTWm\u0019;")
public class TruncateTableCommand
extends LogicalPlan
implements RunnableCommand,
scala.Serializable {
    private final TableIdentifier tableName;
    private final Option<Map<String, String>> partitionSpec;
    private Map<String, SQLMetric> metrics;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<TableIdentifier, Option<Map<String, String>>>> unapply(TruncateTableCommand truncateTableCommand) {
        return TruncateTableCommand$.MODULE$.unapply(truncateTableCommand);
    }

    public static Function1<Tuple2<TableIdentifier, Option<Map<String, String>>>, TruncateTableCommand> tupled() {
        return TruncateTableCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Option<Map<String, String>>, TruncateTableCommand>> curried() {
        return TruncateTableCommand$.MODULE$.curried();
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Seq<LogicalPlan> children() {
        return Command.children$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        TruncateTableCommand truncateTableCommand = this;
        synchronized (truncateTableCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public TableIdentifier tableName() {
        return this.tableName;
    }

    public Option<Map<String, String>> partitionSpec() {
        return this.partitionSpec;
    }

    @Override
    public Seq<Row> run(SparkSession spark) {
        block9: {
            Seq seq;
            Seq partCols;
            SessionCatalog catalog = spark.sessionState().catalog();
            CatalogTable table = catalog.getTableMetadata(this.tableName());
            String tableIdentWithDB = table.identifier().quotedString();
            CatalogTableType catalogTableType = table.tableType();
            CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.EXTERNAL();
            if (!(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null)) {
                throw new AnalysisException(new StringBuilder(58).append("Operation not allowed: TRUNCATE TABLE on external tables: ").append(tableIdentWithDB).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            CatalogTableType catalogTableType3 = table.tableType();
            CatalogTableType catalogTableType4 = CatalogTableType$.MODULE$.VIEW();
            if (!(catalogTableType3 != null ? !catalogTableType3.equals(catalogTableType4) : catalogTableType4 != null)) {
                throw new AnalysisException(new StringBuilder(48).append("Operation not allowed: TRUNCATE TABLE on views: ").append(tableIdentWithDB).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            if (table.partitionColumnNames().isEmpty() && this.partitionSpec().isDefined()) {
                throw new AnalysisException(new StringBuilder(106).append("Operation not allowed: TRUNCATE TABLE ... PARTITION is not supported ").append("for tables that are not partitioned: ").append(tableIdentWithDB).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            if (this.partitionSpec().isDefined()) {
                DDLUtils$.MODULE$.verifyPartitionProviderIsHive(spark, table, "TRUNCATE TABLE ... PARTITION");
            }
            if ((partCols = table.partitionColumnNames()).isEmpty()) {
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{table.storage().locationUri()}));
            } else {
                Option normalizedSpec = this.partitionSpec().map((Function1 & Serializable & scala.Serializable)spec -> PartitioningUtils$.MODULE$.normalizePartitionSpec(spec, table.partitionSchema(), table.identifier().quotedString(), spark.sessionState().conf().resolver()));
                Seq partLocations = (Seq)catalog.listPartitions(table.identifier(), normalizedSpec).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.storage().locationUri(), Seq$.MODULE$.canBuildFrom());
                this.partitionSpec().withFilter((Function1 & Serializable & scala.Serializable)spec -> BoxesRunTime.boxToBoolean((boolean)TruncateTableCommand.$anonfun$run$8(partLocations, partCols, spec))).foreach((Function1 & Serializable & scala.Serializable)spec -> {
                    throw new NoSuchPartitionException(table.database(), table.identifier().table(), spec);
                });
                seq = partLocations;
            }
            Seq locations = seq;
            Configuration hadoopConf = spark.sessionState().newHadoopConf();
            boolean ignorePermissionAcl = SQLConf$.MODULE$.get().truncateTableIgnorePermissionAcl();
            locations.foreach((Function1 & Serializable & scala.Serializable)location -> {
                TruncateTableCommand.$anonfun$run$10(this, hadoopConf, ignorePermissionAcl, tableIdentWithDB, location);
                return BoxedUnit.UNIT;
            });
            spark.sessionState().refreshTable(this.tableName().unquotedString());
            try {
                spark.sharedState().cacheManager().uncacheQuery(spark.table(table.identifier()), true);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    this.log().warn(new StringBuilder(43).append("Exception when attempting to uncache table ").append(tableIdentWithDB).toString(), e);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                throw throwable;
            }
            if (!table.stats().nonEmpty()) break block9;
            CatalogStatistics newStats = new CatalogStatistics(BigInt$.MODULE$.int2bigInt(0), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), CatalogStatistics$.MODULE$.apply$default$3());
            catalog.alterTableStats(this.tableName(), (Option)new Some((Object)newStats));
        }
        return (Seq)Seq$.MODULE$.empty();
    }

    private AclEntry newAclEntry(AclEntryScope scope, AclEntryType aclType, FsAction permission) {
        return new AclEntry.Builder().setScope(scope).setType(aclType).setPermission(permission).build();
    }

    public TruncateTableCommand copy(TableIdentifier tableName, Option<Map<String, String>> partitionSpec) {
        return new TruncateTableCommand(tableName, partitionSpec);
    }

    public TableIdentifier copy$default$1() {
        return this.tableName();
    }

    public Option<Map<String, String>> copy$default$2() {
        return this.partitionSpec();
    }

    public String productPrefix() {
        return "TruncateTableCommand";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Option<Map<String, String>> option;
        int n = x$1;
        switch (n) {
            case 0: {
                option = this.tableName();
                break;
            }
            case 1: {
                option = this.partitionSpec();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return option;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TruncateTableCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TruncateTableCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        TruncateTableCommand truncateTableCommand = (TruncateTableCommand)x$1;
        TableIdentifier tableIdentifier = this.tableName();
        TableIdentifier tableIdentifier2 = truncateTableCommand.tableName();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        Option<Map<String, String>> option = this.partitionSpec();
        Option<Map<String, String>> option2 = truncateTableCommand.partitionSpec();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!truncateTableCommand.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$run$8(Seq partLocations$1, Seq partCols$1, Map spec) {
        return partLocations$1.isEmpty() && spec.size() == partCols$1.length();
    }

    public static final /* synthetic */ void $anonfun$run$11(FileSystem fs$1, Path path$1, FsPermission permission) {
        try {
            fs$1.setPermission(path$1, permission);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                throw new SecurityException(new StringBuilder(74).append("Failed to set original permission ").append(permission).append(" back to ").append("the created path: ").append(path$1).append(". Exception: ").append(e.getMessage()).toString());
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ boolean $anonfun$run$13(AclEntry x$5) {
        return x$5.getName() != null;
    }

    public static final /* synthetic */ boolean $anonfun$run$14(TruncateTableCommand $this, List aclEntries$1, FsPermission permission) {
        aclEntries$1.add($this.newAclEntry(AclEntryScope.ACCESS, AclEntryType.USER, permission.getUserAction()));
        aclEntries$1.add($this.newAclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, permission.getGroupAction()));
        return aclEntries$1.add($this.newAclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, permission.getOtherAction()));
    }

    public static final /* synthetic */ void $anonfun$run$12(TruncateTableCommand $this, ObjectRef optPermission$1, FileSystem fs$1, Path path$1, List acls) {
        List aclEntries = (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(acls).asScala()).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TruncateTableCommand.$anonfun$run$13(x$5)))).asJava();
        ((Option)optPermission$1.elem).map((Function1 & Serializable & scala.Serializable)permission -> BoxesRunTime.boxToBoolean((boolean)TruncateTableCommand.$anonfun$run$14($this, aclEntries, permission)));
        try {
            fs$1.setAcl(path$1, aclEntries);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                throw new SecurityException(new StringBuilder(67).append("Failed to set original ACL ").append(aclEntries).append(" back to ").append("the created path: ").append(path$1).append(". Exception: ").append(e.getMessage()).toString());
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ void $anonfun$run$10(TruncateTableCommand $this, Configuration hadoopConf$1, boolean ignorePermissionAcl$1, String tableIdentWithDB$1, Option location) {
        if (location.isDefined()) {
            Path path = new Path((URI)location.get());
            try {
                FileSystem fs = path.getFileSystem(hadoopConf$1);
                ObjectRef optPermission = ObjectRef.create((Object)None$.MODULE$);
                None$ optAcls = None$.MODULE$;
                if (!ignorePermissionAcl$1) {
                    try {
                        FileStatus fileStatus = fs.getFileStatus(path);
                        optPermission.elem = new Some((Object)fileStatus.getPermission());
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                        if (!option.isEmpty()) {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        throw throwable;
                    }
                    try {
                        optAcls = new Some((Object)fs.getAclStatus(path).getEntries());
                    }
                    catch (Throwable throwable) {
                        Throwable throwable3 = throwable;
                        Option option = NonFatal$.MODULE$.unapply(throwable3);
                        if (!option.isEmpty()) {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        throw throwable;
                    }
                }
                fs.delete(path, true);
                fs.mkdirs(path);
                if (!ignorePermissionAcl$1) {
                    ((Option)optPermission.elem).foreach((Function1 & Serializable & scala.Serializable)permission -> {
                        TruncateTableCommand.$anonfun$run$11(fs, path, permission);
                        return BoxedUnit.UNIT;
                    });
                    optAcls.foreach((Function1 & Serializable & scala.Serializable)acls -> {
                        TruncateTableCommand.$anonfun$run$12($this, optPermission, fs, path, acls);
                        return BoxedUnit.UNIT;
                    });
                }
            }
            catch (Throwable throwable) {
                Throwable throwable4 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable4);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    throw new AnalysisException(new StringBuilder(70).append("Failed to truncate table ").append(tableIdentWithDB$1).append(" when removing data of the path: ").append(path).append(" ").append("because of ").append(e.toString()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
                throw throwable;
            }
        }
    }

    public TruncateTableCommand(TableIdentifier tableName, Option<Map<String, String>> partitionSpec) {
        this.tableName = tableName;
        this.partitionSpec = partitionSpec;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
    }
}

