/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.execution.CacheManager;
import org.apache.spark.sql.execution.command.AnalyzeTableCommand$;
import org.apache.spark.sql.execution.command.CommandUtils$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.internal.SessionState;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.math.BigInt;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001B\r\u001b\u0001\u001eB\u0001b\u0010\u0001\u0003\u0016\u0004%\t\u0001\u0011\u0005\t\u000b\u0002\u0011\t\u0012)A\u0005\u0003\"Aa\t\u0001BK\u0002\u0013\u0005q\t\u0003\u0005L\u0001\tE\t\u0015!\u0003I\u0011\u0015a\u0005\u0001\"\u0001N\u0011\u0015\t\u0006\u0001\"\u0011S\u0011\u001dA\u0007!!A\u0005\u0002%Dq\u0001\u001c\u0001\u0012\u0002\u0013\u0005Q\u000eC\u0004y\u0001E\u0005I\u0011A=\t\u000fm\u0004\u0011\u0011!C!y\"I\u00111\u0002\u0001\u0002\u0002\u0013\u0005\u0011Q\u0002\u0005\n\u0003+\u0001\u0011\u0011!C\u0001\u0003/A\u0011\"a\t\u0001\u0003\u0003%\t%!\n\t\u0013\u0005M\u0002!!A\u0005\u0002\u0005U\u0002\"CA\u001d\u0001\u0005\u0005I\u0011IA\u001e\u000f%\tyDGA\u0001\u0012\u0003\t\tE\u0002\u0005\u001a5\u0005\u0005\t\u0012AA\"\u0011\u0019a\u0015\u0003\"\u0001\u0002R!I\u00111K\t\u0002\u0002\u0013\u0015\u0013Q\u000b\u0005\n\u0003/\n\u0012\u0011!CA\u00033B\u0001\"a\u0018\u0012#\u0003%\t!\u001f\u0005\n\u0003C\n\u0012\u0011!CA\u0003GB\u0001\"!\u001e\u0012#\u0003%\t!\u001f\u0005\n\u0003o\n\u0012\u0011!C\u0005\u0003s\u00121#\u00118bYfTX\rV1cY\u0016\u001cu.\\7b]\u0012T!a\u0007\u000f\u0002\u000f\r|W.\\1oI*\u0011QDH\u0001\nKb,7-\u001e;j_:T!a\b\u0011\u0002\u0007M\fHN\u0003\u0002\"E\u0005)1\u000f]1sW*\u00111\u0005J\u0001\u0007CB\f7\r[3\u000b\u0003\u0015\n1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\u00153mq\u0002\"!\u000b\u0019\u000e\u0003)R!a\u000b\u0017\u0002\u000f1|w-[2bY*\u0011QFL\u0001\u0006a2\fgn\u001d\u0006\u0003_y\t\u0001bY1uC2L8\u000f^\u0005\u0003c)\u00121\u0002T8hS\u000e\fG\u000e\u00157b]B\u00111\u0007N\u0007\u00025%\u0011QG\u0007\u0002\u0010%Vtg.\u00192mK\u000e{W.\\1oIB\u0011qGO\u0007\u0002q)\t\u0011(A\u0003tG\u0006d\u0017-\u0003\u0002<q\t9\u0001K]8ek\u000e$\bCA\u001c>\u0013\tq\u0004H\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0006uC\ndW-\u00133f]R,\u0012!\u0011\t\u0003\u0005\u000ek\u0011AL\u0005\u0003\t:\u0012q\u0002V1cY\u0016LE-\u001a8uS\u001aLWM]\u0001\fi\u0006\u0014G.Z%eK:$\b%\u0001\u0004o_N\u001c\u0017M\\\u000b\u0002\u0011B\u0011q'S\u0005\u0003\u0015b\u0012qAQ8pY\u0016\fg.A\u0004o_N\u001c\u0017M\u001c\u0011\u0002\rqJg.\u001b;?)\rqu\n\u0015\t\u0003g\u0001AQaP\u0003A\u0002\u0005CqAR\u0003\u0011\u0002\u0003\u0007\u0001*A\u0002sk:$\"aU2\u0011\u0007QcvL\u0004\u0002V5:\u0011a+W\u0007\u0002/*\u0011\u0001LJ\u0001\u0007yI|w\u000e\u001e \n\u0003eJ!a\u0017\u001d\u0002\u000fA\f7m[1hK&\u0011QL\u0018\u0002\u0004'\u0016\f(BA.9!\t\u0001\u0017-D\u0001\u001f\u0013\t\u0011gDA\u0002S_^DQ\u0001\u001a\u0004A\u0002\u0015\fAb\u001d9be.\u001cVm]:j_:\u0004\"\u0001\u00194\n\u0005\u001dt\"\u0001D*qCJ\\7+Z:tS>t\u0017\u0001B2paf$2A\u00146l\u0011\u001dyt\u0001%AA\u0002\u0005CqAR\u0004\u0011\u0002\u0003\u0007\u0001*\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u00039T#!Q8,\u0003A\u0004\"!\u001d<\u000e\u0003IT!a\u001d;\u0002\u0013Ut7\r[3dW\u0016$'BA;9\u0003)\tgN\\8uCRLwN\\\u0005\u0003oJ\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\u0012A\u001f\u0016\u0003\u0011>\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DX#A?\u0011\u0007y\f9!D\u0001\u0000\u0015\u0011\t\t!a\u0001\u0002\t1\fgn\u001a\u0006\u0003\u0003\u000b\tAA[1wC&\u0019\u0011\u0011B@\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ty\u0001E\u00028\u0003#I1!a\u00059\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\tI\"a\b\u0011\u0007]\nY\"C\u0002\u0002\u001ea\u00121!\u00118z\u0011%\t\t\u0003DA\u0001\u0002\u0004\ty!A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003O\u0001b!!\u000b\u00020\u0005eQBAA\u0016\u0015\r\ti\u0003O\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u0019\u0003W\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019\u0001*a\u000e\t\u0013\u0005\u0005b\"!AA\u0002\u0005e\u0011AB3rk\u0006d7\u000fF\u0002I\u0003{A\u0011\"!\t\u0010\u0003\u0003\u0005\r!!\u0007\u0002'\u0005s\u0017\r\\={KR\u000b'\r\\3D_6l\u0017M\u001c3\u0011\u0005M\n2\u0003B\t\u0002Fq\u0002r!a\u0012\u0002N\u0005Ce*\u0004\u0002\u0002J)\u0019\u00111\n\u001d\u0002\u000fI,h\u000e^5nK&!\u0011qJA%\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u000b\u0003\u0003\u0003\n\u0001\u0002^8TiJLgn\u001a\u000b\u0002{\u0006)\u0011\r\u001d9msR)a*a\u0017\u0002^!)q\b\u0006a\u0001\u0003\"9a\t\u0006I\u0001\u0002\u0004A\u0015aD1qa2LH\u0005Z3gCVdG\u000f\n\u001a\u0002\u000fUt\u0017\r\u001d9msR!\u0011QMA9!\u00159\u0014qMA6\u0013\r\tI\u0007\u000f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000b]\ni'\u0011%\n\u0007\u0005=\u0004H\u0001\u0004UkBdWM\r\u0005\t\u0003g2\u0012\u0011!a\u0001\u001d\u0006\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005m\u0004c\u0001@\u0002~%\u0019\u0011qP@\u0003\r=\u0013'.Z2u\u0001")
public class AnalyzeTableCommand
extends LogicalPlan
implements RunnableCommand,
scala.Serializable {
    private final TableIdentifier tableIdent;
    private final boolean noscan;
    private Map<String, SQLMetric> metrics;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$2() {
        return AnalyzeTableCommand$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<TableIdentifier, Object>> unapply(AnalyzeTableCommand analyzeTableCommand) {
        return AnalyzeTableCommand$.MODULE$.unapply(analyzeTableCommand);
    }

    public static boolean apply$default$2() {
        return AnalyzeTableCommand$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple2<TableIdentifier, Object>, AnalyzeTableCommand> tupled() {
        return AnalyzeTableCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Object, AnalyzeTableCommand>> curried() {
        return AnalyzeTableCommand$.MODULE$.curried();
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Seq<LogicalPlan> children() {
        return Command.children$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        AnalyzeTableCommand analyzeTableCommand = this;
        synchronized (analyzeTableCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public TableIdentifier tableIdent() {
        return this.tableIdent;
    }

    public boolean noscan() {
        return this.noscan;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        Object object;
        SessionState sessionState = sparkSession.sessionState();
        String db = (String)this.tableIdent().database().getOrElse((Function0 & Serializable & scala.Serializable)() -> sessionState.catalog().getCurrentDatabase());
        TableIdentifier tableIdentWithDB = new TableIdentifier(this.tableIdent().table(), (Option)new Some((Object)db));
        CatalogTable tableMeta = sessionState.catalog().getTableMetadata(tableIdentWithDB);
        CatalogTableType catalogTableType = tableMeta.tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
        if (!(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null)) {
            Dataset<Row> table = sparkSession.table(this.tableIdent().quotedString());
            CacheManager cacheManager = sparkSession.sharedState().cacheManager();
            if (!cacheManager.lookupCachedData(table.logicalPlan()).isDefined()) throw new AnalysisException("ANALYZE TABLE is not supported on views.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            object = !this.noscan() ? BoxesRunTime.boxToLong((long)table.count()) : BoxedUnit.UNIT;
            return (Seq)Seq$.MODULE$.empty();
        } else {
            BigInt newTotalSize = CommandUtils$.MODULE$.calculateTotalSize(sparkSession, tableMeta);
            None$ newRowCount = this.noscan() ? None$.MODULE$ : new Some((Object)package$.MODULE$.BigInt().apply(sparkSession.table(tableIdentWithDB).count()));
            Option<CatalogStatistics> newStats = CommandUtils$.MODULE$.compareAndGetNewStats((Option<CatalogStatistics>)tableMeta.stats(), newTotalSize, (Option<BigInt>)newRowCount);
            if (newStats.isDefined()) {
                sessionState.catalog().alterTableStats(tableIdentWithDB, newStats);
            }
            object = BoxedUnit.UNIT;
        }
        return (Seq)Seq$.MODULE$.empty();
    }

    public AnalyzeTableCommand copy(TableIdentifier tableIdent, boolean noscan) {
        return new AnalyzeTableCommand(tableIdent, noscan);
    }

    public TableIdentifier copy$default$1() {
        return this.tableIdent();
    }

    public boolean copy$default$2() {
        return this.noscan();
    }

    public String productPrefix() {
        return "AnalyzeTableCommand";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.tableIdent();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.noscan());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AnalyzeTableCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AnalyzeTableCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        AnalyzeTableCommand analyzeTableCommand = (AnalyzeTableCommand)x$1;
        TableIdentifier tableIdentifier = this.tableIdent();
        TableIdentifier tableIdentifier2 = analyzeTableCommand.tableIdent();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        if (this.noscan() != analyzeTableCommand.noscan()) return false;
        if (!analyzeTableCommand.canEqual(this)) return false;
        return true;
    }

    public AnalyzeTableCommand(TableIdentifier tableIdent, boolean noscan) {
        this.tableIdent = tableIdent;
        this.noscan = noscan;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
    }
}

