/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.time.ZoneId;
import java.util.List;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.apache.spark.SparkException;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.catalyst.util.RebaseDateTime;
import org.apache.spark.sql.connector.expressions.aggregate.AggregateFunc;
import org.apache.spark.sql.connector.expressions.aggregate.Aggregation;
import org.apache.spark.sql.connector.expressions.aggregate.Count;
import org.apache.spark.sql.connector.expressions.aggregate.CountStar;
import org.apache.spark.sql.connector.expressions.aggregate.Max;
import org.apache.spark.sql.connector.expressions.aggregate.Min;
import org.apache.spark.sql.execution.datasources.AggregatePushDownUtils$;
import org.apache.spark.sql.execution.datasources.parquet.NoopUpdater$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOptions;
import org.apache.spark.sql.execution.datasources.parquet.ParquetRowConverter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetUtils;
import org.apache.spark.sql.execution.datasources.v2.V2ColumnUtils$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;

public final class ParquetUtils$ {
    public static ParquetUtils$ MODULE$;
    private final String FIELD_ID_METADATA_KEY;

    static {
        new ParquetUtils$();
    }

    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> parameters, Seq<FileStatus> files) {
        Seq seq;
        ParquetOptions parquetOptions = new ParquetOptions(parameters, sparkSession.sessionState().conf());
        boolean shouldMergeSchemas = parquetOptions.mergeSchema();
        boolean mergeRespectSummaries = sparkSession.sessionState().conf().isParquetSchemaRespectSummaries();
        ParquetUtils.FileTypes filesByType = this.splitFiles(files);
        if (shouldMergeSchemas) {
            Seq<FileStatus> needMerged = mergeRespectSummaries ? (Seq<FileStatus>)Nil$.MODULE$ : filesByType.data();
            seq = (Seq)((TraversableLike)needMerged.$plus$plus(filesByType.metadata(), Seq$.MODULE$.canBuildFrom())).$plus$plus(filesByType.commonMetadata(), Seq$.MODULE$.canBuildFrom());
        } else {
            seq = Option$.MODULE$.option2Iterable(filesByType.commonMetadata().headOption().orElse((Function0 & Serializable & scala.Serializable)() -> filesByType.metadata().headOption()).orElse((Function0 & Serializable & scala.Serializable)() -> filesByType.data().headOption())).toSeq();
        }
        Seq filesToTouch = seq;
        return ParquetFileFormat$.MODULE$.mergeSchemasInParallel(parameters, (Seq<FileStatus>)filesToTouch, sparkSession);
    }

    private ParquetUtils.FileTypes splitFiles(Seq<FileStatus> allFiles) {
        FileStatus[] leaves = (FileStatus[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allFiles.toArray(ClassTag$.MODULE$.apply(FileStatus.class)))).sortBy((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getPath().toString(), (Ordering)Ordering.String$.MODULE$);
        return new ParquetUtils.FileTypes((Seq<FileStatus>)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])leaves)).filterNot((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)ParquetUtils$.MODULE$.isSummaryFile(f.getPath())))), (Seq<FileStatus>)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])leaves)).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ParquetUtils$.$anonfun$splitFiles$3(x$2)))), (Seq<FileStatus>)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])leaves)).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ParquetUtils$.$anonfun$splitFiles$4(x$3)))));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isSummaryFile(Path file) {
        String string = file.getName();
        String string2 = "_common_metadata";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = file.getName();
        String string4 = "_metadata";
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public String FIELD_ID_METADATA_KEY() {
        return this.FIELD_ID_METADATA_KEY;
    }

    public boolean hasFieldIds(StructType schema) {
        return schema.isEmpty() ? false : this.recursiveCheck$1((DataType)schema);
    }

    public boolean hasFieldId(StructField field) {
        return field.metadata().contains(this.FIELD_ID_METADATA_KEY());
    }

    public int getFieldId(StructField field) {
        int n;
        Predef$.MODULE$.require(this.hasFieldId(field), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("The key `").append(MODULE$.FIELD_ID_METADATA_KEY()).append("` doesn't exist in the metadata of ").append(field).toString());
        try {
            n = Math.toIntExact(field.metadata().getLong(this.FIELD_ID_METADATA_KEY()));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof ArithmeticException ? true : throwable2 instanceof ClassCastException;
            if (bl) {
                throw new IllegalArgumentException(new StringBuilder(35).append("The key `").append(this.FIELD_ID_METADATA_KEY()).append("` must be a 32-bit integer").toString());
            }
            throw throwable;
        }
        return n;
    }

    public boolean isBatchReadSupportedForSchema(SQLConf sqlConf, StructType schema) {
        return sqlConf.parquetVectorizedReaderEnabled() && schema.forall((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)ParquetUtils$.MODULE$.isBatchReadSupported(sqlConf, f.dataType())));
    }

    public boolean isBatchReadSupported(SQLConf sqlConf, DataType dt) {
        boolean bl;
        block6: {
            DataType dataType;
            block7: {
                while (true) {
                    if ((dataType = dt) instanceof AtomicType) {
                        bl = true;
                        break block6;
                    }
                    if (dataType instanceof ArrayType) {
                        ArrayType arrayType = (ArrayType)dataType;
                        if (sqlConf.parquetVectorizedReaderNestedColumnEnabled()) {
                            dt = arrayType.elementType();
                            continue;
                        }
                        bl = false;
                        break block6;
                    }
                    if (!(dataType instanceof MapType)) break block7;
                    MapType mapType = (MapType)dataType;
                    if (!sqlConf.parquetVectorizedReaderNestedColumnEnabled() || !this.isBatchReadSupported(sqlConf, mapType.keyType())) break;
                    dt = mapType.valueType();
                }
                bl = false;
                break block6;
            }
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                bl = sqlConf.parquetVectorizedReaderNestedColumnEnabled() && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structType.fields())).forall((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)ParquetUtils$.MODULE$.isBatchReadSupported(sqlConf, f.dataType())));
            } else {
                bl = false;
            }
        }
        return bl;
    }

    public InternalRow createAggInternalRowFromFooter(ParquetMetadata footer, String filePath, StructType dataSchema, StructType partitionSchema, Aggregation aggregation, StructType aggSchema, InternalRow partitionValues, RebaseDateTime.RebaseSpec datetimeRebaseSpec) {
        InternalRow internalRow;
        Tuple2<PrimitiveType[], Object[]> tuple2 = this.getPushedDownAggResult(footer, filePath, dataSchema, partitionSchema, aggregation);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        PrimitiveType[] primitiveTypes = (PrimitiveType[])tuple2._1();
        Object[] values = (Object[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)primitiveTypes, (Object)values);
        Tuple2 tuple23 = tuple22;
        PrimitiveType[] primitiveTypes2 = (PrimitiveType[])tuple23._1();
        Object[] values2 = (Object[])tuple23._2();
        Types.MessageTypeBuilder builder = Types.buildMessage();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])primitiveTypes2)).foreach((Function1 & Serializable & scala.Serializable)t -> (Types.GroupBuilder)builder.addField((Type)t));
        MessageType parquetSchema = builder.named("root");
        StructType schemaWithoutGroupBy = AggregatePushDownUtils$.MODULE$.getSchemaWithoutGroupingExpression(aggSchema, aggregation);
        ParquetToSparkSchemaConverter schemaConverter = new ParquetToSparkSchemaConverter(ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$1(), ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$2(), ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$3());
        ParquetRowConverter converter = new ParquetRowConverter(schemaConverter, (GroupType)parquetSchema, schemaWithoutGroupBy, (Option<ZoneId>)None$.MODULE$, datetimeRebaseSpec, new RebaseDateTime.RebaseSpec(SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED(), RebaseDateTime.RebaseSpec$.MODULE$.apply$default$2()), NoopUpdater$.MODULE$);
        PrimitiveType.PrimitiveTypeName[] primitiveTypeNames = (PrimitiveType.PrimitiveTypeName[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])primitiveTypes2)).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getPrimitiveTypeName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(PrimitiveType.PrimitiveTypeName.class)));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])primitiveTypeNames)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ParquetUtils$.$anonfun$createAggInternalRowFromFooter$3(values2, converter, primitiveTypeNames, x0$1);
            return BoxedUnit.UNIT;
        });
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])aggregation.groupByExpressions())).nonEmpty()) {
            InternalRow reorderedPartitionValues = AggregatePushDownUtils$.MODULE$.reOrderPartitionCol(partitionSchema, aggregation, partitionValues);
            internalRow = new JoinedRow(reorderedPartitionValues, converter.currentRecord());
        } else {
            internalRow = converter.currentRecord();
        }
        return internalRow;
    }

    public Tuple2<PrimitiveType[], Object[]> getPushedDownAggResult(ParquetMetadata footer, String filePath, StructType dataSchema, StructType partitionSchema, Aggregation aggregation) {
        FileMetaData footerFileMetaData = footer.getFileMetaData();
        List fields = footerFileMetaData.getSchema().getFields();
        List blocks = footer.getBlocks();
        ArrayBuilder primitiveTypeBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(PrimitiveType.class));
        ArrayBuilder valuesBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Any());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])aggregation.aggregateExpressions())).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            ArrayBuilder arrayBuilder;
            ObjectRef value = ObjectRef.create((Object)None$.MODULE$);
            LongRef rowCount = LongRef.create((long)0L);
            BooleanRef isCount = BooleanRef.create((boolean)false);
            IntRef index = IntRef.create((int)0);
            ObjectRef schemaName = ObjectRef.create((Object)"");
            blocks.forEach(block -> {
                Count count;
                Min min;
                Max max;
                List blockMetaData = block.getColumns();
                AggregateFunc aggregateFunc = agg;
                if (aggregateFunc instanceof Max && V2ColumnUtils$.MODULE$.extractV2Column((max = (Max)aggregateFunc).column()).isDefined()) {
                    BoxedUnit boxedUnit;
                    String colName = (String)V2ColumnUtils$.MODULE$.extractV2Column(max.column()).get();
                    index$1.elem = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataSchema.fieldNames())).toList().indexOf((Object)colName);
                    schemaName$1.elem = new StringBuilder(5).append("max(").append(colName).append(")").toString();
                    Object currentMax = MODULE$.getCurrentBlockMaxOrMin(filePath, blockMetaData, index$1.elem, true);
                    Object object = value$1.elem;
                    None$ none$ = None$.MODULE$;
                    if (!(object == null ? none$ != null : !object.equals(none$)) || ((Comparable)currentMax).compareTo(value$1.elem) > 0) {
                        value$1.elem = currentMax;
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                } else if (aggregateFunc instanceof Min && V2ColumnUtils$.MODULE$.extractV2Column((min = (Min)aggregateFunc).column()).isDefined()) {
                    BoxedUnit boxedUnit;
                    String colName = (String)V2ColumnUtils$.MODULE$.extractV2Column(min.column()).get();
                    index$1.elem = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataSchema.fieldNames())).toList().indexOf((Object)colName);
                    schemaName$1.elem = new StringBuilder(5).append("min(").append(colName).append(")").toString();
                    Object currentMin = MODULE$.getCurrentBlockMaxOrMin(filePath, blockMetaData, index$1.elem, false);
                    Object object = value$1.elem;
                    None$ none$ = None$.MODULE$;
                    if (!(object == null ? none$ != null : !object.equals(none$)) || ((Comparable)currentMin).compareTo(value$1.elem) < 0) {
                        value$1.elem = currentMin;
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit3 = boxedUnit;
                } else if (aggregateFunc instanceof Count && V2ColumnUtils$.MODULE$.extractV2Column((count = (Count)aggregateFunc).column()).isDefined()) {
                    BoxedUnit boxedUnit;
                    String colName = (String)V2ColumnUtils$.MODULE$.extractV2Column(count.column()).get();
                    schemaName$1.elem = new StringBuilder(7).append("count(").append(colName).append(")").toString();
                    rowCount$1.elem += block.getRowCount();
                    boolean isPartitionCol = false;
                    if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields())).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSet().contains((Object)colName)) {
                        isPartitionCol = true;
                    }
                    isCount$1.elem = true;
                    if (!isPartitionCol) {
                        index$1.elem = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataSchema.fieldNames())).toList().indexOf((Object)colName);
                        rowCount$1.elem -= MODULE$.getNumNulls(filePath, blockMetaData, index$1.elem);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit4 = boxedUnit;
                } else if (aggregateFunc instanceof CountStar) {
                    schemaName$1.elem = "count(*)";
                    rowCount$1.elem += block.getRowCount();
                    isCount$1.elem = true;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            });
            if (isCount.elem) {
                valuesBuilder.$plus$eq((Object)BoxesRunTime.boxToLong((long)rowCount.elem));
                arrayBuilder = (ArrayBuilder)primitiveTypeBuilder.$plus$eq(Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).named((String)schemaName.elem));
            } else {
                valuesBuilder.$plus$eq(value.elem);
                Type field = (Type)fields.get(index.elem);
                arrayBuilder = (ArrayBuilder)primitiveTypeBuilder.$plus$eq(((Types.BasePrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)field.asPrimitiveType().getPrimitiveTypeName()).as(field.getLogicalTypeAnnotation())).length(field.asPrimitiveType().getTypeLength()).named((String)schemaName.elem));
            }
            return arrayBuilder;
        });
        return new Tuple2(primitiveTypeBuilder.result(), valuesBuilder.result());
    }

    private Object getCurrentBlockMaxOrMin(String filePath, List<ColumnChunkMetaData> columnChunkMetaData, int i, boolean isMax) {
        Statistics statistics = columnChunkMetaData.get(i).getStatistics();
        if (!statistics.hasNonNullValue()) {
            throw new UnsupportedOperationException(new StringBuilder(75).append("No min/max found for Parquet file ").append(filePath).append(". ").append("Set SQLConf ").append(SQLConf$.MODULE$.PARQUET_AGGREGATE_PUSHDOWN_ENABLED().key()).append(" to false and execute again").toString());
        }
        return isMax ? statistics.genericGetMax() : statistics.genericGetMin();
    }

    private long getNumNulls(String filePath, List<ColumnChunkMetaData> columnChunkMetaData, int i) {
        Statistics statistics = columnChunkMetaData.get(i).getStatistics();
        if (!statistics.isNumNullsSet()) {
            throw new UnsupportedOperationException(new StringBuilder(82).append("Number of nulls not set for Parquet file").append(" ").append(filePath).append(". Set SQLConf ").append(SQLConf$.MODULE$.PARQUET_AGGREGATE_PUSHDOWN_ENABLED().key()).append(" to false and execute").append(" again").toString());
        }
        return statistics.getNumNulls();
    }

    public static final /* synthetic */ boolean $anonfun$splitFiles$3(FileStatus x$2) {
        String string = x$2.getPath().getName();
        String string2 = "_metadata";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$splitFiles$4(FileStatus x$3) {
        String string = x$3.getPath().getName();
        String string2 = "_common_metadata";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$hasFieldIds$1(ParquetUtils$ $this, StructField field) {
        return MODULE$.hasFieldId(field) || $this.recursiveCheck$1(field.dataType());
    }

    private final boolean recursiveCheck$1(DataType schema) {
        boolean bl;
        block3: {
            block4: {
                while (true) {
                    DataType dataType;
                    if ((dataType = schema) instanceof StructType) {
                        StructType structType = (StructType)dataType;
                        bl = structType.exists((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)ParquetUtils$.$anonfun$hasFieldIds$1(this, field)));
                        break block3;
                    }
                    if (dataType instanceof ArrayType) {
                        ArrayType arrayType = (ArrayType)dataType;
                        schema = arrayType.elementType();
                        continue;
                    }
                    if (!(dataType instanceof MapType)) break block4;
                    MapType mapType = (MapType)dataType;
                    if (this.recursiveCheck$1(mapType.keyType())) break;
                    schema = mapType.valueType();
                }
                bl = true;
                break block3;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$createAggInternalRowFromFooter$3(Object[] values$1, ParquetRowConverter converter$1, PrimitiveType.PrimitiveTypeName[] primitiveTypeNames$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            PrimitiveType.PrimitiveTypeName primitiveTypeName = (PrimitiveType.PrimitiveTypeName)tuple2._1();
            int i = tuple2._2$mcI$sp();
            if (PrimitiveType.PrimitiveTypeName.BOOLEAN.equals(primitiveTypeName)) {
                boolean v = BoxesRunTime.unboxToBoolean((Object)values$1[i]);
                converter$1.getConverter(i).asPrimitiveConverter().addBoolean(v);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 != null) {
            PrimitiveType.PrimitiveTypeName primitiveTypeName = (PrimitiveType.PrimitiveTypeName)tuple2._1();
            int i = tuple2._2$mcI$sp();
            if (PrimitiveType.PrimitiveTypeName.INT32.equals(primitiveTypeName)) {
                Integer v = (Integer)values$1[i];
                converter$1.getConverter(i).asPrimitiveConverter().addInt(Predef$.MODULE$.Integer2int(v));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 != null) {
            PrimitiveType.PrimitiveTypeName primitiveTypeName = (PrimitiveType.PrimitiveTypeName)tuple2._1();
            int i = tuple2._2$mcI$sp();
            if (PrimitiveType.PrimitiveTypeName.INT64.equals(primitiveTypeName)) {
                long v = BoxesRunTime.unboxToLong((Object)values$1[i]);
                converter$1.getConverter(i).asPrimitiveConverter().addLong(v);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 != null) {
            PrimitiveType.PrimitiveTypeName primitiveTypeName = (PrimitiveType.PrimitiveTypeName)tuple2._1();
            int i = tuple2._2$mcI$sp();
            if (PrimitiveType.PrimitiveTypeName.FLOAT.equals(primitiveTypeName)) {
                float v = BoxesRunTime.unboxToFloat((Object)values$1[i]);
                converter$1.getConverter(i).asPrimitiveConverter().addFloat(v);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 != null) {
            PrimitiveType.PrimitiveTypeName primitiveTypeName = (PrimitiveType.PrimitiveTypeName)tuple2._1();
            int i = tuple2._2$mcI$sp();
            if (PrimitiveType.PrimitiveTypeName.DOUBLE.equals(primitiveTypeName)) {
                double v = BoxesRunTime.unboxToDouble((Object)values$1[i]);
                converter$1.getConverter(i).asPrimitiveConverter().addDouble(v);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 != null) {
            PrimitiveType.PrimitiveTypeName primitiveTypeName = (PrimitiveType.PrimitiveTypeName)tuple2._1();
            int i = tuple2._2$mcI$sp();
            if (PrimitiveType.PrimitiveTypeName.BINARY.equals(primitiveTypeName)) {
                Binary v = (Binary)values$1[i];
                converter$1.getConverter(i).asPrimitiveConverter().addBinary(v);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 != null) {
            PrimitiveType.PrimitiveTypeName primitiveTypeName = (PrimitiveType.PrimitiveTypeName)tuple2._1();
            int i = tuple2._2$mcI$sp();
            if (PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY.equals(primitiveTypeName)) {
                Binary v = (Binary)values$1[i];
                converter$1.getConverter(i).asPrimitiveConverter().addBinary(v);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        int i = tuple2._2$mcI$sp();
        throw new SparkException(new StringBuilder(30).append("Unexpected parquet type name: ").append(primitiveTypeNames$1[i]).toString());
    }

    private ParquetUtils$() {
        MODULE$ = this;
        this.FIELD_ID_METADATA_KEY = "parquet.field.id";
    }
}

