/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.StatisticsCollectionTestBase;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.BinaryOperator;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.IsNotNull;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.datasources.v2.BatchScanExec;
import org.apache.spark.sql.execution.datasources.v2.FileScan;
import org.apache.spark.sql.internal.SQLConf$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001y3Qa\u0002\u0005\u0002\u0002UAQA\u0007\u0001\u0005\u0002mAQA\b\u0001\u0007\u0012}AQ!\f\u0001\u0005\n9BQ!\u000f\u0001\u0005\u0012iBQ\u0001\u0013\u0001\u0007\u0012%CQA\u0017\u0001\u0007\u0012m\u0013q\u0003\u0015:v]\u0016\u0004\u0016M\u001d;ji&|gnU;ji\u0016\u0014\u0015m]3\u000b\u0005%Q\u0011a\u00033bi\u0006\u001cx.\u001e:dKNT!a\u0003\u0007\u0002\u0013\u0015DXmY;uS>t'BA\u0007\u000f\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u001fA\tQa\u001d9be.T!!\u0005\n\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0012aA8sO\u000e\u00011C\u0001\u0001\u0017!\t9\u0002$D\u0001\r\u0013\tIBB\u0001\u000fTi\u0006$\u0018n\u001d;jGN\u001cu\u000e\u001c7fGRLwN\u001c+fgR\u0014\u0015m]3\u0002\rqJg.\u001b;?)\u0005a\u0002CA\u000f\u0001\u001b\u0005A\u0011A\u00024pe6\fG/F\u0001!!\t\t#F\u0004\u0002#QA\u00111EJ\u0007\u0002I)\u0011Q\u0005F\u0001\u0007yI|w\u000e\u001e \u000b\u0003\u001d\nQa]2bY\u0006L!!\u000b\u0014\u0002\rA\u0013X\rZ3g\u0013\tYCF\u0001\u0004TiJLgn\u001a\u0006\u0003S\u0019\nAdZ3u\u00072,\u0017M\\*ue&twMU3qe\u0016\u001cXM\u001c;bi&|g\u000e\u0006\u0002!_!)\u0001g\u0001a\u0001c\u0005\u0019Q\r\u001f9\u0011\u0005I:T\"A\u001a\u000b\u0005Q*\u0014aC3yaJ,7o]5p]NT!A\u000e\u0007\u0002\u0011\r\fG/\u00197zgRL!\u0001O\u001a\u0003\u0015\u0015C\bO]3tg&|g.\u0001\fbgN,'\u000f\u001e)sk:,G\rU1si&$\u0018n\u001c8t)\u0011Yt(\u0011$\u0011\u0005qjT\"\u0001\u0014\n\u0005y2#\u0001B+oSRDQ\u0001\u0011\u0003A\u0002\u0001\nQ!];fefDQA\u0011\u0003A\u0002\r\u000ba#\u001a=qK\u000e$X\r\u001a)beRLG/[8o\u0007>,h\u000e\u001e\t\u0003y\u0011K!!\u0012\u0014\u0003\t1{gn\u001a\u0005\u0006\u000f\u0012\u0001\r\u0001I\u0001\u001aKb\u0004Xm\u0019;fIB+8\u000f[3e\t><hNR5mi\u0016\u00148/A\rd_2dWm\u0019;QCJ$\u0018\u000e^5p]\u001aKG\u000e^3sg\u001asG#\u0001&\u0011\tqZU*U\u0005\u0003\u0019\u001a\u0012q\u0002U1si&\fGNR;oGRLwN\u001c\t\u0003\u001d>k\u0011AC\u0005\u0003!*\u0011\u0011b\u00159be.\u0004F.\u00198\u0011\u0007I;\u0016G\u0004\u0002T+:\u00111\u0005V\u0005\u0002O%\u0011aKJ\u0001\ba\u0006\u001c7.Y4f\u0013\tA\u0016LA\u0002TKFT!A\u0016\u0014\u00021\u001d,GoU2b]\u0016CXm\u0019)beRLG/[8o'&TX\r\u0006\u0002D9\")QL\u0002a\u0001\u001b\u0006!\u0001\u000f\\1o\u0001")
public abstract class PrunePartitionSuiteBase
extends StatisticsCollectionTestBase {
    public abstract String format();

    private String getCleanStringRepresentation(Expression exp) {
        String string;
        Expression expression = exp;
        if (expression instanceof AttributeReference) {
            AttributeReference attributeReference = (AttributeReference)expression;
            string = attributeReference.sql().replaceAll("spark_catalog.default.t.", "");
        } else if (expression instanceof Literal) {
            Literal literal = (Literal)expression;
            string = literal.sql();
        } else if (expression instanceof BinaryOperator) {
            BinaryOperator binaryOperator = (BinaryOperator)expression;
            string = new StringBuilder(4).append("(").append(this.getCleanStringRepresentation((Expression)binaryOperator.left())).append(" ").append(binaryOperator.symbol()).append(" ").append(this.getCleanStringRepresentation((Expression)binaryOperator.right())).append(")").toString();
        } else {
            throw new MatchError((Object)expression);
        }
        return string;
    }

    public void assertPrunedPartitions(String query, long expectedPartitionCount, String expectedPushedDownFilters) {
        Option pushedFilters;
        QueryExecution qe = ((Dataset)this.sql().apply((Object)query)).queryExecution();
        SparkPlan plan = qe.sparkPlan();
        long $org_scalatest_assert_macro_left = this.getScanExecPartitionSize(plan);
        long $org_scalatest_assert_macro_right = expectedPartitionCount;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PrunePartitionSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
        PartialFunction collectFn = this.collectPartitionFiltersFn().orElse((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                BatchScanExec batchScanExec;
                Scan scan;
                A1 A1 = x1;
                if (A1 instanceof BatchScanExec && (scan = (batchScanExec = (BatchScanExec)A1).scan()) instanceof FileScan) {
                    FileScan fileScan = (FileScan)scan;
                    object = fileScan.partitionFilters();
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x1) {
                BatchScanExec batchScanExec;
                Scan scan;
                SparkPlan sparkPlan2 = x1;
                boolean bl = sparkPlan2 instanceof BatchScanExec && (scan = (batchScanExec = (BatchScanExec)sparkPlan2).scan()) instanceof FileScan;
                return bl;
            }
        });
        Option pushedDownPartitionFilters = plan.collectFirst(collectFn).map((Function1 & Serializable & scala.Serializable)exps -> (Seq)exps.filterNot((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)PrunePartitionSuiteBase.$anonfun$assertPrunedPartitions$2(e))));
        Option $org_scalatest_assert_macro_left2 = pushedFilters = pushedDownPartitionFilters.map((Function1 & Serializable & scala.Serializable)filters -> (String)filters.foldLeft((Object)"", (Function2 & Serializable & scala.Serializable)(currentStr, exp) -> {
            String string = currentStr;
            String string2 = "";
            return !(string != null ? !string.equals(string2) : string2 != null) ? String.valueOf(this.getCleanStringRepresentation((Expression)exp)) : new StringBuilder(5).append((String)currentStr).append(" AND ").append(this.getCleanStringRepresentation((Expression)exp)).toString();
        }));
        Some $org_scalatest_assert_macro_right2 = new Some((Object)expectedPushedDownFilters);
        Option option = $org_scalatest_assert_macro_left2;
        Some some = $org_scalatest_assert_macro_right2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PrunePartitionSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
    }

    public abstract PartialFunction<SparkPlan, Seq<Expression>> collectPartitionFiltersFn();

    public abstract long getScanExecPartitionSize(SparkPlan var1);

    public static final /* synthetic */ Dataset $anonfun$new$5(PrunePartitionSuiteBase $this, int part) {
        return (Dataset)$this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(99).append("\n                 |INSERT OVERWRITE TABLE t PARTITION (p='").append(part).append("')\n                 |SELECT col FROM temp").toString())).stripMargin());
    }

    public static final /* synthetic */ boolean $anonfun$assertPrunedPartitions$2(Expression e) {
        return e instanceof IsNotNull;
    }

    public PrunePartitionSuiteBase() {
        this.test("SPARK-28169: Convert scan predicate condition to CNF", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ADAPTIVE_EXECUTION_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"temp"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(106).append("\n               |CREATE TABLE t(i INT, p STRING)\n               |USING ").append(this.format()).append("\n               |PARTITIONED BY (p)").toString())).stripMargin());
            this.spark().range(0L, 1000L, 1L).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id as col"})).createOrReplaceTempView("temp");
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4}))).foreach((Function1 & Serializable & scala.Serializable)part -> PrunePartitionSuiteBase.$anonfun$new$5(this, BoxesRunTime.unboxToInt((Object)part)));
            this.assertPrunedPartitions("SELECT * FROM t WHERE p = '1' OR (p = '2' AND i = 1)", 2L, "((p = '1') || (p = '2'))");
            this.assertPrunedPartitions("SELECT * FROM t WHERE (p = '1' AND i = 2) OR (i = 1 OR p = '2')", 4L, "");
            this.assertPrunedPartitions("SELECT * FROM t WHERE (p = '1' AND i = 2) OR (p = '3' AND i = 3 )", 2L, "((p = '1') || (p = '3'))");
            this.assertPrunedPartitions("SELECT * FROM t WHERE (p = '1' AND i = 2) OR (p = '2' OR p = '3')", 3L, "((p = '1') || ((p = '2') || (p = '3')))");
            this.assertPrunedPartitions("SELECT * FROM t", 4L, "");
            this.assertPrunedPartitions("SELECT * FROM t WHERE p = '1' AND i = 2", 1L, "(p = '1')");
            this.assertPrunedPartitions(new StringOps(Predef$.MODULE$.augmentString("\n              |SELECT i, COUNT(1) FROM (\n              |SELECT * FROM t WHERE  p = '1' OR (p = '2' AND i = 1)\n              |) tmp GROUP BY i\n            ")).stripMargin(), 2L, "((p = '1') || (p = '2'))");
        }))), new Position("PrunePartitionSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 30));
    }
}

