/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.aggregate;

import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.SessionWindow$;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateExpression;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateExpression$;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateFunction;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateMode;
import org.apache.spark.sql.catalyst.expressions.aggregate.Complete$;
import org.apache.spark.sql.catalyst.expressions.aggregate.Final$;
import org.apache.spark.sql.catalyst.expressions.aggregate.Partial$;
import org.apache.spark.sql.catalyst.expressions.aggregate.PartialMerge$;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.aggregate.HashAggregateExec;
import org.apache.spark.sql.execution.aggregate.MergingSessionsExec;
import org.apache.spark.sql.execution.aggregate.ObjectHashAggregateExec;
import org.apache.spark.sql.execution.aggregate.SortAggregateExec;
import org.apache.spark.sql.execution.aggregate.UpdatingSessionsExec;
import org.apache.spark.sql.execution.streaming.SessionWindowStateStoreRestoreExec;
import org.apache.spark.sql.execution.streaming.SessionWindowStateStoreSaveExec;
import org.apache.spark.sql.execution.streaming.StateStoreRestoreExec;
import org.apache.spark.sql.execution.streaming.StateStoreSaveExec;
import org.apache.spark.sql.execution.streaming.StatefulOperatorStateInfo;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.util.collection.Utils$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;

public final class AggUtils$ {
    public static AggUtils$ MODULE$;

    static {
        new AggUtils$();
    }

    private Seq<AggregateExpression> mayRemoveAggFilters(Seq<AggregateExpression> exprs) {
        return (Seq)exprs.map((Function1 & Serializable & scala.Serializable)ae -> {
            if (ae.filter().isDefined()) {
                AggregateMode aggregateMode = ae.mode();
                if (Partial$.MODULE$.equals(aggregateMode) ? true : Complete$.MODULE$.equals(aggregateMode)) {
                    return ae;
                }
                None$ x$1 = None$.MODULE$;
                AggregateFunction x$2 = ae.copy$default$1();
                AggregateMode x$3 = ae.copy$default$2();
                boolean x$4 = ae.copy$default$3();
                ExprId x$5 = ae.copy$default$5();
                return ae.copy(x$2, x$3, x$4, (Option)x$1, x$5);
            }
            return ae;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private SparkPlan createStreamingAggregate(Option<Seq<Expression>> requiredChildDistributionExpressions, Seq<NamedExpression> groupingExpressions, Seq<AggregateExpression> aggregateExpressions, Seq<Attribute> aggregateAttributes, int initialInputBufferOffset, Seq<NamedExpression> resultExpressions, SparkPlan child) {
        return this.createAggregate(requiredChildDistributionExpressions, true, groupingExpressions, aggregateExpressions, aggregateAttributes, initialInputBufferOffset, resultExpressions, child);
    }

    private Option<Seq<Expression>> createStreamingAggregate$default$1() {
        return None$.MODULE$;
    }

    private Seq<NamedExpression> createStreamingAggregate$default$2() {
        return Nil$.MODULE$;
    }

    private Seq<AggregateExpression> createStreamingAggregate$default$3() {
        return Nil$.MODULE$;
    }

    private Seq<Attribute> createStreamingAggregate$default$4() {
        return Nil$.MODULE$;
    }

    private int createStreamingAggregate$default$5() {
        return 0;
    }

    private Seq<NamedExpression> createStreamingAggregate$default$6() {
        return Nil$.MODULE$;
    }

    private SparkPlan createAggregate(Option<Seq<Expression>> requiredChildDistributionExpressions, boolean isStreaming, Seq<NamedExpression> groupingExpressions, Seq<AggregateExpression> aggregateExpressions, Seq<Attribute> aggregateAttributes, int initialInputBufferOffset, Seq<NamedExpression> resultExpressions, SparkPlan child) {
        boolean useHash = Aggregate$.MODULE$.supportsHashAggregate((Seq)aggregateExpressions.flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.aggregateFunction().aggBufferAttributes(), Seq$.MODULE$.canBuildFrom()));
        boolean forceSortAggregate = this.forceApplySortAggregate(child.conf());
        if (useHash && !forceSortAggregate) {
            return new HashAggregateExec(requiredChildDistributionExpressions, isStreaming, (Option<Object>)None$.MODULE$, groupingExpressions, this.mayRemoveAggFilters(aggregateExpressions), aggregateAttributes, initialInputBufferOffset, resultExpressions, child);
        }
        boolean objectHashEnabled = child.conf().useObjectHashAggregation();
        boolean useObjectHash = Aggregate$.MODULE$.supportsObjectHashAggregate(aggregateExpressions);
        if (objectHashEnabled && useObjectHash && !forceSortAggregate) {
            return new ObjectHashAggregateExec(requiredChildDistributionExpressions, isStreaming, (Option<Object>)None$.MODULE$, groupingExpressions, this.mayRemoveAggFilters(aggregateExpressions), aggregateAttributes, initialInputBufferOffset, resultExpressions, child);
        }
        return new SortAggregateExec(requiredChildDistributionExpressions, isStreaming, (Option<Object>)None$.MODULE$, groupingExpressions, this.mayRemoveAggFilters(aggregateExpressions), aggregateAttributes, initialInputBufferOffset, resultExpressions, child);
    }

    private Option<Seq<Expression>> createAggregate$default$1() {
        return None$.MODULE$;
    }

    private boolean createAggregate$default$2() {
        return false;
    }

    private Seq<NamedExpression> createAggregate$default$3() {
        return Nil$.MODULE$;
    }

    private Seq<AggregateExpression> createAggregate$default$4() {
        return Nil$.MODULE$;
    }

    private Seq<Attribute> createAggregate$default$5() {
        return Nil$.MODULE$;
    }

    private int createAggregate$default$6() {
        return 0;
    }

    private Seq<NamedExpression> createAggregate$default$7() {
        return Nil$.MODULE$;
    }

    public Seq<SparkPlan> planAggregateWithoutDistinct(Seq<NamedExpression> groupingExpressions, Seq<AggregateExpression> aggregateExpressions, Seq<NamedExpression> resultExpressions, SparkPlan child) {
        SparkPlan finalAggregate;
        Seq groupingAttributes = (Seq)groupingExpressions.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toAttribute(), Seq$.MODULE$.canBuildFrom());
        Seq partialAggregateExpressions = (Seq)aggregateExpressions.map((Function1 & Serializable & scala.Serializable)x$3 -> {
            Partial$ x$1 = Partial$.MODULE$;
            AggregateFunction x$2 = x$3.copy$default$1();
            boolean x$32 = x$3.copy$default$3();
            Option x$4 = x$3.copy$default$4();
            ExprId x$5 = x$3.copy$default$5();
            return x$3.copy(x$2, (AggregateMode)x$1, x$32, x$4, x$5);
        }, Seq$.MODULE$.canBuildFrom());
        Seq partialAggregateAttributes = (Seq)partialAggregateExpressions.flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.aggregateFunction().aggBufferAttributes(), Seq$.MODULE$.canBuildFrom());
        Seq partialResultExpressions = (Seq)groupingAttributes.$plus$plus((GenTraversableOnce)partialAggregateExpressions.flatMap((Function1 & Serializable & scala.Serializable)x$5 -> x$5.aggregateFunction().inputAggBufferAttributes(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        None$ x$62 = None$.MODULE$;
        Seq<NamedExpression> x$72 = groupingExpressions;
        Seq x$8 = partialAggregateExpressions;
        Seq x$9 = partialAggregateAttributes;
        int x$10 = 0;
        Seq x$11 = partialResultExpressions;
        SparkPlan x$12 = child;
        boolean x$13 = this.createAggregate$default$2();
        SparkPlan partialAggregate = this.createAggregate((Option<Seq<Expression>>)x$62, x$13, x$72, (Seq<AggregateExpression>)x$8, (Seq<Attribute>)x$9, x$10, (Seq<NamedExpression>)x$11, x$12);
        SparkPlan interExec = this.mayAppendMergingSessionExec(groupingExpressions, aggregateExpressions, partialAggregate, this.mayAppendMergingSessionExec$default$4());
        Seq finalAggregateExpressions = (Seq)aggregateExpressions.map((Function1 & Serializable & scala.Serializable)x$6 -> {
            Final$ x$14 = Final$.MODULE$;
            AggregateFunction x$15 = x$6.copy$default$1();
            boolean x$16 = x$6.copy$default$3();
            Option x$17 = x$6.copy$default$4();
            ExprId x$18 = x$6.copy$default$5();
            return x$6.copy(x$15, (AggregateMode)x$14, x$16, x$17, x$18);
        }, Seq$.MODULE$.canBuildFrom());
        Seq finalAggregateAttributes = (Seq)finalAggregateExpressions.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.resultAttribute(), Seq$.MODULE$.canBuildFrom());
        Some x$19 = new Some((Object)groupingAttributes);
        Seq x$20 = groupingAttributes;
        Seq x$21 = finalAggregateExpressions;
        Seq x$22 = finalAggregateAttributes;
        int x$23 = groupingExpressions.length();
        Seq<NamedExpression> x$24 = resultExpressions;
        SparkPlan x$25 = interExec;
        boolean x$26 = this.createAggregate$default$2();
        SparkPlan sparkPlan = finalAggregate = this.createAggregate((Option<Seq<Expression>>)x$19, x$26, (Seq<NamedExpression>)x$20, (Seq<AggregateExpression>)x$21, (Seq<Attribute>)x$22, x$23, x$24, x$25);
        return Nil$.MODULE$.$colon$colon((Object)sparkPlan);
    }

    public Seq<SparkPlan> planAggregateWithOneDistinct(Seq<NamedExpression> groupingExpressions, Seq<AggregateExpression> functionsWithDistinct, Seq<AggregateExpression> functionsWithoutDistinct, Seq<Expression> distinctExpressions, Seq<NamedExpression> normalizedNamedDistinctExpressions, Seq<NamedExpression> resultExpressions, SparkPlan child) {
        SparkPlan finalAndCompleteAggregate;
        SparkPlan maySessionChild = this.mayAppendUpdatingSessionExec(groupingExpressions, child, this.mayAppendUpdatingSessionExec$default$3());
        Seq distinctAttributes = (Seq)normalizedNamedDistinctExpressions.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.toAttribute(), Seq$.MODULE$.canBuildFrom());
        Seq groupingAttributes = (Seq)groupingExpressions.map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.toAttribute(), Seq$.MODULE$.canBuildFrom());
        Seq aggregateExpressions = (Seq)functionsWithoutDistinct.map((Function1 & Serializable & scala.Serializable)x$11 -> {
            Partial$ x$1 = Partial$.MODULE$;
            AggregateFunction x$2 = x$11.copy$default$1();
            boolean x$3 = x$11.copy$default$3();
            Option x$4 = x$11.copy$default$4();
            ExprId x$5 = x$11.copy$default$5();
            return x$11.copy(x$2, (AggregateMode)x$1, x$3, x$4, x$5);
        }, Seq$.MODULE$.canBuildFrom());
        Seq aggregateAttributes = (Seq)aggregateExpressions.map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.resultAttribute(), Seq$.MODULE$.canBuildFrom());
        Seq x$6 = (Seq)groupingExpressions.$plus$plus(normalizedNamedDistinctExpressions, Seq$.MODULE$.canBuildFrom());
        Seq x$7 = aggregateExpressions;
        Seq x$8 = aggregateAttributes;
        Seq x$92 = (Seq)((TraversableLike)groupingAttributes.$plus$plus((GenTraversableOnce)distinctAttributes, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)aggregateExpressions.flatMap((Function1 & Serializable & scala.Serializable)x$13 -> x$13.aggregateFunction().inputAggBufferAttributes(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        SparkPlan x$102 = maySessionChild;
        Option<Seq<Expression>> x$112 = this.createAggregate$default$1();
        boolean x$122 = this.createAggregate$default$2();
        int x$132 = this.createAggregate$default$6();
        SparkPlan partialAggregate = this.createAggregate(x$112, x$122, (Seq<NamedExpression>)x$6, (Seq<AggregateExpression>)x$7, (Seq<Attribute>)x$8, x$132, (Seq<NamedExpression>)x$92, x$102);
        Seq aggregateExpressions2 = (Seq)functionsWithoutDistinct.map((Function1 & Serializable & scala.Serializable)x$14 -> {
            PartialMerge$ x$142 = PartialMerge$.MODULE$;
            AggregateFunction x$15 = x$14.copy$default$1();
            boolean x$16 = x$14.copy$default$3();
            Option x$17 = x$14.copy$default$4();
            ExprId x$18 = x$14.copy$default$5();
            return x$14.copy(x$15, (AggregateMode)x$142, x$16, x$17, x$18);
        }, Seq$.MODULE$.canBuildFrom());
        Seq aggregateAttributes2 = (Seq)aggregateExpressions2.map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.resultAttribute(), Seq$.MODULE$.canBuildFrom());
        Some x$192 = new Some(groupingAttributes.$plus$plus((GenTraversableOnce)distinctAttributes, Seq$.MODULE$.canBuildFrom()));
        Seq x$20 = (Seq)groupingAttributes.$plus$plus((GenTraversableOnce)distinctAttributes, Seq$.MODULE$.canBuildFrom());
        Seq x$212 = aggregateExpressions2;
        Seq x$222 = aggregateAttributes2;
        int x$232 = ((SeqLike)groupingAttributes.$plus$plus((GenTraversableOnce)distinctAttributes, Seq$.MODULE$.canBuildFrom())).length();
        Seq x$242 = (Seq)((TraversableLike)groupingAttributes.$plus$plus((GenTraversableOnce)distinctAttributes, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)aggregateExpressions2.flatMap((Function1 & Serializable & scala.Serializable)x$16 -> x$16.aggregateFunction().inputAggBufferAttributes(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        SparkPlan x$25 = partialAggregate;
        boolean x$26 = this.createAggregate$default$2();
        SparkPlan partialMergeAggregate = this.createAggregate((Option<Seq<Expression>>)x$192, x$26, (Seq<NamedExpression>)x$20, (Seq<AggregateExpression>)x$212, (Seq<Attribute>)x$222, x$232, (Seq<NamedExpression>)x$242, x$25);
        Map distinctColumnAttributeLookup = Utils$.MODULE$.toMap((Iterable)distinctExpressions.map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.canonicalized(), Seq$.MODULE$.canBuildFrom()), (Iterable)distinctAttributes);
        Seq rewrittenDistinctFunctions = (Seq)functionsWithDistinct.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            AggregateExpression aggregateExpression = x0$1;
            if (aggregateExpression != null) {
                AggregateFunction aggregateFunction = aggregateExpression.aggregateFunction();
                boolean bl = aggregateExpression.isDistinct();
                if (bl) {
                    return (AggregateFunction)aggregateFunction.transformDown((PartialFunction)new scala.Serializable(distinctColumnAttributeLookup){
                        public static final long serialVersionUID = 0L;
                        private final Map distinctColumnAttributeLookup$1;

                        public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            A1 A1;
                            A1 A12 = x1;
                            if (A12 != null && this.distinctColumnAttributeLookup$1.contains((Object)(A1 = A12).canonicalized())) {
                                return (B1)this.distinctColumnAttributeLookup$1.apply((Object)A1.canonicalized());
                            }
                            return (B1)function1.apply(x1);
                        }

                        public final boolean isDefinedAt(Expression x1) {
                            Expression expression;
                            Expression expression2 = x1;
                            return expression2 != null && this.distinctColumnAttributeLookup$1.contains((Object)(expression = expression2).canonicalized());
                        }
                        {
                            this.distinctColumnAttributeLookup$1 = distinctColumnAttributeLookup$1;
                        }
                    });
                }
            }
            throw new IllegalArgumentException(new StringBuilder(90).append("Non-distinct aggregate is found in functionsWithDistinct ").append("at planAggregateWithOneDistinct: ").append(aggregateExpression).toString());
        }, Seq$.MODULE$.canBuildFrom());
        Seq mergeAggregateExpressions = (Seq)functionsWithoutDistinct.map((Function1 & Serializable & scala.Serializable)x$18 -> {
            PartialMerge$ x$27 = PartialMerge$.MODULE$;
            AggregateFunction x$28 = x$18.copy$default$1();
            boolean x$29 = x$18.copy$default$3();
            Option x$30 = x$18.copy$default$4();
            ExprId x$31 = x$18.copy$default$5();
            return x$18.copy(x$28, (AggregateMode)x$27, x$29, x$30, x$31);
        }, Seq$.MODULE$.canBuildFrom());
        Seq mergeAggregateAttributes = (Seq)mergeAggregateExpressions.map((Function1 & Serializable & scala.Serializable)x$19 -> x$19.resultAttribute(), Seq$.MODULE$.canBuildFrom());
        Tuple2 tuple2 = ((GenericTraversableTemplate)((TraversableLike)rewrittenDistinctFunctions.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                AggregateFunction func = (AggregateFunction)tuple2._1();
                int i = tuple2._2$mcI$sp();
                AggregateExpression expr = AggregateExpression$.MODULE$.apply(func, (AggregateMode)Partial$.MODULE$, true, AggregateExpression$.MODULE$.apply$default$4());
                Attribute attr = ((AggregateExpression)functionsWithDistinct.apply(i)).resultAttribute();
                return new Tuple2((Object)expr, (Object)attr);
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom())).unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq distinctAggregateExpressions = (Seq)tuple2._1();
        Seq distinctAggregateAttributes = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)distinctAggregateExpressions, (Object)distinctAggregateAttributes);
        Seq distinctAggregateExpressions2 = (Seq)tuple22._1();
        Seq distinctAggregateAttributes2 = (Seq)tuple22._2();
        Seq partialAggregateResult = (Seq)((TraversableLike)groupingAttributes.$plus$plus((GenTraversableOnce)mergeAggregateExpressions.flatMap((Function1 & Serializable & scala.Serializable)x$21 -> x$21.aggregateFunction().inputAggBufferAttributes(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)distinctAggregateExpressions2.flatMap((Function1 & Serializable & scala.Serializable)x$22 -> x$22.aggregateFunction().inputAggBufferAttributes(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        Seq x$32 = groupingAttributes;
        Seq x$33 = (Seq)mergeAggregateExpressions.$plus$plus((GenTraversableOnce)distinctAggregateExpressions2, Seq$.MODULE$.canBuildFrom());
        Seq x$34 = (Seq)mergeAggregateAttributes.$plus$plus((GenTraversableOnce)distinctAggregateAttributes2, Seq$.MODULE$.canBuildFrom());
        int x$35 = ((SeqLike)groupingAttributes.$plus$plus((GenTraversableOnce)distinctAttributes, Seq$.MODULE$.canBuildFrom())).length();
        Seq x$36 = partialAggregateResult;
        SparkPlan x$37 = partialMergeAggregate;
        Option<Seq<Expression>> x$38 = this.createAggregate$default$1();
        boolean x$39 = this.createAggregate$default$2();
        SparkPlan partialDistinctAggregate = this.createAggregate(x$38, x$39, (Seq<NamedExpression>)x$32, (Seq<AggregateExpression>)x$33, (Seq<Attribute>)x$34, x$35, (Seq<NamedExpression>)x$36, x$37);
        Seq finalAggregateExpressions = (Seq)functionsWithoutDistinct.map((Function1 & Serializable & scala.Serializable)x$23 -> {
            Final$ x$40 = Final$.MODULE$;
            AggregateFunction x$41 = x$23.copy$default$1();
            boolean x$42 = x$23.copy$default$3();
            Option x$43 = x$23.copy$default$4();
            ExprId x$44 = x$23.copy$default$5();
            return x$23.copy(x$41, (AggregateMode)x$40, x$42, x$43, x$44);
        }, Seq$.MODULE$.canBuildFrom());
        Seq finalAggregateAttributes = (Seq)finalAggregateExpressions.map((Function1 & Serializable & scala.Serializable)x$24 -> x$24.resultAttribute(), Seq$.MODULE$.canBuildFrom());
        Tuple2 tuple23 = ((GenericTraversableTemplate)((TraversableLike)rewrittenDistinctFunctions.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                AggregateFunction func = (AggregateFunction)tuple2._1();
                int i = tuple2._2$mcI$sp();
                AggregateExpression expr = AggregateExpression$.MODULE$.apply(func, (AggregateMode)Final$.MODULE$, true, AggregateExpression$.MODULE$.apply$default$4());
                Attribute attr = ((AggregateExpression)functionsWithDistinct.apply(i)).resultAttribute();
                return new Tuple2((Object)expr, (Object)attr);
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom())).unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        Seq distinctAggregateExpressions3 = (Seq)tuple23._1();
        Seq distinctAggregateAttributes3 = (Seq)tuple23._2();
        Tuple2 tuple24 = new Tuple2((Object)distinctAggregateExpressions3, (Object)distinctAggregateAttributes3);
        Seq distinctAggregateExpressions4 = (Seq)tuple24._1();
        Seq distinctAggregateAttributes4 = (Seq)tuple24._2();
        Some x$45 = new Some((Object)groupingAttributes);
        Seq x$46 = groupingAttributes;
        Seq x$47 = (Seq)finalAggregateExpressions.$plus$plus((GenTraversableOnce)distinctAggregateExpressions4, Seq$.MODULE$.canBuildFrom());
        Seq x$48 = (Seq)finalAggregateAttributes.$plus$plus((GenTraversableOnce)distinctAggregateAttributes4, Seq$.MODULE$.canBuildFrom());
        int x$49 = groupingAttributes.length();
        Seq<NamedExpression> x$50 = resultExpressions;
        SparkPlan x$51 = partialDistinctAggregate;
        boolean x$52 = this.createAggregate$default$2();
        SparkPlan sparkPlan = finalAndCompleteAggregate = this.createAggregate((Option<Seq<Expression>>)x$45, x$52, (Seq<NamedExpression>)x$46, (Seq<AggregateExpression>)x$47, (Seq<Attribute>)x$48, x$49, x$50, x$51);
        return Nil$.MODULE$.$colon$colon((Object)sparkPlan);
    }

    public Seq<SparkPlan> planStreamingAggregation(Seq<NamedExpression> groupingExpressions, Seq<AggregateExpression> functionsWithoutDistinct, Seq<NamedExpression> resultExpressions, int stateFormatVersion, SparkPlan child) {
        SparkPlan finalAndCompleteAggregate;
        Seq groupingAttributes = (Seq)groupingExpressions.map((Function1 & Serializable & scala.Serializable)x$27 -> x$27.toAttribute(), Seq$.MODULE$.canBuildFrom());
        Seq aggregateExpressions = (Seq)functionsWithoutDistinct.map((Function1 & Serializable & scala.Serializable)x$28 -> {
            Partial$ x$1 = Partial$.MODULE$;
            AggregateFunction x$2 = x$28.copy$default$1();
            boolean x$3 = x$28.copy$default$3();
            Option x$4 = x$28.copy$default$4();
            ExprId x$5 = x$28.copy$default$5();
            return x$28.copy(x$2, (AggregateMode)x$1, x$3, x$4, x$5);
        }, Seq$.MODULE$.canBuildFrom());
        Seq aggregateAttributes = (Seq)aggregateExpressions.map((Function1 & Serializable & scala.Serializable)x$29 -> x$29.resultAttribute(), Seq$.MODULE$.canBuildFrom());
        Seq<NamedExpression> x$6 = groupingExpressions;
        Seq x$7 = aggregateExpressions;
        Seq x$8 = aggregateAttributes;
        Seq x$9 = (Seq)groupingAttributes.$plus$plus((GenTraversableOnce)aggregateExpressions.flatMap((Function1 & Serializable & scala.Serializable)x$30 -> x$30.aggregateFunction().inputAggBufferAttributes(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        SparkPlan x$10 = child;
        Option<Seq<Expression>> x$11 = this.createStreamingAggregate$default$1();
        int x$12 = this.createStreamingAggregate$default$5();
        SparkPlan partialAggregate = this.createStreamingAggregate(x$11, x$6, (Seq<AggregateExpression>)x$7, (Seq<Attribute>)x$8, x$12, (Seq<NamedExpression>)x$9, x$10);
        Seq aggregateExpressions2 = (Seq)functionsWithoutDistinct.map((Function1 & Serializable & scala.Serializable)x$31 -> {
            PartialMerge$ x$13 = PartialMerge$.MODULE$;
            AggregateFunction x$14 = x$31.copy$default$1();
            boolean x$15 = x$31.copy$default$3();
            Option x$16 = x$31.copy$default$4();
            ExprId x$17 = x$31.copy$default$5();
            return x$31.copy(x$14, (AggregateMode)x$13, x$15, x$16, x$17);
        }, Seq$.MODULE$.canBuildFrom());
        Seq aggregateAttributes2 = (Seq)aggregateExpressions2.map((Function1 & Serializable & scala.Serializable)x$32 -> x$32.resultAttribute(), Seq$.MODULE$.canBuildFrom());
        SparkPlan partialMerged1 = this.createStreamingAggregate((Option<Seq<Expression>>)new Some((Object)groupingAttributes), (Seq<NamedExpression>)groupingAttributes, (Seq<AggregateExpression>)aggregateExpressions2, (Seq<Attribute>)aggregateAttributes2, groupingAttributes.length(), (Seq<NamedExpression>)((Seq)groupingAttributes.$plus$plus((GenTraversableOnce)aggregateExpressions2.flatMap((Function1 & Serializable & scala.Serializable)x$33 -> x$33.aggregateFunction().inputAggBufferAttributes(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())), partialAggregate);
        StateStoreRestoreExec restored = new StateStoreRestoreExec((Seq<Attribute>)groupingAttributes, (Option<StatefulOperatorStateInfo>)None$.MODULE$, stateFormatVersion, partialMerged1);
        Seq aggregateExpressions3 = (Seq)functionsWithoutDistinct.map((Function1 & Serializable & scala.Serializable)x$34 -> {
            PartialMerge$ x$18 = PartialMerge$.MODULE$;
            AggregateFunction x$19 = x$34.copy$default$1();
            boolean x$20 = x$34.copy$default$3();
            Option x$21 = x$34.copy$default$4();
            ExprId x$22 = x$34.copy$default$5();
            return x$34.copy(x$19, (AggregateMode)x$18, x$20, x$21, x$22);
        }, Seq$.MODULE$.canBuildFrom());
        Seq aggregateAttributes3 = (Seq)aggregateExpressions3.map((Function1 & Serializable & scala.Serializable)x$35 -> x$35.resultAttribute(), Seq$.MODULE$.canBuildFrom());
        SparkPlan partialMerged2 = this.createStreamingAggregate((Option<Seq<Expression>>)new Some((Object)groupingAttributes), (Seq<NamedExpression>)groupingAttributes, (Seq<AggregateExpression>)aggregateExpressions3, (Seq<Attribute>)aggregateAttributes3, groupingAttributes.length(), (Seq<NamedExpression>)((Seq)groupingAttributes.$plus$plus((GenTraversableOnce)aggregateExpressions3.flatMap((Function1 & Serializable & scala.Serializable)x$36 -> x$36.aggregateFunction().inputAggBufferAttributes(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())), restored);
        StateStoreSaveExec saved = new StateStoreSaveExec((Seq<Attribute>)groupingAttributes, (Option<StatefulOperatorStateInfo>)None$.MODULE$, (Option<OutputMode>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, stateFormatVersion, partialMerged2);
        Seq finalAggregateExpressions = (Seq)functionsWithoutDistinct.map((Function1 & Serializable & scala.Serializable)x$37 -> {
            Final$ x$23 = Final$.MODULE$;
            AggregateFunction x$24 = x$37.copy$default$1();
            boolean x$25 = x$37.copy$default$3();
            Option x$26 = x$37.copy$default$4();
            ExprId x$27 = x$37.copy$default$5();
            return x$37.copy(x$24, (AggregateMode)x$23, x$25, x$26, x$27);
        }, Seq$.MODULE$.canBuildFrom());
        Seq finalAggregateAttributes = (Seq)finalAggregateExpressions.map((Function1 & Serializable & scala.Serializable)x$38 -> x$38.resultAttribute(), Seq$.MODULE$.canBuildFrom());
        SparkPlan sparkPlan = finalAndCompleteAggregate = this.createStreamingAggregate((Option<Seq<Expression>>)new Some((Object)groupingAttributes), (Seq<NamedExpression>)groupingAttributes, (Seq<AggregateExpression>)finalAggregateExpressions, (Seq<Attribute>)finalAggregateAttributes, groupingAttributes.length(), resultExpressions, saved);
        return Nil$.MODULE$.$colon$colon((Object)sparkPlan);
    }

    public Seq<SparkPlan> planStreamingAggregationForSession(Seq<NamedExpression> groupingExpressions, NamedExpression sessionExpression, Seq<AggregateExpression> functionsWithoutDistinct, Seq<NamedExpression> resultExpressions, int stateFormatVersion, boolean mergeSessionsInLocalPartition, SparkPlan child) {
        SparkPlan finalAndCompleteAggregate;
        SparkPlan sparkPlan;
        Seq groupWithoutSessionExpression = (Seq)groupingExpressions.filterNot((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)AggUtils$.$anonfun$planStreamingAggregationForSession$1(sessionExpression, p)));
        if (groupWithoutSessionExpression.isEmpty()) {
            throw new AnalysisException("Global aggregation with session window in streaming query is not supported.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7(), AnalysisException$.MODULE$.$lessinit$greater$default$8());
        }
        Seq groupingWithoutSessionAttributes = (Seq)groupWithoutSessionExpression.map((Function1 & Serializable & scala.Serializable)x$40 -> x$40.toAttribute(), Seq$.MODULE$.canBuildFrom());
        Seq groupingAttributes = (Seq)groupingExpressions.map((Function1 & Serializable & scala.Serializable)x$41 -> x$41.toAttribute(), Seq$.MODULE$.canBuildFrom());
        Seq aggregateExpressions = (Seq)functionsWithoutDistinct.map((Function1 & Serializable & scala.Serializable)x$42 -> {
            Partial$ x$1 = Partial$.MODULE$;
            AggregateFunction x$2 = x$42.copy$default$1();
            boolean x$3 = x$42.copy$default$3();
            Option x$4 = x$42.copy$default$4();
            ExprId x$5 = x$42.copy$default$5();
            return x$42.copy(x$2, (AggregateMode)x$1, x$3, x$4, x$5);
        }, Seq$.MODULE$.canBuildFrom());
        Seq aggregateAttributes = (Seq)aggregateExpressions.map((Function1 & Serializable & scala.Serializable)x$43 -> x$43.resultAttribute(), Seq$.MODULE$.canBuildFrom());
        Seq<NamedExpression> x$6 = groupingExpressions;
        Seq x$7 = aggregateExpressions;
        Seq x$8 = aggregateAttributes;
        Seq x$9 = (Seq)groupingAttributes.$plus$plus((GenTraversableOnce)aggregateExpressions.flatMap((Function1 & Serializable & scala.Serializable)x$44 -> x$44.aggregateFunction().inputAggBufferAttributes(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        SparkPlan x$10 = child;
        Option<Seq<Expression>> x$11 = this.createStreamingAggregate$default$1();
        int x$12 = this.createStreamingAggregate$default$5();
        SparkPlan partialAggregate = this.createStreamingAggregate(x$11, x$6, (Seq<AggregateExpression>)x$7, (Seq<Attribute>)x$8, x$12, (Seq<NamedExpression>)x$9, x$10);
        if (mergeSessionsInLocalPartition) {
            Seq aggregateExpressions2 = (Seq)functionsWithoutDistinct.map((Function1 & Serializable & scala.Serializable)x$45 -> {
                PartialMerge$ x$13 = PartialMerge$.MODULE$;
                AggregateFunction x$14 = x$45.copy$default$1();
                boolean x$15 = x$45.copy$default$3();
                Option x$16 = x$45.copy$default$4();
                ExprId x$17 = x$45.copy$default$5();
                return x$45.copy(x$14, (AggregateMode)x$13, x$15, x$16, x$17);
            }, Seq$.MODULE$.canBuildFrom());
            Seq aggregateAttributes2 = (Seq)aggregateExpressions2.map((Function1 & Serializable & scala.Serializable)x$46 -> x$46.resultAttribute(), Seq$.MODULE$.canBuildFrom());
            sparkPlan = new MergingSessionsExec((Option<Seq<Expression>>)None$.MODULE$, true, (Option<Object>)None$.MODULE$, (Seq<NamedExpression>)groupingAttributes, sessionExpression, (Seq<AggregateExpression>)aggregateExpressions2, (Seq<Attribute>)aggregateAttributes2, groupingAttributes.length(), (Seq<NamedExpression>)((Seq)groupingAttributes.$plus$plus((GenTraversableOnce)aggregateExpressions2.flatMap((Function1 & Serializable & scala.Serializable)x$47 -> x$47.aggregateFunction().inputAggBufferAttributes(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())), partialAggregate);
        } else {
            sparkPlan = partialAggregate;
        }
        SparkPlan partialMerged1 = sparkPlan;
        SessionWindowStateStoreRestoreExec restored = new SessionWindowStateStoreRestoreExec((Seq<Attribute>)groupingWithoutSessionAttributes, sessionExpression.toAttribute(), (Option<StatefulOperatorStateInfo>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, stateFormatVersion, partialMerged1);
        Seq aggregateExpressions3 = (Seq)functionsWithoutDistinct.map((Function1 & Serializable & scala.Serializable)x$48 -> {
            PartialMerge$ x$18 = PartialMerge$.MODULE$;
            AggregateFunction x$19 = x$48.copy$default$1();
            boolean x$20 = x$48.copy$default$3();
            Option x$21 = x$48.copy$default$4();
            ExprId x$22 = x$48.copy$default$5();
            return x$48.copy(x$19, (AggregateMode)x$18, x$20, x$21, x$22);
        }, Seq$.MODULE$.canBuildFrom());
        Seq aggregateAttributes3 = (Seq)aggregateExpressions3.map((Function1 & Serializable & scala.Serializable)x$49 -> x$49.resultAttribute(), Seq$.MODULE$.canBuildFrom());
        MergingSessionsExec mergedSessions = new MergingSessionsExec((Option<Seq<Expression>>)new Some((Object)groupingWithoutSessionAttributes), true, (Option<Object>)None$.MODULE$, (Seq<NamedExpression>)groupingAttributes, sessionExpression, (Seq<AggregateExpression>)aggregateExpressions3, (Seq<Attribute>)aggregateAttributes3, groupingAttributes.length(), (Seq<NamedExpression>)((Seq)groupingAttributes.$plus$plus((GenTraversableOnce)aggregateExpressions3.flatMap((Function1 & Serializable & scala.Serializable)x$50 -> x$50.aggregateFunction().inputAggBufferAttributes(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())), restored);
        SessionWindowStateStoreSaveExec saved = new SessionWindowStateStoreSaveExec((Seq<Attribute>)groupingWithoutSessionAttributes, sessionExpression.toAttribute(), (Option<StatefulOperatorStateInfo>)None$.MODULE$, (Option<OutputMode>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, stateFormatVersion, mergedSessions);
        Seq finalAggregateExpressions = (Seq)functionsWithoutDistinct.map((Function1 & Serializable & scala.Serializable)x$51 -> {
            Final$ x$23 = Final$.MODULE$;
            AggregateFunction x$24 = x$51.copy$default$1();
            boolean x$25 = x$51.copy$default$3();
            Option x$26 = x$51.copy$default$4();
            ExprId x$27 = x$51.copy$default$5();
            return x$51.copy(x$24, (AggregateMode)x$23, x$25, x$26, x$27);
        }, Seq$.MODULE$.canBuildFrom());
        Seq finalAggregateAttributes = (Seq)finalAggregateExpressions.map((Function1 & Serializable & scala.Serializable)x$52 -> x$52.resultAttribute(), Seq$.MODULE$.canBuildFrom());
        SparkPlan sparkPlan2 = finalAndCompleteAggregate = this.createStreamingAggregate((Option<Seq<Expression>>)new Some((Object)groupingWithoutSessionAttributes), (Seq<NamedExpression>)groupingAttributes, (Seq<AggregateExpression>)finalAggregateExpressions, (Seq<Attribute>)finalAggregateAttributes, groupingAttributes.length(), resultExpressions, saved);
        return Nil$.MODULE$.$colon$colon((Object)sparkPlan2);
    }

    private SparkPlan mayAppendUpdatingSessionExec(Seq<NamedExpression> groupingExpressions, SparkPlan maybeChildPlan, boolean isStreaming) {
        Option option = groupingExpressions.find((Function1 & Serializable & scala.Serializable)x$54 -> BoxesRunTime.boxToBoolean((boolean)AggUtils$.$anonfun$mayAppendUpdatingSessionExec$1(x$54)));
        if (option instanceof Some) {
            Some some = (Some)option;
            NamedExpression sessionExpression = (NamedExpression)some.value();
            return new UpdatingSessionsExec(isStreaming, (Option<Object>)None$.MODULE$, (Seq<Attribute>)((Seq)groupingExpressions.map((Function1 & Serializable & scala.Serializable)x$55 -> x$55.toAttribute(), Seq$.MODULE$.canBuildFrom())), sessionExpression.toAttribute(), maybeChildPlan);
        }
        if (None$.MODULE$.equals(option)) {
            return maybeChildPlan;
        }
        throw new MatchError((Object)option);
    }

    private boolean mayAppendUpdatingSessionExec$default$3() {
        return false;
    }

    private SparkPlan mayAppendMergingSessionExec(Seq<NamedExpression> groupingExpressions, Seq<AggregateExpression> aggregateExpressions, SparkPlan partialAggregate, boolean isStreaming) {
        Option option = groupingExpressions.find((Function1 & Serializable & scala.Serializable)x$56 -> BoxesRunTime.boxToBoolean((boolean)AggUtils$.$anonfun$mayAppendMergingSessionExec$1(x$56)));
        if (option instanceof Some) {
            Some some = (Some)option;
            NamedExpression sessionExpression = (NamedExpression)some.value();
            Seq aggExpressions = (Seq)aggregateExpressions.map((Function1 & Serializable & scala.Serializable)x$57 -> {
                PartialMerge$ x$1 = PartialMerge$.MODULE$;
                AggregateFunction x$2 = x$57.copy$default$1();
                boolean x$3 = x$57.copy$default$3();
                Option x$4 = x$57.copy$default$4();
                ExprId x$5 = x$57.copy$default$5();
                return x$57.copy(x$2, (AggregateMode)x$1, x$3, x$4, x$5);
            }, Seq$.MODULE$.canBuildFrom());
            Seq aggAttributes = (Seq)aggregateExpressions.map((Function1 & Serializable & scala.Serializable)x$58 -> x$58.resultAttribute(), Seq$.MODULE$.canBuildFrom());
            Seq groupingAttributes = (Seq)groupingExpressions.map((Function1 & Serializable & scala.Serializable)x$59 -> x$59.toAttribute(), Seq$.MODULE$.canBuildFrom());
            Seq groupingWithoutSessionExpressions = (Seq)groupingExpressions.diff((GenSeq)new .colon.colon((Object)sessionExpression, (List)Nil$.MODULE$));
            Seq groupingWithoutSessionsAttributes = (Seq)groupingWithoutSessionExpressions.map((Function1 & Serializable & scala.Serializable)x$60 -> x$60.toAttribute(), Seq$.MODULE$.canBuildFrom());
            return new MergingSessionsExec((Option<Seq<Expression>>)new Some((Object)groupingWithoutSessionsAttributes), isStreaming, (Option<Object>)None$.MODULE$, (Seq<NamedExpression>)groupingAttributes, sessionExpression, (Seq<AggregateExpression>)aggExpressions, (Seq<Attribute>)aggAttributes, groupingAttributes.length(), (Seq<NamedExpression>)((Seq)groupingAttributes.$plus$plus((GenTraversableOnce)aggExpressions.flatMap((Function1 & Serializable & scala.Serializable)x$61 -> x$61.aggregateFunction().inputAggBufferAttributes(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())), partialAggregate);
        }
        if (None$.MODULE$.equals(option)) {
            return partialAggregate;
        }
        throw new MatchError((Object)option);
    }

    private boolean mayAppendMergingSessionExec$default$4() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean forceApplySortAggregate(SQLConf conf) {
        if (!org.apache.spark.util.Utils$.MODULE$.isTesting()) return false;
        String string = conf.getConfString("spark.sql.test.forceApplySortAggregate", "false");
        String string2 = "true";
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$planStreamingAggregationForSession$1(NamedExpression sessionExpression$1, NamedExpression p) {
        return ((Expression)p).semanticEquals((Expression)sessionExpression$1);
    }

    public static final /* synthetic */ boolean $anonfun$mayAppendUpdatingSessionExec$1(NamedExpression x$54) {
        return x$54.metadata().contains(SessionWindow$.MODULE$.marker());
    }

    public static final /* synthetic */ boolean $anonfun$mayAppendMergingSessionExec$1(NamedExpression x$56) {
        return x$56.metadata().contains(SessionWindow$.MODULE$.marker());
    }

    private AggUtils$() {
        MODULE$ = this;
    }
}

