/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.IndexAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchIndexException;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.index.TableIndex;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.FieldReference$;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.jdbc.MySQLDialect;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MetadataBuilder;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

public final class MySQLDialect$
extends JdbcDialect
implements SQLConfHelper,
Product {
    public static MySQLDialect$ MODULE$;
    private final Set<String> org$apache$spark$sql$jdbc$MySQLDialect$$distinctUnsupportedAggregateFunctions;
    private final Set<String> supportedAggregateFunctions;
    private final Set<String> supportedFunctions;

    static {
        new MySQLDialect$();
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    @Override
    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:mysql");
    }

    public Set<String> org$apache$spark$sql$jdbc$MySQLDialect$$distinctUnsupportedAggregateFunctions() {
        return this.org$apache$spark$sql$jdbc$MySQLDialect$$distinctUnsupportedAggregateFunctions;
    }

    private Set<String> supportedAggregateFunctions() {
        return this.supportedAggregateFunctions;
    }

    private Set<String> supportedFunctions() {
        return this.supportedFunctions;
    }

    @Override
    public boolean isSupportedFunction(String funcName) {
        return this.supportedFunctions().contains((Object)funcName);
    }

    @Override
    public Option<String> compileExpression(Expression expr) {
        Some some;
        MySQLDialect.MySQLSQLBuilder mysqlSQLBuilder = new MySQLDialect.MySQLSQLBuilder();
        try {
            some = new Some((Object)mysqlSQLBuilder.build(expr));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error occurs while compiling V2 expression", e);
                some = None$.MODULE$;
            }
            throw throwable;
        }
        return some;
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        if (sqlType == -3 && typeName.equals("BIT") && size != 1) {
            md.putLong("binarylong", 1L);
            return Option$.MODULE$.apply((Object)LongType$.MODULE$);
        }
        if (sqlType == -7 && typeName.equals("TINYINT")) {
            return Option$.MODULE$.apply((Object)BooleanType$.MODULE$);
        }
        return None$.MODULE$;
    }

    @Override
    public String quoteIdentifier(String colName) {
        return new StringBuilder(2).append("`").append(colName).append("`").toString();
    }

    @Override
    public boolean schemasExists(Connection conn, JDBCOptions options, String schema) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.listSchemas(conn, options))).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MySQLDialect$.$anonfun$schemasExists$1(schema, x$1)));
    }

    @Override
    public String[][] listSchemas(Connection conn, JDBCOptions options) {
        ArrayBuilder schemaBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
        try {
            JdbcUtils$.MODULE$.executeQuery(conn, options, "SHOW SCHEMAS", (Function1<ResultSet, BoxedUnit>)(Function1 & Serializable & scala.Serializable)rs -> {
                MySQLDialect$.$anonfun$listSchemas$1(schemaBuilder, rs);
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception exception) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Cannot show schemas.");
        }
        return (String[][])schemaBuilder.result();
    }

    @Override
    public String getTableExistsQuery(String table) {
        return new StringBuilder(22).append("SELECT 1 FROM ").append(table).append(" LIMIT 1").toString();
    }

    @Override
    public Option<Object> isCascadingTruncateTable() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Override
    public String getUpdateColumnTypeQuery(String tableName, String columnName, String newDataType) {
        return new StringBuilder(28).append("ALTER TABLE ").append(tableName).append(" MODIFY COLUMN ").append(this.quoteIdentifier(columnName)).append(" ").append(newDataType).toString();
    }

    @Override
    public String getRenameColumnQuery(String tableName, String columnName, String newName, int dbMajorVersion) {
        if (dbMajorVersion >= 8) {
            return new StringBuilder(31).append("ALTER TABLE ").append(tableName).append(" RENAME COLUMN ").append(this.quoteIdentifier(columnName)).append(" TO").append(" ").append(this.quoteIdentifier(newName)).toString();
        }
        throw QueryExecutionErrors$.MODULE$.renameColumnUnsupportedForOlderMySQLError();
    }

    @Override
    public String getUpdateColumnNullabilityQuery(String tableName, String columnName, boolean isNullable) {
        throw QueryExecutionErrors$.MODULE$.unsupportedUpdateColumnNullabilityError();
    }

    @Override
    public String getTableCommentQuery(String table, String comment) {
        return new StringBuilder(25).append("ALTER TABLE ").append(table).append(" COMMENT = '").append(comment).append("'").toString();
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        DataType dataType = dt;
        if (FloatType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("FLOAT", 6));
        }
        return JdbcUtils$.MODULE$.getCommonJDBCType(dt);
    }

    @Override
    public String getSchemaCommentQuery(String schema, String comment) {
        throw QueryExecutionErrors$.MODULE$.unsupportedCreateNamespaceCommentError();
    }

    @Override
    public String removeSchemaCommentQuery(String schema) {
        throw QueryExecutionErrors$.MODULE$.unsupportedRemoveNamespaceCommentError();
    }

    @Override
    public String createIndex(String indexName, Identifier tableIdent, NamedReference[] columns, Map<NamedReference, Map<String, String>> columnsProperties, Map<String, String> properties) {
        String[] columnList = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])columns)).map((Function1 & Serializable & scala.Serializable)col -> MODULE$.quoteIdentifier((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])col.fieldNames())).head()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        Tuple2<String, String[]> tuple2 = JdbcUtils$.MODULE$.processIndexProperties(properties, "mysql");
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String indexType = (String)tuple2._1();
        String[] indexPropertyList = (String[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)indexType, (Object)indexPropertyList);
        String indexType2 = (String)tuple22._1();
        String[] indexPropertyList2 = (String[])tuple22._2();
        return new StringBuilder(22).append("CREATE INDEX ").append(this.quoteIdentifier(indexName)).append(" ").append(indexType2).append(" ON").append(" ").append(this.quoteIdentifier(tableIdent.name())).append(" (").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])columnList)).mkString(", ")).append(")").append(" ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])indexPropertyList2)).mkString(" ")).toString();
    }

    @Override
    public boolean indexExists(Connection conn, String indexName, Identifier tableIdent, JDBCOptions options) {
        String sql = new StringBuilder(38).append("SHOW INDEXES FROM ").append(this.quoteIdentifier(tableIdent.name())).append(" ").append("WHERE key_name = '").append(indexName).append("'").toString();
        return JdbcUtils$.MODULE$.checkIfIndexExists(conn, sql, options);
    }

    @Override
    public String dropIndex(String indexName, Identifier tableIdent) {
        return new StringBuilder(15).append("DROP INDEX ").append(this.quoteIdentifier(indexName)).append(" ON ").append(tableIdent.name()).toString();
    }

    @Override
    public TableIndex[] listIndexes(Connection conn, Identifier tableIdent, JDBCOptions options) {
        String sql = new StringBuilder(18).append("SHOW INDEXES FROM ").append(tableIdent.name()).toString();
        ObjectRef indexMap = ObjectRef.create((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        try {
            JdbcUtils$.MODULE$.executeQuery(conn, options, sql, (Function1<ResultSet, BoxedUnit>)(Function1 & Serializable & scala.Serializable)rs -> {
                MySQLDialect$.$anonfun$listIndexes$1(indexMap, rs);
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception exception) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Cannot retrieved index info.");
        }
        return (TableIndex[])((scala.collection.immutable.Map)indexMap.elem).values().toArray(ClassTag$.MODULE$.apply(TableIndex.class));
    }

    @Override
    public AnalysisException classifyException(String message, Throwable e) {
        Throwable throwable = e;
        if (throwable instanceof SQLException) {
            SQLException sQLException = (SQLException)throwable;
            int n = sQLException.getErrorCode();
            switch (n) {
                case 1061: {
                    Regex regex = new StringOps(Predef$.MODULE$.augmentString("(?s)Failed to create index (.*) in (.*)")).r();
                    String indexName = ((Regex.MatchData)regex.findFirstMatchIn((CharSequence)message).get()).group(1);
                    String tableName = ((Regex.MatchData)regex.findFirstMatchIn((CharSequence)message).get()).group(2);
                    throw new IndexAlreadyExistsException(indexName, tableName, (Option)new Some((Object)e));
                }
                case 1091: {
                    Regex regex = new StringOps(Predef$.MODULE$.augmentString("(?s)Failed to drop index (.*) in (.*)")).r();
                    String indexName = ((Regex.MatchData)regex.findFirstMatchIn((CharSequence)message).get()).group(1);
                    String tableName = ((Regex.MatchData)regex.findFirstMatchIn((CharSequence)message).get()).group(2);
                    throw new NoSuchIndexException(indexName, tableName, (Option)new Some((Object)e));
                }
            }
            return super.classifyException(message, e);
        }
        if (throwable instanceof UnsupportedOperationException) {
            UnsupportedOperationException unsupportedOperationException = (UnsupportedOperationException)throwable;
            throw unsupportedOperationException;
        }
        return super.classifyException(message, e);
    }

    @Override
    public String dropSchema(String schema, boolean cascade) {
        if (cascade) {
            return new StringBuilder(12).append("DROP SCHEMA ").append(this.quoteIdentifier(schema)).toString();
        }
        throw QueryExecutionErrors$.MODULE$.unsupportedDropNamespaceRestrictError();
    }

    public String productPrefix() {
        return "MySQLDialect";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MySQLDialect$;
    }

    public int hashCode() {
        return 1790277476;
    }

    public String toString() {
        return "MySQLDialect";
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$schemasExists$1(String schema$1, String[] x$1) {
        Object object = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$1)).head();
        String string = schema$1;
        return !(object != null ? !object.equals(string) : string != null);
    }

    public static final /* synthetic */ void $anonfun$listSchemas$1(ArrayBuilder schemaBuilder$1, ResultSet rs) {
        while (rs.next()) {
            schemaBuilder$1.$plus$eq((Object)new String[]{rs.getString("Database")});
        }
    }

    public static final /* synthetic */ void $anonfun$listIndexes$1(ObjectRef indexMap$1, ResultSet rs) {
        while (rs.next()) {
            String indexName = rs.getString("key_name");
            String colName = rs.getString("column_name");
            String indexType = rs.getString("index_type");
            String indexComment = rs.getString("index_comment");
            if (((scala.collection.immutable.Map)indexMap$1.elem).contains((Object)indexName)) {
                TableIndex index = (TableIndex)((scala.collection.immutable.Map)indexMap$1.elem).get((Object)indexName).get();
                TableIndex newIndex = new TableIndex(indexName, indexType, (NamedReference[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])index.columns())).$colon$plus((Object)FieldReference$.MODULE$.apply(colName), ClassTag$.MODULE$.apply(NamedReference.class)), index.columnProperties(), index.properties());
                indexMap$1.elem = ((scala.collection.immutable.Map)indexMap$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)indexName), (Object)newIndex));
                continue;
            }
            Properties properties = new Properties();
            Object object = new StringOps(Predef$.MODULE$.augmentString(indexComment)).nonEmpty() ? properties.put("COMMENT", indexComment) : BoxedUnit.UNIT;
            TableIndex index = new TableIndex(indexName, indexType, (NamedReference[])((Object[])new NamedReference[]{FieldReference$.MODULE$.apply(colName)}), new HashMap(), properties);
            indexMap$1.elem = ((scala.collection.immutable.Map)indexMap$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)indexName), (Object)index));
        }
    }

    private MySQLDialect$() {
        MODULE$ = this;
        SQLConfHelper.$init$((SQLConfHelper)this);
        Product.$init$((Product)this);
        this.org$apache$spark$sql$jdbc$MySQLDialect$$distinctUnsupportedAggregateFunctions = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"VAR_POP", "VAR_SAMP", "STDDEV_POP", "STDDEV_SAMP"}));
        this.supportedAggregateFunctions = (Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MAX", "MIN", "SUM", "COUNT", "AVG"}))).$plus$plus(this.org$apache$spark$sql$jdbc$MySQLDialect$$distinctUnsupportedAggregateFunctions());
        this.supportedFunctions = this.supportedAggregateFunctions();
    }
}

