/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar.compression;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.columnar.ByteBufferHelper$;
import org.apache.spark.sql.execution.columnar.ColumnType;
import org.apache.spark.sql.execution.columnar.NativeColumnType;
import org.apache.spark.sql.execution.columnar.compression.PassThrough$;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.ShortType;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\rsAB\u0013'\u0011\u0003CCG\u0002\u00047M!\u0005\u0005f\u000e\u0005\u0006\u000f\u0006!\t!\u0013\u0005\b\u0015\u0006\u0011\r\u0011\"\u0011L\u0011\u0019y\u0015\u0001)A\u0005\u0019\")\u0001+\u0001C!#\")q-\u0001C!Q\"9\u00111F\u0001\u0005B\u00055b\u0001\u00027\u0002\u00015D\u0001B\u0016\u0005\u0003\u0002\u0003\u0006Ia\u001f\u0005\u0006\u000f\"!\tA \u0005\u0007\u0003\u0007AA\u0011I&\t\r\u0005\u0015\u0001\u0002\"\u0011L\u0011\u001d\t9\u0001\u0003C!\u0003\u00131a!a\r\u0002\u0001\u0005U\u0002BCA!\u001d\t\u0005\t\u0015!\u0003\u0002\f!IaK\u0004B\u0001B\u0003%\u00111\t\u0005\u0007\u000f:!\t!!\u0012\t\u000f\u00055c\u0002\"\u0011\u0002P!9\u00111\u000e\b\u0005B\u00055\u0004bBA8\u001d\u0011%\u0011\u0011\u000f\u0005\b\u0003\u001fsA\u0011BAI\u0011\u001d\tYJ\u0004C\u0005\u0003;Cq!a*\u000f\t\u0013\tI\u000bC\u0004\u00024:!I!!.\t\u000f\u0005}f\u0002\"\u0003\u0002B\"9\u00111\u001a\b\u0005\n\u00055\u0007bBAl\u001d\u0011%\u0011\u0011\u001c\u0005\b\u0003_tA\u0011IAy\u0011%\u0011\t!AA\u0001\n\u0003\u0012\u0019\u0001\u0003\u0005\u0003\u0012\u0005\t\t\u0011\"\u0001L\u0011%\u0011\u0019\"AA\u0001\n\u0003\u0011)\u0002C\u0005\u0003\u001c\u0005\t\t\u0011\"\u0011\u0003\u001e!I!1F\u0001\u0002\u0002\u0013\u0005!Q\u0006\u0005\n\u0005c\t\u0011\u0011!C!\u0005gA\u0011B!\u000e\u0002\u0003\u0003%\tEa\u000e\t\u0013\te\u0012!!A\u0005\n\tm\u0012a\u0003)bgN$\u0006N]8vO\"T!a\n\u0015\u0002\u0017\r|W\u000e\u001d:fgNLwN\u001c\u0006\u0003S)\n\u0001bY8mk6t\u0017M\u001d\u0006\u0003W1\n\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u00055r\u0013aA:rY*\u0011q\u0006M\u0001\u0006gB\f'o\u001b\u0006\u0003cI\na!\u00199bG\",'\"A\u001a\u0002\u0007=\u0014x\r\u0005\u00026\u00035\taEA\u0006QCN\u001cH\u000b\u001b:pk\u001eD7#B\u00019}\u0005#\u0005CA\u001d=\u001b\u0005Q$\"A\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uR$AB!osJ+g\r\u0005\u00026\u007f%\u0011\u0001I\n\u0002\u0012\u0007>l\u0007O]3tg&|gnU2iK6,\u0007CA\u001dC\u0013\t\u0019%HA\u0004Qe>$Wo\u0019;\u0011\u0005e*\u0015B\u0001$;\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0019a\u0014N\\5u}\r\u0001A#\u0001\u001b\u0002\rQL\b/Z%e+\u0005a\u0005CA\u001dN\u0013\tq%HA\u0002J]R\fq\u0001^=qK&#\u0007%\u0001\u0005tkB\u0004xN\u001d;t)\t\u0011V\u000b\u0005\u0002:'&\u0011AK\u000f\u0002\b\u0005>|G.Z1o\u0011\u00151V\u00011\u0001X\u0003)\u0019w\u000e\\;n]RK\b/\u001a\u0019\u00031z\u00032!\u0017.]\u001b\u0005A\u0013BA.)\u0005)\u0019u\u000e\\;n]RK\b/\u001a\t\u0003;zc\u0001\u0001B\u0005`+\u0006\u0005\t\u0011!B\u0001A\n\u0019q\fJ\u0019\u0012\u0005\u0005$\u0007CA\u001dc\u0013\t\u0019'HA\u0004O_RD\u0017N\\4\u0011\u0005e*\u0017B\u00014;\u0005\r\te._\u0001\bK:\u001cw\u000eZ3s+\rI\u0017Q\u0005\u000b\u0004U\u0006\u001d\u0002\u0003B6\t\u0003Gi\u0011!\u0001\u0002\b\u000b:\u001cw\u000eZ3s+\tq'oE\u0002\tq=\u00042!\u000e9r\u0013\tag\u0005\u0005\u0002^e\u0012)1\u000f\u0003b\u0001i\n\tA+\u0005\u0002bkB\u0011a/_\u0007\u0002o*\u0011\u0001\u0010L\u0001\u0006if\u0004Xm]\u0005\u0003u^\u0014!\"\u0011;p[&\u001cG+\u001f9f!\rIF0]\u0005\u0003{\"\u0012\u0001CT1uSZ,7i\u001c7v[:$\u0016\u0010]3\u0015\u0007}\f\t\u0001E\u0002l\u0011EDQA\u0016\u0006A\u0002m\f\u0001#\u001e8d_6\u0004(/Z:tK\u0012\u001c\u0016N_3\u0002\u001d\r|W\u000e\u001d:fgN,GmU5{K\u0006A1m\\7qe\u0016\u001c8\u000f\u0006\u0004\u0002\f\u0005m\u0011q\u0004\t\u0005\u0003\u001b\t9\"\u0004\u0002\u0002\u0010)!\u0011\u0011CA\n\u0003\rq\u0017n\u001c\u0006\u0003\u0003+\tAA[1wC&!\u0011\u0011DA\b\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\b\u0003;i\u0001\u0019AA\u0006\u0003\u00111'o\\7\t\u000f\u0005\u0005R\u00021\u0001\u0002\f\u0005\u0011Ao\u001c\t\u0004;\u0006\u0015B!B:\u0007\u0005\u0004!\bB\u0002,\u0007\u0001\u0004\tI\u0003\u0005\u0003Zy\u0006\r\u0012a\u00023fG>$WM]\u000b\u0005\u0003_\tI\u0010\u0006\u0004\u00022\u0005m\u0018Q \t\u0005W:\t9PA\u0004EK\u000e|G-\u001a:\u0016\t\u0005]\u0012qH\n\u0005\u001da\nI\u0004E\u00036\u0003w\ti$C\u0002\u00024\u0019\u00022!XA \t\u0015\u0019hB1\u0001u\u0003\u0019\u0011WO\u001a4feB!\u0011\f`A\u001f)\u0019\t9%!\u0013\u0002LA!1NDA\u001f\u0011\u001d\t\t%\u0005a\u0001\u0003\u0017AaAV\tA\u0002\u0005\r\u0013\u0001\u00028fqR$b!!\u0015\u0002X\u0005\u001d\u0004cA\u001d\u0002T%\u0019\u0011Q\u000b\u001e\u0003\tUs\u0017\u000e\u001e\u0005\b\u00033\u0012\u0002\u0019AA.\u0003\r\u0011xn\u001e\t\u0005\u0003;\n\u0019'\u0004\u0002\u0002`)\u0019\u0011\u0011\r\u0017\u0002\u0011\r\fG/\u00197zgRLA!!\u001a\u0002`\tY\u0011J\u001c;fe:\fGNU8x\u0011\u0019\tIG\u0005a\u0001\u0019\u00069qN\u001d3j]\u0006d\u0017a\u00025bg:+\u0007\u0010^\u000b\u0002%\u0006Y\u0001/\u001e;C_>dW-\u00198t))\t\t&a\u001d\u0002\u0004\u0006\u001d\u00151\u0012\u0005\b\u0003k\"\u0002\u0019AA<\u00031\u0019w\u000e\\;n]Z+7\r^8s!\u0011\tI(a \u000e\u0005\u0005m$bAA?U\u0005Qa/Z2u_JL'0\u001a3\n\t\u0005\u0005\u00151\u0010\u0002\u0015/JLG/\u00192mK\u000e{G.^7o-\u0016\u001cGo\u001c:\t\r\u0005\u0015E\u00031\u0001M\u0003\r\u0001xn\u001d\u0005\u0007\u0003\u0013#\u0002\u0019\u0001'\u0002\u0013\t,hMZ3s!>\u001c\bBBAG)\u0001\u0007A*A\u0002mK:\f\u0001\u0002];u\u0005f$Xm\u001d\u000b\u000b\u0003#\n\u0019*!&\u0002\u0018\u0006e\u0005bBA;+\u0001\u0007\u0011q\u000f\u0005\u0007\u0003\u000b+\u0002\u0019\u0001'\t\r\u0005%U\u00031\u0001M\u0011\u0019\ti)\u0006a\u0001\u0019\u0006I\u0001/\u001e;TQ>\u0014Ho\u001d\u000b\u000b\u0003#\ny*!)\u0002$\u0006\u0015\u0006bBA;-\u0001\u0007\u0011q\u000f\u0005\u0007\u0003\u000b3\u0002\u0019\u0001'\t\r\u0005%e\u00031\u0001M\u0011\u0019\tiI\u0006a\u0001\u0019\u00069\u0001/\u001e;J]R\u001cHCCA)\u0003W\u000bi+a,\u00022\"9\u0011QO\fA\u0002\u0005]\u0004BBAC/\u0001\u0007A\n\u0003\u0004\u0002\n^\u0001\r\u0001\u0014\u0005\u0007\u0003\u001b;\u0002\u0019\u0001'\u0002\u0011A,H\u000fT8oON$\"\"!\u0015\u00028\u0006e\u00161XA_\u0011\u001d\t)\b\u0007a\u0001\u0003oBa!!\"\u0019\u0001\u0004a\u0005BBAE1\u0001\u0007A\n\u0003\u0004\u0002\u000eb\u0001\r\u0001T\u0001\naV$h\t\\8biN$\"\"!\u0015\u0002D\u0006\u0015\u0017qYAe\u0011\u001d\t)(\u0007a\u0001\u0003oBa!!\"\u001a\u0001\u0004a\u0005BBAE3\u0001\u0007A\n\u0003\u0004\u0002\u000ef\u0001\r\u0001T\u0001\u000baV$Hi\\;cY\u0016\u001cHCCA)\u0003\u001f\f\t.a5\u0002V\"9\u0011Q\u000f\u000eA\u0002\u0005]\u0004BBAC5\u0001\u0007A\n\u0003\u0004\u0002\nj\u0001\r\u0001\u0014\u0005\u0007\u0003\u001bS\u0002\u0019\u0001'\u0002\u0017\u0011,7m\\7qe\u0016\u001c8\u000f\r\u000b\u000b\u0003#\nY.!8\u0002b\u0006\u0015\bbBA;7\u0001\u0007\u0011q\u000f\u0005\u0007\u0003?\\\u0002\u0019\u0001'\u0002\u0011\r\f\u0007/Y2jifDa!a9\u001c\u0001\u0004a\u0015\u0001C;oSR\u001c\u0016N_3\t\u000f\u0005\u001d8\u00041\u0001\u0002j\u0006Y\u0001/\u001e;Gk:\u001cG/[8o!)I\u00141^A<\u00192c\u0015\u0011K\u0005\u0004\u0003[T$!\u0003$v]\u000e$\u0018n\u001c85\u0003)!WmY8naJ,7o\u001d\u000b\u0007\u0003#\n\u00190!>\t\u000f\u0005UD\u00041\u0001\u0002x!1\u0011q\u001c\u000fA\u00021\u00032!XA}\t\u0015\u0019xA1\u0001u\u0011\u001d\t\te\u0002a\u0001\u0003\u0017AaAV\u0004A\u0002\u0005}\b\u0003B-}\u0003o\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001B\u0003!\u0011\u00119A!\u0004\u000e\u0005\t%!\u0002\u0002B\u0006\u0003'\tA\u0001\\1oO&!!q\u0002B\u0005\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$Hc\u00013\u0003\u0018!A!\u0011D\u0010\u0002\u0002\u0003\u0007A*A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005?\u0001RA!\t\u0003(\u0011l!Aa\t\u000b\u0007\t\u0015\"(\u0001\u0006d_2dWm\u0019;j_:LAA!\u000b\u0003$\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\r\u0011&q\u0006\u0005\t\u00053\t\u0013\u0011!a\u0001I\u0006A\u0001.Y:i\u0007>$W\rF\u0001M\u0003!!xn\u0015;sS:<GC\u0001B\u0003\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\tu\u0002\u0003\u0002B\u0004\u0005\u007fIAA!\u0011\u0003\n\t1qJ\u00196fGR\u0004")
public final class PassThrough {
    public static String toString() {
        return PassThrough$.MODULE$.toString();
    }

    public static int hashCode() {
        return PassThrough$.MODULE$.hashCode();
    }

    public static boolean canEqual(Object object) {
        return PassThrough$.MODULE$.canEqual(object);
    }

    public static Iterator<Object> productIterator() {
        return PassThrough$.MODULE$.productIterator();
    }

    public static Object productElement(int n) {
        return PassThrough$.MODULE$.productElement(n);
    }

    public static int productArity() {
        return PassThrough$.MODULE$.productArity();
    }

    public static String productPrefix() {
        return PassThrough$.MODULE$.productPrefix();
    }

    public static <T extends AtomicType> Decoder<T> decoder(ByteBuffer byteBuffer, NativeColumnType<T> nativeColumnType) {
        return PassThrough$.MODULE$.decoder(byteBuffer, (NativeColumnType)nativeColumnType);
    }

    public static <T extends AtomicType> Encoder<T> encoder(NativeColumnType<T> nativeColumnType) {
        return PassThrough$.MODULE$.encoder((NativeColumnType)nativeColumnType);
    }

    public static boolean supports(ColumnType<?> columnType) {
        return PassThrough$.MODULE$.supports(columnType);
    }

    public static int typeId() {
        return PassThrough$.MODULE$.typeId();
    }

    public static class Decoder<T extends AtomicType>
    implements org.apache.spark.sql.execution.columnar.compression.Decoder<T> {
        private final ByteBuffer buffer;
        private final NativeColumnType<T> columnType;

        @Override
        public void next(InternalRow row, int ordinal) {
            this.columnType.extract(this.buffer, row, ordinal);
        }

        @Override
        public boolean hasNext() {
            return this.buffer.hasRemaining();
        }

        private void putBooleans(WritableColumnVector columnVector, int pos, int bufferPos, int len) {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> columnVector.putBoolean(pos + i, $this.buffer.get(bufferPos + i) != 0));
        }

        private void putBytes(WritableColumnVector columnVector, int pos, int bufferPos, int len) {
            columnVector.putBytes(pos, len, this.buffer.array(), bufferPos);
        }

        private void putShorts(WritableColumnVector columnVector, int pos, int bufferPos, int len) {
            columnVector.putShorts(pos, len, this.buffer.array(), bufferPos);
        }

        private void putInts(WritableColumnVector columnVector, int pos, int bufferPos, int len) {
            columnVector.putInts(pos, len, this.buffer.array(), bufferPos);
        }

        private void putLongs(WritableColumnVector columnVector, int pos, int bufferPos, int len) {
            columnVector.putLongs(pos, len, this.buffer.array(), bufferPos);
        }

        private void putFloats(WritableColumnVector columnVector, int pos, int bufferPos, int len) {
            columnVector.putFloats(pos, len, this.buffer.array(), bufferPos);
        }

        private void putDoubles(WritableColumnVector columnVector, int pos, int bufferPos, int len) {
            columnVector.putDoubles(pos, len, this.buffer.array(), bufferPos);
        }

        private void decompress0(WritableColumnVector columnVector, int capacity, int unitSize, Function4<WritableColumnVector, Object, Object, Object, BoxedUnit> putFunction) {
            ByteBuffer nullsBuffer = this.buffer.duplicate().order(ByteOrder.nativeOrder());
            nullsBuffer.rewind();
            int nullCount = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
            int nextNullIndex = nullCount > 0 ? ByteBufferHelper$.MODULE$.getInt(nullsBuffer) : capacity;
            int pos = 0;
            int seenNulls = 0;
            int bufferPos = this.buffer.position();
            while (pos < capacity) {
                if (pos != nextNullIndex) {
                    int len = nextNullIndex - pos;
                    Predef$.MODULE$.assert((long)len * (long)unitSize < Integer.MAX_VALUE);
                    putFunction.apply((Object)columnVector, (Object)BoxesRunTime.boxToInteger((int)pos), (Object)BoxesRunTime.boxToInteger((int)bufferPos), (Object)BoxesRunTime.boxToInteger((int)len));
                    bufferPos += len * unitSize;
                    pos += len;
                    continue;
                }
                nextNullIndex = ++seenNulls < nullCount ? ByteBufferHelper$.MODULE$.getInt(nullsBuffer) : capacity;
                columnVector.putNull(pos);
                ++pos;
            }
        }

        @Override
        public void decompress(WritableColumnVector columnVector2, int capacity) {
            T t = this.columnType.dataType();
            if (t instanceof BooleanType) {
                int unitSize = 1;
                this.decompress0(columnVector2, capacity, unitSize, (Function4<WritableColumnVector, Object, Object, Object, BoxedUnit>)(Function4 & Serializable & scala.Serializable)(columnVector, pos, bufferPos, len) -> {
                    this.putBooleans(columnVector, BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToInt((Object)bufferPos), BoxesRunTime.unboxToInt((Object)len));
                    return BoxedUnit.UNIT;
                });
                return;
            }
            if (t instanceof ByteType) {
                int unitSize = 1;
                this.decompress0(columnVector2, capacity, unitSize, (Function4<WritableColumnVector, Object, Object, Object, BoxedUnit>)(Function4 & Serializable & scala.Serializable)(columnVector, pos, bufferPos, len) -> {
                    this.putBytes(columnVector, BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToInt((Object)bufferPos), BoxesRunTime.unboxToInt((Object)len));
                    return BoxedUnit.UNIT;
                });
                return;
            }
            if (t instanceof ShortType) {
                int unitSize = 2;
                this.decompress0(columnVector2, capacity, unitSize, (Function4<WritableColumnVector, Object, Object, Object, BoxedUnit>)(Function4 & Serializable & scala.Serializable)(columnVector, pos, bufferPos, len) -> {
                    this.putShorts(columnVector, BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToInt((Object)bufferPos), BoxesRunTime.unboxToInt((Object)len));
                    return BoxedUnit.UNIT;
                });
                return;
            }
            if (t instanceof IntegerType) {
                int unitSize = 4;
                this.decompress0(columnVector2, capacity, unitSize, (Function4<WritableColumnVector, Object, Object, Object, BoxedUnit>)(Function4 & Serializable & scala.Serializable)(columnVector, pos, bufferPos, len) -> {
                    this.putInts(columnVector, BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToInt((Object)bufferPos), BoxesRunTime.unboxToInt((Object)len));
                    return BoxedUnit.UNIT;
                });
                return;
            }
            if (t instanceof LongType) {
                int unitSize = 8;
                this.decompress0(columnVector2, capacity, unitSize, (Function4<WritableColumnVector, Object, Object, Object, BoxedUnit>)(Function4 & Serializable & scala.Serializable)(columnVector, pos, bufferPos, len) -> {
                    this.putLongs(columnVector, BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToInt((Object)bufferPos), BoxesRunTime.unboxToInt((Object)len));
                    return BoxedUnit.UNIT;
                });
                return;
            }
            if (t instanceof FloatType) {
                int unitSize = 4;
                this.decompress0(columnVector2, capacity, unitSize, (Function4<WritableColumnVector, Object, Object, Object, BoxedUnit>)(Function4 & Serializable & scala.Serializable)(columnVector, pos, bufferPos, len) -> {
                    this.putFloats(columnVector, BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToInt((Object)bufferPos), BoxesRunTime.unboxToInt((Object)len));
                    return BoxedUnit.UNIT;
                });
                return;
            }
            if (t instanceof DoubleType) {
                int unitSize = 8;
                this.decompress0(columnVector2, capacity, unitSize, (Function4<WritableColumnVector, Object, Object, Object, BoxedUnit>)(Function4 & Serializable & scala.Serializable)(columnVector, pos, bufferPos, len) -> {
                    this.putDoubles(columnVector, BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToInt((Object)bufferPos), BoxesRunTime.unboxToInt((Object)len));
                    return BoxedUnit.UNIT;
                });
                return;
            }
            throw new MatchError(t);
        }

        public Decoder(ByteBuffer buffer, NativeColumnType<T> columnType) {
            this.buffer = buffer;
            this.columnType = columnType;
        }
    }

    public static class Encoder<T extends AtomicType>
    implements org.apache.spark.sql.execution.columnar.compression.Encoder<T> {
        @Override
        public void gatherCompressibilityStats(InternalRow row, int ordinal) {
            org.apache.spark.sql.execution.columnar.compression.Encoder.gatherCompressibilityStats$(this, row, ordinal);
        }

        @Override
        public double compressionRatio() {
            return org.apache.spark.sql.execution.columnar.compression.Encoder.compressionRatio$(this);
        }

        @Override
        public int uncompressedSize() {
            return 0;
        }

        @Override
        public int compressedSize() {
            return 0;
        }

        @Override
        public ByteBuffer compress(ByteBuffer from, ByteBuffer to) {
            to.putInt(PassThrough$.MODULE$.typeId()).put(from).rewind();
            return to;
        }

        public Encoder(NativeColumnType<T> columnType) {
            org.apache.spark.sql.execution.columnar.compression.Encoder.$init$(this);
        }
    }
}

