/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Locale;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkUpgradeException;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogUtils$;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.AttributeSet$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionSet$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.util.RebaseDateTime;
import org.apache.spark.sql.catalyst.util.RebaseDateTime$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOptions$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.package$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.util.Utils$;
import org.json4s.Formats;
import org.json4s.NoTypeHints$;
import org.json4s.TypeHints;
import org.json4s.jackson.Serialization$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenSetLike;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class DataSourceUtils$
implements PredicateHelper {
    public static DataSourceUtils$ MODULE$;
    private final String PARTITIONING_COLUMNS_KEY;
    private final String PARTITION_OVERWRITE_MODE;
    private final Formats formats;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new DataSourceUtils$();
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$((PredicateHelper)this, expressions, op);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$((PredicateHelper)this, (Expression)expr);
    }

    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$((PredicateHelper)this, output, nonNullAttrExprIds);
    }

    public boolean isLikelySelective(Expression e) {
        return PredicateHelper.isLikelySelective$((PredicateHelper)this, (Expression)e);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String PARTITIONING_COLUMNS_KEY() {
        return this.PARTITIONING_COLUMNS_KEY;
    }

    public String PARTITION_OVERWRITE_MODE() {
        return this.PARTITION_OVERWRITE_MODE;
    }

    private Formats formats() {
        return this.formats;
    }

    public String encodePartitioningColumns(Seq<String> columns) {
        return Serialization$.MODULE$.write(columns, this.formats());
    }

    public Seq<String> decodePartitioningColumns(String str) {
        return (Seq)Serialization$.MODULE$.read(str, this.formats(), ManifestFactory$.MODULE$.classType(Seq.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
    }

    public void checkFieldNames(FileFormat format, StructType schema) {
        schema.foreach((Function1 & Serializable & scala.Serializable)field -> {
            DataSourceUtils$.$anonfun$checkFieldNames$1(format, field);
            return BoxedUnit.UNIT;
        });
    }

    public void verifySchema(FileFormat format, StructType schema) {
        schema.foreach((Function1 & Serializable & scala.Serializable)field -> {
            DataSourceUtils$.$anonfun$verifySchema$1(format, field);
            return BoxedUnit.UNIT;
        });
    }

    public boolean isDataPath(Path path) {
        return this.isDataFile(path.getName());
    }

    public boolean isDataFile(String fileName) {
        return !fileName.startsWith("_") && !fileName.startsWith(".");
    }

    public boolean supportNestedPredicatePushdown(BaseRelation relation) {
        BaseRelation baseRelation = relation;
        if (baseRelation instanceof HadoopFsRelation) {
            HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)baseRelation;
            Seq supportedDatasources = Utils$.MODULE$.stringToSeq(((String)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.NESTED_PREDICATE_PUSHDOWN_FILE_SOURCE_LIST())).toLowerCase(Locale.ROOT));
            return supportedDatasources.contains((Object)hadoopFsRelation.toString());
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private RebaseDateTime.RebaseSpec getRebaseSpec(Function1<String, String> lookupFileMeta, String modeByConfig, String minVersion, String metadataKey) {
        if (!Utils$.MODULE$.isTesting()) ** GOTO lbl-1000
        v0 = SQLConf$.MODULE$.get().getConfString("spark.test.forceNoRebase", "");
        var7_5 = "true";
        if (!(v0 != null ? v0.equals(var7_5) == false : var7_5 != null)) {
            v1 = SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED();
        } else lbl-1000:
        // 2 sources

        {
            v1 = (Enumeration.Value)Option$.MODULE$.apply(lookupFileMeta.apply((Object)package$.MODULE$.SPARK_VERSION_METADATA_KEY())).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$getRebaseSpec$1(java.lang.String scala.Function1 java.lang.String java.lang.String ), (Ljava/lang/String;)Lscala/Enumeration$Value;)((String)minVersion, lookupFileMeta, (String)metadataKey)).getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$getRebaseSpec$2(java.lang.String ), ()Lscala/Enumeration$Value;)((String)modeByConfig));
        }
        var8_7 = policy = v1;
        v2 = SQLConf.LegacyBehaviorPolicy$.MODULE$.LEGACY();
        var9_8 = var8_7;
        if (!(v2 != null ? v2.equals(var9_8) == false : var9_8 != null)) {
            return new RebaseDateTime.RebaseSpec(SQLConf.LegacyBehaviorPolicy$.MODULE$.LEGACY(), Option$.MODULE$.apply(lookupFileMeta.apply((Object)package$.MODULE$.SPARK_TIMEZONE_METADATA_KEY())));
        }
        return new RebaseDateTime.RebaseSpec(policy, RebaseDateTime.RebaseSpec$.MODULE$.apply$default$2());
    }

    public RebaseDateTime.RebaseSpec datetimeRebaseSpec(Function1<String, String> lookupFileMeta, String modeByConfig) {
        return this.getRebaseSpec(lookupFileMeta, modeByConfig, "3.0.0", package$.MODULE$.SPARK_LEGACY_DATETIME_METADATA_KEY());
    }

    public RebaseDateTime.RebaseSpec int96RebaseSpec(Function1<String, String> lookupFileMeta, String modeByConfig) {
        return this.getRebaseSpec(lookupFileMeta, modeByConfig, "3.1.0", package$.MODULE$.SPARK_LEGACY_INT96_METADATA_KEY());
    }

    public SparkUpgradeException newRebaseExceptionInRead(String format) {
        Tuple2 tuple2;
        String string = format;
        if ("Parquet INT96".equals(string)) {
            tuple2 = new Tuple2((Object)SQLConf$.MODULE$.PARQUET_INT96_REBASE_MODE_IN_READ().key(), (Object)ParquetOptions$.MODULE$.INT96_REBASE_MODE());
        } else if ("Parquet".equals(string)) {
            tuple2 = new Tuple2((Object)SQLConf$.MODULE$.PARQUET_REBASE_MODE_IN_READ().key(), (Object)ParquetOptions$.MODULE$.DATETIME_REBASE_MODE());
        } else if ("Avro".equals(string)) {
            tuple2 = new Tuple2((Object)SQLConf$.MODULE$.AVRO_REBASE_MODE_IN_READ().key(), (Object)"datetimeRebaseMode");
        } else {
            throw new IllegalStateException(new StringBuilder(21).append("Unrecognized format ").append(format).append(".").toString());
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        String config = (String)tuple22._1();
        String option = (String)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)config, (Object)option);
        String config2 = (String)tuple23._1();
        String option2 = (String)tuple23._2();
        return QueryExecutionErrors$.MODULE$.sparkUpgradeInReadingDatesError(format, config2, option2);
    }

    public SparkUpgradeException newRebaseExceptionInWrite(String format) {
        String string;
        String string2 = format;
        if ("Parquet INT96".equals(string2)) {
            string = SQLConf$.MODULE$.PARQUET_INT96_REBASE_MODE_IN_WRITE().key();
        } else if ("Parquet".equals(string2)) {
            string = SQLConf$.MODULE$.PARQUET_REBASE_MODE_IN_WRITE().key();
        } else if ("Avro".equals(string2)) {
            string = SQLConf$.MODULE$.AVRO_REBASE_MODE_IN_WRITE().key();
        } else {
            throw new IllegalStateException(new StringBuilder(21).append("Unrecognized format ").append(format).append(".").toString());
        }
        String config = string;
        return QueryExecutionErrors$.MODULE$.sparkUpgradeInWritingDatesError(format, config);
    }

    public Function1<Object, Object> createDateRebaseFuncInRead(Enumeration.Value rebaseMode, String format) {
        Enumeration.Value value = rebaseMode;
        Enumeration.Value value2 = SQLConf.LegacyBehaviorPolicy$.MODULE$.EXCEPTION();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return (JFunction1.mcII.sp & Serializable & scala.Serializable)days -> {
                if (days < RebaseDateTime$.MODULE$.lastSwitchJulianDay()) {
                    throw MODULE$.newRebaseExceptionInRead(format);
                }
                return days;
            };
        }
        Enumeration.Value value4 = SQLConf.LegacyBehaviorPolicy$.MODULE$.LEGACY();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            return (JFunction1.mcII.sp & Serializable & scala.Serializable)days -> RebaseDateTime$.MODULE$.rebaseJulianToGregorianDays(days);
        }
        Enumeration.Value value6 = SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            return (JFunction1.mcII.sp & Serializable & scala.Serializable)x -> BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToInteger((int)x)));
        }
        throw new MatchError((Object)value);
    }

    public Function1<Object, Object> createDateRebaseFuncInWrite(Enumeration.Value rebaseMode, String format) {
        Enumeration.Value value = rebaseMode;
        Enumeration.Value value2 = SQLConf.LegacyBehaviorPolicy$.MODULE$.EXCEPTION();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return (JFunction1.mcII.sp & Serializable & scala.Serializable)days -> {
                if (days < RebaseDateTime$.MODULE$.lastSwitchGregorianDay()) {
                    throw MODULE$.newRebaseExceptionInWrite(format);
                }
                return days;
            };
        }
        Enumeration.Value value4 = SQLConf.LegacyBehaviorPolicy$.MODULE$.LEGACY();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            return (JFunction1.mcII.sp & Serializable & scala.Serializable)days -> RebaseDateTime$.MODULE$.rebaseGregorianToJulianDays(days);
        }
        Enumeration.Value value6 = SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            return (JFunction1.mcII.sp & Serializable & scala.Serializable)x -> BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToInteger((int)x)));
        }
        throw new MatchError((Object)value);
    }

    public Function1<Object, Object> createTimestampRebaseFuncInRead(RebaseDateTime.RebaseSpec rebaseSpec, String format) {
        Enumeration.Value value = rebaseSpec.mode();
        Enumeration.Value value2 = SQLConf.LegacyBehaviorPolicy$.MODULE$.EXCEPTION();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return (JFunction1.mcJJ.sp & Serializable & scala.Serializable)micros -> {
                if (micros < RebaseDateTime$.MODULE$.lastSwitchJulianTs()) {
                    throw MODULE$.newRebaseExceptionInRead(format);
                }
                return micros;
            };
        }
        Enumeration.Value value4 = SQLConf.LegacyBehaviorPolicy$.MODULE$.LEGACY();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            return (JFunction1.mcJJ.sp & Serializable & scala.Serializable)x$2 -> RebaseDateTime$.MODULE$.rebaseJulianToGregorianMicros(rebaseSpec.timeZone(), x$2);
        }
        Enumeration.Value value6 = SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            return (JFunction1.mcJJ.sp & Serializable & scala.Serializable)x -> BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToLong((long)x)));
        }
        throw new MatchError((Object)value);
    }

    public Function1<Object, Object> createTimestampRebaseFuncInWrite(Enumeration.Value rebaseMode, String format) {
        Enumeration.Value value = rebaseMode;
        Enumeration.Value value2 = SQLConf.LegacyBehaviorPolicy$.MODULE$.EXCEPTION();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return (JFunction1.mcJJ.sp & Serializable & scala.Serializable)micros -> {
                if (micros < RebaseDateTime$.MODULE$.lastSwitchGregorianTs()) {
                    throw MODULE$.newRebaseExceptionInWrite(format);
                }
                return micros;
            };
        }
        Enumeration.Value value4 = SQLConf.LegacyBehaviorPolicy$.MODULE$.LEGACY();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            String timeZone = SQLConf$.MODULE$.get().sessionLocalTimeZone();
            return (JFunction1.mcJJ.sp & Serializable & scala.Serializable)x$3 -> RebaseDateTime$.MODULE$.rebaseGregorianToJulianMicros(timeZone, x$3);
        }
        Enumeration.Value value6 = SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            return (JFunction1.mcJJ.sp & Serializable & scala.Serializable)x -> BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToLong((long)x)));
        }
        throw new MatchError((Object)value);
    }

    public Map<String, String> generateDatasourceOptions(CaseInsensitiveStringMap extraOptions, CatalogTable table) {
        Option pathOption = table.storage().locationUri().map((Function1 & Serializable & scala.Serializable)x$4 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)CatalogUtils$.MODULE$.URIToString(x$4)));
        Map options = table.storage().properties().$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(pathOption));
        if (!BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.LEGACY_EXTRA_OPTIONS_BEHAVIOR()))) {
            table.storage().properties().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                DataSourceUtils$.$anonfun$generateDatasourceOptions$2(extraOptions, table, x0$1);
                return BoxedUnit.UNIT;
            });
            Set lowerCasedDuplicatedKeys = (Set)((GenSetLike)table.storage().properties().keySet().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.toLowerCase(Locale.ROOT), Set$.MODULE$.canBuildFrom())).intersect((GenSet)JavaConverters$.MODULE$.asScalaSetConverter(extraOptions.keySet()).asScala());
            return ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(extraOptions.asCaseSensitiveMap()).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)DataSourceUtils$.$anonfun$generateDatasourceOptions$4(lowerCasedDuplicatedKeys, x0$2))).toMap(Predef$.MODULE$.$conforms()).$plus$plus((GenTraversableOnce)options);
        }
        return options;
    }

    public Tuple2<Seq<Expression>, Seq<Expression>> getPartitionFiltersAndDataFilters(StructType partitionSchema, Seq<Expression> normalizedFilters) {
        Seq partitionColumns = (Seq)normalizedFilters.flatMap((Function1 & Serializable & scala.Serializable)expr -> expr.collect((PartialFunction)new scala.Serializable(partitionSchema){
            public static final long serialVersionUID = 0L;
            private final StructType partitionSchema$1;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof AttributeReference) {
                    AttributeReference attributeReference = (AttributeReference)A1;
                    if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.partitionSchema$1.names())).contains((Object)attributeReference.name())) {
                        return (B1)attributeReference;
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Expression x1) {
                Expression expression = x1;
                if (expression instanceof AttributeReference) {
                    AttributeReference attributeReference = (AttributeReference)expression;
                    if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.partitionSchema$1.names())).contains((Object)attributeReference.name())) {
                        return true;
                    }
                }
                return false;
            }
            {
                this.partitionSchema$1 = partitionSchema$1;
            }
        }), Seq$.MODULE$.canBuildFrom());
        AttributeSet partitionSet = AttributeSet$.MODULE$.apply((Iterable)partitionColumns);
        Tuple2 tuple2 = normalizedFilters.partition((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)DataSourceUtils$.$anonfun$getPartitionFiltersAndDataFilters$2(partitionSet, f)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq partitionFilters = (Seq)tuple2._1();
        Seq dataFilters = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)partitionFilters, (Object)dataFilters);
        Seq partitionFilters2 = (Seq)tuple22._1();
        Seq dataFilters2 = (Seq)tuple22._2();
        Seq extraPartitionFilter = (Seq)dataFilters2.flatMap((Function1 & Serializable & scala.Serializable)x$7 -> Option$.MODULE$.option2Iterable(MODULE$.extractPredicatesWithinOutputSet((Expression)x$7, partitionSet)), Seq$.MODULE$.canBuildFrom());
        return new Tuple2((Object)ExpressionSet$.MODULE$.apply((TraversableOnce)partitionFilters2.$plus$plus((GenTraversableOnce)extraPartitionFilter, Seq$.MODULE$.canBuildFrom())).toSeq(), (Object)dataFilters2);
    }

    public static final /* synthetic */ void $anonfun$checkFieldNames$1(FileFormat format$1, StructField field) {
        if (!format$1.supportFieldName(field.name())) {
            throw QueryCompilationErrors$.MODULE$.invalidColumnNameAsPathError(format$1.getClass().getSimpleName(), field.name());
        }
        DataType dataType = field.dataType();
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            MODULE$.checkFieldNames(format$1, structType);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$verifySchema$1(FileFormat format$2, StructField field) {
        if (!format$2.supportDataType(field.dataType())) {
            throw QueryCompilationErrors$.MODULE$.dataTypeUnsupportedByDataSourceError(format$2.toString(), field);
        }
    }

    public static final /* synthetic */ Enumeration.Value $anonfun$getRebaseSpec$1(String minVersion$1, Function1 lookupFileMeta$1, String metadataKey$1, String version) {
        if (new StringOps(Predef$.MODULE$.augmentString(version)).$less((Object)minVersion$1) || lookupFileMeta$1.apply((Object)metadataKey$1) != null) {
            return SQLConf.LegacyBehaviorPolicy$.MODULE$.LEGACY();
        }
        return SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED();
    }

    public static final /* synthetic */ Enumeration.Value $anonfun$getRebaseSpec$2(String modeByConfig$1) {
        return SQLConf.LegacyBehaviorPolicy$.MODULE$.withName(modeByConfig$1);
    }

    public static final /* synthetic */ void $anonfun$generateDatasourceOptions$2(CaseInsensitiveStringMap extraOptions$1, CatalogTable table$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            if (extraOptions$1.containsKey((Object)k)) {
                String string = extraOptions$1.get((Object)k);
                String string2 = v;
                if (string == null ? string2 != null : !string.equals(string2)) {
                    throw QueryCompilationErrors$.MODULE$.failToResolveDataSourceForTableError(table$1, k);
                }
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$generateDatasourceOptions$4(Set lowerCasedDuplicatedKeys$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            return lowerCasedDuplicatedKeys$1.contains((Object)k.toLowerCase(Locale.ROOT));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$getPartitionFiltersAndDataFilters$2(AttributeSet partitionSet$1, Expression f) {
        return f.references().nonEmpty() && f.references().subsetOf(partitionSet$1);
    }

    private DataSourceUtils$() {
        MODULE$ = this;
        AliasHelper.$init$((AliasHelper)this);
        Logging.$init$((Logging)this);
        PredicateHelper.$init$((PredicateHelper)this);
        this.PARTITIONING_COLUMNS_KEY = "__partition_columns";
        this.PARTITION_OVERWRITE_MODE = "partitionOverwriteMode";
        this.formats = Serialization$.MODULE$.formats((TypeHints)NoTypeHints$.MODULE$);
    }
}

