/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.UUID;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.QueryPlanningTracker;
import org.apache.spark.sql.catalyst.QueryPlanningTracker$;
import org.apache.spark.sql.catalyst.analysis.UnsupportedOperationChecker$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.QueryPlan$;
import org.apache.spark.sql.catalyst.plans.logical.AppendData;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.CommandResult;
import org.apache.spark.sql.catalyst.plans.logical.CreateTableAsSelect;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.OverwriteByExpression;
import org.apache.spark.sql.catalyst.plans.logical.OverwritePartitionsDynamic;
import org.apache.spark.sql.catalyst.plans.logical.ReplaceTableAsSelect;
import org.apache.spark.sql.catalyst.rules.PlanChangeLogger;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.StringUtils;
import org.apache.spark.sql.execution.CodegenMode$;
import org.apache.spark.sql.execution.CollectMetricsExec$;
import org.apache.spark.sql.execution.CommandExecutionMode$;
import org.apache.spark.sql.execution.CostMode$;
import org.apache.spark.sql.execution.ExplainMode;
import org.apache.spark.sql.execution.ExplainUtils$;
import org.apache.spark.sql.execution.ExtendedMode$;
import org.apache.spark.sql.execution.FormattedMode$;
import org.apache.spark.sql.execution.QueryExecution$;
import org.apache.spark.sql.execution.QueryExecution$debug$;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.SQLExecutionRDD;
import org.apache.spark.sql.execution.SimpleMode$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.SparkPlanner;
import org.apache.spark.sql.execution.adaptive.AdaptiveExecutionContext;
import org.apache.spark.sql.execution.adaptive.InsertAdaptiveSparkPlan;
import org.apache.spark.sql.execution.debug.package$;
import org.apache.spark.sql.execution.streaming.IncrementalExecution;
import org.apache.spark.sql.execution.streaming.OffsetSeqMetadata;
import org.apache.spark.sql.execution.streaming.OffsetSeqMetadata$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\r-c\u0001B!C\u00015C\u0001B\u0017\u0001\u0003\u0006\u0004%\ta\u0017\u0005\tA\u0002\u0011\t\u0011)A\u00059\"A\u0011\r\u0001BC\u0002\u0013\u0005!\r\u0003\u0005m\u0001\t\u0005\t\u0015!\u0003d\u0011!i\u0007A!b\u0001\n\u0003q\u0007\u0002C:\u0001\u0005\u0003\u0005\u000b\u0011B8\t\u0011Q\u0004!Q1A\u0005\u0002UD\u0001b \u0001\u0003\u0002\u0003\u0006IA\u001e\u0005\b\u0003\u0003\u0001A\u0011AA\u0002\u0011%\ty\u0001\u0001b\u0001\n\u0003\t\t\u0002\u0003\u0005\u0002\u001a\u0001\u0001\u000b\u0011BA\n\u0011\u001d\tY\u0002\u0001C\t\u0003;Aq!!\n\u0001\t\u0003\t9\u0003C\u0004\u00020\u0001!\t!a\n\t\u0013\u0005E\u0002\u0001#b\u0001\n\u0003\u0011\u0007\"CA\u001a\u0001!\u0015\r\u0011\"\u0001c\u0011\u001d\t)\u0004\u0001C\u0005\u0003oAq!!\u0017\u0001\t\u0013\tY\u0006C\u0005\u0002b\u0001A)\u0019!C\u0001E\"I\u00111\r\u0001\t\u0006\u0004%\tA\u0019\u0005\b\u0003K\u0002A\u0011AA\u0014\u0011%\t9\u0007\u0001EC\u0002\u0013\u0005!\rC\u0004\u0002j\u0001!I!a\n\t\u0015\u0005-\u0004\u0001#b\u0001\n\u0003\ti\u0007\u0003\u0006\u0002v\u0001A)\u0019!C\u0001\u0003[B!\"a\u001e\u0001\u0011\u000b\u0007I\u0011AA=\u0011\u001d\ti\t\u0001C\u0001\u0003\u001fCq!!(\u0001\t#\ty\nC\u0004\u0002@\u0002!\t\"!1\t\u000f\u0005-\b\u0001\"\u0001\u0002n\"9\u00111\u001e\u0001\u0005\n\u0005=\bb\u0002B\b\u0001\u0011\u0005!\u0011\u0003\u0005\b\u0005\u001f\u0001A\u0011\u0002B\u000e\u0011\u001d\u0011\u0019\u0003\u0001C\u0005\u0005KAqAa\u000b\u0001\t\u0003\u0012i\u0003C\u0004\u0003,\u0001!IAa\f\t\u000f\tU\u0002\u0001\"\u0001\u0002n\"9!Q\u0007\u0001\u0005\n\t]\u0002b\u0002B\u001f\u0001\u0011%!qH\u0004\b\u0005\u000b\u0002\u0001\u0012\u0001B$\r\u001d\u0011Y\u0005\u0001E\u0001\u0005\u001bBq!!\u0001*\t\u0003\u0011y\u0005C\u0004\u0003R%\"\t!a\n\t\u000f\tM\u0013\u0006\"\u0001\u0003V!9!QN\u0015\u0005\u0002\t=\u0004\"\u0003BASE\u0005I\u0011\u0001BB\u0011%\u0011I*KI\u0001\n\u0003\u0011YjB\u0004\u0003 \nC\tA!)\u0007\r\u0005\u0013\u0005\u0012\u0001BR\u0011\u001d\t\t!\rC\u0001\u0005KC\u0011Ba*2\u0005\u0004%IA!+\t\u0011\t\r\u0017\u0007)A\u0005\u0005WCqA!22\t\u0013\t\t\u0002\u0003\u0005\u0002\u001eF\"\tA\u0011Bd\u0011)\u0011\t/MI\u0001\n\u0003\u0011%1\u001d\u0005\t\u0005O\fD\u0011\u0001\"\u0003j\"9!\u0011_\u0019\u0005\u0002\tM\bb\u0002B~c\u0011\u0005!Q \u0005\b\u0005w\fD\u0011AB\u0002\u0011\u001d\u0011Y0\rC\u0001\u0007\u0013A\u0001ba\u00072\t\u0003!5Q\u0004\u0005\t\u0007[\tD\u0011\u0001#\u00040!I1qH\u0019\u0012\u0002\u0013\u00051\u0011\t\u0005\n\u0007\u000b\n\u0014\u0013!C\u0001\u0007\u000f\u0012a\"U;fef,\u00050Z2vi&|gN\u0003\u0002D\t\u0006IQ\r_3dkRLwN\u001c\u0006\u0003\u000b\u001a\u000b1a]9m\u0015\t9\u0005*A\u0003ta\u0006\u00148N\u0003\u0002J\u0015\u00061\u0011\r]1dQ\u0016T\u0011aS\u0001\u0004_J<7\u0001A\n\u0004\u00019#\u0006CA(S\u001b\u0005\u0001&\"A)\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0003&AB!osJ+g\r\u0005\u0002V16\taK\u0003\u0002X\r\u0006A\u0011N\u001c;fe:\fG.\u0003\u0002Z-\n9Aj\\4hS:<\u0017\u0001D:qCJ\\7+Z:tS>tW#\u0001/\u0011\u0005usV\"\u0001#\n\u0005}#%\u0001D*qCJ\\7+Z:tS>t\u0017!D:qCJ\\7+Z:tS>t\u0007%A\u0004m_\u001eL7-\u00197\u0016\u0003\r\u0004\"\u0001\u001a6\u000e\u0003\u0015T!!\u00194\u000b\u0005\u001dD\u0017!\u00029mC:\u001c(BA5E\u0003!\u0019\u0017\r^1msN$\u0018BA6f\u0005-aunZ5dC2\u0004F.\u00198\u0002\u00111|w-[2bY\u0002\nq\u0001\u001e:bG.,'/F\u0001p!\t\u0001\u0018/D\u0001i\u0013\t\u0011\bN\u0001\u000bRk\u0016\u0014\u0018\u0010\u00157b]:Lgn\u001a+sC\u000e\\WM]\u0001\tiJ\f7m[3sA\u0005!Qn\u001c3f+\u00051\bCA<|\u001d\tA\u00180D\u0001C\u0013\tQ()\u0001\u000bD_6l\u0017M\u001c3Fq\u0016\u001cW\u000f^5p]6{G-Z\u0005\u0003yv\u0014QAV1mk\u0016L!A )\u0003\u0017\u0015sW/\\3sCRLwN\\\u0001\u0006[>$W\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0015\u0005\u0015\u0011qAA\u0005\u0003\u0017\ti\u0001\u0005\u0002y\u0001!)!,\u0003a\u00019\")\u0011-\u0003a\u0001G\"9Q.\u0003I\u0001\u0002\u0004y\u0007b\u0002;\n!\u0003\u0005\rA^\u0001\u0003S\u0012,\"!a\u0005\u0011\u0007=\u000b)\"C\u0002\u0002\u0018A\u0013A\u0001T8oO\u0006\u0019\u0011\u000e\u001a\u0011\u0002\u000fAd\u0017M\u001c8feV\u0011\u0011q\u0004\t\u0004q\u0006\u0005\u0012bAA\u0012\u0005\na1\u000b]1sWBc\u0017M\u001c8fe\u0006q\u0011m]:feR\fe.\u00197zu\u0016$GCAA\u0015!\ry\u00151F\u0005\u0004\u0003[\u0001&\u0001B+oSR\fq\"Y:tKJ$8+\u001e9q_J$X\rZ\u0001\tC:\fG.\u001f>fI\u0006y1m\\7nC:$W\t_3dkR,G-\u0001\u000bd_6l\u0017M\u001c3Fq\u0016\u001cW\u000f^5p]:\u000bW.\u001a\u000b\u0005\u0003s\ty\u0005\u0005\u0003\u0002<\u0005%c\u0002BA\u001f\u0003\u000b\u00022!a\u0010Q\u001b\t\t\tEC\u0002\u0002D1\u000ba\u0001\u0010:p_Rt\u0014bAA$!\u00061\u0001K]3eK\u001aLA!a\u0013\u0002N\t11\u000b\u001e:j]\u001eT1!a\u0012Q\u0011\u001d\t\t&\u0005a\u0001\u0003'\nqaY8n[\u0006tG\rE\u0002e\u0003+J1!a\u0016f\u0005\u001d\u0019u.\\7b]\u0012\fa#Z1hKJd\u00170\u0012=fGV$XmQ8n[\u0006tGm\u001d\u000b\u0004G\u0006u\u0003BBA0%\u0001\u00071-A\u0001q\u0003)qwN]7bY&TX\rZ\u0001\u000fo&$\bnQ1dQ\u0016$G)\u0019;b\u0003U\t7o]3si\u000e{W.\\1oI\u0016CXmY;uK\u0012\fQb\u001c9uS6L'0\u001a3QY\u0006t\u0017aD1tg\u0016\u0014Ho\u00149uS6L'0\u001a3\u0002\u0013M\u0004\u0018M]6QY\u0006tWCAA8!\rA\u0018\u0011O\u0005\u0004\u0003g\u0012%!C*qCJ\\\u0007\u000b\\1o\u00031)\u00070Z2vi\u0016$\u0007\u000b\\1o\u0003\u0015!xN\u00153e+\t\tY\b\u0005\u0004\u0002~\u0005\r\u0015qQ\u0007\u0003\u0003\u007fR1!!!G\u0003\r\u0011H\rZ\u0005\u0005\u0003\u000b\u000byHA\u0002S\t\u0012\u00032\u0001]AE\u0013\r\tY\t\u001b\u0002\f\u0013:$XM\u001d8bYJ{w/A\bpEN,'O^3e\u001b\u0016$(/[2t+\t\t\t\n\u0005\u0005\u0002<\u0005M\u0015\u0011HAL\u0013\u0011\t)*!\u0014\u0003\u00075\u000b\u0007\u000fE\u0002^\u00033K1!a'E\u0005\r\u0011vn^\u0001\raJ,\u0007/\u0019:bi&|gn]\u000b\u0003\u0003C\u0003b!a)\u0002.\u0006Mf\u0002BAS\u0003SsA!a\u0010\u0002(&\t\u0011+C\u0002\u0002,B\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u00020\u0006E&aA*fc*\u0019\u00111\u0016)\u0011\r\u0005U\u00161XA8\u001b\t\t9LC\u0002\u0002:\"\fQA];mKNLA!!0\u00028\n!!+\u001e7f\u00031)\u00070Z2vi\u0016\u0004\u0006.Y:f+\u0011\t\u0019-a3\u0015\t\u0005\u0015\u0017q\u001d\u000b\u0005\u0003\u000f\fi\u000e\u0005\u0003\u0002J\u0006-G\u0002\u0001\u0003\b\u0003\u001bl\"\u0019AAh\u0005\u0005!\u0016\u0003BAi\u0003/\u00042aTAj\u0013\r\t)\u000e\u0015\u0002\b\u001d>$\b.\u001b8h!\ry\u0015\u0011\\\u0005\u0004\u00037\u0004&aA!os\"A\u0011q\\\u000f\u0005\u0002\u0004\t\t/A\u0003cY>\u001c7\u000eE\u0003P\u0003G\f9-C\u0002\u0002fB\u0013\u0001\u0002\u00102z]\u0006lWM\u0010\u0005\b\u0003Sl\u0002\u0019AA\u001d\u0003\u0015\u0001\b.Y:f\u00031\u0019\u0018.\u001c9mKN#(/\u001b8h+\t\tI\u0004\u0006\u0005\u0002*\u0005E\u00181 B\u0003\u0011\u001d\t\u0019p\ba\u0001\u0003k\f\u0011BZ8s[\u0006$H/\u001a3\u0011\u0007=\u000b90C\u0002\u0002zB\u0013qAQ8pY\u0016\fg\u000eC\u0004\u0002~~\u0001\r!a@\u0002\u00135\f\u0007PR5fY\u0012\u001c\bcA(\u0003\u0002%\u0019!1\u0001)\u0003\u0007%sG\u000fC\u0004\u0003\b}\u0001\rA!\u0003\u0002\r\u0005\u0004\b/\u001a8e!\u001dy%1BA\u001d\u0003SI1A!\u0004Q\u0005%1UO\\2uS>t\u0017'A\u0007fqBd\u0017-\u001b8TiJLgn\u001a\u000b\u0005\u0003s\u0011\u0019\u0002\u0003\u0004uA\u0001\u0007!Q\u0003\t\u0004q\n]\u0011b\u0001B\r\u0005\nYQ\t\u001f9mC&tWj\u001c3f)!\tIC!\b\u0003 \t\u0005\u0002B\u0002;\"\u0001\u0004\u0011)\u0002C\u0004\u0002~\u0006\u0002\r!a@\t\u000f\t\u001d\u0011\u00051\u0001\u0003\n\u0005QqO]5uKBc\u0017M\\:\u0015\r\u0005%\"q\u0005B\u0015\u0011\u001d\u00119A\ta\u0001\u0005\u0013Aq!!@#\u0001\u0004\ty0\u0001\u0005u_N#(/\u001b8h)\t\tI\u0004\u0006\u0004\u0002*\tE\"1\u0007\u0005\b\u0003{$\u0003\u0019AA\u0000\u0011\u001d\u00119\u0001\na\u0001\u0005\u0013\tqb\u001d;sS:<w+\u001b;i'R\fGo\u001d\u000b\u0007\u0003S\u0011IDa\u000f\t\u000f\u0005uh\u00051\u0001\u0002\u0000\"9!q\u0001\u0014A\u0002\t%\u0011!D<ji\"\u0014V\rZ1di&|g\u000e\u0006\u0003\u0002:\t\u0005\u0003b\u0002B\"O\u0001\u0007\u0011\u0011H\u0001\b[\u0016\u001c8/Y4f\u0003\u0015!WMY;h!\r\u0011I%K\u0007\u0002\u0001\t)A-\u001a2vON\u0011\u0011F\u0014\u000b\u0003\u0005\u000f\nqaY8eK\u001e,g.\u0001\u0007d_\u0012,w-\u001a8U_N+\u0017\u000f\u0006\u0002\u0003XA1\u00111UAW\u00053\u0002\u0012b\u0014B.\u0003s\tIDa\u0018\n\u0007\tu\u0003K\u0001\u0004UkBdWm\r\t\u0005\u0005C\u0012I'\u0004\u0002\u0003d)!!\u0011\u000bB3\u0015\r\u00119\u0007[\u0001\fKb\u0004(/Z:tS>t7/\u0003\u0003\u0003l\t\r$!\u0004\"zi\u0016\u001cu\u000eZ3Ti\u0006$8/\u0001\u0004u_\u001aKG.\u001a\u000b\t\u0003S\u0011\tH!\u001e\u0003x!9!1O\u0017A\u0002\u0005e\u0012\u0001\u00029bi\"D\u0011\"!@.!\u0003\u0005\r!a@\t\u0013\teT\u0006%AA\u0002\tm\u0014aC3ya2\f\u0017N\\'pI\u0016\u0004Ra\u0014B?\u0003sI1Aa Q\u0005\u0019y\u0005\u000f^5p]\u0006\u0001Bo\u001c$jY\u0016$C-\u001a4bk2$HEM\u000b\u0003\u0005\u000bSC!a@\u0003\b.\u0012!\u0011\u0012\t\u0005\u0005\u0017\u0013)*\u0004\u0002\u0003\u000e*!!q\u0012BI\u0003%)hn\u00195fG.,GMC\u0002\u0003\u0014B\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u00119J!$\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\tu_\u001aKG.\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!Q\u0014\u0016\u0005\u0005w\u00129)\u0001\bRk\u0016\u0014\u00180\u0012=fGV$\u0018n\u001c8\u0011\u0005a\f4CA\u0019O)\t\u0011\t+\u0001\t`]\u0016DH/\u0012=fGV$\u0018n\u001c8JIV\u0011!1\u0016\t\u0005\u0005[\u0013y,\u0004\u0002\u00030*!!\u0011\u0017BZ\u0003\u0019\tGo\\7jG*!!Q\u0017B\\\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0005s\u0013Y,\u0001\u0003vi&d'B\u0001B_\u0003\u0011Q\u0017M^1\n\t\t\u0005'q\u0016\u0002\u000b\u0003R|W.[2M_:<\u0017!E0oKb$X\t_3dkRLwN\\%eA\u0005ya.\u001a=u\u000bb,7-\u001e;j_:LE\r\u0006\u0005\u0002\"\n%'1\u001aBo\u0011\u0015Qf\u00071\u0001]\u0011%\u0011iM\u000eI\u0001\u0002\u0004\u0011y-A\u000bbI\u0006\u0004H/\u001b<f\u000bb,7-\u001e;j_:\u0014V\u000f\\3\u0011\u000b=\u0013iH!5\u0011\t\tM'\u0011\\\u0007\u0003\u0005+T1Aa6C\u0003!\tG-\u00199uSZ,\u0017\u0002\u0002Bn\u0005+\u0014q#\u00138tKJ$\u0018\tZ1qi&4Xm\u00159be.\u0004F.\u00198\t\u000f\t}g\u00071\u0001\u0002v\u0006A1/\u001e2rk\u0016\u0014\u00180\u0001\fqe\u0016\u0004\u0018M]1uS>t7\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011)O\u000b\u0003\u0003P\n\u001d\u0015a\u00059sKB\f'/\u001a$pe\u0016CXmY;uS>tGCBA8\u0005W\u0014i\u000fC\u0004\u0002\u001eb\u0002\r!!)\t\u000f\t=\b\b1\u0001\u0002p\u0005!\u0001\u000f\\1o\u0003=\u0019'/Z1uKN\u0003\u0018M]6QY\u0006tG\u0003CA8\u0005k\u00149P!?\t\u000biK\u0004\u0019\u0001/\t\u000f\u0005m\u0011\b1\u0001\u0002 !1!q^\u001dA\u0002\r\f1\u0003\u001d:fa\u0006\u0014X-\u0012=fGV$X\r\u001a)mC:$b!a\u001c\u0003\u0000\u000e\u0005\u0001\"B$;\u0001\u0004a\u0006b\u0002Bxu\u0001\u0007\u0011q\u000e\u000b\u0007\u0003_\u001a)aa\u0002\t\u000b\u001d[\u0004\u0019\u0001/\t\r\t=8\b1\u0001d)!\tyga\u0003\u0004\u0010\rE\u0001BBB\u0007y\u0001\u0007A,A\u0004tKN\u001c\u0018n\u001c8\t\r\t=H\b1\u0001d\u0011\u001d\u0019\u0019\u0002\u0010a\u0001\u0007+\tqaY8oi\u0016DH\u000f\u0005\u0003\u0003T\u000e]\u0011\u0002BB\r\u0005+\u0014\u0001$\u00113baRLg/Z#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0003=!x.\u00138uKJt\u0017\r\\#se>\u0014HCBB\u0010\u0007K\u0019I\u0003\u0005\u0003\u0002$\u000e\u0005\u0012\u0002BB\u0012\u0003c\u0013\u0011\u0002\u00165s_^\f'\r\\3\t\u000f\r\u001dR\b1\u0001\u0002:\u0005\u0019Qn]4\t\u000f\r-R\b1\u0001\u0004 \u0005\tQ-A\txSRD\u0017J\u001c;fe:\fG.\u0012:s_J,Ba!\r\u00048Q!11GB\u001f)\u0011\u0019)d!\u000f\u0011\t\u0005%7q\u0007\u0003\b\u0003\u001bt$\u0019AAh\u0011!\tyN\u0010CA\u0002\rm\u0002#B(\u0002d\u000eU\u0002bBB\u0014}\u0001\u0007\u0011\u0011H\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\r\r#fA8\u0003\b\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQ*\"a!\u0013+\u0007Y\u00149\t")
public class QueryExecution
implements Logging {
    private LogicalPlan analyzed;
    private LogicalPlan commandExecuted;
    private LogicalPlan normalized;
    private LogicalPlan withCachedData;
    private LogicalPlan optimizedPlan;
    private SparkPlan sparkPlan;
    private SparkPlan executedPlan;
    private RDD<InternalRow> toRdd;
    private volatile QueryExecution$debug$ debug$module;
    private final SparkSession sparkSession;
    private final LogicalPlan logical;
    private final QueryPlanningTracker tracker;
    private final Enumeration.Value mode;
    private final long id;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static Enumeration.Value $lessinit$greater$default$4() {
        return QueryExecution$.MODULE$.$lessinit$greater$default$4();
    }

    public static QueryPlanningTracker $lessinit$greater$default$3() {
        return QueryExecution$.MODULE$.$lessinit$greater$default$3();
    }

    public static SparkPlan prepareExecutedPlan(SparkSession sparkSession, LogicalPlan logicalPlan2, AdaptiveExecutionContext adaptiveExecutionContext) {
        return QueryExecution$.MODULE$.prepareExecutedPlan(sparkSession, logicalPlan2, adaptiveExecutionContext);
    }

    public static SparkPlan prepareExecutedPlan(SparkSession sparkSession, LogicalPlan logicalPlan2) {
        return QueryExecution$.MODULE$.prepareExecutedPlan(sparkSession, logicalPlan2);
    }

    public static SparkPlan prepareExecutedPlan(SparkSession sparkSession, SparkPlan sparkPlan) {
        return QueryExecution$.MODULE$.prepareExecutedPlan(sparkSession, sparkPlan);
    }

    public static SparkPlan createSparkPlan(SparkSession sparkSession, SparkPlanner sparkPlanner, LogicalPlan logicalPlan2) {
        return QueryExecution$.MODULE$.createSparkPlan(sparkSession, sparkPlanner, logicalPlan2);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public QueryExecution$debug$ debug() {
        if (this.debug$module == null) {
            this.debug$lzycompute$1();
        }
        return this.debug$module;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SparkSession sparkSession() {
        return this.sparkSession;
    }

    public LogicalPlan logical() {
        return this.logical;
    }

    public QueryPlanningTracker tracker() {
        return this.tracker;
    }

    public Enumeration.Value mode() {
        return this.mode;
    }

    public long id() {
        return this.id;
    }

    public SparkPlanner planner() {
        return this.sparkSession().sessionState().planner();
    }

    public void assertAnalyzed() {
        this.analyzed();
    }

    public void assertSupported() {
        if (this.sparkSession().sessionState().conf().isUnsupportedOperationCheckEnabled()) {
            UnsupportedOperationChecker$.MODULE$.checkForBatch(this.analyzed());
            return;
        }
    }

    private LogicalPlan analyzed$lzycompute() {
        QueryExecution queryExecution = this;
        synchronized (queryExecution) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.analyzed = (LogicalPlan)this.executePhase(QueryPlanningTracker$.MODULE$.ANALYSIS(), (Function0 & Serializable & scala.Serializable)() -> this.sparkSession().sessionState().analyzer().executeAndCheck(this.logical(), this.tracker()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.analyzed;
    }

    public LogicalPlan analyzed() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.analyzed$lzycompute();
        }
        return this.analyzed;
    }

    private LogicalPlan commandExecuted$lzycompute() {
        QueryExecution queryExecution = this;
        synchronized (queryExecution) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                LogicalPlan logicalPlan2;
                Enumeration.Value value = this.mode();
                Enumeration.Value value2 = CommandExecutionMode$.MODULE$.NON_ROOT();
                Enumeration.Value value3 = value;
                if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                    logicalPlan2 = (LogicalPlan)this.analyzed().mapChildren((Function1 & Serializable & scala.Serializable)p -> this.eagerlyExecuteCommands((LogicalPlan)p));
                } else {
                    Enumeration.Value value4 = CommandExecutionMode$.MODULE$.ALL();
                    Enumeration.Value value5 = value;
                    if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                        logicalPlan2 = this.eagerlyExecuteCommands(this.analyzed());
                    } else {
                        Enumeration.Value value6 = CommandExecutionMode$.MODULE$.SKIP();
                        Enumeration.Value value7 = value;
                        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                            logicalPlan2 = this.analyzed();
                        } else {
                            throw new MatchError((Object)value);
                        }
                    }
                }
                this.commandExecuted = logicalPlan2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.commandExecuted;
    }

    public LogicalPlan commandExecuted() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.commandExecuted$lzycompute();
        }
        return this.commandExecuted;
    }

    public String org$apache$spark$sql$execution$QueryExecution$$commandExecutionName(Command command) {
        Command command2 = command;
        if (command2 instanceof CreateTableAsSelect) {
            return "create";
        }
        if (command2 instanceof ReplaceTableAsSelect) {
            return "replace";
        }
        if (command2 instanceof AppendData) {
            return "append";
        }
        if (command2 instanceof OverwriteByExpression) {
            return "overwrite";
        }
        if (command2 instanceof OverwritePartitionsDynamic) {
            return "overwritePartitions";
        }
        return "command";
    }

    private LogicalPlan eagerlyExecuteCommands(LogicalPlan p) {
        return (LogicalPlan)p.transformDown((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ QueryExecution $outer;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof Command) {
                    Command command = (Command)A1;
                    QueryExecution qe = this.$outer.sparkSession().sessionState().executePlan((LogicalPlan)command, CommandExecutionMode$.MODULE$.NON_ROOT());
                    InternalRow[] result = (InternalRow[])SQLExecution$.MODULE$.withNewExecutionId(qe, (Option<String>)new Some((Object)this.$outer.org$apache$spark$sql$execution$QueryExecution$$commandExecutionName(command)), (Function0 & Serializable & scala.Serializable)() -> qe.executedPlan().executeCollect());
                    return (B1)((Object)new CommandResult((Seq<Attribute>)qe.analyzed().output(), qe.commandExecuted(), qe.executedPlan(), (Seq<InternalRow>)Predef$.MODULE$.wrapRefArray((Object[])result)));
                }
                return (B1)A1;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan2 = x1;
                if (logicalPlan2 instanceof Command) {
                    return true;
                }
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.execution.QueryExecution )}, serializedLambda);
            }
        });
    }

    private LogicalPlan normalized$lzycompute() {
        QueryExecution queryExecution = this;
        synchronized (queryExecution) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                LogicalPlan logicalPlan2;
                Seq<Rule<LogicalPlan>> normalizationRules = this.sparkSession().sessionState().planNormalizationRules();
                if (normalizationRules.isEmpty()) {
                    logicalPlan2 = this.commandExecuted();
                } else {
                    PlanChangeLogger planChangeLogger = new PlanChangeLogger();
                    LogicalPlan normalized = (LogicalPlan)normalizationRules.foldLeft((Object)this.commandExecuted(), (Function2 & Serializable & scala.Serializable)(p, rule) -> {
                        LogicalPlan result = (LogicalPlan)rule.apply((TreeNode)p);
                        planChangeLogger.logRule(rule.ruleName(), (TreeNode)p, (TreeNode)result);
                        return result;
                    });
                    planChangeLogger.logBatch("Plan Normalization", (TreeNode)this.commandExecuted(), (TreeNode)normalized);
                    logicalPlan2 = normalized;
                }
                this.normalized = logicalPlan2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.normalized;
    }

    public LogicalPlan normalized() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.normalized$lzycompute();
        }
        return this.normalized;
    }

    private LogicalPlan withCachedData$lzycompute() {
        QueryExecution queryExecution = this;
        synchronized (queryExecution) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.withCachedData = (LogicalPlan)this.sparkSession().withActive((Function0 & Serializable & scala.Serializable)() -> {
                    this.assertAnalyzed();
                    this.assertSupported();
                    return this.sparkSession().sharedState().cacheManager().useCachedData(this.normalized().clone());
                });
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.withCachedData;
    }

    public LogicalPlan withCachedData() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.withCachedData$lzycompute();
        }
        return this.withCachedData;
    }

    public void assertCommandExecuted() {
        this.commandExecuted();
    }

    private LogicalPlan optimizedPlan$lzycompute() {
        QueryExecution queryExecution = this;
        synchronized (queryExecution) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.assertCommandExecuted();
                this.optimizedPlan = (LogicalPlan)this.executePhase(QueryPlanningTracker$.MODULE$.OPTIMIZATION(), (Function0 & Serializable & scala.Serializable)() -> {
                    LogicalPlan plan = (LogicalPlan)this.sparkSession().sessionState().optimizer().executeAndTrack((TreeNode)this.withCachedData().clone(), this.tracker());
                    plan.setAnalyzed();
                    return plan;
                });
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.optimizedPlan;
    }

    public LogicalPlan optimizedPlan() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.optimizedPlan$lzycompute();
        }
        return this.optimizedPlan;
    }

    private void assertOptimized() {
        this.optimizedPlan();
    }

    private SparkPlan sparkPlan$lzycompute() {
        QueryExecution queryExecution = this;
        synchronized (queryExecution) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.assertOptimized();
                this.sparkPlan = (SparkPlan)((Object)this.executePhase(QueryPlanningTracker$.MODULE$.PLANNING(), (Function0 & Serializable & scala.Serializable)() -> QueryExecution$.MODULE$.createSparkPlan(this.sparkSession(), this.planner(), this.optimizedPlan().clone())));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.sparkPlan;
    }

    public SparkPlan sparkPlan() {
        if ((byte)(this.bitmap$0 & 0x20) == 0) {
            return this.sparkPlan$lzycompute();
        }
        return this.sparkPlan;
    }

    private SparkPlan executedPlan$lzycompute() {
        QueryExecution queryExecution = this;
        synchronized (queryExecution) {
            if ((byte)(this.bitmap$0 & 0x40) == 0) {
                this.assertOptimized();
                this.executedPlan = (SparkPlan)((Object)this.executePhase(QueryPlanningTracker$.MODULE$.PLANNING(), (Function0 & Serializable & scala.Serializable)() -> QueryExecution$.MODULE$.prepareForExecution(this.preparations(), (SparkPlan)this.sparkPlan().clone())));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x40);
            }
        }
        return this.executedPlan;
    }

    public SparkPlan executedPlan() {
        if ((byte)(this.bitmap$0 & 0x40) == 0) {
            return this.executedPlan$lzycompute();
        }
        return this.executedPlan;
    }

    private RDD<InternalRow> toRdd$lzycompute() {
        QueryExecution queryExecution = this;
        synchronized (queryExecution) {
            if ((byte)(this.bitmap$0 & 0x80) == 0) {
                this.toRdd = new SQLExecutionRDD(this.executedPlan().execute(), this.sparkSession().sessionState().conf());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x80);
            }
        }
        return this.toRdd;
    }

    public RDD<InternalRow> toRdd() {
        if ((byte)(this.bitmap$0 & 0x80) == 0) {
            return this.toRdd$lzycompute();
        }
        return this.toRdd;
    }

    public Map<String, Row> observedMetrics() {
        return CollectMetricsExec$.MODULE$.collect(this.executedPlan());
    }

    public Seq<Rule<SparkPlan>> preparations() {
        return QueryExecution$.MODULE$.preparations(this.sparkSession(), (Option<InsertAdaptiveSparkPlan>)Option$.MODULE$.apply((Object)new InsertAdaptiveSparkPlan(new AdaptiveExecutionContext(this.sparkSession(), this))), false);
    }

    public <T> T executePhase(String phase, Function0<T> block) {
        return this.sparkSession().withActive((Function0 & Serializable & scala.Serializable)() -> QueryExecution$.MODULE$.withInternalError(new StringBuilder(51).append("The Spark SQL phase ").append(phase).append(" failed with an internal error.").toString(), (Function0 & Serializable & scala.Serializable)() -> this.tracker().measurePhase(phase, block)));
    }

    public String simpleString() {
        StringUtils.PlanStringConcat concat = new StringUtils.PlanStringConcat();
        this.simpleString(false, SQLConf$.MODULE$.get().maxToStringFields(), (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)s -> {
            concat.append(s);
            return BoxedUnit.UNIT;
        });
        return this.withRedaction(concat.toString());
    }

    private void simpleString(boolean formatted, int maxFields, Function1<String, BoxedUnit> append) {
        Object object;
        append.apply((Object)"== Physical Plan ==\n");
        if (formatted) {
            try {
                ExplainUtils$.MODULE$.processPlan(this.executedPlan(), append);
                object = BoxedUnit.UNIT;
            }
            catch (AnalysisException e) {
                object = append.apply((Object)e.toString());
            }
            catch (IllegalArgumentException e) {
                object = append.apply((Object)e.toString());
            }
        } else {
            QueryPlan$.MODULE$.append((Function0 & Serializable & scala.Serializable)() -> this.executedPlan(), append, false, false, maxFields, QueryPlan$.MODULE$.append$default$6());
            object = BoxedUnit.UNIT;
        }
        append.apply((Object)"\n");
    }

    public String explainString(ExplainMode mode) {
        StringUtils.PlanStringConcat concat = new StringUtils.PlanStringConcat();
        this.org$apache$spark$sql$execution$QueryExecution$$explainString(mode, SQLConf$.MODULE$.get().maxToStringFields(), (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)s -> {
            concat.append(s);
            return BoxedUnit.UNIT;
        });
        return this.withRedaction(concat.toString());
    }

    public void org$apache$spark$sql$execution$QueryExecution$$explainString(ExplainMode mode, int maxFields, Function1<String, BoxedUnit> append) {
        QueryExecution queryExecution = this.logical().isStreaming() ? new IncrementalExecution(this.sparkSession(), this.logical(), OutputMode.Append(), "<unknown>", UUID.randomUUID(), UUID.randomUUID(), 0L, (Option<OffsetSeqMetadata>)None$.MODULE$, new OffsetSeqMetadata(0L, 0L, OffsetSeqMetadata$.MODULE$.apply$default$3())) : this;
        ExplainMode explainMode = mode;
        if (SimpleMode$.MODULE$.equals(explainMode)) {
            queryExecution.simpleString(false, maxFields, append);
            return;
        }
        if (ExtendedMode$.MODULE$.equals(explainMode)) {
            queryExecution.toString(maxFields, append);
            return;
        }
        if (CodegenMode$.MODULE$.equals(explainMode)) {
            BoxedUnit boxedUnit;
            try {
                package$.MODULE$.writeCodegen(append, queryExecution.executedPlan());
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (AnalysisException e) {
                boxedUnit = (BoxedUnit)append.apply((Object)e.toString());
            }
            return;
        }
        if (CostMode$.MODULE$.equals(explainMode)) {
            queryExecution.stringWithStats(maxFields, append);
            return;
        }
        if (FormattedMode$.MODULE$.equals(explainMode)) {
            queryExecution.simpleString(true, maxFields, append);
            return;
        }
        throw new MatchError((Object)explainMode);
    }

    private void writePlans(Function1<String, BoxedUnit> append, int maxFields) {
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(true, false);
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        boolean verbose = sp2._1$mcZ$sp();
        boolean addSuffix = sp2._2$mcZ$sp();
        Tuple2.mcZZ.sp sp3 = new Tuple2.mcZZ.sp(verbose, addSuffix);
        boolean verbose2 = sp3._1$mcZ$sp();
        boolean addSuffix2 = sp3._2$mcZ$sp();
        append.apply((Object)"== Parsed Logical Plan ==\n");
        QueryPlan$.MODULE$.append((Function0 & Serializable & scala.Serializable)() -> this.logical(), append, verbose2, addSuffix2, maxFields, QueryPlan$.MODULE$.append$default$6());
        append.apply((Object)"\n== Analyzed Logical Plan ==\n");
        try {
            Object object;
            if (this.analyzed().output().nonEmpty()) {
                append.apply((Object)org.apache.spark.sql.catalyst.util.package$.MODULE$.truncatedString((Seq)this.analyzed().output().map((Function1 & Serializable & scala.Serializable)o -> new StringBuilder(2).append(o.name()).append(": ").append(o.dataType().simpleString()).toString(), Seq$.MODULE$.canBuildFrom()), ", ", maxFields));
                object = append.apply((Object)"\n");
            } else {
                object = BoxedUnit.UNIT;
            }
            QueryPlan$.MODULE$.append((Function0 & Serializable & scala.Serializable)() -> this.analyzed(), append, verbose2, addSuffix2, maxFields, QueryPlan$.MODULE$.append$default$6());
            append.apply((Object)"\n== Optimized Logical Plan ==\n");
            QueryPlan$.MODULE$.append((Function0 & Serializable & scala.Serializable)() -> this.optimizedPlan(), append, verbose2, addSuffix2, maxFields, QueryPlan$.MODULE$.append$default$6());
            append.apply((Object)"\n== Physical Plan ==\n");
            QueryPlan$.MODULE$.append((Function0 & Serializable & scala.Serializable)() -> this.executedPlan(), append, verbose2, addSuffix2, maxFields, QueryPlan$.MODULE$.append$default$6());
        }
        catch (AnalysisException e) {
            append.apply((Object)e.toString());
        }
    }

    public String toString() {
        StringUtils.PlanStringConcat concat = new StringUtils.PlanStringConcat();
        this.toString(SQLConf$.MODULE$.get().maxToStringFields(), (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)s -> {
            concat.append(s);
            return BoxedUnit.UNIT;
        });
        return this.withRedaction(this.withRedaction(concat.toString()));
    }

    private void toString(int maxFields, Function1<String, BoxedUnit> append) {
        this.writePlans(append, maxFields);
    }

    public String stringWithStats() {
        StringUtils.PlanStringConcat concat = new StringUtils.PlanStringConcat();
        this.stringWithStats(SQLConf$.MODULE$.get().maxToStringFields(), (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)s -> {
            concat.append(s);
            return BoxedUnit.UNIT;
        });
        return this.withRedaction(concat.toString());
    }

    private void stringWithStats(int maxFields, Function1<String, BoxedUnit> append) {
        Object object;
        try {
            object = this.optimizedPlan().collectWithSubqueries((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    return (B1)A1.stats();
                }

                public final boolean isDefinedAt(LogicalPlan x1) {
                    LogicalPlan logicalPlan2 = x1;
                    return true;
                }
            });
        }
        catch (AnalysisException e) {
            object = append.apply((Object)new StringBuilder(1).append(e.toString()).append("\n").toString());
        }
        append.apply((Object)"== Optimized Logical Plan ==\n");
        QueryPlan$.MODULE$.append((Function0 & Serializable & scala.Serializable)() -> this.optimizedPlan(), append, true, true, maxFields, QueryPlan$.MODULE$.append$default$6());
        append.apply((Object)"\n== Physical Plan ==\n");
        QueryPlan$.MODULE$.append((Function0 & Serializable & scala.Serializable)() -> this.executedPlan(), append, true, false, maxFields, QueryPlan$.MODULE$.append$default$6());
        append.apply((Object)"\n");
    }

    private String withRedaction(String message) {
        return Utils$.MODULE$.redact(this.sparkSession().sessionState().conf().stringRedactionPattern(), message);
    }

    private final void debug$lzycompute$1() {
        QueryExecution queryExecution = this;
        synchronized (queryExecution) {
            if (this.debug$module == null) {
                this.debug$module = new QueryExecution$debug$(this);
            }
        }
    }

    public QueryExecution(SparkSession sparkSession, LogicalPlan logical, QueryPlanningTracker tracker, Enumeration.Value mode) {
        this.sparkSession = sparkSession;
        this.logical = logical;
        this.tracker = tracker;
        this.mode = mode;
        Logging.$init$((Logging)this);
        this.id = QueryExecution$.MODULE$.org$apache$spark$sql$execution$QueryExecution$$nextExecutionId();
    }
}

