/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.io.Serializable;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.OutputCommitCoordinator;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.metric.CustomTaskMetric;
import org.apache.spark.sql.connector.write.DataWriter;
import org.apache.spark.sql.connector.write.DataWriterFactory;
import org.apache.spark.sql.connector.write.WriterCommitMessage;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.v2.DataWritingSparkTaskResult;
import org.apache.spark.sql.execution.metric.CustomMetrics$;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001q4q\u0001B\u0003\u0011\u0002\u0007\u0005A\u0003C\u0003&\u0001\u0011\u0005a\u0005C\u0003+\u0001\u0019E1\u0006C\u0003F\u0001\u0011\u0005aI\u0001\tXe&$\u0018N\\4Ta\u0006\u00148\u000eV1tW*\u0011aaB\u0001\u0003mJR!\u0001C\u0005\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u0003\u0015-\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u00051i\u0011aA:rY*\u0011abD\u0001\u0006gB\f'o\u001b\u0006\u0003!E\ta!\u00199bG\",'\"\u0001\n\u0002\u0007=\u0014xm\u0001\u0001\u0016\u0005U\u00014\u0003\u0002\u0001\u00179\t\u0002\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u0011a!\u00118z%\u00164\u0007CA\u000f!\u001b\u0005q\"BA\u0010\u000e\u0003!Ig\u000e^3s]\u0006d\u0017BA\u0011\u001f\u0005\u001daunZ4j]\u001e\u0004\"aF\u0012\n\u0005\u0011B\"\u0001D*fe&\fG.\u001b>bE2,\u0017A\u0002\u0013j]&$H\u0005F\u0001(!\t9\u0002&\u0003\u0002*1\t!QK\\5u\u0003\u00159(/\u001b;f)\r9Cf\u0011\u0005\u0006[\t\u0001\rAL\u0001\u0007oJLG/\u001a:\u0011\u0005=\u0002D\u0002\u0001\u0003\u0006c\u0001\u0011\rA\r\u0002\u0002/F\u00111G\u000e\t\u0003/QJ!!\u000e\r\u0003\u000f9{G\u000f[5oOB\u0019qgO\u001f\u000e\u0003aR!AK\u001d\u000b\u0005iZ\u0011!C2p]:,7\r^8s\u0013\ta\u0004H\u0001\u0006ECR\fwK]5uKJ\u0004\"AP!\u000e\u0003}R!\u0001Q\u0006\u0002\u0011\r\fG/\u00197zgRL!AQ \u0003\u0017%sG/\u001a:oC2\u0014vn\u001e\u0005\u0006\t\n\u0001\r!P\u0001\u0004e><\u0018a\u0001:v]R1qi\u0013)WI&\u0004\"\u0001S%\u000e\u0003\u0015I!AS\u0003\u00035\u0011\u000bG/Y,sSRLgnZ*qCJ\\G+Y:l%\u0016\u001cX\u000f\u001c;\t\u000b1\u001b\u0001\u0019A'\u0002\u001b]\u0014\u0018\u000e^3s\r\u0006\u001cGo\u001c:z!\t9d*\u0003\u0002Pq\t\tB)\u0019;b/JLG/\u001a:GC\u000e$xN]=\t\u000bE\u001b\u0001\u0019\u0001*\u0002\u000f\r|g\u000e^3yiB\u00111\u000bV\u0007\u0002\u001b%\u0011Q+\u0004\u0002\f)\u0006\u001c8nQ8oi\u0016DH\u000fC\u0003X\u0007\u0001\u0007\u0001,\u0001\u0003ji\u0016\u0014\bcA-b{9\u0011!l\u0018\b\u00037zk\u0011\u0001\u0018\u0006\u0003;N\ta\u0001\u0010:p_Rt\u0014\"A\r\n\u0005\u0001D\u0012a\u00029bG.\fw-Z\u0005\u0003E\u000e\u0014\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0003AbAQ!Z\u0002A\u0002\u0019\fA#^:f\u0007>lW.\u001b;D_>\u0014H-\u001b8bi>\u0014\bCA\fh\u0013\tA\u0007DA\u0004C_>dW-\u00198\t\u000b)\u001c\u0001\u0019A6\u0002\u001b\r,8\u000f^8n\u001b\u0016$(/[2t!\u0011a\u0007o\u001d<\u000f\u00055t\u0007CA.\u0019\u0013\ty\u0007$\u0001\u0004Qe\u0016$WMZ\u0005\u0003cJ\u00141!T1q\u0015\ty\u0007\u0004\u0005\u0002mi&\u0011QO\u001d\u0002\u0007'R\u0014\u0018N\\4\u0011\u0005]TX\"\u0001=\u000b\u0005eL\u0011AB7fiJL7-\u0003\u0002|q\nI1+\u0015'NKR\u0014\u0018n\u0019")
public interface WritingSparkTask<W extends DataWriter<InternalRow>>
extends Logging,
scala.Serializable {
    public void write(W var1, InternalRow var2);

    public static /* synthetic */ DataWritingSparkTaskResult run$(WritingSparkTask $this, DataWriterFactory writerFactory, TaskContext context, Iterator iter, boolean useCommitCoordinator, Map customMetrics) {
        return $this.run(writerFactory, context, (Iterator<InternalRow>)iter, useCommitCoordinator, (Map<String, SQLMetric>)customMetrics);
    }

    default public DataWritingSparkTaskResult run(DataWriterFactory writerFactory, TaskContext context, Iterator<InternalRow> iter, boolean useCommitCoordinator, Map<String, SQLMetric> customMetrics) {
        int stageId = context.stageId();
        int stageAttempt = context.stageAttemptNumber();
        int partId = context.partitionId();
        long taskId = context.taskAttemptId();
        int attemptId = context.attemptNumber();
        DataWriter dataWriter = writerFactory.createWriter(partId, taskId);
        LongRef count = LongRef.create((long)0L);
        return (DataWritingSparkTaskResult)Utils$.MODULE$.tryWithSafeFinallyAndFailureCallbacks((Function0 & Serializable & scala.Serializable)() -> {
            WriterCommitMessage writerCommitMessage;
            while (iter.hasNext()) {
                if (count$1.elem % (long)CustomMetrics$.MODULE$.NUM_ROWS_PER_UPDATE() == 0L) {
                    CustomMetrics$.MODULE$.updateMetrics((Seq<CustomTaskMetric>)Predef$.MODULE$.wrapRefArray((Object[])dataWriter.currentMetricsValues()), customMetrics);
                }
                ++count$1.elem;
                this.write(dataWriter, (InternalRow)iter.next());
            }
            CustomMetrics$.MODULE$.updateMetrics((Seq<CustomTaskMetric>)Predef$.MODULE$.wrapRefArray((Object[])dataWriter.currentMetricsValues()), customMetrics);
            if (useCommitCoordinator) {
                OutputCommitCoordinator coordinator = SparkEnv$.MODULE$.get().outputCommitCoordinator();
                boolean commitAuthorized = coordinator.canCommit(stageId, stageAttempt, partId, attemptId);
                if (!commitAuthorized) {
                    Throwable commitDeniedException = QueryExecutionErrors$.MODULE$.commitDeniedError(partId, taskId, attemptId, stageId, stageAttempt);
                    this.logInfo((Function0 & Serializable & scala.Serializable)() -> commitDeniedException.getMessage());
                    throw commitDeniedException;
                }
                this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Commit authorized for partition ").append(partId).append(" (task ").append(taskId).append(", attempt ").append(attemptId).append(", ").append("stage ").append(stageId).append(".").append(stageAttempt).append(")").toString());
                writerCommitMessage = dataWriter.commit();
            } else {
                this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Writer for partition ").append(context.partitionId()).append(" is committing.").toString());
                writerCommitMessage = dataWriter.commit();
            }
            WriterCommitMessage msg = writerCommitMessage;
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Committed partition ").append(partId).append(" (task ").append(taskId).append(", attempt ").append(attemptId).append(", ").append("stage ").append(stageId).append(".").append(stageAttempt).append(")").toString());
            return new DataWritingSparkTaskResult(count$1.elem, msg);
        }, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.logError((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Aborting commit for partition ").append(partId).append(" (task ").append(taskId).append(", attempt ").append(attemptId).append(", ").append("stage ").append(stageId).append(".").append(stageAttempt).append(")").toString());
            dataWriter.abort();
            this.logError((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Aborted commit for partition ").append(partId).append(" (task ").append(taskId).append(", attempt ").append(attemptId).append(", ").append("stage ").append(stageId).append(".").append(stageAttempt).append(")").toString());
        }, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> dataWriter.close());
    }

    public static void $init$(WritingSparkTask $this) {
    }
}

