/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.RuntimeConfig;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.streaming.EventTimeWatermarkExec;
import org.apache.spark.sql.execution.streaming.MultipleWatermarkPolicy;
import org.apache.spark.sql.execution.streaming.WatermarkTracker$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005}d\u0001B\u000f\u001f\u0001.B\u0001B\u0010\u0001\u0003\u0016\u0004%\ta\u0010\u0005\t\t\u0002\u0011\t\u0012)A\u0005\u0001\")Q\t\u0001C\u0001\r\"9\u0011\n\u0001b\u0001\n\u0013Q\u0005BB-\u0001A\u0003%1\nC\u0004[\u0001\u0001\u0007I\u0011B.\t\u000fq\u0003\u0001\u0019!C\u0005;\"11\r\u0001Q!\nYCQ\u0001\u001a\u0001\u0005\u0002\u0015DQ\u0001\u001b\u0001\u0005\u0002%DQ\u0001\u001d\u0001\u0005\u0002mCq!\u001d\u0001\u0002\u0002\u0013\u0005!\u000fC\u0004u\u0001E\u0005I\u0011A;\t\u0013\u0005\u0005\u0001!!A\u0005B\u0005\r\u0001\"CA\u000b\u0001\u0005\u0005I\u0011AA\f\u0011%\tI\u0002AA\u0001\n\u0003\tY\u0002C\u0005\u0002&\u0001\t\t\u0011\"\u0011\u0002(!I\u0011\u0011\u0007\u0001\u0002\u0002\u0013\u0005\u00111\u0007\u0005\n\u0003{\u0001\u0011\u0011!C!\u0003\u007fA\u0011\"!\u0011\u0001\u0003\u0003%\t%a\u0011\t\u0013\u0005\u0015\u0003!!A\u0005B\u0005\u001dsaBA&=!\u0005\u0011Q\n\u0004\u0007;yA\t!a\u0014\t\r\u0015;B\u0011AA)\u0011\u001d\t\u0019f\u0006C\u0001\u0003+B\u0011\"a\u0015\u0018\u0003\u0003%\t)a\u0019\t\u0013\u0005\u001dt#!A\u0005\u0002\u0006%\u0004\"CA;/\u0005\u0005I\u0011BA<\u0005A9\u0016\r^3s[\u0006\u00148\u000e\u0016:bG.,'O\u0003\u0002 A\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003C\t\n\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005\r\"\u0013aA:rY*\u0011QEJ\u0001\u0006gB\f'o\u001b\u0006\u0003O!\na!\u00199bG\",'\"A\u0015\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001a#\u0007O\u001e\u0011\u00055\u0002T\"\u0001\u0018\u000b\u0003=\nQa]2bY\u0006L!!\r\u0018\u0003\r\u0005s\u0017PU3g!\t\u0019d'D\u00015\u0015\t)D%\u0001\u0005j]R,'O\\1m\u0013\t9DGA\u0004M_\u001e<\u0017N\\4\u0011\u00055J\u0014B\u0001\u001e/\u0005\u001d\u0001&o\u001c3vGR\u0004\"!\f\u001f\n\u0005ur#\u0001D*fe&\fG.\u001b>bE2,\u0017A\u00029pY&\u001c\u00170F\u0001A!\t\t%)D\u0001\u001f\u0013\t\u0019eDA\fNk2$\u0018\u000e\u001d7f/\u0006$XM]7be.\u0004v\u000e\\5ds\u00069\u0001o\u001c7jGf\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002H\u0011B\u0011\u0011\t\u0001\u0005\u0006}\r\u0001\r\u0001Q\u0001\u0017_B,'/\u0019;peR{w+\u0019;fe6\f'o['baV\t1\n\u0005\u0003M#N3V\"A'\u000b\u00059{\u0015aB7vi\u0006\u0014G.\u001a\u0006\u0003!:\n!bY8mY\u0016\u001cG/[8o\u0013\t\u0011VJA\u0004ICNDW*\u00199\u0011\u00055\"\u0016BA+/\u0005\rIe\u000e\u001e\t\u0003[]K!\u0001\u0017\u0018\u0003\t1{gnZ\u0001\u0018_B,'/\u0019;peR{w+\u0019;fe6\f'o['ba\u0002\n\u0011c\u001a7pE\u0006dw+\u0019;fe6\f'o['t+\u00051\u0016!F4m_\n\fGnV1uKJl\u0017M]6Ng~#S-\u001d\u000b\u0003=\u0006\u0004\"!L0\n\u0005\u0001t#\u0001B+oSRDqAY\u0004\u0002\u0002\u0003\u0007a+A\u0002yIE\n!c\u001a7pE\u0006dw+\u0019;fe6\f'o['tA\u0005a1/\u001a;XCR,'/\\1sWR\u0011aL\u001a\u0005\u0006O&\u0001\rAV\u0001\u000f]\u0016<x+\u0019;fe6\f'o['t\u0003=)\b\u000fZ1uK^\u000bG/\u001a:nCJ\\GC\u00010k\u0011\u0015Y'\u00021\u0001m\u00031)\u00070Z2vi\u0016$\u0007\u000b\\1o!\tig.D\u0001!\u0013\ty\u0007EA\u0005Ta\u0006\u00148\u000e\u00157b]\u0006\u00012-\u001e:sK:$x+\u0019;fe6\f'o[\u0001\u0005G>\u0004\u0018\u0010\u0006\u0002Hg\"9a\b\u0004I\u0001\u0002\u0004\u0001\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0002m*\u0012\u0001i^\u0016\u0002qB\u0011\u0011P`\u0007\u0002u*\u00111\u0010`\u0001\nk:\u001c\u0007.Z2lK\u0012T!! \u0018\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002\u0000u\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t)\u0001\u0005\u0003\u0002\b\u0005EQBAA\u0005\u0015\u0011\tY!!\u0004\u0002\t1\fgn\u001a\u0006\u0003\u0003\u001f\tAA[1wC&!\u00111CA\u0005\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\t1+\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005u\u00111\u0005\t\u0004[\u0005}\u0011bAA\u0011]\t\u0019\u0011I\\=\t\u000f\t\u0004\u0012\u0011!a\u0001'\u0006y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002*A1\u00111FA\u0017\u0003;i\u0011aT\u0005\u0004\u0003_y%\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!\u000e\u0002<A\u0019Q&a\u000e\n\u0007\u0005ebFA\u0004C_>dW-\u00198\t\u0011\t\u0014\u0012\u0011!a\u0001\u0003;\t\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002'\u0006AAo\\*ue&tw\r\u0006\u0002\u0002\u0006\u00051Q-];bYN$B!!\u000e\u0002J!A!-FA\u0001\u0002\u0004\ti\"\u0001\tXCR,'/\\1sWR\u0013\u0018mY6feB\u0011\u0011iF\n\u0004/1ZDCAA'\u0003\u0015\t\u0007\u000f\u001d7z)\r9\u0015q\u000b\u0005\b\u00033J\u0002\u0019AA.\u0003\u0011\u0019wN\u001c4\u0011\t\u0005u\u0013qL\u0007\u0002E%\u0019\u0011\u0011\r\u0012\u0003\u001bI+h\u000e^5nK\u000e{gNZ5h)\r9\u0015Q\r\u0005\u0006}i\u0001\r\u0001Q\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\tY'!\u001d\u0011\t5\ni\u0007Q\u0005\u0004\u0003_r#AB(qi&|g\u000e\u0003\u0005\u0002tm\t\t\u00111\u0001H\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002zA!\u0011qAA>\u0013\u0011\ti(!\u0003\u0003\r=\u0013'.Z2u\u0001")
public class WatermarkTracker
implements Logging,
Product,
scala.Serializable {
    private final MultipleWatermarkPolicy policy;
    private final HashMap<Object, Object> operatorToWatermarkMap;
    private long globalWatermarkMs;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Option<MultipleWatermarkPolicy> unapply(WatermarkTracker watermarkTracker) {
        return WatermarkTracker$.MODULE$.unapply(watermarkTracker);
    }

    public static WatermarkTracker apply(MultipleWatermarkPolicy multipleWatermarkPolicy) {
        return WatermarkTracker$.MODULE$.apply(multipleWatermarkPolicy);
    }

    public static WatermarkTracker apply(RuntimeConfig runtimeConfig) {
        return WatermarkTracker$.MODULE$.apply(runtimeConfig);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public MultipleWatermarkPolicy policy() {
        return this.policy;
    }

    private HashMap<Object, Object> operatorToWatermarkMap() {
        return this.operatorToWatermarkMap;
    }

    private long globalWatermarkMs() {
        return this.globalWatermarkMs;
    }

    private void globalWatermarkMs_$eq(long x$1) {
        this.globalWatermarkMs = x$1;
    }

    public synchronized void setWatermark(long newWatermarkMs) {
        this.globalWatermarkMs_$eq(newWatermarkMs);
    }

    public synchronized void updateWatermark(SparkPlan executedPlan) {
        Seq watermarkOperators = executedPlan.collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof EventTimeWatermarkExec) {
                    EventTimeWatermarkExec eventTimeWatermarkExec = (EventTimeWatermarkExec)A1;
                    return (B1)eventTimeWatermarkExec;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(SparkPlan x1) {
                SparkPlan sparkPlan = x1;
                return sparkPlan instanceof EventTimeWatermarkExec;
            }
        });
        if (watermarkOperators.isEmpty()) {
            return;
        }
        ((IterableLike)watermarkOperators.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                EventTimeWatermarkExec e = (EventTimeWatermarkExec)tuple2._1();
                int index = tuple2._2$mcI$sp();
                if (e.eventTimeStats().value().count() > 0L) {
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Observed event time stats ").append(index).append(": ").append(e.eventTimeStats().value()).toString());
                    long newWatermarkMs = e.eventTimeStats().value().max() - e.delayMs();
                    Option prevWatermarkMs = this.operatorToWatermarkMap().get((Object)BoxesRunTime.boxToInteger((int)index));
                    if (prevWatermarkMs.isEmpty() || newWatermarkMs > BoxesRunTime.unboxToLong((Object)prevWatermarkMs.get())) {
                        return this.operatorToWatermarkMap().put((Object)BoxesRunTime.boxToInteger((int)index), (Object)BoxesRunTime.boxToLong((long)newWatermarkMs));
                    }
                    return BoxedUnit.UNIT;
                }
            }
            if (tuple2 != null) {
                int index = tuple2._2$mcI$sp();
                if (!this.operatorToWatermarkMap().isDefinedAt((Object)BoxesRunTime.boxToInteger((int)index))) {
                    return this.operatorToWatermarkMap().put((Object)BoxesRunTime.boxToInteger((int)index), (Object)BoxesRunTime.boxToLong((long)0L));
                }
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)tuple2);
        });
        long chosenGlobalWatermark = this.policy().chooseGlobalWatermark((Seq<Object>)this.operatorToWatermarkMap().values().toSeq());
        if (chosenGlobalWatermark > this.globalWatermarkMs()) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Updating event-time watermark from ").append(this.globalWatermarkMs()).append(" to ").append(chosenGlobalWatermark).append(" ms").toString());
            this.globalWatermarkMs_$eq(chosenGlobalWatermark);
            return;
        }
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Event time watermark didn't move: ").append(chosenGlobalWatermark).append(" < ").append(this.globalWatermarkMs()).toString());
    }

    public synchronized long currentWatermark() {
        return this.globalWatermarkMs();
    }

    public WatermarkTracker copy(MultipleWatermarkPolicy policy) {
        return new WatermarkTracker(policy);
    }

    public MultipleWatermarkPolicy copy$default$1() {
        return this.policy();
    }

    public String productPrefix() {
        return "WatermarkTracker";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.policy();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof WatermarkTracker;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof WatermarkTracker)) return false;
        boolean bl = true;
        if (!bl) return false;
        WatermarkTracker watermarkTracker = (WatermarkTracker)x$1;
        MultipleWatermarkPolicy multipleWatermarkPolicy = this.policy();
        MultipleWatermarkPolicy multipleWatermarkPolicy2 = watermarkTracker.policy();
        if (multipleWatermarkPolicy == null) {
            if (multipleWatermarkPolicy2 != null) {
                return false;
            }
        } else if (!multipleWatermarkPolicy.equals(multipleWatermarkPolicy2)) return false;
        if (!watermarkTracker.canEqual(this)) return false;
        return true;
    }

    public WatermarkTracker(MultipleWatermarkPolicy policy) {
        this.policy = policy;
        Logging.$init$((Logging)this);
        Product.$init$((Product)this);
        this.operatorToWatermarkMap = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.globalWatermarkMs = 0L;
    }
}

