/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.internal;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import org.apache.hadoop.fs.Path;
import org.apache.spark.annotation.Unstable;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.ArchiveResource$;
import org.apache.spark.sql.catalyst.catalog.FileResource$;
import org.apache.spark.sql.catalyst.catalog.FunctionResource;
import org.apache.spark.sql.catalyst.catalog.FunctionResourceLoader;
import org.apache.spark.sql.catalyst.catalog.FunctionResourceType;
import org.apache.spark.sql.catalyst.catalog.JarResource$;
import org.apache.spark.util.DependencyUtils$;
import org.apache.spark.util.Utils$;
import scala.Function1;
import scala.MatchError;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Unstable
@ScalaSignature(bytes="\u0006\u0001}3AAB\u0004\u0001%!A\u0011\u0005\u0001B\u0001B\u0003%!\u0005C\u0003'\u0001\u0011\u0005q\u0005C\u0003,\u0001\u0011\u0005C\u0006C\u00036\u0001\u0011\u0005a\u0007C\u0003V\u0001\u0011\u0005aKA\u000bTKN\u001c\u0018n\u001c8SKN|WO]2f\u0019>\fG-\u001a:\u000b\u0005!I\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005)Y\u0011aA:rY*\u0011A\"D\u0001\u0006gB\f'o\u001b\u0006\u0003\u001d=\ta!\u00199bG\",'\"\u0001\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0019\u0012\u0004\u0005\u0002\u0015/5\tQCC\u0001\u0017\u0003\u0015\u00198-\u00197b\u0013\tARC\u0001\u0004B]f\u0014VM\u001a\t\u00035}i\u0011a\u0007\u0006\u00039u\tqaY1uC2|wM\u0003\u0002\u001f\u0013\u0005A1-\u0019;bYf\u001cH/\u0003\u0002!7\t1b)\u001e8di&|gNU3t_V\u00148-\u001a'pC\u0012,'/A\u0004tKN\u001c\u0018n\u001c8\u0011\u0005\r\"S\"A\u0005\n\u0005\u0015J!\u0001D*qCJ\\7+Z:tS>t\u0017A\u0002\u001fj]&$h\b\u0006\u0002)UA\u0011\u0011\u0006A\u0007\u0002\u000f!)\u0011E\u0001a\u0001E\u0005aAn\\1e%\u0016\u001cx.\u001e:dKR\u0011Q\u0006\r\t\u0003)9J!aL\u000b\u0003\tUs\u0017\u000e\u001e\u0005\u0006c\r\u0001\rAM\u0001\te\u0016\u001cx.\u001e:dKB\u0011!dM\u0005\u0003im\u0011\u0001CR;oGRLwN\u001c*fg>,(oY3\u0002\u0017I,7o\u001c7wK*\u000b'o\u001d\u000b\u0003o-\u00032\u0001\u000f!D\u001d\tIdH\u0004\u0002;{5\t1H\u0003\u0002=#\u00051AH]8pizJ\u0011AF\u0005\u0003\u007fU\tq\u0001]1dW\u0006<W-\u0003\u0002B\u0005\n\u00191+Z9\u000b\u0005}*\u0002C\u0001#I\u001d\t)e\t\u0005\u0002;+%\u0011q)F\u0001\u0007!J,G-\u001a4\n\u0005%S%AB*ue&twM\u0003\u0002H+!)A\n\u0002a\u0001\u001b\u0006!\u0001/\u0019;i!\tq5+D\u0001P\u0015\t\u0001\u0016+A\u0002oKRT\u0011AU\u0001\u0005U\u00064\u0018-\u0003\u0002U\u001f\n\u0019QKU%\u0002\r\u0005$GMS1s)\tis\u000bC\u0003M\u000b\u0001\u00071\t\u000b\u0002\u00013B\u0011!,X\u0007\u00027*\u0011AlC\u0001\u000bC:tw\u000e^1uS>t\u0017B\u00010\\\u0005!)fn\u001d;bE2,\u0007")
public class SessionResourceLoader
implements FunctionResourceLoader {
    private final SparkSession session;

    public void loadResource(FunctionResource resource) {
        FunctionResourceType functionResourceType = resource.resourceType();
        if (JarResource$.MODULE$.equals(functionResourceType)) {
            this.addJar(resource.uri());
            return;
        }
        if (FileResource$.MODULE$.equals(functionResourceType)) {
            this.session.sparkContext().addFile(resource.uri());
            return;
        }
        if (ArchiveResource$.MODULE$.equals(functionResourceType)) {
            this.session.sparkContext().addArchive(resource.uri());
            return;
        }
        throw new MatchError((Object)functionResourceType);
    }

    public Seq<String> resolveJars(URI path) {
        String string = path.getScheme();
        if ("ivy".equals(string)) {
            return DependencyUtils$.MODULE$.resolveMavenDependencies(path);
        }
        String string2 = path.toString();
        return Nil$.MODULE$.$colon$colon((Object)string2);
    }

    public void addJar(String path) {
        URI uri = Utils$.MODULE$.resolveURI(path);
        this.resolveJars(uri).foreach((Function1 & Serializable & scala.Serializable)p -> {
            SessionResourceLoader.$anonfun$addJar$1(this, p);
            return BoxedUnit.UNIT;
        });
        Thread.currentThread().setContextClassLoader((ClassLoader)((Object)this.session.sharedState().jarClassLoader()));
    }

    public static final /* synthetic */ void $anonfun$addJar$1(SessionResourceLoader $this, String p) {
        $this.session.sparkContext().addJar(p);
        URI uri = new Path(p).toUri();
        URL jarURL = uri.getScheme() == null ? new File(p).toURI().toURL() : uri.toURL();
        $this.session.sharedState().jarClassLoader().addURL(jarURL);
    }

    public SessionResourceLoader(SparkSession session) {
        this.session = session;
    }
}

