/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.TimeZone;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Sort;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.execution.SQLExecution$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.CanEqual;
import org.scalactic.Equality;
import org.scalactic.Equivalence;
import org.scalactic.Prettifier;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEquals;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions;
import org.scalatest.Assertions$;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenSet;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class QueryTest$
implements Assertions,
scala.Serializable {
    public static QueryTest$ MODULE$;
    private final Assertion succeed;

    static {
        new QueryTest$();
    }

    public Throwable newAssertionFailedException(Option<String> optionalMessage, Option<Throwable> optionalCause, Position pos, IndexedSeq<String> analysis) {
        return Assertions.newAssertionFailedException$((Assertions)this, optionalMessage, optionalCause, (Position)pos, analysis);
    }

    public Throwable newTestCanceledException(Option<String> optionalMessage, Option<Throwable> optionalCause, Position pos) {
        return Assertions.newTestCanceledException$((Assertions)this, optionalMessage, optionalCause, (Position)pos);
    }

    public <T> T intercept(Function0<Object> f, ClassTag<T> classTag, Position pos) {
        return (T)Assertions.intercept$((Assertions)this, f, classTag, (Position)pos);
    }

    public <T> Assertion assertThrows(Function0<Object> f, ClassTag<T> classTag, Position pos) {
        return Assertions.assertThrows$((Assertions)this, f, classTag, (Position)pos);
    }

    public Assertion assertResult(Object expected, Object clue, Object actual, Prettifier prettifier, Position pos) {
        return Assertions.assertResult$((Assertions)this, (Object)expected, (Object)clue, (Object)actual, (Prettifier)prettifier, (Position)pos);
    }

    public Assertion assertResult(Object expected, Object actual, Prettifier prettifier, Position pos) {
        return Assertions.assertResult$((Assertions)this, (Object)expected, (Object)actual, (Prettifier)prettifier, (Position)pos);
    }

    public Nothing$ fail(Position pos) {
        return Assertions.fail$((Assertions)this, (Position)pos);
    }

    public Nothing$ fail(String message, Position pos) {
        return Assertions.fail$((Assertions)this, (String)message, (Position)pos);
    }

    public Nothing$ fail(String message, Throwable cause, Position pos) {
        return Assertions.fail$((Assertions)this, (String)message, (Throwable)cause, (Position)pos);
    }

    public Nothing$ fail(Throwable cause, Position pos) {
        return Assertions.fail$((Assertions)this, (Throwable)cause, (Position)pos);
    }

    public Nothing$ cancel(Position pos) {
        return Assertions.cancel$((Assertions)this, (Position)pos);
    }

    public Nothing$ cancel(String message, Position pos) {
        return Assertions.cancel$((Assertions)this, (String)message, (Position)pos);
    }

    public Nothing$ cancel(String message, Throwable cause, Position pos) {
        return Assertions.cancel$((Assertions)this, (String)message, (Throwable)cause, (Position)pos);
    }

    public Nothing$ cancel(Throwable cause, Position pos) {
        return Assertions.cancel$((Assertions)this, (Throwable)cause, (Position)pos);
    }

    public <T> T withClue(Object clue, Function0<T> fun) {
        return (T)Assertions.withClue$((Assertions)this, (Object)clue, fun);
    }

    public Assertion pending() {
        return Assertions.pending$((Assertions)this);
    }

    public Assertion pendingUntilFixed(Function0<BoxedUnit> f, Position pos) {
        return Assertions.pendingUntilFixed$((Assertions)this, f, (Position)pos);
    }

    public <T> TripleEqualsSupport.Equalizer<T> convertToEqualizer(T left) {
        return TripleEquals.convertToEqualizer$((TripleEquals)this, left);
    }

    public <T> TripleEqualsSupport.CheckingEqualizer<T> convertToCheckingEqualizer(T left) {
        return TripleEquals.convertToCheckingEqualizer$((TripleEquals)this, left);
    }

    public <A, B> CanEqual<A, B> unconstrainedEquality(Equality<A> equalityOfA) {
        return TripleEquals.unconstrainedEquality$((TripleEquals)this, equalityOfA);
    }

    public <A, B> CanEqual<A, B> lowPriorityTypeCheckedConstraint(Equivalence<B> equivalenceOfB, Predef.$less$colon$less<A, B> ev) {
        return TripleEquals.lowPriorityTypeCheckedConstraint$((TripleEquals)this, equivalenceOfB, ev);
    }

    public <A, B> CanEqual<A, B> convertEquivalenceToAToBConstraint(Equivalence<B> equivalenceOfB, Predef.$less$colon$less<A, B> ev) {
        return TripleEquals.convertEquivalenceToAToBConstraint$((TripleEquals)this, equivalenceOfB, ev);
    }

    public <A, B> CanEqual<A, B> typeCheckedConstraint(Equivalence<A> equivalenceOfA, Predef.$less$colon$less<B, A> ev) {
        return TripleEquals.typeCheckedConstraint$((TripleEquals)this, equivalenceOfA, ev);
    }

    public <A, B> CanEqual<A, B> convertEquivalenceToBToAConstraint(Equivalence<A> equivalenceOfA, Predef.$less$colon$less<B, A> ev) {
        return TripleEquals.convertEquivalenceToBToAConstraint$((TripleEquals)this, equivalenceOfA, ev);
    }

    public <A, B> CanEqual<A, B> lowPriorityConversionCheckedConstraint(Equivalence<B> equivalenceOfB, Function1<A, B> cnv) {
        return TripleEquals.lowPriorityConversionCheckedConstraint$((TripleEquals)this, equivalenceOfB, cnv);
    }

    public <A, B> CanEqual<A, B> convertEquivalenceToAToBConversionConstraint(Equivalence<B> equivalenceOfB, Function1<A, B> ev) {
        return TripleEquals.convertEquivalenceToAToBConversionConstraint$((TripleEquals)this, equivalenceOfB, ev);
    }

    public <A, B> CanEqual<A, B> conversionCheckedConstraint(Equivalence<A> equivalenceOfA, Function1<B, A> cnv) {
        return TripleEquals.conversionCheckedConstraint$((TripleEquals)this, equivalenceOfA, cnv);
    }

    public <A, B> CanEqual<A, B> convertEquivalenceToBToAConversionConstraint(Equivalence<A> equivalenceOfA, Function1<B, A> ev) {
        return TripleEquals.convertEquivalenceToBToAConversionConstraint$((TripleEquals)this, equivalenceOfA, ev);
    }

    public <A> Equality<A> defaultEquality() {
        return TripleEqualsSupport.defaultEquality$((TripleEqualsSupport)this);
    }

    public <T> TripleEqualsSupport.TripleEqualsInvocation<T> $eq$eq$eq(T right) {
        return TripleEqualsSupport.$eq$eq$eq$((TripleEqualsSupport)this, right);
    }

    public <T> TripleEqualsSupport.TripleEqualsInvocation<T> $bang$eq$eq(T right) {
        return TripleEqualsSupport.$bang$eq$eq$((TripleEqualsSupport)this, right);
    }

    public TripleEqualsSupport.TripleEqualsInvocation<Null$> $eq$eq$eq(Null$ right) {
        return TripleEqualsSupport.$eq$eq$eq$((TripleEqualsSupport)this, (Null$)right);
    }

    public TripleEqualsSupport.TripleEqualsInvocation<Null$> $bang$eq$eq(Null$ right) {
        return TripleEqualsSupport.$bang$eq$eq$((TripleEqualsSupport)this, (Null$)right);
    }

    public <T> TripleEqualsSupport.TripleEqualsInvocationOnSpread<T> $eq$eq$eq(TripleEqualsSupport.Spread<T> right) {
        return TripleEqualsSupport.$eq$eq$eq$((TripleEqualsSupport)this, right);
    }

    public <T> TripleEqualsSupport.TripleEqualsInvocationOnSpread<T> $bang$eq$eq(TripleEqualsSupport.Spread<T> right) {
        return TripleEqualsSupport.$bang$eq$eq$((TripleEqualsSupport)this, right);
    }

    public final Assertion succeed() {
        return this.succeed;
    }

    public final void org$scalatest$Assertions$_setter_$succeed_$eq(Assertion x$1) {
        this.succeed = x$1;
    }

    public void checkAnswer(Dataset<Row> df, Seq<Row> expectedAnswer, boolean checkToRDD) {
        Option<String> option = this.getErrorMessageInCheckAnswer(df, expectedAnswer, checkToRDD);
        if (option instanceof Some) {
            Some some = (Some)option;
            String errorMessage = (String)some.value();
            throw this.fail(errorMessage, new Position("QueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 243));
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    public Option<String> getErrorMessageInCheckAnswer(Dataset<Row> df, Seq<Row> expectedAnswer, boolean checkToRDD) {
        Seq seq;
        boolean isSorted = df.logicalPlan().collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof Sort) {
                    Sort sort = (Sort)A1;
                    return (B1)sort;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                return logicalPlan instanceof Sort;
            }
        }).nonEmpty();
        Object object = checkToRDD ? SQLExecution$.MODULE$.withSQLConfPropagated(df.sparkSession(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> df.rdd().count()) : BoxedUnit.UNIT;
        try {
            seq = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.collect())).toSeq();
        }
        catch (Exception e) {
            String errorMessage = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(135).append("\n            |Exception thrown while executing query:\n            |").append(df.queryExecution()).append("\n            |== Exception ==\n            |").append(e).append("\n            |").append(package$.MODULE$.stackTraceToString((Throwable)e)).append("\n          ").toString())).stripMargin();
            return new Some((Object)errorMessage);
        }
        Seq sparkAnswer = seq;
        return this.sameRows(expectedAnswer, (Seq<Row>)sparkAnswer, isSorted).map((Function1 & Serializable & scala.Serializable)results -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(146).append("\n        |Results do not match for query:\n        |Timezone: ").append(TimeZone.getDefault()).append("\n        |Timezone Env: ").append(scala.sys.package$.MODULE$.env().getOrElse((Object)"TZ", (Function0 & Serializable & scala.Serializable)() -> "")).append("\n        |\n        |").append(df.queryExecution()).append("\n        |== Results ==\n        |").append((String)results).append("\n       ").toString())).stripMargin());
    }

    public boolean getErrorMessageInCheckAnswer$default$3() {
        return true;
    }

    public Seq<Row> prepareAnswer(Seq<Row> answer, boolean isSorted) {
        Seq converted = (Seq)answer.map((Function1 & Serializable & scala.Serializable)row -> MODULE$.prepareRow((Row)row), Seq$.MODULE$.canBuildFrom());
        if (!isSorted) {
            return (Seq)converted.sortBy((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toString(), (Ordering)Ordering.String$.MODULE$);
        }
        return converted;
    }

    public Row prepareRow(Row row) {
        return Row$.MODULE$.fromSeq((Seq)row.toSeq().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object = x0$1;
            if (object == null) {
                return null;
            }
            if (object instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)object;
                return scala.package$.MODULE$.BigDecimal().apply(bigDecimal);
            }
            if (object instanceof Seq) {
                Seq seq = (Seq)object;
                return seq.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Object object = x0$2;
                    if (object instanceof Byte) {
                        Byte by = (Byte)object;
                        return BoxesRunTime.boxToByte((byte)by);
                    }
                    if (object instanceof Short) {
                        Short s = (Short)object;
                        return BoxesRunTime.boxToShort((short)s);
                    }
                    if (object instanceof Integer) {
                        Integer n = (Integer)object;
                        return BoxesRunTime.boxToInteger((int)n);
                    }
                    if (object instanceof Long) {
                        Long l = (Long)object;
                        return BoxesRunTime.boxToLong((long)l);
                    }
                    if (object instanceof Float) {
                        Float f = (Float)object;
                        return BoxesRunTime.boxToFloat((float)f.floatValue());
                    }
                    if (object instanceof Double) {
                        Double d = (Double)object;
                        return BoxesRunTime.boxToDouble((double)d);
                    }
                    return object;
                }, Seq$.MODULE$.canBuildFrom());
            }
            if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
                Object object2 = object;
                return Predef$.MODULE$.genericArrayOps(object2).toSeq();
            }
            if (object instanceof Row) {
                Row row = (Row)object;
                return MODULE$.prepareRow(row);
            }
            return object;
        }, Seq$.MODULE$.canBuildFrom()));
    }

    private String genError(Seq<Row> expectedAnswer, Seq<Row> sparkAnswer, boolean isSorted) {
        Function1 & Serializable & scala.Serializable getRowType = (Function1 & Serializable & scala.Serializable)row2 -> (String)row2.map((Function1 & Serializable & scala.Serializable)row -> {
            if (row.schema() == null) {
                return "struct<>";
            }
            return String.valueOf(row.schema().catalogString());
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> "struct<>");
        String string = new StringBuilder(23).append("== Correct Answer - ").append(expectedAnswer.size()).append(" ==").toString();
        String string2 = (String)getRowType.apply((Object)expectedAnswer.headOption());
        String string3 = new StringBuilder(21).append("== Spark Answer - ").append(sparkAnswer.size()).append(" ==").toString();
        String string4 = (String)getRowType.apply((Object)sparkAnswer.headOption());
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(36).append("\n       |== Results ==\n       |").append(package$.MODULE$.sideBySide((Seq)((SeqLike)((SeqLike)this.prepareAnswer(expectedAnswer, isSorted).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.toString(), Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)string2, Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom()), (Seq)((SeqLike)((SeqLike)this.prepareAnswer(sparkAnswer, isSorted).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.toString(), Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)string4, Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)string3, Seq$.MODULE$.canBuildFrom())).mkString("\n")).append("\n    ").toString())).stripMargin();
    }

    private boolean genError$default$3() {
        return false;
    }

    public Option<String> includesRows(Seq<Row> expectedRows, Seq<Row> sparkAnswer) {
        if (!this.prepareAnswer(expectedRows, true).toSet().subsetOf((GenSet)this.prepareAnswer(sparkAnswer, true).toSet())) {
            return new Some((Object)this.genError(expectedRows, sparkAnswer, true));
        }
        return None$.MODULE$;
    }

    public boolean compare(Object obj1, Object obj2) {
        Tuple2 tuple2;
        while (true) {
            Object object;
            Object object2;
            if ((tuple2 = new Tuple2(obj1, obj2)) != null) {
                Object object3 = tuple2._1();
                Object object4 = tuple2._2();
                if (object3 == null && object4 == null) {
                    return true;
                }
            }
            if (tuple2 != null && (object2 = tuple2._1()) == null) {
                return false;
            }
            if (tuple2 != null && (object = tuple2._2()) == null) {
                return false;
            }
            if (tuple2 != null) {
                Object a = tuple2._1();
                Object b = tuple2._2();
                if (ScalaRunTime$.MODULE$.isArray(a, 1)) {
                    Object object5 = a;
                    if (ScalaRunTime$.MODULE$.isArray(b, 1)) {
                        Object object6 = b;
                        return ScalaRunTime$.MODULE$.array_length(object5) == ScalaRunTime$.MODULE$.array_length(object6) && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps(object5).zip((GenIterable)Predef$.MODULE$.genericWrapArray(object6), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)QueryTest$.$anonfun$compare$1(x0$1)));
                    }
                }
            }
            if (tuple2 != null) {
                Object a = tuple2._1();
                Object b = tuple2._2();
                if (a instanceof Map) {
                    Map map = (Map)a;
                    if (b instanceof Map) {
                        Map map2 = (Map)b;
                        return map.size() == map2.size() && map.keys().forall((Function1 & Serializable & scala.Serializable)aKey -> BoxesRunTime.boxToBoolean((boolean)QueryTest$.$anonfun$compare$2(map2, map, aKey)));
                    }
                }
            }
            if (tuple2 != null) {
                Object a = tuple2._1();
                Object b = tuple2._2();
                if (a instanceof Iterable) {
                    Iterable iterable = (Iterable)a;
                    if (b instanceof Iterable) {
                        Iterable iterable2 = (Iterable)b;
                        return iterable.size() == iterable2.size() && ((IterableLike)iterable.zip((GenIterable)iterable2, Iterable$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)QueryTest$.$anonfun$compare$5(x0$2)));
                    }
                }
            }
            if (tuple2 != null) {
                Object a = tuple2._1();
                Object b = tuple2._2();
                if (a instanceof Product) {
                    Product product = (Product)a;
                    if (b instanceof Product) {
                        Product product2 = (Product)b;
                        obj2 = product2.productIterator().toSeq();
                        obj1 = product.productIterator().toSeq();
                        continue;
                    }
                }
            }
            if (tuple2 == null) break;
            Object a = tuple2._1();
            Object b = tuple2._2();
            if (!(a instanceof Row)) break;
            Row row = (Row)a;
            if (!(b instanceof Row)) break;
            Row row2 = (Row)b;
            obj2 = row2.toSeq();
            obj1 = row.toSeq();
        }
        if (tuple2 != null) {
            Object a = tuple2._1();
            Object b = tuple2._2();
            if (a instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)a);
                if (b instanceof Double) {
                    double d2 = BoxesRunTime.unboxToDouble((Object)b);
                    return Double.doubleToRawLongBits(d) == Double.doubleToRawLongBits(d2);
                }
            }
        }
        if (tuple2 != null) {
            Object a = tuple2._1();
            Object b = tuple2._2();
            if (a instanceof Float) {
                float f = BoxesRunTime.unboxToFloat((Object)a);
                if (b instanceof Float) {
                    float f2 = BoxesRunTime.unboxToFloat((Object)b);
                    return Float.floatToRawIntBits(f) == Float.floatToRawIntBits(f2);
                }
            }
        }
        if (tuple2 != null) {
            Object b;
            Object a = tuple2._1();
            return BoxesRunTime.equals((Object)a, (Object)(b = tuple2._2()));
        }
        throw new MatchError((Object)tuple2);
    }

    public Option<String> sameRows(Seq<Row> expectedAnswer, Seq<Row> sparkAnswer, boolean isSorted) {
        if (!this.compare(this.prepareAnswer(expectedAnswer, isSorted), this.prepareAnswer(sparkAnswer, isSorted))) {
            return new Some((Object)this.genError(expectedAnswer, sparkAnswer, isSorted));
        }
        return None$.MODULE$;
    }

    public boolean sameRows$default$3() {
        return false;
    }

    public void checkAggregatesWithTol(Row actualAnswer, Row expectedAnswer, double absTol) {
        Predef$.MODULE$.require(actualAnswer.length() == expectedAnswer.length(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("actual answer length ").append(actualAnswer.length()).append(" != ").append("expected answer length ").append(expectedAnswer.length()).toString());
        ((IterableLike)actualAnswer.toSeq().zip((GenIterable)expectedAnswer.toSeq(), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Object actual = tuple2._1();
                Object expected = tuple2._2();
                if (actual instanceof Double) {
                    double d = BoxesRunTime.unboxToDouble((Object)actual);
                    if (expected instanceof Double) {
                        double d2 = BoxesRunTime.unboxToDouble((Object)expected);
                        double $org_scalatest_assert_macro_left = scala.math.package$.MODULE$.abs(d - d2);
                        double $org_scalatest_assert_macro_right = absTol;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(45).append("actual answer ").append(d).append(" not within ").append(absTol).append(" of correct answer ").append(d2).toString(), Prettifier$.MODULE$.default(), new Position("QueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 413));
                    }
                }
            }
            if (tuple2 != null) {
                Object expected;
                Object $org_scalatest_assert_macro_right;
                Object $org_scalatest_assert_macro_left;
                Object actual = tuple2._1();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", $org_scalatest_assert_macro_right, BoxesRunTime.equals((Object)($org_scalatest_assert_macro_left = actual), (Object)($org_scalatest_assert_macro_right = (expected = tuple2._2()))), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(15).append(actual).append(" did not equal ").append(expected).toString(), Prettifier$.MODULE$.default(), new Position("QueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 416));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public void checkAnswer(Dataset<Row> df, List<Row> expectedAnswer) {
        Option<String> option = this.getErrorMessageInCheckAnswer(df, (Seq<Row>)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(expectedAnswer).asScala()).toSeq(), this.getErrorMessageInCheckAnswer$default$3());
        if (option instanceof Some) {
            Some some = (Some)option;
            String errorMessage = (String)some.value();
            throw this.fail(errorMessage, new Position("QueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 422));
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    public boolean checkAnswer$default$3() {
        return true;
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$compare$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Object l = tuple2._1();
            Object r = tuple2._2();
            return MODULE$.compare(l, r);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$compare$2(Map x15$1, Map x14$1, Object aKey) {
        return x15$1.keys().find((Function1 & Serializable & scala.Serializable)bKey -> BoxesRunTime.boxToBoolean((boolean)QueryTest$.MODULE$.compare(aKey, bKey))).exists((Function1 & Serializable & scala.Serializable)bKey -> BoxesRunTime.boxToBoolean((boolean)QueryTest$.MODULE$.compare(x14$1.apply(aKey), x15$1.apply(bKey))));
    }

    public static final /* synthetic */ boolean $anonfun$compare$5(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            Object l = tuple2._1();
            Object r = tuple2._2();
            return MODULE$.compare(l, r);
        }
        throw new MatchError((Object)tuple2);
    }

    private QueryTest$() {
        MODULE$ = this;
        TripleEqualsSupport.$init$((TripleEqualsSupport)this);
        TripleEquals.$init$((TripleEquals)this);
        Assertions.$init$((Assertions)this);
    }
}

