/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector;

import java.io.Serializable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.connector.MergeIntoTableSuiteBase;
import org.apache.spark.sql.internal.SQLConf$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001}1Aa\u0001\u0003\u0001\u001f!)A\u0003\u0001C\u0001+!)q\u0003\u0001C\u00051\tirI]8va\n\u000b7/\u001a3NKJ<W-\u00138u_R\u000b'\r\\3Tk&$XM\u0003\u0002\u0006\r\u0005I1m\u001c8oK\u000e$xN\u001d\u0006\u0003\u000f!\t1a]9m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0003\u0001A\u0001\"!\u0005\n\u000e\u0003\u0011I!a\u0005\u0003\u0003/5+'oZ3J]R|G+\u00192mKN+\u0018\u000e^3CCN,\u0017A\u0002\u001fj]&$h\bF\u0001\u0017!\t\t\u0002!A\u0010dQ\u0016\u001c7.T3sO\u0016\u0014VO\u001c;j[\u0016<%o\\;q\r&dG/\u001a:j]\u001e$\u0012!\u0007\t\u00035ui\u0011a\u0007\u0006\u00029\u0005)1oY1mC&\u0011ad\u0007\u0002\u0005+:LG\u000f")
public class GroupBasedMergeIntoTableSuite
extends MergeIntoTableSuiteBase {
    private void checkMergeRuntimeGroupFiltering() {
        this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"source"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, salary INT, dep STRING", new StringOps(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"salary\": 100, \"dep\": \"hr\" }\n          |{ \"pk\": 2, \"salary\": 200, \"dep\": \"hr\" }\n          |{ \"pk\": 3, \"salary\": 300, \"dep\": \"hr\" }\n          |{ \"pk\": 4, \"salary\": 400, \"dep\": \"software\" }\n          |{ \"pk\": 5, \"salary\": 500, \"dep\": \"software\" }\n          |")).stripMargin());
            Dataset sourceDF = this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 6})), this.testImplicits().newIntEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"pk"}));
            sourceDF.createOrReplaceTempView("source");
            this.executeAndCheckScans(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(253).append("MERGE INTO ").append(this.tableNameAsString()).append(" t\n           |USING source s\n           |ON t.pk = s.pk\n           |WHEN MATCHED THEN\n           | UPDATE SET t.salary = t.salary + 1\n           |WHEN NOT MATCHED THEN\n           | INSERT (pk, salary, dep) VALUES (s.pk, 0, 'hr')\n           |").toString())).stripMargin(), "pk INT, salary INT, dep STRING, _partition STRING", (Option<String>)new Some((Object)"pk INT, dep STRING"));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)101), "hr"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)201), "hr"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)301), "hr"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)400), "software"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)500), "software"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)0), "hr"})), (List)Nil$.MODULE$))))))));
            this.checkReplacedPartitions((Seq<Object>)((Seq)new .colon.colon((Object)"hr", (List)Nil$.MODULE$)));
        });
    }

    public GroupBasedMergeIntoTableSuite() {
        this.test("merge runtime filtering is disabled with NOT MATCHED BY SOURCE clauses", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"source"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, salary INT, dep STRING", new StringOps(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"salary\": 100, \"dep\": \"hr\" }\n          |{ \"pk\": 2, \"salary\": 200, \"dep\": \"hr\" }\n          |{ \"pk\": 3, \"salary\": 300, \"dep\": \"hr\" }\n          |{ \"pk\": 4, \"salary\": 400, \"dep\": \"software\" }\n          |{ \"pk\": 5, \"salary\": 500, \"dep\": \"software\" }\n          |")).stripMargin());
            Dataset sourceDF = this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 6})), this.testImplicits().newIntEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"pk"}));
            sourceDF.createOrReplaceTempView("source");
            this.executeAndCheckScans(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(317).append("MERGE INTO ").append(this.tableNameAsString()).append(" t\n           |USING source s\n           |ON t.pk = s.pk\n           |WHEN MATCHED THEN\n           | UPDATE SET t.salary = t.salary + 1\n           |WHEN NOT MATCHED THEN\n           | INSERT (pk, salary, dep) VALUES (s.pk, 0, 'hr')\n           |WHEN NOT MATCHED BY SOURCE THEN\n           | DELETE\n           |").toString())).stripMargin(), "pk INT, salary INT, dep STRING, _partition STRING", (Option<String>)None$.MODULE$);
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)101), "hr"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)201), "hr"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)301), "hr"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)0), "hr"})), (List)Nil$.MODULE$))))));
            this.checkReplacedPartitions((Seq<Object>)((Seq)new .colon.colon((Object)"hr", (List)new .colon.colon((Object)"software", (List)Nil$.MODULE$))));
        }), new Position("GroupBasedMergeIntoTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 27));
        this.test("merge runtime group filtering (DPP enabled)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.DYNAMIC_PARTITION_PRUNING_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkMergeRuntimeGroupFiltering()), new Position("GroupBasedMergeIntoTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
        this.test("merge runtime group filtering (DPP disabled)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.DYNAMIC_PARTITION_PRUNING_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkMergeRuntimeGroupFiltering()), new Position("GroupBasedMergeIntoTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
        this.test("merge runtime group filtering (AQE enabled)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ADAPTIVE_EXECUTION_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkMergeRuntimeGroupFiltering()), new Position("GroupBasedMergeIntoTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
        this.test("merge runtime group filtering (AQE disabled)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ADAPTIVE_EXECUTION_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkMergeRuntimeGroupFiltering()), new Position("GroupBasedMergeIntoTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
    }
}

