/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.QueryTest$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.execution.CachedData;
import org.apache.spark.sql.execution.command.DDLCommandTestUtils;
import org.apache.spark.storage.StorageLevel;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEquals;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u000154qAB\u0004\u0011\u0002\u0007\u0005A\u0003C\u0003\u001e\u0001\u0011\u0005a\u0004C\u0004\t\u0001\t\u0007I\u0011I\u0013\t\u00179\u0002\u0001\u0013aA\u0001\u0002\u0013%qF\u0013\u0005\f\u0019\u0002\u0001\n1!A\u0001\n\u0013iu\rC\u0006M\u0001A\u0005\u0019\u0011!A\u0005\n%d'!G!mi\u0016\u0014H+\u00192mKJ+g.Y7f'VLG/\u001a\"bg\u0016T!\u0001C\u0005\u0002\u000f\r|W.\\1oI*\u0011!bC\u0001\nKb,7-\u001e;j_:T!\u0001D\u0007\u0002\u0007M\fHN\u0003\u0002\u000f\u001f\u0005)1\u000f]1sW*\u0011\u0001#E\u0001\u0007CB\f7\r[3\u000b\u0003I\t1a\u001c:h\u0007\u0001\u00192\u0001A\u000b\u001a!\t1r#D\u0001\f\u0013\tA2BA\u0005Rk\u0016\u0014\u0018\u0010V3tiB\u0011!dG\u0007\u0002\u000f%\u0011Ad\u0002\u0002\u0014\t\u0012c5i\\7nC:$G+Z:u+RLGn]\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0015\u0003}\u0001\"\u0001I\u0012\u000e\u0003\u0005R\u0011AI\u0001\u0006g\u000e\fG.Y\u0005\u0003I\u0005\u0012A!\u00168jiV\ta\u0005\u0005\u0002(Y5\t\u0001F\u0003\u0002*U\u0005!A.\u00198h\u0015\u0005Y\u0013\u0001\u00026bm\u0006L!!\f\u0015\u0003\rM#(/\u001b8h\u0003u\u0019X\u000f]3sI\rDWmY6FeJ|'\u000fV1cY\u0016tu\u000e\u001e$pk:$G\u0003B\u00101m\tCQ!M\u0002A\u0002I\n\u0011\"\u001a=dKB$\u0018n\u001c8\u0011\u0005M\"T\"A\u0007\n\u0005Uj!AD*qCJ\\G\u000b\u001b:po\u0006\u0014G.\u001a\u0005\u0006o\r\u0001\r\u0001O\u0001\ni\u0006\u0014G.\u001a(b[\u0016\u0004\"!\u000f!\u000f\u0005ir\u0004CA\u001e\"\u001b\u0005a$BA\u001f\u0014\u0003\u0019a$o\\8u}%\u0011q(I\u0001\u0007!J,G-\u001a4\n\u00055\n%BA \"\u0011\u0015\u00195\u00011\u0001E\u00031\tX/\u001a:z\u0007>tG/\u001a=u!\t)e)D\u0001\u0001\u0013\t9\u0005JA\bFqB,7\r^3e\u0007>tG/\u001a=u\u0013\tIUBA\u0007Ta\u0006\u00148NR;o'VLG/Z\u0005\u0003\u0017\"\u000bqc\u00195fG.,%O]8s)\u0006\u0014G.\u001a(pi\u001a{WO\u001c3\u0002#M,\b/\u001a:%G\",7m[!og^,'\u000fF\u0002 \u001djCaa\u0014\u0003\u0005\u0002\u0004\u0001\u0016A\u00013g!\r\u0001\u0013kU\u0005\u0003%\u0006\u0012\u0001\u0002\u00102z]\u0006lWM\u0010\t\u0003)^s!AF+\n\u0005Y[\u0011a\u00029bG.\fw-Z\u0005\u00031f\u0013\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0005Y[\u0001\"B.\u0005\u0001\u0004a\u0016AD3ya\u0016\u001cG/\u001a3B]N<XM\u001d\t\u0004;\u0006$gB\u00010a\u001d\tYt,C\u0001#\u0013\t1\u0016%\u0003\u0002cG\n\u00191+Z9\u000b\u0005Y\u000b\u0003C\u0001\ff\u0013\t17BA\u0002S_^L!\u0001[\f\u0002\u0017\rDWmY6B]N<XM\u001d\u000b\u0004?)\\\u0007BB(\u0006\t\u0003\u0007\u0001\u000bC\u0003\\\u000b\u0001\u0007A-\u0003\u0002i/\u0001")
public interface AlterTableRenameSuiteBase
extends DDLCommandTestUtils {
    public void org$apache$spark$sql$execution$command$AlterTableRenameSuiteBase$_setter_$command_$eq(String var1);

    public /* synthetic */ void org$apache$spark$sql$execution$command$AlterTableRenameSuiteBase$$super$checkErrorTableNotFound(SparkThrowable var1, String var2, SparkFunSuite.ExpectedContext var3);

    public /* synthetic */ void org$apache$spark$sql$execution$command$AlterTableRenameSuiteBase$$super$checkAnswer(Function0 var1, Seq var2);

    public /* synthetic */ void org$apache$spark$sql$execution$command$AlterTableRenameSuiteBase$$super$checkAnswer(Function0 var1, Row var2);

    @Override
    public String command();

    public static /* synthetic */ void $anonfun$$init$$2(AlterTableRenameSuiteBase $this, String dst) {
        String src = dst.replace("dst", "src");
        $this.sql().apply((Object)new StringBuilder(23).append("CREATE TABLE ").append(src).append(" (c0 INT) ").append($this.defaultUsing()).toString());
        $this.sql().apply((Object)new StringBuilder(21).append("INSERT INTO ").append(src).append(" SELECT 0").toString());
        $this.sql().apply((Object)new StringBuilder(33).append("ALTER TABLE ").append(src).append(" RENAME TO ns.dst_tbl").toString());
        $this.checkTables("ns", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dst_tbl"}));
        QueryTest$.MODULE$.checkAnswer((Dataset<Row>)((Dataset)$this.sql().apply((Object)new StringBuilder(15).append("SELECT c0 FROM ").append(dst).toString())), (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)})), (List)Nil$.MODULE$)), QueryTest$.MODULE$.checkAnswer$default$3());
    }

    public static /* synthetic */ void $anonfun$$init$$6(AlterTableRenameSuiteBase $this, String dst) {
        String src = dst.replace("dst", "src");
        $this.sql().apply((Object)new StringBuilder(23).append("CREATE TABLE ").append(src).append(" (c0 INT) ").append($this.defaultUsing()).toString());
        $this.sql().apply((Object)new StringBuilder(21).append("INSERT INTO ").append(src).append(" SELECT 0").toString());
        $this.sql().apply((Object)new StringBuilder(30).append("ALTER TABLE ").append(src).append(" RENAME TO dst_tbl").toString());
        $this.checkTables("ns", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dst_tbl"}));
        QueryTest$.MODULE$.checkAnswer((Dataset<Row>)((Dataset)$this.sql().apply((Object)new StringBuilder(15).append("SELECT c0 FROM ").append(dst).toString())), (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)})), (List)Nil$.MODULE$)), QueryTest$.MODULE$.checkAnswer$default$3());
    }

    private StorageLevel getStorageLevel$1(String tableName) {
        Dataset table = this.spark().table(tableName);
        CachedData cachedData = (CachedData)this.spark().sharedState().cacheManager().lookupCachedData(table).get();
        return cachedData.cachedRepresentation().cacheBuilder().storageLevel();
    }

    public static /* synthetic */ void $anonfun$$init$$8(AlterTableRenameSuiteBase $this, String dst) {
        String src = dst.replace("dst", "src");
        $this.sql().apply((Object)new StringBuilder(23).append("CREATE TABLE ").append(src).append(" (c0 INT) ").append($this.defaultUsing()).toString());
        $this.sql().apply((Object)new StringBuilder(21).append("INSERT INTO ").append(src).append(" SELECT 0").toString());
        $this.sql().apply((Object)new StringBuilder(50).append("CACHE TABLE ").append(src).append(" OPTIONS('storageLevel' 'MEMORY_ONLY')").toString());
        StorageLevel oldStorageLevel = $this.getStorageLevel$1(src);
        $this.sql().apply((Object)new StringBuilder(33).append("ALTER TABLE ").append(src).append(" RENAME TO ns.dst_tbl").toString());
        QueryTest$.MODULE$.checkAnswer((Dataset<Row>)((Dataset)$this.sql().apply((Object)new StringBuilder(15).append("SELECT c0 FROM ").append(dst).toString())), (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)})), (List)Nil$.MODULE$)), QueryTest$.MODULE$.checkAnswer$default$3());
        StorageLevel newStorageLevel = $this.getStorageLevel$1(dst);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)oldStorageLevel);
        StorageLevel $org_scalatest_assert_macro_right = newStorageLevel;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableRenameSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
    }

    public static /* synthetic */ void $anonfun$$init$$10(AlterTableRenameSuiteBase $this, String students) {
        $this.sql().apply((Object)new StringBuilder(37).append("CREATE TABLE ").append(students).append(" (age INT, name STRING) ").append($this.defaultUsing()).toString());
        $this.sql().apply((Object)new StringBuilder(29).append("INSERT INTO ").append(students).append(" SELECT 19, 'Ana'").toString());
        $this.spark().catalog().cacheTable(students);
        Seq expected = (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)19), "Ana"})), (List)Nil$.MODULE$);
        QueryTest$.MODULE$.checkAnswer((Dataset<Row>)$this.spark().table(students), (Seq<Row>)expected, QueryTest$.MODULE$.checkAnswer$default$3());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool($this.spark().catalog().isCached(students), "AlterTableRenameSuiteBase.this.spark.catalog.isCached(students)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"bad test: table was not cached in the first place", Prettifier$.MODULE$.default(), new Position("AlterTableRenameSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
        String teachers = new StringBuilder(12).append($this.catalog()).append(".ns.teachers").toString();
        $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{teachers}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(34).append("ALTER TABLE ").append(students).append(" RENAME TO ns.teachers").toString());
            $this.sql().apply((Object)new StringBuilder(37).append("CREATE TABLE ").append(students).append(" (age INT, name STRING) ").append($this.defaultUsing()).toString());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.spark().catalog().isCached(students), "AlterTableRenameSuiteBase.this.spark.catalog.isCached(students)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableRenameSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool($this.spark().catalog().isCached(teachers), "AlterTableRenameSuiteBase.this.spark.catalog.isCached(teachers)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableRenameSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
            Object[] $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])$this.spark().table(students).collect());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left), "isEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left).isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableRenameSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
            QueryTest$.MODULE$.checkAnswer((Dataset<Row>)$this.spark().table(teachers), (Seq<Row>)expected, QueryTest$.MODULE$.checkAnswer$default$3());
        });
    }

    public static /* synthetic */ void $anonfun$$init$$13(AlterTableRenameSuiteBase $this, String dst) {
        String src = dst.replace("dst", "src");
        $this.sql().apply((Object)new StringBuilder(23).append("CREATE TABLE ").append(src).append(" (c0 INT) ").append($this.defaultUsing()).toString());
        $this.sql().apply((Object)new StringBuilder(21).append("INSERT INTO ").append(src).append(" SELECT 0").toString());
        $this.sql().apply((Object)new StringBuilder(7).append("USE ").append($this.catalog()).append(".ns").toString());
        $this.sql().apply((Object)"ALTER TABLE src_tbl RENAME TO dst_tbl");
        $this.checkTables("ns", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dst_tbl"}));
        $this.org$apache$spark$sql$execution$command$AlterTableRenameSuiteBase$$super$checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(15).append("SELECT c0 FROM ").append(dst).toString()), (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)})), (List)Nil$.MODULE$));
    }

    public static /* synthetic */ void $anonfun$$init$$16(AlterTableRenameSuiteBase $this, String dst) {
        String src = dst.replace("dst", "src");
        $this.sql().apply((Object)new StringBuilder(48).append("CREATE TABLE ").append(src).append(" (i int, j int) ").append($this.defaultUsing()).append(" partitioned by (j)").toString());
        $this.sql().apply((Object)new StringBuilder(44).append("insert into table ").append(src).append(" partition(j=2) values (1)").toString());
        $this.sql().apply((Object)new StringBuilder(33).append("ALTER TABLE ").append(src).append(" RENAME TO ns.dst_tbl").toString());
        $this.org$apache$spark$sql$execution$command$AlterTableRenameSuiteBase$$super$checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().table(dst), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})));
    }

    public static /* synthetic */ void $anonfun$$init$$19(AlterTableRenameSuiteBase $this, String t) {
        $this.sql().apply((Object)new StringBuilder(26).append("CREATE TABLE ").append(t).append("_Old (i int) ").append($this.defaultUsing()).toString());
        $this.sql().apply((Object)new StringBuilder(64).append("ALTER TABLE ").append(t).append("_Old RENAME TO CaseUpperCaseLower.CaseUpperCaseLower").toString());
        Dataset $org_scalatest_assert_macro_left = $this.spark().table(t);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableRenameSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
    }

    public static void $init$(AlterTableRenameSuiteBase $this) {
        $this.org$apache$spark$sql$execution$command$AlterTableRenameSuiteBase$_setter_$command_$eq("ALTER TABLE .. RENAME");
        $this.test("rename a table in a database/namespace", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withNamespaceAndTable("ns", "dst_tbl", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dst -> {
            AlterTableRenameSuiteBase.$anonfun$$init$$2($this, dst);
            return BoxedUnit.UNIT;
        }), new Position("AlterTableRenameSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
        $this.test("table to rename does not exist", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            AnalysisException e = (AnalysisException)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(50).append("ALTER TABLE ").append($this.catalog()).append(".dbx.does_not_exist RENAME TO dbx.tab2").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableRenameSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
            $this.org$apache$spark$sql$execution$command$AlterTableRenameSuiteBase$$super$checkErrorTableNotFound((SparkThrowable)e, new StringBuilder(25).append("`").append($this.catalog()).append("`.`dbx`.`does_not_exist`").toString(), ((SparkFunSuite)$this).ExpectedContext().apply(new StringBuilder(19).append($this.catalog()).append(".dbx.does_not_exist").toString(), 12, 11 + new StringBuilder(19).append($this.catalog()).append(".dbx.does_not_exist").toString().length()));
        }, new Position("AlterTableRenameSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
        $this.test("omit namespace in the destination table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withNamespaceAndTable("ns", "dst_tbl", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dst -> {
            AlterTableRenameSuiteBase.$anonfun$$init$$6($this, dst);
            return BoxedUnit.UNIT;
        }), new Position("AlterTableRenameSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
        $this.test("SPARK-33786: Cache's storage level should be respected when a table name is altered", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withNamespaceAndTable("ns", "dst_tbl", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dst -> {
            AlterTableRenameSuiteBase.$anonfun$$init$$8($this, dst);
            return BoxedUnit.UNIT;
        }), new Position("AlterTableRenameSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        $this.test("rename cached table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withNamespaceAndTable("ns", "students", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)students -> {
            AlterTableRenameSuiteBase.$anonfun$$init$$10($this, students);
            return BoxedUnit.UNIT;
        }), new Position("AlterTableRenameSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        $this.test("rename without explicitly specifying database", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            try {
                $this.withNamespaceAndTable("ns", "dst_tbl", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dst -> {
                    AlterTableRenameSuiteBase.$anonfun$$init$$13($this, dst);
                    return BoxedUnit.UNIT;
                });
                boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                $this.spark().sessionState().catalogManager().reset();
            }
            return boxedUnit;
        }, new Position("AlterTableRenameSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
        $this.test("SPARK-37963: preserve partition info", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withNamespaceAndTable("ns", "dst_tbl", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dst -> {
            AlterTableRenameSuiteBase.$anonfun$$init$$16($this, dst);
            return BoxedUnit.UNIT;
        }), new Position("AlterTableRenameSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
        $this.test("SPARK-38587: use formatted names", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withNamespaceAndTable("CaseUpperCaseLower", "CaseUpperCaseLower", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)t -> {
            AlterTableRenameSuiteBase.$anonfun$$init$$19($this, t);
            return BoxedUnit.UNIT;
        }), new Position("AlterTableRenameSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
    }
}

