/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.serializer.JavaSerializer;
import org.apache.spark.serializer.KryoSerializer;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.trees.SQLQueryContext;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypeTestUtils$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.memory.MemoryAllocator;
import org.apache.spark.unsafe.memory.MemoryBlock;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001U1AAA\u0002\u0001\u0019!)\u0011\u0003\u0001C\u0001%\tqQK\\:bM\u0016\u0014vn^*vSR,'B\u0001\u0003\u0006\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\r\u001d\tQa\u001d9be.T!\u0001C\u0005\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0011aA8sO\u000e\u00011C\u0001\u0001\u000e!\tqq\"D\u0001\u0006\u0013\t\u0001RAA\u0007Ta\u0006\u00148NR;o'VLG/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003M\u0001\"\u0001\u0006\u0001\u000e\u0003\r\u0001")
public class UnsafeRowSuite
extends SparkFunSuite {
    public static final /* synthetic */ String $anonfun$new$9(int x$4) {
        return "abc";
    }

    public UnsafeRowSuite() {
        this.test("UnsafeRow Java serialization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            byte[] data = new byte[1024];
            UnsafeRow row = new UnsafeRow(1);
            row.pointTo(data, 16);
            row.setLong(0, 19285L);
            SerializerInstance ser = new JavaSerializer(new SparkConf()).newInstance();
            UnsafeRow row1 = (UnsafeRow)ser.deserialize(ser.serialize((Object)row, ClassTag$.MODULE$.apply(UnsafeRow.class)), ClassTag$.MODULE$.apply(UnsafeRow.class));
            long $org_scalatest_assert_macro_left = row1.getLong(0);
            int $org_scalatest_assert_macro_right = 19285;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
            byte[] $org_scalatest_assert_macro_left2 = (byte[])row1.getBaseObject();
            int $org_scalatest_assert_macro_right2 = 16;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
        }, new Position("UnsafeRowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 34));
        this.test("UnsafeRow Kryo serialization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            byte[] data = new byte[1024];
            UnsafeRow row = new UnsafeRow(1);
            row.pointTo(data, 16);
            row.setLong(0, 19285L);
            SerializerInstance ser = new KryoSerializer(new SparkConf()).newInstance();
            UnsafeRow row1 = (UnsafeRow)ser.deserialize(ser.serialize((Object)row, ClassTag$.MODULE$.apply(UnsafeRow.class)), ClassTag$.MODULE$.apply(UnsafeRow.class));
            long $org_scalatest_assert_macro_left = row1.getLong(0);
            int $org_scalatest_assert_macro_right = 19285;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
            byte[] $org_scalatest_assert_macro_left2 = (byte[])row1.getBaseObject();
            int $org_scalatest_assert_macro_right2 = 16;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
        }, new Position("UnsafeRowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
        this.test("bitset width calculation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)UnsafeRow.calculateBitSetWidthInBytes((int)0)));
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)UnsafeRow.calculateBitSetWidthInBytes((int)1)));
            int $org_scalatest_assert_macro_right2 = 8;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)UnsafeRow.calculateBitSetWidthInBytes((int)32)));
            int $org_scalatest_assert_macro_right3 = 8;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)UnsafeRow.calculateBitSetWidthInBytes((int)64)));
            int $org_scalatest_assert_macro_right4 = 8;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)UnsafeRow.calculateBitSetWidthInBytes((int)65)));
            int $org_scalatest_assert_macro_right5 = 16;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)UnsafeRow.calculateBitSetWidthInBytes((int)128)));
            int $org_scalatest_assert_macro_right6 = 16;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
        }, new Position("UnsafeRowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
        this.test("writeToStream", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Tuple2 tuple2;
            InternalRow row = InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UTF8String.fromString((String)"hello"), UTF8String.fromString((String)"world"), BoxesRunTime.boxToInteger((int)123)}));
            UnsafeRow arrayBackedUnsafeRow = UnsafeProjection$.MODULE$.create((DataType[])((Object[])new DataType[]{StringType$.MODULE$, StringType$.MODULE$, IntegerType$.MODULE$})).apply(row);
            Object $org_scalatest_assert_macro_left = arrayBackedUnsafeRow.getBaseObject();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool($org_scalatest_assert_macro_left, "isInstanceOf", "scala.Array", $org_scalatest_assert_macro_left instanceof byte[], Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            arrayBackedUnsafeRow.writeToStream((OutputStream)baos, null);
            Tuple2 tuple22 = new Tuple2((Object)baos.toByteArray(), (Object)arrayBackedUnsafeRow.getString(0));
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            byte[] bytesFromArrayBackedRow = (byte[])tuple22._1();
            String field0StringFromArrayBackedRow = (String)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)bytesFromArrayBackedRow, (Object)field0StringFromArrayBackedRow);
            byte[] bytesFromArrayBackedRow2 = (byte[])tuple23._1();
            String field0StringFromArrayBackedRow2 = (String)tuple23._2();
            MemoryBlock offheapRowPage = MemoryAllocator.UNSAFE.allocate((long)arrayBackedUnsafeRow.getSizeInBytes());
            try {
                Platform.copyMemory((Object)arrayBackedUnsafeRow.getBaseObject(), (long)arrayBackedUnsafeRow.getBaseOffset(), (Object)offheapRowPage.getBaseObject(), (long)offheapRowPage.getBaseOffset(), (long)arrayBackedUnsafeRow.getSizeInBytes());
                UnsafeRow offheapUnsafeRow = new UnsafeRow(3);
                offheapUnsafeRow.pointTo(offheapRowPage.getBaseObject(), offheapRowPage.getBaseOffset(), arrayBackedUnsafeRow.getSizeInBytes());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(offheapUnsafeRow.getBaseObject());
                Null$ $org_scalatest_assert_macro_right = null;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", null, $org_scalatest_assert_macro_left2.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
                ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
                byte[] writeBuffer = new byte[1024];
                offheapUnsafeRow.writeToStream((OutputStream)baos2, writeBuffer);
                tuple2 = new Tuple2((Object)baos2.toByteArray(), (Object)offheapUnsafeRow.getString(0));
            }
            finally {
                MemoryAllocator.UNSAFE.free(offheapRowPage);
            }
            Tuple2 tuple24 = tuple2;
            if (tuple24 == null) {
                throw new MatchError((Object)tuple24);
            }
            byte[] bytesFromOffheapRow = (byte[])tuple24._1();
            String field0StringFromOffheapRow = (String)tuple24._2();
            Tuple2 tuple25 = new Tuple2((Object)bytesFromOffheapRow, (Object)field0StringFromOffheapRow);
            byte[] bytesFromOffheapRow2 = (byte[])tuple25._1();
            String field0StringFromOffheapRow2 = (String)tuple25._2();
            ByteArrayOutputStream baos3 = new ByteArrayOutputStream();
            int numBytes = arrayBackedUnsafeRow.getSizeInBytes();
            byte[] bytesWithOffset = new byte[numBytes + 100];
            System.arraycopy((byte[])arrayBackedUnsafeRow.getBaseObject(), 0, bytesWithOffset, 100, numBytes);
            UnsafeRow arrayBackedRow = new UnsafeRow(arrayBackedUnsafeRow.numFields());
            arrayBackedRow.pointTo((Object)bytesWithOffset, (long)(Platform.BYTE_ARRAY_OFFSET + 100), numBytes);
            arrayBackedRow.writeToStream((OutputStream)baos3, null);
            Tuple2 tuple26 = new Tuple2((Object)baos3.toByteArray(), (Object)arrayBackedRow.getString(0));
            if (tuple26 == null) {
                throw new MatchError((Object)tuple26);
            }
            byte[] bytesFromArrayBackedRowWithOffset = (byte[])tuple26._1();
            String field0StringFromArrayBackedRowWithOffset = (String)tuple26._2();
            Tuple2 tuple27 = new Tuple2((Object)bytesFromArrayBackedRowWithOffset, (Object)field0StringFromArrayBackedRowWithOffset);
            byte[] bytesFromArrayBackedRowWithOffset2 = (byte[])tuple27._1();
            String field0StringFromArrayBackedRowWithOffset2 = (String)tuple27._2();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(bytesFromArrayBackedRow2);
            byte[] $org_scalatest_assert_macro_right = bytesFromOffheapRow2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(field0StringFromArrayBackedRow2);
            String $org_scalatest_assert_macro_right2 = field0StringFromOffheapRow2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(bytesFromArrayBackedRow2);
            byte[] $org_scalatest_assert_macro_right3 = bytesFromArrayBackedRowWithOffset2;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(field0StringFromArrayBackedRow2);
            String $org_scalatest_assert_macro_right4 = field0StringFromArrayBackedRowWithOffset2;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
        }, new Position("UnsafeRowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        this.test("calling getDouble() and getFloat() on null columns", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InternalRow row = InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null}));
            UnsafeRow unsafeRow = UnsafeProjection$.MODULE$.create((DataType[])((Object[])new DataType[]{FloatType$.MODULE$, DoubleType$.MODULE$})).apply(row);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToFloat((float)unsafeRow.getFloat(0)));
            float $org_scalatest_assert_macro_right = row.getFloat(0);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)unsafeRow.getDouble(1)));
            double $org_scalatest_assert_macro_right2 = row.getDouble(1);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
        }, new Position("UnsafeRowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
        this.test("calling get(ordinal, datatype) on null columns", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            InternalRow row = InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null}));
            UnsafeRow unsafeRow = UnsafeProjection$.MODULE$.create((DataType[])((Object[])new DataType[]{NullType$.MODULE$})).apply(row);
            DataTypeTestUtils$.MODULE$.atomicTypes().foreach((Function1 & Serializable & scala.Serializable)dataType -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(unsafeRow.get(0, (DataType)dataType));
                Null$ $org_scalatest_assert_macro_right = null;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
            });
        }, new Position("UnsafeRowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
        this.test("createFromByteArray and copyFrom", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InternalRow row = InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), UTF8String.fromString((String)"abc")}));
            UnsafeProjection converter = UnsafeProjection$.MODULE$.create((DataType[])((Object[])new DataType[]{IntegerType$.MODULE$, StringType$.MODULE$}));
            UnsafeRow unsafeRow = converter.apply(row);
            UnsafeRow emptyRow = UnsafeRow.createFromByteArray((int)64, (int)2);
            Object buffer = emptyRow.getBaseObject();
            emptyRow.copyFrom(unsafeRow);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)emptyRow.getSizeInBytes()));
            int $org_scalatest_assert_macro_right = unsafeRow.getSizeInBytes();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)emptyRow.getInt(0)));
            int $org_scalatest_assert_macro_right2 = unsafeRow.getInt(0);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(emptyRow.getUTF8String(1));
            UTF8String $org_scalatest_assert_macro_right3 = unsafeRow.getUTF8String(1);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(emptyRow.getBaseObject());
            Object $org_scalatest_assert_macro_right4 = buffer;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", $org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq($org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
            unsafeRow.setInt(0, 2);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)emptyRow.getInt(0)));
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
            UTF8String longString = UTF8String.fromString((String)((String)((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 100).map((Function1 & Serializable & scala.Serializable)x$4 -> UnsafeRowSuite.$anonfun$new$9(BoxesRunTime.unboxToInt((Object)x$4)), IndexedSeq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$5, x$6) -> new StringBuilder(0).append((String)x$5).append((String)x$6).toString())));
            InternalRow row2 = InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), longString}));
            UnsafeRow unsafeRow2 = converter.apply(row2);
            emptyRow.copyFrom(unsafeRow2);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)emptyRow.getSizeInBytes()));
            int $org_scalatest_assert_macro_right6 = unsafeRow2.getSizeInBytes();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)emptyRow.getInt(0)));
            int $org_scalatest_assert_macro_right7 = 3;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(emptyRow.getUTF8String(1));
            UTF8String $org_scalatest_assert_macro_right8 = longString;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
            Object $org_scalatest_assert_macro_left9 = emptyRow.getBaseObject();
            Object $org_scalatest_assert_macro_right9 = buffer;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left9, "!=", $org_scalatest_assert_macro_right9, !BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left9, (Object)$org_scalatest_assert_macro_right9), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
            emptyRow.copyFrom(unsafeRow);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)emptyRow.getSizeInBytes()));
            int $org_scalatest_assert_macro_right10 = unsafeRow.getSizeInBytes();
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)emptyRow.getInt(0)));
            int $org_scalatest_assert_macro_right11 = unsafeRow.getInt(0);
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.convertToEqualizer(emptyRow.getUTF8String(1));
            UTF8String $org_scalatest_assert_macro_right12 = unsafeRow.getUTF8String(1);
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)$org_scalatest_assert_macro_right12, $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)$org_scalatest_assert_macro_right12, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
        }, new Position("UnsafeRowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
        this.test("calling hashCode on unsafe array returned by getArray(ordinal)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
            InternalRow row = InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new GenericArrayData(new long[]{1L})}));
            UnsafeRow unsafeRow = UnsafeProjection$.MODULE$.create((DataType[])((Object[])new DataType[]{ArrayType$.MODULE$.apply((DataType)LongType$.MODULE$)})).apply(row);
            return unsafeRow.getArray(0).hashCode();
        }, new Position("UnsafeRowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
        this.test("SPARK-32018: setDecimal with overflowed value", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Decimal qual$1 = new Decimal().set(package$.MODULE$.BigDecimal().apply("10000000000000000000"));
            int x$1 = 38;
            int x$2 = 18;
            Enumeration.Value x$3 = qual$1.toPrecision$default$3();
            boolean x$4 = qual$1.toPrecision$default$4();
            SQLQueryContext x$5 = qual$1.toPrecision$default$5();
            Decimal d1 = qual$1.toPrecision(x$1, x$2, x$3, x$4, x$5);
            InternalRow row = InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{d1}));
            UnsafeRow unsafeRow = UnsafeProjection$.MODULE$.create((DataType[])((Object[])new DataType[]{new DecimalType(38, 18)})).apply(row);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(unsafeRow.getDecimal(0, 38, 18));
            Decimal $org_scalatest_assert_macro_right = d1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
            Decimal qual$2 = d1.$times(Decimal$.MODULE$.apply(10));
            int x$6 = 39;
            int x$7 = 18;
            Enumeration.Value x$8 = qual$2.toPrecision$default$3();
            boolean x$9 = qual$2.toPrecision$default$4();
            SQLQueryContext x$10 = qual$2.toPrecision$default$5();
            Decimal d2 = qual$2.toPrecision(x$6, x$7, x$8, x$9, x$10);
            unsafeRow.setDecimal(0, d2, 38);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(unsafeRow.getDecimal(0, 38, 18));
            Null$ $org_scalatest_assert_macro_right2 = null;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", null, $org_scalatest_assert_macro_left2.$eq$eq$eq($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
        }, new Position("UnsafeRowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
    }
}

