/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector;

import java.io.File;
import java.io.Serializable;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDate;
import java.time.Period;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.spark.QueryContext;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkThrowable;
import org.apache.spark.SparkUnsupportedOperationException;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.QueryTest$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.CannotReplaceMissingTableException;
import org.apache.spark.sql.catalyst.analysis.NoSuchDatabaseException;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.trees.SQLQueryContext;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.connector.AlterTableTests;
import org.apache.spark.sql.connector.DataSourceV2SQLSuite;
import org.apache.spark.sql.connector.DataSourceV2SQLSuiteV1Filter$;
import org.apache.spark.sql.connector.InMemoryTableSessionCatalog;
import org.apache.spark.sql.connector.ReserveSchemaNullabilityCatalog;
import org.apache.spark.sql.connector.catalog.BasicInMemoryTableCatalog;
import org.apache.spark.sql.connector.catalog.BufferedRows;
import org.apache.spark.sql.connector.catalog.CatalogManager;
import org.apache.spark.sql.connector.catalog.CatalogManager$;
import org.apache.spark.sql.connector.catalog.CatalogNotFoundException;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.CatalogV2Util$;
import org.apache.spark.sql.connector.catalog.Column;
import org.apache.spark.sql.connector.catalog.ColumnDefaultValue;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.InMemoryBaseTable$;
import org.apache.spark.sql.connector.catalog.InMemoryPartitionTable;
import org.apache.spark.sql.connector.catalog.InMemoryTable;
import org.apache.spark.sql.connector.catalog.InMemoryTableCatalog;
import org.apache.spark.sql.connector.catalog.InMemoryTableCatalog$;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.V1Table;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.Literal;
import org.apache.spark.sql.connector.expressions.LiteralValue;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.execution.FilterExec;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.columnar.InMemoryRelation;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2ScanRelation;
import org.apache.spark.sql.execution.streaming.MemoryStream;
import org.apache.spark.sql.execution.streaming.MemoryStream$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.sql.sources.SimpleScanSource;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001q4AAC\u0006\u0001-!)A\u0005\u0001C\u0001K!9q\u0005\u0001b\u0001\n#B\u0003BB\u0019\u0001A\u0003%\u0011\u0006C\u00033\u0001\u0011\u00053\u0007C\u0003I\u0001\u0011%\u0011\nC\u0003\\\u0001\u0011%A\fC\u0003b\u0001\u0011%!\rC\u0003f\u0001\u0011%a\rC\u0004q\u0001E\u0005I\u0011B9\u00039\u0011\u000bG/Y*pkJ\u001cWM\u0016\u001aT#2\u001bV/\u001b;f-F2\u0015\u000e\u001c;fe*\u0011A\"D\u0001\nG>tg.Z2u_JT!AD\b\u0002\u0007M\fHN\u0003\u0002\u0011#\u0005)1\u000f]1sW*\u0011!cE\u0001\u0007CB\f7\r[3\u000b\u0003Q\t1a\u001c:h\u0007\u0001\u0019B\u0001A\f\u001c=A\u0011\u0001$G\u0007\u0002\u0017%\u0011!d\u0003\u0002\u0015\t\u0006$\u0018mU8ve\u000e,gKM*R\u0019N+\u0018\u000e^3\u0011\u0005aa\u0012BA\u000f\f\u0005=\tE\u000e^3s)\u0006\u0014G.\u001a+fgR\u001c\bCA\u0010#\u001b\u0005\u0001#BA\u0011\u000e\u0003\u0019)'O]8sg&\u00111\u0005\t\u0002\u0010#V,'/_#se>\u00148OQ1tK\u00061A(\u001b8jiz\"\u0012A\n\t\u00031\u0001\t1cY1uC2|w-\u00118e\u001d\u0006lWm\u001d9bG\u0016,\u0012!\u000b\t\u0003U=j\u0011a\u000b\u0006\u0003Y5\nA\u0001\\1oO*\ta&\u0001\u0003kCZ\f\u0017B\u0001\u0019,\u0005\u0019\u0019FO]5oO\u0006!2-\u0019;bY><\u0017I\u001c3OC6,7\u000f]1dK\u0002\n\u0001cZ3u)\u0006\u0014G.Z'fi\u0006$\u0017\r^1\u0015\u0005QR\u0004CA\u001b9\u001b\u00051$BA\u001c\f\u0003\u001d\u0019\u0017\r^1m_\u001eL!!\u000f\u001c\u0003\u000bQ\u000b'\r\\3\t\u000bm\"\u0001\u0019\u0001\u001f\u0002\u0013Q\f'\r\\3OC6,\u0007CA\u001fG\u001d\tqD\t\u0005\u0002@\u00056\t\u0001I\u0003\u0002B+\u00051AH]8pizR\u0011aQ\u0001\u0006g\u000e\fG.Y\u0005\u0003\u000b\n\u000ba\u0001\u0015:fI\u00164\u0017B\u0001\u0019H\u0015\t)%)\u0001\nuKN$8\u000b[8x\u001d\u0006lWm\u001d9bG\u0016\u001cHc\u0001&O!B\u00111\nT\u0007\u0002\u0005&\u0011QJ\u0011\u0002\u0005+:LG\u000fC\u0003P\u000b\u0001\u0007A(A\u0004tc2$V\r\u001f;\t\u000bE+\u0001\u0019\u0001*\u0002\u0011\u0015D\b/Z2uK\u0012\u00042a\u0015-=\u001d\t!fK\u0004\u0002@+&\t1)\u0003\u0002X\u0005\u00069\u0001/Y2lC\u001e,\u0017BA-[\u0005\r\u0019V-\u001d\u0006\u0003/\n\u000bQc\u00195fG.t\u0015-\\3ta\u0006\u001cWmQ8n[\u0016tG\u000fF\u0002K;~CQA\u0018\u0004A\u0002q\n\u0011B\\1nKN\u0004\u0018mY3\t\u000b\u00014\u0001\u0019\u0001\u001f\u0002\u000f\r|W.\\3oi\u0006\t2\r[3dWR\u000b'\r\\3D_6lWM\u001c;\u0015\u0007)\u001bG\rC\u0003<\u000f\u0001\u0007A\bC\u0003a\u000f\u0001\u0007A(A\ruKN$hj\u001c;TkB\u0004xN\u001d;fIZ\u00134i\\7nC:$G\u0003\u0002&hS.DQ\u0001\u001b\u0005A\u0002q\n!b]9m\u0007>lW.\u00198e\u0011\u0015Q\u0007\u00021\u0001=\u0003%\u0019\u0018\u000f\u001c)be\u0006l7\u000fC\u0004m\u0011A\u0005\t\u0019A7\u0002!\u0015D\b/Z2uK\u0012\f%oZ;nK:$\bcA&oy%\u0011qN\u0011\u0002\u0007\u001fB$\u0018n\u001c8\u0002GQ,7\u000f\u001e(piN+\b\u000f]8si\u0016$gKM\"p[6\fg\u000e\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\t!O\u000b\u0002ng.\nA\u000f\u0005\u0002vu6\taO\u0003\u0002xq\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003s\n\u000b!\"\u00198o_R\fG/[8o\u0013\tYhOA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class DataSourceV2SQLSuiteV1Filter
extends DataSourceV2SQLSuite
implements AlterTableTests {
    private final String catalogAndNamespace;

    @Override
    public /* synthetic */ void org$apache$spark$sql$connector$AlterTableTests$$super$checkErrorTableNotFound(SparkThrowable exception, String tableName, SparkFunSuite.ExpectedContext queryContext) {
        super.checkErrorTableNotFound(exception, tableName, queryContext);
    }

    @Override
    public /* synthetic */ Option org$apache$spark$sql$connector$AlterTableTests$$super$checkError$default$3() {
        return super.checkError$default$3();
    }

    @Override
    public /* synthetic */ boolean org$apache$spark$sql$connector$AlterTableTests$$super$checkError$default$5() {
        return super.checkError$default$5();
    }

    @Override
    public /* synthetic */ QueryContext[] org$apache$spark$sql$connector$AlterTableTests$$super$checkError$default$6() {
        return super.checkError$default$6();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$connector$AlterTableTests$$super$checkError(SparkThrowable exception, String errorClass, Option sqlState, scala.collection.immutable.Map parameters, boolean matchPVals, QueryContext[] queryContext) {
        super.checkError(exception, errorClass, sqlState, parameters, matchPVals, queryContext);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$connector$AlterTableTests$$super$checkError(SparkThrowable exception, String errorClass, scala.collection.immutable.Map parameters, QueryContext context) {
        super.checkError(exception, errorClass, parameters, context);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$connector$AlterTableTests$$super$checkErrorMatchPVals(SparkThrowable exception, String errorClass, Option sqlState, scala.collection.immutable.Map parameters, QueryContext context) {
        super.checkErrorMatchPVals(exception, errorClass, sqlState, parameters, context);
    }

    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$((QueryErrorsBase)this, (String)conf);
    }

    public String toDSOption(String option) {
        return QueryErrorsBase.toDSOption$((QueryErrorsBase)this, (String)option);
    }

    public String toSQLExpr(org.apache.spark.sql.catalyst.expressions.Expression e) {
        return QueryErrorsBase.toSQLExpr$((QueryErrorsBase)this, (org.apache.spark.sql.catalyst.expressions.Expression)e);
    }

    public String toSQLSchema(String schema) {
        return QueryErrorsBase.toSQLSchema$((QueryErrorsBase)this, (String)schema);
    }

    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$((QueryErrorsBase)this, (Object)v, (DataType)t);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(SQLQueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(SQLQueryContext sqlContext) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    @Override
    public String catalogAndNamespace() {
        return this.catalogAndNamespace;
    }

    @Override
    public Table getTableMetadata(String tableName) {
        Seq nameParts = this.spark().sessionState().sqlParser().parseMultipartIdentifier(tableName);
        TableCatalog v2Catalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog((String)nameParts.head())).asTableCatalog();
        String[] namespace = (String[])((TraversableOnce)((TraversableLike)nameParts.drop(1)).init()).toArray(ClassTag$.MODULE$.apply(String.class));
        return v2Catalog.loadTable(Identifier.of((String[])namespace, (String)((String)nameParts.last())));
    }

    private void testShowNamespaces(String sqlText, Seq<String> expected) {
        StructType schema = new StructType().add("namespace", (DataType)StringType$.MODULE$, false);
        Dataset df = this.spark().sql(sqlText);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(df.schema());
        StructType $org_scalatest_assert_macro_right = schema;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1377));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.collect())).map((Function1 & Serializable & scala.Serializable)x$17 -> (String)x$17.getAs(0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).sorted((Ordering)Ordering.String$.MODULE$));
        Seq $org_scalatest_assert_macro_right2 = (Seq)expected.sorted((Ordering)Ordering.String$.MODULE$);
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1378));
    }

    private void checkNamespaceComment(String namespace, String comment) {
        this.sql().apply((Object)new StringBuilder(25).append("COMMENT ON NAMESPACE ").append(namespace).append(" IS ").append(Option$.MODULE$.apply((Object)comment).map((Function1 & Serializable & scala.Serializable)x$21 -> new StringBuilder(2).append("'").append((String)x$21).append("'").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "NULL")).toString());
        String expectedComment = (String)Option$.MODULE$.apply((Object)comment).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(((Row)((Dataset)this.sql().apply((Object)new StringBuilder(24).append("DESC NAMESPACE extended ").append(namespace).toString())).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k", "v"})).where(new StringBuilder(4).append("k='").append(new StringOps(Predef$.MODULE$.augmentString("comment")).capitalize()).append("'").toString()).head()).getString(1));
        String $org_scalatest_assert_macro_right = expectedComment;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2562));
    }

    private void checkTableComment(String tableName, String comment) {
        this.sql().apply((Object)new StringBuilder(21).append("COMMENT ON TABLE ").append(tableName).append(" IS ").append(Option$.MODULE$.apply((Object)comment).map((Function1 & Serializable & scala.Serializable)x$22 -> new StringBuilder(2).append("'").append((String)x$22).append("'").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "NULL")).toString());
        String expectedComment = (String)Option$.MODULE$.apply((Object)comment).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(((Row)((Dataset)this.sql().apply((Object)new StringBuilder(14).append("DESC extended ").append(tableName).toString())).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k", "v", "c"})).where(new StringBuilder(4).append("k='").append(new StringOps(Predef$.MODULE$.augmentString("comment")).capitalize()).append("'").toString()).head()).getString(1));
        String $org_scalatest_assert_macro_right = expectedComment;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2616));
    }

    private void testNotSupportedV2Command(String sqlCommand, String sqlParams, Option<String> expectedArgument) {
        this.checkError((SparkThrowable)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(1).append(sqlCommand).append(" ").append(sqlParams).toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3314)), "NOT_SUPPORTED_COMMAND_FOR_V2_TABLE", "46110", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cmd"), expectedArgument.getOrElse((Function0 & Serializable & scala.Serializable)() -> sqlCommand))})));
    }

    private Option<String> testNotSupportedV2Command$default$3() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$new$29(DataSourceV2SQLSuiteV1Filter $this, String action) {
        AnalysisException x$38 = (AnalysisException)((Object)$this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(49).append(action).append(" TABLE table_name (id int, value interval) USING ").append($this.v2Format()).toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 299)));
        String x$39 = "_LEGACY_ERROR_TEMP_1183";
        scala.collection.immutable.Map x$40 = Predef$.MODULE$.Map().empty();
        Option x$41 = $this.checkError$default$3();
        boolean x$42 = $this.checkError$default$5();
        QueryContext[] x$43 = $this.checkError$default$6();
        $this.checkError((SparkThrowable)x$38, x$39, x$41, x$40, x$42, x$43);
        AnalysisException x$44 = (AnalysisException)((Object)$this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(45).append(action).append(" TABLE table_name (id array<interval>) USING ").append($this.v2Format()).toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 306)));
        String x$45 = "_LEGACY_ERROR_TEMP_1183";
        scala.collection.immutable.Map x$46 = Predef$.MODULE$.Map().empty();
        Option x$47 = $this.checkError$default$3();
        boolean x$48 = $this.checkError$default$5();
        QueryContext[] x$49 = $this.checkError$default$6();
        $this.checkError((SparkThrowable)x$44, x$45, x$47, x$46, x$48, x$49);
    }

    public static final /* synthetic */ void $anonfun$new$34(DataSourceV2SQLSuiteV1Filter $this, String action) {
        AnalysisException x$50 = (AnalysisException)((Object)$this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(49).append(action).append(" TABLE table_name USING ").append($this.v2Format()).append(" as select interval 1 day").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 318)));
        String x$51 = "_LEGACY_ERROR_TEMP_1183";
        scala.collection.immutable.Map x$52 = Predef$.MODULE$.Map().empty();
        Option x$53 = $this.checkError$default$3();
        boolean x$54 = $this.checkError$default$5();
        QueryContext[] x$55 = $this.checkError$default$6();
        $this.checkError((SparkThrowable)x$50, x$51, x$53, x$52, x$54, x$55);
        AnalysisException x$56 = (AnalysisException)((Object)$this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(56).append(action).append(" TABLE table_name USING ").append($this.v2Format()).append(" as select array(interval 1 day)").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 325)));
        String x$57 = "_LEGACY_ERROR_TEMP_1183";
        scala.collection.immutable.Map x$58 = Predef$.MODULE$.Map().empty();
        Option x$59 = $this.checkError$default$3();
        boolean x$60 = $this.checkError$default$5();
        QueryContext[] x$61 = $this.checkError$default$6();
        $this.checkError((SparkThrowable)x$56, x$57, x$59, x$58, x$60, x$61);
    }

    public static final /* synthetic */ void $anonfun$new$38(DataSourceV2SQLSuiteV1Filter $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            TableCatalog catalog = (TableCatalog)tuple2._1();
            String identifier = (String)tuple2._2();
            $this.spark().sql(new StringBuilder(54).append("CREATE TABLE ").append(identifier).append(" USING foo AS SELECT id, data FROM source").toString());
            Table table = catalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            String $org_scalatest_assert_macro_left = table.name();
            String $org_scalatest_assert_macro_right = identifier;
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 346));
            Object[] $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])table.partitioning());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left2), "isEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left2).isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 347));
            java.util.Map $org_scalatest_assert_macro_left3 = table.properties();
            java.util.Map $org_scalatest_assert_macro_right2 = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)"foo")})))).asJava();
            java.util.Map map = $org_scalatest_assert_macro_left3;
            java.util.Map map2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 348));
            StructType $org_scalatest_assert_macro_left4 = table.schema();
            StructType $org_scalatest_assert_macro_right3 = new StructType().add("id", (DataType)LongType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
            StructType structType = $org_scalatest_assert_macro_left4;
            StructType structType2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 349));
            SparkContext qual$11 = $this.spark().sparkContext();
            Seq x$62 = ((InMemoryTable)table).rows();
            int x$63 = qual$11.parallelize$default$2();
            RDD rdd = qual$11.parallelize(x$62, x$63, ClassTag$.MODULE$.apply(InternalRow.class));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> {
                SparkSession qual$12 = $this.spark();
                RDD x$64 = rdd;
                StructType x$65 = table.schema();
                boolean x$66 = qual$12.internalCreateDataFrame$default$3();
                return qual$12.internalCreateDataFrame(x$64, x$65, x$66);
            }, (Dataset<Row>)$this.spark().table("source"));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$41(DataSourceV2SQLSuiteV1Filter $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            TableCatalog catalog = (TableCatalog)tuple2._1();
            String identifier = (String)tuple2._2();
            Dataset df = $this.spark().sql(new StringBuilder(54).append("CREATE TABLE ").append(identifier).append(" USING foo AS SELECT id, data FROM source").toString());
            df.collect();
            df.take(5);
            df.tail(5);
            df.where("true").collect();
            df.where("true").take(5);
            df.where("true").tail(5);
            Table table = catalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            String $org_scalatest_assert_macro_left = table.name();
            String $org_scalatest_assert_macro_right = identifier;
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 377));
            Object[] $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])table.partitioning());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left2), "isEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left2).isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 378));
            java.util.Map $org_scalatest_assert_macro_left3 = table.properties();
            java.util.Map $org_scalatest_assert_macro_right2 = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)"foo")})))).asJava();
            java.util.Map map = $org_scalatest_assert_macro_left3;
            java.util.Map map2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 379));
            StructType $org_scalatest_assert_macro_left4 = table.schema();
            StructType $org_scalatest_assert_macro_right3 = new StructType().add("id", (DataType)LongType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
            StructType structType = $org_scalatest_assert_macro_left4;
            StructType structType2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 380));
            SparkContext qual$13 = $this.spark().sparkContext();
            Seq x$67 = ((InMemoryTable)table).rows();
            int x$68 = qual$13.parallelize$default$2();
            RDD rdd = qual$13.parallelize(x$67, x$68, ClassTag$.MODULE$.apply(InternalRow.class));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> {
                SparkSession qual$14 = $this.spark();
                RDD x$69 = rdd;
                StructType x$70 = table.schema();
                boolean x$71 = qual$14.internalCreateDataFrame$default$3();
                return qual$14.internalCreateDataFrame(x$69, x$70, x$71);
            }, (Dataset<Row>)$this.spark().table("source"));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$54(DataSourceV2SQLSuiteV1Filter $this, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            Table replacedTable;
            TableCatalog catalog = (TableCatalog)tuple2._1();
            String identifier = (String)tuple2._2();
            $this.spark().sql(new StringBuilder(54).append("CREATE TABLE ").append(identifier).append(" USING foo AS SELECT id, data FROM source").toString());
            Table originalTable = catalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            $this.spark().sql(new StringBuilder(49).append("REPLACE TABLE ").append(identifier).append(" USING foo AS SELECT id FROM source").toString());
            Table $org_scalatest_assert_macro_left = replacedTable = catalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            Table $org_scalatest_assert_macro_right = originalTable;
            Table table = $org_scalatest_assert_macro_left;
            Table table2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", (Object)$org_scalatest_assert_macro_right, table == null ? table2 != null : !table.equals(table2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Table should have been replaced.", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 480));
            String $org_scalatest_assert_macro_left2 = replacedTable.name();
            String $org_scalatest_assert_macro_right2 = identifier;
            String string = $org_scalatest_assert_macro_left2;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 481));
            Object[] $org_scalatest_assert_macro_left3 = Predef$.MODULE$.refArrayOps((Object[])replacedTable.partitioning());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left3), "isEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left3).isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 482));
            java.util.Map $org_scalatest_assert_macro_left4 = replacedTable.properties();
            java.util.Map $org_scalatest_assert_macro_right3 = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)"foo")})))).asJava();
            java.util.Map map = $org_scalatest_assert_macro_left4;
            java.util.Map map2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 483));
            StructType $org_scalatest_assert_macro_left5 = replacedTable.schema();
            StructType $org_scalatest_assert_macro_right4 = new StructType().add("id", (DataType)LongType$.MODULE$);
            StructType structType = $org_scalatest_assert_macro_left5;
            StructType structType2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right4, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 484));
            SparkContext qual$15 = $this.spark().sparkContext();
            Seq x$72 = ((InMemoryTable)replacedTable).rows();
            int x$73 = qual$15.parallelize$default$2();
            RDD rdd = qual$15.parallelize(x$72, x$73, ClassTag$.MODULE$.apply(InternalRow.class));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> {
                SparkSession qual$16 = $this.spark();
                RDD x$74 = rdd;
                StructType x$75 = replacedTable.schema();
                boolean x$76 = qual$16.internalCreateDataFrame$default$3();
                return qual$16.internalCreateDataFrame(x$74, x$75, x$76);
            }, (Dataset<Row>)$this.spark().table("source").select("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$58(DataSourceV2SQLSuiteV1Filter $this, String cmd$1, Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 != null) {
            Table replacedTable;
            TableCatalog catalog = (TableCatalog)tuple2._1();
            String identifier = (String)tuple2._2();
            $this.spark().sql(new StringBuilder(54).append("CREATE TABLE ").append(identifier).append(" USING foo AS SELECT id, data FROM source").toString());
            Table originalTable = catalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            Dataset df = $this.spark().sql(new StringBuilder(42).append(cmd$1).append(" TABLE ").append(identifier).append(" USING foo AS SELECT id FROM source").toString());
            df.collect();
            df.take(5);
            df.tail(5);
            df.where("true").collect();
            df.where("true").take(5);
            df.where("true").tail(5);
            Table $org_scalatest_assert_macro_left = replacedTable = catalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            Table $org_scalatest_assert_macro_right = originalTable;
            Table table = $org_scalatest_assert_macro_left;
            Table table2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", (Object)$org_scalatest_assert_macro_right, table == null ? table2 != null : !table.equals(table2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Table should have been replaced.", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 516));
            String $org_scalatest_assert_macro_left2 = replacedTable.name();
            String $org_scalatest_assert_macro_right2 = identifier;
            String string = $org_scalatest_assert_macro_left2;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 517));
            Object[] $org_scalatest_assert_macro_left3 = Predef$.MODULE$.refArrayOps((Object[])replacedTable.partitioning());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left3), "isEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left3).isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 518));
            java.util.Map $org_scalatest_assert_macro_left4 = replacedTable.properties();
            java.util.Map $org_scalatest_assert_macro_right3 = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)"foo")})))).asJava();
            java.util.Map map = $org_scalatest_assert_macro_left4;
            java.util.Map map2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 519));
            StructType $org_scalatest_assert_macro_left5 = replacedTable.schema();
            StructType $org_scalatest_assert_macro_right4 = new StructType().add("id", (DataType)LongType$.MODULE$);
            StructType structType = $org_scalatest_assert_macro_left5;
            StructType structType2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right4, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 520));
            SparkContext qual$17 = $this.spark().sparkContext();
            Seq x$77 = ((InMemoryTable)replacedTable).rows();
            int x$78 = qual$17.parallelize$default$2();
            RDD rdd = qual$17.parallelize(x$77, x$78, ClassTag$.MODULE$.apply(InternalRow.class));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> {
                SparkSession qual$18 = $this.spark();
                RDD x$79 = rdd;
                StructType x$80 = replacedTable.schema();
                boolean x$81 = qual$18.internalCreateDataFrame$default$3();
                return qual$18.internalCreateDataFrame(x$79, x$80, x$81);
            }, (Dataset<Row>)$this.spark().table("source").select("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$72(DataSourceV2SQLSuiteV1Filter $this, String catalog) {
        $this.spark().sql(new StringBuilder(59).append("CREATE TABLE ").append(catalog).append(".created USING ").append($this.v2Source()).append(" AS SELECT id, data FROM source").toString());
        CannotReplaceMissingTableException x$82 = (CannotReplaceMissingTableException)$this.intercept((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql(new StringBuilder(61).append("REPLACE TABLE ").append(catalog).append(".replaced USING ").append($this.v2Source()).append(" ").append("AS SELECT id, data FROM source").toString()), ClassTag$.MODULE$.apply(CannotReplaceMissingTableException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 639));
        String x$83 = "TABLE_OR_VIEW_NOT_FOUND";
        scala.collection.immutable.Map x$84 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationName"), (Object)"`replaced`")}));
        Option x$85 = $this.checkError$default$3();
        boolean x$86 = $this.checkError$default$5();
        QueryContext[] x$87 = $this.checkError$default$6();
        $this.checkError((SparkThrowable)x$82, x$83, x$85, x$84, x$86, x$87);
    }

    private final void insertNullValueAndCheck$1(String identifier$5, Table table$12) {
        this.sql().apply((Object)new StringBuilder(37).append("INSERT INTO ").append(identifier$5).append(" SELECT CAST(null AS INT)").toString());
        SparkContext qual$1 = this.spark().sparkContext();
        Seq x$1 = ((InMemoryTable)table$12).rows();
        int x$2 = qual$1.parallelize$default$2();
        RDD rdd2 = qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(InternalRow.class));
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> {
            SparkSession qual$2 = this.spark();
            RDD x$3 = rdd2;
            StructType x$4 = table$12.schema();
            boolean x$5 = qual$2.internalCreateDataFrame$default$3();
            return qual$2.internalCreateDataFrame(x$3, x$4, x$5);
        }, (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null})), (List)Nil$.MODULE$))));
    }

    public static final /* synthetic */ void $anonfun$new$90(DataSourceV2SQLSuiteV1Filter $this, Tuple3 x0$5) {
        Tuple3 tuple3 = x0$5;
        if (tuple3 != null) {
            TableCatalog catalog = (TableCatalog)tuple3._1();
            String identifier = (String)tuple3._2();
            boolean nullable = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
            $this.spark().sql(new StringBuilder(37).append("CREATE TABLE ").append(identifier).append(" USING foo AS SELECT 1 i").toString());
            Table table = catalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            String $org_scalatest_assert_macro_left = table.name();
            String $org_scalatest_assert_macro_right = identifier;
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 802));
            Object[] $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])table.partitioning());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left2), "isEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left2).isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 803));
            java.util.Map $org_scalatest_assert_macro_left3 = table.properties();
            java.util.Map $org_scalatest_assert_macro_right2 = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)"foo")})))).asJava();
            java.util.Map map = $org_scalatest_assert_macro_left3;
            java.util.Map map2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 804));
            StructType $org_scalatest_assert_macro_left4 = table.schema();
            StructType $org_scalatest_assert_macro_right3 = new StructType().add("i", "int", nullable);
            StructType structType = $org_scalatest_assert_macro_left4;
            StructType structType2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 805));
            SparkContext qual$31 = $this.spark().sparkContext();
            Seq x$130 = ((InMemoryTable)table).rows();
            int x$131 = qual$31.parallelize$default$2();
            RDD rdd = qual$31.parallelize(x$130, x$131, ClassTag$.MODULE$.apply(InternalRow.class));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> {
                SparkSession qual$32 = $this.spark();
                RDD x$132 = rdd;
                StructType x$133 = table.schema();
                boolean x$134 = qual$32.internalCreateDataFrame$default$3();
                return qual$32.internalCreateDataFrame(x$132, x$133, x$134);
            }, Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
            if (nullable) {
                $this.insertNullValueAndCheck$1(identifier, table);
                return;
            }
            SparkException x$135 = (SparkException)((Object)$this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.insertNullValueAndCheck$1(identifier, table), ClassTag$.MODULE$.apply(SparkException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 820)));
            Object x$136 = null;
            scala.collection.immutable.Map x$137 = Predef$.MODULE$.Map().empty();
            Option x$138 = $this.checkError$default$3();
            boolean x$139 = $this.checkError$default$5();
            QueryContext[] x$140 = $this.checkError$default$6();
            $this.checkError((SparkThrowable)x$135, null, x$138, x$137, x$139, x$140);
            return;
        }
        throw new MatchError((Object)tuple3);
    }

    public static final /* synthetic */ void $anonfun$new$96(DataSourceV2SQLSuiteV1Filter $this, String t) {
        String view = "view";
        $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{view}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(54).append("CREATE TABLE ").append(t).append(" USING foo AS SELECT id, data FROM source").toString());
            $this.sql().apply((Object)new StringBuilder(31).append("CACHE TABLE ").append(view).append(" AS SELECT id FROM ").append(t).toString());
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(t).toString()), (Dataset<Row>)$this.spark().table("source"));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(view).toString()), (Dataset<Row>)$this.spark().table("source").select("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])));
            Dataset oldView = $this.spark().table(view);
            $this.sql().apply((Object)new StringBuilder(35).append("REPLACE TABLE ").append(t).append(" (a bigint) USING foo").toString());
            Option $org_scalatest_assert_macro_left = $this.spark().sharedState().cacheManager().lookupCachedData(oldView);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 860));
        }));
    }

    public static final /* synthetic */ void $anonfun$new$102(DataSourceV2SQLSuiteV1Filter $this, String t) {
        String view = "view";
        $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{view}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(54).append("CREATE TABLE ").append(t).append(" USING foo AS SELECT id, data FROM source").toString());
            $this.sql().apply((Object)new StringBuilder(31).append("CACHE TABLE ").append(view).append(" AS SELECT id FROM ").append(t).toString());
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(t).toString()), (Dataset<Row>)$this.spark().table("source"));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(view).toString()), (Dataset<Row>)$this.spark().table("source").select("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])));
            $this.sql().apply((Object)new StringBuilder(49).append("REPLACE TABLE ").append(t).append(" USING foo AS SELECT id FROM source").toString());
            Option $org_scalatest_assert_macro_left = $this.spark().sharedState().cacheManager().lookupCachedData($this.spark().table(view));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 877));
        }));
    }

    public static final /* synthetic */ void $anonfun$new$130(DataSourceV2SQLSuiteV1Filter $this, String t$9, File checkpointDir) {
        $this.sql().apply((Object)new StringBuilder(48).append("CREATE TABLE ").append(t$9).append(" (id bigint, data string) USING foo").toString());
        $this.sql().apply((Object)new StringBuilder(29).append("INSERT INTO ").append(t$9).append(" VALUES (1L, 'a')").toString());
        $this.sql().apply((Object)new StringBuilder(12).append("CACHE TABLE ").append(t$9).toString());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuiteV1Filter.class.getClassLoader());
        public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator49$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator49$1(DataSourceV2SQLSuiteV1Filter $outer) {
            }
        }
        MemoryStream inputData = MemoryStream$.MODULE$.apply($this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator49$1(null))), $this.sqlContext());
        Dataset df = inputData.toDF().toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data"}));
        StreamingQuery query = df.writeStream().option("checkpointLocation", checkpointDir.getAbsolutePath()).toTable(t$9);
        Seq newData = (Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)2L), (Object)"b"), (List)Nil$.MODULE$);
        inputData.addData((TraversableOnce)newData);
        query.processAllAvailable();
        query.stop();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.spark().catalog().isCached("testcat.ns.t"), "DataSourceV2SQLSuiteV1Filter.this.spark.catalog.isCached(\"testcat.ns.t\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 966));
        Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)1L), "a"}));
        Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)2L), "b"}));
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(t$9).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row2).$colon$colon((Object)row));
    }

    private final void check$1(String tbl) {
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(64).append("SELECT testcat.ns1.ns2.tbl.id, testcat.ns1.ns2.tbl.point.x FROM ").append(tbl).toString()), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)10)})));
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(48).append("SELECT ns1.ns2.tbl.id, ns1.ns2.tbl.point.x FROM ").append(tbl).toString()), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)10)})));
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(40).append("SELECT ns2.tbl.id, ns2.tbl.point.x FROM ").append(tbl).toString()), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)10)})));
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(32).append("SELECT tbl.id, tbl.point.x FROM ").append(tbl).toString()), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)10)})));
    }

    public static final /* synthetic */ void $anonfun$new$156(DataSourceV2SQLSuiteV1Filter $this, boolean useV1Table) {
        String format;
        String string = format = useV1Table ? "json" : $this.v2Format();
        if (useV1Table) {
            $this.spark().conf().unset(SQLConf$.MODULE$.V2_SESSION_CATALOG_IMPLEMENTATION().key());
        } else {
            $this.spark().conf().set(SQLConf$.MODULE$.V2_SESSION_CATALOG_IMPLEMENTATION().key(), InMemoryTableSessionCatalog.class.getName());
        }
        $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(38).append("CREATE TABLE t USING ").append(format).append(" AS SELECT 1 AS i").toString());
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"select i from t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"select t.i from t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"select default.t.i from t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"select spark_catalog.default.t.i from t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"select t.i from spark_catalog.default.t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"select default.t.i from spark_catalog.default.t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"select spark_catalog.default.t.i from spark_catalog.default.t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
        });
    }

    public static final /* synthetic */ boolean $anonfun$new$189(String x$15) {
        String string = x$15;
        String string2 = "comment";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$new$192(DataSourceV2SQLSuiteV1Filter $this, String clause$1, String key$1, scala.collection.immutable.Map keyParameters$1, String action) {
        String sqlText = new StringBuilder(59).append(action).append(" TABLE testcat.reservedTest (key int) ").append("USING foo ").append(clause$1).append(" ('").append(key$1).append("'='bar')").toString();
        $this.checkError((SparkThrowable)$this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)sqlText), ClassTag$.MODULE$.apply(ParseException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1253)), "UNSUPPORTED_FEATURE.SET_TABLE_PROPERTY", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)key$1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"msg"), keyParameters$1.getOrElse((Object)key$1, (Function0 & Serializable & scala.Serializable)() -> "please remove it from the TBLPROPERTIES list."))})), (QueryContext)$this.ExpectedContext().apply(sqlText, 0, 58 + key$1.length() + clause$1.length() + action.length()));
    }

    public static final /* synthetic */ void $anonfun$new$191(DataSourceV2SQLSuiteV1Filter $this, String key$1, scala.collection.immutable.Map keyParameters$1, String clause) {
        ((IterableLike)new .colon.colon((Object)"CREATE", (List)new .colon.colon((Object)"REPLACE", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)action -> {
            DataSourceV2SQLSuiteV1Filter.$anonfun$new$192($this, clause, key$1, keyParameters$1, action);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$190(DataSourceV2SQLSuiteV1Filter $this, scala.collection.immutable.Map keyParameters$1, String key) {
        ((IterableLike)new .colon.colon((Object)"OPTIONS", (List)new .colon.colon((Object)"TBLPROPERTIES", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)clause -> {
            DataSourceV2SQLSuiteV1Filter.$anonfun$new$191($this, key, keyParameters$1, clause);
            return BoxedUnit.UNIT;
        });
        String sql1 = new StringBuilder(61).append("ALTER TABLE testcat.reservedTest SET TBLPROPERTIES ('").append(key).append("'='bar')").toString();
        $this.checkError((SparkThrowable)$this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)sql1), ClassTag$.MODULE$.apply(ParseException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1270)), "UNSUPPORTED_FEATURE.SET_TABLE_PROPERTY", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)key), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"msg"), keyParameters$1.getOrElse((Object)key, (Function0 & Serializable & scala.Serializable)() -> "please remove it from the TBLPROPERTIES list."))})), (QueryContext)$this.ExpectedContext().apply(sql1, 0, 60 + key.length()));
        String sql2 = new StringBuilder(57).append("ALTER TABLE testcat.reservedTest UNSET TBLPROPERTIES ('").append(key).append("')").toString();
        $this.checkError((SparkThrowable)$this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)sql2), ClassTag$.MODULE$.apply(ParseException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1285)), "UNSUPPORTED_FEATURE.SET_TABLE_PROPERTY", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)key), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"msg"), keyParameters$1.getOrElse((Object)key, (Function0 & Serializable & scala.Serializable)() -> "please remove it from the TBLPROPERTIES list."))})), (QueryContext)$this.ExpectedContext().apply(sql2, 0, 56 + key.length()));
    }

    public static final /* synthetic */ boolean $anonfun$new$200(String x$16) {
        String string = x$16;
        String string2 = "comment";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$new$201(DataSourceV2SQLSuiteV1Filter $this, String key) {
        ((IterableLike)new .colon.colon((Object)"OPTIONS", (List)new .colon.colon((Object)"TBLPROPERTIES", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)clause -> {
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"testcat.reservedTest"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"CREATE", (List)new .colon.colon((Object)"REPLACE", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)action -> {
                String originValue;
                $this.sql().apply((Object)new StringBuilder(59).append((String)action).append(" TABLE testcat.reservedTest (key int) USING foo ").append(clause).append(" ('").append(key$2).append("'='bar')").toString());
                TableCatalog tableCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper($this.catalog("testcat")).asTableCatalog();
                Identifier identifier = Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"reservedTest");
                String $org_scalatest_assert_macro_left = originValue = (String)tableCatalog.loadTable(identifier).properties().get(key$2);
                String $org_scalatest_assert_macro_right = "bar";
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", (Object)$org_scalatest_assert_macro_right, string == null ? string2 != null : !string.equals(string2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"reserved properties should not have side effects", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1308));
                $this.sql().apply((Object)new StringBuilder(66).append("ALTER TABLE testcat.reservedTest SET TBLPROPERTIES ('").append(key$2).append("'='newValue')").toString());
                String $org_scalatest_assert_macro_left2 = (String)tableCatalog.loadTable(identifier).properties().get(key$2);
                String $org_scalatest_assert_macro_right2 = originValue;
                String string3 = $org_scalatest_assert_macro_left2;
                String string4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"reserved properties should not have side effects", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1310));
                $this.sql().apply((Object)new StringBuilder(57).append("ALTER TABLE testcat.reservedTest UNSET TBLPROPERTIES ('").append(key$2).append("')").toString());
                String $org_scalatest_assert_macro_left3 = (String)tableCatalog.loadTable(identifier).properties().get(key$2);
                String $org_scalatest_assert_macro_right3 = originValue;
                String string5 = $org_scalatest_assert_macro_left3;
                String string6 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"reserved properties should not have side effects", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1313));
            }));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$222(DataSourceV2SQLSuiteV1Filter $this, String tblName$1, String tableDefinition$1, String statement) {
        $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(8).append("testcat.").append(tblName$1).toString()}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String string = statement;
            String string2 = "REPLACE TABLE";
            Object object = !(string != null ? !string.equals(string2) : string2 != null) ? $this.sql().apply((Object)new StringBuilder(38).append("CREATE TABLE testcat.").append(tblName$1).append("(a INT) USING foo").toString()) : BoxedUnit.UNIT;
            $this.sql().apply((Object)new StringBuilder(9).append(statement).append(" testcat.").append(tableDefinition$1).toString());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(CatalogV2Implicits$.MODULE$.CatalogHelper($this.catalog("testcat")).asTableCatalog().tableExists(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)tblName$1)), "org.apache.spark.sql.connector.catalog.CatalogV2Implicits.CatalogHelper(DataSourceV2SQLSuiteV1Filter.this.catalog(\"testcat\")).asTableCatalog.tableExists(org.apache.spark.sql.connector.catalog.Identifier.of(scala.Array.apply[String]()((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String])), tblName))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1480));
        });
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.sql.catalog.dummy"), (Object)BasicInMemoryTableCatalog.class.getName())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            AnalysisException x$207 = (AnalysisException)((Object)((Object)$this.intercept((Function0 & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)"USE dummy");
                return (Dataset)$this.sql().apply((Object)new StringBuilder(7).append(statement).append(" dummy.").append(tableDefinition$1).toString());
            }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1485))));
            String x$208 = "UNSUPPORTED_FEATURE.TABLE_OPERATION";
            scala.collection.immutable.Map x$209 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)"`dummy`.`my_tab`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)"column default value")}));
            Option x$210 = $this.checkError$default$3();
            boolean x$211 = $this.checkError$default$5();
            QueryContext[] x$212 = $this.checkError$default$6();
            $this.checkError((SparkThrowable)x$207, x$208, x$210, x$209, x$211, x$212);
        });
    }

    public static final /* synthetic */ void $anonfun$new$227(DataSourceV2SQLSuiteV1Filter $this, String tblName$2, String tableDefinition$2, String statement) {
        $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(8).append("testcat.").append(tblName$2).toString()}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String string = statement;
            String string2 = "REPLACE TABLE";
            Object object = !(string != null ? !string.equals(string2) : string2 != null) ? $this.sql().apply((Object)new StringBuilder(38).append("CREATE TABLE testcat.").append(tblName$2).append("(a INT) USING foo").toString()) : BoxedUnit.UNIT;
            $this.sql().apply((Object)new StringBuilder(19).append(statement).append(" testcat.").append(tableDefinition$2).append(" USING foo").toString());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(CatalogV2Implicits$.MODULE$.CatalogHelper($this.catalog("testcat")).asTableCatalog().tableExists(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)tblName$2)), "org.apache.spark.sql.connector.catalog.CatalogV2Implicits.CatalogHelper(DataSourceV2SQLSuiteV1Filter.this.catalog(\"testcat\")).asTableCatalog.tableExists(org.apache.spark.sql.connector.catalog.Identifier.of(scala.Array.apply[String]()((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String])), tblName))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1512));
        });
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.sql.catalog.dummy"), (Object)BasicInMemoryTableCatalog.class.getName())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            AnalysisException x$213 = (AnalysisException)((Object)((Object)$this.intercept((Function0 & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)"USE dummy");
                return (Dataset)$this.sql().apply((Object)new StringBuilder(17).append(statement).append(" dummy.").append(tableDefinition$2).append(" USING foo").toString());
            }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1517))));
            String x$214 = "UNSUPPORTED_FEATURE.TABLE_OPERATION";
            scala.collection.immutable.Map x$215 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)"`dummy`.`my_tab`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)"generated columns")}));
            Option x$216 = $this.checkError$default$3();
            boolean x$217 = $this.checkError$default$5();
            QueryContext[] x$218 = $this.checkError$default$6();
            $this.checkError((SparkThrowable)x$213, x$214, x$216, x$215, x$217, x$218);
        });
    }

    private final void checkUnsupportedGenerationExpression$1(String expr, String expectedReason, String genColType, Option customTableDef, String tblName$4) {
        String tableDef = new StringBuilder(65).append("CREATE TABLE testcat.").append(tblName$4).append("(a INT, b ").append(genColType).append(" GENERATED ALWAYS AS (").append(expr).append(")) USING foo").toString();
        this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(8).append("testcat.").append(tblName$4).toString()}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            AnalysisException x$1 = (AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply(customTableDef.getOrElse((Function0 & Serializable & scala.Serializable)() -> tableDef)), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1567))));
            String x$2 = "UNSUPPORTED_EXPRESSION_GENERATED_COLUMN";
            scala.collection.immutable.Map x$3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldName"), (Object)"b"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expressionStr"), (Object)expr), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"reason"), (Object)expectedReason)}));
            Option x$4 = this.checkError$default$3();
            boolean x$5 = this.checkError$default$5();
            QueryContext[] x$6 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$1, x$2, x$4, x$3, x$5, x$6);
        });
    }

    private static final String checkUnsupportedGenerationExpression$default$3$1() {
        return "INT";
    }

    private static final Option checkUnsupportedGenerationExpression$default$4$1() {
        return None$.MODULE$;
    }

    private final void testShowCurrentNamespace$1(String expectedCatalogName, String expectedNamespace) {
        StructType schema = new StructType().add("catalog", (DataType)StringType$.MODULE$, false).add("namespace", (DataType)StringType$.MODULE$, false);
        Dataset df = (Dataset)this.sql().apply((Object)"SHOW CURRENT NAMESPACE");
        Row[] rows = (Row[])df.collect();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(df.schema());
        StructType $org_scalatest_assert_macro_right = schema;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1747));
        Row[] $org_scalatest_assert_macro_left2 = rows;
        int $org_scalatest_assert_macro_right2 = 1;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1748));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(rows[0].getAs(0));
        String $org_scalatest_assert_macro_right3 = expectedCatalogName;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1749));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(rows[0].getAs(1));
        String $org_scalatest_assert_macro_right4 = expectedNamespace;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1750));
    }

    private final void checkPartitioning$1(TableCatalog cat, String partition) {
        String string = cat.name();
        String string2 = CatalogManager$.MODULE$.SESSION_CATALOG_NAME();
        String[] namespace = !(string != null ? !string.equals(string2) : string2 != null) ? (String[])((Object[])new String[]{"default"}) : (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
        Table table = cat.loadTable(Identifier.of((String[])namespace, (String)"tbl"));
        NamedReference[][] partitions = (NamedReference[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])table.partitioning())).map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.references(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(NamedReference.class))));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)partitions.length));
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1776));
        String[][] fieldNames = (String[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitions)).flatMap((Function1 & Serializable & scala.Serializable)x$19 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$19)).map((Function1 & Serializable & scala.Serializable)x$20 -> x$20.fieldNames(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(fieldNames);
        String[][] $org_scalatest_assert_macro_right2 = (String[][])((Object[])new String[][]{(String[])((Object[])new String[]{partition})});
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1778));
    }

    private final void checkFailure$1(String statement) {
        this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            AnalysisException x$1 = (AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)statement), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1795))));
            Object x$2 = null;
            scala.collection.immutable.Map x$3 = Predef$.MODULE$.Map().empty();
            Option x$4 = this.checkError$default$3();
            boolean x$5 = this.checkError$default$5();
            QueryContext[] x$6 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$1, null, x$4, x$3, x$5, x$6);
        });
    }

    public static final /* synthetic */ void $anonfun$new$266(DataSourceV2SQLSuiteV1Filter $this, Tuple2 x0$6) {
        Tuple2 tuple2 = x0$6;
        if (tuple2 != null) {
            boolean caseSensitive = tuple2._1$mcZ$sp();
            Tuple2 tuple22 = (Tuple2)tuple2._2();
            if (tuple22 != null) {
                String c0 = (String)tuple22._1();
                String c1 = (String)tuple22._2();
                $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE().key()), (Object)Boolean.toString(caseSensitive))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    AnalysisException x$237 = $this.analysisException(new StringBuilder(34).append("CREATE TABLE t (").append(c0).append(" INT, ").append(c1).append(" INT) USING ").append($this.v2Source()).toString());
                    String x$238 = "COLUMN_ALREADY_EXISTS";
                    scala.collection.immutable.Map x$239 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)new StringBuilder(2).append("`").append(c0.toLowerCase(Locale.ROOT)).append("`").toString())}));
                    Option x$240 = $this.checkError$default$3();
                    boolean x$241 = $this.checkError$default$5();
                    QueryContext[] x$242 = $this.checkError$default$6();
                    $this.checkError((SparkThrowable)x$237, x$238, x$240, x$239, x$241, x$242);
                    AnalysisException x$243 = $this.analysisException(new StringBuilder(42).append("CREATE TABLE testcat.t (").append(c0).append(" INT, ").append(c1).append(" INT) USING ").append($this.v2Source()).toString());
                    String x$244 = "COLUMN_ALREADY_EXISTS";
                    scala.collection.immutable.Map x$245 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)new StringBuilder(2).append("`").append(c0.toLowerCase(Locale.ROOT)).append("`").toString())}));
                    Option x$246 = $this.checkError$default$3();
                    boolean x$247 = $this.checkError$default$5();
                    QueryContext[] x$248 = $this.checkError$default$6();
                    $this.checkError((SparkThrowable)x$243, x$244, x$246, x$245, x$247, x$248);
                    AnalysisException x$249 = $this.analysisException(new StringBuilder(45).append("CREATE OR REPLACE TABLE t (").append(c0).append(" INT, ").append(c1).append(" INT) USING ").append($this.v2Source()).toString());
                    String x$250 = "COLUMN_ALREADY_EXISTS";
                    scala.collection.immutable.Map x$251 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)new StringBuilder(2).append("`").append(c0.toLowerCase(Locale.ROOT)).append("`").toString())}));
                    Option x$252 = $this.checkError$default$3();
                    boolean x$253 = $this.checkError$default$5();
                    QueryContext[] x$254 = $this.checkError$default$6();
                    $this.checkError((SparkThrowable)x$249, x$250, x$252, x$251, x$253, x$254);
                    AnalysisException x$255 = $this.analysisException(new StringBuilder(53).append("CREATE OR REPLACE TABLE testcat.t (").append(c0).append(" INT, ").append(c1).append(" INT) USING ").append($this.v2Source()).toString());
                    String x$256 = "COLUMN_ALREADY_EXISTS";
                    scala.collection.immutable.Map x$257 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)new StringBuilder(2).append("`").append(c0.toLowerCase(Locale.ROOT)).append("`").toString())}));
                    Option x$258 = $this.checkError$default$3();
                    boolean x$259 = $this.checkError$default$5();
                    QueryContext[] x$260 = $this.checkError$default$6();
                    $this.checkError((SparkThrowable)x$255, x$256, x$258, x$257, x$259, x$260);
                });
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$269(DataSourceV2SQLSuiteV1Filter $this, Tuple2 x0$7) {
        Tuple2 tuple2 = x0$7;
        if (tuple2 != null) {
            boolean caseSensitive = tuple2._1$mcZ$sp();
            Tuple2 tuple22 = (Tuple2)tuple2._2();
            if (tuple22 != null) {
                String c0 = (String)tuple22._1();
                String c1 = (String)tuple22._2();
                $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE().key()), (Object)Boolean.toString(caseSensitive))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    AnalysisException x$261 = $this.analysisException(new StringBuilder(46).append("CREATE TABLE t (d struct<").append(c0).append(": INT, ").append(c1).append(": INT>) USING ").append($this.v2Source()).toString());
                    String x$262 = "COLUMN_ALREADY_EXISTS";
                    scala.collection.immutable.Map x$263 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)$this.toSQLId(new StringBuilder(2).append("d.").append(c0.toLowerCase(Locale.ROOT)).toString()))}));
                    Option x$264 = $this.checkError$default$3();
                    boolean x$265 = $this.checkError$default$5();
                    QueryContext[] x$266 = $this.checkError$default$6();
                    $this.checkError((SparkThrowable)x$261, x$262, x$264, x$263, x$265, x$266);
                    AnalysisException x$267 = $this.analysisException(new StringBuilder(54).append("CREATE TABLE testcat.t (d struct<").append(c0).append(": INT, ").append(c1).append(": INT>) USING ").append($this.v2Source()).toString());
                    String x$268 = "COLUMN_ALREADY_EXISTS";
                    scala.collection.immutable.Map x$269 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)$this.toSQLId(new StringBuilder(2).append("d.").append(c0.toLowerCase(Locale.ROOT)).toString()))}));
                    Option x$270 = $this.checkError$default$3();
                    boolean x$271 = $this.checkError$default$5();
                    QueryContext[] x$272 = $this.checkError$default$6();
                    $this.checkError((SparkThrowable)x$267, x$268, x$270, x$269, x$271, x$272);
                    AnalysisException x$273 = $this.analysisException(new StringBuilder(57).append("CREATE OR REPLACE TABLE t (d struct<").append(c0).append(": INT, ").append(c1).append(": INT>) USING ").append($this.v2Source()).toString());
                    String x$274 = "COLUMN_ALREADY_EXISTS";
                    scala.collection.immutable.Map x$275 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)$this.toSQLId(new StringBuilder(2).append("d.").append(c0.toLowerCase(Locale.ROOT)).toString()))}));
                    Option x$276 = $this.checkError$default$3();
                    boolean x$277 = $this.checkError$default$5();
                    QueryContext[] x$278 = $this.checkError$default$6();
                    $this.checkError((SparkThrowable)x$273, x$274, x$276, x$275, x$277, x$278);
                    AnalysisException x$279 = $this.analysisException(new StringBuilder(65).append("CREATE OR REPLACE TABLE testcat.t (d struct<").append(c0).append(": INT, ").append(c1).append(": INT>) USING ").append($this.v2Source()).toString());
                    String x$280 = "COLUMN_ALREADY_EXISTS";
                    scala.collection.immutable.Map x$281 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)$this.toSQLId(new StringBuilder(2).append("d.").append(c0.toLowerCase(Locale.ROOT)).toString()))}));
                    Option x$282 = $this.checkError$default$3();
                    boolean x$283 = $this.checkError$default$5();
                    QueryContext[] x$284 = $this.checkError$default$6();
                    $this.checkError((SparkThrowable)x$279, x$280, x$282, x$281, x$283, x$284);
                });
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$276(DataSourceV2SQLSuiteV1Filter $this, Tuple2 x0$8) {
        Tuple2 tuple2 = x0$8;
        if (tuple2 != null) {
            boolean caseSensitive = tuple2._1$mcZ$sp();
            Tuple2 tuple22 = (Tuple2)tuple2._2();
            if (tuple22 != null) {
                String c0 = (String)tuple22._1();
                String c1 = (String)tuple22._2();
                $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE().key()), (Object)Boolean.toString(caseSensitive))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    AnalysisException x$309 = $this.analysisException(new StringBuilder(48).append("CREATE TABLE t (").append(c0).append(" INT) USING ").append($this.v2Source()).append(" PARTITIONED BY (").append(c0).append(", ").append(c1).append(")").toString());
                    Object x$310 = null;
                    scala.collection.immutable.Map x$311 = Predef$.MODULE$.Map().empty();
                    Option x$312 = $this.checkError$default$3();
                    boolean x$313 = $this.checkError$default$5();
                    QueryContext[] x$314 = $this.checkError$default$6();
                    $this.checkError((SparkThrowable)x$309, null, x$312, x$311, x$313, x$314);
                    AnalysisException x$315 = $this.analysisException(new StringBuilder(56).append("CREATE TABLE testcat.t (").append(c0).append(" INT) USING ").append($this.v2Source()).append(" PARTITIONED BY (").append(c0).append(", ").append(c1).append(")").toString());
                    Object x$316 = null;
                    scala.collection.immutable.Map x$317 = Predef$.MODULE$.Map().empty();
                    Option x$318 = $this.checkError$default$3();
                    boolean x$319 = $this.checkError$default$5();
                    QueryContext[] x$320 = $this.checkError$default$6();
                    $this.checkError((SparkThrowable)x$315, null, x$318, x$317, x$319, x$320);
                    AnalysisException x$321 = $this.analysisException(new StringBuilder(59).append("CREATE OR REPLACE TABLE t (").append(c0).append(" INT) USING ").append($this.v2Source()).append(" PARTITIONED BY (").append(c0).append(", ").append(c1).append(")").toString());
                    Object x$322 = null;
                    scala.collection.immutable.Map x$323 = Predef$.MODULE$.Map().empty();
                    Option x$324 = $this.checkError$default$3();
                    boolean x$325 = $this.checkError$default$5();
                    QueryContext[] x$326 = $this.checkError$default$6();
                    $this.checkError((SparkThrowable)x$321, null, x$324, x$323, x$325, x$326);
                    AnalysisException x$327 = $this.analysisException(new StringBuilder(67).append("CREATE OR REPLACE TABLE testcat.t (").append(c0).append(" INT) ").append("USING ").append($this.v2Source()).append(" PARTITIONED BY (").append(c0).append(", ").append(c1).append(")").toString());
                    Object x$328 = null;
                    scala.collection.immutable.Map x$329 = Predef$.MODULE$.Map().empty();
                    Option x$330 = $this.checkError$default$3();
                    boolean x$331 = $this.checkError$default$5();
                    QueryContext[] x$332 = $this.checkError$default$6();
                    $this.checkError((SparkThrowable)x$327, null, x$330, x$329, x$331, x$332);
                });
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$279(DataSourceV2SQLSuiteV1Filter $this, Tuple2 x0$9) {
        Tuple2 tuple2 = x0$9;
        if (tuple2 != null) {
            boolean caseSensitive = tuple2._1$mcZ$sp();
            Tuple2 tuple22 = (Tuple2)tuple2._2();
            if (tuple22 != null) {
                String c0 = (String)tuple22._1();
                String c1 = (String)tuple22._2();
                $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE().key()), (Object)Boolean.toString(caseSensitive))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    AnalysisException x$333 = $this.analysisException(new StringBuilder(61).append("CREATE TABLE t (").append(c0).append(" INT) USING ").append($this.v2Source()).append(" ").append("CLUSTERED BY (").append(c0).append(", ").append(c1).append(") INTO 2 BUCKETS").toString());
                    String x$334 = "COLUMN_ALREADY_EXISTS";
                    scala.collection.immutable.Map x$335 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)new StringBuilder(2).append("`").append(c0.toLowerCase(Locale.ROOT)).append("`").toString())}));
                    Option x$336 = $this.checkError$default$3();
                    boolean x$337 = $this.checkError$default$5();
                    QueryContext[] x$338 = $this.checkError$default$6();
                    $this.checkError((SparkThrowable)x$333, x$334, x$336, x$335, x$337, x$338);
                    AnalysisException x$339 = $this.analysisException(new StringBuilder(69).append("CREATE TABLE testcat.t (").append(c0).append(" INT) USING ").append($this.v2Source()).append(" ").append("CLUSTERED BY (").append(c0).append(", ").append(c1).append(") INTO 2 BUCKETS").toString());
                    String x$340 = "COLUMN_ALREADY_EXISTS";
                    scala.collection.immutable.Map x$341 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)new StringBuilder(2).append("`").append(c0.toLowerCase(Locale.ROOT)).append("`").toString())}));
                    Option x$342 = $this.checkError$default$3();
                    boolean x$343 = $this.checkError$default$5();
                    QueryContext[] x$344 = $this.checkError$default$6();
                    $this.checkError((SparkThrowable)x$339, x$340, x$342, x$341, x$343, x$344);
                    AnalysisException x$345 = $this.analysisException(new StringBuilder(72).append("CREATE OR REPLACE TABLE t (").append(c0).append(" INT) USING ").append($this.v2Source()).append(" ").append("CLUSTERED BY (").append(c0).append(", ").append(c1).append(") INTO 2 BUCKETS").toString());
                    String x$346 = "COLUMN_ALREADY_EXISTS";
                    scala.collection.immutable.Map x$347 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)new StringBuilder(2).append("`").append(c0.toLowerCase(Locale.ROOT)).append("`").toString())}));
                    Option x$348 = $this.checkError$default$3();
                    boolean x$349 = $this.checkError$default$5();
                    QueryContext[] x$350 = $this.checkError$default$6();
                    $this.checkError((SparkThrowable)x$345, x$346, x$348, x$347, x$349, x$350);
                    AnalysisException x$351 = $this.analysisException(new StringBuilder(80).append("CREATE OR REPLACE TABLE testcat.t (").append(c0).append(" INT) USING ").append($this.v2Source()).append(" ").append("CLUSTERED BY (").append(c0).append(", ").append(c1).append(") INTO 2 BUCKETS").toString());
                    String x$352 = "COLUMN_ALREADY_EXISTS";
                    scala.collection.immutable.Map x$353 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)new StringBuilder(2).append("`").append(c0.toLowerCase(Locale.ROOT)).append("`").toString())}));
                    Option x$354 = $this.checkError$default$3();
                    boolean x$355 = $this.checkError$default$5();
                    QueryContext[] x$356 = $this.checkError$default$6();
                    $this.checkError((SparkThrowable)x$351, x$352, x$354, x$353, x$355, x$356);
                });
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    private final boolean isCached$1(String table) {
        return this.spark().table(table).queryExecution().withCachedData() instanceof InMemoryRelation;
    }

    private final void verify$1(String sql) {
        AnalysisException x$1 = (AnalysisException)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.spark().sql(sql), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2434)));
        String x$2 = "REQUIRES_SINGLE_PART_NAMESPACE";
        scala.collection.immutable.Map x$3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sessionCatalog"), (Object)"spark_catalog"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"namespace"), (Object)"")}));
        Option x$4 = this.checkError$default$3();
        boolean x$5 = this.checkError$default$5();
        QueryContext[] x$6 = this.checkError$default$6();
        this.checkError((SparkThrowable)x$1, x$2, x$4, x$3, x$5, x$6);
    }

    private final void assertWrongTableIdent$1() {
        this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE t USING json AS SELECT 1 AS i");
            String t = "spark_catalog.t";
            this.verify$1(new StringBuilder(14).append("select * from ").append(t).toString());
            this.verify$1(new StringBuilder(14).append("REFRESH TABLE ").append(t).toString());
            this.verify$1(new StringBuilder(11).append("DESCRIBE ").append(t).append(" i").toString());
            this.verify$1(new StringBuilder(11).append("DROP TABLE ").append(t).toString());
            this.verify$1(new StringBuilder(10).append("DROP VIEW ").append(t).toString());
            this.verify$1(new StringBuilder(33).append("ANALYZE TABLE ").append(t).append(" COMPUTE STATISTICS").toString());
            this.verify$1(new StringBuilder(49).append("ANALYZE TABLE ").append(t).append(" COMPUTE STATISTICS FOR ALL COLUMNS").toString());
            this.verify$1(new StringBuilder(18).append("MSCK REPAIR TABLE ").append(t).toString());
            this.verify$1(new StringBuilder(39).append("LOAD DATA INPATH 'filepath' INTO TABLE ").append(t).toString());
            this.verify$1(new StringBuilder(18).append("SHOW CREATE TABLE ").append(t).toString());
            this.verify$1(new StringBuilder(27).append("SHOW CREATE TABLE ").append(t).append(" AS SERDE").toString());
            this.verify$1(new StringBuilder(12).append("CACHE TABLE ").append(t).toString());
            this.verify$1(new StringBuilder(14).append("UNCACHE TABLE ").append(t).toString());
            this.verify$1(new StringBuilder(15).append("TRUNCATE TABLE ").append(t).toString());
            this.verify$1(new StringBuilder(18).append("SHOW COLUMNS FROM ").append(t).toString());
        });
    }

    private final void check$2(String tbl) {
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(34).append("SELECT testcat.ns1.ns2.tbl.* FROM ").append(tbl).toString()), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "hello"})));
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(26).append("SELECT ns1.ns2.tbl.* FROM ").append(tbl).toString()), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "hello"})));
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(22).append("SELECT ns2.tbl.* FROM ").append(tbl).toString()), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "hello"})));
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(18).append("SELECT tbl.* FROM ").append(tbl).toString()), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "hello"})));
    }

    private static final Timestamp testTimestamp$1(int daysOffset) {
        return Timestamp.valueOf(LocalDate.of(2020, 1, 1 + daysOffset).atStartOfDay());
    }

    private final void validateViewCommand$1(String sqlStatement) {
        AnalysisException e;
        AnalysisException x$1 = e = (AnalysisException)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)sqlStatement), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2706)));
        String x$2 = "UNSUPPORTED_FEATURE.CATALOG_OPERATION";
        scala.collection.immutable.Map x$3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"catalogName"), (Object)"`testcat`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)"views")}));
        Option x$4 = this.checkError$default$3();
        boolean x$5 = this.checkError$default$5();
        QueryContext[] x$6 = this.checkError$default$6();
        this.checkError((SparkThrowable)x$1, x$2, x$4, x$3, x$5, x$6);
    }

    public static final /* synthetic */ int $anonfun$new$405(BufferedRows x$23) {
        return x$23.partitionKey().getInt(0);
    }

    public static final /* synthetic */ int $anonfun$new$406(BufferedRows x$24) {
        return x$24.partitionKey().getInt(0);
    }

    public static final /* synthetic */ int $anonfun$new$407(BufferedRows x$25) {
        return x$25.partitionKey().getInt(0);
    }

    public static final /* synthetic */ int $anonfun$new$408(BufferedRows x$26) {
        return x$26.partitionKey().getInt(0);
    }

    public static final /* synthetic */ boolean $anonfun$new$449(SparkPlan x$27) {
        return x$27 instanceof FilterExec;
    }

    public static final /* synthetic */ boolean $anonfun$new$453(SparkPlan x$28) {
        return x$28 instanceof FilterExec;
    }

    public DataSourceV2SQLSuiteV1Filter() {
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$((QueryErrorsBase)this);
        AlterTableTests.$init$(this);
        this.catalogAndNamespace = "testcat.ns1.ns2.";
        this.test("CreateTable: use v2 plan because catalog is set", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql("CREATE TABLE testcat.table_name (id bigint NOT NULL, data string) USING foo");
            TableCatalog testCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            Table table = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            String $org_scalatest_assert_macro_left = table.name();
            String $org_scalatest_assert_macro_right = "testcat.table_name";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
            Object[] $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])table.partitioning());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left2), "isEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left2).isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
            java.util.Map $org_scalatest_assert_macro_left3 = table.properties();
            java.util.Map $org_scalatest_assert_macro_right2 = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)"foo")})))).asJava();
            java.util.Map map = $org_scalatest_assert_macro_left3;
            java.util.Map map2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
            StructType $org_scalatest_assert_macro_left4 = table.schema();
            StructType $org_scalatest_assert_macro_right3 = new StructType().add("id", (DataType)LongType$.MODULE$, false).add("data", (DataType)StringType$.MODULE$);
            StructType structType = $org_scalatest_assert_macro_left4;
            StructType structType2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
            SparkContext qual$1 = this.spark().sparkContext();
            Seq x$1 = ((InMemoryTable)table).rows();
            int x$2 = qual$1.parallelize$default$2();
            RDD rdd = qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(InternalRow.class));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> {
                SparkSession qual$2 = this.spark();
                RDD x$3 = rdd;
                StructType x$4 = table.schema();
                boolean x$5 = qual$2.internalCreateDataFrame$default$3();
                return qual$2.internalCreateDataFrame(x$3, x$4, x$5);
            }, (Seq<Row>)((Seq)Nil$.MODULE$));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
        this.test("Describe column for v2 catalog", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testcat.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(64).append("CREATE TABLE ").append(t).append(" (id bigint, data string COMMENT 'hello') USING foo").toString());
                Dataset df1 = (Dataset)this.sql().apply((Object)new StringBuilder(12).append("DESCRIBE ").append(t).append(" id").toString());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(df1.schema().map((Function1 & Serializable & scala.Serializable)field -> new Tuple2((Object)field.name(), (Object)field.dataType()), Seq$.MODULE$.canBuildFrom()));
                Seq $org_scalatest_assert_macro_right = (Seq)new .colon.colon((Object)new Tuple2((Object)"info_name", (Object)StringType$.MODULE$), (List)new .colon.colon((Object)new Tuple2((Object)"info_value", (Object)StringType$.MODULE$), (List)Nil$.MODULE$));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(df1.collect());
                Seq $org_scalatest_assert_macro_right2 = (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"col_name", "id"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"data_type", "bigint"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"comment", "NULL"})), (List)Nil$.MODULE$)));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
                Dataset df2 = (Dataset)this.sql().apply((Object)new StringBuilder(14).append("DESCRIBE ").append(t).append(" data").toString());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(df2.schema().map((Function1 & Serializable & scala.Serializable)field -> new Tuple2((Object)field.name(), (Object)field.dataType()), Seq$.MODULE$.canBuildFrom()));
                Seq $org_scalatest_assert_macro_right3 = (Seq)new .colon.colon((Object)new Tuple2((Object)"info_name", (Object)StringType$.MODULE$), (List)new .colon.colon((Object)new Tuple2((Object)"info_value", (Object)StringType$.MODULE$), (List)Nil$.MODULE$));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(df2.collect());
                Seq $org_scalatest_assert_macro_right4 = (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"col_name", "data"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"data_type", "string"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"comment", "hello"})), (List)Nil$.MODULE$)));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
                this.checkError((SparkThrowable)this.analysisException(new StringBuilder(21).append("DESCRIBE ").append(t).append(" invalid_col").toString()), "UNRESOLVED_COLUMN.WITH_SUGGESTION", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"objectName"), (Object)"`invalid_col`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"proposal"), (Object)"`id`, `data`")})), (QueryContext)this.ExpectedContext().apply("DESCRIBE testcat.tbl invalid_col", 0, 31));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
        this.test("Describe column for v2 catalog should work with qualified columns", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testcat.ns.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(35).append("CREATE TABLE ").append(t).append(" (id bigint) USING foo").toString());
                ((IterableLike)new .colon.colon((Object)"testcat.ns.tbl.id", (List)new .colon.colon((Object)"ns.tbl.id", (List)new .colon.colon((Object)"tbl.id", (List)new .colon.colon((Object)"id", (List)Nil$.MODULE$))))).foreach((Function1 & Serializable & scala.Serializable)col -> {
                    Dataset df = (Dataset)this.sql().apply((Object)new StringBuilder(10).append("DESCRIBE ").append(t).append(" ").append((String)col).toString());
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(df.schema().map((Function1 & Serializable & scala.Serializable)field -> new Tuple2((Object)field.name(), (Object)field.dataType()), Seq$.MODULE$.canBuildFrom()));
                    Seq $org_scalatest_assert_macro_right = (Seq)new .colon.colon((Object)new Tuple2((Object)"info_name", (Object)StringType$.MODULE$), (List)new .colon.colon((Object)new Tuple2((Object)"info_value", (Object)StringType$.MODULE$), (List)Nil$.MODULE$));
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(df.collect());
                    Seq $org_scalatest_assert_macro_right2 = (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"col_name", "id"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"data_type", "bigint"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"comment", "NULL"})), (List)Nil$.MODULE$)));
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
                });
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
        this.test("Describing nested column for v2 catalog is not supported", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testcat.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(50).append("CREATE TABLE ").append(t).append(" (d struct<a: INT, b: INT>) USING foo").toString());
                AnalysisException x$6 = this.analysisException(new StringBuilder(13).append("describe ").append(t).append(" d.a").toString());
                String x$7 = "_LEGACY_ERROR_TEMP_1060";
                scala.collection.immutable.Map x$8 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"command"), (Object)"DESC TABLE COLUMN"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"column"), (Object)"d.a")}));
                Option x$9 = this.checkError$default$3();
                boolean x$10 = this.checkError$default$5();
                QueryContext[] x$11 = this.checkError$default$6();
                this.checkError((SparkThrowable)x$6, x$7, x$9, x$8, x$10, x$11);
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
        this.test("SPARK-33004: Describe column should resolve to a temporary view first", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"testcat.ns.t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE testcat.ns.t (id bigint) USING foo");
            this.sql().apply((Object)"CREATE TEMPORARY VIEW t AS SELECT 2 as i");
            this.sql().apply((Object)"USE testcat.ns");
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"DESCRIBE t i"), (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"col_name", "i"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"data_type", "int"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"comment", "NULL"})), (List)Nil$.MODULE$)))));
        })), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
        this.test("CreateTable: use v2 plan and session catalog when provider is v2", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringBuilder(55).append("CREATE TABLE table_name (id bigint, data string) USING ").append(this.v2Source()).toString());
            TableCatalog testCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog(CatalogManager$.MODULE$.SESSION_CATALOG_NAME())).asTableCatalog();
            Table table = testCatalog.loadTable(Identifier.of((String[])((String[])((Object[])new String[]{"default"})), (String)"table_name"));
            String $org_scalatest_assert_macro_left = table.name();
            String $org_scalatest_assert_macro_right = "default.table_name";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
            Object[] $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])table.partitioning());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left2), "isEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left2).isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
            java.util.Map $org_scalatest_assert_macro_left3 = table.properties();
            java.util.Map $org_scalatest_assert_macro_right2 = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)this.v2Source())})))).asJava();
            java.util.Map map = $org_scalatest_assert_macro_left3;
            java.util.Map map2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
            StructType $org_scalatest_assert_macro_left4 = table.schema();
            StructType $org_scalatest_assert_macro_right3 = new StructType().add("id", (DataType)LongType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
            StructType structType = $org_scalatest_assert_macro_left4;
            StructType structType2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
            SparkContext qual$3 = this.spark().sparkContext();
            Seq x$12 = ((InMemoryTable)table).rows();
            int x$13 = qual$3.parallelize$default$2();
            RDD rdd = qual$3.parallelize(x$12, x$13, ClassTag$.MODULE$.apply(InternalRow.class));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> {
                SparkSession qual$4 = this.spark();
                RDD x$14 = rdd;
                StructType x$15 = table.schema();
                boolean x$16 = qual$4.internalCreateDataFrame$default$3();
                return qual$4.internalCreateDataFrame(x$14, x$15, x$16);
            }, (Seq<Row>)((Seq)Nil$.MODULE$));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
        this.test("CreateTable: fail if table exists", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql("CREATE TABLE testcat.table_name (id bigint, data string) USING foo");
            TableCatalog testCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            Table table = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            String $org_scalatest_assert_macro_left = table.name();
            String $org_scalatest_assert_macro_right = "testcat.table_name";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 208));
            Object[] $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])table.partitioning());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left2), "isEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left2).isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
            java.util.Map $org_scalatest_assert_macro_left3 = table.properties();
            java.util.Map $org_scalatest_assert_macro_right2 = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)"foo")})))).asJava();
            java.util.Map map = $org_scalatest_assert_macro_left3;
            java.util.Map map2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210));
            StructType $org_scalatest_assert_macro_left4 = table.schema();
            StructType $org_scalatest_assert_macro_right3 = new StructType().add("id", (DataType)LongType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
            StructType structType = $org_scalatest_assert_macro_left4;
            StructType structType2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211));
            TableAlreadyExistsException x$17 = (TableAlreadyExistsException)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.spark().sql("CREATE TABLE testcat.table_name (id bigint, data string, id2 bigint) USING bar"), ClassTag$.MODULE$.apply(TableAlreadyExistsException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 215));
            String x$18 = "TABLE_OR_VIEW_ALREADY_EXISTS";
            scala.collection.immutable.Map x$19 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationName"), (Object)"`table_name`")}));
            Option x$20 = this.checkError$default$3();
            boolean x$21 = this.checkError$default$5();
            QueryContext[] x$22 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$17, x$18, x$20, x$19, x$21, x$22);
            Table table2 = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            String $org_scalatest_assert_macro_left5 = table2.name();
            String $org_scalatest_assert_macro_right4 = "testcat.table_name";
            String string3 = $org_scalatest_assert_macro_left5;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 224));
            Object[] $org_scalatest_assert_macro_left6 = Predef$.MODULE$.refArrayOps((Object[])table2.partitioning());
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left6), "isEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left6).isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 225));
            java.util.Map $org_scalatest_assert_macro_left7 = table2.properties();
            java.util.Map $org_scalatest_assert_macro_right5 = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)"foo")})))).asJava();
            java.util.Map map3 = $org_scalatest_assert_macro_left7;
            java.util.Map map4 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right5, !(map3 != null ? !((Object)map3).equals(map4) : map4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 226));
            StructType $org_scalatest_assert_macro_left8 = table2.schema();
            StructType $org_scalatest_assert_macro_right6 = new StructType().add("id", (DataType)LongType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
            StructType structType3 = $org_scalatest_assert_macro_left8;
            StructType structType4 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right6, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 227));
            SparkContext qual$5 = this.spark().sparkContext();
            Seq x$23 = ((InMemoryTable)table).rows();
            int x$24 = qual$5.parallelize$default$2();
            RDD rdd = qual$5.parallelize(x$23, x$24, ClassTag$.MODULE$.apply(InternalRow.class));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> {
                SparkSession qual$6 = this.spark();
                RDD x$25 = rdd;
                StructType x$26 = table.schema();
                boolean x$27 = qual$6.internalCreateDataFrame$default$3();
                return qual$6.internalCreateDataFrame(x$25, x$26, x$27);
            }, (Seq<Row>)((Seq)Nil$.MODULE$));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
        this.test("CreateTable: if not exists", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql("CREATE TABLE IF NOT EXISTS testcat.table_name (id bigint, data string) USING foo");
            TableCatalog testCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            Table table = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            String $org_scalatest_assert_macro_left = table.name();
            String $org_scalatest_assert_macro_right = "testcat.table_name";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241));
            Object[] $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])table.partitioning());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left2), "isEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left2).isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
            java.util.Map $org_scalatest_assert_macro_left3 = table.properties();
            java.util.Map $org_scalatest_assert_macro_right2 = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)"foo")})))).asJava();
            java.util.Map map = $org_scalatest_assert_macro_left3;
            java.util.Map map2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 243));
            StructType $org_scalatest_assert_macro_left4 = table.schema();
            StructType $org_scalatest_assert_macro_right3 = new StructType().add("id", (DataType)LongType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
            StructType structType = $org_scalatest_assert_macro_left4;
            StructType structType2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 244));
            this.spark().sql("CREATE TABLE IF NOT EXISTS testcat.table_name (id bigint, data string) USING bar");
            Table table2 = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            String $org_scalatest_assert_macro_left5 = table2.name();
            String $org_scalatest_assert_macro_right4 = "testcat.table_name";
            String string3 = $org_scalatest_assert_macro_left5;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 250));
            Object[] $org_scalatest_assert_macro_left6 = Predef$.MODULE$.refArrayOps((Object[])table2.partitioning());
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left6), "isEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left6).isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 251));
            java.util.Map $org_scalatest_assert_macro_left7 = table2.properties();
            java.util.Map $org_scalatest_assert_macro_right5 = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)"foo")})))).asJava();
            java.util.Map map3 = $org_scalatest_assert_macro_left7;
            java.util.Map map4 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right5, !(map3 != null ? !((Object)map3).equals(map4) : map4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 252));
            StructType $org_scalatest_assert_macro_left8 = table2.schema();
            StructType $org_scalatest_assert_macro_right6 = new StructType().add("id", (DataType)LongType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
            StructType structType3 = $org_scalatest_assert_macro_left8;
            StructType structType4 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right6, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 253));
            SparkContext qual$7 = this.spark().sparkContext();
            Seq x$28 = ((InMemoryTable)table).rows();
            int x$29 = qual$7.parallelize$default$2();
            RDD rdd2 = qual$7.parallelize(x$28, x$29, ClassTag$.MODULE$.apply(InternalRow.class));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> {
                SparkSession qual$8 = this.spark();
                RDD x$30 = rdd2;
                StructType x$31 = table.schema();
                boolean x$32 = qual$8.internalCreateDataFrame$default$3();
                return qual$8.internalCreateDataFrame(x$30, x$31, x$32);
            }, (Seq<Row>)((Seq)Nil$.MODULE$));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234));
        this.test("CreateTable: use default catalog for v2 sources when default catalog is set", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().conf().set(SQLConf$.MODULE$.DEFAULT_CATALOG().key(), "testcat");
            this.spark().sql("CREATE TABLE table_name (id bigint, data string) USING foo");
            TableCatalog testCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            Table table = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            String $org_scalatest_assert_macro_left = table.name();
            String $org_scalatest_assert_macro_right = "testcat.table_name";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 267));
            Object[] $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])table.partitioning());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left2), "isEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left2).isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 268));
            java.util.Map $org_scalatest_assert_macro_left3 = table.properties();
            java.util.Map $org_scalatest_assert_macro_right2 = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)"foo")})))).asJava();
            java.util.Map map = $org_scalatest_assert_macro_left3;
            java.util.Map map2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 269));
            StructType $org_scalatest_assert_macro_left4 = table.schema();
            StructType $org_scalatest_assert_macro_right3 = new StructType().add("id", (DataType)LongType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
            StructType structType = $org_scalatest_assert_macro_left4;
            StructType structType2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
            SparkContext qual$9 = this.spark().sparkContext();
            Seq x$33 = ((InMemoryTable)table).rows();
            int x$34 = qual$9.parallelize$default$2();
            RDD rdd = qual$9.parallelize(x$33, x$34, ClassTag$.MODULE$.apply(InternalRow.class));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> {
                SparkSession qual$10 = this.spark();
                RDD x$35 = rdd;
                StructType x$36 = table.schema();
                boolean x$37 = qual$10.internalCreateDataFrame$default$3();
                return qual$10.internalCreateDataFrame(x$35, x$36, x$37);
            }, (Seq<Row>)((Seq)Nil$.MODULE$));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 260));
        this.test("CreateTable: without USING clause", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_CREATE_HIVE_TABLE_BY_DEFAULT().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().conf().unset(SQLConf$.MODULE$.V2_SESSION_CATALOG_IMPLEMENTATION().key());
            TableCatalog testCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            this.sql().apply((Object)"CREATE TABLE testcat.t1 (id int)");
            Table t1 = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"t1"));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(t1.properties().containsKey("provider"), "t1.properties().containsKey(\"provider\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 286));
            this.sql().apply((Object)"CREATE TABLE t2 (id int)");
            V1Table t2 = (V1Table)CatalogV2Implicits$.MODULE$.CatalogHelper(this.spark().sessionState().catalogManager().v2SessionCatalog()).asTableCatalog().loadTable(Identifier.of((String[])((String[])((Object[])new String[]{"default"})), (String)"t2"));
            Option $org_scalatest_assert_macro_left = t2.v1Table().provider();
            Some $org_scalatest_assert_macro_right = new Some((Object)this.conf().defaultDataSourceName());
            Option option = $org_scalatest_assert_macro_left;
            Some some = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 292));
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 277));
        this.test("CreateTable/ReplaceTable: invalid schema if has interval type", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"CREATE", (List)new .colon.colon((Object)"REPLACE", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)action -> {
            DataSourceV2SQLSuiteV1Filter.$anonfun$new$29(this, action);
            return BoxedUnit.UNIT;
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 296));
        this.test("CTAS/RTAS: invalid schema if has interval type", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_INTERVAL_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"CREATE", (List)new .colon.colon((Object)"REPLACE", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)action -> {
            DataSourceV2SQLSuiteV1Filter.$anonfun$new$34(this, action);
            return BoxedUnit.UNIT;
        })), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314));
        this.test("CreateTableAsSelect: use v2 plan because catalog is set", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TableCatalog basicCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            TableCatalog atomicCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat_atomic")).asTableCatalog();
            String basicIdentifier = "testcat.table_name";
            String atomicIdentifier = "testcat_atomic.table_name";
            ((IterableLike)new .colon.colon((Object)new Tuple2((Object)basicCatalog, (Object)basicIdentifier), (List)new .colon.colon((Object)new Tuple2((Object)atomicCatalog, (Object)atomicIdentifier), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                DataSourceV2SQLSuiteV1Filter.$anonfun$new$38(this, x0$1);
                return BoxedUnit.UNIT;
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 334));
        this.test("CreateTableAsSelect: do not double execute on collect(), take() and other queries", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TableCatalog basicCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            TableCatalog atomicCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat_atomic")).asTableCatalog();
            String basicIdentifier = "testcat.table_name";
            String atomicIdentifier = "testcat_atomic.table_name";
            ((IterableLike)new .colon.colon((Object)new Tuple2((Object)basicCatalog, (Object)basicIdentifier), (List)new .colon.colon((Object)new Tuple2((Object)atomicCatalog, (Object)atomicIdentifier), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                DataSourceV2SQLSuiteV1Filter.$anonfun$new$41(this, x0$2);
                return BoxedUnit.UNIT;
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 358));
        this.test("SPARK-36850: CreateTableAsSelect partitions can be specified using PARTITIONED BY and/or CLUSTERED BY", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String identifier = "testcat.table_name";
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuiteV1Filter.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))))));
                }

                public Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator1$1(DataSourceV2SQLSuiteV1Filter $outer) {
                }
            }
            Dataset df = this.spark().createDataFrame((Seq)new .colon.colon((Object)new Tuple5((Object)BoxesRunTime.boxToLong((long)1L), (Object)"a", (Object)"a1", (Object)"a2", (Object)"a3"), (List)new .colon.colon((Object)new Tuple5((Object)BoxesRunTime.boxToLong((long)2L), (Object)"b", (Object)"b1", (Object)"b2", (Object)"b3"), (List)new .colon.colon((Object)new Tuple5((Object)BoxesRunTime.boxToLong((long)3L), (Object)"c", (Object)"c1", (Object)"c2", (Object)"c3"), (List)Nil$.MODULE$))), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator1$1(null))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data1", "data2", "data3", "data4"}));
            df.createOrReplaceTempView("source_table");
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{identifier}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.spark().sql(new StringBuilder(130).append("CREATE TABLE ").append(identifier).append(" USING foo PARTITIONED BY (id) ").append("CLUSTERED BY (data1, data2, data3, data4) INTO 4 BUCKETS AS SELECT * FROM source_table").toString());
                Dataset describe = this.spark().sql(new StringBuilder(9).append("DESCRIBE ").append(identifier).toString());
                String part1 = ((Row)describe.filter("col_name = 'Part 0'").select("data_type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).head()).getString(0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(part1);
                String $org_scalatest_assert_macro_right = "id";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 402));
                String part2 = ((Row)describe.filter("col_name = 'Part 1'").select("data_type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).head()).getString(0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(part2);
                String $org_scalatest_assert_macro_right2 = "bucket(4, data1, data2, data3, data4)";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 406));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 390));
        this.test("SPARK-36850: ReplaceTableAsSelect partitions can be specified using PARTITIONED BY and/or CLUSTERED BY", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String identifier = "testcat.table_name";
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuiteV1Filter.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator2$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))))));
                }

                public Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator2$1(DataSourceV2SQLSuiteV1Filter $outer) {
                }
            }
            Dataset df = this.spark().createDataFrame((Seq)new .colon.colon((Object)new Tuple5((Object)BoxesRunTime.boxToLong((long)1L), (Object)"a", (Object)"a1", (Object)"a2", (Object)"a3"), (List)new .colon.colon((Object)new Tuple5((Object)BoxesRunTime.boxToLong((long)2L), (Object)"b", (Object)"b1", (Object)"b2", (Object)"b3"), (List)new .colon.colon((Object)new Tuple5((Object)BoxesRunTime.boxToLong((long)3L), (Object)"c", (Object)"c1", (Object)"c2", (Object)"c3"), (List)Nil$.MODULE$))), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator2$1(null))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data1", "data2", "data3", "data4"}));
            df.createOrReplaceTempView("source_table");
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{identifier}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.spark().sql(new StringBuilder(48).append("CREATE TABLE ").append(identifier).append(" USING foo ").append("AS SELECT id FROM source").toString());
                this.spark().sql(new StringBuilder(142).append("REPLACE TABLE ").append(identifier).append(" USING foo PARTITIONED BY (id) ").append("CLUSTERED BY (data1, data2) SORTED by (data3, data4) INTO 4 BUCKETS ").append("AS SELECT * FROM source_table").toString());
                Dataset describe = this.spark().sql(new StringBuilder(9).append("DESCRIBE ").append(identifier).toString());
                String part1 = ((Row)describe.filter("col_name = 'Part 0'").select("data_type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).head()).getString(0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(part1);
                String $org_scalatest_assert_macro_right = "id";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 426));
                String part2 = ((Row)describe.filter("col_name = 'Part 1'").select("data_type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).head()).getString(0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(part2);
                String $org_scalatest_assert_macro_right2 = "sorted_bucket(data1, data2, 4, data3, data4)";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 430));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 411));
        this.test("SPARK-37545: CreateTableAsSelect should store location as qualified", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String basicIdentifier = "testcat.table_name";
            String atomicIdentifier = "testcat_atomic.table_name";
            ((IterableLike)new .colon.colon((Object)basicIdentifier, (List)new .colon.colon((Object)atomicIdentifier, (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)identifier -> {
                this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{identifier}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    $this.spark().sql(new StringBuilder(68).append("CREATE TABLE ").append(identifier).append(" USING foo LOCATION '/tmp/foo' ").append("AS SELECT id FROM source").toString());
                    String location = ((Row)$this.spark().sql(new StringBuilder(18).append("DESCRIBE EXTENDED ").append(identifier).toString()).filter("col_name = 'Location'").select("data_type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).head()).getString(0);
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(location);
                    String $org_scalatest_assert_macro_right = "file:/tmp/foo";
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 444));
                });
                return BoxedUnit.UNIT;
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 434));
        this.test("SPARK-37546: ReplaceTableAsSelect should store location as qualified", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String basicIdentifier = "testcat.table_name";
            String atomicIdentifier = "testcat_atomic.table_name";
            ((IterableLike)new .colon.colon((Object)basicIdentifier, (List)new .colon.colon((Object)atomicIdentifier, (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)identifier -> {
                this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{identifier}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    $this.spark().sql(new StringBuilder(74).append("CREATE TABLE ").append(identifier).append(" USING foo LOCATION '/tmp/foo' ").append("AS SELECT id, data FROM source").toString());
                    $this.spark().sql(new StringBuilder(69).append("REPLACE TABLE ").append(identifier).append(" USING foo LOCATION '/tmp/foo' ").append("AS SELECT id FROM source").toString());
                    String location = ((Row)$this.spark().sql(new StringBuilder(18).append("DESCRIBE EXTENDED ").append(identifier).toString()).filter("col_name = 'Location'").select("data_type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).head()).getString(0);
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(location);
                    String $org_scalatest_assert_macro_right = "file:/tmp/foo";
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 461));
                });
                return BoxedUnit.UNIT;
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 449));
        this.test("ReplaceTableAsSelect: basic v2 implementation.", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TableCatalog basicCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            TableCatalog atomicCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat_atomic")).asTableCatalog();
            String basicIdentifier = "testcat.table_name";
            String atomicIdentifier = "testcat_atomic.table_name";
            ((IterableLike)new .colon.colon((Object)new Tuple2((Object)basicCatalog, (Object)basicIdentifier), (List)new .colon.colon((Object)new Tuple2((Object)atomicCatalog, (Object)atomicIdentifier), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                DataSourceV2SQLSuiteV1Filter.$anonfun$new$54(this, x0$3);
                return BoxedUnit.UNIT;
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 466));
        ((IterableLike)new .colon.colon((Object)"REPLACE", (List)new .colon.colon((Object)"CREATE OR REPLACE", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)cmd -> {
            this.test(new StringBuilder(57).append("ReplaceTableAsSelect: do not double execute ").append(cmd).append(" on collect()").toString(), (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                TableCatalog basicCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper($this.catalog("testcat")).asTableCatalog();
                TableCatalog atomicCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper($this.catalog("testcat_atomic")).asTableCatalog();
                String basicIdentifier = "testcat.table_name";
                String atomicIdentifier = "testcat_atomic.table_name";
                ((IterableLike)new .colon.colon((Object)new Tuple2((Object)basicCatalog, (Object)basicIdentifier), (List)new .colon.colon((Object)new Tuple2((Object)atomicCatalog, (Object)atomicIdentifier), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
                    DataSourceV2SQLSuiteV1Filter.$anonfun$new$58($this, cmd, x0$4);
                    return BoxedUnit.UNIT;
                });
            }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 494));
            return BoxedUnit.UNIT;
        });
        this.test("ReplaceTableAsSelect: Non-atomic catalog drops the table if the write fails.", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            this.spark().sql("CREATE TABLE testcat.table_name USING foo AS SELECT id, data FROM source");
            TableCatalog testCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            Table table = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            Seq $org_scalatest_assert_macro_left = ((InMemoryTable)table).rows();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 534));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> this.spark().sql(new StringBuilder(91).append("REPLACE TABLE testcat.table_name").append(" USING foo TBLPROPERTIES (`").append(InMemoryBaseTable$.MODULE$.SIMULATE_FAILED_WRITE_OPTION()).append("`=true)").append(" AS SELECT id FROM source").toString()), ClassTag$.MODULE$.apply(Exception.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 536));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(testCatalog.tableExists(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name")), "testCatalog.tableExists(org.apache.spark.sql.connector.catalog.Identifier.of(scala.Array.apply[String]()((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String])), \"table_name\"))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Table should have been dropped as a result of the replace.", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 542));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 530));
        this.test("ReplaceTableAsSelect: Non-atomic catalog drops the table permanently if the subsequent table creation fails.", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            this.spark().sql("CREATE TABLE testcat.table_name USING foo AS SELECT id, data FROM source");
            TableCatalog testCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            Table table = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            Seq $org_scalatest_assert_macro_left = ((InMemoryTable)table).rows();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 551));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> this.spark().sql(new StringBuilder(91).append("REPLACE TABLE testcat.table_name").append(" USING foo").append(" TBLPROPERTIES (`").append(InMemoryTableCatalog$.MODULE$.SIMULATE_FAILED_CREATE_PROPERTY()).append("`=true)").append(" AS SELECT id FROM source").toString()), ClassTag$.MODULE$.apply(Exception.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 553));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(testCatalog.tableExists(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name")), "testCatalog.tableExists(org.apache.spark.sql.connector.catalog.Identifier.of(scala.Array.apply[String]()((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String])), \"table_name\"))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Table should have been dropped and failed to be created.", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 560));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 547));
        this.test("ReplaceTableAsSelect: Atomic catalog does not drop the table when replace fails.", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            this.spark().sql("CREATE TABLE testcat_atomic.table_name USING foo AS SELECT id, data FROM source");
            TableCatalog testCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat_atomic")).asTableCatalog();
            Table table = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> this.spark().sql(new StringBuilder(97).append("REPLACE TABLE testcat_atomic.table_name").append(" USING foo TBLPROPERTIES (`").append(InMemoryBaseTable$.MODULE$.SIMULATE_FAILED_WRITE_OPTION()).append("=true)").append(" AS SELECT id FROM source").toString()), ClassTag$.MODULE$.apply(Exception.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 569));
            Table maybeReplacedTable = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(maybeReplacedTable);
            Table $org_scalatest_assert_macro_right = table;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Table should not have changed.", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 576));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> this.spark().sql(new StringBuilder(98).append("REPLACE TABLE testcat_atomic.table_name").append(" USING foo").append(" TBLPROPERTIES (`").append(InMemoryTableCatalog$.MODULE$.SIMULATE_FAILED_CREATE_PROPERTY()).append("`=true)").append(" AS SELECT id FROM source").toString()), ClassTag$.MODULE$.apply(Exception.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 578));
            maybeReplacedTable = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(maybeReplacedTable);
            Table $org_scalatest_assert_macro_right2 = table;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Table should not have changed.", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 586));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 564));
        this.test("ReplaceTable: Erases the table contents and changes the metadata", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringBuilder(69).append("CREATE TABLE testcat.table_name USING ").append(this.v2Source()).append(" AS SELECT id, data FROM source").toString());
            TableCatalog testCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            Table table = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            Seq $org_scalatest_assert_macro_left = ((InMemoryTable)table).rows();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 594));
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.DEFAULT_COLUMN_ALLOWED_PROVIDERS().key()), (Object)"foo")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.spark().sql("REPLACE TABLE testcat.table_name (id bigint NOT NULL DEFAULT 41 + 1) USING foo");
                Table replaced = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
                Seq $org_scalatest_assert_macro_left = ((InMemoryTable)replaced).rows();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Replaced table should have no rows after committing.", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 600));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)replaced.columns().length));
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Replaced table should have new schema.", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 602));
                Column actual = (Column)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])replaced.columns())).head();
                Column expected = Column.create((String)"id", (DataType)LongType$.MODULE$, (boolean)false, null, (ColumnDefaultValue)new ColumnDefaultValue("41 + 1", (Literal)new LiteralValue((Object)BoxesRunTime.boxToLong((long)42L), (DataType)LongType$.MODULE$)), null);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(actual);
                Column $org_scalatest_assert_macro_right2 = expected;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"Replaced table should have new schema with DEFAULT column metadata.", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 607));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 589));
        this.test("ReplaceTableAsSelect: CREATE OR REPLACE new table has same behavior as CTAS.", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"testcat", (List)new .colon.colon((Object)"testcat_atomic", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)catalogName -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(94).append("\n           |CREATE TABLE ").append((String)catalogName).append(".created USING ").append(this.v2Source()).append("\n           |AS SELECT id, data FROM source\n         ").toString())).stripMargin());
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(106).append("\n           |CREATE OR REPLACE TABLE ").append((String)catalogName).append(".replaced USING ").append(this.v2Source()).append("\n           |AS SELECT id, data FROM source\n         ").toString())).stripMargin());
            TableCatalog testCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog((String)catalogName)).asTableCatalog();
            Table createdTable = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"created"));
            Table replacedTable = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"replaced"));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(((InMemoryTable)createdTable).rows());
            Seq $org_scalatest_assert_macro_right = ((InMemoryTable)replacedTable).rows();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 629));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(createdTable.schema());
            StructType $org_scalatest_assert_macro_right2 = replacedTable.schema();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 631));
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 612));
        this.test("ReplaceTableAsSelect: REPLACE TABLE throws exception if table does not exist.", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"testcat", (List)new .colon.colon((Object)"testcat_atomic", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)catalog -> {
            DataSourceV2SQLSuiteV1Filter.$anonfun$new$72(this, catalog);
            return BoxedUnit.UNIT;
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 635));
        this.test("ReplaceTableAsSelect: REPLACE TABLE throws exception if table is dropped before commit.", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringBuilder(73).append("CREATE TABLE testcat_atomic.created USING ").append(this.v2Source()).append(" AS SELECT id, data FROM source").toString());
            CannotReplaceMissingTableException x$88 = (CannotReplaceMissingTableException)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.spark().sql(new StringBuilder(99).append("REPLACE TABLE testcat_atomic.replaced").append(" USING ").append(this.v2Source()).append(" TBLPROPERTIES (`").append(InMemoryTableCatalog$.MODULE$.SIMULATE_DROP_BEFORE_REPLACE_PROPERTY()).append("`=true)").append(" AS SELECT id, data FROM source").toString()), ClassTag$.MODULE$.apply(CannotReplaceMissingTableException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 652));
            String x$89 = "TABLE_OR_VIEW_NOT_FOUND";
            scala.collection.immutable.Map x$90 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationName"), (Object)"`replaced`")}));
            Option x$91 = this.checkError$default$3();
            boolean x$92 = this.checkError$default$5();
            QueryContext[] x$93 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$88, x$89, x$91, x$90, x$92, x$93);
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 648));
        this.test("CreateTableAsSelect: use v2 plan and session catalog when provider is v2", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringBuilder(61).append("CREATE TABLE table_name USING ").append(this.v2Source()).append(" AS SELECT id, data FROM source").toString());
            TableCatalog testCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog(CatalogManager$.MODULE$.SESSION_CATALOG_NAME())).asTableCatalog();
            Table table = testCatalog.loadTable(Identifier.of((String[])((String[])((Object[])new String[]{"default"})), (String)"table_name"));
            String $org_scalatest_assert_macro_left = table.name();
            String $org_scalatest_assert_macro_right = "default.table_name";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 668));
            Object[] $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])table.partitioning());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left2), "isEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left2).isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 669));
            java.util.Map $org_scalatest_assert_macro_left3 = table.properties();
            java.util.Map $org_scalatest_assert_macro_right2 = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)this.v2Source())})))).asJava();
            java.util.Map map = $org_scalatest_assert_macro_left3;
            java.util.Map map2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 670));
            StructType $org_scalatest_assert_macro_left4 = table.schema();
            StructType $org_scalatest_assert_macro_right3 = new StructType().add("id", (DataType)LongType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
            StructType structType = $org_scalatest_assert_macro_left4;
            StructType structType2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 671));
            SparkContext qual$19 = this.spark().sparkContext();
            Seq x$94 = ((InMemoryTable)table).rows();
            int x$95 = qual$19.parallelize$default$2();
            RDD rdd = qual$19.parallelize(x$94, x$95, ClassTag$.MODULE$.apply(InternalRow.class));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> {
                SparkSession qual$20 = this.spark();
                RDD x$96 = rdd;
                StructType x$97 = table.schema();
                boolean x$98 = qual$20.internalCreateDataFrame$default$3();
                return qual$20.internalCreateDataFrame(x$96, x$97, x$98);
            }, (Dataset<Row>)this.spark().table("source"));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 662));
        this.test("CreateTableAsSelect: fail if table exists", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql("CREATE TABLE testcat.table_name USING foo AS SELECT id, data FROM source");
            TableCatalog testCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            Table table = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            String $org_scalatest_assert_macro_left = table.name();
            String $org_scalatest_assert_macro_right = "testcat.table_name";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 685));
            Object[] $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])table.partitioning());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left2), "isEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left2).isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 686));
            java.util.Map $org_scalatest_assert_macro_left3 = table.properties();
            java.util.Map $org_scalatest_assert_macro_right2 = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)"foo")})))).asJava();
            java.util.Map map = $org_scalatest_assert_macro_left3;
            java.util.Map map2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 687));
            StructType $org_scalatest_assert_macro_left4 = table.schema();
            StructType $org_scalatest_assert_macro_right3 = new StructType().add("id", (DataType)LongType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
            StructType structType = $org_scalatest_assert_macro_left4;
            StructType structType2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 688));
            SparkContext qual$21 = this.spark().sparkContext();
            Seq x$99 = ((InMemoryTable)table).rows();
            int x$100 = qual$21.parallelize$default$2();
            RDD rdd = qual$21.parallelize(x$99, x$100, ClassTag$.MODULE$.apply(InternalRow.class));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> {
                SparkSession qual$22 = this.spark();
                RDD x$101 = rdd;
                StructType x$102 = table.schema();
                boolean x$103 = qual$22.internalCreateDataFrame$default$3();
                return qual$22.internalCreateDataFrame(x$101, x$102, x$103);
            }, (Dataset<Row>)this.spark().table("source"));
            TableAlreadyExistsException x$104 = (TableAlreadyExistsException)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.spark().sql("CREATE TABLE testcat.table_name USING bar AS SELECT id, data, id as id2 FROM source2"), ClassTag$.MODULE$.apply(TableAlreadyExistsException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 697));
            String x$105 = "TABLE_OR_VIEW_ALREADY_EXISTS";
            scala.collection.immutable.Map x$106 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationName"), (Object)"`table_name`")}));
            Option x$107 = this.checkError$default$3();
            boolean x$108 = this.checkError$default$5();
            QueryContext[] x$109 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$104, x$105, x$107, x$106, x$108, x$109);
            Table table2 = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            String $org_scalatest_assert_macro_left5 = table2.name();
            String $org_scalatest_assert_macro_right4 = "testcat.table_name";
            String string3 = $org_scalatest_assert_macro_left5;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 706));
            Object[] $org_scalatest_assert_macro_left6 = Predef$.MODULE$.refArrayOps((Object[])table2.partitioning());
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left6), "isEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left6).isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 707));
            java.util.Map $org_scalatest_assert_macro_left7 = table2.properties();
            java.util.Map $org_scalatest_assert_macro_right5 = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)"foo")})))).asJava();
            java.util.Map map3 = $org_scalatest_assert_macro_left7;
            java.util.Map map4 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right5, !(map3 != null ? !((Object)map3).equals(map4) : map4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 708));
            StructType $org_scalatest_assert_macro_left8 = table2.schema();
            StructType $org_scalatest_assert_macro_right6 = new StructType().add("id", (DataType)LongType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
            StructType structType3 = $org_scalatest_assert_macro_left8;
            StructType structType4 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right6, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 709));
            SparkContext qual$23 = this.spark().sparkContext();
            Seq x$110 = ((InMemoryTable)table).rows();
            int x$111 = qual$23.parallelize$default$2();
            RDD rdd2 = qual$23.parallelize(x$110, x$111, ClassTag$.MODULE$.apply(InternalRow.class));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> {
                SparkSession qual$24 = this.spark();
                RDD x$112 = rdd2;
                StructType x$113 = table.schema();
                boolean x$114 = qual$24.internalCreateDataFrame$default$3();
                return qual$24.internalCreateDataFrame(x$112, x$113, x$114);
            }, (Dataset<Row>)this.spark().table("source"));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 679));
        this.test("CreateTableAsSelect: if not exists", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql("CREATE TABLE IF NOT EXISTS testcat.table_name USING foo AS SELECT id, data FROM source");
            TableCatalog testCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            Table table = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            String $org_scalatest_assert_macro_left = table.name();
            String $org_scalatest_assert_macro_right = "testcat.table_name";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 724));
            Object[] $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])table.partitioning());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left2), "isEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left2).isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 725));
            java.util.Map $org_scalatest_assert_macro_left3 = table.properties();
            java.util.Map $org_scalatest_assert_macro_right2 = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)"foo")})))).asJava();
            java.util.Map map = $org_scalatest_assert_macro_left3;
            java.util.Map map2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 726));
            StructType $org_scalatest_assert_macro_left4 = table.schema();
            StructType $org_scalatest_assert_macro_right3 = new StructType().add("id", (DataType)LongType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
            StructType structType = $org_scalatest_assert_macro_left4;
            StructType structType2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 727));
            SparkContext qual$25 = this.spark().sparkContext();
            Seq x$115 = ((InMemoryTable)table).rows();
            int x$116 = qual$25.parallelize$default$2();
            RDD rdd = qual$25.parallelize(x$115, x$116, ClassTag$.MODULE$.apply(InternalRow.class));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> {
                SparkSession qual$26 = this.spark();
                RDD x$117 = rdd;
                StructType x$118 = table.schema();
                boolean x$119 = qual$26.internalCreateDataFrame$default$3();
                return qual$26.internalCreateDataFrame(x$117, x$118, x$119);
            }, (Dataset<Row>)this.spark().table("source"));
            this.spark().sql("CREATE TABLE IF NOT EXISTS testcat.table_name USING foo AS SELECT id, data FROM source2");
            SparkContext qual$27 = this.spark().sparkContext();
            Seq x$120 = ((InMemoryTable)table).rows();
            int x$121 = qual$27.parallelize$default$2();
            RDD rdd2 = qual$27.parallelize(x$120, x$121, ClassTag$.MODULE$.apply(InternalRow.class));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> {
                SparkSession qual$28 = this.spark();
                RDD x$122 = rdd2;
                StructType x$123 = table.schema();
                boolean x$124 = qual$28.internalCreateDataFrame$default$3();
                return qual$28.internalCreateDataFrame(x$122, x$123, x$124);
            }, (Dataset<Row>)this.spark().table("source"));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 717));
        this.test("CreateTableAsSelect: use default catalog for v2 sources when default catalog is set", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().conf().set(SQLConf$.MODULE$.DEFAULT_CATALOG().key(), "testcat");
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuiteV1Filter.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator3$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator3$1(DataSourceV2SQLSuiteV1Filter $outer) {
                }
            }
            Dataset df = this.spark().createDataFrame((Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)"a"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)2L), (Object)"b"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)3L), (Object)"c"), (List)Nil$.MODULE$))), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator3$1(null))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data"}));
            df.createOrReplaceTempView("source");
            this.spark().sql("CREATE TABLE table_name USING foo AS SELECT id, data FROM source");
            TableCatalog testCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            Table table = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            String $org_scalatest_assert_macro_left = table.name();
            String $org_scalatest_assert_macro_right = "testcat.table_name";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 755));
            Object[] $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])table.partitioning());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left2), "isEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left2).isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 756));
            java.util.Map $org_scalatest_assert_macro_left3 = table.properties();
            java.util.Map $org_scalatest_assert_macro_right2 = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)"foo")})))).asJava();
            java.util.Map map = $org_scalatest_assert_macro_left3;
            java.util.Map map2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 757));
            StructType $org_scalatest_assert_macro_left4 = table.schema();
            StructType $org_scalatest_assert_macro_right3 = new StructType().add("id", (DataType)LongType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
            StructType structType = $org_scalatest_assert_macro_left4;
            StructType structType2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 758));
            SparkContext qual$29 = this.sparkContext();
            Seq x$125 = ((InMemoryTable)table).rows();
            int x$126 = qual$29.parallelize$default$2();
            RDD rdd = qual$29.parallelize(x$125, x$126, ClassTag$.MODULE$.apply(InternalRow.class));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> {
                SparkSession qual$30 = this.spark();
                RDD x$127 = rdd;
                StructType x$128 = table.schema();
                boolean x$129 = qual$30.internalCreateDataFrame$default$3();
                return qual$30.internalCreateDataFrame(x$127, x$128, x$129);
            }, (Dataset<Row>)this.spark().table("source"));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 742));
        this.test("CreateTableAsSelect: v2 session catalog can load v1 source table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Table t;
            this.spark().conf().unset(SQLConf$.MODULE$.V2_SESSION_CATALOG_IMPLEMENTATION().key());
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuiteV1Filter.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator4$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator4$1(DataSourceV2SQLSuiteV1Filter $outer) {
                }
            }
            Dataset df = this.spark().createDataFrame((Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)"a"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)2L), (Object)"b"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)3L), (Object)"c"), (List)Nil$.MODULE$))), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator4$1(null))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data"}));
            df.createOrReplaceTempView("source");
            this.sql().apply((Object)"CREATE TABLE table_name USING parquet AS SELECT id, data FROM source");
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"TABLE default.table_name"), (Dataset<Row>)this.spark().table("source"));
            Table $org_scalatest_assert_macro_left = t = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog(CatalogManager$.MODULE$.SESSION_CATALOG_NAME())).asTableCatalog().loadTable(Identifier.of((String[])((String[])((Object[])new String[]{"default"})), (String)"table_name"));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.spark.sql.connector.catalog.V1Table", $org_scalatest_assert_macro_left instanceof V1Table, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"V1 table wasn't returned as an unresolved table", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 780));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 766));
        this.test("CreateTableAsSelect: nullable schema", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.registerCatalog("testcat_nullability", ReserveSchemaNullabilityCatalog.class);
            TableCatalog basicCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            TableCatalog atomicCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat_atomic")).asTableCatalog();
            TableCatalog reserveNullabilityCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat_nullability")).asTableCatalog();
            String basicIdentifier = "testcat.table_name";
            String atomicIdentifier = "testcat_atomic.table_name";
            String reserveNullabilityIdentifier = "testcat_nullability.table_name";
            ((IterableLike)new .colon.colon((Object)new Tuple3((Object)basicCatalog, (Object)basicIdentifier, (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple3((Object)atomicCatalog, (Object)atomicIdentifier, (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple3((Object)reserveNullabilityCatalog, (Object)reserveNullabilityIdentifier, (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)x0$5 -> {
                DataSourceV2SQLSuiteV1Filter.$anonfun$new$90(this, x0$5);
                return BoxedUnit.UNIT;
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 783));
        this.ignore("CreateTableAsSelect: without USING clause", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.spark().conf().unset(SQLConf$.MODULE$.V2_SESSION_CATALOG_IMPLEMENTATION().key());
            TableCatalog testCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            this.sql().apply((Object)"CREATE TABLE testcat.t1 AS SELECT 1 i");
            Table t1 = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"t1"));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(t1.properties().containsKey("provider"), "t1.properties().containsKey(\"provider\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 839));
            this.sql().apply((Object)"CREATE TABLE t2 AS SELECT 1 i");
            V1Table t2 = (V1Table)CatalogV2Implicits$.MODULE$.CatalogHelper(this.spark().sessionState().catalogManager().v2SessionCatalog()).asTableCatalog().loadTable(Identifier.of((String[])((String[])((Object[])new String[]{"default"})), (String)"t2"));
            Option $org_scalatest_assert_macro_left = t2.v1Table().provider();
            Some $org_scalatest_assert_macro_right = new Some((Object)this.conf().defaultDataSourceName());
            Option option = $org_scalatest_assert_macro_left;
            Some some = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 831));
        this.test("SPARK-34039: ReplaceTable (atomic or non-atomic) should invalidate cache", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"testcat.ns.t", (List)new .colon.colon((Object)"testcat_atomic.ns.t", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)t -> {
            DataSourceV2SQLSuiteV1Filter.$anonfun$new$96(this, t);
            return BoxedUnit.UNIT;
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 848));
        this.test("SPARK-33492: ReplaceTableAsSelect (atomic or non-atomic) should invalidate cache", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"testcat.ns.t", (List)new .colon.colon((Object)"testcat_atomic.ns.t", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)t -> {
            DataSourceV2SQLSuiteV1Filter.$anonfun$new$102(this, t);
            return BoxedUnit.UNIT;
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 866));
        this.test("SPARK-33492: AppendData should refresh cache", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testcat.ns.t";
            String view = "view";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{view}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuiteV1Filter.class.getClassLoader());
                public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator10$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator10$1(DataSourceV2SQLSuiteV1Filter $outer) {
                    }
                }
                this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a"), (List)Nil$.MODULE$), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator10$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"i", "j"})).write().saveAsTable(t);
                this.sql().apply((Object)new StringBuilder(30).append("CACHE TABLE ").append(view).append(" AS SELECT i FROM ").append(t).toString());
                Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a"}));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(t).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row));
                Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(view).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row2));
                JavaUniverse $u2 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuiteV1Filter.class.getClassLoader());
                public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator20$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator20$1(DataSourceV2SQLSuiteV1Filter $outer) {
                    }
                }
                this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)2), (Object)"b"), (List)Nil$.MODULE$), this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator20$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"i", "j"})).write().mode(SaveMode.Append).saveAsTable(t);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.spark().sharedState().cacheManager().lookupCachedData(this.spark().table(view)).isDefined(), "DataSourceV2SQLSuiteV1Filter.this.spark.sharedState.cacheManager.lookupCachedData(DataSourceV2SQLSuiteV1Filter.this.spark.table(view)).isDefined", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 897));
                Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a"}));
                Row row4 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "b"}));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(t).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row4).$colon$colon((Object)row3));
                Row row5 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}));
                Row row6 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)}));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(view).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row6).$colon$colon((Object)row5));
            }));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 883));
        this.test("SPARK-33492: OverwriteByExpression should refresh cache", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testcat.ns.t";
            String view = "view";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{view}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(54).append("CREATE TABLE ").append(t).append(" USING foo AS SELECT id, data FROM source").toString());
                this.sql().apply((Object)new StringBuilder(31).append("CACHE TABLE ").append(view).append(" AS SELECT id FROM ").append(t).toString());
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(t).toString()), (Dataset<Row>)this.spark().table("source"));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(view).toString()), (Dataset<Row>)this.spark().table("source").select("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])));
                this.sql().apply((Object)new StringBuilder(39).append("INSERT OVERWRITE TABLE ").append(t).append(" VALUES (1, 'a')").toString());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.spark().sharedState().cacheManager().lookupCachedData(this.spark().table(view)).isDefined(), "DataSourceV2SQLSuiteV1Filter.this.spark.sharedState.cacheManager.lookupCachedData(DataSourceV2SQLSuiteV1Filter.this.spark.table(view)).isDefined", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 916));
                Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a"}));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(t).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row));
                Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(view).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row2));
            }));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 904));
        this.test("SPARK-33492: OverwritePartitionsDynamic should refresh cache", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testcat.ns.t";
            String view = "view";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{view}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuiteV1Filter.class.getClassLoader());
                public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator30$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                    }

                    public Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator30$1(DataSourceV2SQLSuiteV1Filter $outer) {
                    }
                }
                this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a", (Object)BoxesRunTime.boxToInteger((int)1)), (List)Nil$.MODULE$), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator30$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"i", "j", "k"})).write().partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k"})).saveAsTable(t);
                this.sql().apply((Object)new StringBuilder(30).append("CACHE TABLE ").append(view).append(" AS SELECT i FROM ").append(t).toString());
                Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a", BoxesRunTime.boxToInteger((int)1)}));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(t).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row));
                Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(view).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row2));
                JavaUniverse $u2 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuiteV1Filter.class.getClassLoader());
                public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator40$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                    }

                    public Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator40$1(DataSourceV2SQLSuiteV1Filter $outer) {
                    }
                }
                this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)"b", (Object)BoxesRunTime.boxToInteger((int)1)), (List)Nil$.MODULE$), this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator40$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"i", "j", "k"})).writeTo(t).overwritePartitions();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.spark().sharedState().cacheManager().lookupCachedData(this.spark().table(view)).isDefined(), "DataSourceV2SQLSuiteV1Filter.this.spark.sharedState.cacheManager.lookupCachedData(DataSourceV2SQLSuiteV1Filter.this.spark.table(view)).isDefined", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 937));
                Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "b", BoxesRunTime.boxToInteger((int)1)}));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(t).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row3));
                Row row4 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)}));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(view).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row4));
            }));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 923));
        this.test("SPARK-34947: micro batch streaming write should invalidate cache", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testcat.ns.t";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)checkpointDir -> {
                DataSourceV2SQLSuiteV1Filter.$anonfun$new$130(this, t, checkpointDir);
                return BoxedUnit.UNIT;
            }));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 944));
        this.test("Relation: basic", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t1 = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t1}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(54).append("CREATE TABLE ").append(t1).append(" USING foo AS SELECT id, data FROM source").toString());
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(6).append("TABLE ").append(t1).toString()), (Dataset<Row>)this.spark().table("source"));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(t1).toString()), (Dataset<Row>)this.spark().table("source"));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 972));
        this.test("Relation: SparkSession.table()", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t1 = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t1}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(54).append("CREATE TABLE ").append(t1).append(" USING foo AS SELECT id, data FROM source").toString());
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> this.spark().table(String.valueOf(t1)), (Dataset<Row>)this.spark().table("source"));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 981));
        this.test("Relation: CTE", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t1 = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t1}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(54).append("CREATE TABLE ").append(t1).append(" USING foo AS SELECT id, data FROM source").toString());
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(78).append("\n          |WITH cte AS (SELECT * FROM ").append(t1).append(")\n          |SELECT * FROM cte\n        ").toString())).stripMargin()), (Dataset<Row>)this.spark().table("source"));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 989));
        this.test("Relation: view text", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t1 = "testcat.ns1.ns2.tbl";
            String v1 = "view1";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t1}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{v1}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(54).append("CREATE TABLE ").append(t1).append(" USING foo AS SELECT id, data FROM source").toString());
                this.sql().apply((Object)new StringBuilder(30).append("CREATE VIEW ").append(v1).append(" AS SELECT * from ").append(t1).toString());
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(6).append("TABLE ").append(v1).toString()), (Dataset<Row>)this.spark().table("source"));
            }));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1002));
        this.test("Relation: join tables in 2 catalogs", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t1 = "testcat.ns1.ns2.tbl";
            String t2 = "testcat2.v2tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t1, t2}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(54).append("CREATE TABLE ").append(t1).append(" USING foo AS SELECT id, data FROM source").toString());
                this.sql().apply((Object)new StringBuilder(55).append("CREATE TABLE ").append(t2).append(" USING foo AS SELECT id, data FROM source2").toString());
                Dataset df1 = this.spark().table("source");
                Dataset df2 = this.spark().table("source2");
                Dataset df_joined = df1.join(df2).where(df1.apply("id").$plus((Object)BoxesRunTime.boxToInteger((int)1)).$eq$eq$eq((Object)df2.apply("id")));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(89).append("\n          |SELECT *\n          |FROM ").append(t1).append(" t1, ").append(t2).append(" t2\n          |WHERE t1.id + 1 = t2.id\n        ").toString())).stripMargin()), (Dataset<Row>)df_joined);
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1014));
        this.test("qualified column names for v2 tables", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(71).append("CREATE TABLE ").append(t).append(" (id bigint, point struct<x: bigint, y: bigint>) USING foo").toString());
                this.sql().apply((Object)new StringBuilder(33).append("INSERT INTO ").append(t).append(" VALUES (1, (10, 20))").toString());
                this.check$1(t);
                this.sql().apply((Object)"USE testcat.ns1.ns2");
                this.check$1("tbl");
                this.checkError((SparkThrowable)this.analysisException(new StringBuilder(31).append("SELECT ns1.ns2.ns3.tbl.id from ").append(t).toString()), "UNRESOLVED_COLUMN.WITH_SUGGESTION", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"objectName"), (Object)"`ns1`.`ns2`.`ns3`.`tbl`.`id`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"proposal"), (Object)"`testcat`.`ns1`.`ns2`.`tbl`.`id`, `testcat`.`ns1`.`ns2`.`tbl`.`point`")})), (QueryContext)this.ExpectedContext().apply("ns1.ns2.ns3.tbl.id", 7, 24));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1033));
        this.test("qualified column names for v1 tables", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)useV1Table -> {
            DataSourceV2SQLSuiteV1Filter.$anonfun$new$156(this, BoxesRunTime.unboxToBoolean((Object)useV1Table));
            return BoxedUnit.UNIT;
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1068));
        this.test("InsertInto: append - across catalog", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t1 = "testcat.ns1.ns2.tbl";
            String t2 = "testcat2.db.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t1, t2}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(47).append("CREATE TABLE ").append(t1).append(" USING foo AS SELECT * FROM source").toString());
                this.sql().apply((Object)new StringBuilder(48).append("CREATE TABLE ").append(t2).append(" (id bigint, data string) USING foo").toString());
                this.sql().apply((Object)new StringBuilder(27).append("INSERT INTO ").append(t2).append(" SELECT * FROM ").append(t1).toString());
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> this.spark().table(t2), (Dataset<Row>)this.spark().table("source"));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1092));
        this.test("insertInto: append by name", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t1 = "tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t1}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(45).append("CREATE TABLE ").append(t1).append(" (id bigint, data string) USING ").append(this.v2Format()).toString());
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuiteV1Filter.class.getClassLoader());
                public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator55$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator55$1(DataSourceV2SQLSuiteV1Filter $outer) {
                    }
                }
                Dataset df = this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)"a"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)2L), (Object)"b"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)3L), (Object)"c"), (List)Nil$.MODULE$))), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator55$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data"}));
                this.sql().apply((Object)new StringBuilder(38).append("INSERT INTO ").append(t1).append("(id, data) VALUES(1L, 'a')").toString());
                this.sql().apply((Object)new StringBuilder(38).append("INSERT INTO ").append(t1).append("(data, id) VALUES('b', 2L)").toString());
                this.sql().apply((Object)new StringBuilder(37).append("INSERT INTO ").append(t1).append("(data, id) VALUES('c', 3)").toString());
                this.verifyTable(t1, (Dataset<Row>)df);
                AnalysisException x$141 = (AnalysisException)((Object)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(22).append("INSERT INTO ").append(t1).append(" VALUES(4)").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1117)))));
                String x$142 = "INSERT_COLUMN_ARITY_MISMATCH.NOT_ENOUGH_DATA_COLUMNS";
                scala.collection.immutable.Map x$143 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)"`default`.`tbl`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableColumns"), (Object)"`id`, `data`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataColumns"), (Object)"`col1`")}));
                Option x$144 = this.checkError$default$3();
                boolean x$145 = this.checkError$default$5();
                QueryContext[] x$146 = this.checkError$default$6();
                this.checkError((SparkThrowable)x$141, x$142, x$144, x$143, x$145, x$146);
                AnalysisException x$147 = (AnalysisException)((Object)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(34).append("INSERT INTO ").append(t1).append("(data, data) VALUES(5)").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1129)))));
                String x$148 = "COLUMN_ALREADY_EXISTS";
                scala.collection.immutable.Map x$149 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)"`data`")}));
                Option x$150 = this.checkError$default$3();
                boolean x$151 = this.checkError$default$5();
                QueryContext[] x$152 = this.checkError$default$6();
                this.checkError((SparkThrowable)x$147, x$148, x$150, x$149, x$151, x$152);
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1103));
        this.test("insertInto: overwrite by name", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t1 = "tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t1}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(45).append("CREATE TABLE ").append(t1).append(" (id bigint, data string) USING ").append(this.v2Format()).toString());
                this.sql().apply((Object)new StringBuilder(43).append("INSERT OVERWRITE ").append(t1).append("(id, data) VALUES(1L, 'a')").toString());
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuiteV1Filter.class.getClassLoader());
                public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator65$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator65$1(DataSourceV2SQLSuiteV1Filter $outer) {
                    }
                }
                this.verifyTable(t1, (Dataset<Row>)this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)"a"), (List)Nil$.MODULE$), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator65$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data"})));
                this.sql().apply((Object)new StringBuilder(43).append("INSERT OVERWRITE ").append(t1).append("(data, id) VALUES('b', 2L)").toString());
                JavaUniverse $u2 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuiteV1Filter.class.getClassLoader());
                public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator75$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator75$1(DataSourceV2SQLSuiteV1Filter $outer) {
                    }
                }
                this.verifyTable(t1, (Dataset<Row>)this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)2L), (Object)"b"), (List)Nil$.MODULE$), this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator75$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data"})));
                this.sql().apply((Object)new StringBuilder(42).append("INSERT OVERWRITE ").append(t1).append("(data, id) VALUES('c', 3)").toString());
                JavaUniverse $u3 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuiteV1Filter.class.getClassLoader());
                public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator85$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator85$1(DataSourceV2SQLSuiteV1Filter $outer) {
                    }
                }
                this.verifyTable(t1, (Dataset<Row>)this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)3L), (Object)"c"), (List)Nil$.MODULE$), this.testImplicits().newProductEncoder(((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator85$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data"})));
                AnalysisException x$153 = (AnalysisException)((Object)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(27).append("INSERT OVERWRITE ").append(t1).append(" VALUES(4)").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1152)))));
                String x$154 = "INSERT_COLUMN_ARITY_MISMATCH.NOT_ENOUGH_DATA_COLUMNS";
                scala.collection.immutable.Map x$155 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)"`default`.`tbl`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableColumns"), (Object)"`id`, `data`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataColumns"), (Object)"`col1`")}));
                Option x$156 = this.checkError$default$3();
                boolean x$157 = this.checkError$default$5();
                QueryContext[] x$158 = this.checkError$default$6();
                this.checkError((SparkThrowable)x$153, x$154, x$156, x$155, x$157, x$158);
                AnalysisException x$159 = (AnalysisException)((Object)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(39).append("INSERT OVERWRITE ").append(t1).append("(data, data) VALUES(5)").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1164)))));
                String x$160 = "COLUMN_ALREADY_EXISTS";
                scala.collection.immutable.Map x$161 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)"`data`")}));
                Option x$162 = this.checkError$default$3();
                boolean x$163 = this.checkError$default$5();
                QueryContext[] x$164 = this.checkError$default$6();
                this.checkError((SparkThrowable)x$159, x$160, x$162, x$161, x$163, x$164);
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1137));
        this.dynamicOverwriteTest("insertInto: dynamic overwrite by name", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t1 = "tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t1}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(79).append("CREATE TABLE ").append(t1).append(" (id bigint, data string, data2 string) ").append("USING ").append(this.v2Format()).append(" PARTITIONED BY (id)").toString());
                this.sql().apply((Object)new StringBuilder(55).append("INSERT OVERWRITE ").append(t1).append("(id, data, data2) VALUES(1L, 'a', 'b')").toString());
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuiteV1Filter.class.getClassLoader());
                public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator95$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                    }

                    public Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator95$1(DataSourceV2SQLSuiteV1Filter $outer) {
                    }
                }
                this.verifyTable(t1, (Dataset<Row>)this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)1L), (Object)"a", (Object)"b"), (List)Nil$.MODULE$), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator95$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data", "data2"})));
                this.sql().apply((Object)new StringBuilder(55).append("INSERT OVERWRITE ").append(t1).append("(data, data2, id) VALUES('b', 'd', 2L)").toString());
                JavaUniverse $u2 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuiteV1Filter.class.getClassLoader());
                public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator105$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                    }

                    public Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator105$1(DataSourceV2SQLSuiteV1Filter $outer) {
                    }
                }
                this.verifyTable(t1, (Dataset<Row>)this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)1L), (Object)"a", (Object)"b"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)2L), (Object)"b", (Object)"d"), (List)Nil$.MODULE$)), this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator105$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data", "data2"})));
                this.sql().apply((Object)new StringBuilder(54).append("INSERT OVERWRITE ").append(t1).append("(data, data2, id) VALUES('c', 'e', 1)").toString());
                JavaUniverse $u3 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuiteV1Filter.class.getClassLoader());
                public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator115$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                    }

                    public Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator115$1(DataSourceV2SQLSuiteV1Filter $outer) {
                    }
                }
                this.verifyTable(t1, (Dataset<Row>)this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)1L), (Object)"c", (Object)"e"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)2L), (Object)"b", (Object)"d"), (List)Nil$.MODULE$)), this.testImplicits().newProductEncoder(((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator115$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data", "data2"})));
                AnalysisException x$165 = (AnalysisException)((Object)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(32).append("INSERT OVERWRITE ").append(t1).append(" VALUES('a', 4)").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1188)))));
                String x$166 = "INSERT_COLUMN_ARITY_MISMATCH.NOT_ENOUGH_DATA_COLUMNS";
                scala.collection.immutable.Map x$167 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)"`default`.`tbl`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableColumns"), (Object)"`id`, `data`, `data2`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataColumns"), (Object)"`col1`, `col2`")}));
                Option x$168 = this.checkError$default$3();
                boolean x$169 = this.checkError$default$5();
                QueryContext[] x$170 = this.checkError$default$6();
                this.checkError((SparkThrowable)x$165, x$166, x$168, x$167, x$169, x$170);
                AnalysisException x$171 = (AnalysisException)((Object)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(39).append("INSERT OVERWRITE ").append(t1).append("(data, data) VALUES(5)").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1200)))));
                String x$172 = "COLUMN_ALREADY_EXISTS";
                scala.collection.immutable.Map x$173 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)"`data`")}));
                Option x$174 = this.checkError$default$3();
                boolean x$175 = this.checkError$default$5();
                QueryContext[] x$176 = this.checkError$default$6();
                this.checkError((SparkThrowable)x$171, x$172, x$174, x$173, x$175, x$176);
            });
        });
        this.test("insertInto: static partition column name should not be used in the column list", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)new StringBuilder(60).append("CREATE TABLE t(i STRING, c string) USING ").append(this.v2Format()).append(" PARTITIONED BY (c)").toString());
            AnalysisException x$177 = (AnalysisException)((Object)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"INSERT OVERWRITE t PARTITION (c='1') (c) VALUES ('2')"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1212)))));
            String x$178 = "STATIC_PARTITION_COLUMN_IN_INSERT_COLUMN_LIST";
            scala.collection.immutable.Map x$179 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"staticName"), (Object)"c")}));
            Option x$180 = this.checkError$default$3();
            boolean x$181 = this.checkError$default$5();
            QueryContext[] x$182 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$177, x$178, x$180, x$179, x$181, x$182);
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1208));
        this.test("ShowViews: using v1 catalog, db name with multipartIdentifier ('a.b') is not allowed.", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            AnalysisException x$183 = (AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SHOW VIEWS FROM a.b"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1222))));
            String x$184 = "_LEGACY_ERROR_TEMP_1126";
            scala.collection.immutable.Map x$185 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"catalog"), (Object)"a.b")}));
            Option x$186 = this.checkError$default$3();
            boolean x$187 = this.checkError$default$5();
            QueryContext[] x$188 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$183, x$184, x$186, x$185, x$187, x$188);
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1220));
        this.test("ShowViews: using v2 catalog, command not supported.", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            AnalysisException x$189 = (AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SHOW VIEWS FROM testcat"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1231))));
            String x$190 = "_LEGACY_ERROR_TEMP_1184";
            scala.collection.immutable.Map x$191 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"plugin"), (Object)"testcat"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ability"), (Object)"views")}));
            Option x$192 = this.checkError$default$3();
            boolean x$193 = this.checkError$default$5();
            QueryContext[] x$194 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$189, x$190, x$192, x$191, x$193, x$194);
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1229));
        this.test("create/replace/alter table - reserved properties", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            scala.collection.immutable.Map keyParameters = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)"please use the USING clause to specify it"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"location"), (Object)"please use the LOCATION clause to specify it"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"owner"), (Object)"it will be set to the current user"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"external"), (Object)"please use CREATE EXTERNAL TABLE")}));
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SQLConf$.MODULE$.LEGACY_PROPERTY_NON_RESERVED().key(), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)CatalogV2Util$.MODULE$.TABLE_RESERVED_PROPERTIES().filterNot((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)DataSourceV2SQLSuiteV1Filter.$anonfun$new$189(x$15)))).foreach((Function1 & Serializable & scala.Serializable)key -> {
                DataSourceV2SQLSuiteV1Filter.$anonfun$new$190(this, keyParameters, key);
                return BoxedUnit.UNIT;
            }));
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SQLConf$.MODULE$.LEGACY_PROPERTY_NON_RESERVED().key(), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)CatalogV2Util$.MODULE$.TABLE_RESERVED_PROPERTIES().filterNot((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)DataSourceV2SQLSuiteV1Filter.$anonfun$new$200(x$16)))).foreach((Function1 & Serializable & scala.Serializable)key -> {
                DataSourceV2SQLSuiteV1Filter.$anonfun$new$201(this, key);
                return BoxedUnit.UNIT;
            }));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1238));
        this.test("create/replace - path property", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"true", (List)new .colon.colon((Object)"false", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)conf -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SQLConf$.MODULE$.LEGACY_PROPERTY_NON_RESERVED().key(), (Object)conf)}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"testcat.reservedTest"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"CREATE", (List)new .colon.colon((Object)"REPLACE", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)action -> {
                Bool bool;
                String location;
                String sql1 = new StringBuilder(75).append((String)action).append(" TABLE testcat.reservedTest USING foo LOCATION 'foo' OPTIONS").append(" ('path'='bar')").toString();
                $this.checkError((SparkThrowable)$this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)sql1), ClassTag$.MODULE$.apply(ParseException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1330)), "_LEGACY_ERROR_TEMP_0032", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pathOne"), (Object)"foo"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pathTwo"), (Object)"bar")})), (QueryContext)$this.ExpectedContext().apply(sql1, 0, 74 + action.length()));
                String sql2 = new StringBuilder(74).append((String)action).append(" TABLE testcat.reservedTest USING foo OPTIONS").append(" ('path'='foo', 'PaTh'='bar')").toString();
                $this.checkError((SparkThrowable)$this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)sql2), ClassTag$.MODULE$.apply(ParseException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1343)), "_LEGACY_ERROR_TEMP_0032", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pathOne"), (Object)"foo"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pathTwo"), (Object)"bar")})), (QueryContext)$this.ExpectedContext().apply(sql2, 0, 73 + action.length()));
                $this.sql().apply((Object)new StringBuilder(96).append((String)action).append(" TABLE testcat.reservedTest USING foo LOCATION 'foo' TBLPROPERTIES").append(" ('path'='bar', 'Path'='noop')").toString());
                TableCatalog tableCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper($this.catalog("testcat")).asTableCatalog();
                Identifier identifier = Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"reservedTest");
                String $org_scalatest_assert_macro_left = location = (String)tableCatalog.loadTable(identifier).properties().get("location");
                String $org_scalatest_assert_macro_right = "file:";
                Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "startsWith", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.startsWith($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left2.value()) {
                    String $org_scalatest_assert_macro_left3 = location;
                    String $org_scalatest_assert_macro_right2 = "foo";
                    bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "endsWith", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.endsWith($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                } else {
                    bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right3 = bool;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"path as a table property should not have side effects", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1359));
                String $org_scalatest_assert_macro_left4 = (String)tableCatalog.loadTable(identifier).properties().get("path");
                String $org_scalatest_assert_macro_right4 = "bar";
                String string = $org_scalatest_assert_macro_left4;
                String string2 = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"path as a table property should not have side effects", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1361));
                String $org_scalatest_assert_macro_left5 = (String)tableCatalog.loadTable(identifier).properties().get("Path");
                String $org_scalatest_assert_macro_right5 = "noop";
                String string3 = $org_scalatest_assert_macro_left5;
                String string4 = $org_scalatest_assert_macro_right5;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"path as a table property should not have side effects", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1363));
            })));
            return BoxedUnit.UNIT;
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1322));
        this.test("Use: basic tests with USE statements", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            CatalogManager catalogManager = this.spark().sessionState().catalogManager();
            String $org_scalatest_assert_macro_left = catalogManager.currentCatalog().name();
            String $org_scalatest_assert_macro_right = CatalogManager$.MODULE$.SESSION_CATALOG_NAME();
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1385));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(catalogManager.currentNamespace());
            String[] $org_scalatest_assert_macro_right2 = (String[])((Object[])new String[]{"default"});
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1386));
            this.sql().apply((Object)"CREATE TABLE testcat.ns1.ns1_1.table (id bigint) USING foo");
            this.sql().apply((Object)"CREATE TABLE testcat2.ns2.ns2_2.table (id bigint) USING foo");
            this.sql().apply((Object)"CREATE TABLE testcat2.ns3.ns3_3.table (id bigint) USING foo");
            this.sql().apply((Object)"CREATE TABLE testcat2.testcat.table (id bigint) USING foo");
            this.sql().apply((Object)"CREATE TABLE testcat2.testcat.ns1.ns1_1.table (id bigint) USING foo");
            this.sql().apply((Object)"USE testcat.ns1.ns1_1");
            String $org_scalatest_assert_macro_left3 = catalogManager.currentCatalog().name();
            String $org_scalatest_assert_macro_right3 = "testcat";
            String string3 = $org_scalatest_assert_macro_left3;
            String string4 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1397));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(catalogManager.currentNamespace());
            String[] $org_scalatest_assert_macro_right4 = (String[])((Object[])new String[]{"ns1", "ns1_1"});
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1398));
            this.sql().apply((Object)"USE testcat2.ns2.ns2_2");
            String $org_scalatest_assert_macro_left5 = catalogManager.currentCatalog().name();
            String $org_scalatest_assert_macro_right5 = "testcat2";
            String string5 = $org_scalatest_assert_macro_left5;
            String string6 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1402));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(catalogManager.currentNamespace());
            String[] $org_scalatest_assert_macro_right6 = (String[])((Object[])new String[]{"ns2", "ns2_2"});
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1403));
            this.sql().apply((Object)"USE ns3.ns3_3");
            String $org_scalatest_assert_macro_left7 = catalogManager.currentCatalog().name();
            String $org_scalatest_assert_macro_right7 = "testcat2";
            String string7 = $org_scalatest_assert_macro_left7;
            String string8 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right7, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1407));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(catalogManager.currentNamespace());
            String[] $org_scalatest_assert_macro_right8 = (String[])((Object[])new String[]{"ns3", "ns3_3"});
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1408));
            this.sql().apply((Object)"USE NAMESPACE testcat");
            String $org_scalatest_assert_macro_left9 = catalogManager.currentCatalog().name();
            String $org_scalatest_assert_macro_right9 = "testcat2";
            String string9 = $org_scalatest_assert_macro_left9;
            String string10 = $org_scalatest_assert_macro_right9;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right9, !(string9 != null ? !string9.equals(string10) : string10 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1412));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(catalogManager.currentNamespace());
            String[] $org_scalatest_assert_macro_right10 = (String[])((Object[])new String[]{"testcat"});
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1413));
            this.sql().apply((Object)"USE NAMESPACE testcat.ns1.ns1_1");
            String $org_scalatest_assert_macro_left11 = catalogManager.currentCatalog().name();
            String $org_scalatest_assert_macro_right11 = "testcat2";
            String string11 = $org_scalatest_assert_macro_left11;
            String string12 = $org_scalatest_assert_macro_right11;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "==", (Object)$org_scalatest_assert_macro_right11, !(string11 != null ? !string11.equals(string12) : string12 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1417));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.convertToEqualizer(catalogManager.currentNamespace());
            String[] $org_scalatest_assert_macro_right12 = (String[])((Object[])new String[]{"testcat", "ns1", "ns1_1"});
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)$org_scalatest_assert_macro_right12, $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)$org_scalatest_assert_macro_right12, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1418));
            this.sql().apply((Object)"USE testcat");
            String $org_scalatest_assert_macro_left13 = catalogManager.currentCatalog().name();
            String $org_scalatest_assert_macro_right13 = "testcat";
            String string13 = $org_scalatest_assert_macro_left13;
            String string14 = $org_scalatest_assert_macro_right13;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "==", (Object)$org_scalatest_assert_macro_right13, !(string13 != null ? !string13.equals(string14) : string14 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1422));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left14 = this.convertToEqualizer(catalogManager.currentNamespace());
            Object[] $org_scalatest_assert_macro_right14 = (Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Nothing());
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "===", (Object)$org_scalatest_assert_macro_right14, $org_scalatest_assert_macro_left14.$eq$eq$eq((Object)$org_scalatest_assert_macro_right14, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1423));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1381));
        this.test("Use: set v2 catalog as a current catalog", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            CatalogManager catalogManager = this.spark().sessionState().catalogManager();
            String $org_scalatest_assert_macro_left = catalogManager.currentCatalog().name();
            String $org_scalatest_assert_macro_right = CatalogManager$.MODULE$.SESSION_CATALOG_NAME();
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1428));
            this.sql().apply((Object)"USE testcat");
            String $org_scalatest_assert_macro_left2 = catalogManager.currentCatalog().name();
            String $org_scalatest_assert_macro_right2 = "testcat";
            String string3 = $org_scalatest_assert_macro_left2;
            String string4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1431));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1426));
        this.test("Use: v2 session catalog is used and namespace does not exist", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            NoSuchDatabaseException exception;
            NoSuchDatabaseException x$195 = exception = (NoSuchDatabaseException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"USE ns1"), ClassTag$.MODULE$.apply(NoSuchDatabaseException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1435));
            String x$196 = "SCHEMA_NOT_FOUND";
            scala.collection.immutable.Map x$197 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schemaName"), (Object)"`ns1`")}));
            Option x$198 = this.checkError$default$3();
            boolean x$199 = this.checkError$default$5();
            QueryContext[] x$200 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$195, x$196, x$198, x$197, x$199, x$200);
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1434));
        this.test("SPARK-31100: Use: v2 catalog that implements SupportsNamespaces is used and namespace not exists", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            NoSuchNamespaceException exception;
            NoSuchNamespaceException x$201 = exception = (NoSuchNamespaceException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"USE testcat.ns1.ns2"), ClassTag$.MODULE$.apply(NoSuchNamespaceException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1446));
            String x$202 = "SCHEMA_NOT_FOUND";
            scala.collection.immutable.Map x$203 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schemaName"), (Object)"`ns1`.`ns2`")}));
            Option x$204 = this.checkError$default$3();
            boolean x$205 = this.checkError$default$5();
            QueryContext[] x$206 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$201, x$202, x$204, x$203, x$205, x$206);
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1444));
        this.test("SPARK-31100: Use: v2 catalog that does not implement SupportsNameSpaces is used and namespace does not exist", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.sql.catalog.dummy"), (Object)BasicInMemoryTableCatalog.class.getName())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            CatalogManager catalogManager = this.spark().sessionState().catalogManager();
            this.sql().apply((Object)"USE dummy.ns1");
            String $org_scalatest_assert_macro_left = catalogManager.currentCatalog().name();
            String $org_scalatest_assert_macro_right = "dummy";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1462));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(catalogManager.currentNamespace());
            String[] $org_scalatest_assert_macro_right2 = (String[])((Object[])new String[]{"ns1"});
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1463));
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1455));
        this.test("SPARK-42684: Column default value only allowed with TableCatalogs that SUPPORT_COLUMN_DEFAULT_VALUE", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tblName = "my_tab";
            String tableDefinition = new StringBuilder(26).append(tblName).append("(c1 INT, c2 INT DEFAULT 0)").toString();
            ((IterableLike)new .colon.colon((Object)"CREATE TABLE", (List)new .colon.colon((Object)"REPLACE TABLE", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)statement -> {
                DataSourceV2SQLSuiteV1Filter.$anonfun$new$222(this, tblName, tableDefinition, statement);
                return BoxedUnit.UNIT;
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1468));
        this.test("SPARK-41290: Generated columns only allowed with TableCatalogs that SUPPORTS_CREATE_TABLE_WITH_GENERATED_COLUMNS", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tblName = "my_tab";
            String tableDefinition = new StringBuilder(69).append(tblName).append("(eventDate DATE, eventYear INT GENERATED ALWAYS AS (year(eventDate)))").toString();
            ((IterableLike)new .colon.colon((Object)"CREATE TABLE", (List)new .colon.colon((Object)"REPLACE TABLE", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)statement -> {
                DataSourceV2SQLSuiteV1Filter.$anonfun$new$227(this, tblName, tableDefinition, statement);
                return BoxedUnit.UNIT;
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1500));
        this.test("SPARK-41290: Column cannot have both a generation expression and a default value", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tblName = "my_tab";
            String tableDefinition = new StringBuilder(79).append(tblName).append("(eventDate DATE, eventYear INT GENERATED ALWAYS AS (year(eventDate)) DEFAULT 0)").toString();
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.DEFAULT_COLUMN_ALLOWED_PROVIDERS().key()), (Object)"foo")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"CREATE TABLE", (List)new .colon.colon((Object)"REPLACE TABLE", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)statement -> {
                this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(8).append("testcat.").append(tblName).toString()}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    String string = statement;
                    String string2 = "REPLACE TABLE";
                    Object object = !(string != null ? !string.equals(string2) : string2 != null) ? $this.sql().apply((Object)new StringBuilder(38).append("CREATE TABLE testcat.").append(tblName$3).append("(a INT) USING foo").toString()) : BoxedUnit.UNIT;
                    AnalysisException x$219 = (AnalysisException)((Object)((Object)$this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(19).append(statement).append(" testcat.").append(tableDefinition$3).append(" USING foo").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1542))));
                    String x$220 = "GENERATED_COLUMN_WITH_DEFAULT_VALUE";
                    scala.collection.immutable.Map x$221 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colName"), (Object)"eventYear"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"defaultValue"), (Object)"0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"genExpr"), (Object)"year(eventDate)")}));
                    Option x$222 = $this.checkError$default$3();
                    boolean x$223 = $this.checkError$default$5();
                    QueryContext[] x$224 = $this.checkError$default$6();
                    $this.checkError((SparkThrowable)x$219, x$220, x$222, x$221, x$223, x$224);
                });
                return BoxedUnit.UNIT;
            }));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1531));
        this.test("SPARK-41290: Generated column expression must be valid generation expression", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tblName = "my_tab";
            this.checkUnsupportedGenerationExpression$1("not_a_function(a)", "failed to resolve `not_a_function` to a built-in function", DataSourceV2SQLSuiteV1Filter.checkUnsupportedGenerationExpression$default$3$1(), DataSourceV2SQLSuiteV1Filter.checkUnsupportedGenerationExpression$default$4$1(), tblName);
            this.spark().udf().register("timesTwo", (Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x -> x * 2, ((TypeTags)package$.MODULE$.universe()).TypeTag().Int(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int());
            this.checkUnsupportedGenerationExpression$1("timesTwo(a)", "failed to resolve `timesTwo` to a built-in function", DataSourceV2SQLSuiteV1Filter.checkUnsupportedGenerationExpression$default$3$1(), DataSourceV2SQLSuiteV1Filter.checkUnsupportedGenerationExpression$default$4$1(), tblName);
            this.checkUnsupportedGenerationExpression$1("b + 1", "generation expression cannot reference itself", DataSourceV2SQLSuiteV1Filter.checkUnsupportedGenerationExpression$default$3$1(), DataSourceV2SQLSuiteV1Filter.checkUnsupportedGenerationExpression$default$4$1(), tblName);
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkUnsupportedGenerationExpression$1("B + 1", "generation expression cannot reference itself", DataSourceV2SQLSuiteV1Filter.checkUnsupportedGenerationExpression$default$3$1(), DataSourceV2SQLSuiteV1Filter.checkUnsupportedGenerationExpression$default$4$1(), tblName));
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(8).append("testcat.").append(tblName).toString()}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkError((SparkThrowable)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(73).append("CREATE TABLE testcat.").append(tblName).append("(a INT, ").append("b INT GENERATED ALWAYS AS (B + 1)) USING foo").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1609)), "UNRESOLVED_COLUMN.WITH_SUGGESTION", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"objectName"), (Object)"`B`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"proposal"), (Object)"`a`")})), (QueryContext)this.ExpectedContext().apply("B", 0, 0))));
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(8).append("testcat.").append(tblName).toString()}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(80).append("CREATE TABLE testcat.").append(tblName).append("(").append("a INT, b INT GENERATED ALWAYS AS (B + 1), B INT) USING foo").toString());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog().tableExists(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)tblName)), "org.apache.spark.sql.connector.catalog.CatalogV2Implicits.CatalogHelper(DataSourceV2SQLSuiteV1Filter.this.catalog(\"testcat\")).asTableCatalog.tableExists(org.apache.spark.sql.connector.catalog.Identifier.of(scala.Array.apply[String]()((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String])), tblName))", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1624));
            }));
            String x$225 = "c + 1";
            String x$226 = "generation expression cannot reference another generated column";
            Some x$227 = new Some((Object)new StringBuilder(108).append("CREATE TABLE testcat.").append(tblName).append("(a INT, ").append("b INT GENERATED ALWAYS AS (c + 1), c INT GENERATED ALWAYS AS (a + 1)) USING foo").toString());
            String x$228 = DataSourceV2SQLSuiteV1Filter.checkUnsupportedGenerationExpression$default$3$1();
            this.checkUnsupportedGenerationExpression$1(x$225, x$226, x$228, (Option)x$227, tblName);
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                String x$229 = "C + 1";
                String x$230 = "generation expression cannot reference another generated column";
                Some x$231 = new Some((Object)new StringBuilder(108).append("CREATE TABLE testcat.").append(tblName).append("(a INT, ").append("b INT GENERATED ALWAYS AS (C + 1), c INT GENERATED ALWAYS AS (a + 1)) USING foo").toString());
                String x$232 = DataSourceV2SQLSuiteV1Filter.checkUnsupportedGenerationExpression$default$3$1();
                this.checkUnsupportedGenerationExpression$1(x$229, x$230, x$232, (Option)x$231, tblName);
                String x$233 = "c + 1";
                String x$234 = "generation expression cannot reference another generated column";
                Some x$235 = new Some((Object)new StringBuilder(108).append("CREATE TABLE testcat.").append(tblName).append("(a INT, ").append("b INT GENERATED ALWAYS AS (c + 1), C INT GENERATED ALWAYS AS (a + 1)) USING foo").toString());
                String x$236 = DataSourceV2SQLSuiteV1Filter.checkUnsupportedGenerationExpression$default$3$1();
                this.checkUnsupportedGenerationExpression$1(x$233, x$234, x$236, (Option)x$235, tblName);
            });
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(8).append("testcat.").append(tblName).toString()}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(108).append("CREATE TABLE testcat.").append(tblName).append("(").append("a INT, A INT GENERATED ALWAYS AS (a + 1), b INT GENERATED ALWAYS AS (a + 1)) USING foo").toString());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog().tableExists(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)tblName)), "org.apache.spark.sql.connector.catalog.CatalogV2Implicits.CatalogHelper(DataSourceV2SQLSuiteV1Filter.this.catalog(\"testcat\")).asTableCatalog.tableExists(org.apache.spark.sql.connector.catalog.Identifier.of(scala.Array.apply[String]()((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String])), tblName))", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1661));
            }));
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(8).append("testcat.").append(tblName).toString()}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkError((SparkThrowable)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(73).append("CREATE TABLE testcat.").append(tblName).append("(a INT, b INT GENERATED ALWAYS AS (c + 1)) USING foo").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1668)), "UNRESOLVED_COLUMN.WITH_SUGGESTION", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"objectName"), (Object)"`c`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"proposal"), (Object)"`a`")})), (QueryContext)this.ExpectedContext().apply("c", 0, 0)));
            this.checkUnsupportedGenerationExpression$1("rand()", "generation expression is not deterministic", DataSourceV2SQLSuiteV1Filter.checkUnsupportedGenerationExpression$default$3$1(), DataSourceV2SQLSuiteV1Filter.checkUnsupportedGenerationExpression$default$4$1(), tblName);
            this.checkUnsupportedGenerationExpression$1("a + 1", "generation expression data type int is incompatible with column data type boolean", "BOOLEAN", DataSourceV2SQLSuiteV1Filter.checkUnsupportedGenerationExpression$default$4$1(), tblName);
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(8).append("testcat.").append(tblName).toString()}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(74).append("CREATE TABLE testcat.").append(tblName).append("(a INT, b LONG GENERATED ALWAYS AS (a + 1)) USING foo").toString());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog().tableExists(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)tblName)), "org.apache.spark.sql.connector.catalog.CatalogV2Implicits.CatalogHelper(DataSourceV2SQLSuiteV1Filter.this.catalog(\"testcat\")).asTableCatalog.tableExists(org.apache.spark.sql.connector.catalog.Identifier.of(scala.Array.apply[String]()((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String])), tblName))", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1692));
            });
            this.checkUnsupportedGenerationExpression$1("(SELECT 1)", "subquery expressions are not allowed for generated columns", DataSourceV2SQLSuiteV1Filter.checkUnsupportedGenerationExpression$default$3$1(), DataSourceV2SQLSuiteV1Filter.checkUnsupportedGenerationExpression$default$4$1(), tblName);
            this.checkUnsupportedGenerationExpression$1("(SELECT (SELECT 2) + 1)", "subquery expressions are not allowed for generated columns", DataSourceV2SQLSuiteV1Filter.checkUnsupportedGenerationExpression$default$3$1(), DataSourceV2SQLSuiteV1Filter.checkUnsupportedGenerationExpression$default$4$1(), tblName);
            this.checkUnsupportedGenerationExpression$1("(SELECT 1) + a", "subquery expressions are not allowed for generated columns", DataSourceV2SQLSuiteV1Filter.checkUnsupportedGenerationExpression$default$3$1(), DataSourceV2SQLSuiteV1Filter.checkUnsupportedGenerationExpression$default$4$1(), tblName);
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"other"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)"create table other(x INT) using parquet");
                this.checkUnsupportedGenerationExpression$1("(select min(x) from other)", "subquery expressions are not allowed for generated columns", DataSourceV2SQLSuiteV1Filter.checkUnsupportedGenerationExpression$default$3$1(), DataSourceV2SQLSuiteV1Filter.checkUnsupportedGenerationExpression$default$4$1(), tblName);
            });
            this.checkUnsupportedGenerationExpression$1("(select min(x) from faketable)", "subquery expressions are not allowed for generated columns", DataSourceV2SQLSuiteV1Filter.checkUnsupportedGenerationExpression$default$3$1(), DataSourceV2SQLSuiteV1Filter.checkUnsupportedGenerationExpression$default$4$1(), tblName);
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1556));
        this.test("SPARK-44313: generation expression validation passes when there is a char/varchar column", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tblName = "my_tab";
            ((IterableLike)new .colon.colon((Object)"name VARCHAR(64)", (List)new .colon.colon((Object)"name CHAR(64)", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)charVarCharCol -> {
                this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(8).append("testcat.").append(tblName).toString()}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    $this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(206).append("\n             |CREATE TABLE testcat.").append(tblName$5).append("(\n             |  ").append(charVarCharCol).append(",\n             |  tstamp TIMESTAMP,\n             |  tstamp_date DATE GENERATED ALWAYS AS (CAST(tstamp AS DATE))\n             |) USING foo\n             |").toString())).stripMargin());
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(CatalogV2Implicits$.MODULE$.CatalogHelper($this.catalog("testcat")).asTableCatalog().tableExists(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)tblName$5)), "org.apache.spark.sql.connector.catalog.CatalogV2Implicits.CatalogHelper(DataSourceV2SQLSuiteV1Filter.this.catalog(\"testcat\")).asTableCatalog.tableExists(org.apache.spark.sql.connector.catalog.Identifier.of(scala.Array.apply[String]()((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String])), tblName))", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1734));
                });
                return BoxedUnit.UNIT;
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1721));
        this.test("ShowCurrentNamespace: basic tests", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.testShowCurrentNamespace$1("spark_catalog", "default");
            this.sql().apply((Object)"USE testcat");
            this.testShowCurrentNamespace$1("testcat", "");
            this.sql().apply((Object)"CREATE NAMESPACE testcat.ns1.ns2");
            this.sql().apply((Object)"USE testcat.ns1.ns2");
            this.testShowCurrentNamespace$1("testcat", "ns1.ns2");
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1739));
        this.test("tableCreation: partition column case insensitive resolution", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TableCatalog testCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            TableCatalog sessionCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog(CatalogManager$.MODULE$.SESSION_CATALOG_NAME())).asTableCatalog();
            this.sql().apply((Object)new StringBuilder(60).append("CREATE TABLE tbl (a int, b string) USING ").append(this.v2Source()).append(" PARTITIONED BY (A)").toString());
            this.checkPartitioning$1(sessionCatalog, "a");
            this.sql().apply((Object)new StringBuilder(68).append("CREATE TABLE testcat.tbl (a int, b string) USING ").append(this.v2Source()).append(" PARTITIONED BY (A)").toString());
            this.checkPartitioning$1(testCatalog, "a");
            this.sql().apply((Object)new StringBuilder(71).append("CREATE OR REPLACE TABLE tbl (a int, b string) USING ").append(this.v2Source()).append(" PARTITIONED BY (B)").toString());
            this.checkPartitioning$1(sessionCatalog, "b");
            this.sql().apply((Object)new StringBuilder(79).append("CREATE OR REPLACE TABLE testcat.tbl (a int, b string) USING ").append(this.v2Source()).append(" PARTITIONED BY (B)").toString());
            this.checkPartitioning$1(testCatalog, "b");
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1764));
        this.test("tableCreation: partition column case sensitive resolution", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkFailure$1(new StringBuilder(60).append("CREATE TABLE tbl (a int, b string) USING ").append(this.v2Source()).append(" PARTITIONED BY (A)").toString());
            this.checkFailure$1(new StringBuilder(68).append("CREATE TABLE testcat.tbl (a int, b string) USING ").append(this.v2Source()).append(" PARTITIONED BY (A)").toString());
            this.checkFailure$1(new StringBuilder(71).append("CREATE OR REPLACE TABLE tbl (a int, b string) USING ").append(this.v2Source()).append(" PARTITIONED BY (B)").toString());
            this.checkFailure$1(new StringBuilder(79).append("CREATE OR REPLACE TABLE testcat.tbl (a int, b string) USING ").append(this.v2Source()).append(" PARTITIONED BY (B)").toString());
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1791));
        this.test("tableCreation: duplicate column names in the table definition", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String errorMsg = "Found duplicate column(s) in the table definition of";
            ((IterableLike)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)new Tuple2((Object)"a", (Object)"a")), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new Tuple2((Object)"aA", (Object)"Aa")), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)x0$6 -> {
                DataSourceV2SQLSuiteV1Filter.$anonfun$new$266(this, x0$6);
                return BoxedUnit.UNIT;
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1811));
        this.test("tableCreation: duplicate nested column names in the table definition", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)new Tuple2((Object)"a", (Object)"a")), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new Tuple2((Object)"aA", (Object)"Aa")), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)x0$7 -> {
            DataSourceV2SQLSuiteV1Filter.$anonfun$new$269(this, x0$7);
            return BoxedUnit.UNIT;
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1838));
        this.test("tableCreation: bucket column names not in table definition", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            AnalysisException x$285 = this.analysisException(new StringBuilder(73).append("CREATE TABLE tbl (a int, b string) USING ").append(this.v2Source()).append(" CLUSTERED BY (c) INTO 4 BUCKETS").toString());
            Object x$286 = null;
            scala.collection.immutable.Map x$287 = Predef$.MODULE$.Map().empty();
            Option x$288 = this.checkError$default$3();
            boolean x$289 = this.checkError$default$5();
            QueryContext[] x$290 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$285, null, x$288, x$287, x$289, x$290);
            AnalysisException x$291 = this.analysisException(new StringBuilder(81).append("CREATE TABLE testcat.tbl (a int, b string) ").append("USING ").append(this.v2Source()).append(" CLUSTERED BY (c) INTO 4 BUCKETS").toString());
            Object x$292 = null;
            scala.collection.immutable.Map x$293 = Predef$.MODULE$.Map().empty();
            Option x$294 = this.checkError$default$3();
            boolean x$295 = this.checkError$default$5();
            QueryContext[] x$296 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$291, null, x$294, x$293, x$295, x$296);
            AnalysisException x$297 = this.analysisException(new StringBuilder(84).append("CREATE OR REPLACE TABLE tbl (a int, b string) ").append("USING ").append(this.v2Source()).append(" CLUSTERED BY (c) INTO 4 BUCKETS").toString());
            Object x$298 = null;
            scala.collection.immutable.Map x$299 = Predef$.MODULE$.Map().empty();
            Option x$300 = this.checkError$default$3();
            boolean x$301 = this.checkError$default$5();
            QueryContext[] x$302 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$297, null, x$300, x$299, x$301, x$302);
            AnalysisException x$303 = this.analysisException(new StringBuilder(92).append("CREATE OR REPLACE TABLE testcat.tbl (a int, b string) ").append("USING ").append(this.v2Source()).append(" CLUSTERED BY (c) INTO 4 BUCKETS").toString());
            Object x$304 = null;
            scala.collection.immutable.Map x$305 = Predef$.MODULE$.Map().empty();
            Option x$306 = this.checkError$default$3();
            boolean x$307 = this.checkError$default$5();
            QueryContext[] x$308 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$303, null, x$306, x$305, x$307, x$308);
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1866));
        this.test("tableCreation: bucket column name containing dot", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            NamedReference[] references;
            Bool bool;
            Transform[] partitioning;
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("\n          |CREATE TABLE testcat.t (id int, `a.b` string) USING foo\n          |CLUSTERED BY (`a.b`) INTO 4 BUCKETS\n        ")).stripMargin());
            InMemoryTableCatalog testCatalog = (InMemoryTableCatalog)CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            Table table = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class))), (String)"t"));
            Transform[] $org_scalatest_assert_macro_left = partitioning = table.partitioning();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left2.value()) {
                String $org_scalatest_assert_macro_left3 = ((Transform)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitioning)).head()).name();
                String $org_scalatest_assert_macro_right2 = "bucket";
                String string = $org_scalatest_assert_macro_left3;
                String string2 = $org_scalatest_assert_macro_right2;
                bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            } else {
                bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right3 = bool;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1900));
            NamedReference[] $org_scalatest_assert_macro_left4 = references = ((Expression)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitioning)).head()).references();
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1902));
            Seq $org_scalatest_assert_macro_left5 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((NamedReference)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])references)).head()).fieldNames())).toSeq();
            Seq $org_scalatest_assert_macro_right5 = (Seq)new .colon.colon((Object)"a.b", (List)Nil$.MODULE$);
            Seq seq = $org_scalatest_assert_macro_left5;
            Seq seq2 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1903));
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1889));
        this.test("tableCreation: column repeated in partition columns", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)new Tuple2((Object)"a", (Object)"a")), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new Tuple2((Object)"aA", (Object)"Aa")), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)x0$8 -> {
            DataSourceV2SQLSuiteV1Filter.$anonfun$new$276(this, x0$8);
            return BoxedUnit.UNIT;
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1907));
        this.test("tableCreation: column repeated in bucket columns", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String errorMsg = "Found duplicate column(s) in the bucket definition";
            ((IterableLike)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)new Tuple2((Object)"a", (Object)"a")), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new Tuple2((Object)"aA", (Object)"Aa")), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)x0$9 -> {
                DataSourceV2SQLSuiteV1Filter.$anonfun$new$279(this, x0$9);
                return BoxedUnit.UNIT;
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1934));
        this.test("create table using - with sorted bucket", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String identifier = "testcat.table_name";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{identifier}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(140).append("CREATE TABLE ").append(identifier).append(" (a int, b string, c int, d int, e int, f int) USING").append(" ").append(this.v2Source()).append(" PARTITIONED BY (a, b) CLUSTERED BY (c, d) SORTED by (e, f) INTO 4 BUCKETS").toString());
                Dataset describe = this.spark().sql(new StringBuilder(9).append("DESCRIBE ").append(identifier).toString());
                String part1 = ((Row)describe.filter("col_name = 'Part 0'").select("data_type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).head()).getString(0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(part1);
                String $org_scalatest_assert_macro_right = "a";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1976));
                String part2 = ((Row)describe.filter("col_name = 'Part 1'").select("data_type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).head()).getString(0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(part2);
                String $org_scalatest_assert_macro_right2 = "b";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1980));
                String part3 = ((Row)describe.filter("col_name = 'Part 2'").select("data_type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).head()).getString(0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(part3);
                String $org_scalatest_assert_macro_right3 = "sorted_bucket(c, d, 4, e, f)";
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1984));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1967));
        this.test("REFRESH TABLE: v2 table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(48).append("CREATE TABLE ").append(t).append(" (id bigint, data string) USING foo").toString());
                InMemoryTableCatalog testCatalog = (InMemoryTableCatalog)CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
                Identifier identifier = Identifier.of((String[])((String[])((Object[])new String[]{"ns1", "ns2"})), (String)"tbl");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(testCatalog.isTableInvalidated(identifier), "testCatalog.isTableInvalidated(identifier)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1996));
                this.sql().apply((Object)new StringBuilder(14).append("REFRESH TABLE ").append(t).toString());
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(testCatalog.isTableInvalidated(identifier), "testCatalog.isTableInvalidated(identifier)", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1998));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1988));
        this.test("SPARK-32990: REFRESH TABLE should resolve to a temporary view first", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"testcat.ns.t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE testcat.ns.t (id bigint) USING foo");
            this.sql().apply((Object)"CREATE TEMPORARY VIEW t AS SELECT 2");
            this.sql().apply((Object)"USE testcat.ns");
            InMemoryTableCatalog testCatalog = (InMemoryTableCatalog)CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            Identifier identifier = Identifier.of((String[])((String[])((Object[])new String[]{"ns"})), (String)"t");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(testCatalog.isTableInvalidated(identifier), "testCatalog.isTableInvalidated(identifier)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2012));
            this.sql().apply((Object)"REFRESH TABLE t");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(testCatalog.isTableInvalidated(identifier), "testCatalog.isTableInvalidated(identifier)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2014));
        })), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2002));
        this.test("SPARK-33435, SPARK-34099: REFRESH TABLE should refresh all caches referencing the table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tblName = "testcat.ns.t";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tblName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(35).append("CREATE TABLE ").append(tblName).append(" (id bigint) USING foo").toString());
                this.sql().apply((Object)new StringBuilder(21).append("INSERT INTO ").append(tblName).append(" SELECT 0").toString());
                this.sql().apply((Object)new StringBuilder(32).append("CACHE TABLE t AS SELECT id FROM ").append(tblName).toString());
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> this.spark().table(tblName), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)})));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> this.spark().table("t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)})));
                this.sql().apply((Object)new StringBuilder(21).append("INSERT INTO ").append(tblName).append(" SELECT 1").toString());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.spark().sharedState().cacheManager().lookupCachedData(this.spark().table("t")).isDefined(), "DataSourceV2SQLSuiteV1Filter.this.spark.sharedState.cacheManager.lookupCachedData(DataSourceV2SQLSuiteV1Filter.this.spark.table(\"t\")).isDefined", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2031));
                this.sql().apply((Object)new StringBuilder(14).append("REFRESH TABLE ").append(tblName).toString());
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.spark().sharedState().cacheManager().lookupCachedData(this.spark().table("t")).isDefined(), "DataSourceV2SQLSuiteV1Filter.this.spark.sharedState.cacheManager.lookupCachedData(DataSourceV2SQLSuiteV1Filter.this.spark.table(\"t\")).isDefined", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2033));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> this.spark().table(tblName), (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$))));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> this.spark().table("t"), (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$))));
            }));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2019));
        this.test("SPARK-33653: REFRESH TABLE should recache the target table itself", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tblName = "testcat.ns.t";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tblName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(35).append("CREATE TABLE ").append(tblName).append(" (id bigint) USING foo").toString());
                Option $org_scalatest_assert_macro_left = this.spark().sharedState().cacheManager().lookupCachedData(this.spark().table(tblName));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2046));
                this.sql().apply((Object)new StringBuilder(14).append("REFRESH TABLE ").append(tblName).toString());
                Option $org_scalatest_assert_macro_left2 = this.spark().sharedState().cacheManager().lookupCachedData(this.spark().table(tblName));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2048));
                this.sql().apply((Object)new StringBuilder(12).append("CACHE TABLE ").append(tblName).toString());
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(this.spark().sharedState().cacheManager().lookupCachedData(this.spark().table(tblName)).isDefined(), "DataSourceV2SQLSuiteV1Filter.this.spark.sharedState.cacheManager.lookupCachedData(DataSourceV2SQLSuiteV1Filter.this.spark.table(tblName)).isDefined", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2053));
                this.sql().apply((Object)new StringBuilder(14).append("REFRESH TABLE ").append(tblName).toString());
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(this.spark().sharedState().cacheManager().lookupCachedData(this.spark().table(tblName)).isDefined(), "DataSourceV2SQLSuiteV1Filter.this.spark.sharedState.cacheManager.lookupCachedData(DataSourceV2SQLSuiteV1Filter.this.spark.table(tblName)).isDefined", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2055));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2040));
        this.test("REPLACE TABLE: v1 table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            AnalysisException e = (AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(42).append("CREATE OR REPLACE TABLE tbl (a int) USING ").append(SimpleScanSource.class.getName()).toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2060))));
            this.checkError((SparkThrowable)e, "UNSUPPORTED_FEATURE.TABLE_OPERATION", "0A000", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)"`spark_catalog`.`default`.`tbl`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)"REPLACE TABLE")})));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2059));
        this.test("DeleteFrom: - delete with invalid predicate", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(78).append("CREATE TABLE ").append(t).append(" (id bigint, data string, p int) USING foo PARTITIONED BY (id, p)").toString());
                this.sql().apply((Object)new StringBuilder(60).append("INSERT INTO ").append(t).append(" VALUES (2L, 'a', 2), (2L, 'b', 3), (3L, 'c', 3)").toString());
                AnalysisException x$357 = (AnalysisException)((Object)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(37).append("DELETE FROM ").append(t).append(" WHERE id = 2 AND id = id").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2077)))));
                String x$358 = "_LEGACY_ERROR_TEMP_1110";
                scala.collection.immutable.Map x$359 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"table"), (Object)"testcat.ns1.ns2.tbl"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"filters"), (Object)"[id = 2, id = id]")}));
                Option x$360 = this.checkError$default$3();
                boolean x$361 = this.checkError$default$5();
                QueryContext[] x$362 = this.checkError$default$6();
                this.checkError((SparkThrowable)x$357, x$358, x$360, x$359, x$361, x$362);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)this.spark().table(t).count()));
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2084));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2071));
        this.test("UPDATE TABLE", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(134).append("\n           |CREATE TABLE ").append(t).append(" (id bigint, name string, age int, p int)\n           |USING foo\n           |PARTITIONED BY (id, p)\n         ").toString())).stripMargin());
                this.checkError((SparkThrowable)this.analysisException("UPDATE dummy SET name='abc'"), "TABLE_OR_VIEW_NOT_FOUND", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationName"), (Object)"`dummy`")})), (QueryContext)this.ExpectedContext().apply("dummy", 7, 11));
                this.checkError((SparkThrowable)this.analysisException(new StringBuilder(23).append("UPDATE ").append(t).append(" SET dummy='abc'").toString()), "UNRESOLVED_COLUMN.WITH_SUGGESTION", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"objectName"), (Object)"`dummy`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"proposal"), (Object)"`age`, `id`, `name`, `p`")})), (QueryContext)this.ExpectedContext().apply("dummy='abc'", 31, 41));
                this.checkError((SparkThrowable)this.analysisException(new StringBuilder(36).append("UPDATE ").append(t).append(" SET name='abc' WHERE dummy=1").toString()), "UNRESOLVED_COLUMN.WITH_SUGGESTION", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"objectName"), (Object)"`dummy`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"proposal"), (Object)"`age`, `id`, `name`, `p`")})), (QueryContext)this.ExpectedContext().apply("dummy", 48, 52));
                SparkUnsupportedOperationException x$363 = (SparkUnsupportedOperationException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(43).append("UPDATE ").append(t).append(" SET name='Robert', age=32 WHERE p=1").toString()), ClassTag$.MODULE$.apply(SparkUnsupportedOperationException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2134));
                String x$364 = "_LEGACY_ERROR_TEMP_2096";
                scala.collection.immutable.Map x$365 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ddl"), (Object)"UPDATE TABLE")}));
                Option x$366 = this.checkError$default$3();
                boolean x$367 = this.checkError$default$5();
                QueryContext[] x$368 = this.checkError$default$6();
                this.checkError((SparkThrowable)x$363, x$364, x$366, x$365, x$367, x$368);
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2088));
        this.test("MERGE INTO TABLE", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String target = "testcat.ns1.ns2.target";
            String source = "testcat.ns1.ns2.source";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{target, source}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(134).append("\n           |CREATE TABLE ").append(target).append(" (id bigint, name string, age int, p int)\n           |USING foo\n           |PARTITIONED BY (id, p)\n         ").toString())).stripMargin());
                this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(134).append("\n           |CREATE TABLE ").append(source).append(" (id bigint, name string, age int, p int)\n           |USING foo\n           |PARTITIONED BY (id, p)\n         ").toString())).stripMargin());
                this.checkError((SparkThrowable)this.analysisException(new StringOps(Predef$.MODULE$.augmentString("\n             |MERGE INTO testcat.ns1.ns2.dummy AS target\n             |USING testcat.ns1.ns2.source AS source\n             |ON target.id = source.id\n             |WHEN MATCHED AND (target.age < 10) THEN DELETE\n             |WHEN MATCHED AND (target.age > 10) THEN UPDATE SET *\n             |WHEN NOT MATCHED AND (target.col2='insert')\n             |THEN INSERT *\n           ")).stripMargin()), "TABLE_OR_VIEW_NOT_FOUND", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationName"), (Object)"`testcat`.`ns1`.`ns2`.`dummy`")})), (QueryContext)this.ExpectedContext().apply("testcat.ns1.ns2.dummy", 12, 32));
                this.checkError((SparkThrowable)this.analysisException(new StringOps(Predef$.MODULE$.augmentString("\n             |MERGE INTO testcat.ns1.ns2.target AS target\n             |USING testcat.ns1.ns2.dummy AS source\n             |ON target.id = source.id\n             |WHEN MATCHED AND (target.age < 10) THEN DELETE\n             |WHEN MATCHED AND (target.age > 10) THEN UPDATE SET *\n             |WHEN NOT MATCHED AND (target.col2='insert')\n             |THEN INSERT *\n           ")).stripMargin()), "TABLE_OR_VIEW_NOT_FOUND", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationName"), (Object)"`testcat`.`ns1`.`ns2`.`dummy`")})), (QueryContext)this.ExpectedContext().apply("testcat.ns1.ns2.dummy", 51, 71));
                String sql1 = new StringOps(Predef$.MODULE$.augmentString("MERGE INTO testcat.ns1.ns2.target AS target\n           |USING testcat.ns1.ns2.source AS source\n           |ON target.id = source.id\n           |WHEN MATCHED AND (target.age < 10) THEN DELETE\n           |WHEN MATCHED AND (target.age > 10) THEN UPDATE SET target.dummy = source.age\n           |WHEN NOT MATCHED AND (target.col2='insert')\n           |THEN INSERT *")).stripMargin();
                this.checkError((SparkThrowable)this.analysisException(sql1), "UNRESOLVED_COLUMN.WITH_SUGGESTION", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"objectName"), (Object)"`target`.`dummy`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"proposal"), (Object)"`age`, `id`, `name`, `p`")})), (QueryContext)this.ExpectedContext().apply("target.dummy = source.age", 206, 230));
                this.checkError((SparkThrowable)this.analysisException(new StringOps(Predef$.MODULE$.augmentString("MERGE INTO testcat.ns1.ns2.target AS target\n             |USING testcat.ns1.ns2.source AS source\n             |ON target.id = source.id\n             |WHEN MATCHED AND (target.age < 10) THEN DELETE\n             |WHEN MATCHED AND (target.age > 10) THEN UPDATE SET target.age = source.dummy\n             |WHEN NOT MATCHED AND (target.col2='insert')\n             |THEN INSERT *")).stripMargin()), "UNRESOLVED_COLUMN.WITH_SUGGESTION", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"objectName"), (Object)"`source`.`dummy`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"proposal"), (Object)"`age`, `age`, `id`, `id`, `name`, `name`, `p`, `p`")})), (QueryContext)this.ExpectedContext().apply("source.dummy", 219, 230));
                SparkUnsupportedOperationException x$369 = (SparkUnsupportedOperationException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("MERGE INTO testcat.ns1.ns2.target AS target\n               |USING testcat.ns1.ns2.source AS source\n               |ON target.id = source.id\n               |WHEN MATCHED AND (target.p < 0) THEN DELETE\n               |WHEN MATCHED AND (target.p > 0) THEN UPDATE SET *\n               |WHEN NOT MATCHED THEN INSERT *")).stripMargin()), ClassTag$.MODULE$.apply(SparkUnsupportedOperationException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2234));
                String x$370 = "_LEGACY_ERROR_TEMP_2096";
                scala.collection.immutable.Map x$371 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ddl"), (Object)"MERGE INTO TABLE")}));
                Option x$372 = this.checkError$default$3();
                boolean x$373 = this.checkError$default$5();
                QueryContext[] x$374 = this.checkError$default$6();
                this.checkError((SparkThrowable)x$369, x$370, x$372, x$371, x$373, x$374);
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2143));
        this.test("rename table by ALTER VIEW", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"testcat.ns1.new"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE testcat.ns1.ns2.old USING foo AS SELECT id, data FROM source");
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SHOW TABLES FROM testcat.ns1.ns2"), (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"ns1.ns2", "old", BoxesRunTime.boxToBoolean((boolean)false)})), (List)Nil$.MODULE$)));
            AnalysisException x$375 = (AnalysisException)((Object)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"ALTER VIEW testcat.ns1.ns2.old RENAME TO ns1.new"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2253)))));
            String x$376 = "_LEGACY_ERROR_TEMP_1123";
            scala.collection.immutable.Map x$377 = Predef$.MODULE$.Map().empty();
            Option x$378 = this.checkError$default$3();
            boolean x$379 = this.checkError$default$5();
            QueryContext[] x$380 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$375, x$376, x$378, x$377, x$379, x$380);
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2248));
        this.test("AlterTable: renaming views are not supported", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            AnalysisException e = (AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"ALTER VIEW testcat.ns.tbl RENAME TO ns.view"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2262))));
            this.checkErrorTableNotFound((SparkThrowable)e, "`testcat`.`ns`.`tbl`", this.ExpectedContext().apply("testcat.ns.tbl", 11, 10 + "testcat.ns.tbl".length()));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2261));
        this.test("ANALYZE TABLE", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.spark().sql(new StringBuilder(48).append("CREATE TABLE ").append(t).append(" (id bigint, data string) USING foo").toString());
                this.testNotSupportedV2Command("ANALYZE TABLE", new StringBuilder(19).append(t).append(" COMPUTE STATISTICS").toString(), this.testNotSupportedV2Command$default$3());
                this.testNotSupportedV2Command("ANALYZE TABLE", new StringBuilder(35).append(t).append(" COMPUTE STATISTICS FOR ALL COLUMNS").toString(), this.testNotSupportedV2Command$default$3());
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2269));
        this.test("MSCK REPAIR TABLE", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.spark().sql(new StringBuilder(48).append("CREATE TABLE ").append(t).append(" (id bigint, data string) USING foo").toString());
                this.testNotSupportedV2Command("MSCK REPAIR TABLE", t, this.testNotSupportedV2Command$default$3());
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2278));
        this.test("LOAD DATA INTO TABLE", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(115).append("\n           |CREATE TABLE ").append(t).append(" (id bigint, data string)\n           |USING foo\n           |PARTITIONED BY (id)\n         ").toString())).stripMargin());
                this.testNotSupportedV2Command("LOAD DATA", new StringBuilder(29).append("INPATH 'filepath' INTO TABLE ").append(t).toString(), this.testNotSupportedV2Command$default$3());
                this.testNotSupportedV2Command("LOAD DATA", new StringBuilder(35).append("LOCAL INPATH 'filepath' INTO TABLE ").append(t).toString(), this.testNotSupportedV2Command$default$3());
                this.testNotSupportedV2Command("LOAD DATA", new StringBuilder(45).append("LOCAL INPATH 'filepath' OVERWRITE INTO TABLE ").append(t).toString(), this.testNotSupportedV2Command$default$3());
                this.testNotSupportedV2Command("LOAD DATA", new StringBuilder(61).append("LOCAL INPATH 'filepath' OVERWRITE INTO TABLE ").append(t).append(" PARTITION(id=1)").toString(), this.testNotSupportedV2Command$default$3());
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2286));
        this.test("CACHE/UNCACHE TABLE", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String t = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.spark().sql(new StringBuilder(48).append("CREATE TABLE ").append(t).append(" (id bigint, data string) USING foo").toString());
                this.sql().apply((Object)new StringBuilder(12).append("CACHE TABLE ").append(t).toString());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.isCached$1(t), "isCached(t)", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2313));
                this.sql().apply((Object)new StringBuilder(14).append("UNCACHE TABLE ").append(t).toString());
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.isCached$1(t), "isCached(t)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2316));
            });
            AnalysisException e = (AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("UNCACHE TABLE ").append(t).toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2320))));
            this.checkErrorTableNotFound((SparkThrowable)e, "`testcat`.`ns1`.`ns2`.`tbl`", this.ExpectedContext().apply(t, 14, 13 + t.length()));
            return (Dataset)this.sql().apply((Object)new StringBuilder(24).append("UNCACHE TABLE IF EXISTS ").append(t).toString());
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2304));
        this.test("SHOW COLUMNS", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.spark().sql(new StringBuilder(48).append("CREATE TABLE ").append(t).append(" (id bigint, data string) USING foo").toString());
                this.testNotSupportedV2Command("SHOW COLUMNS", new StringBuilder(5).append("FROM ").append(t).toString(), this.testNotSupportedV2Command$default$3());
                this.testNotSupportedV2Command("SHOW COLUMNS", new StringBuilder(3).append("IN ").append(t).toString(), this.testNotSupportedV2Command$default$3());
                this.testNotSupportedV2Command("SHOW COLUMNS", "FROM tbl IN testcat.ns1.ns2", this.testNotSupportedV2Command$default$3());
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2330));
        this.test("ALTER TABLE ... SET [SERDE|SERDEPROPERTIES]", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.spark().sql(new StringBuilder(48).append("CREATE TABLE ").append(t).append(" (id bigint, data string) USING foo").toString());
                this.testNotSupportedV2Command("ALTER TABLE", new StringBuilder(23).append(t).append(" SET SERDE 'test_serde'").toString(), (Option<String>)new Some((Object)"ALTER TABLE ... SET [SERDE|SERDEPROPERTIES]"));
                this.testNotSupportedV2Command("ALTER TABLE", new StringBuilder(32).append(t).append(" SET SERDEPROPERTIES ('a' = 'b')").toString(), (Option<String>)new Some((Object)"ALTER TABLE ... SET [SERDE|SERDEPROPERTIES]"));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2341));
        this.test("CREATE VIEW", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String v = "testcat.ns1.ns2.v";
            AnalysisException x$381 = (AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(24).append("CREATE VIEW ").append(v).append(" AS SELECT 1").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2358))));
            String x$382 = "_LEGACY_ERROR_TEMP_1184";
            scala.collection.immutable.Map x$383 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"plugin"), (Object)"testcat"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ability"), (Object)"views")}));
            Option x$384 = this.checkError$default$3();
            boolean x$385 = this.checkError$default$5();
            QueryContext[] x$386 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$381, x$382, x$384, x$383, x$385, x$386);
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2355));
        this.test("global temp view should not be masked by v2 catalog", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            String globalTempDB = (String)this.spark().conf().get(StaticSQLConf$.MODULE$.GLOBAL_TEMP_DATABASE());
            this.registerCatalog(globalTempDB, InMemoryTableCatalog.class);
            try {
                this.sql().apply((Object)"create global temp view v as select 1");
                this.sql().apply((Object)new StringBuilder(26).append("alter view ").append(globalTempDB).append(".v rename to v2").toString());
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> this.spark().table(new StringBuilder(3).append(globalTempDB).append(".v2").toString()), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
                object = this.sql().apply((Object)new StringBuilder(13).append("drop view ").append(globalTempDB).append(".v2").toString());
            }
            finally {
                this.spark().sharedState().globalTempViewManager().clear();
            }
            return object;
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2365));
        this.test("SPARK-30104: global temp db is used as a table name under v2 catalog", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String globalTempDB = (String)this.spark().conf().get(StaticSQLConf$.MODULE$.GLOBAL_TEMP_DATABASE());
            String t = new StringBuilder(8).append("testcat.").append(globalTempDB).toString();
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(48).append("CREATE TABLE ").append(t).append(" (id bigint, data string) USING foo").toString());
                this.sql().apply((Object)"USE testcat");
                this.sql().apply((Object)new StringBuilder(15).append("DESCRIBE TABLE ").append(globalTempDB).toString());
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2379));
        this.test("SPARK-30104: v2 catalog named global_temp will be masked", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String globalTempDB = (String)this.spark().conf().get(StaticSQLConf$.MODULE$.GLOBAL_TEMP_DATABASE());
            this.registerCatalog(globalTempDB, InMemoryTableCatalog.class);
            AnalysisException x$387 = (AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(61).append("CREATE TABLE ").append(globalTempDB).append(".ns1.ns2.tbl (id bigint, data string) USING json").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2394))));
            String x$388 = "REQUIRES_SINGLE_PART_NAMESPACE";
            scala.collection.immutable.Map x$389 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sessionCatalog"), (Object)"spark_catalog"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"namespace"), (Object)"`global_temp`.`ns1`.`ns2`")}));
            Option x$390 = this.checkError$default$3();
            boolean x$391 = this.checkError$default$5();
            QueryContext[] x$392 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$387, x$388, x$390, x$389, x$391, x$392);
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2390));
        this.test("table name same as catalog can be used", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"testcat.testcat"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE testcat.testcat (id bigint, data string) USING foo");
            this.sql().apply((Object)"USE testcat");
            this.sql().apply((Object)"DESCRIBE TABLE testcat");
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2405));
        this.test("SPARK-30001: session catalog name can be specified in SQL statements", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().conf().unset(SQLConf$.MODULE$.V2_SESSION_CATALOG_IMPLEMENTATION().key());
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)"CREATE TABLE t USING json AS SELECT 1 AS i");
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"select * from t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"select * from spark_catalog.default.t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2414));
        this.test("SPARK-30885: v1 table name should be fully qualified", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertWrongTableIdent$1();
            this.spark().conf().unset(SQLConf$.MODULE$.V2_SESSION_CATALOG_IMPLEMENTATION().key());
            this.assertWrongTableIdent$1();
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2425));
        this.test("SPARK-30259: session catalog can be specified in CREATE TABLE AS SELECT command", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Identifier ident = Identifier.of((String[])((String[])((Object[])new String[]{"default"})), (String)"tbl");
            this.sql().apply((Object)"CREATE TABLE spark_catalog.default.tbl USING json AS SELECT 1 AS i");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("spark_catalog")).asTableCatalog().tableExists(ident)));
            boolean $org_scalatest_assert_macro_right = true;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2468));
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2464));
        this.test("SPARK-30259: session catalog can be specified in CREATE TABLE command", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Identifier ident = Identifier.of((String[])((String[])((Object[])new String[]{"default"})), (String)"tbl");
            this.sql().apply((Object)"CREATE TABLE spark_catalog.default.tbl (col string) USING json");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("spark_catalog")).asTableCatalog().tableExists(ident)));
            boolean $org_scalatest_assert_macro_right = true;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2476));
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2472));
        this.test("SPARK-30094: current namespace is used during table resolution", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().conf().unset(SQLConf$.MODULE$.V2_SESSION_CATALOG_IMPLEMENTATION().key());
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark_catalog.default.t", "testcat.ns.t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)"CREATE TABLE t USING parquet AS SELECT 1");
                this.sql().apply((Object)"CREATE TABLE testcat.ns.t USING parquet AS SELECT 2");
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
                this.sql().apply((Object)"USE testcat.ns");
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)})));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2480));
        this.test("SPARK-30284: CREATE VIEW should track the current catalog and namespace", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().conf().unset(SQLConf$.MODULE$.V2_SESSION_CATALOG_IMPLEMENTATION().key());
            String sessionCatalogName = CatalogManager$.MODULE$.SESSION_CATALOG_NAME();
            this.sql().apply((Object)"CREATE NAMESPACE testcat.ns1.ns2");
            this.sql().apply((Object)"USE testcat.ns1.ns2");
            this.sql().apply((Object)"CREATE TABLE t USING foo AS SELECT 1 col");
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> this.spark().table("t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
            this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.spark().range(10L).createTempView("t");
                this.withView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(10).append(sessionCatalogName).append(".default.v").toString()}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    AnalysisException x$393 = (AnalysisException)((Object)((Object)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(41).append("CREATE VIEW ").append(sessionCatalogName).append(".default.v AS SELECT * FROM t").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2509))))));
                    String x$394 = "INVALID_TEMP_OBJ_REFERENCE";
                    scala.collection.immutable.Map x$395 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"obj"), (Object)"VIEW"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"objName"), (Object)"`spark_catalog`.`default`.`v`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tempObj"), (Object)"VIEW"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tempObjName"), (Object)"`t`")}));
                    Option x$396 = this.checkError$default$3();
                    boolean x$397 = this.checkError$default$5();
                    QueryContext[] x$398 = this.checkError$default$6();
                    this.checkError((SparkThrowable)x$393, x$394, x$396, x$395, x$397, x$398);
                });
            });
            this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(10).append(sessionCatalogName).append(".default.v").toString()}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(67).append("CREATE VIEW ").append(sessionCatalogName).append(".default.v ").append("AS SELECT t1.col FROM t t1 JOIN ns1.ns2.t t2").toString());
                this.sql().apply((Object)new StringBuilder(4).append("USE ").append(sessionCatalogName).toString());
                this.spark().range(10L).createTempView("t");
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> this.spark().table("v"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
            }));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2495));
        this.test("COMMENT ON NAMESPACE", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().conf().unset(SQLConf$.MODULE$.V2_SESSION_CATALOG_IMPLEMENTATION().key());
            this.sql().apply((Object)"CREATE NAMESPACE ns");
            this.checkNamespaceComment("ns", "minor revision");
            this.checkNamespaceComment("ns", null);
            this.checkNamespaceComment("ns", "NULL");
            AnalysisException x$399 = (AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"COMMENT ON NAMESPACE abc IS NULL"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2543))));
            String x$400 = "SCHEMA_NOT_FOUND";
            scala.collection.immutable.Map x$401 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schemaName"), (Object)"`abc`")}));
            Option x$402 = this.checkError$default$3();
            boolean x$403 = this.checkError$default$5();
            QueryContext[] x$404 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$399, x$400, x$402, x$401, x$403, x$404);
            this.sql().apply((Object)"CREATE NAMESPACE testcat.ns1");
            this.checkNamespaceComment("testcat.ns1", "minor revision");
            this.checkNamespaceComment("testcat.ns1", null);
            this.checkNamespaceComment("testcat.ns1", "NULL");
            AnalysisException x$405 = (AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"COMMENT ON NAMESPACE testcat.abc IS NULL"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2553))));
            String x$406 = "SCHEMA_NOT_FOUND";
            scala.collection.immutable.Map x$407 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schemaName"), (Object)"`abc`")}));
            Option x$408 = this.checkError$default$3();
            boolean x$409 = this.checkError$default$5();
            QueryContext[] x$410 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$405, x$406, x$408, x$407, x$409, x$410);
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2533));
        this.test("COMMENT ON TABLE", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().conf().unset(SQLConf$.MODULE$.V2_SESSION_CATALOG_IMPLEMENTATION().key());
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)"CREATE TABLE t(k int) USING json");
                this.checkTableComment("t", "minor revision");
                this.checkTableComment("t", null);
                this.checkTableComment("t", "NULL");
            });
            String sql1 = "COMMENT ON TABLE abc IS NULL";
            this.checkError((SparkThrowable)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)sql1), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2579)), "TABLE_OR_VIEW_NOT_FOUND", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationName"), (Object)"`abc`")})), (QueryContext)this.ExpectedContext().apply("abc", 17, 19));
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"testcat.ns1.ns2.t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)"CREATE TABLE testcat.ns1.ns2.t(k int) USING foo");
                this.checkTableComment("testcat.ns1.ns2.t", "minor revision");
                this.checkTableComment("testcat.ns1.ns2.t", null);
                this.checkTableComment("testcat.ns1.ns2.t", "NULL");
            });
            String sql2 = "COMMENT ON TABLE testcat.abc IS NULL";
            this.checkError((SparkThrowable)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)sql2), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2593)), "TABLE_OR_VIEW_NOT_FOUND", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationName"), (Object)"`testcat`.`abc`")})), (QueryContext)this.ExpectedContext().apply("testcat.abc", 17, 27));
            String globalTempDB = (String)this.spark().conf().get(StaticSQLConf$.MODULE$.GLOBAL_TEMP_DATABASE());
            this.registerCatalog(globalTempDB, InMemoryTableCatalog.class);
            this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"v"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)"create global temp view v as select 1");
                this.checkError((SparkThrowable)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"COMMENT ON TABLE global_temp.v IS NULL"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2603)), "_LEGACY_ERROR_TEMP_1013", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nameParts"), (Object)"global_temp.v"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"viewStr"), (Object)"temp view"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cmd"), (Object)"COMMENT ON TABLE"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hintStr"), (Object)"")})), (QueryContext)this.ExpectedContext().apply("global_temp.v", 17, 29));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2567));
        this.test("SPARK-31015: star expression should work for qualified column names for v2 tables", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(48).append("CREATE TABLE ").append(t).append(" (id bigint, name string) USING foo").toString());
                this.sql().apply((Object)new StringBuilder(32).append("INSERT INTO ").append(t).append(" VALUES (1, 'hello')").toString());
                this.check$2(t);
                this.sql().apply((Object)"USE testcat.ns1.ns2");
                this.check$2("tbl");
                this.checkError((SparkThrowable)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(30).append("SELECT ns1.ns2.ns3.tbl.* from ").append(t).toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2642)), "CANNOT_RESOLVE_STAR_EXPAND", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetString"), (Object)"`ns1`.`ns2`.`ns3`.`tbl`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columns"), (Object)"`id`, `name`")})), (QueryContext)this.ExpectedContext().apply("ns1.ns2.ns3.tbl.*", 7, 23));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2621));
        this.test("SPARK-32168: INSERT OVERWRITE - hidden days partition - dynamic mode", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARTITION_OVERWRITE_MODE().key()), (Object)SQLConf.PartitionOverwriteMode$.MODULE$.DYNAMIC().toString())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t1 = new StringBuilder(3).append(this.catalogAndNamespace()).append("tbl").toString();
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t1}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuiteV1Filter.class.getClassLoader());
                public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator120$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.sql.Timestamp").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator120$1(DataSourceV2SQLSuiteV1Filter $outer) {
                    }
                }
                Dataset df = this.spark().createDataFrame((Seq)new .colon.colon((Object)new Tuple2((Object)DataSourceV2SQLSuiteV1Filter.testTimestamp$1(1), (Object)"a"), (List)new .colon.colon((Object)new Tuple2((Object)DataSourceV2SQLSuiteV1Filter.testTimestamp$1(2), (Object)"b"), (List)new .colon.colon((Object)new Tuple2((Object)DataSourceV2SQLSuiteV1Filter.testTimestamp$1(3), (Object)"c"), (List)Nil$.MODULE$))), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator120$1(null))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ts", "data"}));
                df.createOrReplaceTempView("source_view");
                this.sql().apply((Object)new StringBuilder(74).append("CREATE TABLE ").append(t1).append(" (ts timestamp, data string) ").append("USING ").append(this.v2Format()).append(" PARTITIONED BY (days(ts))").toString());
                this.sql().apply((Object)new StringBuilder(131).append("INSERT INTO ").append(t1).append(" VALUES ").append("(CAST(date_add('2020-01-01', 2) AS timestamp), 'dummy'), ").append("(CAST(date_add('2020-01-01', 4) AS timestamp), 'keep')").toString());
                this.sql().apply((Object)new StringBuilder(56).append("INSERT OVERWRITE TABLE ").append(t1).append(" SELECT ts, data FROM source_view").toString());
                JavaUniverse $u2 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuiteV1Filter.class.getClassLoader());
                public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator121$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.sql.Timestamp").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator121$1(DataSourceV2SQLSuiteV1Filter $outer) {
                    }
                }
                Dataset expected = this.spark().createDataFrame((Seq)new .colon.colon((Object)new Tuple2((Object)DataSourceV2SQLSuiteV1Filter.testTimestamp$1(1), (Object)"a"), (List)new .colon.colon((Object)new Tuple2((Object)DataSourceV2SQLSuiteV1Filter.testTimestamp$1(2), (Object)"b"), (List)new .colon.colon((Object)new Tuple2((Object)DataSourceV2SQLSuiteV1Filter.testTimestamp$1(3), (Object)"c"), (List)new .colon.colon((Object)new Tuple2((Object)DataSourceV2SQLSuiteV1Filter.testTimestamp$1(4), (Object)"keep"), (List)Nil$.MODULE$)))), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator121$1(null))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ts", "data"}));
                this.verifyTable(t1, (Dataset<Row>)expected);
            });
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2653));
        this.test("SPARK-33505: insert into partitioned table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testpart.ns1.ns2.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(115).append("\n        |CREATE TABLE ").append(t).append(" (id bigint, city string, data string)\n        |USING foo\n        |PARTITIONED BY (id, city)").toString())).stripMargin());
                InMemoryPartitionTable partTable = (InMemoryPartitionTable)CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testpart")).asTableCatalog().loadTable(Identifier.of((String[])((String[])((Object[])new String[]{"ns1", "ns2"})), (String)"tbl"));
                InternalRow expectedPartitionIdent = InternalRow$.MODULE$.fromSeq((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), UTF8String.fromString((String)"NY")})));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(partTable.partitionExists(expectedPartitionIdent), "partTable.partitionExists(expectedPartitionIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2695));
                this.sql().apply((Object)new StringBuilder(56).append("INSERT INTO ").append(t).append(" PARTITION(id = 1, city = 'NY') SELECT 'abc'").toString());
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(partTable.partitionExists(expectedPartitionIdent), "partTable.partitionExists(expectedPartitionIdent)", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2697));
                this.sql().apply((Object)new StringBuilder(56).append("INSERT INTO ").append(t).append(" PARTITION(id = 1, city = 'NY') SELECT 'def'").toString());
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(partTable.partitionExists(expectedPartitionIdent), "partTable.partitionExists(expectedPartitionIdent)", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2700));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2685));
        this.test("View commands are not supported in v2 catalogs", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.validateViewCommand$1("DROP VIEW testcat.v");
            this.validateViewCommand$1("ALTER VIEW testcat.v SET TBLPROPERTIES ('key' = 'val')");
            this.validateViewCommand$1("ALTER VIEW testcat.v UNSET TBLPROPERTIES ('key')");
            this.validateViewCommand$1("ALTER VIEW testcat.v AS SELECT 1");
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2704));
        this.test("SPARK-33924: INSERT INTO .. PARTITION preserves the partition location", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testpart.ns1.ns2.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(115).append("\n        |CREATE TABLE ").append(t).append(" (id bigint, city string, data string)\n        |USING foo\n        |PARTITIONED BY (id, city)").toString())).stripMargin());
                InMemoryPartitionTable partTable = (InMemoryPartitionTable)CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testpart")).asTableCatalog().loadTable(Identifier.of((String[])((String[])((Object[])new String[]{"ns1", "ns2"})), (String)"tbl"));
                String loc = "partition_location";
                this.sql().apply((Object)new StringBuilder(60).append("ALTER TABLE ").append(t).append(" ADD PARTITION (id = 1, city = 'NY') LOCATION '").append(loc).append("'").toString());
                InternalRow ident = InternalRow$.MODULE$.fromSeq((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), UTF8String.fromString((String)"NY")})));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(partTable.loadPartitionMetadata(ident).get("location"));
                String $org_scalatest_assert_macro_right = loc;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2733));
                this.sql().apply((Object)new StringBuilder(56).append("INSERT INTO ").append(t).append(" PARTITION(id = 1, city = 'NY') SELECT 'abc'").toString());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(partTable.loadPartitionMetadata(ident).get("location"));
                String $org_scalatest_assert_macro_right2 = loc;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2736));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2719));
        this.test("SPARK-34468: rename table in place when the destination name has single part", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tbl = new StringBuilder(7).append(this.catalogAndNamespace()).append("src_tbl").toString();
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tbl}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(29).append("CREATE TABLE ").append(tbl).append(" (c0 INT) USING ").append(this.v2Format()).toString());
                this.sql().apply((Object)new StringBuilder(21).append("INSERT INTO ").append(tbl).append(" SELECT 0").toString());
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SHOW TABLES FROM testcat.ns1.ns2 LIKE 'new_tbl'"), (Seq<Row>)Nil$.MODULE$);
                this.sql().apply((Object)new StringBuilder(30).append("ALTER TABLE ").append(tbl).append(" RENAME TO new_tbl").toString());
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SHOW TABLES FROM testcat.ns1.ns2 LIKE 'new_tbl'"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"ns1.ns2", "new_tbl", BoxesRunTime.boxToBoolean((boolean)false)})));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(22).append("SELECT c0 FROM ").append(this.catalogAndNamespace()).append("new_tbl").toString()), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)})));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2740));
        this.test("SPARK-36481: Test for SET CATALOG statement", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            CatalogManager catalogManager = this.spark().sessionState().catalogManager();
            String $org_scalatest_assert_macro_left = catalogManager.currentCatalog().name();
            String $org_scalatest_assert_macro_right = CatalogManager$.MODULE$.SESSION_CATALOG_NAME();
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2756));
            this.sql().apply((Object)"SET CATALOG testcat");
            String $org_scalatest_assert_macro_left2 = catalogManager.currentCatalog().name();
            String $org_scalatest_assert_macro_right2 = "testcat";
            String string3 = $org_scalatest_assert_macro_left2;
            String string4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2759));
            this.sql().apply((Object)"SET CATALOG testcat2");
            String $org_scalatest_assert_macro_left3 = catalogManager.currentCatalog().name();
            String $org_scalatest_assert_macro_right3 = "testcat2";
            String string5 = $org_scalatest_assert_macro_left3;
            String string6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2762));
            CatalogNotFoundException x$411 = (CatalogNotFoundException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SET CATALOG not_exist_catalog"), ClassTag$.MODULE$.apply(CatalogNotFoundException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2765));
            Object x$412 = null;
            scala.collection.immutable.Map x$413 = Predef$.MODULE$.Map().empty();
            Option x$414 = this.checkError$default$3();
            boolean x$415 = this.checkError$default$5();
            QueryContext[] x$416 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$411, null, x$414, x$413, x$415, x$416);
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2754));
        this.test("SPARK-35973: ShowCatalogs", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            StructType schema = new StructType().add("catalog", (DataType)StringType$.MODULE$, false);
            Dataset df = (Dataset)this.sql().apply((Object)"SHOW CATALOGS");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(df.schema());
            StructType $org_scalatest_assert_macro_right = schema;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2777));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(df.collect());
            Row[] $org_scalatest_assert_macro_right2 = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"spark_catalog"}))});
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2778));
            this.sql().apply((Object)"use testcat");
            this.sql().apply((Object)"use testpart");
            this.sql().apply((Object)"use testcat2");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(((Dataset)this.sql().apply((Object)"SHOW CATALOGS")).collect());
            Row[] $org_scalatest_assert_macro_right3 = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"spark_catalog"})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"testcat"})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"testcat2"})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"testpart"}))});
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2783));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(((Dataset)this.sql().apply((Object)"SHOW CATALOGS LIKE 'test*'")).collect());
            Row[] $org_scalatest_assert_macro_right4 = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"testcat"})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"testcat2"})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"testpart"}))});
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2786));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(((Dataset)this.sql().apply((Object)"SHOW CATALOGS LIKE 'testcat*'")).collect());
            Row[] $org_scalatest_assert_macro_right5 = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"testcat"})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"testcat2"}))});
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2789));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2772));
        this.test("CREATE INDEX should fail", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testcat.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(64).append("CREATE TABLE ").append(t).append(" (id bigint, data string COMMENT 'hello') USING foo").toString());
                String sql1 = new StringBuilder(30).append("CREATE index i1 ON ").append(t).append("(non_exist)").toString();
                this.checkError((SparkThrowable)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)sql1), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2799)), "_LEGACY_ERROR_TEMP_1331", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldName"), (Object)"non_exist"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"table"), (Object)"testcat.tbl"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schema"), (Object)new StringOps(Predef$.MODULE$.augmentString("root\n              | |-- id: long (nullable = true)\n              | |-- data: string (nullable = true)\n              |")).stripMargin())})), (QueryContext)this.ExpectedContext().apply(sql1, 0, 40));
                String sql2 = new StringBuilder(23).append("CREATE index i1 ON ").append(t).append("(id)").toString();
                AnalysisException x$417 = (AnalysisException)((Object)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)sql2), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2818)))));
                String x$418 = "_LEGACY_ERROR_TEMP_1332";
                scala.collection.immutable.Map x$419 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"errorMessage"), (Object)"CreateIndex is not supported in this table testcat.tbl.")}));
                Option x$420 = this.checkError$default$3();
                boolean x$421 = this.checkError$default$5();
                QueryContext[] x$422 = this.checkError$default$6();
                this.checkError((SparkThrowable)x$417, x$418, x$420, x$419, x$421, x$422);
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2793));
        this.test("SPARK-37294: insert ANSI intervals into a table partitioned by the interval columns", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tbl = "testpart.interval_table";
            ((IterableLike)new .colon.colon((Object)SQLConf.PartitionOverwriteMode$.MODULE$.DYNAMIC(), (List)new .colon.colon((Object)SQLConf.PartitionOverwriteMode$.MODULE$.STATIC(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)mode -> {
                this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARTITION_OVERWRITE_MODE().key()), (Object)mode.toString())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tbl}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    $this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(147).append("\n               |CREATE TABLE ").append(tbl$4).append(" (i INT, part1 INTERVAL YEAR, part2 INTERVAL DAY) USING ").append($this.v2Format()).append("\n               |PARTITIONED BY (part1, part2)\n              ").toString())).stripMargin());
                    $this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(113).append("ALTER TABLE ").append(tbl$4).append(" ADD PARTITION (\n               |part1 = INTERVAL '2' YEAR,\n               |part2 = INTERVAL '3' DAY)").toString())).stripMargin());
                    $this.sql().apply((Object)new StringBuilder(69).append("INSERT OVERWRITE TABLE ").append(tbl$4).append(" SELECT 1, INTERVAL '2' YEAR, INTERVAL '3' DAY").toString());
                    $this.sql().apply((Object)new StringBuilder(64).append("INSERT INTO TABLE ").append(tbl$4).append(" SELECT 4, INTERVAL '5' YEAR, INTERVAL '6' DAY").toString());
                    $this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(135).append("\n               |INSERT INTO ").append(tbl$4).append("\n               | PARTITION (part1 = INTERVAL '8' YEAR, part2 = INTERVAL '9' DAY)\n               |SELECT 7").toString())).stripMargin());
                    $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().table(tbl$4), (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), Period.ofYears(2), Duration.ofDays(3L)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), Period.ofYears(5), Duration.ofDays(6L)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7), Period.ofYears(8), Duration.ofDays(9L)})), (List)Nil$.MODULE$)))));
                }));
                return BoxedUnit.UNIT;
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2827));
        this.test("Check HasPartitionKey from InMemoryPartitionTable", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testpart.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                int[] partKeys;
                this.sql().apply((Object)new StringBuilder(60).append("CREATE TABLE ").append(t).append(" (id string) USING foo PARTITIONED BY (key int)").toString());
                InMemoryPartitionTable table = (InMemoryPartitionTable)CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testpart")).asTableCatalog().loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"tbl"));
                this.sql().apply((Object)new StringBuilder(48).append("INSERT INTO ").append(t).append(" VALUES ('a', 1), ('b', 2), ('c', 3)").toString());
                int[] $org_scalatest_assert_macro_left = partKeys = (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])table.data())).map((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToInteger((int)DataSourceV2SQLSuiteV1Filter.$anonfun$new$405(x$23)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2870));
                Set $org_scalatest_assert_macro_left2 = new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(partKeys)).toSet();
                Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
                Set set = $org_scalatest_assert_macro_left2;
                Set set2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2871));
                this.sql().apply((Object)new StringBuilder(35).append("ALTER TABLE ").append(t).append(" DROP PARTITION (key=3)").toString());
                int[] $org_scalatest_assert_macro_left3 = partKeys = (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])table.data())).map((Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToInteger((int)DataSourceV2SQLSuiteV1Filter.$anonfun$new$406(x$24)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
                int $org_scalatest_assert_macro_right3 = 2;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2875));
                Set $org_scalatest_assert_macro_left4 = new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(partKeys)).toSet();
                Set $org_scalatest_assert_macro_right4 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}));
                Set set3 = $org_scalatest_assert_macro_left4;
                Set set4 = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(set3 != null ? !set3.equals(set4) : set4 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2876));
                this.sql().apply((Object)new StringBuilder(34).append("ALTER TABLE ").append(t).append(" ADD PARTITION (key=4)").toString());
                int[] $org_scalatest_assert_macro_left5 = partKeys = (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])table.data())).map((Function1 & Serializable & scala.Serializable)x$25 -> BoxesRunTime.boxToInteger((int)DataSourceV2SQLSuiteV1Filter.$anonfun$new$407(x$25)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
                int $org_scalatest_assert_macro_right5 = 3;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2880));
                Set $org_scalatest_assert_macro_left6 = new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(partKeys)).toSet();
                Set $org_scalatest_assert_macro_right6 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 4}));
                Set set5 = $org_scalatest_assert_macro_left6;
                Set set6 = $org_scalatest_assert_macro_right6;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(set5 != null ? !set5.equals(set6) : set6 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2881));
                this.sql().apply((Object)new StringBuilder(38).append("INSERT INTO ").append(t).append(" VALUES ('c', 3), ('e', 5)").toString());
                int[] $org_scalatest_assert_macro_left7 = partKeys = (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])table.data())).map((Function1 & Serializable & scala.Serializable)x$26 -> BoxesRunTime.boxToInteger((int)DataSourceV2SQLSuiteV1Filter.$anonfun$new$408(x$26)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
                int $org_scalatest_assert_macro_right7 = 5;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left7, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2885));
                Set $org_scalatest_assert_macro_left8 = new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(partKeys)).toSet();
                Set $org_scalatest_assert_macro_right8 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5}));
                Set set7 = $org_scalatest_assert_macro_left8;
                Set set8 = $org_scalatest_assert_macro_right8;
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right8, !(set7 != null ? !set7.equals(set8) : set8 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2886));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2860));
        this.test("time travel", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"use testcat");
            String t1 = "testcat.tSnapshot123456789";
            String t2 = "testcat.t2345678910";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t1, t2}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(32).append("CREATE TABLE ").append(t1).append(" (id int) USING foo").toString());
                this.sql().apply((Object)new StringBuilder(32).append("CREATE TABLE ").append(t2).append(" (id int) USING foo").toString());
                this.sql().apply((Object)new StringBuilder(23).append("INSERT INTO ").append(t1).append(" VALUES (1)").toString());
                this.sql().apply((Object)new StringBuilder(23).append("INSERT INTO ").append(t1).append(" VALUES (2)").toString());
                this.sql().apply((Object)new StringBuilder(23).append("INSERT INTO ").append(t2).append(" VALUES (3)").toString());
                this.sql().apply((Object)new StringBuilder(23).append("INSERT INTO ").append(t2).append(" VALUES (4)").toString());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(((Dataset)this.sql().apply((Object)"SELECT * FROM t VERSION AS OF 'Snapshot123456789'")).collect());
                Row[] $org_scalatest_assert_macro_right = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)}))});
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2905));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(((Dataset)this.sql().apply((Object)"SELECT * FROM t VERSION AS OF 2345678910")).collect());
                Row[] $org_scalatest_assert_macro_right2 = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4)}))});
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2907));
            });
            long ts1 = DateTimeUtils$.MODULE$.stringToTimestampAnsi(UTF8String.fromString((String)"2019-01-29 00:37:58"), DateTimeUtils$.MODULE$.getZoneId(SQLConf$.MODULE$.get().sessionLocalTimeZone()), DateTimeUtils$.MODULE$.stringToTimestampAnsi$default$3());
            long ts2 = DateTimeUtils$.MODULE$.stringToTimestampAnsi(UTF8String.fromString((String)"2021-01-29 00:00:00"), DateTimeUtils$.MODULE$.getZoneId(SQLConf$.MODULE$.get().sessionLocalTimeZone()), DateTimeUtils$.MODULE$.stringToTimestampAnsi$default$3());
            String ts1InSeconds = Long.toString(TimeUnit.MICROSECONDS.toSeconds(ts1));
            String ts2InSeconds = Long.toString(TimeUnit.MICROSECONDS.toSeconds(ts2));
            String t3 = new StringBuilder(9).append("testcat.t").append(ts1).toString();
            String t4 = new StringBuilder(9).append("testcat.t").append(ts2).toString();
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t3, t4}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(32).append("CREATE TABLE ").append(t3).append(" (id int) USING foo").toString());
                this.sql().apply((Object)new StringBuilder(32).append("CREATE TABLE ").append(t4).append(" (id int) USING foo").toString());
                this.sql().apply((Object)new StringBuilder(23).append("INSERT INTO ").append(t3).append(" VALUES (5)").toString());
                this.sql().apply((Object)new StringBuilder(23).append("INSERT INTO ").append(t3).append(" VALUES (6)").toString());
                this.sql().apply((Object)new StringBuilder(23).append("INSERT INTO ").append(t4).append(" VALUES (7)").toString());
                this.sql().apply((Object)new StringBuilder(23).append("INSERT INTO ").append(t4).append(" VALUES (8)").toString());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(((Dataset)this.sql().apply((Object)"SELECT * FROM t TIMESTAMP AS OF '2019-01-29 00:37:58'")).collect());
                Row[] $org_scalatest_assert_macro_right = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6)}))});
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2931));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(((Dataset)this.sql().apply((Object)"SELECT * FROM t TIMESTAMP AS OF '2021-01-29 00:00:00'")).collect());
                Row[] $org_scalatest_assert_macro_right2 = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)8)}))});
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2933));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(((Dataset)this.sql().apply((Object)new StringBuilder(32).append("SELECT * FROM t TIMESTAMP AS OF ").append(ts1InSeconds).toString())).collect());
                Row[] $org_scalatest_assert_macro_right3 = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6)}))});
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2935));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(((Dataset)this.sql().apply((Object)new StringBuilder(32).append("SELECT * FROM t TIMESTAMP AS OF ").append(ts2InSeconds).toString())).collect());
                Row[] $org_scalatest_assert_macro_right4 = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)8)}))});
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2937));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(((Dataset)this.sql().apply((Object)new StringBuilder(38).append("SELECT * FROM t FOR SYSTEM_TIME AS OF ").append(ts1InSeconds).toString())).collect());
                Row[] $org_scalatest_assert_macro_right5 = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6)}))});
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2939));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(((Dataset)this.sql().apply((Object)new StringBuilder(38).append("SELECT * FROM t FOR SYSTEM_TIME AS OF ").append(ts2InSeconds).toString())).collect());
                Row[] $org_scalatest_assert_macro_right6 = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)8)}))});
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2941));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(((Dataset)this.sql().apply((Object)"SELECT * FROM t TIMESTAMP AS OF make_date(2021, 1, 29)")).collect());
                Row[] $org_scalatest_assert_macro_right7 = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)8)}))});
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2943));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(((Dataset)this.sql().apply((Object)"SELECT * FROM t TIMESTAMP AS OF to_timestamp('2021-01-29 00:00:00')")).collect());
                Row[] $org_scalatest_assert_macro_right8 = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)8)}))});
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2945));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(((Dataset)this.sql().apply((Object)"SELECT * FROM t TIMESTAMP AS OF (SELECT make_date(2021, 1, 29))")).collect());
                Row[] $org_scalatest_assert_macro_right9 = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)8)}))});
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2948));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(((Dataset)this.sql().apply((Object)"SELECT * FROM t TIMESTAMP AS OF (SELECT (SELECT make_date(2021, 1, 29)))")).collect());
                Row[] $org_scalatest_assert_macro_right10 = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)8)}))});
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2951));
                AnalysisException x$423 = (AnalysisException)((Object)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Row[])((Dataset)this.sql().apply((Object)"SELECT * FROM t TIMESTAMP AS OF INTERVAL 1 DAY")).collect(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2955)))));
                String x$424 = "INVALID_TIME_TRAVEL_TIMESTAMP_EXPR.INPUT";
                scala.collection.immutable.Map x$425 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expr"), (Object)"\"INTERVAL '1' DAY\"")}));
                Option x$426 = this.checkError$default$3();
                boolean x$427 = this.checkError$default$5();
                QueryContext[] x$428 = this.checkError$default$6();
                this.checkError((SparkThrowable)x$423, x$424, x$426, x$425, x$427, x$428);
                AnalysisException x$429 = (AnalysisException)((Object)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Row[])((Dataset)this.sql().apply((Object)"SELECT * FROM t TIMESTAMP AS OF 'abc'")).collect(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2963)))));
                String x$430 = "INVALID_TIME_TRAVEL_TIMESTAMP_EXPR.INPUT";
                scala.collection.immutable.Map x$431 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expr"), (Object)"\"abc\"")}));
                Option x$432 = this.checkError$default$3();
                boolean x$433 = this.checkError$default$5();
                QueryContext[] x$434 = this.checkError$default$6();
                this.checkError((SparkThrowable)x$429, x$430, x$432, x$431, x$433, x$434);
                AnalysisException x$435 = (AnalysisException)((Object)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Row[])((Dataset)this.sql().apply((Object)"SELECT * FROM t TIMESTAMP AS OF current_user()")).collect(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2970)))));
                String x$436 = "INVALID_TIME_TRAVEL_TIMESTAMP_EXPR.UNEVALUABLE";
                scala.collection.immutable.Map x$437 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expr"), (Object)"\"current_user()\"")}));
                Option x$438 = this.checkError$default$3();
                boolean x$439 = this.checkError$default$5();
                QueryContext[] x$440 = this.checkError$default$6();
                this.checkError((SparkThrowable)x$435, x$436, x$438, x$437, x$439, x$440);
                AnalysisException x$441 = (AnalysisException)((Object)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Row[])((Dataset)this.sql().apply((Object)"SELECT * FROM t TIMESTAMP AS OF CAST(rand() AS STRING)")).collect(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2977)))));
                String x$442 = "INVALID_TIME_TRAVEL_TIMESTAMP_EXPR.NON_DETERMINISTIC";
                scala.collection.immutable.Map x$443 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expr"), (Object)"\"CAST(rand() AS STRING)\"")}));
                Option x$444 = this.checkError$default$3();
                boolean x$445 = this.checkError$default$5();
                QueryContext[] x$446 = this.checkError$default$6();
                this.checkError((SparkThrowable)x$441, x$442, x$444, x$443, x$445, x$446);
                this.checkError((SparkThrowable)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Row[])((Dataset)this.sql().apply((Object)"SELECT * FROM t TIMESTAMP AS OF abs(true)")).collect(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2984)), "DATATYPE_MISMATCH.UNEXPECTED_INPUT_TYPE", (Option)None$.MODULE$, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"abs(true)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)"\"true\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)"\"BOOLEAN\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)"(\"NUMERIC\" or \"INTERVAL DAY TO SECOND\" or \"INTERVAL YEAR TO MONTH\")")})), (QueryContext)this.ExpectedContext().apply("abs(true)", 32, 40));
                this.checkError((SparkThrowable)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM parquet.`/the/path` VERSION AS OF 1"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3002)), "UNSUPPORTED_FEATURE.TIME_TRAVEL", (Option)None$.MODULE$, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationId"), (Object)"`parquet`.`/the/path`")})), this.checkError$default$5(), this.checkError$default$6());
                this.checkError((SparkThrowable)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"WITH x AS (SELECT 1) SELECT * FROM x VERSION AS OF 1"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3010)), "UNSUPPORTED_FEATURE.TIME_TRAVEL", (Option)None$.MODULE$, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationId"), (Object)"`x`")})), this.checkError$default$5(), this.checkError$default$6());
                this.checkError((SparkThrowable)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM non_exist VERSION AS OF 1"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3018)), "TABLE_OR_VIEW_NOT_FOUND", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationName"), (Object)"`non_exist`")})), (QueryContext)this.ExpectedContext().apply("non_exist", 14, 22));
                String subquery1 = "SELECT 1 FROM non_exist";
                this.checkError((SparkThrowable)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Row[])((Dataset)this.sql().apply((Object)new StringBuilder(34).append("SELECT * FROM t TIMESTAMP AS OF (").append(subquery1).append(")").toString())).collect(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3030)), "TABLE_OR_VIEW_NOT_FOUND", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationName"), (Object)"`non_exist`")})), (QueryContext)this.ExpectedContext().apply("non_exist", 47, 55));
                this.checkError((SparkThrowable)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Row[])((Dataset)this.sql().apply((Object)new StringBuilder(43).append("SELECT * FROM t TIMESTAMP AS OF (SELECT (").append(subquery1).append("))").toString())).collect(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3041)), "TABLE_OR_VIEW_NOT_FOUND", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationName"), (Object)"`non_exist`")})), (QueryContext)this.ExpectedContext().apply("non_exist", 55, 63));
                String subquery2 = "SELECT col";
                this.checkError((SparkThrowable)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Row[])((Dataset)this.sql().apply((Object)new StringBuilder(34).append("SELECT * FROM t TIMESTAMP AS OF (").append(subquery2).append(")").toString())).collect(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3053)), "UNRESOLVED_COLUMN.WITHOUT_SUGGESTION", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"objectName"), (Object)"`col`")})), (QueryContext)this.ExpectedContext().apply("col", 40, 42));
                this.checkError((SparkThrowable)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Row[])((Dataset)this.sql().apply((Object)new StringBuilder(43).append("SELECT * FROM t TIMESTAMP AS OF (SELECT (").append(subquery2).append("))").toString())).collect(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3063)), "UNRESOLVED_COLUMN.WITHOUT_SUGGESTION", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"objectName"), (Object)"`col`")})), (QueryContext)this.ExpectedContext().apply("col", 48, 50));
                String subquery3 = "SELECT 1, 2";
                this.checkError((SparkThrowable)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Row[])((Dataset)this.sql().apply((Object)new StringBuilder(34).append("SELECT * FROM t TIMESTAMP AS OF (").append(subquery3).append(")").toString())).collect(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3075)), "INVALID_SUBQUERY_EXPRESSION.SCALAR_SUBQUERY_RETURN_MORE_THAN_ONE_OUTPUT_COLUMN", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"number"), (Object)"2")})), (QueryContext)this.ExpectedContext().apply("(SELECT 1, 2)", 32, 44));
                this.checkError((SparkThrowable)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Row[])((Dataset)this.sql().apply((Object)new StringBuilder(43).append("SELECT * FROM t TIMESTAMP AS OF (SELECT (").append(subquery3).append("))").toString())).collect(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3086)), "INVALID_SUBQUERY_EXPRESSION.SCALAR_SUBQUERY_RETURN_MORE_THAN_ONE_OUTPUT_COLUMN", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"number"), (Object)"2")})), (QueryContext)this.ExpectedContext().apply("(SELECT 1, 2)", 40, 52));
                String subquery4 = "SELECT * FROM VALUES (1), (2)";
                this.checkError((SparkThrowable)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Row[])((Dataset)this.sql().apply((Object)new StringBuilder(34).append("SELECT * FROM t TIMESTAMP AS OF (").append(subquery4).append(")").toString())).collect(), ClassTag$.MODULE$.apply(SparkException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3099)), "SCALAR_SUBQUERY_TOO_MANY_ROWS", Predef$.MODULE$.Map().empty(), (QueryContext)this.ExpectedContext().apply("(SELECT * FROM VALUES (1), (2))", 32, 62));
                this.checkError((SparkThrowable)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Row[])((Dataset)this.sql().apply((Object)new StringBuilder(43).append("SELECT * FROM t TIMESTAMP AS OF (SELECT (").append(subquery4).append("))").toString())).collect(), ClassTag$.MODULE$.apply(SparkException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3109)), "SCALAR_SUBQUERY_TOO_MANY_ROWS", Predef$.MODULE$.Map().empty(), (QueryContext)this.ExpectedContext().apply("(SELECT * FROM VALUES (1), (2))", 40, 70));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2890));
        this.test("SPARK-37827: put build-in properties into V1Table.properties to adapt v2 command", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(348).append("\n           |CREATE TABLE ").append(t).append(" (\n           |  a bigint,\n           |  b bigint\n           |)\n           |using parquet\n           |OPTIONS (\n           |  from = 0,\n           |  to = 1)\n           |COMMENT 'This is a comment'\n           |TBLPROPERTIES ('prop1' = '1', 'prop2' = '2')\n           |PARTITIONED BY (a)\n           |LOCATION '/tmp'\n        ").toString())).stripMargin());
                Table table = CatalogV2Implicits$.MODULE$.CatalogHelper(this.spark().sessionState().catalogManager().v2SessionCatalog()).asTableCatalog().loadTable(Identifier.of((String[])((String[])((Object[])new String[]{"default"})), (String)t));
                java.util.Map properties = table.properties();
                String $org_scalatest_assert_macro_left = (String)properties.get("provider");
                String $org_scalatest_assert_macro_right = "parquet";
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3143));
                String $org_scalatest_assert_macro_left2 = (String)properties.get("comment");
                String $org_scalatest_assert_macro_right2 = "This is a comment";
                String string3 = $org_scalatest_assert_macro_left2;
                String string4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3144));
                String $org_scalatest_assert_macro_left3 = (String)properties.get("location");
                String $org_scalatest_assert_macro_right3 = "file:///tmp";
                String string5 = $org_scalatest_assert_macro_left3;
                String string6 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3145));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(properties.containsKey("owner"), "properties.containsKey(\"owner\")", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3146));
                String $org_scalatest_assert_macro_left4 = (String)properties.get("external");
                String $org_scalatest_assert_macro_right4 = "true";
                String string7 = $org_scalatest_assert_macro_left4;
                String string8 = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3147));
                String $org_scalatest_assert_macro_left5 = (String)properties.get(new StringBuilder(11).append("option.").append("from").toString());
                String $org_scalatest_assert_macro_right5 = "0";
                String string9 = $org_scalatest_assert_macro_left5;
                String string10 = $org_scalatest_assert_macro_right5;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(string9 != null ? !string9.equals(string10) : string10 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3148));
                String $org_scalatest_assert_macro_left6 = (String)properties.get(new StringBuilder(9).append("option.").append("to").toString());
                String $org_scalatest_assert_macro_right6 = "1";
                String string11 = $org_scalatest_assert_macro_left6;
                String string12 = $org_scalatest_assert_macro_right6;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(string11 != null ? !string11.equals(string12) : string12 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3149));
                String $org_scalatest_assert_macro_left7 = (String)properties.get("prop1");
                String $org_scalatest_assert_macro_right7 = "1";
                String string13 = $org_scalatest_assert_macro_left7;
                String string14 = $org_scalatest_assert_macro_right7;
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right7, !(string13 != null ? !string13.equals(string14) : string14 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3150));
                String $org_scalatest_assert_macro_left8 = (String)properties.get("prop2");
                String $org_scalatest_assert_macro_right8 = "2";
                String string15 = $org_scalatest_assert_macro_left8;
                String string16 = $org_scalatest_assert_macro_right8;
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right8, !(string15 != null ? !string15.equals(string16) : string16 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3151));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3121));
        this.test("Overwrite: overwrite by expression: True", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuiteV1Filter.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator122$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator122$1(DataSourceV2SQLSuiteV1Filter $outer) {
                }
            }
            Dataset df = this.spark().createDataFrame((Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)"a"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)2L), (Object)"b"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)3L), (Object)"c"), (List)Nil$.MODULE$))), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator122$1(null))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data"}));
            df.createOrReplaceTempView("source");
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuiteV1Filter.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator123$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator123$1(DataSourceV2SQLSuiteV1Filter $outer) {
                }
            }
            Dataset df2 = this.spark().createDataFrame((Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)4L), (Object)"d"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)5L), (Object)"e"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)6L), (Object)"f"), (List)Nil$.MODULE$))), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator123$1(null))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data"}));
            df2.createOrReplaceTempView("source2");
            String t = "testcat.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.spark().sql(new StringBuilder(68).append("CREATE TABLE ").append(t).append(" (id bigint, data string) USING foo PARTITIONED BY (id)").toString());
                this.spark().sql(new StringBuilder(39).append("INSERT INTO TABLE ").append(t).append(" SELECT * FROM source").toString());
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> this.spark().table(String.valueOf(t)), (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)1L), "a"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)2L), "b"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)3L), "c"})), (List)Nil$.MODULE$)))));
                this.spark().sql(new StringBuilder(53).append("INSERT INTO ").append(t).append(" REPLACE WHERE TRUE SELECT * FROM source2").toString());
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> this.spark().table(String.valueOf(t)), (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)4L), "d"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), "e"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)6L), "f"})), (List)Nil$.MODULE$)))));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3155));
        this.test("Overwrite: overwrite by expression: id = 3", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuiteV1Filter.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator124$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator124$1(DataSourceV2SQLSuiteV1Filter $outer) {
                }
            }
            Dataset df = this.spark().createDataFrame((Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)"a"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)2L), (Object)"b"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)3L), (Object)"c"), (List)Nil$.MODULE$))), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator124$1(null))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data"}));
            df.createOrReplaceTempView("source");
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuiteV1Filter.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator125$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator125$1(DataSourceV2SQLSuiteV1Filter $outer) {
                }
            }
            Dataset df2 = this.spark().createDataFrame((Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)4L), (Object)"d"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)5L), (Object)"e"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)6L), (Object)"f"), (List)Nil$.MODULE$))), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator125$1(null))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data"}));
            df2.createOrReplaceTempView("source2");
            String t = "testcat.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.spark().sql(new StringBuilder(68).append("CREATE TABLE ").append(t).append(" (id bigint, data string) USING foo PARTITIONED BY (id)").toString());
                this.spark().sql(new StringBuilder(39).append("INSERT INTO TABLE ").append(t).append(" SELECT * FROM source").toString());
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> this.spark().table(String.valueOf(t)), (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)1L), "a"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)2L), "b"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)3L), "c"})), (List)Nil$.MODULE$)))));
                this.spark().sql(new StringBuilder(55).append("INSERT INTO ").append(t).append(" REPLACE WHERE id = 3 SELECT * FROM source2").toString());
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> this.spark().table(String.valueOf(t)), (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)1L), "a"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)2L), "b"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)4L), "d"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), "e"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)6L), "f"})), (List)Nil$.MODULE$)))))));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3178));
        this.test("SPARK-41154: Incorrect relation caching for queries with time travel spec", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"use testcat");
            String t1 = "testcat.t1";
            String t2 = "testcat.t2";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t1, t2}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(40).append("CREATE TABLE ").append(t1).append(" USING foo AS SELECT 1 as c").toString());
                this.sql().apply((Object)new StringBuilder(40).append("CREATE TABLE ").append(t2).append(" USING foo AS SELECT 2 as c").toString());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(((Dataset)this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("\n              |SELECT * FROM t VERSION AS OF '1'\n              |UNION ALL\n              |SELECT * FROM t VERSION AS OF '2'\n              |")).stripMargin())).collect());
                Row[] $org_scalatest_assert_macro_right = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)}))});
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3208));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3201));
        this.test("SPARK-41378: test column stats", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            this.spark().sql("CREATE TABLE testcat.test (id bigint NOT NULL, data string)");
            this.spark().sql("INSERT INTO testcat.test values (1, 'test1'), (2, null), (3, null), (4, null), (5, 'test5')");
            Dataset df = this.spark().sql("select * from testcat.test");
            Seq expectedColumnStats = (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(5)), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, 2)), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"data"), (Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(3)), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(3)), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, 2)), (List)Nil$.MODULE$));
            return df.queryExecution().optimizedPlan().collect((PartialFunction)new scala.Serializable(this, expectedColumnStats, df){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DataSourceV2SQLSuiteV1Filter $outer;
                private final Seq expectedColumnStats$1;
                private final Dataset df$1;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof DataSourceV2ScanRelation) {
                        DataSourceV2ScanRelation dataSourceV2ScanRelation = (DataSourceV2ScanRelation)A1;
                        Statistics stats = dataSourceV2ScanRelation.stats();
                        BigInt $org_scalatest_assert_macro_left = stats.sizeInBytes();
                        int $org_scalatest_assert_macro_right = 200;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), BoxesRunTime.equalsNumObject((Number)$org_scalatest_assert_macro_left, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3230));
                        BigInt $org_scalatest_assert_macro_left2 = (BigInt)stats.rowCount().get();
                        int $org_scalatest_assert_macro_right2 = 5;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), BoxesRunTime.equalsNumObject((Number)$org_scalatest_assert_macro_left2, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2)), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3231));
                        AttributeMap $org_scalatest_assert_macro_left3 = stats.attributeStats();
                        AttributeMap<ColumnStat> $org_scalatest_assert_macro_right3 = this.$outer.toAttributeMap((Seq<Tuple2<String, ColumnStat>>)this.expectedColumnStats$1, this.df$1.queryExecution().optimizedPlan());
                        AttributeMap attributeMap = $org_scalatest_assert_macro_left3;
                        AttributeMap<ColumnStat> attributeMap2 = $org_scalatest_assert_macro_right3;
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", $org_scalatest_assert_macro_right3, !(attributeMap != null ? !attributeMap.equals(attributeMap2) : attributeMap2 != null), Prettifier$.MODULE$.default());
                        return (B1)Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3232));
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(LogicalPlan x1) {
                    LogicalPlan logicalPlan = x1;
                    return logicalPlan instanceof DataSourceV2ScanRelation;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.expectedColumnStats$1 = expectedColumnStats$1;
                    this.df$1 = df$1;
                }
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3218));
        this.test("DESCRIBE TABLE EXTENDED of a V2 table with a default column value", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.DEFAULT_COLUMN_ALLOWED_PROVIDERS().key()), (Object)this.v2Source())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringBuilder(44).append("CREATE TABLE t (id bigint default 42) USING ").append(this.v2Source()).toString());
            Dataset descriptionDf = this.spark().sql("DESCRIBE TABLE EXTENDED t");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(descriptionDf.schema().map((Function1 & Serializable & scala.Serializable)field -> new Tuple2((Object)field.name(), (Object)field.dataType()), Seq$.MODULE$.canBuildFrom()));
            Seq $org_scalatest_assert_macro_right = (Seq)new .colon.colon((Object)new Tuple2((Object)"col_name", (Object)StringType$.MODULE$), (List)new .colon.colon((Object)new Tuple2((Object)"data_type", (Object)StringType$.MODULE$), (List)new .colon.colon((Object)new Tuple2((Object)"comment", (Object)StringType$.MODULE$), (List)Nil$.MODULE$)));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3242));
            QueryTest$.MODULE$.checkAnswer((Dataset<Row>)descriptionDf.filter("!(col_name in ('Catalog', 'Created Time', 'Created By', 'Database', 'index', 'Location', 'Name', 'Owner', 'Provider', 'Table', 'Table Properties', 'Type', '_partition', ''))"), (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"# Detailed Table Information", "", ""})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"# Column Default Values", "", ""})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"# Metadata Columns", "", ""})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"id", "bigint", "42"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"id", "bigint", null})), (List)Nil$.MODULE$)))))), QueryTest$.MODULE$.checkAnswer$default$3());
        })), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3237));
        this.test("SPARK-40045: Move the post-Scan Filters to the far right", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t1 = new StringBuilder(5).append(this.catalogAndNamespace()).append("table").toString();
            this.withUserDefinedFunction((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"udfStrLen"), (Object)BoxesRunTime.boxToBoolean((boolean)true))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t1}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Bool bool;
                Bool bool2;
                Bool bool3;
                Seq<org.apache.spark.sql.catalyst.expressions.Expression> expressionsAfter;
                Bool bool4;
                Bool bool5;
                Bool bool6;
                Seq<org.apache.spark.sql.catalyst.expressions.Expression> expressionsBefore;
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuiteV1Filter.class.getClassLoader());
                public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator126$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
                    }

                    public Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator126$1(DataSourceV2SQLSuiteV1Filter $outer) {
                    }
                }
                this.spark().udf().register("udfStrLen", (Function1 & Serializable & scala.Serializable)str -> BoxesRunTime.boxToInteger((int)str.length()), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator126$1(null)));
                this.sql().apply((Object)new StringBuilder(45).append("CREATE TABLE ").append(t1).append(" (id bigint, data string) USING ").append(this.v2Format()).toString());
                this.sql().apply((Object)new StringBuilder(48).append("INSERT INTO ").append(t1).append(" VALUES (1, 'a'), (2, 'b'), (3, 'c')").toString());
                Dataset filterBefore = this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(116).append("\n             |SELECT id, data FROM ").append(t1).append("\n             |WHERE udfStrLen(data) = 1\n             |and id = 2\n             |").toString())).stripMargin());
                org.apache.spark.sql.catalyst.expressions.Expression conditionBefore = ((FilterExec)Option$.MODULE$.option2Iterable(this.find(filterBefore.queryExecution().executedPlan(), (Function1<SparkPlan, Object>)(Function1 & Serializable & scala.Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)DataSourceV2SQLSuiteV1Filter.$anonfun$new$449(x$27)))).head()).condition();
                Seq<org.apache.spark.sql.catalyst.expressions.Expression> $org_scalatest_assert_macro_left = expressionsBefore = this.splitConjunctivePredicates(conditionBefore);
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.lengthSizeMacroBool($org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left2.value()) {
                    String $org_scalatest_assert_macro_left3 = ((org.apache.spark.sql.catalyst.expressions.Expression)expressionsBefore.apply(0)).toString().trim();
                    String $org_scalatest_assert_macro_right2 = "isnotnull(id";
                    bool6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "startsWith", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.startsWith($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                } else {
                    bool6 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right3 = bool6;
                Bool $org_scalatest_assert_macro_left4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left4.value()) {
                    String $org_scalatest_assert_macro_left5 = ((org.apache.spark.sql.catalyst.expressions.Expression)expressionsBefore.apply(1)).toString().trim();
                    String $org_scalatest_assert_macro_right4 = "(id";
                    bool5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "startsWith", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left5.startsWith($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
                } else {
                    bool5 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right5 = bool5;
                Bool $org_scalatest_assert_macro_left6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "&&", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left4.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left6.value()) {
                    String $org_scalatest_assert_macro_left7 = ((org.apache.spark.sql.catalyst.expressions.Expression)expressionsBefore.apply(2)).toString().trim();
                    String $org_scalatest_assert_macro_right6 = "(udfStrLen(data";
                    bool4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "startsWith", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left7.startsWith($org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
                } else {
                    bool4 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right7 = bool4;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "&&", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left6.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3284));
                Dataset filterAfter = this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(116).append("\n             |SELECT id, data FROM ").append(t1).append("\n             |WHERE id = 2\n             |and udfStrLen(data) = 1\n             |").toString())).stripMargin());
                org.apache.spark.sql.catalyst.expressions.Expression conditionAfter = ((FilterExec)Option$.MODULE$.option2Iterable(this.find(filterAfter.queryExecution().executedPlan(), (Function1<SparkPlan, Object>)(Function1 & Serializable & scala.Serializable)x$28 -> BoxesRunTime.boxToBoolean((boolean)DataSourceV2SQLSuiteV1Filter.$anonfun$new$453(x$28)))).head()).condition();
                Seq<org.apache.spark.sql.catalyst.expressions.Expression> $org_scalatest_assert_macro_left8 = expressionsAfter = this.splitConjunctivePredicates(conditionAfter);
                int $org_scalatest_assert_macro_right8 = 3;
                Bool $org_scalatest_assert_macro_left9 = Bool$.MODULE$.lengthSizeMacroBool($org_scalatest_assert_macro_left8, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left8.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left9.value()) {
                    String $org_scalatest_assert_macro_left10 = ((org.apache.spark.sql.catalyst.expressions.Expression)expressionsAfter.apply(0)).toString().trim();
                    String $org_scalatest_assert_macro_right9 = "isnotnull(id";
                    bool3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "startsWith", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left10.startsWith($org_scalatest_assert_macro_right9), Prettifier$.MODULE$.default());
                } else {
                    bool3 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right10 = bool3;
                Bool $org_scalatest_assert_macro_left11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "&&", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left9.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right10), Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left11.value()) {
                    String $org_scalatest_assert_macro_left12 = ((org.apache.spark.sql.catalyst.expressions.Expression)expressionsAfter.apply(1)).toString().trim();
                    String $org_scalatest_assert_macro_right11 = "(id";
                    bool2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "startsWith", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left12.startsWith($org_scalatest_assert_macro_right11), Prettifier$.MODULE$.default());
                } else {
                    bool2 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right12 = bool2;
                Bool $org_scalatest_assert_macro_left13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "&&", (Object)$org_scalatest_assert_macro_right12, $org_scalatest_assert_macro_left11.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right12), Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left13.value()) {
                    String $org_scalatest_assert_macro_left14 = ((org.apache.spark.sql.catalyst.expressions.Expression)expressionsAfter.apply(2)).toString().trim();
                    String $org_scalatest_assert_macro_right13 = "(udfStrLen(data";
                    bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "startsWith", (Object)$org_scalatest_assert_macro_right13, $org_scalatest_assert_macro_left14.startsWith($org_scalatest_assert_macro_right13), Prettifier$.MODULE$.default());
                } else {
                    bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right14 = bool;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "&&", (Object)$org_scalatest_assert_macro_right14, $org_scalatest_assert_macro_left13.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right14), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3301));
            }));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3264));
    }
}

