/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder$;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.CurrentBatchTimestamp;
import org.apache.spark.sql.catalyst.expressions.CurrentDate;
import org.apache.spark.sql.catalyst.expressions.CurrentTimestamp;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.FileSourceMetadataAttribute$;
import org.apache.spark.sql.catalyst.expressions.LocalTimestamp;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.streaming.StreamingRelationV2;
import org.apache.spark.sql.catalyst.streaming.WriteToStream;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.SupportsRead;
import org.apache.spark.sql.connector.catalog.SupportsWrite;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.read.streaming.MicroBatchStream;
import org.apache.spark.sql.connector.read.streaming.ReadLimit;
import org.apache.spark.sql.connector.read.streaming.SparkDataStream;
import org.apache.spark.sql.connector.read.streaming.SupportsAdmissionControl;
import org.apache.spark.sql.connector.read.streaming.SupportsTriggerAvailableNow;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Implicits$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation$;
import org.apache.spark.sql.execution.datasources.v2.StreamWriterCommitProgress;
import org.apache.spark.sql.execution.datasources.v2.StreamingDataSourceV2Relation;
import org.apache.spark.sql.execution.datasources.v2.StreamingDataSourceV2Relation$;
import org.apache.spark.sql.execution.datasources.v2.WriteToDataSourceV2Exec;
import org.apache.spark.sql.execution.streaming.AcceptsLatestSeenOffsetHandler$;
import org.apache.spark.sql.execution.streaming.AsyncLogPurge;
import org.apache.spark.sql.execution.streaming.AvailableNowDataStreamWrapper;
import org.apache.spark.sql.execution.streaming.AvailableNowMicroBatchStreamWrapper;
import org.apache.spark.sql.execution.streaming.AvailableNowSourceWrapper;
import org.apache.spark.sql.execution.streaming.AvailableNowTrigger$;
import org.apache.spark.sql.execution.streaming.CommitMetadata;
import org.apache.spark.sql.execution.streaming.ErrorNotifier;
import org.apache.spark.sql.execution.streaming.IncrementalExecution;
import org.apache.spark.sql.execution.streaming.MicroBatchExecution$;
import org.apache.spark.sql.execution.streaming.MicroBatchExecution$$anonfun$2$;
import org.apache.spark.sql.execution.streaming.MultiBatchExecutor;
import org.apache.spark.sql.execution.streaming.Offset;
import org.apache.spark.sql.execution.streaming.OffsetHolder;
import org.apache.spark.sql.execution.streaming.OffsetSeq;
import org.apache.spark.sql.execution.streaming.OffsetSeqMetadata;
import org.apache.spark.sql.execution.streaming.OffsetSeqMetadata$;
import org.apache.spark.sql.execution.streaming.OneTimeTrigger$;
import org.apache.spark.sql.execution.streaming.ProcessingTimeExecutor;
import org.apache.spark.sql.execution.streaming.ProcessingTimeTrigger;
import org.apache.spark.sql.execution.streaming.ProgressReporter;
import org.apache.spark.sql.execution.streaming.SerializedOffset;
import org.apache.spark.sql.execution.streaming.SingleBatchExecutor;
import org.apache.spark.sql.execution.streaming.Sink;
import org.apache.spark.sql.execution.streaming.Source;
import org.apache.spark.sql.execution.streaming.StreamExecution;
import org.apache.spark.sql.execution.streaming.StreamExecution$;
import org.apache.spark.sql.execution.streaming.StreamingExecutionRelation;
import org.apache.spark.sql.execution.streaming.StreamingRelation;
import org.apache.spark.sql.execution.streaming.TERMINATED$;
import org.apache.spark.sql.execution.streaming.TriggerExecutor;
import org.apache.spark.sql.execution.streaming.WatermarkPropagator;
import org.apache.spark.sql.execution.streaming.WatermarkPropagator$;
import org.apache.spark.sql.execution.streaming.WatermarkTracker;
import org.apache.spark.sql.execution.streaming.WatermarkTracker$;
import org.apache.spark.sql.execution.streaming.sources.WriteToMicroBatchDataSource;
import org.apache.spark.sql.execution.streaming.sources.WriteToMicroBatchDataSource$;
import org.apache.spark.sql.execution.streaming.sources.WriteToMicroBatchDataSourceV1;
import org.apache.spark.sql.execution.streaming.sources.WriteToMicroBatchDataSourceV1$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.streaming.StreamingQueryStatus;
import org.apache.spark.sql.streaming.Trigger;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.util.Clock;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t\u0015c\u0001\u0002\u00180\u0001qB\u0011\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!R%\t\u0013)\u0003!\u0011!Q\u0001\n-\u0003\u0006\"C)\u0001\u0005\u0003\u0005\u000b\u0011\u0002*Y\u0011!I\u0006A!A!\u0002\u0013Q\u0006\u0002\u00036\u0001\u0005\u0003\u0005\u000b\u0011B6\t\u000bI\u0004A\u0011A:\t\u0011i\u0004!\u0019!C\tgmDaa \u0001!\u0002\u0013a\b\"CA\u0001\u0001\u0001\u0007I\u0011CA\u0002\u0011%\tI\u0003\u0001a\u0001\n#\tY\u0003\u0003\u0005\u0002:\u0001\u0001\u000b\u0015BA\u0003\u0011%\t\u0019\u0005\u0001b\u0001\n#\t)\u0005\u0003\u0005\u0002N\u0001\u0001\u000b\u0011BA$\u0011-\ty\u0005\u0001a\u0001\u0002\u0004%\t\"!\u0015\t\u0017\u0005e\u0003\u00011AA\u0002\u0013E\u00111\f\u0005\f\u0003?\u0002\u0001\u0019!A!B\u0013\t\u0019\u0006\u0003\u0006\u0002b\u0001A)\u0019!C!\u0003GB\u0011\"!\u001e\u0001\u0001\u0004%I!a\u001e\t\u0013\u0005}\u0004\u00011A\u0005\n\u0005\u0005\u0005\u0002CAC\u0001\u0001\u0006K!!\u001f\t\u000f\u0005\u001d\u0005\u0001\"\u0011\u0002\n\"I\u00111\u0012\u0001C\u0002\u0013%\u0011Q\u0012\u0005\t\u0003+\u0003\u0001\u0015!\u0003\u0002\u0010\"9\u0011q\u0013\u0001\u0005B\u0005%\u0005bBAM\u0001\u0011E\u0013\u0011\u0012\u0005\b\u00037\u0003A\u0011CAO\u0011\u001d\t\u0019\u000b\u0001C\u0001\u0003KCq!!0\u0001\t\u0013\ty\fC\u0004\u0002F\u0002!I!a\u001e\t\u000f\u0005\u001d\u0007\u0001\"\u0003\u0002J\"9\u0011Q\u001b\u0001\u0005\n\u0005]\u0007bBAo\u0001\u0011E\u0011q\u001c\u0005\b\u0003K\u0004A\u0011BAt\u0011\u001d\ti\u000f\u0001C\t\u0003\u0013Cq!a<\u0001\t#\tI\tC\u0004\u0002r\u0002!\t\"!#\t\u000f\u0005M\b\u0001\"\u0005\u0002\n\"A\u0011Q\u001f\u0001\u0005\u0002M\n9\u0010C\u0007\u0003\u001c\u0001\u0001\n1!A\u0001\n\u0013\u0011i\"\u0013\u0005\u000e\u0005?\u0001\u0001\u0013aA\u0001\u0002\u0013%!\u0011\u0005-\b\u000f\t\rr\u0006#\u0001\u0003&\u00191af\fE\u0001\u0005OAaA\u001d\u0016\u0005\u0002\t=\u0002\"\u0003B\u0019U\t\u0007I\u0011\u0001B\u001a\u0011!\u0011\u0019E\u000bQ\u0001\n\tU\"aE'jGJ|')\u0019;dQ\u0016CXmY;uS>t'B\u0001\u00192\u0003%\u0019HO]3b[&twM\u0003\u00023g\u0005IQ\r_3dkRLwN\u001c\u0006\u0003iU\n1a]9m\u0015\t1t'A\u0003ta\u0006\u00148N\u0003\u00029s\u00051\u0011\r]1dQ\u0016T\u0011AO\u0001\u0004_J<7\u0001A\n\u0004\u0001u\n\u0005C\u0001 @\u001b\u0005y\u0013B\u0001!0\u0005=\u0019FO]3b[\u0016CXmY;uS>t\u0007C\u0001 C\u0013\t\u0019uFA\u0007Bgft7\rT8h!V\u0014x-Z\u0001\rgB\f'o[*fgNLwN\u001c\t\u0003\r\u001ek\u0011aM\u0005\u0003\u0011N\u0012Ab\u00159be.\u001cVm]:j_:L!\u0001R \u0002\u000fQ\u0014\u0018nZ4feB\u0011AJT\u0007\u0002\u001b*\u0011\u0001gM\u0005\u0003\u001f6\u0013q\u0001\u0016:jO\u001e,'/\u0003\u0002K\u007f\u0005aAO]5hO\u0016\u00148\t\\8dWB\u00111KV\u0007\u0002)*\u0011Q+N\u0001\u0005kRLG.\u0003\u0002X)\n)1\t\\8dW&\u0011\u0011kP\u0001\rKb$(/Y(qi&|gn\u001d\t\u00057\u0012<wM\u0004\u0002]EB\u0011Q\fY\u0007\u0002=*\u0011qlO\u0001\u0007yI|w\u000e\u001e \u000b\u0003\u0005\fQa]2bY\u0006L!a\u00191\u0002\rA\u0013X\rZ3g\u0013\t)gMA\u0002NCBT!a\u00191\u0011\u0005mC\u0017BA5g\u0005\u0019\u0019FO]5oO\u0006!\u0001\u000f\\1o!\ta\u0007/D\u0001n\u0015\t\u0001dN\u0003\u0002pg\u0005A1-\u0019;bYf\u001cH/\u0003\u0002r[\niqK]5uKR{7\u000b\u001e:fC6\fa\u0001P5oSRtDC\u0002;vm^D\u0018\u0010\u0005\u0002?\u0001!)AI\u0002a\u0001\u000b\")!J\u0002a\u0001\u0017\")\u0011K\u0002a\u0001%\")\u0011L\u0002a\u00015\")!N\u0002a\u0001W\u0006iQM\u001d:pe:{G/\u001b4jKJ,\u0012\u0001 \t\u0003}uL!A`\u0018\u0003\u001b\u0015\u0013(o\u001c:O_RLg-[3s\u00039)'O]8s\u001d>$\u0018NZ5fe\u0002\nqa]8ve\u000e,7/\u0006\u0002\u0002\u0006A1\u0011qAA\t\u0003/qA!!\u0003\u0002\u000e9\u0019Q,a\u0003\n\u0003\u0005L1!a\u0004a\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0005\u0002\u0016\t\u00191+Z9\u000b\u0007\u0005=\u0001\r\u0005\u0003\u0002\u001a\u0005\u0015RBAA\u000e\u0015\r\u0001\u0014Q\u0004\u0006\u0005\u0003?\t\t#\u0001\u0003sK\u0006$'bAA\u0012g\u0005I1m\u001c8oK\u000e$xN]\u0005\u0005\u0003O\tYBA\bTa\u0006\u00148\u000eR1uCN#(/Z1n\u0003-\u0019x.\u001e:dKN|F%Z9\u0015\t\u00055\u0012Q\u0007\t\u0005\u0003_\t\t$D\u0001a\u0013\r\t\u0019\u0004\u0019\u0002\u0005+:LG\u000fC\u0005\u00028)\t\t\u00111\u0001\u0002\u0006\u0005\u0019\u0001\u0010J\u0019\u0002\u0011M|WO]2fg\u0002B3aCA\u001f!\u0011\ty#a\u0010\n\u0007\u0005\u0005\u0003M\u0001\u0005w_2\fG/\u001b7f\u0003=!(/[4hKJ,\u00050Z2vi>\u0014XCAA$!\rq\u0014\u0011J\u0005\u0004\u0003\u0017z#a\u0004+sS\u001e<WM]#yK\u000e,Ho\u001c:\u0002!Q\u0014\u0018nZ4fe\u0016CXmY;u_J\u0004\u0013\u0001E<bi\u0016\u0014X.\u0019:l)J\f7m[3s+\t\t\u0019\u0006E\u0002?\u0003+J1!a\u00160\u0005A9\u0016\r^3s[\u0006\u00148\u000e\u0016:bG.,'/\u0001\u000bxCR,'/\\1sWR\u0013\u0018mY6fe~#S-\u001d\u000b\u0005\u0003[\ti\u0006C\u0005\u00028=\t\t\u00111\u0001\u0002T\u0005\tr/\u0019;fe6\f'o\u001b+sC\u000e\\WM\u001d\u0011\u0002\u00171|w-[2bYBc\u0017M\\\u000b\u0003\u0003K\u0002B!a\u001a\u0002r5\u0011\u0011\u0011\u000e\u0006\u0005\u0003W\ni'A\u0004m_\u001eL7-\u00197\u000b\u0007\u0005=d.A\u0003qY\u0006t7/\u0003\u0003\u0002t\u0005%$a\u0003'pO&\u001c\u0017\r\u001c)mC:\f\u0011$[:DkJ\u0014XM\u001c;CCR\u001c\u0007nQ8ogR\u0014Xo\u0019;fIV\u0011\u0011\u0011\u0010\t\u0005\u0003_\tY(C\u0002\u0002~\u0001\u0014qAQ8pY\u0016\fg.A\u000fjg\u000e+(O]3oi\n\u000bGo\u00195D_:\u001cHO];di\u0016$w\fJ3r)\u0011\ti#a!\t\u0013\u0005]2#!AA\u0002\u0005e\u0014AG5t\u0007V\u0014(/\u001a8u\u0005\u0006$8\r[\"p]N$(/^2uK\u0012\u0004\u0013\u0001B:u_B$\"!!\f\u0002']\fG/\u001a:nCJ\\\u0007K]8qC\u001e\fGo\u001c:\u0016\u0005\u0005=\u0005c\u0001 \u0002\u0012&\u0019\u00111S\u0018\u0003']\u000bG/\u001a:nCJ\\\u0007K]8qC\u001e\fGo\u001c:\u0002)]\fG/\u001a:nCJ\\\u0007K]8qC\u001e\fGo\u001c:!\u0003\u001d\u0019G.Z1okB\fAb\u001d;beR$&/[4hKJ\f!C];o\u0003\u000e$\u0018N^1uK\u0012\u001cFO]3b[R!\u0011QFAP\u0011\u0019\t\tK\u0007a\u0001\u000b\u0006)2\u000f]1sWN+7o]5p]\u001a{'o\u0015;sK\u0006l\u0017!\t<bY&$\u0017\r^3PM\u001a\u001cX\r\u001e'pO\u0006sGmR3u!J,go\u00144gg\u0016$H\u0003BAT\u0003g\u0003b!a\f\u0002*\u00065\u0016bAAVA\n1q\n\u001d;j_:\u00042APAX\u0013\r\t\tl\f\u0002\n\u001f\u001a47/\u001a;TKFDq!!.\u001c\u0001\u0004\t9,A\u0007mCR,7\u000f\u001e\"bi\u000eD\u0017\n\u001a\t\u0005\u0003_\tI,C\u0002\u0002<\u0002\u0014A\u0001T8oO\u0006!\u0002o\u001c9vY\u0006$Xm\u0015;beR|eMZ:fiN$B!!\f\u0002B\"1\u00111\u0019\u000fA\u0002\u0015\u000b\u0001d\u001d9be.\u001cVm]:j_:$vNU;o\u0005\u0006$8\r[3t\u0003II7OT3x\t\u0006$\u0018-\u0011<bS2\f'\r\\3\u0002\u001d\u001d,Go\u0015;beR|eMZ:fiR!\u00111ZAi!\u0011\tI\"!4\n\t\u0005=\u00171\u0004\u0002\u0007\u001f\u001a47/\u001a;\t\u000f\u0005Mg\u00041\u0001\u0002\u0018\u0005QA-\u0019;b'R\u0014X-Y7\u0002%\r|gn\u001d;sk\u000e$h*\u001a=u\u0005\u0006$8\r\u001b\u000b\u0005\u0003s\nI\u000eC\u0004\u0002\\~\u0001\r!!\u001f\u0002)9|G)\u0019;b\u0005\u0006$8\r[3t\u000b:\f'\r\\3e\u00035\u0019w.\\7jiN{WO]2fgR!\u0011QFAq\u0011\u001d\t\u0019\u000f\ta\u0001\u0003[\u000b\u0011b\u001c4gg\u0016$8+Z9\u0002\u0011I,hNQ1uG\"$B!!\f\u0002j\"1\u00111^\u0011A\u0002\u0015\u000bac\u001d9be.\u001cVm]:j_:$vNU;o\u0005\u0006$8\r[\u0001\u0014[\u0006\u00148.T5de>\u0014\u0015\r^2i'R\f'\u000f^\u0001\u001d[\u0006\u00148.T5de>\u0014\u0015\r^2i\u000bb,7-\u001e;j_:\u001cF/\u0019:u\u0003Ei\u0017M]6NS\u000e\u0014xNQ1uG\",e\u000eZ\u0001\u001eG2,\u0017M\\+q\u0019\u0006\u001cH/\u0012=fGV$X\rZ'jGJ|')\u0019;dQ\u0006\u0011r/\u001b;i!J|wM]3tg2{7m[3e+\u0011\tI0a@\u0015\t\u0005m(\u0011\u0003\t\u0005\u0003{\fy\u0010\u0004\u0001\u0005\u000f\t\u0005aE1\u0001\u0003\u0004\t\tA+\u0005\u0003\u0003\u0006\t-\u0001\u0003BA\u0018\u0005\u000fI1A!\u0003a\u0005\u001dqu\u000e\u001e5j]\u001e\u0004B!a\f\u0003\u000e%\u0019!q\u00021\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0003\u0014\u0019\"\t\u0019\u0001B\u000b\u0003\u00051\u0007CBA\u0018\u0005/\tY0C\u0002\u0003\u001a\u0001\u0014\u0001\u0002\u00102z]\u0006lWMP\u0001\u0013gV\u0004XM\u001d\u0013ta\u0006\u00148nU3tg&|g.F\u0001F\u0003I\u0019X\u000f]3sIQ\u0014\u0018nZ4fe\u000ecwnY6\u0016\u0003I\u000b1#T5de>\u0014\u0015\r^2i\u000bb,7-\u001e;j_:\u0004\"A\u0010\u0016\u0014\u0007)\u0012I\u0003\u0005\u0003\u00020\t-\u0012b\u0001B\u0017A\n1\u0011I\\=SK\u001a$\"A!\n\u0002\u0019\t\u000bEk\u0011%`\u0013\u0012{6*R-\u0016\u0005\tU\u0002\u0003\u0002B\u001c\u0005\u0003j!A!\u000f\u000b\t\tm\"QH\u0001\u0005Y\u0006twM\u0003\u0002\u0003@\u0005!!.\u0019<b\u0013\rI'\u0011H\u0001\u000e\u0005\u0006#6\tS0J\t~[U)\u0017\u0011")
public class MicroBatchExecution
extends StreamExecution
implements AsyncLogPurge {
    private LogicalPlan logicalPlan;
    private final scala.collection.immutable.Map<String, String> extraOptions;
    private final WriteToStream plan;
    private final ErrorNotifier errorNotifier;
    private volatile Seq<SparkDataStream> sources;
    private final TriggerExecutor triggerExecutor;
    private WatermarkTracker watermarkTracker;
    private boolean isCurrentBatchConstructed;
    private final WatermarkPropagator watermarkPropagator;
    private final ThreadPoolExecutor org$apache$spark$sql$execution$streaming$AsyncLogPurge$$asyncPurgeExecutorService;
    private final AtomicBoolean org$apache$spark$sql$execution$streaming$AsyncLogPurge$$purgeRunning;
    private boolean useAsyncPurge;
    private volatile byte bitmap$0;

    public static String BATCH_ID_KEY() {
        return MicroBatchExecution$.MODULE$.BATCH_ID_KEY();
    }

    @Override
    public void purgeAsync() {
        AsyncLogPurge.purgeAsync$(this);
    }

    @Override
    public void asyncLogPurgeShutdown() {
        AsyncLogPurge.asyncLogPurgeShutdown$(this);
    }

    @Override
    public boolean arePendingAsyncPurge() {
        return AsyncLogPurge.arePendingAsyncPurge$(this);
    }

    @Override
    public ThreadPoolExecutor org$apache$spark$sql$execution$streaming$AsyncLogPurge$$asyncPurgeExecutorService() {
        return this.org$apache$spark$sql$execution$streaming$AsyncLogPurge$$asyncPurgeExecutorService;
    }

    @Override
    public AtomicBoolean org$apache$spark$sql$execution$streaming$AsyncLogPurge$$purgeRunning() {
        return this.org$apache$spark$sql$execution$streaming$AsyncLogPurge$$purgeRunning;
    }

    private boolean useAsyncPurge$lzycompute() {
        MicroBatchExecution microBatchExecution = this;
        synchronized (microBatchExecution) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.useAsyncPurge = AsyncLogPurge.useAsyncPurge$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.useAsyncPurge;
    }

    @Override
    public boolean useAsyncPurge() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.useAsyncPurge$lzycompute();
        }
        return this.useAsyncPurge;
    }

    @Override
    public final void org$apache$spark$sql$execution$streaming$AsyncLogPurge$_setter_$org$apache$spark$sql$execution$streaming$AsyncLogPurge$$asyncPurgeExecutorService_$eq(ThreadPoolExecutor x$1) {
        this.org$apache$spark$sql$execution$streaming$AsyncLogPurge$$asyncPurgeExecutorService = x$1;
    }

    @Override
    public final void org$apache$spark$sql$execution$streaming$AsyncLogPurge$_setter_$org$apache$spark$sql$execution$streaming$AsyncLogPurge$$purgeRunning_$eq(AtomicBoolean x$1) {
        this.org$apache$spark$sql$execution$streaming$AsyncLogPurge$$purgeRunning = x$1;
    }

    public /* synthetic */ SparkSession org$apache$spark$sql$execution$streaming$MicroBatchExecution$$super$sparkSession() {
        return super.sparkSession();
    }

    private /* synthetic */ Clock super$triggerClock() {
        return super.triggerClock();
    }

    @Override
    public ErrorNotifier errorNotifier() {
        return this.errorNotifier;
    }

    @Override
    public Seq<SparkDataStream> sources() {
        return this.sources;
    }

    public void sources_$eq(Seq<SparkDataStream> x$1) {
        this.sources = x$1;
    }

    public TriggerExecutor triggerExecutor() {
        return this.triggerExecutor;
    }

    public WatermarkTracker watermarkTracker() {
        return this.watermarkTracker;
    }

    public void watermarkTracker_$eq(WatermarkTracker x$1) {
        this.watermarkTracker = x$1;
    }

    private LogicalPlan logicalPlan$lzycompute() {
        MicroBatchExecution microBatchExecution = this;
        synchronized (microBatchExecution) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                LogicalPlan logicalPlan2;
                Predef$.MODULE$.assert(this.queryExecutionThread() == Thread.currentThread(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(83).append("logicalPlan must be initialized in QueryExecutionThread ").append("but the current thread was ").append(Thread.currentThread()).toString());
                LongRef nextSourceId = LongRef.create((long)0L);
                Map toExecutionRelationMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
                Map v2ToExecutionRelationMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
                Map v2ToRelationMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
                Seq disabledSources = Utils$.MODULE$.stringToSeq(super.sparkSession().sqlContext().conf().disabledV2StreamingMicroBatchReaders());
                LogicalPlan _logicalPlan = (LogicalPlan)this.analyzedPlan().transform((PartialFunction)new scala.Serializable(this, toExecutionRelationMap, nextSourceId, disabledSources, v2ToRelationMap, v2ToExecutionRelationMap){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ MicroBatchExecution $outer;
                    private final Map toExecutionRelationMap$1;
                    private final LongRef nextSourceId$1;
                    private final Seq disabledSources$1;
                    private final Map v2ToRelationMap$1;
                    private final Map v2ToExecutionRelationMap$1;

                    public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        if (A1 instanceof StreamingRelation) {
                            StreamingRelation streamingRelation = (StreamingRelation)A1;
                            DataSource dataSourceV1 = streamingRelation.dataSource();
                            String sourceName = streamingRelation.sourceName();
                            Seq<Attribute> output = streamingRelation.output();
                            return (B1)this.toExecutionRelationMap$1.getOrElseUpdate((Object)((Object)streamingRelation), (Function0 & Serializable & scala.Serializable)() -> {
                                String metadataPath = new StringBuilder(9).append($this.$outer.resolvedCheckpointRoot()).append("/sources/").append($this.nextSourceId$1.elem).toString();
                                Source source = dataSourceV1.createSource(metadataPath);
                                ++$this.nextSourceId$1.elem;
                                $this.$outer.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Using Source [").append(source).append("] from DataSourceV1 named '").append(sourceName).append("' [").append(dataSourceV1).append("]").toString());
                                return new StreamingExecutionRelation(source, output, dataSourceV1.catalogTable(), $this.$outer.org$apache$spark$sql$execution$streaming$MicroBatchExecution$$super$sparkSession());
                            });
                        }
                        if (A1 instanceof StreamingRelationV2) {
                            StreamingRelationV2 streamingRelationV2 = (StreamingRelationV2)A1;
                            Option src = streamingRelationV2.source();
                            String srcName = streamingRelationV2.sourceName();
                            Table table = streamingRelationV2.table();
                            CaseInsensitiveStringMap options = streamingRelationV2.extraOptions();
                            Seq output = streamingRelationV2.output();
                            Option catalog = streamingRelationV2.catalog();
                            Option identifier = streamingRelationV2.identifier();
                            Option v1 = streamingRelationV2.v1Relation();
                            if (table instanceof SupportsRead) {
                                SupportsRead supportsRead = (SupportsRead)table;
                                String dsStr = src.nonEmpty() ? new StringBuilder(2).append("[").append(src.get()).append("]").toString() : "";
                                boolean v2Disabled = this.disabledSources$1.contains((Object)src.getOrElse((Function0 & Serializable & scala.Serializable)() -> None$.MODULE$).getClass().getCanonicalName());
                                if (!v2Disabled && DataSourceV2Implicits$.MODULE$.TableHelper((Table)supportsRead).supports(TableCapability.MICRO_BATCH_READ)) {
                                    return (B1)this.v2ToRelationMap$1.getOrElseUpdate((Object)streamingRelationV2, (Function0 & Serializable & scala.Serializable)() -> {
                                        String metadataPath = new StringBuilder(9).append($this.$outer.resolvedCheckpointRoot()).append("/sources/").append($this.nextSourceId$1.elem).toString();
                                        ++$this.nextSourceId$1.elem;
                                        $this.$outer.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Reading table [").append(supportsRead).append("] from DataSourceV2 named '").append(srcName).append("' ").append(dsStr).toString());
                                        Scan scan = supportsRead.newScanBuilder(options).build();
                                        MicroBatchStream stream = scan.toMicroBatchStream(metadataPath);
                                        return new StreamingDataSourceV2Relation(output, scan, (SparkDataStream)stream, catalog, identifier, StreamingDataSourceV2Relation$.MODULE$.apply$default$6(), StreamingDataSourceV2Relation$.MODULE$.apply$default$7());
                                    });
                                }
                                if (v1.isEmpty()) {
                                    throw QueryExecutionErrors$.MODULE$.microBatchUnsupportedByDataSourceError(srcName, this.$outer.org$apache$spark$sql$execution$streaming$MicroBatchExecution$$super$sparkSession().sqlContext().conf().disabledV2StreamingMicroBatchReaders(), (Table)supportsRead);
                                }
                                return (B1)this.v2ToExecutionRelationMap$1.getOrElseUpdate((Object)streamingRelationV2, (Function0 & Serializable & scala.Serializable)() -> {
                                    String metadataPath = new StringBuilder(9).append($this.$outer.resolvedCheckpointRoot()).append("/sources/").append($this.nextSourceId$1.elem).toString();
                                    Source source = ((StreamingRelation)((Object)((Object)v1.get()))).dataSource().createSource(metadataPath);
                                    ++$this.nextSourceId$1.elem;
                                    $this.$outer.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Using Source [").append(source).append("] from DataSourceV2 named '").append(srcName).append("' ").append(dsStr).toString());
                                    return new StreamingExecutionRelation(source, (Seq<Attribute>)output, (Option<CatalogTable>)None$.MODULE$, $this.$outer.org$apache$spark$sql$execution$streaming$MicroBatchExecution$$super$sparkSession());
                                });
                            }
                        }
                        return (B1)function1.apply(x1);
                    }

                    public final boolean isDefinedAt(LogicalPlan x1) {
                        StreamingRelationV2 streamingRelationV2;
                        Table table;
                        LogicalPlan logicalPlan2 = x1;
                        if (logicalPlan2 instanceof StreamingRelation) {
                            return true;
                        }
                        return logicalPlan2 instanceof StreamingRelationV2 && (table = (streamingRelationV2 = (StreamingRelationV2)logicalPlan2).table()) instanceof SupportsRead;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.toExecutionRelationMap$1 = toExecutionRelationMap$1;
                        this.nextSourceId$1 = nextSourceId$1;
                        this.disabledSources$1 = disabledSources$1;
                        this.v2ToRelationMap$1 = v2ToRelationMap$1;
                        this.v2ToExecutionRelationMap$1 = v2ToExecutionRelationMap$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.execution.streaming.MicroBatchExecution$$anonfun$1 org.apache.spark.sql.execution.datasources.DataSource java.lang.String scala.collection.Seq ), $anonfun$applyOrElse$3(), $anonfun$applyOrElse$4(org.apache.spark.sql.execution.streaming.MicroBatchExecution$$anonfun$1 org.apache.spark.sql.connector.catalog.SupportsRead java.lang.String java.lang.String org.apache.spark.sql.util.CaseInsensitiveStringMap scala.collection.Seq scala.Option scala.Option ), $anonfun$applyOrElse$6(org.apache.spark.sql.execution.streaming.MicroBatchExecution$$anonfun$1 scala.Option java.lang.String java.lang.String scala.collection.Seq ), $anonfun$applyOrElse$2(org.apache.spark.sql.execution.streaming.Source java.lang.String org.apache.spark.sql.execution.datasources.DataSource ), $anonfun$applyOrElse$5(org.apache.spark.sql.connector.catalog.SupportsRead java.lang.String java.lang.String ), $anonfun$applyOrElse$7(org.apache.spark.sql.execution.streaming.Source java.lang.String java.lang.String )}, serializedLambda);
                    }
                });
                this.sources_$eq((Seq<SparkDataStream>)_logicalPlan.collect((PartialFunction)new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                        A1 A1 = x2;
                        if (A1 instanceof StreamingExecutionRelation) {
                            StreamingExecutionRelation streamingExecutionRelation = (StreamingExecutionRelation)A1;
                            return (B1)streamingExecutionRelation.source();
                        }
                        if (A1 instanceof StreamingDataSourceV2Relation) {
                            StreamingDataSourceV2Relation streamingDataSourceV2Relation = (StreamingDataSourceV2Relation)A1;
                            return (B1)streamingDataSourceV2Relation.stream();
                        }
                        return (B1)function1.apply(x2);
                    }

                    public final boolean isDefinedAt(LogicalPlan x2) {
                        LogicalPlan logicalPlan2 = x2;
                        if (logicalPlan2 instanceof StreamingExecutionRelation) {
                            return true;
                        }
                        return logicalPlan2 instanceof StreamingDataSourceV2Relation;
                    }
                }));
                TriggerExecutor triggerExecutor = this.triggerExecutor();
                this.uniqueSources_$eq((scala.collection.immutable.Map<SparkDataStream, ReadLimit>)(triggerExecutor instanceof SingleBatchExecutor ? ((TraversableOnce)((TraversableLike)this.sources().distinct()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    SparkDataStream sparkDataStream = x0$1;
                    if (sparkDataStream instanceof SupportsAdmissionControl) {
                        ReadLimit limit;
                        SupportsAdmissionControl supportsAdmissionControl = (SupportsAdmissionControl)sparkDataStream;
                        ReadLimit readLimit = limit = supportsAdmissionControl.getDefaultReadLimit();
                        ReadLimit readLimit2 = ReadLimit.allAvailable();
                        if (readLimit == null ? readLimit2 != null : !readLimit.equals(readLimit2)) {
                            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("The read limit ").append(limit).append(" for ").append(supportsAdmissionControl).append(" is ignored when Trigger.Once is used.").toString());
                        }
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)supportsAdmissionControl), (Object)ReadLimit.allAvailable());
                    }
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)sparkDataStream), (Object)ReadLimit.allAvailable());
                }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()) : (triggerExecutor instanceof MultiBatchExecutor ? ((TraversableOnce)((TraversableLike)((TraversableLike)this.sources().distinct()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    SparkDataStream sparkDataStream = x0$2;
                    if (sparkDataStream instanceof SupportsTriggerAvailableNow) {
                        SupportsTriggerAvailableNow supportsTriggerAvailableNow = (SupportsTriggerAvailableNow)sparkDataStream;
                        return supportsTriggerAvailableNow;
                    }
                    if (sparkDataStream instanceof Source) {
                        Source source = (Source)sparkDataStream;
                        return new AvailableNowSourceWrapper(source);
                    }
                    if (sparkDataStream instanceof MicroBatchStream) {
                        MicroBatchStream microBatchStream = (MicroBatchStream)sparkDataStream;
                        return new AvailableNowMicroBatchStreamWrapper(microBatchStream);
                    }
                    throw new MatchError((Object)sparkDataStream);
                }, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)s -> {
                    s.prepareForTriggerAvailableNow();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(s), (Object)s.getDefaultReadLimit());
                }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()) : ((TraversableOnce)((TraversableLike)this.sources().distinct()).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                    SparkDataStream sparkDataStream = x0$3;
                    if (sparkDataStream instanceof SupportsAdmissionControl) {
                        SupportsAdmissionControl supportsAdmissionControl = (SupportsAdmissionControl)sparkDataStream;
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)supportsAdmissionControl), (Object)supportsAdmissionControl.getDefaultReadLimit());
                    }
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)sparkDataStream), (Object)ReadLimit.allAvailable());
                }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()))));
                Table table = this.sink();
                if (table instanceof SupportsWrite) {
                    SupportsWrite supportsWrite = (SupportsWrite)table;
                    Option relationOpt = this.plan.catalogAndIdent().map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                        Tuple2 tuple2 = x0$4;
                        if (tuple2 != null) {
                            TableCatalog catalog = (TableCatalog)tuple2._1();
                            Identifier ident = (Identifier)tuple2._2();
                            return DataSourceV2Relation$.MODULE$.create((Table)supportsWrite, (Option)new Some((Object)catalog), (Option)new Some((Object)ident));
                        }
                        throw new MatchError((Object)tuple2);
                    });
                    logicalPlan2 = new WriteToMicroBatchDataSource((Option<DataSourceV2Relation>)relationOpt, supportsWrite, _logicalPlan, this.id().toString(), this.extraOptions, this.outputMode(), WriteToMicroBatchDataSource$.MODULE$.apply$default$7());
                } else if (table instanceof Sink) {
                    Sink sink = (Sink)table;
                    logicalPlan2 = new WriteToMicroBatchDataSourceV1((Option<CatalogTable>)this.plan.catalogTable(), sink, _logicalPlan, this.id().toString(), this.extraOptions, this.outputMode(), WriteToMicroBatchDataSourceV1$.MODULE$.apply$default$7());
                } else {
                    throw new IllegalArgumentException(new StringBuilder(22).append("unknown sink type for ").append(this.sink()).toString());
                }
                this.logicalPlan = logicalPlan2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.logicalPlan;
    }

    @Override
    public LogicalPlan logicalPlan() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.logicalPlan$lzycompute();
        }
        return this.logicalPlan;
    }

    private boolean isCurrentBatchConstructed() {
        return this.isCurrentBatchConstructed;
    }

    private void isCurrentBatchConstructed_$eq(boolean x$1) {
        this.isCurrentBatchConstructed = x$1;
    }

    @Override
    public void stop() {
        this.state().set(TERMINATED$.MODULE$);
        if (this.queryExecutionThread().isAlive()) {
            super.sparkSession().sparkContext().cancelJobGroup(this.runId().toString());
            this.interruptAndAwaitExecutionThreadTermination();
            super.sparkSession().sparkContext().cancelJobGroup(this.runId().toString());
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Query ").append(this.prettyIdString()).append(" was stopped").toString());
    }

    private WatermarkPropagator watermarkPropagator() {
        return this.watermarkPropagator;
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.asyncLogPurgeShutdown();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Async log purge executor pool for query ").append(this.prettyIdString()).append(" has been shutdown").toString());
    }

    @Override
    public void startTrigger() {
        ProgressReporter.startTrigger$(this);
        StreamingQueryStatus qual$1 = this.currentStatus();
        boolean x$1 = true;
        String x$2 = qual$1.copy$default$1();
        boolean x$3 = qual$1.copy$default$2();
        this.currentStatus_$eq(qual$1.copy(x$2, x$3, x$1));
    }

    @Override
    public void runActivatedStream(SparkSession sparkSessionForStream) {
        boolean noDataBatchesEnabled = sparkSessionForStream.sessionState().conf().streamingNoDataMicroBatchesEnabled();
        this.triggerExecutor().execute((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            if (this.isActive()) {
                this.errorNotifier().throwErrorIfExists();
                BooleanRef currentBatchHasNewData = BooleanRef.create((boolean)false);
                this.startTrigger();
                this.reportTimeTaken("triggerExecution", (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    if (this.currentBatchId() < 0L) {
                        AcceptsLatestSeenOffsetHandler$.MODULE$.setLatestSeenOffsetOnSources((Option<OffsetSeq>)this.offsetLog().getLatest().map((Function1 & Serializable & scala.Serializable)x$1 -> (OffsetSeq)x$1._2()), this.sources());
                        this.populateStartOffsets(sparkSessionForStream);
                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Stream started from ").append(this.committedOffsets()).toString());
                    }
                    this.org$apache$spark$sql$execution$streaming$MicroBatchExecution$$super$sparkSession().sparkContext().setJobDescription(this.getBatchDescriptionString());
                    if (!this.isCurrentBatchConstructed()) {
                        this.isCurrentBatchConstructed_$eq(this.constructNextBatch(noDataBatchesEnabled));
                    }
                    this.recordTriggerOffsets(this.committedOffsets(), this.availableOffsets(), this.latestOffsets());
                    currentBatchHasNewData$1.elem = this.isNewDataAvailable();
                    StreamingQueryStatus qual$1 = this.currentStatus();
                    boolean x$12 = this.isNewDataAvailable();
                    String x$2 = qual$1.copy$default$1();
                    boolean x$3 = qual$1.copy$default$3();
                    this.currentStatus_$eq(qual$1.copy(x$2, x$12, x$3));
                    if (this.isCurrentBatchConstructed()) {
                        if (currentBatchHasNewData$1.elem) {
                            this.updateStatusMessage("Processing new data");
                        } else {
                            this.updateStatusMessage("No new data but cleaning up state");
                        }
                        this.runBatch(sparkSessionForStream);
                        return;
                    }
                    this.updateStatusMessage("Waiting for data to arrive");
                });
                this.finishTrigger(currentBatchHasNewData.elem, this.isCurrentBatchConstructed());
                this.withProgressLocked((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.awaitProgressLockCondition().signalAll());
                if (this.isCurrentBatchConstructed()) {
                    this.currentBatchId_$eq(this.currentBatchId() + 1L);
                    this.isCurrentBatchConstructed_$eq(false);
                } else if (this.triggerExecutor() instanceof MultiBatchExecutor) {
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Finished processing all available data for the trigger, terminating this Trigger.AvailableNow query");
                    this.state().set(TERMINATED$.MODULE$);
                } else {
                    Thread.sleep(this.pollingDelayMs());
                }
            }
            this.updateStatusMessage("Waiting for next trigger");
            return this.isActive();
        });
    }

    public Option<OffsetSeq> validateOffsetLogAndGetPrevOffset(long latestBatchId) {
        if (latestBatchId != 0L) {
            return new Some(this.offsetLog().get(latestBatchId - 1L).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(366).append("The offset log for batch ").append(latestBatchId - 1L).append(" doesn't exist, ").append("which is required to restart the query from the latest batch ").append(latestBatchId).append(" ").append("from the offset log. Please ensure there are two subsequent offset logs ").append("available for the latest batch via manually deleting the offset file(s). ").append("Please also ensure the latest batch for commit log is equal or one batch ").append("earlier than the latest batch for offset log.").toString());
                throw new IllegalStateException(new StringBuilder(20).append("batch ").append(latestBatchId - 1L).append(" doesn't exist").toString());
            }));
        }
        return None$.MODULE$;
    }

    private void populateStartOffsets(SparkSession sparkSessionToRunBatches) {
        Some some;
        Tuple2 tuple2;
        this.sinkCommitProgress_$eq((Option<StreamWriterCommitProgress>)None$.MODULE$);
        Option option = this.offsetLog().getLatest();
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            Some some2;
            Tuple2 tuple22;
            long latestBatchId = tuple2._1$mcJ$sp();
            OffsetSeq nextOffsets = (OffsetSeq)tuple2._2();
            this.currentBatchId_$eq(latestBatchId);
            this.isCurrentBatchConstructed_$eq(true);
            this.availableOffsets_$eq(nextOffsets.toStreamProgress(this.sources()));
            Option<OffsetSeq> secondLatestOffsets = this.validateOffsetLogAndGetPrevOffset(latestBatchId);
            secondLatestOffsets.foreach((Function1 & Serializable & scala.Serializable)offset -> {
                this.committedOffsets_$eq(offset.toStreamProgress(this.sources()));
                return BoxedUnit.UNIT;
            });
            nextOffsets.metadata().foreach((Function1 & Serializable & scala.Serializable)metadata -> {
                MicroBatchExecution.$anonfun$populateStartOffsets$2(this, sparkSessionToRunBatches, metadata);
                return BoxedUnit.UNIT;
            });
            Option option2 = this.commitLog().getLatest();
            if (option2 instanceof Some && (tuple22 = (Tuple2)(some2 = (Some)option2).value()) != null) {
                long latestCommittedBatchId = tuple22._1$mcJ$sp();
                CommitMetadata commitMetadata = (CommitMetadata)tuple22._2();
                if (latestBatchId == latestCommittedBatchId) {
                    this.availableOffsets().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 != null) {
                            SparkDataStream source = (SparkDataStream)tuple2._1();
                            org.apache.spark.sql.connector.read.streaming.Offset end = (org.apache.spark.sql.connector.read.streaming.Offset)tuple2._2();
                            if (source instanceof Source) {
                                Source source2 = (Source)source;
                                if (end instanceof Offset) {
                                    Offset offset = (Offset)end;
                                    Option start = this.committedOffsets().get(source2).map((Function1 & Serializable & scala.Serializable)x$2 -> (Offset)((Object)((Object)x$2)));
                                    return source2.getBatch((Option<Offset>)start, offset);
                                }
                            }
                        }
                        return BoxedUnit.UNIT;
                    });
                    this.currentBatchId_$eq(latestCommittedBatchId + 1L);
                    this.isCurrentBatchConstructed_$eq(false);
                    this.committedOffsets_$eq(this.committedOffsets().$plus$plus((GenTraversableOnce<Tuple2<SparkDataStream, org.apache.spark.sql.connector.read.streaming.Offset>>)this.availableOffsets()));
                    this.watermarkTracker().setWatermark(package$.MODULE$.max(this.watermarkTracker().currentWatermark(), commitMetadata.nextBatchWatermarkMs()));
                } else if (latestCommittedBatchId == latestBatchId - 1L) {
                    this.availableOffsets().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        Tuple2 tuple2 = x0$2;
                        if (tuple2 != null) {
                            SparkDataStream source = (SparkDataStream)tuple2._1();
                            org.apache.spark.sql.connector.read.streaming.Offset end = (org.apache.spark.sql.connector.read.streaming.Offset)tuple2._2();
                            if (source instanceof Source) {
                                Source source2 = (Source)source;
                                if (end instanceof Offset) {
                                    Offset offset = (Offset)end;
                                    Option start = this.committedOffsets().get(source2).map((Function1 & Serializable & scala.Serializable)x$3 -> (Offset)((Object)((Object)x$3)));
                                    if (BoxesRunTime.unboxToBoolean((Object)start.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)MicroBatchExecution.$anonfun$populateStartOffsets$7(offset, x$4))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true))) {
                                        return source2.getBatch((Option<Offset>)start, offset);
                                    }
                                    return BoxedUnit.UNIT;
                                }
                            }
                        }
                        return BoxedUnit.UNIT;
                    });
                } else if (latestCommittedBatchId < latestBatchId - 1L) {
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(79).append("Batch completion log latest batch id is ").append(latestCommittedBatchId).append(", which is not trailing ").append("batchid ").append(latestBatchId).append(" by one").toString());
                }
            } else if (None$.MODULE$.equals(option2)) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "no commit log present");
            } else {
                throw new MatchError(option2);
            }
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append("Resuming at batch ").append(this.currentBatchId()).append(" with committed offsets ").append(this.committedOffsets()).append(" and available offsets ").append(this.availableOffsets()).toString());
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting new streaming query.");
            this.currentBatchId_$eq(0L);
            this.watermarkTracker_$eq(WatermarkTracker$.MODULE$.apply(sparkSessionToRunBatches.conf()));
            return;
        }
        throw new MatchError(option);
    }

    private boolean isNewDataAvailable() {
        return this.availableOffsets().exists((Function1<Tuple2<SparkDataStream, org.apache.spark.sql.connector.read.streaming.Offset>, Object>)(Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MicroBatchExecution.$anonfun$isNewDataAvailable$1(this, x0$1)));
    }

    private org.apache.spark.sql.connector.read.streaming.Offset getStartOffset(SparkDataStream dataStream) {
        Option<org.apache.spark.sql.connector.read.streaming.Offset> startOffsetOpt = this.availableOffsets().get(dataStream);
        SparkDataStream sparkDataStream = dataStream;
        if (sparkDataStream instanceof Source) {
            return (org.apache.spark.sql.connector.read.streaming.Offset)startOffsetOpt.orNull(Predef$.MODULE$.$conforms());
        }
        if (sparkDataStream instanceof MicroBatchStream) {
            MicroBatchStream microBatchStream = (MicroBatchStream)sparkDataStream;
            return (org.apache.spark.sql.connector.read.streaming.Offset)startOffsetOpt.map((Function1 & Serializable & scala.Serializable)offset -> microBatchStream.deserializeOffset(offset.json())).getOrElse((Function0 & Serializable & scala.Serializable)() -> microBatchStream.initialOffset());
        }
        throw new MatchError((Object)sparkDataStream);
    }

    private boolean constructNextBatch(boolean noDataBatchesEnabled) {
        boolean bl;
        Object object = new Object();
        try {
            bl = BoxesRunTime.unboxToBoolean(this.withProgressLocked((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                if (this.isCurrentBatchConstructed()) {
                    throw new NonLocalReturnControl.mcZ.sp(object, true);
                }
                Tuple2 tuple2 = ((GenericTraversableTemplate)this.uniqueSources().toSeq().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    SparkDataStream s;
                    SparkDataStream s2;
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        SparkDataStream s3 = (SparkDataStream)tuple2._1();
                        ReadLimit limit = (ReadLimit)tuple2._2();
                        if (s3 instanceof AvailableNowDataStreamWrapper) {
                            AvailableNowDataStreamWrapper availableNowDataStreamWrapper = (AvailableNowDataStreamWrapper)s3;
                            this.updateStatusMessage(new StringBuilder(21).append("Getting offsets from ").append(availableNowDataStreamWrapper).toString());
                            SparkDataStream originalSource = availableNowDataStreamWrapper.delegate();
                            return (Tuple2)this.reportTimeTaken("latestOffset", (Function0 & Serializable & scala.Serializable)() -> {
                                org.apache.spark.sql.connector.read.streaming.Offset next = availableNowDataStreamWrapper.latestOffset(this.getStartOffset(originalSource), limit);
                                org.apache.spark.sql.connector.read.streaming.Offset latest = availableNowDataStreamWrapper.reportLatestOffset();
                                return new Tuple2((Object)new Tuple2((Object)originalSource, (Object)Option$.MODULE$.apply((Object)next)), (Object)new Tuple2((Object)originalSource, (Object)Option$.MODULE$.apply((Object)latest)));
                            });
                        }
                    }
                    if (tuple2 != null) {
                        SparkDataStream s4 = (SparkDataStream)tuple2._1();
                        ReadLimit limit = (ReadLimit)tuple2._2();
                        if (s4 instanceof SupportsAdmissionControl) {
                            SupportsAdmissionControl supportsAdmissionControl = (SupportsAdmissionControl)s4;
                            this.updateStatusMessage(new StringBuilder(21).append("Getting offsets from ").append(supportsAdmissionControl).toString());
                            return (Tuple2)this.reportTimeTaken("latestOffset", (Function0 & Serializable & scala.Serializable)() -> {
                                org.apache.spark.sql.connector.read.streaming.Offset next = supportsAdmissionControl.latestOffset(this.getStartOffset((SparkDataStream)supportsAdmissionControl), limit);
                                org.apache.spark.sql.connector.read.streaming.Offset latest = supportsAdmissionControl.reportLatestOffset();
                                return new Tuple2((Object)new Tuple2((Object)supportsAdmissionControl, (Object)Option$.MODULE$.apply((Object)next)), (Object)new Tuple2((Object)supportsAdmissionControl, (Object)Option$.MODULE$.apply((Object)latest)));
                            });
                        }
                    }
                    if (tuple2 != null && (s2 = (SparkDataStream)tuple2._1()) instanceof Source) {
                        Source source = (Source)s2;
                        this.updateStatusMessage(new StringBuilder(21).append("Getting offsets from ").append(source).toString());
                        return (Tuple2)this.reportTimeTaken("getOffset", (Function0 & Serializable & scala.Serializable)() -> {
                            Option<Offset> offset = source.getOffset();
                            return new Tuple2((Object)new Tuple2((Object)source, offset), (Object)new Tuple2((Object)source, offset));
                        });
                    }
                    if (tuple2 != null && (s = (SparkDataStream)tuple2._1()) instanceof MicroBatchStream) {
                        MicroBatchStream microBatchStream = (MicroBatchStream)s;
                        this.updateStatusMessage(new StringBuilder(21).append("Getting offsets from ").append(microBatchStream).toString());
                        return (Tuple2)this.reportTimeTaken("latestOffset", (Function0 & Serializable & scala.Serializable)() -> {
                            org.apache.spark.sql.connector.read.streaming.Offset latest = microBatchStream.latestOffset();
                            return new Tuple2((Object)new Tuple2((Object)microBatchStream, (Object)Option$.MODULE$.apply((Object)latest)), (Object)new Tuple2((Object)microBatchStream, (Object)Option$.MODULE$.apply((Object)latest)));
                        });
                    }
                    if (tuple2 != null) {
                        SparkDataStream s5 = (SparkDataStream)tuple2._1();
                        throw new IllegalStateException(new StringBuilder(19).append("Unexpected source: ").append(s5).toString());
                    }
                    throw new MatchError((Object)tuple2);
                }, Seq$.MODULE$.canBuildFrom())).unzip((Function1)Predef$.MODULE$.$conforms());
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Seq nextOffsets = (Seq)tuple2._1();
                Seq recentOffsets = (Seq)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)nextOffsets, (Object)recentOffsets);
                Seq nextOffsets2 = (Seq)tuple22._1();
                Seq recentOffsets2 = (Seq)tuple22._2();
                this.availableOffsets_$eq(this.availableOffsets().$plus$plus((GenTraversableOnce<Tuple2<SparkDataStream, org.apache.spark.sql.connector.read.streaming.Offset>>)((TraversableOnce)((TraversableLike)nextOffsets2.filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)MicroBatchExecution.$anonfun$constructNextBatch$7(x0$2)))).map((Function1 & Serializable & scala.Serializable)p -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(p._1()), ((Option)p._2()).get()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())));
                this.latestOffsets_$eq(this.latestOffsets().$plus$plus((GenTraversableOnce<Tuple2<SparkDataStream, org.apache.spark.sql.connector.read.streaming.Offset>>)((TraversableOnce)((TraversableLike)recentOffsets2.filter((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)MicroBatchExecution.$anonfun$constructNextBatch$9(x0$3)))).map((Function1 & Serializable & scala.Serializable)p -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(p._1()), ((Option)p._2()).get()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())));
                OffsetSeqMetadata qual$1 = this.offsetSeqMetadata();
                long x$1 = this.watermarkTracker().currentWatermark();
                long x$2 = this.super$triggerClock().getTimeMillis();
                scala.collection.immutable.Map<String, String> x$3 = qual$1.copy$default$3();
                this.offsetSeqMetadata_$eq(qual$1.copy(x$1, x$2, x$3));
                boolean lastExecutionRequiresAnotherBatch = noDataBatchesEnabled && Option$.MODULE$.apply((Object)this.lastExecution()).exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.shouldRunAnotherBatch(this.offsetSeqMetadata())));
                boolean shouldConstructNextBatch = this.isNewDataAvailable() || lastExecutionRequiresAnotherBatch;
                this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(113).append("noDataBatchesEnabled = ").append(noDataBatchesEnabled).append(", ").append("lastExecutionRequiresAnotherBatch = ").append(lastExecutionRequiresAnotherBatch).append(", ").append("isNewDataAvailable = ").append(this.isNewDataAvailable()).append(", ").append("shouldConstructNextBatch = ").append(shouldConstructNextBatch).toString());
                if (shouldConstructNextBatch) {
                    this.updateStatusMessage("Writing offsets to log");
                    this.reportTimeTaken("walCommit", (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                        this.markMicroBatchStart();
                        this.cleanUpLastExecutedMicroBatch();
                        if ((long)this.minLogEntriesToMaintain() < this.currentBatchId()) {
                            if (this.useAsyncPurge()) {
                                this.purgeAsync();
                                return;
                            }
                            this.purge(this.currentBatchId() - (long)this.minLogEntriesToMaintain());
                            return;
                        }
                    });
                    this.noNewData_$eq(false);
                } else {
                    this.noNewData_$eq(true);
                    this.awaitProgressLockCondition().signalAll();
                }
                return shouldConstructNextBatch;
            }));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    public void commitSources(OffsetSeq offsetSeq) {
        offsetSeq.toStreamProgress(this.sources()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            MicroBatchExecution.$anonfun$commitSources$1(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void runBatch(SparkSession sparkSessionToRunBatch) {
        LogicalPlan logicalPlan2;
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(14).append("Running batch ").append(this.currentBatchId()).toString());
        Map mutableNewData = Map$.MODULE$.empty().$plus$plus((GenTraversableOnce)this.reportTimeTaken("getBatch", (Function0 & Serializable & scala.Serializable)() -> (scala.collection.immutable.Map)this.availableOffsets().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                SparkDataStream source = (SparkDataStream)tuple2._1();
                org.apache.spark.sql.connector.read.streaming.Offset available = (org.apache.spark.sql.connector.read.streaming.Offset)tuple2._2();
                if (source instanceof Source) {
                    Source source2 = (Source)source;
                    if (available instanceof Offset) {
                        Offset offset = (Offset)available;
                        if (BoxesRunTime.unboxToBoolean((Object)this.committedOffsets().get(source2).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)MicroBatchExecution.$anonfun$runBatch$4(offset, x$7))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true))) {
                            Option current = this.committedOffsets().get(source2).map((Function1 & Serializable & scala.Serializable)x$8 -> (Offset)((Object)((Object)((Object)x$8))));
                            Dataset<Row> batch = source2.getBatch((Option<Offset>)current, offset);
                            Predef$.MODULE$.assert(batch.isStreaming(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("DataFrame returned by getBatch from ").append(source2).append(" did not have isStreaming=true\n").append(batch.queryExecution().logical()).toString());
                            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Retrieving data from ").append(source2).append(": ").append(current).append(" -> ").append((Object)offset).toString());
                            return Option$.MODULE$.option2Iterable((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)source2), (Object)batch.logicalPlan())));
                        }
                    }
                }
            }
            if (tuple2 != null) {
                SparkDataStream stream = (SparkDataStream)tuple2._1();
                org.apache.spark.sql.connector.read.streaming.Offset available = (org.apache.spark.sql.connector.read.streaming.Offset)tuple2._2();
                if (stream instanceof MicroBatchStream) {
                    MicroBatchStream microBatchStream = (MicroBatchStream)stream;
                    if (BoxesRunTime.unboxToBoolean((Object)this.committedOffsets().get((SparkDataStream)microBatchStream).map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)MicroBatchExecution.$anonfun$runBatch$9(available, x$9))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true))) {
                        org.apache.spark.sql.connector.read.streaming.Offset offset;
                        Option current = this.committedOffsets().get((SparkDataStream)microBatchStream).map((Function1 & Serializable & scala.Serializable)off -> microBatchStream.deserializeOffset(off.json()));
                        org.apache.spark.sql.connector.read.streaming.Offset offset2 = available;
                        if (offset2 instanceof SerializedOffset) {
                            SerializedOffset serializedOffset = (SerializedOffset)offset2;
                            offset = microBatchStream.deserializeOffset(serializedOffset.json());
                        } else if (offset2 != null) {
                            org.apache.spark.sql.connector.read.streaming.Offset offset3;
                            offset = offset3 = offset2;
                        } else {
                            throw new MatchError((Object)offset2);
                        }
                        org.apache.spark.sql.connector.read.streaming.Offset endOffset = offset;
                        org.apache.spark.sql.connector.read.streaming.Offset startOffset = (org.apache.spark.sql.connector.read.streaming.Offset)current.getOrElse((Function0 & Serializable & scala.Serializable)() -> microBatchStream.initialOffset());
                        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Retrieving data from ").append(microBatchStream).append(": ").append(current).append(" -> ").append(endOffset).toString());
                        return Option$.MODULE$.option2Iterable((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)microBatchStream), (Object)new OffsetHolder(startOffset, endOffset))));
                    }
                }
            }
            return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom())));
        LogicalPlan newBatchesPlan = (LogicalPlan)this.logicalPlan().transform((PartialFunction)new scala.Serializable(this, mutableNewData){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MicroBatchExecution $outer;
            private final Map mutableNewData$1;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof StreamingExecutionRelation) {
                    StreamingExecutionRelation streamingExecutionRelation = (StreamingExecutionRelation)A1;
                    SparkDataStream source = streamingExecutionRelation.source();
                    Seq<Attribute> output = streamingExecutionRelation.output();
                    Option<CatalogTable> catalogTable = streamingExecutionRelation.catalogTable();
                    return (B1)this.mutableNewData$1.get((Object)source).map((Function1 & Serializable & scala.Serializable)dataPlan -> {
                        boolean hasFileMetadata = output.exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$2.$anonfun$applyOrElse$9(x0$1)));
                        LogicalPlan finalDataPlan = (LogicalPlan)dataPlan.transformUp((PartialFunction)new scala.Serializable(this, hasFileMetadata, catalogTable, source){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$2 $outer;
                            private final boolean hasFileMetadata$1;
                            private final Option catalogTable$1;
                            private final SparkDataStream source$3;

                            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                A1 A1 = x1;
                                if (A1 instanceof LogicalRelation) {
                                    LogicalRelation logicalRelation = (LogicalRelation)A1;
                                    ObjectRef newRelation = ObjectRef.create((Object)((Object)logicalRelation));
                                    if (this.hasFileMetadata$1) {
                                        newRelation.elem = ((LogicalRelation)((Object)newRelation.elem)).withMetadataColumns();
                                    }
                                    if (((LogicalRelation)((Object)newRelation.elem)).catalogTable().isEmpty()) {
                                        this.catalogTable$1.foreach((Function1 & Serializable & scala.Serializable)table -> {
                                            $anonfun$2$$anonfun$3.$anonfun$applyOrElse$10(newRelation, table);
                                            return BoxedUnit.UNIT;
                                        });
                                    } else if (this.catalogTable$1.exists((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$2$$anonfun$3.$anonfun$applyOrElse$11(newRelation, x$10)))) {
                                        this.$outer.org$apache$spark$sql$execution$streaming$MicroBatchExecution$$anonfun$$$outer().logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(71).append("Source ").append($this.source$3).append(" should not produce the information of catalog table by its own.").toString());
                                    }
                                    return (B1)((Object)((LogicalRelation)((Object)newRelation.elem)));
                                }
                                return (B1)function1.apply(x1);
                            }

                            public final boolean isDefinedAt(LogicalPlan x1) {
                                LogicalPlan logicalPlan2 = x1;
                                return logicalPlan2 instanceof LogicalRelation;
                            }

                            public static final /* synthetic */ void $anonfun$applyOrElse$10(ObjectRef newRelation$1, CatalogTable table) {
                                LogicalRelation qual$1 = (LogicalRelation)((Object)newRelation$1.elem);
                                Some x$1 = new Some((Object)table);
                                BaseRelation x$2 = qual$1.copy$default$1();
                                Seq<AttributeReference> x$3 = qual$1.copy$default$2();
                                boolean x$4 = qual$1.copy$default$4();
                                newRelation$1.elem = qual$1.copy(x$2, x$3, (Option<CatalogTable>)x$1, x$4);
                            }

                            public static final /* synthetic */ boolean $anonfun$applyOrElse$11(ObjectRef newRelation$1, CatalogTable x$10) {
                                return x$10 != ((LogicalRelation)((Object)newRelation$1.elem)).catalogTable().get();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.hasFileMetadata$1 = hasFileMetadata$1;
                                this.catalogTable$1 = catalogTable$1;
                                this.source$3 = source$3;
                            }

                            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$10$adapted(scala.runtime.ObjectRef org.apache.spark.sql.catalyst.catalog.CatalogTable ), $anonfun$applyOrElse$11$adapted(scala.runtime.ObjectRef org.apache.spark.sql.catalyst.catalog.CatalogTable ), $anonfun$applyOrElse$12(org.apache.spark.sql.execution.streaming.MicroBatchExecution$$anonfun$2$$anonfun$3 )}, serializedLambda);
                            }
                        });
                        $this.mutableNewData$1.put((Object)source, (Object)finalDataPlan);
                        int maxFields = SQLConf$.MODULE$.get().maxToStringFields();
                        Predef$.MODULE$.assert(output.size() == finalDataPlan.output().size(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Invalid batch: ").append(org.apache.spark.sql.catalyst.util.package$.MODULE$.truncatedString(output, ",", maxFields)).append(" != ").append(org.apache.spark.sql.catalyst.util.package$.MODULE$.truncatedString(finalDataPlan.output(), ",", maxFields)).toString());
                        Seq aliases = (Seq)((TraversableLike)output.zip((GenIterable)finalDataPlan.output(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                            Tuple2 tuple2 = x0$2;
                            if (tuple2 != null) {
                                Attribute from;
                                Attribute to = (Attribute)tuple2._1();
                                Attribute x$1 = from = (Attribute)tuple2._2();
                                String x$2 = to.name();
                                ExprId x$3 = to.exprId();
                                Some x$4 = new Some((Object)from.metadata());
                                Seq x$5 = Alias$.MODULE$.apply$default$4((Expression)x$1, x$2);
                                Seq x$6 = Alias$.MODULE$.apply$default$6((Expression)x$1, x$2);
                                return new Alias((Expression)x$1, x$2, x$3, x$5, (Option)x$4, x$6);
                            }
                            throw new MatchError((Object)tuple2);
                        }, Seq$.MODULE$.canBuildFrom());
                        return new Project(aliases, finalDataPlan);
                    }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                        Seq x$7 = output;
                        boolean x$8 = true;
                        Seq x$9 = LocalRelation$.MODULE$.apply$default$2();
                        return new LocalRelation(x$7, x$9, x$8);
                    });
                }
                if (A1 instanceof StreamingDataSourceV2Relation) {
                    StreamingDataSourceV2Relation streamingDataSourceV2Relation = (StreamingDataSourceV2Relation)A1;
                    return (B1)this.mutableNewData$1.get((Object)streamingDataSourceV2Relation.stream()).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                        LogicalPlan logicalPlan2 = x0$3;
                        if (logicalPlan2 instanceof OffsetHolder) {
                            OffsetHolder offsetHolder = (OffsetHolder)logicalPlan2;
                            org.apache.spark.sql.connector.read.streaming.Offset start = offsetHolder.start();
                            org.apache.spark.sql.connector.read.streaming.Offset end = offsetHolder.end();
                            Some x$10 = new Some((Object)start);
                            Some x$11 = new Some((Object)end);
                            Seq x$12 = streamingDataSourceV2Relation.copy$default$1();
                            Scan x$13 = streamingDataSourceV2Relation.copy$default$2();
                            SparkDataStream x$14 = streamingDataSourceV2Relation.copy$default$3();
                            Option x$15 = streamingDataSourceV2Relation.copy$default$4();
                            Option x$16 = streamingDataSourceV2Relation.copy$default$5();
                            return streamingDataSourceV2Relation.copy(x$12, x$13, x$14, x$15, x$16, (Option)x$10, (Option)x$11);
                        }
                        throw new MatchError((Object)logicalPlan2);
                    }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                        Seq x$17 = streamingDataSourceV2Relation.output();
                        boolean x$18 = true;
                        Seq x$19 = LocalRelation$.MODULE$.apply$default$2();
                        return new LocalRelation(x$17, x$19, x$18);
                    });
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan2 = x1;
                if (logicalPlan2 instanceof StreamingExecutionRelation) {
                    return true;
                }
                return logicalPlan2 instanceof StreamingDataSourceV2Relation;
            }

            public /* synthetic */ MicroBatchExecution org$apache$spark$sql$execution$streaming$MicroBatchExecution$$anonfun$$$outer() {
                return this.$outer;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$9(Attribute x0$1) {
                AttributeReference attributeReference;
                Option option;
                Attribute attribute = x0$1;
                return attribute instanceof AttributeReference && !(option = FileSourceMetadataAttribute$.MODULE$.unapply(attributeReference = (AttributeReference)attribute)).isEmpty();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.mutableNewData$1 = mutableNewData$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$8(org.apache.spark.sql.execution.streaming.MicroBatchExecution$$anonfun$2 scala.collection.Seq scala.Option org.apache.spark.sql.connector.read.streaming.SparkDataStream org.apache.spark.sql.catalyst.plans.logical.LogicalPlan ), $anonfun$applyOrElse$15(scala.collection.Seq ), $anonfun$applyOrElse$16(org.apache.spark.sql.execution.datasources.v2.StreamingDataSourceV2Relation org.apache.spark.sql.catalyst.plans.logical.LogicalPlan ), $anonfun$applyOrElse$17(org.apache.spark.sql.execution.datasources.v2.StreamingDataSourceV2Relation ), $anonfun$applyOrElse$9$adapted(org.apache.spark.sql.catalyst.expressions.Attribute ), $anonfun$applyOrElse$13(scala.collection.Seq int org.apache.spark.sql.catalyst.plans.logical.LogicalPlan ), $anonfun$applyOrElse$14(scala.Tuple2 )}, serializedLambda);
            }
        });
        this.newData_$eq((scala.collection.immutable.Map<SparkDataStream, LogicalPlan>)mutableNewData.toMap(Predef$.MODULE$.$conforms()));
        LogicalPlan newAttributePlan = newBatchesPlan.transformAllExpressionsWithPruning((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.containsPattern(TreePattern$.MODULE$.CURRENT_LIKE())), newBatchesPlan.transformAllExpressionsWithPruning$default$2(), (PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MicroBatchExecution $outer;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (A1 instanceof CurrentTimestamp) {
                    CurrentTimestamp currentTimestamp = (CurrentTimestamp)A1;
                    return (B1)new CurrentBatchTimestamp(this.$outer.offsetSeqMetadata().batchTimestampMs(), currentTimestamp.dataType(), (Option)new Some((Object)"Dummy TimeZoneId"));
                }
                if (A1 instanceof LocalTimestamp) {
                    LocalTimestamp localTimestamp = (LocalTimestamp)A1;
                    return (B1)new CurrentBatchTimestamp(this.$outer.offsetSeqMetadata().batchTimestampMs(), localTimestamp.dataType(), localTimestamp.timeZoneId());
                }
                if (A1 instanceof CurrentDate) {
                    CurrentDate currentDate = (CurrentDate)A1;
                    return (B1)new CurrentBatchTimestamp(this.$outer.offsetSeqMetadata().batchTimestampMs(), currentDate.dataType(), currentDate.timeZoneId());
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(Expression x2) {
                Expression expression = x2;
                if (expression instanceof CurrentTimestamp) {
                    return true;
                }
                if (expression instanceof LocalTimestamp) {
                    return true;
                }
                return expression instanceof CurrentDate;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Table table = this.sink();
        if (table instanceof Sink) {
            logicalPlan2 = ((WriteToMicroBatchDataSourceV1)newAttributePlan).withNewBatchId(this.currentBatchId());
        } else if (table instanceof SupportsWrite) {
            logicalPlan2 = ((WriteToMicroBatchDataSource)newAttributePlan).withNewBatchId(this.currentBatchId());
        } else {
            throw new IllegalArgumentException(new StringBuilder(22).append("unknown sink type for ").append(this.sink()).toString());
        }
        WriteToMicroBatchDataSourceV1 triggerLogicalPlan = logicalPlan2;
        sparkSessionToRunBatch.sparkContext().setLocalProperty(MicroBatchExecution$.MODULE$.BATCH_ID_KEY(), Long.toString(this.currentBatchId()));
        sparkSessionToRunBatch.sparkContext().setLocalProperty(StreamExecution$.MODULE$.IS_CONTINUOUS_PROCESSING(), Boolean.toString(false));
        this.reportTimeTaken("queryPlanning", (Function0 & Serializable & scala.Serializable)() -> {
            this.lastExecution_$eq(new IncrementalExecution(sparkSessionToRunBatch, triggerLogicalPlan, this.outputMode(), this.checkpointFile("state"), this.id(), this.runId(), this.currentBatchId(), this.offsetLog().offsetSeqMetadataForBatchId(this.currentBatchId() - 1L), this.offsetSeqMetadata(), this.watermarkPropagator()));
            return this.lastExecution().executedPlan();
        });
        this.markMicroBatchExecutionStart();
        Dataset nextBatch = new Dataset(this.lastExecution(), ExpressionEncoder$.MODULE$.apply(this.lastExecution().analyzed().schema()));
        Option batchSinkProgress = (Option)this.reportTimeTaken("addBatch", (Function0 & Serializable & scala.Serializable)() -> (Option)SQLExecution$.MODULE$.withNewExecutionId(this.lastExecution(), SQLExecution$.MODULE$.withNewExecutionId$default$2(), (Function0 & Serializable & scala.Serializable)() -> {
            Table table = this.sink();
            if (table instanceof Sink) {
                Sink sink = (Sink)table;
                sink.addBatch(this.currentBatchId(), nextBatch);
                $this.plan.catalogTable().foreach((Function1 & Serializable & scala.Serializable)tbl -> {
                    MicroBatchExecution.$anonfun$runBatch$18(this, tbl);
                    return BoxedUnit.UNIT;
                });
            } else if (table instanceof SupportsWrite) {
                nextBatch.collect();
            } else {
                throw new MatchError((Object)table);
            }
            SparkPlan sparkPlan = this.lastExecution().executedPlan();
            if (sparkPlan instanceof WriteToDataSourceV2Exec) {
                WriteToDataSourceV2Exec writeToDataSourceV2Exec = (WriteToDataSourceV2Exec)sparkPlan;
                return writeToDataSourceV2Exec.commitProgress();
            }
            return None$.MODULE$;
        }));
        this.withProgressLocked((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sinkCommitProgress_$eq((Option<StreamWriterCommitProgress>)batchSinkProgress);
            this.markMicroBatchEnd();
        });
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Completed batch ").append(this.currentBatchId()).toString());
    }

    public void markMicroBatchStart() {
        if (!this.offsetLog().add(this.currentBatchId(), this.availableOffsets().toOffsetSeq(this.sources(), this.offsetSeqMetadata()))) {
            throw QueryExecutionErrors$.MODULE$.concurrentStreamLogUpdate(this.currentBatchId());
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Committed offsets for batch ").append(this.currentBatchId()).append(". ").append("Metadata ").append(this.offsetSeqMetadata().toString()).toString());
    }

    public void markMicroBatchExecutionStart() {
    }

    public void markMicroBatchEnd() {
        this.watermarkTracker().updateWatermark(this.lastExecution().executedPlan());
        this.reportTimeTaken("commitOffsets", (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (!this.commitLog().add(this.currentBatchId(), new CommitMetadata(this.watermarkTracker().currentWatermark()))) {
                throw QueryExecutionErrors$.MODULE$.concurrentStreamLogUpdate(this.currentBatchId());
            }
        });
        this.committedOffsets_$eq(this.committedOffsets().$plus$plus((GenTraversableOnce<Tuple2<SparkDataStream, org.apache.spark.sql.connector.read.streaming.Offset>>)this.availableOffsets()));
    }

    public void cleanUpLastExecutedMicroBatch() {
        if (this.currentBatchId() != 0L) {
            Option prevBatchOff = this.offsetLog().get(this.currentBatchId() - 1L);
            if (prevBatchOff.isDefined()) {
                this.commitSources((OffsetSeq)prevBatchOff.get());
                this.watermarkPropagator().purge(this.currentBatchId() - 2L);
                return;
            }
            throw new IllegalStateException(new StringBuilder(20).append("batch ").append(this.currentBatchId() - 1L).append(" doesn't exist").toString());
        }
    }

    public <T> T withProgressLocked(Function0<T> f) {
        Object object;
        this.awaitProgressLock().lock();
        try {
            object = f.apply();
        }
        finally {
            this.awaitProgressLock().unlock();
        }
        return (T)object;
    }

    public static final /* synthetic */ void $anonfun$populateStartOffsets$2(MicroBatchExecution $this, SparkSession sparkSessionToRunBatches$1, OffsetSeqMetadata metadata) {
        OffsetSeqMetadata$.MODULE$.setSessionConf(metadata, sparkSessionToRunBatches$1.conf());
        $this.offsetSeqMetadata_$eq(OffsetSeqMetadata$.MODULE$.apply(metadata.batchWatermarkMs(), metadata.batchTimestampMs(), sparkSessionToRunBatches$1.conf()));
        $this.watermarkTracker_$eq(WatermarkTracker$.MODULE$.apply(sparkSessionToRunBatches$1.conf()));
        $this.watermarkTracker().setWatermark(metadata.batchWatermarkMs());
    }

    public static final /* synthetic */ boolean $anonfun$populateStartOffsets$7(Offset x3$1, Offset x$4) {
        Offset offset = x$4;
        Offset offset2 = x3$1;
        return !(offset != null ? !((Object)((Object)offset)).equals((Object)offset2) : offset2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$isNewDataAvailable$2(org.apache.spark.sql.connector.read.streaming.Offset available$1, org.apache.spark.sql.connector.read.streaming.Offset committed) {
        org.apache.spark.sql.connector.read.streaming.Offset offset = committed;
        org.apache.spark.sql.connector.read.streaming.Offset offset2 = available$1;
        return offset == null ? offset2 != null : !offset.equals(offset2);
    }

    public static final /* synthetic */ boolean $anonfun$isNewDataAvailable$1(MicroBatchExecution $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            SparkDataStream source = (SparkDataStream)tuple2._1();
            org.apache.spark.sql.connector.read.streaming.Offset available = (org.apache.spark.sql.connector.read.streaming.Offset)tuple2._2();
            return BoxesRunTime.unboxToBoolean((Object)$this.committedOffsets().get(source).map((Function1 & Serializable & scala.Serializable)committed -> BoxesRunTime.boxToBoolean((boolean)MicroBatchExecution.$anonfun$isNewDataAvailable$2(available, committed))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$constructNextBatch$7(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            Option o = (Option)tuple2._2();
            return o.nonEmpty();
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$constructNextBatch$9(Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            Option o = (Option)tuple2._2();
            return o.nonEmpty();
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$commitSources$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            SparkDataStream src = (SparkDataStream)tuple2._1();
            org.apache.spark.sql.connector.read.streaming.Offset off = (org.apache.spark.sql.connector.read.streaming.Offset)tuple2._2();
            if (src instanceof Source) {
                Source source = (Source)src;
                if (off instanceof Offset) {
                    Offset offset = (Offset)off;
                    source.commit(offset);
                    return;
                }
            }
        }
        if (tuple2 != null) {
            SparkDataStream stream = (SparkDataStream)tuple2._1();
            org.apache.spark.sql.connector.read.streaming.Offset off = (org.apache.spark.sql.connector.read.streaming.Offset)tuple2._2();
            if (stream instanceof MicroBatchStream) {
                MicroBatchStream microBatchStream = (MicroBatchStream)stream;
                microBatchStream.commit(microBatchStream.deserializeOffset(off.json()));
                return;
            }
        }
        if (tuple2 != null) {
            SparkDataStream src = (SparkDataStream)tuple2._1();
            throw new IllegalArgumentException(new StringBuilder(47).append("Unknown source is found at constructNextBatch: ").append(src).toString());
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$runBatch$4(Offset x3$3, org.apache.spark.sql.connector.read.streaming.Offset x$7) {
        org.apache.spark.sql.connector.read.streaming.Offset offset = x$7;
        Offset offset2 = x3$3;
        return offset == null ? offset2 != null : !offset.equals((Object)offset2);
    }

    public static final /* synthetic */ boolean $anonfun$runBatch$9(org.apache.spark.sql.connector.read.streaming.Offset available$2, org.apache.spark.sql.connector.read.streaming.Offset x$9) {
        org.apache.spark.sql.connector.read.streaming.Offset offset = x$9;
        org.apache.spark.sql.connector.read.streaming.Offset offset2 = available$2;
        return offset == null ? offset2 != null : !offset.equals(offset2);
    }

    public static final /* synthetic */ void $anonfun$runBatch$18(MicroBatchExecution $this, CatalogTable tbl) {
        $this.org$apache$spark$sql$execution$streaming$MicroBatchExecution$$super$sparkSession().catalog().refreshTable(tbl.identifier().quotedString());
    }

    public MicroBatchExecution(SparkSession sparkSession, Trigger trigger, Clock triggerClock, scala.collection.immutable.Map<String, String> extraOptions, WriteToStream plan) {
        Product product;
        this.extraOptions = extraOptions;
        this.plan = plan;
        super(sparkSession, plan.name(), plan.resolvedCheckpointLocation(), plan.inputQuery(), plan.sink(), trigger, triggerClock, plan.outputMode(), plan.deleteCheckpointOnStop());
        AsyncLogPurge.$init$(this);
        this.errorNotifier = new ErrorNotifier();
        this.sources = (Seq)Nil$.MODULE$;
        Trigger trigger2 = super.trigger();
        if (trigger2 instanceof ProcessingTimeTrigger) {
            ProcessingTimeTrigger processingTimeTrigger = (ProcessingTimeTrigger)trigger2;
            product = new ProcessingTimeExecutor(processingTimeTrigger, super.triggerClock());
        } else if (OneTimeTrigger$.MODULE$.equals(trigger2)) {
            product = new SingleBatchExecutor();
        } else if (AvailableNowTrigger$.MODULE$.equals(trigger2)) {
            product = new MultiBatchExecutor();
        } else {
            throw new IllegalStateException(new StringBuilder(25).append("Unknown type of trigger: ").append(super.trigger()).toString());
        }
        this.triggerExecutor = product;
        this.isCurrentBatchConstructed = false;
        this.watermarkPropagator = WatermarkPropagator$.MODULE$.apply(super.sparkSession().sessionState().conf());
    }
}

