/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Queue;
import java.util.Random;
import org.apache.spark.LocalSparkContext;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.memory.MemoryTestingUtils$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.ExternalAppendOnlyUnsafeRowArray;
import org.apache.spark.util.collection.unsafe.sort.UnsafeSorterIterator;
import org.apache.spark.util.collection.unsafe.sort.UnsafeSorterSpillReader;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Ma\u0001\u0002\b\u0010\u0001iAQA\t\u0001\u0005\u0002\rBqA\n\u0001C\u0002\u0013%q\u0005\u0003\u00041\u0001\u0001\u0006I\u0001\u000b\u0005\u0006c\u0001!IA\r\u0005\u0006\u0013\u0002!IA\u0013\u0005\u0006!\u0002!I!\u0015\u0005\u0006U\u0002!Ia\u001b\u0005\u0006o\u0002!I\u0001\u001f\u0005\u0006o\u0002!I\u0001 \u0005\b\u0003\u0007\u0001A\u0011BA\u0003\u0011\u001d\t9\u0001\u0001C\u0005\u0003\u0013Aq!a\u0003\u0001\t\u0013\tI\u0001C\u0004\u0002\u000e\u0001!I!a\u0004\u0003K\u0015CH/\u001a:oC2\f\u0005\u000f]3oI>sG._+og\u00064WMU8x\u0003J\u0014\u0018-_*vSR,'B\u0001\t\u0012\u0003%)\u00070Z2vi&|gN\u0003\u0002\u0013'\u0005\u00191/\u001d7\u000b\u0005Q)\u0012!B:qCJ\\'B\u0001\f\u0018\u0003\u0019\t\u0007/Y2iK*\t\u0001$A\u0002pe\u001e\u001c\u0001aE\u0002\u00017}\u0001\"\u0001H\u000f\u000e\u0003MI!AH\n\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\ta\u0002%\u0003\u0002\"'\t\tBj\\2bYN\u0003\u0018M]6D_:$X\r\u001f;\u0002\rqJg.\u001b;?)\u0005!\u0003CA\u0013\u0001\u001b\u0005y\u0011A\u0002:b]\u0012|W.F\u0001)!\tIc&D\u0001+\u0015\tYC&\u0001\u0003vi&d'\"A\u0017\u0002\t)\fg/Y\u0005\u0003_)\u0012aAU1oI>l\u0017a\u0002:b]\u0012|W\u000eI\u0001\u0012o&$\b.\u0012=uKJt\u0017\r\\!se\u0006LHcA\u001aC\u000fR\u0011AG\u000f\t\u0003kaj\u0011A\u000e\u0006\u0002o\u0005)1oY1mC&\u0011\u0011H\u000e\u0002\u0005+:LG\u000fC\u0003<\t\u0001\u0007A(A\u0001g!\u0011)Th\u0010\u001b\n\u0005y2$!\u0003$v]\u000e$\u0018n\u001c82!\t)\u0003)\u0003\u0002B\u001f\t\u0001S\t\u001f;fe:\fG.\u00119qK:$wJ\u001c7z+:\u001c\u0018MZ3S_^\f%O]1z\u0011\u0015\u0019E\u00011\u0001E\u0003EIg.T3n_JLH\u000b\u001b:fg\"|G\u000e\u001a\t\u0003k\u0015K!A\u0012\u001c\u0003\u0007%sG\u000fC\u0003I\t\u0001\u0007A)\u0001\bta&dG\u000e\u00165sKNDw\u000e\u001c3\u0002\u0013%t7/\u001a:u%><HCA&O!\t)D*\u0003\u0002Nm\t!Aj\u001c8h\u0011\u0015yU\u00011\u0001@\u0003\u0015\t'O]1z\u0003I\u0019\u0007.Z2l\u0013\u001a4\u0016\r\\;f\u000bbL7\u000f^:\u0015\u0007Q\u0012\u0006\u000eC\u0003T\r\u0001\u0007A+\u0001\u0005ji\u0016\u0014\u0018\r^8s!\r)V\f\u0019\b\u0003-ns!a\u0016.\u000e\u0003aS!!W\r\u0002\rq\u0012xn\u001c;?\u0013\u00059\u0014B\u0001/7\u0003\u001d\u0001\u0018mY6bO\u0016L!AX0\u0003\u0011%#XM]1u_JT!\u0001\u0018\u001c\u0011\u0005\u00054W\"\u00012\u000b\u0005\r$\u0017aC3yaJ,7o]5p]NT!!Z\t\u0002\u0011\r\fG/\u00197zgRL!a\u001a2\u0003\u0013Us7/\u00194f%><\b\"B5\u0007\u0001\u0004Y\u0015!D3ya\u0016\u001cG/\u001a3WC2,X-\u0001\u0007wC2LG-\u0019;f\t\u0006$\u0018\rF\u0002UY6DQaT\u0004A\u0002}BQA\\\u0004A\u0002=\fa\"\u001a=qK\u000e$X\r\u001a,bYV,7\u000fE\u0002qk.k\u0011!\u001d\u0006\u0003eN\fq!\\;uC\ndWM\u0003\u0002um\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005Y\f(aC!se\u0006L()\u001e4gKJ\fA\u0002]8qk2\fG/\u001a*poN$2a\\={\u0011\u0015y\u0005\u00021\u0001@\u0011\u0015Y\b\u00021\u0001E\u0003QqW/\u001c*poN$vNQ3Q_B,H.\u0019;fIR!q. @\u0000\u0011\u0015y\u0015\u00021\u0001@\u0011\u0015Y\u0018\u00021\u0001E\u0011\u0019\t\t!\u0003a\u0001_\u0006y\u0001o\u001c9vY\u0006$X\r\u001a,bYV,7/\u0001\nhKRtU/\u001c\"zi\u0016\u001c8\u000b]5mY\u0016$W#A&\u0002\u001b\u0005\u001c8/\u001a:u\u001d>\u001c\u0006/\u001b7m)\u0005!\u0014aC1tg\u0016\u0014Ho\u00159jY2\f1h\u00195fG.LE/\u001a:bi>\u00148\t\\8tK\u0012<\u0006.\u001a8UQJ|woQ8oGV\u0014(/\u001a8u\u001b>$\u0017NZ5dCRLwN\\#yG\u0016\u0004H/[8o)\r!\u0014\u0011\u0003\u0005\u0006'6\u0001\r\u0001\u0016")
public class ExternalAppendOnlyUnsafeRowArraySuite
extends SparkFunSuite
implements LocalSparkContext {
    private final Random random;
    private transient SparkContext sc;

    public /* synthetic */ void org$apache$spark$LocalSparkContext$$super$beforeAll() {
        super.beforeAll();
    }

    public /* synthetic */ void org$apache$spark$LocalSparkContext$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    public void beforeAll() {
        LocalSparkContext.beforeAll$((LocalSparkContext)this);
    }

    public void afterEach() {
        LocalSparkContext.afterEach$((LocalSparkContext)this);
    }

    public void resetSparkContext() {
        LocalSparkContext.resetSparkContext$((LocalSparkContext)this);
    }

    public SparkContext sc() {
        return this.sc;
    }

    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    private Random random() {
        return this.random;
    }

    private void withExternalArray(int inMemoryThreshold, int spillThreshold, Function1<ExternalAppendOnlyUnsafeRowArray, BoxedUnit> f) {
        this.sc_$eq(new SparkContext("local", "test", new SparkConf(false)));
        TaskContext taskContext = MemoryTestingUtils$.MODULE$.fakeTaskContext(SparkEnv$.MODULE$.get());
        TaskContext$.MODULE$.setTaskContext(taskContext);
        try {
            ExternalAppendOnlyUnsafeRowArray array = new ExternalAppendOnlyUnsafeRowArray(taskContext.taskMemoryManager(), SparkEnv$.MODULE$.get().blockManager(), SparkEnv$.MODULE$.get().serializerManager(), taskContext, 1024, SparkEnv$.MODULE$.get().memoryManager().pageSizeBytes(), inMemoryThreshold, spillThreshold);
            try {
                f.apply((Object)array);
            }
            finally {
                array.clear();
            }
        }
        finally {
            TaskContext$.MODULE$.unset();
        }
    }

    private long insertRow(ExternalAppendOnlyUnsafeRowArray array) {
        long valueInserted = this.random().nextLong();
        UnsafeRow row = new UnsafeRow(1);
        row.pointTo(new byte[64], 16);
        row.setLong(0, valueInserted);
        array.add(row);
        return valueInserted;
    }

    private void checkIfValueExists(Iterator<UnsafeRow> iterator, long expectedValue) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(iterator.hasNext(), "iterator.hasNext", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        UnsafeRow actualRow = (UnsafeRow)iterator.next();
        long $org_scalatest_assert_macro_left = actualRow.getLong(0);
        long $org_scalatest_assert_macro_right = expectedValue;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
        int $org_scalatest_assert_macro_left2 = actualRow.getSizeInBytes();
        int $org_scalatest_assert_macro_right2 = 16;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
    }

    private Iterator<UnsafeRow> validateData(ExternalAppendOnlyUnsafeRowArray array, ArrayBuffer<Object> expectedValues) {
        Iterator iterator = array.generateIterator();
        expectedValues.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)value -> this.checkIfValueExists((Iterator<UnsafeRow>)iterator, value));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(iterator.hasNext(), "iterator.hasNext", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
        return iterator;
    }

    private ArrayBuffer<Object> populateRows(ExternalAppendOnlyUnsafeRowArray array, int numRowsToBePopulated) {
        ArrayBuffer populatedValues = new ArrayBuffer();
        return this.populateRows(array, numRowsToBePopulated, (ArrayBuffer<Object>)populatedValues);
    }

    private ArrayBuffer<Object> populateRows(ExternalAppendOnlyUnsafeRowArray array, int numRowsToBePopulated, ArrayBuffer<Object> populatedValues) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRowsToBePopulated).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> populatedValues.append((Seq)Predef$.MODULE$.wrapLongArray(new long[]{this.insertRow(array)})));
        return populatedValues;
    }

    private long getNumBytesSpilled() {
        return TaskContext$.MODULE$.get().taskMetrics().memoryBytesSpilled();
    }

    private void assertNoSpill() {
        long $org_scalatest_assert_macro_left = this.getNumBytesSpilled();
        int $org_scalatest_assert_macro_right = 0;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
    }

    private void assertSpill() {
        long $org_scalatest_assert_macro_left = this.getNumBytesSpilled();
        int $org_scalatest_assert_macro_right = 0;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
    }

    private void checkIteratorClosedWhenThrowConcurrentModificationException(Iterator<UnsafeRow> iterator) {
        if (iterator.getClass().getSimpleName().equals("SpillableArrayIterator")) {
            Object current;
            Object chainedIterator = ExternalAppendOnlyUnsafeRowArraySuite.getFieldValue$1(iterator, "iterator");
            Object $org_scalatest_assert_macro_left = current = ExternalAppendOnlyUnsafeRowArraySuite.getFieldValue$1(chainedIterator, "current");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool($org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.spark.util.collection.unsafe.sort.UnsafeSorterIterator", $org_scalatest_assert_macro_left instanceof UnsafeSorterIterator, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 405));
            ExternalAppendOnlyUnsafeRowArraySuite.checkUnsafeSorterSpillReaderClosed$1((UnsafeSorterIterator)current);
            Object iterators = ExternalAppendOnlyUnsafeRowArraySuite.getFieldValue$1(chainedIterator, "iterators");
            ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)((Queue)iterators)).asScala()).foreach((Function1 & Serializable & scala.Serializable)unsafeSorterIterator -> {
                ExternalAppendOnlyUnsafeRowArraySuite.checkUnsafeSorterSpillReaderClosed$1(unsafeSorterIterator);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$new$2(ExternalAppendOnlyUnsafeRowArraySuite $this, int inMemoryThreshold$1, ExternalAppendOnlyUnsafeRowArray array) {
        ExternalAppendOnlyUnsafeRowArray $org_scalatest_assert_macro_left = array;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
        ArrayBuffer<Object> expectedValues = $this.populateRows(array, 1);
        ExternalAppendOnlyUnsafeRowArray $org_scalatest_assert_macro_left2 = array;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
        ExternalAppendOnlyUnsafeRowArray $org_scalatest_assert_macro_left3 = array;
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
        Iterator<UnsafeRow> iterator1 = $this.validateData(array, expectedValues);
        $this.populateRows(array, inMemoryThreshold$1 - 1, expectedValues);
        ExternalAppendOnlyUnsafeRowArray $org_scalatest_assert_macro_left4 = array;
        int $org_scalatest_assert_macro_right2 = inMemoryThreshold$1;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
        $this.assertNoSpill();
        Iterator<UnsafeRow> iterator2 = $this.validateData(array, expectedValues);
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(iterator1.hasNext(), "iterator1.hasNext", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(iterator2.hasNext(), "iterator2.hasNext", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
    }

    public static final /* synthetic */ void $anonfun$new$4(ExternalAppendOnlyUnsafeRowArraySuite $this, int inMemoryThreshold$2, int spillThreshold$1, ExternalAppendOnlyUnsafeRowArray array) {
        ExternalAppendOnlyUnsafeRowArray $org_scalatest_assert_macro_left = array;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
        ArrayBuffer<Object> expectedValues = $this.populateRows(array, inMemoryThreshold$2 - 1);
        ExternalAppendOnlyUnsafeRowArray $org_scalatest_assert_macro_left2 = array;
        int $org_scalatest_assert_macro_right = inMemoryThreshold$2 - 1;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
        Iterator<UnsafeRow> iterator1 = $this.validateData(array, expectedValues);
        $this.assertNoSpill();
        $this.populateRows(array, spillThreshold$1 - expectedValues.length() - 1, expectedValues);
        ExternalAppendOnlyUnsafeRowArray $org_scalatest_assert_macro_left3 = array;
        int $org_scalatest_assert_macro_right2 = spillThreshold$1 - 1;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
        $this.assertNoSpill();
        Iterator<UnsafeRow> iterator2 = $this.validateData(array, expectedValues);
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(iterator2.hasNext(), "iterator2.hasNext", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(iterator1.hasNext(), "iterator1.hasNext", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
        $this.intercept((Function0 & Serializable & scala.Serializable)() -> (UnsafeRow)iterator1.next(), ClassTag$.MODULE$.apply(ConcurrentModificationException.class), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
        $this.checkIteratorClosedWhenThrowConcurrentModificationException(iterator1);
    }

    public static final /* synthetic */ void $anonfun$new$7(ExternalAppendOnlyUnsafeRowArraySuite $this, int inMemoryThreshold$3, ExternalAppendOnlyUnsafeRowArray array) {
        ExternalAppendOnlyUnsafeRowArray $org_scalatest_assert_macro_left = array;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
        ArrayBuffer<Object> expectedValues = $this.populateRows(array, inMemoryThreshold$3 - 1);
        ExternalAppendOnlyUnsafeRowArray $org_scalatest_assert_macro_left2 = array;
        int $org_scalatest_assert_macro_right = inMemoryThreshold$3 - 1;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
        Iterator<UnsafeRow> iterator1 = $this.validateData(array, expectedValues);
        $this.assertNoSpill();
        $this.populateRows(array, 2, expectedValues);
        ExternalAppendOnlyUnsafeRowArray $org_scalatest_assert_macro_left3 = array;
        int $org_scalatest_assert_macro_right2 = inMemoryThreshold$3 + 1;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
        $this.assertSpill();
        Iterator<UnsafeRow> iterator2 = $this.validateData(array, expectedValues);
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(iterator2.hasNext(), "iterator2.hasNext", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(iterator1.hasNext(), "iterator1.hasNext", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
        $this.intercept((Function0 & Serializable & scala.Serializable)() -> (UnsafeRow)iterator1.next(), ClassTag$.MODULE$.apply(ConcurrentModificationException.class), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
        $this.checkIteratorClosedWhenThrowConcurrentModificationException(iterator1);
    }

    public static final /* synthetic */ void $anonfun$new$10(ExternalAppendOnlyUnsafeRowArray array) {
        Iterator iterator = array.generateIterator();
        ExternalAppendOnlyUnsafeRowArray $org_scalatest_assert_macro_left = array;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
        ExternalAppendOnlyUnsafeRowArray $org_scalatest_assert_macro_left2 = array;
        int $org_scalatest_assert_macro_right = 0;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(iterator.hasNext(), "iterator.hasNext", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
    }

    public static final /* synthetic */ void $anonfun$new$12(ExternalAppendOnlyUnsafeRowArraySuite $this, ExternalAppendOnlyUnsafeRowArray array) {
        ArrayIndexOutOfBoundsException exception = (ArrayIndexOutOfBoundsException)$this.intercept((Function0 & Serializable & scala.Serializable)() -> array.generateIterator(-10), ClassTag$.MODULE$.apply(ArrayIndexOutOfBoundsException.class), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
        String $org_scalatest_assert_macro_left = exception.getMessage();
        String $org_scalatest_assert_macro_right = "Invalid `startIndex` provided for generating iterator over the array";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
    }

    public static final /* synthetic */ void $anonfun$new$15(ExternalAppendOnlyUnsafeRowArraySuite $this, int spillThreshold$2, ExternalAppendOnlyUnsafeRowArray array) {
        $this.populateRows(array, spillThreshold$2 / 2);
        ArrayIndexOutOfBoundsException exception = (ArrayIndexOutOfBoundsException)$this.intercept((Function0 & Serializable & scala.Serializable)() -> array.generateIterator(spillThreshold$2 * 10), ClassTag$.MODULE$.apply(ArrayIndexOutOfBoundsException.class), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 215));
        String $org_scalatest_assert_macro_left = exception.getMessage();
        String $org_scalatest_assert_macro_right = "Invalid `startIndex` provided for generating iterator over the array";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
    }

    public static final /* synthetic */ void $anonfun$new$18(ExternalAppendOnlyUnsafeRowArraySuite $this, int spillThreshold$3, ExternalAppendOnlyUnsafeRowArray array) {
        $this.populateRows(array, spillThreshold$3 * 2);
        ArrayIndexOutOfBoundsException exception = (ArrayIndexOutOfBoundsException)$this.intercept((Function0 & Serializable & scala.Serializable)() -> array.generateIterator(spillThreshold$3 * 10), ClassTag$.MODULE$.apply(ArrayIndexOutOfBoundsException.class), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 228));
        String $org_scalatest_assert_macro_left = exception.getMessage();
        String $org_scalatest_assert_macro_right = "Invalid `startIndex` provided for generating iterator over the array";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 231));
    }

    public static final /* synthetic */ void $anonfun$new$21(ExternalAppendOnlyUnsafeRowArraySuite $this, int inMemoryThreshold$4, ExternalAppendOnlyUnsafeRowArray array) {
        ArrayBuffer<Object> expectedValues = $this.populateRows(array, inMemoryThreshold$4);
        int startIndex = inMemoryThreshold$4 / 2;
        Iterator iterator = array.generateIterator(startIndex);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(startIndex), expectedValues.length()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> $this.checkIfValueExists((Iterator<UnsafeRow>)iterator, BoxesRunTime.unboxToLong((Object)expectedValues.apply(i))));
    }

    public static final /* synthetic */ void $anonfun$new$24(ExternalAppendOnlyUnsafeRowArraySuite $this, int spillThreshold$4, ExternalAppendOnlyUnsafeRowArray array) {
        ArrayBuffer<Object> expectedValues = $this.populateRows(array, spillThreshold$4 * 10);
        int startIndex = spillThreshold$4 * 2;
        Iterator iterator = array.generateIterator(startIndex);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(startIndex), expectedValues.length()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> $this.checkIfValueExists((Iterator<UnsafeRow>)iterator, BoxesRunTime.unboxToLong((Object)expectedValues.apply(i))));
    }

    public static final /* synthetic */ void $anonfun$new$27(ExternalAppendOnlyUnsafeRowArraySuite $this, ExternalAppendOnlyUnsafeRowArray array) {
        $this.populateRows(array, 2);
        ObjectRef iterator = ObjectRef.create((Object)array.generateIterator());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(((Iterator)iterator.elem).hasNext(), "iterator.hasNext", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 266));
        ((Iterator)iterator.elem).next();
        $this.populateRows(array, 1);
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(((Iterator)iterator.elem).hasNext(), "iterator.hasNext", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 271));
        $this.intercept((Function0 & Serializable & scala.Serializable)() -> (UnsafeRow)((Iterator)iterator$4.elem).next(), ClassTag$.MODULE$.apply(ConcurrentModificationException.class), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 272));
        $this.checkIteratorClosedWhenThrowConcurrentModificationException((Iterator<UnsafeRow>)((Iterator)iterator.elem));
        iterator.elem = array.generateIterator();
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(((Iterator)iterator.elem).hasNext(), "iterator.hasNext", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 277));
        ((Iterator)iterator.elem).next();
        array.clear();
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(((Iterator)iterator.elem).hasNext(), "iterator.hasNext", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
        $this.intercept((Function0 & Serializable & scala.Serializable)() -> (UnsafeRow)((Iterator)iterator$4.elem).next(), ClassTag$.MODULE$.apply(ConcurrentModificationException.class), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 282));
        $this.checkIteratorClosedWhenThrowConcurrentModificationException((Iterator<UnsafeRow>)((Iterator)iterator.elem));
    }

    public static final /* synthetic */ void $anonfun$new$31(ExternalAppendOnlyUnsafeRowArraySuite $this, int spillThreshold$5, ExternalAppendOnlyUnsafeRowArray array) {
        $this.populateRows(array, spillThreshold$5 * 2);
        $this.assertSpill();
        ObjectRef iterator = ObjectRef.create((Object)array.generateIterator());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(((Iterator)iterator.elem).hasNext(), "iterator.hasNext", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 295));
        ((Iterator)iterator.elem).next();
        $this.populateRows(array, 1);
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(((Iterator)iterator.elem).hasNext(), "iterator.hasNext", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 300));
        $this.intercept((Function0 & Serializable & scala.Serializable)() -> (UnsafeRow)((Iterator)iterator$5.elem).next(), ClassTag$.MODULE$.apply(ConcurrentModificationException.class), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 301));
        $this.checkIteratorClosedWhenThrowConcurrentModificationException((Iterator<UnsafeRow>)((Iterator)iterator.elem));
        iterator.elem = array.generateIterator();
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(((Iterator)iterator.elem).hasNext(), "iterator.hasNext", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 306));
        ((Iterator)iterator.elem).next();
        array.clear();
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(((Iterator)iterator.elem).hasNext(), "iterator.hasNext", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 310));
        $this.intercept((Function0 & Serializable & scala.Serializable)() -> (UnsafeRow)((Iterator)iterator$5.elem).next(), ClassTag$.MODULE$.apply(ConcurrentModificationException.class), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 311));
        $this.checkIteratorClosedWhenThrowConcurrentModificationException((Iterator<UnsafeRow>)((Iterator)iterator.elem));
    }

    public static final /* synthetic */ void $anonfun$new$35(ExternalAppendOnlyUnsafeRowArraySuite $this, ExternalAppendOnlyUnsafeRowArray array) {
        Iterator iterator = array.generateIterator();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(iterator.hasNext(), "iterator.hasNext", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 319));
        array.clear();
        array.clear();
        array.clear();
        ExternalAppendOnlyUnsafeRowArray $org_scalatest_assert_macro_left = array;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 325));
        ExternalAppendOnlyUnsafeRowArray $org_scalatest_assert_macro_left2 = array;
        int $org_scalatest_assert_macro_right = 0;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 326));
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(iterator.hasNext(), "iterator.hasNext", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 329));
        $this.intercept((Function0 & Serializable & scala.Serializable)() -> (UnsafeRow)iterator.next(), ClassTag$.MODULE$.apply(ConcurrentModificationException.class), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 330));
        $this.checkIteratorClosedWhenThrowConcurrentModificationException((Iterator<UnsafeRow>)iterator);
    }

    public static final /* synthetic */ void $anonfun$new$38(ExternalAppendOnlyUnsafeRowArraySuite $this, int inMemoryThreshold$5, ExternalAppendOnlyUnsafeRowArray array) {
        $this.populateRows(array, inMemoryThreshold$5 / 2);
        $this.assertNoSpill();
        array.clear();
        ExternalAppendOnlyUnsafeRowArray $org_scalatest_assert_macro_left = array;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 344));
        ArrayBuffer<Object> expectedValues = $this.populateRows(array, inMemoryThreshold$5 / 2);
        $this.validateData(array, expectedValues);
        $this.assertNoSpill();
        $this.populateRows(array, inMemoryThreshold$5 / 2, expectedValues);
        $this.validateData(array, expectedValues);
        $this.assertNoSpill();
    }

    public static final /* synthetic */ void $anonfun$new$40(ExternalAppendOnlyUnsafeRowArraySuite $this, int spillThreshold$6, ExternalAppendOnlyUnsafeRowArray array) {
        long bytesSpilled;
        $this.populateRows(array, spillThreshold$6 * 2);
        long $org_scalatest_assert_macro_left = bytesSpilled = $this.getNumBytesSpilled();
        int $org_scalatest_assert_macro_right = 0;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 366));
        array.clear();
        ExternalAppendOnlyUnsafeRowArray $org_scalatest_assert_macro_left2 = array;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 370));
        ArrayBuffer<Object> expectedValues = $this.populateRows(array, spillThreshold$6 / 2);
        $this.validateData(array, expectedValues);
        long $org_scalatest_assert_macro_left3 = $this.getNumBytesSpilled();
        long $org_scalatest_assert_macro_right2 = bytesSpilled;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 376));
        $this.populateRows(array, spillThreshold$6 * 2, expectedValues);
        $this.validateData(array, expectedValues);
        long $org_scalatest_assert_macro_left4 = $this.getNumBytesSpilled();
        long $org_scalatest_assert_macro_right3 = bytesSpilled;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left4), ">", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left4 > $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 382));
    }

    private static final Object getFieldValue$1(Object obj, String fieldName) {
        Field field = obj.getClass().getDeclaredField(fieldName);
        field.setAccessible(true);
        return field.get(obj);
    }

    private static final void checkUnsafeSorterSpillReaderClosed$1(UnsafeSorterIterator unsafeSorterIterator) {
        UnsafeSorterIterator unsafeSorterIterator2 = unsafeSorterIterator;
        if (unsafeSorterIterator2 instanceof UnsafeSorterSpillReader) {
            UnsafeSorterSpillReader unsafeSorterSpillReader = (UnsafeSorterSpillReader)unsafeSorterIterator2;
            Object $org_scalatest_assert_macro_left = ExternalAppendOnlyUnsafeRowArraySuite.getFieldValue$1(unsafeSorterSpillReader, "in");
            Object $org_scalatest_assert_macro_right = null;
            Object object = $org_scalatest_assert_macro_left;
            Object var7_5 = null;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", null, !(object != null ? !object.equals(var7_5) : var7_5 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 397));
            Object $org_scalatest_assert_macro_left2 = ExternalAppendOnlyUnsafeRowArraySuite.getFieldValue$1(unsafeSorterSpillReader, "din");
            Object $org_scalatest_assert_macro_right2 = null;
            Object object2 = $org_scalatest_assert_macro_left2;
            Object var11_9 = null;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left2, "==", null, !(object2 != null ? !object2.equals(var11_9) : var11_9 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 398));
            return;
        }
    }

    public ExternalAppendOnlyUnsafeRowArraySuite() {
        LocalSparkContext.$init$((LocalSparkContext)this);
        this.random = new Random();
        this.test("insert rows less than the inMemoryThreshold", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(100, 50);
            if (sp2 == null) {
                throw new MatchError((Object)sp2);
            }
            int inMemoryThreshold = sp2._1$mcI$sp();
            int spillThreshold = sp2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(inMemoryThreshold, spillThreshold);
            int inMemoryThreshold2 = sp3._1$mcI$sp();
            int spillThreshold2 = sp3._2$mcI$sp();
            this.withExternalArray(inMemoryThreshold2, spillThreshold2, (Function1<ExternalAppendOnlyUnsafeRowArray, BoxedUnit>)(Function1 & Serializable & scala.Serializable)array -> {
                ExternalAppendOnlyUnsafeRowArraySuite.$anonfun$new$2(this, inMemoryThreshold2, array);
                return BoxedUnit.UNIT;
            });
        }, new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
        this.test("insert rows more than the inMemoryThreshold but less than spillThreshold", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(10, 50);
            if (sp2 == null) {
                throw new MatchError((Object)sp2);
            }
            int inMemoryThreshold = sp2._1$mcI$sp();
            int spillThreshold = sp2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(inMemoryThreshold, spillThreshold);
            int inMemoryThreshold2 = sp3._1$mcI$sp();
            int spillThreshold2 = sp3._2$mcI$sp();
            this.withExternalArray(inMemoryThreshold2, spillThreshold2, (Function1<ExternalAppendOnlyUnsafeRowArray, BoxedUnit>)(Function1 & Serializable & scala.Serializable)array -> {
                ExternalAppendOnlyUnsafeRowArraySuite.$anonfun$new$4(this, inMemoryThreshold2, spillThreshold2, array);
                return BoxedUnit.UNIT;
            });
        }, new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
        this.test("insert rows enough to force spill", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(20, 10);
            if (sp2 == null) {
                throw new MatchError((Object)sp2);
            }
            int inMemoryThreshold = sp2._1$mcI$sp();
            int spillThreshold = sp2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(inMemoryThreshold, spillThreshold);
            int inMemoryThreshold2 = sp3._1$mcI$sp();
            int spillThreshold2 = sp3._2$mcI$sp();
            this.withExternalArray(inMemoryThreshold2, spillThreshold2, (Function1<ExternalAppendOnlyUnsafeRowArray, BoxedUnit>)(Function1 & Serializable & scala.Serializable)array -> {
                ExternalAppendOnlyUnsafeRowArraySuite.$anonfun$new$7(this, inMemoryThreshold2, array);
                return BoxedUnit.UNIT;
            });
        }, new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
        this.test("iterator on an empty array should be empty", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withExternalArray(4, 10, (Function1<ExternalAppendOnlyUnsafeRowArray, BoxedUnit>)(Function1 & Serializable & scala.Serializable)array -> {
            ExternalAppendOnlyUnsafeRowArraySuite.$anonfun$new$10(array);
            return BoxedUnit.UNIT;
        }), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
        this.test("generate iterator with negative start index", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withExternalArray(100, 56, (Function1<ExternalAppendOnlyUnsafeRowArray, BoxedUnit>)(Function1 & Serializable & scala.Serializable)array -> {
            ExternalAppendOnlyUnsafeRowArraySuite.$anonfun$new$12(this, array);
            return BoxedUnit.UNIT;
        }), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 198));
        this.test("generate iterator with start index exceeding array's size (without spill)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(20, 100);
            if (sp2 == null) {
                throw new MatchError((Object)sp2);
            }
            int inMemoryThreshold = sp2._1$mcI$sp();
            int spillThreshold = sp2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(inMemoryThreshold, spillThreshold);
            int inMemoryThreshold2 = sp3._1$mcI$sp();
            int spillThreshold2 = sp3._2$mcI$sp();
            this.withExternalArray(inMemoryThreshold2, spillThreshold2, (Function1<ExternalAppendOnlyUnsafeRowArray, BoxedUnit>)(Function1 & Serializable & scala.Serializable)array -> {
                ExternalAppendOnlyUnsafeRowArraySuite.$anonfun$new$15(this, spillThreshold2, array);
                return BoxedUnit.UNIT;
            });
        }, new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
        this.test("generate iterator with start index exceeding array's size (with spill)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(20, 100);
            if (sp2 == null) {
                throw new MatchError((Object)sp2);
            }
            int inMemoryThreshold = sp2._1$mcI$sp();
            int spillThreshold = sp2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(inMemoryThreshold, spillThreshold);
            int inMemoryThreshold2 = sp3._1$mcI$sp();
            int spillThreshold2 = sp3._2$mcI$sp();
            this.withExternalArray(inMemoryThreshold2, spillThreshold2, (Function1<ExternalAppendOnlyUnsafeRowArray, BoxedUnit>)(Function1 & Serializable & scala.Serializable)array -> {
                ExternalAppendOnlyUnsafeRowArraySuite.$anonfun$new$18(this, spillThreshold2, array);
                return BoxedUnit.UNIT;
            });
        }, new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 222));
        this.test("generate iterator with custom start index (without spill)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(20, 100);
            if (sp2 == null) {
                throw new MatchError((Object)sp2);
            }
            int inMemoryThreshold = sp2._1$mcI$sp();
            int spillThreshold = sp2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(inMemoryThreshold, spillThreshold);
            int inMemoryThreshold2 = sp3._1$mcI$sp();
            int spillThreshold2 = sp3._2$mcI$sp();
            this.withExternalArray(inMemoryThreshold2, spillThreshold2, (Function1<ExternalAppendOnlyUnsafeRowArray, BoxedUnit>)(Function1 & Serializable & scala.Serializable)array -> {
                ExternalAppendOnlyUnsafeRowArraySuite.$anonfun$new$21(this, inMemoryThreshold2, array);
                return BoxedUnit.UNIT;
            });
        }, new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 236));
        this.test("generate iterator with custom start index (with spill)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(20, 100);
            if (sp2 == null) {
                throw new MatchError((Object)sp2);
            }
            int inMemoryThreshold = sp2._1$mcI$sp();
            int spillThreshold = sp2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(inMemoryThreshold, spillThreshold);
            int inMemoryThreshold2 = sp3._1$mcI$sp();
            int spillThreshold2 = sp3._2$mcI$sp();
            this.withExternalArray(inMemoryThreshold2, spillThreshold2, (Function1<ExternalAppendOnlyUnsafeRowArray, BoxedUnit>)(Function1 & Serializable & scala.Serializable)array -> {
                ExternalAppendOnlyUnsafeRowArraySuite.$anonfun$new$24(this, spillThreshold2, array);
                return BoxedUnit.UNIT;
            });
        }, new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 248));
        this.test("test iterator invalidation (without spill)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withExternalArray(10, 100, (Function1<ExternalAppendOnlyUnsafeRowArray, BoxedUnit>)(Function1 & Serializable & scala.Serializable)array -> {
            ExternalAppendOnlyUnsafeRowArraySuite.$anonfun$new$27(this, array);
            return BoxedUnit.UNIT;
        }), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 260));
        this.test("test iterator invalidation (with spill)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(2, 10);
            if (sp2 == null) {
                throw new MatchError((Object)sp2);
            }
            int inMemoryThreshold = sp2._1$mcI$sp();
            int spillThreshold = sp2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(inMemoryThreshold, spillThreshold);
            int inMemoryThreshold2 = sp3._1$mcI$sp();
            int spillThreshold2 = sp3._2$mcI$sp();
            this.withExternalArray(inMemoryThreshold2, spillThreshold2, (Function1<ExternalAppendOnlyUnsafeRowArray, BoxedUnit>)(Function1 & Serializable & scala.Serializable)array -> {
                ExternalAppendOnlyUnsafeRowArraySuite.$anonfun$new$31(this, spillThreshold2, array);
                return BoxedUnit.UNIT;
            });
        }, new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 287));
        this.test("clear on an empty the array", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withExternalArray(2, 3, (Function1<ExternalAppendOnlyUnsafeRowArray, BoxedUnit>)(Function1 & Serializable & scala.Serializable)array -> {
            ExternalAppendOnlyUnsafeRowArraySuite.$anonfun$new$35(this, array);
            return BoxedUnit.UNIT;
        }), new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 316));
        this.test("clear array (without spill)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(10, 100);
            if (sp2 == null) {
                throw new MatchError((Object)sp2);
            }
            int inMemoryThreshold = sp2._1$mcI$sp();
            int spillThreshold = sp2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(inMemoryThreshold, spillThreshold);
            int inMemoryThreshold2 = sp3._1$mcI$sp();
            int spillThreshold2 = sp3._2$mcI$sp();
            this.withExternalArray(inMemoryThreshold2, spillThreshold2, (Function1<ExternalAppendOnlyUnsafeRowArray, BoxedUnit>)(Function1 & Serializable & scala.Serializable)array -> {
                ExternalAppendOnlyUnsafeRowArraySuite.$anonfun$new$38(this, inMemoryThreshold2, array);
                return BoxedUnit.UNIT;
            });
        }, new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 335));
        this.test("clear array (with spill)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(10, 20);
            if (sp2 == null) {
                throw new MatchError((Object)sp2);
            }
            int inMemoryThreshold = sp2._1$mcI$sp();
            int spillThreshold = sp2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(inMemoryThreshold, spillThreshold);
            int inMemoryThreshold2 = sp3._1$mcI$sp();
            int spillThreshold2 = sp3._2$mcI$sp();
            this.withExternalArray(inMemoryThreshold2, spillThreshold2, (Function1<ExternalAppendOnlyUnsafeRowArray, BoxedUnit>)(Function1 & Serializable & scala.Serializable)array -> {
                ExternalAppendOnlyUnsafeRowArraySuite.$anonfun$new$40(this, spillThreshold2, array);
                return BoxedUnit.UNIT;
            });
        }, new Position("ExternalAppendOnlyUnsafeRowArraySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 360));
    }
}

