/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.benchmark;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.SparkConf;
import org.apache.spark.benchmark.Benchmark;
import org.apache.spark.benchmark.Benchmark$;
import org.apache.spark.benchmark.BenchmarkBase;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.AliasIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.HiveTableRelation;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.SubqueryAlias;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.execution.benchmark.SqlBasedBenchmark;
import org.apache.spark.sql.execution.benchmark.TPCDSQueryBenchmarkArguments;
import org.apache.spark.sql.execution.benchmark.TPCDSSchemaHelper$;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;

public final class TPCDSQueryBenchmark$
extends BenchmarkBase
implements SqlBasedBenchmark,
Logging {
    public static TPCDSQueryBenchmark$ MODULE$;
    private final Seq<String> tables;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private final SparkSession spark;
    private String sparkHome;
    private volatile boolean bitmap$0;

    static {
        new TPCDSQueryBenchmark$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public final void codegenBenchmark(String name, long cardinality, Function0<BoxedUnit> f) {
        SqlBasedBenchmark.codegenBenchmark$(this, name, cardinality, f);
    }

    @Override
    public SqlBasedBenchmark.DatasetToBenchmark DatasetToBenchmark(Dataset<?> ds) {
        return SqlBasedBenchmark.DatasetToBenchmark$(this, ds);
    }

    @Override
    public void prepareDataInfo(Benchmark benchmark) {
        SqlBasedBenchmark.prepareDataInfo$(this, benchmark);
    }

    @Override
    public StructType writeWideRow(String path, int rowsNum, int numCols) {
        return SqlBasedBenchmark.writeWideRow$(this, path, rowsNum, numCols);
    }

    @Override
    public void afterAll() {
        SqlBasedBenchmark.afterAll$(this);
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$((SQLHelper)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void org$apache$spark$sql$execution$benchmark$SqlBasedBenchmark$_setter_$spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    private String sparkHome$lzycompute() {
        TPCDSQueryBenchmark$ tPCDSQueryBenchmark$ = this;
        synchronized (tPCDSQueryBenchmark$) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$((SQLHelper)this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    public String sparkHome() {
        if (!this.bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    @Override
    public SparkSession getSparkSession() {
        SparkConf conf = new SparkConf().setMaster(System.getProperty("spark.sql.test.master", "local[1]")).setAppName("test-sql-context").set("spark.sql.parquet.compression.codec", "snappy").set("spark.sql.shuffle.partitions", System.getProperty("spark.sql.shuffle.partitions", "4")).set("spark.driver.memory", "3g").set("spark.executor.memory", "3g").set("spark.sql.autoBroadcastJoinThreshold", Integer.toString(0x1400000)).set("spark.sql.crossJoin.enabled", "true").set("spark.serializer", "org.apache.spark.serializer.KryoSerializer").set("spark.kryo.registrationRequired", "true");
        return SparkSession$.MODULE$.builder().config(conf).getOrCreate();
    }

    public Seq<String> tables() {
        return this.tables;
    }

    public Map<String, Object> setupTables(String dataLocation, Map<String, StructType> tableColumns) {
        return ((TraversableOnce)this.tables().map((Function1 & Serializable & scala.Serializable)tableName -> {
            MODULE$.spark().sql(new StringBuilder(21).append("DROP TABLE IF EXISTS ").append((String)tableName).toString());
            Map options = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)new StringBuilder(1).append(dataLocation).append("/").append((String)tableName).toString())}));
            MODULE$.spark().catalog().createTable(tableName, "parquet", (StructType)tableColumns.apply(tableName), options);
            Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MODULE$.spark().sql(new StringBuilder(31).append("ALTER TABLE ").append((String)tableName).append(" RECOVER PARTITIONS").toString())).getOrElse((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Recovering partitions of table ").append((String)tableName).append(" failed").toString()));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tableName), (Object)BoxesRunTime.boxToLong((long)MODULE$.spark().table(tableName).count()));
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public void runTpcdsQueries(String queryLocation, Seq<String> queries, Map<String, Object> tableSizes, String nameSuffix) {
        queries.foreach((Function1 & Serializable & scala.Serializable)name -> {
            TPCDSQueryBenchmark$.$anonfun$runTpcdsQueries$1(queryLocation, tableSizes, nameSuffix, name);
            return BoxedUnit.UNIT;
        });
    }

    public String runTpcdsQueries$default$4() {
        return "";
    }

    private Seq<String> filterQueries(Seq<String> origQueries, Set<String> queryFilter, String nameSuffix) {
        if (queryFilter.nonEmpty()) {
            if (new StringOps(Predef$.MODULE$.augmentString(nameSuffix)).nonEmpty()) {
                return (Seq)origQueries.filter((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)queryFilter.contains((Object)new StringBuilder(0).append(name).append(nameSuffix).toString())));
            }
            return (Seq)origQueries.filter((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)queryFilter.contains((Object)elem)));
        }
        return origQueries;
    }

    private String filterQueries$default$3() {
        return "";
    }

    public void runBenchmarkSuite(String[] mainArgs) {
        Dataset dataset;
        Seq<String> queriesV2_7ToRun;
        TPCDSQueryBenchmarkArguments benchmarkArgs = new TPCDSQueryBenchmarkArguments(mainArgs);
        Seq tpcdsQueries = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"q1", "q2", "q3", "q4", "q5", "q6", "q7", "q8", "q9", "q10", "q11", "q12", "q13", "q14a", "q14b", "q15", "q16", "q17", "q18", "q19", "q20", "q21", "q22", "q23a", "q23b", "q24a", "q24b", "q25", "q26", "q27", "q28", "q29", "q30", "q31", "q32", "q33", "q34", "q35", "q36", "q37", "q38", "q39a", "q39b", "q40", "q41", "q42", "q43", "q44", "q45", "q46", "q47", "q48", "q49", "q50", "q51", "q52", "q53", "q54", "q55", "q56", "q57", "q58", "q59", "q60", "q61", "q62", "q63", "q64", "q65", "q66", "q67", "q68", "q69", "q70", "q71", "q72", "q73", "q74", "q75", "q76", "q77", "q78", "q79", "q80", "q81", "q82", "q83", "q84", "q85", "q86", "q87", "q88", "q89", "q90", "q91", "q92", "q93", "q94", "q95", "q96", "q97", "q98", "q99"}));
        String nameSuffixForQueriesV2_7 = "-v2.7";
        Seq tpcdsQueriesV2_7 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"q5a", "q6", "q10a", "q11", "q12", "q14", "q14a", "q18a", "q20", "q22", "q22a", "q24", "q27a", "q34", "q35", "q35a", "q36a", "q47", "q49", "q51a", "q57", "q64", "q67a", "q70a", "q72", "q74", "q75", "q77a", "q78", "q80a", "q86a", "q98"}));
        Seq<String> queriesV1_4ToRun = this.filterQueries((Seq<String>)tpcdsQueries, benchmarkArgs.queryFilter(), this.filterQueries$default$3());
        if (((SeqLike)queriesV1_4ToRun.$plus$plus(queriesV2_7ToRun = this.filterQueries((Seq<String>)tpcdsQueriesV2_7, benchmarkArgs.queryFilter(), nameSuffixForQueriesV2_7), Seq$.MODULE$.canBuildFrom())).isEmpty()) {
            throw new RuntimeException(new StringBuilder(45).append("Empty queries to run. Bad query name filter: ").append(benchmarkArgs.queryFilter()).toString());
        }
        Map<String, Object> tableSizes = this.setupTables(benchmarkArgs.dataLocation(), TPCDSSchemaHelper$.MODULE$.getTableColumns());
        if (benchmarkArgs.cboEnabled()) {
            this.spark().sql(new StringBuilder(9).append("SET ").append(SQLConf$.MODULE$.CBO_ENABLED().key()).append("=true").toString());
            this.spark().sql(new StringBuilder(9).append("SET ").append(SQLConf$.MODULE$.PLAN_STATS_ENABLED().key()).append("=true").toString());
            this.spark().sql(new StringBuilder(9).append("SET ").append(SQLConf$.MODULE$.JOIN_REORDER_ENABLED().key()).append("=true").toString());
            this.spark().sql(new StringBuilder(9).append("SET ").append(SQLConf$.MODULE$.HISTOGRAM_ENABLED().key()).append("=true").toString());
            long startTime = System.nanoTime();
            this.tables().foreach((Function1 & Serializable & scala.Serializable)tableName -> MODULE$.spark().sql(new StringBuilder(49).append("ANALYZE TABLE ").append((String)tableName).append(" COMPUTE STATISTICS FOR ALL COLUMNS").toString()));
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("The elapsed time to analyze all the tables is ").append((double)(System.nanoTime() - startTime) / (double)1000000000L).append(" seconds").toString());
            dataset = BoxedUnit.UNIT;
        } else {
            dataset = this.spark().sql(new StringBuilder(10).append("SET ").append(SQLConf$.MODULE$.CBO_ENABLED().key()).append("=false").toString());
        }
        this.runTpcdsQueries("tpcds", queriesV1_4ToRun, tableSizes, this.runTpcdsQueries$default$4());
        this.runTpcdsQueries("tpcds-v2.7.0", queriesV2_7ToRun, tableSizes, nameSuffixForQueriesV2_7);
    }

    public static final /* synthetic */ void $anonfun$runTpcdsQueries$2(HashSet queryRelations$1, LogicalPlan x0$1) {
        LogicalRelation logicalRelation;
        Option option;
        LogicalPlan logicalPlan = x0$1;
        if (logicalPlan instanceof SubqueryAlias) {
            SubqueryAlias subqueryAlias = (SubqueryAlias)logicalPlan;
            AliasIdentifier alias = subqueryAlias.identifier();
            if (subqueryAlias.child() instanceof LogicalRelation) {
                queryRelations$1.add((Object)alias.name());
                return;
            }
        }
        if (logicalPlan instanceof LogicalRelation && (option = (logicalRelation = (LogicalRelation)logicalPlan).catalogTable()) instanceof Some) {
            Some some = (Some)option;
            CatalogTable catalogTable = (CatalogTable)some.value();
            queryRelations$1.add((Object)catalogTable.identifier().table());
            return;
        }
        if (logicalPlan instanceof HiveTableRelation) {
            HiveTableRelation hiveTableRelation = (HiveTableRelation)logicalPlan;
            CatalogTable tableMeta = hiveTableRelation.tableMeta();
            queryRelations$1.add((Object)tableMeta.identifier().table());
            return;
        }
    }

    public static final /* synthetic */ long $anonfun$runTpcdsQueries$3(Map tableSizes$1, String x$1) {
        return BoxesRunTime.unboxToLong((Object)tableSizes$1.getOrElse((Object)x$1, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
    }

    public static final /* synthetic */ void $anonfun$runTpcdsQueries$1(String queryLocation$1, Map tableSizes$1, String nameSuffix$1, String name) {
        String x$12 = new StringBuilder(5).append(queryLocation$1).append("/").append(name).append(".sql").toString();
        ClassLoader x$22 = Thread.currentThread().getContextClassLoader();
        String x$3 = package$.MODULE$.resourceToString$default$2();
        String queryString = package$.MODULE$.resourceToString(x$12, x$3, x$22);
        HashSet queryRelations = (HashSet)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$);
        MODULE$.spark().sparkContext().setJobGroup(name, new StringBuilder(2).append(name).append(":\n").append(queryString).toString(), true);
        MODULE$.spark().sql(queryString).queryExecution().analyzed().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TPCDSQueryBenchmark$.$anonfun$runTpcdsQueries$2(queryRelations, x0$1);
            return BoxedUnit.UNIT;
        });
        long numRows = BoxesRunTime.unboxToLong((Object)((TraversableOnce)queryRelations.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)TPCDSQueryBenchmark$.$anonfun$runTpcdsQueries$3(tableSizes$1, x$1)), HashSet$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        String x$4 = "TPCDS Snappy";
        long x$5 = numRows;
        int x$6 = 2;
        Option x$7 = MODULE$.output();
        FiniteDuration x$8 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$9 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$10 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$4, x$5, x$6, x$8, x$9, x$10, x$7);
        benchmark.addCase(new StringBuilder(0).append(name).append(nameSuffix$1).toString(), benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$2 -> MODULE$.DatasetToBenchmark(MODULE$.spark().sql(queryString)).noop());
        benchmark.run();
    }

    private TPCDSQueryBenchmark$() {
        MODULE$ = this;
        SQLHelper.$init$((SQLHelper)this);
        SqlBasedBenchmark.$init$(this);
        Logging.$init$((Logging)this);
        this.tables = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"catalog_page", "catalog_returns", "customer", "customer_address", "customer_demographics", "date_dim", "household_demographics", "inventory", "item", "promotion", "store", "store_returns", "catalog_sales", "web_sales", "store_sales", "web_returns", "web_site", "reason", "call_center", "warehouse", "ship_mode", "income_band", "time_dim", "web_page"}));
    }
}

