/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector;

import java.io.Serializable;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.connector.DatasourceV2SQLBase;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.SimpleScanSource;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEquals;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u00054q!\u0002\u0004\u0011\u0002\u0007\u0005\u0011\u0003C\u0003\u001b\u0001\u0011\u00051\u0004C\u0004#\u0001\t\u0007i\u0011C\u0012\t\u0017=\u0002\u0001\u0013aA\u0001\u0002\u0013%\u0001G\u0013\u0005\f\u0019\u0002\u0001\n1!A\u0001\n\u0013iULA\bEK2,G/\u001a$s_6$Vm\u001d;t\u0015\t9\u0001\"A\u0005d_:tWm\u0019;pe*\u0011\u0011BC\u0001\u0004gFd'BA\u0006\r\u0003\u0015\u0019\b/\u0019:l\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0005\f\u0011\u0005M!R\"\u0001\u0005\n\u0005UA!!C)vKJLH+Z:u!\t9\u0002$D\u0001\u0007\u0013\tIbAA\nECR\f7o\\;sG\u00164&gU)M\u0005\u0006\u001cX-\u0001\u0004%S:LG\u000f\n\u000b\u00029A\u0011Q\u0004I\u0007\u0002=)\tq$A\u0003tG\u0006d\u0017-\u0003\u0002\"=\t!QK\\5u\u0003M\u0019\u0017\r^1m_\u001e\fe\u000e\u001a(b[\u0016\u001c\b/Y2f+\u0005!\u0003CA\u0013-\u001d\t1#\u0006\u0005\u0002(=5\t\u0001F\u0003\u0002*!\u00051AH]8pizJ!a\u000b\u0010\u0002\rA\u0013X\rZ3g\u0013\ticF\u0001\u0004TiJLgn\u001a\u0006\u0003Wy\t\u0011c];qKJ$3\r[3dW\u0006s7o^3s)\ra\u0012'\u0010\u0005\u0007e\r!\t\u0019A\u001a\u0002\u0005\u00114\u0007cA\u000f5m%\u0011QG\b\u0002\ty\tLh.Y7f}A\u0011qG\u000f\b\u0003'aJ!!\u000f\u0005\u0002\u000fA\f7m[1hK&\u00111\b\u0010\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T!!\u000f\u0005\t\u000by\u001a\u0001\u0019A \u0002\u001d\u0015D\b/Z2uK\u0012\fen]<feB\u0019\u0001\tR$\u000f\u0005\u0005\u001beBA\u0014C\u0013\u0005y\u0012BA\u001d\u001f\u0013\t)eIA\u0002TKFT!!\u000f\u0010\u0011\u0005MA\u0015BA%\t\u0005\r\u0011vn^\u0005\u0003\u0017R\t1b\u00195fG.\fen]<fe\u0006\u00012/\u001e9fe\u0012\u001a\u0007.Z2l\u000bJ\u0014xN\u001d\u000b\u000699#f\u000b\u0017\u0005\u0006\u001f\u0012\u0001\r\u0001U\u0001\nKb\u001cW\r\u001d;j_:\u0004\"!\u0015*\u000e\u0003)I!a\u0015\u0006\u0003\u001dM\u0003\u0018M]6UQJ|w/\u00192mK\")Q\u000b\u0002a\u0001I\u0005QQM\u001d:pe\u000ec\u0017m]:\t\u000b]#\u0001\u0019\u0001\u0013\u0002\u0011M\fHn\u0015;bi\u0016DQ!\u0017\u0003A\u0002i\u000b!\u0002]1sC6,G/\u001a:t!\u0011)3\f\n\u0013\n\u0005qs#aA'ba&\u0011alX\u0001\u000bG\",7m[#se>\u0014\u0018B\u00011\u000b\u00055\u0019\u0006/\u0019:l\rVt7+^5uK\u0002")
public interface DeleteFromTests
extends DatasourceV2SQLBase {
    public /* synthetic */ void org$apache$spark$sql$connector$DeleteFromTests$$super$checkAnswer(Function0 var1, Seq var2);

    public /* synthetic */ void org$apache$spark$sql$connector$DeleteFromTests$$super$checkError(SparkThrowable var1, String var2, String var3, Map var4);

    public String catalogAndNamespace();

    public static void $init$(DeleteFromTests $this) {
        $this.test("DeleteFrom with v2 filtering: basic - delete all", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(3).append($this.catalogAndNamespace()).append("tbl").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(78).append("CREATE TABLE ").append(t).append(" (id bigint, data string, p int) USING foo PARTITIONED BY (id, p)").toString());
                $this.sql().apply((Object)new StringBuilder(60).append("INSERT INTO ").append(t).append(" VALUES (2L, 'a', 2), (2L, 'b', 3), (3L, 'c', 3)").toString());
                $this.sql().apply((Object)new StringBuilder(12).append("DELETE FROM ").append(t).toString());
                $this.org$apache$spark$sql$connector$DeleteFromTests$$super$checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().table(t), (Seq)Nil$.MODULE$);
            });
        }, new Position("DeleteFromTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 31));
        $this.test("DeleteFrom with v2 filtering: basic - delete with where clause", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(3).append($this.catalogAndNamespace()).append("tbl").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(78).append("CREATE TABLE ").append(t).append(" (id bigint, data string, p int) USING foo PARTITIONED BY (id, p)").toString());
                $this.sql().apply((Object)new StringBuilder(60).append("INSERT INTO ").append(t).append(" VALUES (2L, 'a', 2), (2L, 'b', 3), (3L, 'c', 3)").toString());
                $this.sql().apply((Object)new StringBuilder(25).append("DELETE FROM ").append(t).append(" WHERE id = 2").toString());
                $this.org$apache$spark$sql$connector$DeleteFromTests$$super$checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().table(t), (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "c", BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$));
            });
        }, new Position("DeleteFromTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
        $this.test("DeleteFrom with v2 filtering: delete from aliased target table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(3).append($this.catalogAndNamespace()).append("tbl").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(78).append("CREATE TABLE ").append(t).append(" (id bigint, data string, p int) USING foo PARTITIONED BY (id, p)").toString());
                $this.sql().apply((Object)new StringBuilder(60).append("INSERT INTO ").append(t).append(" VALUES (2L, 'a', 2), (2L, 'b', 3), (3L, 'c', 3)").toString());
                $this.sql().apply((Object)new StringBuilder(36).append("DELETE FROM ").append(t).append(" AS tbl WHERE tbl.id = 2").toString());
                $this.org$apache$spark$sql$connector$DeleteFromTests$$super$checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().table(t), (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "c", BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$));
            });
        }, new Position("DeleteFromTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
        $this.test("DeleteFrom with v2 filtering: normalize attribute names", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(3).append($this.catalogAndNamespace()).append("tbl").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(78).append("CREATE TABLE ").append(t).append(" (id bigint, data string, p int) USING foo PARTITIONED BY (id, p)").toString());
                $this.sql().apply((Object)new StringBuilder(60).append("INSERT INTO ").append(t).append(" VALUES (2L, 'a', 2), (2L, 'b', 3), (3L, 'c', 3)").toString());
                $this.sql().apply((Object)new StringBuilder(36).append("DELETE FROM ").append(t).append(" AS tbl WHERE tbl.ID = 2").toString());
                $this.org$apache$spark$sql$connector$DeleteFromTests$$super$checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().table(t), (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "c", BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$));
            });
        }, new Position("DeleteFromTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        $this.test("DeleteFrom with v2 filtering: fail if has subquery", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(3).append($this.catalogAndNamespace()).append("tbl").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(78).append("CREATE TABLE ").append(t).append(" (id bigint, data string, p int) USING foo PARTITIONED BY (id, p)").toString());
                $this.sql().apply((Object)new StringBuilder(60).append("INSERT INTO ").append(t).append(" VALUES (2L, 'a', 2), (2L, 'b', 3), (3L, 'c', 3)").toString());
                AnalysisException exc = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(42).append("DELETE FROM ").append(t).append(" WHERE id IN (SELECT id FROM ").append(t).append(")").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DeleteFromTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79)))));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)BoxesRunTime.boxToLong((long)$this.spark().table(t).count()));
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DeleteFromTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
                String $org_scalatest_assert_macro_left2 = exc.getMessage();
                String $org_scalatest_assert_macro_right2 = "Delete by condition with subquery is not supported";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DeleteFromTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
            });
        }, new Position("DeleteFromTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
        $this.test("DeleteFrom with v2 filtering: delete with unsupported predicates", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(3).append($this.catalogAndNamespace()).append("tbl").toString();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(55).append("CREATE TABLE ").append(t).append(" (id bigint, data string, p int) USING foo").toString());
                $this.sql().apply((Object)new StringBuilder(60).append("INSERT INTO ").append(t).append(" VALUES (2L, 'a', 2), (2L, 'b', 3), (3L, 'c', 3)").toString());
                AnalysisException exc = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(35).append("DELETE FROM ").append(t).append(" WHERE id > 3 AND p > 3").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DeleteFromTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93)))));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)BoxesRunTime.boxToLong((long)$this.spark().table(t).count()));
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DeleteFromTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
                String $org_scalatest_assert_macro_left2 = exc.getMessage();
                String $org_scalatest_assert_macro_right2 = new StringBuilder(25).append("Cannot delete from table ").append(t).toString();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DeleteFromTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
            });
        }, new Position("DeleteFromTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
        $this.test("DeleteFrom: DELETE is only supported with v2 tables", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.spark().conf().unset(SQLConf$.MODULE$.V2_SESSION_CATALOG_IMPLEMENTATION().key());
            String v1Table = "tbl";
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{v1Table}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(42).append("CREATE TABLE ").append(v1Table).append(" USING ").append(SimpleScanSource.class.getName()).append(" OPTIONS (from=0,to=1)").toString());
                AnalysisException exc = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(24).append("DELETE FROM ").append(v1Table).append(" WHERE i = 2").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DeleteFromTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109)))));
                $this.org$apache$spark$sql$connector$DeleteFromTests$$super$checkError((SparkThrowable)exc, "UNSUPPORTED_FEATURE.TABLE_OPERATION", "0A000", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)"`spark_catalog`.`default`.`tbl`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)"DELETE")})));
            });
        }, new Position("DeleteFromTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
        $this.test("SPARK-33652: DeleteFrom should refresh caches referencing the table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = new StringBuilder(3).append($this.catalogAndNamespace()).append("tbl").toString();
            String view = "view";
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{view}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(78).append("CREATE TABLE ").append(t).append(" (id bigint, data string, p int) USING foo PARTITIONED BY (id, p)").toString());
                $this.sql().apply((Object)new StringBuilder(60).append("INSERT INTO ").append(t).append(" VALUES (2L, 'a', 2), (2L, 'b', 3), (3L, 'c', 3)").toString());
                $this.sql().apply((Object)new StringBuilder(35).append("CACHE TABLE view AS SELECT id FROM ").append(t).toString());
                long $org_scalatest_assert_macro_left = $this.spark().table(view).count();
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DeleteFromTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
                $this.sql().apply((Object)new StringBuilder(25).append("DELETE FROM ").append(t).append(" WHERE id = 2").toString());
                long $org_scalatest_assert_macro_left2 = $this.spark().table(view).count();
                int $org_scalatest_assert_macro_right2 = 1;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == (long)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DeleteFromTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
            }));
        }, new Position("DeleteFromTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
    }
}

