/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar;

import org.apache.spark.sql.catalyst.types.PhysicalArrayType;
import org.apache.spark.sql.catalyst.types.PhysicalBinaryType$;
import org.apache.spark.sql.catalyst.types.PhysicalBooleanType$;
import org.apache.spark.sql.catalyst.types.PhysicalByteType$;
import org.apache.spark.sql.catalyst.types.PhysicalCalendarIntervalType$;
import org.apache.spark.sql.catalyst.types.PhysicalDataType;
import org.apache.spark.sql.catalyst.types.PhysicalDecimalType;
import org.apache.spark.sql.catalyst.types.PhysicalDoubleType$;
import org.apache.spark.sql.catalyst.types.PhysicalFloatType$;
import org.apache.spark.sql.catalyst.types.PhysicalIntegerType$;
import org.apache.spark.sql.catalyst.types.PhysicalLongType$;
import org.apache.spark.sql.catalyst.types.PhysicalMapType;
import org.apache.spark.sql.catalyst.types.PhysicalNullType$;
import org.apache.spark.sql.catalyst.types.PhysicalShortType$;
import org.apache.spark.sql.catalyst.types.PhysicalStringType$;
import org.apache.spark.sql.catalyst.types.PhysicalStructType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public final class ColumnarDataTypeUtils$ {
    public static ColumnarDataTypeUtils$ MODULE$;

    static {
        new ColumnarDataTypeUtils$();
    }

    public DataType toLogicalDataType(PhysicalDataType dataType) {
        PhysicalDataType physicalDataType = dataType;
        if (PhysicalNullType$.MODULE$.equals(physicalDataType)) {
            return NullType$.MODULE$;
        }
        if (PhysicalBooleanType$.MODULE$.equals(physicalDataType)) {
            return BooleanType$.MODULE$;
        }
        if (PhysicalIntegerType$.MODULE$.equals(physicalDataType)) {
            return IntegerType$.MODULE$;
        }
        if (PhysicalLongType$.MODULE$.equals(physicalDataType)) {
            return LongType$.MODULE$;
        }
        if (PhysicalByteType$.MODULE$.equals(physicalDataType)) {
            return ByteType$.MODULE$;
        }
        if (PhysicalShortType$.MODULE$.equals(physicalDataType)) {
            return ShortType$.MODULE$;
        }
        if (PhysicalBinaryType$.MODULE$.equals(physicalDataType)) {
            return BinaryType$.MODULE$;
        }
        if (PhysicalCalendarIntervalType$.MODULE$.equals(physicalDataType)) {
            return CalendarIntervalType$.MODULE$;
        }
        if (PhysicalFloatType$.MODULE$.equals(physicalDataType)) {
            return FloatType$.MODULE$;
        }
        if (PhysicalDoubleType$.MODULE$.equals(physicalDataType)) {
            return DoubleType$.MODULE$;
        }
        if (PhysicalStringType$.MODULE$.equals(physicalDataType)) {
            return StringType$.MODULE$;
        }
        if (physicalDataType instanceof PhysicalDecimalType) {
            PhysicalDecimalType physicalDecimalType = (PhysicalDecimalType)physicalDataType;
            int precision = physicalDecimalType.precision();
            int scale = physicalDecimalType.scale();
            return new DecimalType(precision, scale);
        }
        if (physicalDataType instanceof PhysicalArrayType) {
            PhysicalArrayType physicalArrayType = (PhysicalArrayType)physicalDataType;
            DataType elementType = physicalArrayType.elementType();
            boolean containsNull = physicalArrayType.containsNull();
            return new ArrayType(elementType, containsNull);
        }
        if (physicalDataType instanceof PhysicalStructType) {
            PhysicalStructType physicalStructType = (PhysicalStructType)physicalDataType;
            StructField[] fields = physicalStructType.fields();
            return new StructType(fields);
        }
        if (physicalDataType instanceof PhysicalMapType) {
            PhysicalMapType physicalMapType = (PhysicalMapType)physicalDataType;
            DataType keyType = physicalMapType.keyType();
            DataType valueType = physicalMapType.valueType();
            boolean valueContainsNull = physicalMapType.valueContainsNull();
            return new MapType(keyType, valueType, valueContainsNull);
        }
        throw new UnsupportedOperationException();
    }

    private ColumnarDataTypeUtils$() {
        MODULE$ = this;
    }
}

