/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sources;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.execution.datasources.DataSourceAnalysis$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StructType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001y3AAC\u0006\u0001-!)1\u0005\u0001C\u0001I!Iq\u0005\u0001a\u0001\u0002\u0004%I\u0001\u000b\u0005\n{\u0001\u0001\r\u00111A\u0005\nyB\u0011\"\u0012\u0001A\u0002\u0003\u0005\u000b\u0015B\u0015\t\u0013\u0019\u0003\u0001\u0019!a\u0001\n\u00139\u0005\"\u0003(\u0001\u0001\u0004\u0005\r\u0011\"\u0003P\u0011%\t\u0006\u00011A\u0001B\u0003&\u0001\nC\u0003S\u0001\u0011\u00053\u000bC\u0003U\u0001\u0011%QKA\fECR\f7k\\;sG\u0016\fe.\u00197zg&\u001c8+^5uK*\u0011A\"D\u0001\bg>,(oY3t\u0015\tqq\"A\u0002tc2T!\u0001E\t\u0002\u000bM\u0004\u0018M]6\u000b\u0005I\u0019\u0012AB1qC\u000eDWMC\u0001\u0015\u0003\ry'oZ\u0002\u0001'\r\u0001qc\u0007\t\u00031ei\u0011aD\u0005\u00035=\u0011Qb\u00159be.4UO\\*vSR,\u0007C\u0001\u000f\"\u001b\u0005i\"B\u0001\u0010 \u0003\u0015\u0001H.\u00198t\u0015\t\u0001S\"\u0001\u0005dCR\fG._:u\u0013\t\u0011SDA\u0005T#2CU\r\u001c9fe\u00061A(\u001b8jiz\"\u0012!\n\t\u0003M\u0001i\u0011aC\u0001\u0011i\u0006\u0014x-\u001a;BiR\u0014\u0018NY;uKN,\u0012!\u000b\t\u0004UQ:dBA\u00162\u001d\tas&D\u0001.\u0015\tqS#\u0001\u0004=e>|GOP\u0005\u0002a\u0005)1oY1mC&\u0011!gM\u0001\ba\u0006\u001c7.Y4f\u0015\u0005\u0001\u0014BA\u001b7\u0005\r\u0019V-\u001d\u0006\u0003eM\u0002\"\u0001O\u001e\u000e\u0003eR!AO\u0010\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0003ye\u0012\u0011\"\u0011;ue&\u0014W\u000f^3\u0002)Q\f'oZ3u\u0003R$(/\u001b2vi\u0016\u001cx\fJ3r)\ty4\t\u0005\u0002A\u00036\t1'\u0003\u0002Cg\t!QK\\5u\u0011\u001d!5!!AA\u0002%\n1\u0001\u001f\u00132\u0003E!\u0018M]4fi\u0006#HO]5ckR,7\u000fI\u0001\u0016i\u0006\u0014x-\u001a;QCJ$\u0018\u000e^5p]N\u001b\u0007.Z7b+\u0005A\u0005CA%M\u001b\u0005Q%BA&\u000e\u0003\u0015!\u0018\u0010]3t\u0013\ti%J\u0001\u0006TiJ,8\r\u001e+za\u0016\f\u0011\u0004^1sO\u0016$\b+\u0019:uSRLwN\\*dQ\u0016l\u0017m\u0018\u0013fcR\u0011q\b\u0015\u0005\b\t\u001a\t\t\u00111\u0001I\u0003Y!\u0018M]4fiB\u000b'\u000f^5uS>t7k\u00195f[\u0006\u0004\u0013!\u00032fM>\u0014X-\u00117m)\u0005y\u0014\u0001E2iK\u000e\\\u0007K]8kK\u000e$H*[:u)\ryd\u000b\u0018\u0005\u0006/&\u0001\r\u0001W\u0001\u0007C\u000e$X/\u00197\u0011\u0007)\"\u0014\f\u0005\u000295&\u00111,\u000f\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007\"B/\n\u0001\u0004A\u0016\u0001C3ya\u0016\u001cG/\u001a3")
public class DataSourceAnalysisSuite
extends SparkFunSuite
implements SQLHelper {
    private Seq<Attribute> targetAttributes;
    private StructType targetPartitionSchema;
    private String sparkHome;
    private volatile boolean bitmap$0;

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$((SQLHelper)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    private String sparkHome$lzycompute() {
        DataSourceAnalysisSuite dataSourceAnalysisSuite = this;
        synchronized (dataSourceAnalysisSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$((SQLHelper)this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    public String sparkHome() {
        if (!this.bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    private Seq<Attribute> targetAttributes() {
        return this.targetAttributes;
    }

    private void targetAttributes_$eq(Seq<Attribute> x$1) {
        this.targetAttributes = x$1;
    }

    private StructType targetPartitionSchema() {
        return this.targetPartitionSchema;
    }

    private void targetPartitionSchema_$eq(StructType x$1) {
        this.targetPartitionSchema = x$1;
    }

    public void beforeAll() {
        super.beforeAll();
        this.targetAttributes_$eq((Seq<Attribute>)((Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).int(), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$)).int(), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).int(), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)).int(), (List)Nil$.MODULE$))))));
        this.targetPartitionSchema_$eq(new StructType().add("b", (DataType)IntegerType$.MODULE$).add("c", (DataType)IntegerType$.MODULE$));
    }

    private void checkProjectList(Seq<Expression> actual, Seq<Expression> expected) {
        Seq withoutAliases = (Seq)actual.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Expression expression = x0$1;
            if (expression instanceof Alias) {
                Alias alias = (Alias)expression;
                return alias.child();
            }
            return expression;
        }, Seq$.MODULE$.canBuildFrom());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(withoutAliases);
        Seq<Expression> $org_scalatest_assert_macro_right = expected;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
    }

    private final void testRule$1(String testName, boolean caseSensitive, Function0 func) {
        this.test(new StringBuilder(18).append(testName).append(" (caseSensitive: ").append(caseSensitive).append(")").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE().key()), (Object)Boolean.toString(caseSensitive))}), (Function0<BoxedUnit>)func), new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
    }

    private static final Expression cast$1(Expression e, DataType dt) {
        boolean bl;
        Enumeration.Value value = SQLConf$.MODULE$.get().storeAssignmentPolicy();
        Enumeration.Value value2 = SQLConf.StoreAssignmentPolicy$.MODULE$.ANSI();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            bl = true;
        } else {
            Enumeration.Value value4 = SQLConf.StoreAssignmentPolicy$.MODULE$.STRICT();
            Enumeration.Value value5 = value;
            bl = !(value4 != null ? !value4.equals(value5) : value5 != null);
        }
        if (bl) {
            Cast cast = Cast$.MODULE$.apply(e, dt, Option$.MODULE$.apply((Object)SQLConf$.MODULE$.get().sessionLocalTimeZone()), true);
            cast.setTagValue(Cast$.MODULE$.BY_TABLE_INSERTION(), (Object)BoxedUnit.UNIT);
            return cast;
        }
        return new Cast(e, dt, Option$.MODULE$.apply((Object)SQLConf$.MODULE$.get().sessionLocalTimeZone()), Cast$.MODULE$.apply$default$4());
    }

    public static final /* synthetic */ void $anonfun$new$1(DataSourceAnalysisSuite $this, boolean caseSensitive) {
        DataSourceAnalysis$ rule = DataSourceAnalysis$.MODULE$;
        $this.testRule$1("convertStaticPartitions only handle INSERT having at least static partitions", caseSensitive, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.intercept((Function0 & Serializable & scala.Serializable)() -> rule.convertStaticPartitions((Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"e"}))).$((Seq)Nil$.MODULE$)).int(), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"f"}))).$((Seq)Nil$.MODULE$)).int(), (List)Nil$.MODULE$)), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)None$.MODULE$)})), $this.targetAttributes(), $this.targetPartitionSchema()), ClassTag$.MODULE$.apply(AssertionError.class), new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75)));
        $this.testRule$1("Missing columns", caseSensitive, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.intercept((Function0 & Serializable & scala.Serializable)() -> rule.convertStaticPartitions((Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"e"}))).$((Seq)Nil$.MODULE$)).int(), (List)Nil$.MODULE$), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)new Some((Object)"1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)None$.MODULE$)})), $this.targetAttributes(), $this.targetPartitionSchema()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86)));
        $this.testRule$1("Missing partitioning columns", caseSensitive, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.intercept((Function0 & Serializable & scala.Serializable)() -> rule.convertStaticPartitions((Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"e"}))).$((Seq)Nil$.MODULE$)).int(), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"f"}))).$((Seq)Nil$.MODULE$)).int(), (List)Nil$.MODULE$)), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)new Some((Object)"1"))})), $this.targetAttributes(), $this.targetPartitionSchema()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
            $this.intercept((Function0 & Serializable & scala.Serializable)() -> rule.convertStaticPartitions((Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"e"}))).$((Seq)Nil$.MODULE$)).int(), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"f"}))).$((Seq)Nil$.MODULE$)).int(), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"g"}))).$((Seq)Nil$.MODULE$)).int(), (List)Nil$.MODULE$))), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)new Some((Object)"1"))})), $this.targetAttributes(), $this.targetPartitionSchema()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
            $this.intercept((Function0 & Serializable & scala.Serializable)() -> rule.convertStaticPartitions((Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"e"}))).$((Seq)Nil$.MODULE$)).int(), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"f"}))).$((Seq)Nil$.MODULE$)).int(), (List)Nil$.MODULE$)), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)new Some((Object)"1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"d"), (Object)None$.MODULE$)})), $this.targetAttributes(), $this.targetPartitionSchema()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
        });
        $this.testRule$1("Wrong partitioning columns", caseSensitive, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.intercept((Function0 & Serializable & scala.Serializable)() -> rule.convertStaticPartitions((Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"e"}))).$((Seq)Nil$.MODULE$)).int(), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"f"}))).$((Seq)Nil$.MODULE$)).int(), (List)Nil$.MODULE$)), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)new Some((Object)"1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"d"), (Object)new Some((Object)"2"))})), $this.targetAttributes(), $this.targetPartitionSchema()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
            $this.intercept((Function0 & Serializable & scala.Serializable)() -> rule.convertStaticPartitions((Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"e"}))).$((Seq)Nil$.MODULE$)).int(), (List)Nil$.MODULE$), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)new Some((Object)"1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)new Some((Object)"3")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"d"), (Object)new Some((Object)"2"))})), $this.targetAttributes(), $this.targetPartitionSchema()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
            if (caseSensitive) {
                $this.intercept((Function0 & Serializable & scala.Serializable)() -> rule.convertStaticPartitions((Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"e"}))).$((Seq)Nil$.MODULE$)).int(), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"f"}))).$((Seq)Nil$.MODULE$)).int(), (List)Nil$.MODULE$)), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)new Some((Object)"1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C"), (Object)new Some((Object)"3"))})), $this.targetAttributes(), $this.targetPartitionSchema()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
                return;
            }
        });
        $this.testRule$1("Static partitions need to appear before dynamic partitions", caseSensitive, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.intercept((Function0 & Serializable & scala.Serializable)() -> rule.convertStaticPartitions((Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"e"}))).$((Seq)Nil$.MODULE$)).int(), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"f"}))).$((Seq)Nil$.MODULE$)).int(), (List)Nil$.MODULE$)), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)new Some((Object)"3"))})), $this.targetAttributes(), $this.targetPartitionSchema()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157)));
        $this.testRule$1("All static partitions", caseSensitive, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (!caseSensitive) {
                Seq nonPartitionedAttributes = (Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"e"}))).$((Seq)Nil$.MODULE$)).int(), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"f"}))).$((Seq)Nil$.MODULE$)).int(), (List)Nil$.MODULE$));
                Seq expected = (Seq)nonPartitionedAttributes.$plus$plus((GenTraversableOnce)new .colon.colon((Object)DataSourceAnalysisSuite.cast$1((Expression)Literal$.MODULE$.apply((Object)"1"), (DataType)IntegerType$.MODULE$), (List)new .colon.colon((Object)DataSourceAnalysisSuite.cast$1((Expression)Literal$.MODULE$.apply((Object)"3"), (DataType)IntegerType$.MODULE$), (List)Nil$.MODULE$)), Seq$.MODULE$.canBuildFrom());
                Seq actual = rule.convertStaticPartitions(nonPartitionedAttributes, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)new Some((Object)"1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C"), (Object)new Some((Object)"3"))})), $this.targetAttributes(), $this.targetPartitionSchema());
                $this.checkProjectList((Seq<Expression>)actual, (Seq<Expression>)expected);
            }
            Seq nonPartitionedAttributes = (Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"e"}))).$((Seq)Nil$.MODULE$)).int(), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"f"}))).$((Seq)Nil$.MODULE$)).int(), (List)Nil$.MODULE$));
            Seq expected = (Seq)nonPartitionedAttributes.$plus$plus((GenTraversableOnce)new .colon.colon((Object)DataSourceAnalysisSuite.cast$1((Expression)Literal$.MODULE$.apply((Object)"1"), (DataType)IntegerType$.MODULE$), (List)new .colon.colon((Object)DataSourceAnalysisSuite.cast$1((Expression)Literal$.MODULE$.apply((Object)"3"), (DataType)IntegerType$.MODULE$), (List)Nil$.MODULE$)), Seq$.MODULE$.canBuildFrom());
            Seq actual = rule.convertStaticPartitions(nonPartitionedAttributes, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)new Some((Object)"1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)new Some((Object)"3"))})), $this.targetAttributes(), $this.targetPartitionSchema());
            $this.checkProjectList((Seq<Expression>)actual, (Seq<Expression>)expected);
            Seq nonPartitionedAttributes2 = (Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"e"}))).$((Seq)Nil$.MODULE$)).int(), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"f"}))).$((Seq)Nil$.MODULE$)).int(), (List)Nil$.MODULE$));
            Seq expected2 = (Seq)nonPartitionedAttributes2.$plus$plus((GenTraversableOnce)new .colon.colon((Object)DataSourceAnalysisSuite.cast$1((Expression)Literal$.MODULE$.apply((Object)"1"), (DataType)IntegerType$.MODULE$), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom());
            Seq actual2 = rule.convertStaticPartitions(nonPartitionedAttributes2, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)new Some((Object)"1"))})), (Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).int(), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$)).int(), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).int(), (List)Nil$.MODULE$))), new StructType().add("b", (DataType)IntegerType$.MODULE$));
            $this.checkProjectList((Seq<Expression>)actual2, (Seq<Expression>)expected2);
        });
        $this.testRule$1("Static partition and dynamic partition", caseSensitive, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq nonPartitionedAttributes = (Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"e"}))).$((Seq)Nil$.MODULE$)).int(), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"f"}))).$((Seq)Nil$.MODULE$)).int(), (List)Nil$.MODULE$));
            Seq dynamicPartitionAttributes = (Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"g"}))).$((Seq)Nil$.MODULE$)).int(), (List)Nil$.MODULE$);
            Seq expected = (Seq)((TraversableLike)nonPartitionedAttributes.$plus$plus((GenTraversableOnce)new .colon.colon((Object)DataSourceAnalysisSuite.cast$1((Expression)Literal$.MODULE$.apply((Object)"1"), (DataType)IntegerType$.MODULE$), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)dynamicPartitionAttributes, Seq$.MODULE$.canBuildFrom());
            Seq actual = rule.convertStaticPartitions((Seq)nonPartitionedAttributes.$plus$plus((GenTraversableOnce)dynamicPartitionAttributes, Seq$.MODULE$.canBuildFrom()), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)new Some((Object)"1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)None$.MODULE$)})), $this.targetAttributes(), $this.targetPartitionSchema());
            $this.checkProjectList((Seq<Expression>)actual, (Seq<Expression>)expected);
        });
    }

    public DataSourceAnalysisSuite() {
        SQLHelper.$init$((SQLHelper)this);
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)caseSensitive -> {
            DataSourceAnalysisSuite.$anonfun$new$1(this, BoxesRunTime.unboxToBoolean((Object)caseSensitive));
            return BoxedUnit.UNIT;
        });
    }
}

