/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URI;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.spark.Partition;
import org.apache.spark.QueryContext;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkSQLException;
import org.apache.spark.SparkThrowable;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrameReader;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Observation;
import org.apache.spark.sql.Observation$;
import org.apache.spark.sql.QueryTest;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.ShowCreateTable$;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.catalyst.util.DateTimeTestUtils$;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.execution.DataSourceScanExec;
import org.apache.spark.sql.execution.ExplainMode;
import org.apache.spark.sql.execution.ExtendedMode$;
import org.apache.spark.sql.execution.FilterExec;
import org.apache.spark.sql.execution.ProjectExec;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.WholeStageCodegenExec;
import org.apache.spark.sql.execution.command.ExplainCommand;
import org.apache.spark.sql.execution.command.ShowCreateTableCommand;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCPartition;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRelation;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRelation$;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.execution.metric.InputOutputMetricsHelper$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.SessionState;
import org.apache.spark.sql.jdbc.AggregatedDialect;
import org.apache.spark.sql.jdbc.DB2Dialect$;
import org.apache.spark.sql.jdbc.DerbyDialect$;
import org.apache.spark.sql.jdbc.H2Dialect$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcDialects$;
import org.apache.spark.sql.jdbc.MsSqlServerDialect$;
import org.apache.spark.sql.jdbc.MySQLDialect$;
import org.apache.spark.sql.jdbc.NoopDialect$;
import org.apache.spark.sql.jdbc.OracleDialect$;
import org.apache.spark.sql.jdbc.PostgresDialect$;
import org.apache.spark.sql.jdbc.TeradataDialect$;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.EqualNullSafe;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Not;
import org.apache.spark.sql.sources.Or;
import org.apache.spark.sql.test.SQLTestData;
import org.apache.spark.sql.test.SQLTestData$internalImplicits$;
import org.apache.spark.sql.test.SQLTestUtils;
import org.apache.spark.sql.test.SQLTestUtilsBase;
import org.apache.spark.sql.test.SQLTestUtilsBase$testImplicits$;
import org.apache.spark.sql.test.SharedSparkSession;
import org.apache.spark.sql.test.SharedSparkSessionBase;
import org.apache.spark.sql.test.TestSparkSession;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DatetimeType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.VarcharType;
import org.apache.spark.util.Utils$;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.scalatest.concurrent.AbstractPatienceConfiguration;
import org.scalatest.concurrent.AbstractPatienceConfiguration$PatienceConfig$;
import org.scalatest.concurrent.Eventually;
import org.scalatest.concurrent.PatienceConfiguration;
import org.scalatest.concurrent.ScaledTimeSpans;
import org.scalatest.enablers.Retrying;
import org.scalatest.time.Span;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u0005mb\u0001\u0002\f\u0018\u0001\tBQ!\f\u0001\u0005\u00029Bq!\r\u0001C\u0002\u0013\u0005!\u0007\u0003\u0004<\u0001\u0001\u0006Ia\r\u0005\by\u0001\u0011\r\u0011\"\u00013\u0011\u0019i\u0004\u0001)A\u0005g!9a\b\u0001a\u0001\n\u0003y\u0004bB#\u0001\u0001\u0004%\tA\u0012\u0005\u0007\u001f\u0002\u0001\u000b\u0015\u0002!\t\u000fA\u0003!\u0019!C\u0001#\"1\u0001\f\u0001Q\u0001\nICq!\u0017\u0001C\u0002\u0013\u0005!\f\u0003\u0004_\u0001\u0001\u0006Ia\u0017\u0005\b?\u0002\u0011\r\u0011\"\u0001[\u0011\u0019\u0001\u0007\u0001)A\u00057\")\u0011\r\u0001C\u0001E\")a\u000e\u0001C!_\")\u0001\u000f\u0001C!_\")\u0011\u000f\u0001C\u0001e\"9\u0011\u0011\u0004\u0001\u0005\n\u0005m\u0001bBA\u0010\u0001\u0011%\u0011\u0011\u0005\u0005\b\u0003K\u0001A\u0011BA\u0014\u0005%QEIQ\"Tk&$XM\u0003\u0002\u00193\u0005!!\u000e\u001a2d\u0015\tQ2$A\u0002tc2T!\u0001H\u000f\u0002\u000bM\u0004\u0018M]6\u000b\u0005yy\u0012AB1qC\u000eDWMC\u0001!\u0003\ry'oZ\u0002\u0001'\r\u00011e\n\t\u0003I\u0015j\u0011!G\u0005\u0003Me\u0011\u0011\"U;fef$Vm\u001d;\u0011\u0005!ZS\"A\u0015\u000b\u0005)J\u0012\u0001\u0002;fgRL!\u0001L\u0015\u0003%MC\u0017M]3e'B\f'o[*fgNLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003=\u0002\"\u0001\r\u0001\u000e\u0003]\t1!\u001e:m+\u0005\u0019\u0004C\u0001\u001b:\u001b\u0005)$B\u0001\u001c8\u0003\u0011a\u0017M\\4\u000b\u0003a\nAA[1wC&\u0011!(\u000e\u0002\u0007'R\u0014\u0018N\\4\u0002\tU\u0014H\u000eI\u0001\u0013kJdw+\u001b;i+N,'/\u00118e!\u0006\u001c8/A\nve2<\u0016\u000e\u001e5Vg\u0016\u0014\u0018I\u001c3QCN\u001c\b%\u0001\u0003d_:tW#\u0001!\u0011\u0005\u0005\u001bU\"\u0001\"\u000b\u0005i9\u0014B\u0001#C\u0005)\u0019uN\u001c8fGRLwN\\\u0001\tG>tgn\u0018\u0013fcR\u0011q)\u0014\t\u0003\u0011.k\u0011!\u0013\u0006\u0002\u0015\u0006)1oY1mC&\u0011A*\u0013\u0002\u0005+:LG\u000fC\u0004O\u000f\u0005\u0005\t\u0019\u0001!\u0002\u0007a$\u0013'A\u0003d_:t\u0007%A\u0005uKN$()\u001f;fgV\t!\u000bE\u0002I'VK!\u0001V%\u0003\u000b\u0005\u0013(/Y=\u0011\u0005!3\u0016BA,J\u0005\u0011\u0011\u0015\u0010^3\u0002\u0015Q,7\u000f\u001e\"zi\u0016\u001c\b%A\u0007uKN$\bJ\r#jC2,7\r^\u000b\u00027B\u0011\u0001\u0007X\u0005\u0003;^\u00111B\u00133cG\u0012K\u0017\r\\3di\u0006qA/Z:u\u0011J\"\u0015.\u00197fGR\u0004\u0013\u0001\u0006;fgRD%\u0007R5bY\u0016\u001cG\u000fV5os&sG/A\u000buKN$\bJ\r#jC2,7\r\u001e+j]fLe\u000e\u001e\u0011\u0002\u001f\u0011,g-Y;mi6+G/\u00193bi\u0006$\"aY5\u0011\u0005\u0011<W\"A3\u000b\u0005\u0019L\u0012!\u0002;za\u0016\u001c\u0018B\u00015f\u0005!iU\r^1eCR\f\u0007\"\u00026\u0010\u0001\u0004Y\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0011\u0005\u0011d\u0017BA7f\u0005!!\u0015\r^1UsB,\u0017!\u00032fM>\u0014X-\u00117m)\u00059\u0015\u0001C1gi\u0016\u0014\u0018\t\u001c7\u0002%\rDWmY6Ok6\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0005\u000fN\fy\u0001C\u0003u%\u0001\u0007Q/\u0001\u0002eMB\u0019a/!\u0003\u000f\u0007]\f)AD\u0002y\u0003\u0007q1!_A\u0001\u001d\tQxP\u0004\u0002|}6\tAP\u0003\u0002~C\u00051AH]8pizJ\u0011\u0001I\u0005\u0003=}I!\u0001H\u000f\n\u0005iY\u0012bAA\u00043\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0006\u0003\u001b\u0011\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0007\u0005\u001d\u0011\u0004C\u0004\u0002\u0012I\u0001\r!a\u0005\u0002+\u0015D\b/Z2uK\u0012tU/\u001c)beRLG/[8ogB\u0019\u0001*!\u0006\n\u0007\u0005]\u0011JA\u0002J]R\fQb\u00195fG.\u0004Vo\u001d5e_^tGcA;\u0002\u001e!)Ao\u0005a\u0001k\u0006\u00012\r[3dW:{G\u000fU;tQ\u0012|wO\u001c\u000b\u0004k\u0006\r\u0002\"\u0002;\u0015\u0001\u0004)\u0018\u0001E1tg\u0016\u0014H/R7qif\fV/\u001a:z)\r9\u0015\u0011\u0006\u0005\b\u0003W)\u0002\u0019AA\u0017\u0003%\u0019\u0018\u000f\\*ue&tw\r\u0005\u0003\u00020\u0005]b\u0002BA\u0019\u0003g\u0001\"a_%\n\u0007\u0005U\u0012*\u0001\u0004Qe\u0016$WMZ\u0005\u0004u\u0005e\"bAA\u001b\u0013\u0002")
public class JDBCSuite
extends QueryTest
implements SharedSparkSession {
    private final String url;
    private final String urlWithUserAndPass;
    private Connection conn;
    private final byte[] testBytes;
    private final JdbcDialect testH2Dialect;
    private final JdbcDialect testH2DialectTinyInt;
    private final boolean enableAutoThreadAudit;
    private TestSparkSession org$apache$spark$sql$test$SharedSparkSessionBase$$_spark;
    private boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    private Function1<String, Dataset<Row>> sql;
    private volatile SQLTestUtilsBase$testImplicits$ testImplicits$module;
    private volatile SQLTestData$internalImplicits$ internalImplicits$module;
    private Dataset<Row> emptyTestData;
    private Dataset<Row> testData;
    private Dataset<Row> testData2;
    private Dataset<Row> testData3;
    private Dataset<Row> negativeData;
    private Dataset<Row> largeAndSmallInts;
    private Dataset<Row> decimalData;
    private Dataset<Row> binaryData;
    private Dataset<Row> upperCaseData;
    private Dataset<Row> lowerCaseData;
    private Dataset<Row> lowerCaseDataWithDuplicates;
    private RDD<SQLTestData.ArrayData> arrayData;
    private RDD<SQLTestData.MapData> mapData;
    private RDD<SQLTestData.IntervalData> calendarIntervalData;
    private RDD<SQLTestData.StringData> repeatedData;
    private RDD<SQLTestData.StringData> nullableRepeatedData;
    private Dataset<Row> nullInts;
    private Dataset<Row> allNulls;
    private Dataset<Row> nullStrings;
    private Dataset<Row> tableName;
    private RDD<String> unparsedStrings;
    private RDD<SQLTestData.IntField> withEmptyParts;
    private Dataset<Row> person;
    private Dataset<Row> salary;
    private Dataset<Row> complexData;
    private Dataset<Row> courseSales;
    private Dataset<Row> trainingSales;
    private Dataset<Row> intervalData;
    private final AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    private volatile AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig$module;
    private volatile int bitmap$0;

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$beforeAll() {
        SharedSparkSessionBase.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$afterAll() {
        SharedSparkSessionBase.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$beforeAll() {
        SQLTestUtils.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    @Override
    public SparkConf sparkConf() {
        return SharedSparkSessionBase.sparkConf$(this);
    }

    @Override
    public SparkSession spark() {
        return SharedSparkSessionBase.spark$(this);
    }

    @Override
    public SQLContext sqlContext() {
        return SharedSparkSessionBase.sqlContext$(this);
    }

    @Override
    public TestSparkSession createSparkSession() {
        return SharedSparkSessionBase.createSparkSession$(this);
    }

    @Override
    public void initializeSession() {
        SharedSparkSessionBase.initializeSession$(this);
    }

    @Override
    public void beforeEach() {
        SharedSparkSessionBase.beforeEach$(this);
    }

    @Override
    public void afterEach() {
        SharedSparkSessionBase.afterEach$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$withTempDir(Function1 f) {
        super.withTempDir(f);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$test(String testName, Seq testTags, Function0 testBody, Position pos) {
        super.test(testName, testTags, testBody, pos);
    }

    @Override
    public void withTempDir(Function1<File, BoxedUnit> f) {
        SQLTestUtils.withTempDir$(this, f);
    }

    @Override
    public void testWithWholeStageCodegenOnAndOff(String testName, Function1<String, BoxedUnit> f) {
        SQLTestUtils.testWithWholeStageCodegenOnAndOff$(this, testName, f);
    }

    @Override
    public void setupTestData() {
        SQLTestUtils.setupTestData$(this);
    }

    @Override
    public void testQuietly(String name, Function0<BoxedUnit> f) {
        SQLTestUtils.testQuietly$(this, name, f);
    }

    @Override
    public void test(String testName, Seq<Tag> testTags, Function0<Object> testFun, Position pos) {
        SQLTestUtils.test$(this, testName, testTags, testFun, pos);
    }

    @Override
    public void testWithUninterruptibleThread(String name, boolean quietly, Function0<BoxedUnit> body) {
        SQLTestUtils.testWithUninterruptibleThread$(this, name, quietly, body);
    }

    @Override
    public boolean testWithUninterruptibleThread$default$2() {
        return SQLTestUtils.testWithUninterruptibleThread$default$2$(this);
    }

    @Override
    public void withResourceTempPath(String resourcePath, Function1<File, BoxedUnit> f) {
        SQLTestUtils.withResourceTempPath$(this, resourcePath, f);
    }

    @Override
    public void waitForTasksToFinish() {
        SQLTestUtils.waitForTasksToFinish$(this);
    }

    @Override
    public void withTempPaths(int numPaths, Function1<Seq<File>, BoxedUnit> f) {
        SQLTestUtils.withTempPaths$(this, numPaths, f);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtilsBase$$super$withSQLConf(Seq pairs, Function0 f) {
        SQLHelper.withSQLConf$((SQLHelper)this, (Seq)pairs, (Function0)f);
    }

    @Override
    public SparkContext sparkContext() {
        return SQLTestUtilsBase.sparkContext$(this);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withUserDefinedFunction(Seq<Tuple2<String, Object>> functions2, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withUserDefinedFunction$(this, functions2, f);
    }

    @Override
    public void withTempView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withTempView$(this, viewNames, f);
    }

    @Override
    public void withGlobalTempView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withGlobalTempView$(this, viewNames, f);
    }

    @Override
    public void withTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withTable$(this, tableNames, f);
    }

    @Override
    public void withView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withView$(this, viewNames, f);
    }

    @Override
    public void withCache(Seq<String> cacheNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withCache$(this, cacheNames, f);
    }

    @Override
    public void uncacheTable(String tableName) {
        SQLTestUtilsBase.uncacheTable$(this, tableName);
    }

    @Override
    public void withTempDatabase(Function1<String, BoxedUnit> f) {
        SQLTestUtilsBase.withTempDatabase$(this, f);
    }

    @Override
    public void withDatabase(Seq<String> dbNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withDatabase$(this, dbNames, f);
    }

    @Override
    public void withNamespace(Seq<String> namespaces, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withNamespace$(this, namespaces, f);
    }

    @Override
    public void withCurrentCatalogAndNamespace(Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withCurrentCatalogAndNamespace$(this, f);
    }

    @Override
    public void withLocale(String language, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withLocale$(this, language, f);
    }

    @Override
    public void activateDatabase(String db, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.activateDatabase$(this, db, f);
    }

    @Override
    public Dataset<Row> stripSparkFilter(Dataset<Row> df) {
        return SQLTestUtilsBase.stripSparkFilter$(this, df);
    }

    @Override
    public Dataset<Row> logicalPlanToSparkQuery(LogicalPlan plan) {
        return SQLTestUtilsBase.logicalPlanToSparkQuery$(this, plan);
    }

    @Override
    public URI makeQualifiedPath(String path) {
        return SQLTestUtilsBase.makeQualifiedPath$(this, path);
    }

    @Override
    public String testFile(String fileName) {
        return SQLTestUtilsBase.testFile$(this, fileName);
    }

    @Override
    public long getLocalDirSize(File file) {
        return SQLTestUtilsBase.getLocalDirSize$(this, file);
    }

    @Override
    public void loadTestData() {
        SQLTestData.loadTestData$(this);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, PatienceConfiguration.Interval interval, Function0<T> fun, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, (PatienceConfiguration.Interval)interval, fun, retrying, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Interval interval, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Interval)interval, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public <T> T eventually(Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public AbstractPatienceConfiguration.PatienceConfig patienceConfig() {
        return PatienceConfiguration.patienceConfig$((PatienceConfiguration)this);
    }

    public PatienceConfiguration.Timeout timeout(Span value) {
        return PatienceConfiguration.timeout$((PatienceConfiguration)this, (Span)value);
    }

    public PatienceConfiguration.Interval interval(Span value) {
        return PatienceConfiguration.interval$((PatienceConfiguration)this, (Span)value);
    }

    public final Span scaled(Span span) {
        return ScaledTimeSpans.scaled$((ScaledTimeSpans)this, (Span)span);
    }

    public double spanScaleFactor() {
        return ScaledTimeSpans.spanScaleFactor$((ScaledTimeSpans)this);
    }

    @Override
    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSparkSession$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    @Override
    public TestSparkSession org$apache$spark$sql$test$SharedSparkSessionBase$$_spark() {
        return this.org$apache$spark$sql$test$SharedSparkSessionBase$$_spark;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSparkSessionBase$$_spark_$eq(TestSparkSession x$1) {
        this.org$apache$spark$sql$test$SharedSparkSessionBase$$_spark = x$1;
    }

    @Override
    public boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests() {
        return this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    }

    @Override
    public void org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests_$eq(boolean x$1) {
        this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests = x$1;
    }

    private Function1<String, Dataset<Row>> sql$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if ((this.bitmap$0 & 1) == 0) {
                this.sql = SQLTestUtilsBase.sql$(this);
                this.bitmap$0 |= 1;
            }
        }
        return this.sql;
    }

    @Override
    public Function1<String, Dataset<Row>> sql() {
        if ((this.bitmap$0 & 1) == 0) {
            return this.sql$lzycompute();
        }
        return this.sql;
    }

    @Override
    public SQLTestUtilsBase$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public SQLTestData$internalImplicits$ org$apache$spark$sql$test$SQLTestData$$internalImplicits() {
        if (this.internalImplicits$module == null) {
            this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute$1();
        }
        return this.internalImplicits$module;
    }

    private Dataset<Row> emptyTestData$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if ((this.bitmap$0 & 2) == 0) {
                this.emptyTestData = SQLTestData.emptyTestData$(this);
                this.bitmap$0 |= 2;
            }
        }
        return this.emptyTestData;
    }

    @Override
    public Dataset<Row> emptyTestData() {
        if ((this.bitmap$0 & 2) == 0) {
            return this.emptyTestData$lzycompute();
        }
        return this.emptyTestData;
    }

    private Dataset<Row> testData$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if ((this.bitmap$0 & 4) == 0) {
                this.testData = SQLTestData.testData$(this);
                this.bitmap$0 |= 4;
            }
        }
        return this.testData;
    }

    @Override
    public Dataset<Row> testData() {
        if ((this.bitmap$0 & 4) == 0) {
            return this.testData$lzycompute();
        }
        return this.testData;
    }

    private Dataset<Row> testData2$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if ((this.bitmap$0 & 8) == 0) {
                this.testData2 = SQLTestData.testData2$(this);
                this.bitmap$0 |= 8;
            }
        }
        return this.testData2;
    }

    @Override
    public Dataset<Row> testData2() {
        if ((this.bitmap$0 & 8) == 0) {
            return this.testData2$lzycompute();
        }
        return this.testData2;
    }

    private Dataset<Row> testData3$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.testData3 = SQLTestData.testData3$(this);
                this.bitmap$0 |= 0x10;
            }
        }
        return this.testData3;
    }

    @Override
    public Dataset<Row> testData3() {
        if ((this.bitmap$0 & 0x10) == 0) {
            return this.testData3$lzycompute();
        }
        return this.testData3;
    }

    private Dataset<Row> negativeData$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.negativeData = SQLTestData.negativeData$(this);
                this.bitmap$0 |= 0x20;
            }
        }
        return this.negativeData;
    }

    @Override
    public Dataset<Row> negativeData() {
        if ((this.bitmap$0 & 0x20) == 0) {
            return this.negativeData$lzycompute();
        }
        return this.negativeData;
    }

    private Dataset<Row> largeAndSmallInts$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.largeAndSmallInts = SQLTestData.largeAndSmallInts$(this);
                this.bitmap$0 |= 0x40;
            }
        }
        return this.largeAndSmallInts;
    }

    @Override
    public Dataset<Row> largeAndSmallInts() {
        if ((this.bitmap$0 & 0x40) == 0) {
            return this.largeAndSmallInts$lzycompute();
        }
        return this.largeAndSmallInts;
    }

    private Dataset<Row> decimalData$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.decimalData = SQLTestData.decimalData$(this);
                this.bitmap$0 |= 0x80;
            }
        }
        return this.decimalData;
    }

    @Override
    public Dataset<Row> decimalData() {
        if ((this.bitmap$0 & 0x80) == 0) {
            return this.decimalData$lzycompute();
        }
        return this.decimalData;
    }

    private Dataset<Row> binaryData$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.binaryData = SQLTestData.binaryData$(this);
                this.bitmap$0 |= 0x100;
            }
        }
        return this.binaryData;
    }

    @Override
    public Dataset<Row> binaryData() {
        if ((this.bitmap$0 & 0x100) == 0) {
            return this.binaryData$lzycompute();
        }
        return this.binaryData;
    }

    private Dataset<Row> upperCaseData$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.upperCaseData = SQLTestData.upperCaseData$(this);
                this.bitmap$0 |= 0x200;
            }
        }
        return this.upperCaseData;
    }

    @Override
    public Dataset<Row> upperCaseData() {
        if ((this.bitmap$0 & 0x200) == 0) {
            return this.upperCaseData$lzycompute();
        }
        return this.upperCaseData;
    }

    private Dataset<Row> lowerCaseData$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.lowerCaseData = SQLTestData.lowerCaseData$(this);
                this.bitmap$0 |= 0x400;
            }
        }
        return this.lowerCaseData;
    }

    @Override
    public Dataset<Row> lowerCaseData() {
        if ((this.bitmap$0 & 0x400) == 0) {
            return this.lowerCaseData$lzycompute();
        }
        return this.lowerCaseData;
    }

    private Dataset<Row> lowerCaseDataWithDuplicates$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.lowerCaseDataWithDuplicates = SQLTestData.lowerCaseDataWithDuplicates$(this);
                this.bitmap$0 |= 0x800;
            }
        }
        return this.lowerCaseDataWithDuplicates;
    }

    @Override
    public Dataset<Row> lowerCaseDataWithDuplicates() {
        if ((this.bitmap$0 & 0x800) == 0) {
            return this.lowerCaseDataWithDuplicates$lzycompute();
        }
        return this.lowerCaseDataWithDuplicates;
    }

    private RDD<SQLTestData.ArrayData> arrayData$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.arrayData = SQLTestData.arrayData$(this);
                this.bitmap$0 |= 0x1000;
            }
        }
        return this.arrayData;
    }

    @Override
    public RDD<SQLTestData.ArrayData> arrayData() {
        if ((this.bitmap$0 & 0x1000) == 0) {
            return this.arrayData$lzycompute();
        }
        return this.arrayData;
    }

    private RDD<SQLTestData.MapData> mapData$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if ((this.bitmap$0 & 0x2000) == 0) {
                this.mapData = SQLTestData.mapData$(this);
                this.bitmap$0 |= 0x2000;
            }
        }
        return this.mapData;
    }

    @Override
    public RDD<SQLTestData.MapData> mapData() {
        if ((this.bitmap$0 & 0x2000) == 0) {
            return this.mapData$lzycompute();
        }
        return this.mapData;
    }

    private RDD<SQLTestData.IntervalData> calendarIntervalData$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if ((this.bitmap$0 & 0x4000) == 0) {
                this.calendarIntervalData = SQLTestData.calendarIntervalData$(this);
                this.bitmap$0 |= 0x4000;
            }
        }
        return this.calendarIntervalData;
    }

    @Override
    public RDD<SQLTestData.IntervalData> calendarIntervalData() {
        if ((this.bitmap$0 & 0x4000) == 0) {
            return this.calendarIntervalData$lzycompute();
        }
        return this.calendarIntervalData;
    }

    private RDD<SQLTestData.StringData> repeatedData$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if ((this.bitmap$0 & 0x8000) == 0) {
                this.repeatedData = SQLTestData.repeatedData$(this);
                this.bitmap$0 |= 0x8000;
            }
        }
        return this.repeatedData;
    }

    @Override
    public RDD<SQLTestData.StringData> repeatedData() {
        if ((this.bitmap$0 & 0x8000) == 0) {
            return this.repeatedData$lzycompute();
        }
        return this.repeatedData;
    }

    private RDD<SQLTestData.StringData> nullableRepeatedData$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if ((this.bitmap$0 & 0x10000) == 0) {
                this.nullableRepeatedData = SQLTestData.nullableRepeatedData$(this);
                this.bitmap$0 |= 0x10000;
            }
        }
        return this.nullableRepeatedData;
    }

    @Override
    public RDD<SQLTestData.StringData> nullableRepeatedData() {
        if ((this.bitmap$0 & 0x10000) == 0) {
            return this.nullableRepeatedData$lzycompute();
        }
        return this.nullableRepeatedData;
    }

    private Dataset<Row> nullInts$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if ((this.bitmap$0 & 0x20000) == 0) {
                this.nullInts = SQLTestData.nullInts$(this);
                this.bitmap$0 |= 0x20000;
            }
        }
        return this.nullInts;
    }

    @Override
    public Dataset<Row> nullInts() {
        if ((this.bitmap$0 & 0x20000) == 0) {
            return this.nullInts$lzycompute();
        }
        return this.nullInts;
    }

    private Dataset<Row> allNulls$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if ((this.bitmap$0 & 0x40000) == 0) {
                this.allNulls = SQLTestData.allNulls$(this);
                this.bitmap$0 |= 0x40000;
            }
        }
        return this.allNulls;
    }

    @Override
    public Dataset<Row> allNulls() {
        if ((this.bitmap$0 & 0x40000) == 0) {
            return this.allNulls$lzycompute();
        }
        return this.allNulls;
    }

    private Dataset<Row> nullStrings$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if ((this.bitmap$0 & 0x80000) == 0) {
                this.nullStrings = SQLTestData.nullStrings$(this);
                this.bitmap$0 |= 0x80000;
            }
        }
        return this.nullStrings;
    }

    @Override
    public Dataset<Row> nullStrings() {
        if ((this.bitmap$0 & 0x80000) == 0) {
            return this.nullStrings$lzycompute();
        }
        return this.nullStrings;
    }

    private Dataset<Row> tableName$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if ((this.bitmap$0 & 0x100000) == 0) {
                this.tableName = SQLTestData.tableName$(this);
                this.bitmap$0 |= 0x100000;
            }
        }
        return this.tableName;
    }

    @Override
    public Dataset<Row> tableName() {
        if ((this.bitmap$0 & 0x100000) == 0) {
            return this.tableName$lzycompute();
        }
        return this.tableName;
    }

    private RDD<String> unparsedStrings$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if ((this.bitmap$0 & 0x200000) == 0) {
                this.unparsedStrings = SQLTestData.unparsedStrings$(this);
                this.bitmap$0 |= 0x200000;
            }
        }
        return this.unparsedStrings;
    }

    @Override
    public RDD<String> unparsedStrings() {
        if ((this.bitmap$0 & 0x200000) == 0) {
            return this.unparsedStrings$lzycompute();
        }
        return this.unparsedStrings;
    }

    private RDD<SQLTestData.IntField> withEmptyParts$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if ((this.bitmap$0 & 0x400000) == 0) {
                this.withEmptyParts = SQLTestData.withEmptyParts$(this);
                this.bitmap$0 |= 0x400000;
            }
        }
        return this.withEmptyParts;
    }

    @Override
    public RDD<SQLTestData.IntField> withEmptyParts() {
        if ((this.bitmap$0 & 0x400000) == 0) {
            return this.withEmptyParts$lzycompute();
        }
        return this.withEmptyParts;
    }

    private Dataset<Row> person$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if ((this.bitmap$0 & 0x800000) == 0) {
                this.person = SQLTestData.person$(this);
                this.bitmap$0 |= 0x800000;
            }
        }
        return this.person;
    }

    @Override
    public Dataset<Row> person() {
        if ((this.bitmap$0 & 0x800000) == 0) {
            return this.person$lzycompute();
        }
        return this.person;
    }

    private Dataset<Row> salary$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if ((this.bitmap$0 & 0x1000000) == 0) {
                this.salary = SQLTestData.salary$(this);
                this.bitmap$0 |= 0x1000000;
            }
        }
        return this.salary;
    }

    @Override
    public Dataset<Row> salary() {
        if ((this.bitmap$0 & 0x1000000) == 0) {
            return this.salary$lzycompute();
        }
        return this.salary;
    }

    private Dataset<Row> complexData$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if ((this.bitmap$0 & 0x2000000) == 0) {
                this.complexData = SQLTestData.complexData$(this);
                this.bitmap$0 |= 0x2000000;
            }
        }
        return this.complexData;
    }

    @Override
    public Dataset<Row> complexData() {
        if ((this.bitmap$0 & 0x2000000) == 0) {
            return this.complexData$lzycompute();
        }
        return this.complexData;
    }

    private Dataset<Row> courseSales$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if ((this.bitmap$0 & 0x4000000) == 0) {
                this.courseSales = SQLTestData.courseSales$(this);
                this.bitmap$0 |= 0x4000000;
            }
        }
        return this.courseSales;
    }

    @Override
    public Dataset<Row> courseSales() {
        if ((this.bitmap$0 & 0x4000000) == 0) {
            return this.courseSales$lzycompute();
        }
        return this.courseSales;
    }

    private Dataset<Row> trainingSales$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if ((this.bitmap$0 & 0x8000000) == 0) {
                this.trainingSales = SQLTestData.trainingSales$(this);
                this.bitmap$0 |= 0x8000000;
            }
        }
        return this.trainingSales;
    }

    @Override
    public Dataset<Row> trainingSales() {
        if ((this.bitmap$0 & 0x8000000) == 0) {
            return this.trainingSales$lzycompute();
        }
        return this.trainingSales;
    }

    private Dataset<Row> intervalData$lzycompute() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if ((this.bitmap$0 & 0x10000000) == 0) {
                this.intervalData = SQLTestData.intervalData$(this);
                this.bitmap$0 |= 0x10000000;
            }
        }
        return this.intervalData;
    }

    @Override
    public Dataset<Row> intervalData() {
        if ((this.bitmap$0 & 0x10000000) == 0) {
            return this.intervalData$lzycompute();
        }
        return this.intervalData;
    }

    public AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig() {
        return this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    }

    public final void org$scalatest$concurrent$PatienceConfiguration$_setter_$org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig_$eq(AbstractPatienceConfiguration.PatienceConfig x$1) {
        this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig = x$1;
    }

    public AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig() {
        if (this.PatienceConfig$module == null) {
            this.PatienceConfig$lzycompute$1();
        }
        return this.PatienceConfig$module;
    }

    public String url() {
        return this.url;
    }

    public String urlWithUserAndPass() {
        return this.urlWithUserAndPass;
    }

    public Connection conn() {
        return this.conn;
    }

    public void conn_$eq(Connection x$1) {
        this.conn = x$1;
    }

    public byte[] testBytes() {
        return this.testBytes;
    }

    public JdbcDialect testH2Dialect() {
        return this.testH2Dialect;
    }

    public JdbcDialect testH2DialectTinyInt() {
        return this.testH2DialectTinyInt;
    }

    public Metadata defaultMetadata(DataType dataType) {
        return new MetadataBuilder().putLong("scale", 0L).putBoolean("isSigned", dataType instanceof NumericType).build();
    }

    @Override
    public void beforeAll() {
        SharedSparkSession.beforeAll$(this);
        Utils$.MODULE$.classForName("org.h2.Driver", Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3());
        Properties properties = new Properties();
        properties.setProperty("user", "testUser");
        properties.setProperty("password", "testPass");
        this.conn_$eq(DriverManager.getConnection(this.url(), properties));
        this.conn().prepareStatement("create schema test").executeUpdate();
        this.conn().prepareStatement("create table test.people (name TEXT(32) NOT NULL, theid INTEGER NOT NULL)").executeUpdate();
        this.conn().prepareStatement("insert into test.people values ('fred', 1)").executeUpdate();
        this.conn().prepareStatement("insert into test.people values ('mary', 2)").executeUpdate();
        this.conn().prepareStatement("insert into test.people values ('joe ''foo'' \"bar\"', 3)").executeUpdate();
        this.conn().commit();
        this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(185).append("\n        |CREATE OR REPLACE TEMPORARY VIEW foobar\n        |USING org.apache.spark.sql.jdbc\n        |OPTIONS (url '").append(this.url()).append("', dbtable 'TEST.PEOPLE', user 'testUser', password 'testPass')\n       ").toString())).stripMargin().replaceAll("\n", " "));
        this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(211).append("\n        |CREATE OR REPLACE TEMPORARY VIEW fetchtwo\n        |USING org.apache.spark.sql.jdbc\n        |OPTIONS (url '").append(this.url()).append("', dbtable 'TEST.PEOPLE', user 'testUser', password 'testPass',\n        |         ").append(JDBCOptions$.MODULE$.JDBC_BATCH_FETCH_SIZE()).append(" '2')\n       ").toString())).stripMargin().replaceAll("\n", " "));
        this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(278).append("\n        |CREATE OR REPLACE TEMPORARY VIEW parts\n        |USING org.apache.spark.sql.jdbc\n        |OPTIONS (url '").append(this.url()).append("', dbtable 'TEST.PEOPLE', user 'testUser', password 'testPass',\n        |         partitionColumn 'THEID', lowerBound '1', upperBound '4', numPartitions '3')\n       ").toString())).stripMargin().replaceAll("\n", " "));
        this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(341).append("\n        |CREATE OR REPLACE TEMPORARY VIEW partsoverflow\n        |USING org.apache.spark.sql.jdbc\n        |OPTIONS (url '").append(this.url()).append("', dbtable 'TEST.PEOPLE', user 'testUser', password 'testPass',\n        |         partitionColumn 'THEID', lowerBound '-9223372036854775808',\n        |         upperBound '9223372036854775807', numPartitions '3')\n       ").toString())).stripMargin().replaceAll("\n", " "));
        this.conn().prepareStatement("create table test.inttypes (a INT, b BOOLEAN, c TINYINT, d SMALLINT, e BIGINT)").executeUpdate();
        this.conn().prepareStatement("insert into test.inttypes values (1, false, 3, 4, 1234567890123)").executeUpdate();
        this.conn().prepareStatement("insert into test.inttypes values (null, null, null, null, null)").executeUpdate();
        this.conn().commit();
        this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(189).append("\n        |CREATE OR REPLACE TEMPORARY VIEW inttypes\n        |USING org.apache.spark.sql.jdbc\n        |OPTIONS (url '").append(this.url()).append("', dbtable 'TEST.INTTYPES', user 'testUser', password 'testPass')\n       ").toString())).stripMargin().replaceAll("\n", " "));
        this.conn().prepareStatement("create table test.strtypes (a BINARY(20), b VARCHAR(20), c VARCHAR_IGNORECASE(20), d CHAR(20), e BLOB, f CLOB)").executeUpdate();
        PreparedStatement stmt = this.conn().prepareStatement("insert into test.strtypes values (?, ?, ?, ?, ?, ?)");
        stmt.setBytes(1, this.testBytes());
        stmt.setString(2, "Sensitive");
        stmt.setString(3, "Insensitive");
        stmt.setString(4, "Twenty-byte CHAR");
        stmt.setBytes(5, this.testBytes());
        stmt.setString(6, "I am a clob!");
        stmt.executeUpdate();
        this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(189).append("\n        |CREATE OR REPLACE TEMPORARY VIEW strtypes\n        |USING org.apache.spark.sql.jdbc\n        |OPTIONS (url '").append(this.url()).append("', dbtable 'TEST.STRTYPES', user 'testUser', password 'testPass')\n       ").toString())).stripMargin().replaceAll("\n", " "));
        this.conn().prepareStatement("create table test.timetypes (a TIME, b DATE, c TIMESTAMP(7))").executeUpdate();
        this.conn().prepareStatement("insert into test.timetypes values ('12:34:56', '1996-01-01', '2002-02-20 11:22:33.543543543')").executeUpdate();
        this.conn().prepareStatement("insert into test.timetypes values ('12:34:56', null, '2002-02-20 11:22:33.543543543')").executeUpdate();
        this.conn().commit();
        this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(191).append("\n        |CREATE OR REPLACE TEMPORARY VIEW timetypes\n        |USING org.apache.spark.sql.jdbc\n        |OPTIONS (url '").append(this.url()).append("', dbtable 'TEST.TIMETYPES', user 'testUser', password 'testPass')\n       ").toString())).stripMargin().replaceAll("\n", " "));
        this.conn().prepareStatement("CREATE TABLE test.timezone (tz TIMESTAMP WITH TIME ZONE) AS SELECT '1999-01-08 04:05:06.543543543-08:00'").executeUpdate();
        this.conn().commit();
        this.conn().prepareStatement("CREATE TABLE test.array_table (ar Integer ARRAY) AS SELECT ARRAY[1, 2, 3]").executeUpdate();
        this.conn().commit();
        this.conn().prepareStatement("create table test.flttypes (a DOUBLE, b REAL, c DECIMAL(38, 18))").executeUpdate();
        this.conn().prepareStatement("insert into test.flttypes values (1.0000000000000002220446049250313080847263336181640625, 1.00000011920928955078125, 123456789012345.543215432154321)").executeUpdate();
        this.conn().commit();
        this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(189).append("\n        |CREATE OR REPLACE TEMPORARY VIEW flttypes\n        |USING org.apache.spark.sql.jdbc\n        |OPTIONS (url '").append(this.url()).append("', dbtable 'TEST.FLTTYPES', user 'testUser', password 'testPass')\n       ").toString())).stripMargin().replaceAll("\n", " "));
        this.conn().prepareStatement(new StringOps(Predef$.MODULE$.augmentString("\n        |create table test.nulltypes (a INT, b BOOLEAN, c TINYINT, d BINARY(20), e VARCHAR(20),\n        |f VARCHAR_IGNORECASE(20), g CHAR(20), h BLOB, i CLOB, j TIME, k DATE, l TIMESTAMP,\n        |m DOUBLE, n REAL, o DECIMAL(38, 18))\n       ")).stripMargin().replaceAll("\n", " ")).executeUpdate();
        this.conn().prepareStatement("insert into test.nulltypes values (null, null, null, null, null, null, null, null, null, null, null, null, null, null, null)").executeUpdate();
        this.conn().commit();
        this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(194).append("\n         |CREATE OR REPLACE TEMPORARY VIEW nulltypes\n         |USING org.apache.spark.sql.jdbc\n         |OPTIONS (url '").append(this.url()).append("', dbtable 'TEST.NULLTYPES', user 'testUser', password 'testPass')\n       ").toString())).stripMargin().replaceAll("\n", " "));
        this.conn().prepareStatement("create table test.emp(name TEXT(32) NOT NULL, theid INTEGER, \"Dept\" INTEGER)").executeUpdate();
        this.conn().prepareStatement("insert into test.emp values ('fred', 1, 10)").executeUpdate();
        this.conn().prepareStatement("insert into test.emp values ('mary', 2, null)").executeUpdate();
        this.conn().prepareStatement("insert into test.emp values ('joe ''foo'' \"bar\"', 3, 30)").executeUpdate();
        this.conn().prepareStatement("insert into test.emp values ('kathy', null, null)").executeUpdate();
        this.conn().commit();
        this.conn().prepareStatement("create table test.seq(id INTEGER)").executeUpdate();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)value -> this.conn().prepareStatement(new StringBuilder(30).append("insert into test.seq values (").append(value).append(")").toString()).executeUpdate());
        this.conn().prepareStatement("insert into test.seq values (null)").executeUpdate();
        this.conn().commit();
        this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(271).append("\n        |CREATE OR REPLACE TEMPORARY VIEW nullparts\n        |USING org.apache.spark.sql.jdbc\n        |OPTIONS (url '").append(this.url()).append("', dbtable 'TEST.EMP', user 'testUser', password 'testPass',\n        |partitionColumn '\"Dept\"', lowerBound '1', upperBound '4', numPartitions '3')\n       ").toString())).stripMargin().replaceAll("\n", " "));
        this.conn().prepareStatement("create table test.\"mixedCaseCols\" (\"Name\" TEXT(32), \"Id\" INTEGER NOT NULL)").executeUpdate();
        this.conn().prepareStatement("insert into test.\"mixedCaseCols\" values ('fred', 1)").executeUpdate();
        this.conn().prepareStatement("insert into test.\"mixedCaseCols\" values ('mary', 2)").executeUpdate();
        this.conn().prepareStatement("insert into test.\"mixedCaseCols\" values (null, 3)").executeUpdate();
        this.conn().commit();
        this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(201).append("\n        |CREATE OR REPLACE TEMPORARY VIEW mixedCaseCols\n        |USING org.apache.spark.sql.jdbc\n        |OPTIONS (url '").append(this.url()).append("', dbtable 'TEST.\"mixedCaseCols\"', user 'testUser', password 'testPass')\n       ").toString())).stripMargin().replaceAll("\n", " "));
        this.conn().prepareStatement("CREATE TABLE test.partition (THEID INTEGER, `THE ID` INTEGER) AS SELECT 1, 1").executeUpdate();
        this.conn().commit();
        this.conn().prepareStatement("CREATE TABLE test.datetime (d DATE, t TIMESTAMP)").executeUpdate();
        this.conn().prepareStatement("INSERT INTO test.datetime VALUES ('2018-07-06', '2018-07-06 05:50:00.0')").executeUpdate();
        this.conn().prepareStatement("INSERT INTO test.datetime VALUES ('2018-07-06', '2018-07-06 08:10:08.0')").executeUpdate();
        this.conn().prepareStatement("INSERT INTO test.datetime VALUES ('2018-07-08', '2018-07-08 13:32:01.0')").executeUpdate();
        this.conn().prepareStatement("INSERT INTO test.datetime VALUES ('2018-07-12', '2018-07-12 09:51:15.0')").executeUpdate();
        this.conn().commit();
        this.conn().prepareStatement("CREATE TABLE test.composite_name (`last name` TEXT(32) NOT NULL, id INTEGER NOT NULL)").executeUpdate();
        this.conn().prepareStatement("INSERT INTO test.composite_name VALUES ('smith', 1)").executeUpdate();
        this.conn().prepareStatement("INSERT INTO test.composite_name VALUES ('jones', 2)").executeUpdate();
        this.conn().commit();
        this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(201).append("\n        |CREATE OR REPLACE TEMPORARY VIEW composite_name\n        |USING org.apache.spark.sql.jdbc\n        |OPTIONS (url '").append(this.url()).append("', dbtable 'TEST.COMPOSITE_NAME', user 'testUser', password 'testPass')\n       ").toString())).stripMargin().replaceAll("\n", " "));
    }

    @Override
    public void afterAll() {
        this.conn().close();
        SharedSparkSession.afterAll$(this);
    }

    public void checkNumPartitions(Dataset<Row> df, int expectedNumPartitions) {
        Seq jdbcRelations;
        Seq $org_scalatest_assert_macro_left = jdbcRelations = df.queryExecution().analyzed().collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                LogicalRelation logicalRelation;
                BaseRelation r;
                A1 A1 = x1;
                if (A1 instanceof LogicalRelation && (r = (logicalRelation = (LogicalRelation)A1).relation()) instanceof JDBCRelation) {
                    JDBCRelation jDBCRelation = (JDBCRelation)r;
                    return (B1)jDBCRelation;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalRelation logicalRelation;
                BaseRelation r;
                LogicalPlan logicalPlan = x1;
                return logicalPlan instanceof LogicalRelation && (r = (logicalRelation = (LogicalRelation)logicalPlan).relation()) instanceof JDBCRelation;
            }
        });
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 311));
        Partition[] $org_scalatest_assert_macro_left2 = ((JDBCRelation)jdbcRelations.head()).parts();
        int $org_scalatest_assert_macro_right2 = expectedNumPartitions;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)new StringBuilder(53).append("Expecting a JDBCRelation with ").append(expectedNumPartitions).append(" partitions, but got:`").append(jdbcRelations).append("`").toString(), Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 312));
    }

    private Dataset<Row> checkPushdown(Dataset<Row> df) {
        SparkPlan child;
        SparkPlan sparkPlan2;
        SparkPlan parentPlan;
        SparkPlan $org_scalatest_assert_macro_left = parentPlan = df.queryExecution().executedPlan();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.spark.sql.execution.WholeStageCodegenExec", $org_scalatest_assert_macro_left instanceof WholeStageCodegenExec, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 320));
        WholeStageCodegenExec node = (WholeStageCodegenExec)parentPlan;
        SparkPlan sparkPlan3 = node.child();
        if (sparkPlan3 instanceof ProjectExec) {
            SparkPlan c;
            ProjectExec projectExec = (ProjectExec)sparkPlan3;
            sparkPlan2 = c = projectExec.child();
        } else {
            sparkPlan2 = sparkPlan3;
        }
        SparkPlan $org_scalatest_assert_macro_left2 = child = sparkPlan2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.execution.DataSourceScanExec", $org_scalatest_assert_macro_left2 instanceof DataSourceScanExec, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 326));
        String $org_scalatest_assert_macro_left3 = ((DataSourceScanExec)child).nodeName();
        String $org_scalatest_assert_macro_right = "JDBCRelation";
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 327));
        return df;
    }

    private Dataset<Row> checkNotPushdown(Dataset<Row> df) {
        SparkPlan parentPlan;
        SparkPlan $org_scalatest_assert_macro_left = parentPlan = df.queryExecution().executedPlan();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.spark.sql.execution.WholeStageCodegenExec", $org_scalatest_assert_macro_left instanceof WholeStageCodegenExec, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 335));
        WholeStageCodegenExec node = (WholeStageCodegenExec)parentPlan;
        SparkPlan $org_scalatest_assert_macro_left2 = node.child();
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.execution.FilterExec", $org_scalatest_assert_macro_left2 instanceof FilterExec, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 337));
        return df;
    }

    private void assertEmptyQuery(String sqlString) {
        Object[] $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])((Dataset)this.sql().apply((Object)sqlString)).collect());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left), "isEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left).isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1308));
    }

    private final void testImplicits$lzycompute$1() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new SQLTestUtilsBase$testImplicits$(this);
            }
        }
    }

    private final void org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute$1() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if (this.internalImplicits$module == null) {
                this.internalImplicits$module = new SQLTestData$internalImplicits$(this);
            }
        }
    }

    private final void PatienceConfig$lzycompute$1() {
        JDBCSuite jDBCSuite = this;
        synchronized (jDBCSuite) {
            if (this.PatienceConfig$module == null) {
                this.PatienceConfig$module = new AbstractPatienceConfiguration$PatienceConfig$((AbstractPatienceConfiguration)this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$new$7(String x$1, String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).$less((Object)x$2);
    }

    public static final /* synthetic */ boolean $anonfun$new$10(String x$3, String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).$less((Object)x$4);
    }

    public static final /* synthetic */ Assertion $anonfun$new$30(JDBCSuite $this, int size) {
        Properties properties = new Properties();
        properties.setProperty(JDBCOptions$.MODULE$.JDBC_BATCH_FETCH_SIZE(), Integer.toString(size));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((Row[])$this.spark().read().jdbc($this.urlWithUserAndPass(), "TEST.PEOPLE", properties).collect()).length));
        int $org_scalatest_assert_macro_right = 3;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 539));
    }

    public static final /* synthetic */ boolean $anonfun$new$53(StructField x$11) {
        DataType dataType = x$11.dataType();
        StringType$ stringType$ = StringType$.MODULE$;
        return dataType == null ? stringType$ != null : !dataType.equals(stringType$);
    }

    private static final String doCompileFilter$1(Filter f) {
        return (String)JdbcDialects$.MODULE$.get("jdbc:").compileExpression((Expression)f.toV2()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
    }

    private static final JdbcDialect genDialect$1(Option cascadingTruncateTable) {
        return new JdbcDialect(null, cascadingTruncateTable){
            private final Option cascadingTruncateTable$1;

            public boolean canHandle(String url) {
                return true;
            }

            public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
                return None$.MODULE$;
            }

            public Option<Object> isCascadingTruncateTable() {
                return this.cascadingTruncateTable$1;
            }
            {
                this.cascadingTruncateTable$1 = cascadingTruncateTable$1;
            }
        };
    }

    private final void testDialects$1(List cascadings, Option expected) {
        List dialects = (List)cascadings.map((Function1 & Serializable & scala.Serializable)x$15 -> JDBCSuite.genDialect$1(x$15), List$.MODULE$.canBuildFrom());
        AggregatedDialect agg = new AggregatedDialect(dialects);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(agg.isCascadingTruncateTable());
        Option $org_scalatest_assert_macro_right = expected;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 885));
    }

    private static final String getJdbcType$1(JdbcDialect dialect, DataType dt) {
        return (String)dialect.getJDBCType(dt).orElse((Function0 & Serializable & scala.Serializable)() -> JdbcUtils$.MODULE$.getCommonJDBCType(dt)).map((Function1 & Serializable & scala.Serializable)x$34 -> x$34.databaseTypeDefinition()).get();
    }

    private static final void testJdbcOptions$1(JDBCOptions options) {
        String $org_scalatest_assert_macro_left = options.tableOrQuery();
        String $org_scalatest_assert_macro_right = "t1";
        String string = $org_scalatest_assert_macro_left;
        String string2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1482));
        Properties $org_scalatest_assert_macro_left2 = options.asProperties();
        int $org_scalatest_assert_macro_right2 = 3;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1484));
        Object $org_scalatest_assert_macro_left3 = options.asProperties().get("customkey");
        Object $org_scalatest_assert_macro_right3 = null;
        Object object = $org_scalatest_assert_macro_left3;
        Object var11_10 = null;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left3, "==", null, !(object != null ? !object.equals(var11_10) : var11_10 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1485));
        Object $org_scalatest_assert_macro_left4 = options.asProperties().get("customKey");
        String $org_scalatest_assert_macro_right4 = "a-value";
        Object object2 = $org_scalatest_assert_macro_left4;
        String string3 = $org_scalatest_assert_macro_right4;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(object2 != null ? !object2.equals(string3) : string3 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1486));
        Properties $org_scalatest_assert_macro_left5 = options.asConnectionProperties();
        int $org_scalatest_assert_macro_right5 = 1;
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1487));
        Object $org_scalatest_assert_macro_left6 = options.asConnectionProperties().get("customkey");
        Object $org_scalatest_assert_macro_right6 = null;
        Object object3 = $org_scalatest_assert_macro_left6;
        Object var22_21 = null;
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left6, "==", null, !(object3 != null ? !object3.equals(var22_21) : var22_21 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1488));
        Object $org_scalatest_assert_macro_left7 = options.asConnectionProperties().get("customKey");
        String $org_scalatest_assert_macro_right7 = "a-value";
        Object object4 = $org_scalatest_assert_macro_left7;
        String string4 = $org_scalatest_assert_macro_right7;
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right7, !(object4 != null ? !object4.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1489));
    }

    public static final /* synthetic */ String $anonfun$new$165(int i) {
        return new StringBuilder(11).append("t").append(i).append(".NAME AS c").append(i).toString();
    }

    public static final /* synthetic */ String $anonfun$new$166(int i) {
        return new StringBuilder(18).append("join test.people t").append(i).toString();
    }

    private final void testJdbcPartitionColumn$1(String partColName, String expectedColumnName) {
        LogicalRelation logicalRelation;
        BaseRelation baseRelation;
        Dataset df = this.spark().read().format("jdbc").option("url", this.urlWithUserAndPass()).option("dbtable", "TEST.PARTITION").option("partitionColumn", partColName).option("lowerBound", 1L).option("upperBound", 4L).option("numPartitions", 3L).load();
        String quotedPrtColName = this.testH2Dialect().quoteIdentifier(expectedColumnName);
        LogicalPlan logicalPlan = df.logicalPlan();
        if (logicalPlan instanceof LogicalRelation && (baseRelation = (logicalRelation = (LogicalRelation)logicalPlan).relation()) instanceof JDBCRelation) {
            JDBCRelation jDBCRelation = (JDBCRelation)baseRelation;
            Partition[] parts = jDBCRelation.parts();
            Set whereClauses = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parts)).map((Function1 & Serializable & scala.Serializable)x$38 -> ((JDBCPartition)x$38).whereClause(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSet();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(whereClauses);
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(16).append(quotedPrtColName).append(" < 2 or ").append(quotedPrtColName).append(" is null").toString(), new StringBuilder(14).append(quotedPrtColName).append(" >= 2 AND ").append(quotedPrtColName).append(" < 3").toString(), new StringBuilder(5).append(quotedPrtColName).append(" >= 3").toString()}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1613));
            return;
        }
        throw new MatchError((Object)logicalPlan);
    }

    private final void testIncorrectJdbcPartitionColumn$1(String partColName) {
        String errMsg;
        String $org_scalatest_assert_macro_left = errMsg = ((AnalysisException)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testJdbcPartitionColumn$1(partColName, "THEID"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1628)))).getMessage();
        String $org_scalatest_assert_macro_right = new StringBuilder(62).append("User-defined partition column ").append(partColName).append(" not found ").append("in the JDBC relation:").toString();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1631));
    }

    private final long getRowCount$1(Dataset df) {
        QueryExecution queryExecution = df.queryExecution();
        Seq seq = queryExecution.executedPlan().collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof DataSourceScanExec) {
                    DataSourceScanExec dataSourceScanExec = (DataSourceScanExec)A1;
                    return (B1)dataSourceScanExec;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(SparkPlan x1) {
                SparkPlan sparkPlan2 = x1;
                return sparkPlan2 instanceof DataSourceScanExec;
            }
        });
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(1) != 0) {
            throw this.fail(new StringBuilder(32).append("More than one PhysicalRDD found\n").append(queryExecution).toString(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1848));
        }
        DataSourceScanExec p = (DataSourceScanExec)((SeqLike)some.get()).apply(0);
        DataSourceScanExec rawPlan = p;
        return ((SparkPlan)rawPlan).execute().count();
    }

    public static final /* synthetic */ void $anonfun$new$213(JDBCSuite $this, DataFrameReader readDf$1, DatetimeType tsType$1) {
        Dataset res2 = readDf$1.load();
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> res2, (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null})), (List)Nil$.MODULE$)));
        DataType $org_scalatest_assert_macro_left = ((StructField)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])res2.schema().fields())).head()).dataType();
        DatetimeType $org_scalatest_assert_macro_right = tsType$1;
        DataType dataType = $org_scalatest_assert_macro_left;
        DatetimeType datetimeType = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(dataType != null ? !dataType.equals(datetimeType) : datetimeType != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2019));
    }

    public static final /* synthetic */ void $anonfun$new$211(JDBCSuite $this, DataFrameReader readDf$1, String timestampType) {
        String string = timestampType;
        String string2 = SQLConf.TimestampTypes$.MODULE$.TIMESTAMP_NTZ().toString();
        boolean inferTimestampNTZ = !(string != null ? !string.equals(string2) : string2 != null);
        TimestampNTZType$ tsType = inferTimestampNTZ ? TimestampNTZType$.MODULE$ : TimestampType$.MODULE$;
        Dataset res = readDf$1.option("preferTimestampNTZ", inferTimestampNTZ).load();
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> res, (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null})), (List)Nil$.MODULE$)));
        DataType $org_scalatest_assert_macro_left = ((StructField)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])res.schema().fields())).head()).dataType();
        TimestampNTZType$ $org_scalatest_assert_macro_right = tsType;
        DataType dataType = $org_scalatest_assert_macro_left;
        TimestampNTZType$ timestampNTZType$ = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(dataType != null ? !dataType.equals(timestampNTZType$) : timestampNTZType$ != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2015));
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.TIMESTAMP_TYPE().key()), (Object)timestampType)}), (Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> JDBCSuite.$anonfun$new$213($this, readDf$1, (DatetimeType)tsType)));
    }

    public static final /* synthetic */ void $anonfun$new$218(JDBCSuite $this, String tableName$4, String x0$4) {
        String string = x0$4;
        Dataset df = $this.spark().sql(new StringBuilder(23).append("select timestamp_ntz '").append(string).append("'").toString());
        df.write().format("jdbc").mode("overwrite").option("url", $this.urlWithUserAndPass()).option("dbtable", tableName$4).save();
        ZoneId zoneId = (ZoneId)DateTimeTestUtils$.MODULE$.outstandingZoneIds().apply(Random$.MODULE$.nextInt(DateTimeTestUtils$.MODULE$.outstandingZoneIds().length()));
        BoxedUnit cfr_ignored_0 = (BoxedUnit)DateTimeTestUtils$.MODULE$.withDefaultTimeZone(zoneId, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Dataset res = $this.spark().read().format("jdbc").option("preferTimestampNTZ", "true").option("url", $this.urlWithUserAndPass()).option("dbtable", tableName$4).load();
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> res, (Dataset<Row>)df);
            $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.TIMESTAMP_TYPE().key()), (Object)SQLConf.TimestampTypes$.MODULE$.TIMESTAMP_NTZ().toString())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Dataset res2 = $this.spark().read().format("jdbc").option("url", $this.urlWithUserAndPass()).option("dbtable", tableName$4).load();
                $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> res2, (Dataset<Row>)df);
            });
        });
    }

    public JDBCSuite() {
        ScaledTimeSpans.$init$((ScaledTimeSpans)this);
        AbstractPatienceConfiguration.$init$((AbstractPatienceConfiguration)this);
        PatienceConfiguration.$init$((PatienceConfiguration)this);
        Eventually.$init$((Eventually)this);
        SQLTestData.$init$(this);
        SQLTestUtilsBase.$init$(this);
        SQLTestUtils.$init$(this);
        SharedSparkSessionBase.$init$(this);
        SharedSparkSession.$init$(this);
        this.url = "jdbc:h2:mem:testdb0";
        this.urlWithUserAndPass = "jdbc:h2:mem:testdb0;user=testUser;password=testPass";
        this.conn = null;
        this.testBytes = (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{(byte)99, (byte)134, (byte)135, (byte)200, (byte)205}), ClassTag$.MODULE$.Byte()))).$plus$plus((GenTraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])Array$.MODULE$.fill(15, (Function0)(JFunction0.mcB.sp & Serializable & scala.Serializable)() -> (byte)0, ClassTag$.MODULE$.Byte()))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()));
        this.testH2Dialect = new JdbcDialect(null){

            public boolean canHandle(String url) {
                return url.startsWith("jdbc:h2");
            }

            public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
                return new Some((Object)StringType$.MODULE$);
            }
        };
        this.testH2DialectTinyInt = new JdbcDialect(null){

            public boolean canHandle(String url) {
                return url.startsWith("jdbc:h2");
            }

            public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
                int n = sqlType;
                switch (n) {
                    case -6: {
                        return new Some((Object)ByteType$.MODULE$);
                    }
                }
                return None$.MODULE$;
            }
        };
        this.test("SELECT *", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((Dataset)this.sql().apply((Object)"SELECT * FROM foobar")).collect())).size()));
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 342));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 341));
        this.test("SELECT * WHERE (simple predicates)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Object[] $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])this.checkPushdown((Dataset<Row>)((Dataset)this.sql().apply((Object)"SELECT * FROM foobar WHERE THEID < 1"))).collect());
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left), "size", (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef($org_scalatest_assert_macro_left).size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 346));
            Object[] $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])this.checkPushdown((Dataset<Row>)((Dataset)this.sql().apply((Object)"SELECT * FROM foobar WHERE THEID != 2"))).collect());
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left2), "size", (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef($org_scalatest_assert_macro_left2).size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 347));
            Object[] $org_scalatest_assert_macro_left3 = Predef$.MODULE$.refArrayOps((Object[])this.checkPushdown((Dataset<Row>)((Dataset)this.sql().apply((Object)"SELECT * FROM foobar WHERE THEID = 1"))).collect());
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left3), "size", (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef($org_scalatest_assert_macro_left3).size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 348));
            Object[] $org_scalatest_assert_macro_left4 = Predef$.MODULE$.refArrayOps((Object[])this.checkPushdown((Dataset<Row>)((Dataset)this.sql().apply((Object)"SELECT * FROM foobar WHERE NAME = 'fred'"))).collect());
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left4), "size", (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef($org_scalatest_assert_macro_left4).size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 349));
            Object[] $org_scalatest_assert_macro_left5 = Predef$.MODULE$.refArrayOps((Object[])this.checkPushdown((Dataset<Row>)((Dataset)this.sql().apply((Object)"SELECT * FROM foobar WHERE NAME <=> 'fred'"))).collect());
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left5), "size", (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef($org_scalatest_assert_macro_left5).size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 350));
            Object[] $org_scalatest_assert_macro_left6 = Predef$.MODULE$.refArrayOps((Object[])this.checkPushdown((Dataset<Row>)((Dataset)this.sql().apply((Object)"SELECT * FROM foobar WHERE NAME > 'fred'"))).collect());
            int $org_scalatest_assert_macro_right6 = 2;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left6), "size", (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef($org_scalatest_assert_macro_left6).size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 351));
            Object[] $org_scalatest_assert_macro_left7 = Predef$.MODULE$.refArrayOps((Object[])this.checkPushdown((Dataset<Row>)((Dataset)this.sql().apply((Object)"SELECT * FROM foobar WHERE NAME != 'fred'"))).collect());
            int $org_scalatest_assert_macro_right7 = 2;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.lengthSizeMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left7), "size", (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef($org_scalatest_assert_macro_left7).size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 352));
            Object[] $org_scalatest_assert_macro_left8 = Predef$.MODULE$.refArrayOps((Object[])this.checkPushdown((Dataset<Row>)((Dataset)this.sql().apply((Object)"SELECT * FROM foobar WHERE NAME IN ('mary', 'fred')"))).collect());
            int $org_scalatest_assert_macro_right8 = 2;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.lengthSizeMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left8), "size", (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef($org_scalatest_assert_macro_left8).size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 354));
            Object[] $org_scalatest_assert_macro_left9 = Predef$.MODULE$.refArrayOps((Object[])this.checkPushdown((Dataset<Row>)((Dataset)this.sql().apply((Object)"SELECT * FROM foobar WHERE NAME NOT IN ('fred')"))).collect());
            int $org_scalatest_assert_macro_right9 = 2;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.lengthSizeMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left9), "size", (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef($org_scalatest_assert_macro_left9).size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 356));
            Object[] $org_scalatest_assert_macro_left10 = Predef$.MODULE$.refArrayOps((Object[])this.checkPushdown((Dataset<Row>)((Dataset)this.sql().apply((Object)"SELECT * FROM foobar WHERE THEID = 1 OR NAME = 'mary'"))).collect());
            int $org_scalatest_assert_macro_right10 = 2;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.lengthSizeMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left10), "size", (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef($org_scalatest_assert_macro_left10).size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 358));
            Object[] $org_scalatest_assert_macro_left11 = Predef$.MODULE$.refArrayOps((Object[])this.checkPushdown((Dataset<Row>)((Dataset)this.sql().apply((Object)"SELECT * FROM foobar WHERE THEID = 1 OR NAME = 'mary' AND THEID = 2"))).collect());
            int $org_scalatest_assert_macro_right11 = 2;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.lengthSizeMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left11), "size", (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef($org_scalatest_assert_macro_left11).size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 360));
            Object[] $org_scalatest_assert_macro_left12 = Predef$.MODULE$.refArrayOps((Object[])this.checkPushdown((Dataset<Row>)((Dataset)this.sql().apply((Object)"SELECT * FROM foobar WHERE NAME LIKE 'fr%'"))).collect());
            int $org_scalatest_assert_macro_right12 = 1;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.lengthSizeMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left12), "size", (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef($org_scalatest_assert_macro_left12).size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right12), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 362));
            Object[] $org_scalatest_assert_macro_left13 = Predef$.MODULE$.refArrayOps((Object[])this.checkPushdown((Dataset<Row>)((Dataset)this.sql().apply((Object)"SELECT * FROM foobar WHERE NAME LIKE '%ed'"))).collect());
            int $org_scalatest_assert_macro_right13 = 1;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.lengthSizeMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left13), "size", (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef($org_scalatest_assert_macro_left13).size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right13), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 363));
            Object[] $org_scalatest_assert_macro_left14 = Predef$.MODULE$.refArrayOps((Object[])this.checkPushdown((Dataset<Row>)((Dataset)this.sql().apply((Object)"SELECT * FROM foobar WHERE NAME LIKE '%re%'"))).collect());
            int $org_scalatest_assert_macro_right14 = 1;
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.lengthSizeMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left14), "size", (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef($org_scalatest_assert_macro_left14).size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right14), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 364));
            Object[] $org_scalatest_assert_macro_left15 = Predef$.MODULE$.refArrayOps((Object[])this.checkPushdown((Dataset<Row>)((Dataset)this.sql().apply((Object)"SELECT * FROM nulltypes WHERE A IS NULL"))).collect());
            int $org_scalatest_assert_macro_right15 = 1;
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.lengthSizeMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left15), "size", (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef($org_scalatest_assert_macro_left15).size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right15), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 365));
            Object[] $org_scalatest_assert_macro_left16 = Predef$.MODULE$.refArrayOps((Object[])this.checkPushdown((Dataset<Row>)((Dataset)this.sql().apply((Object)"SELECT * FROM nulltypes WHERE A IS NOT NULL"))).collect());
            int $org_scalatest_assert_macro_right16 = 0;
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.lengthSizeMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left16), "size", (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef($org_scalatest_assert_macro_left16).size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right16), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 366));
            Dataset df1 = (Dataset)this.sql().apply((Object)"SELECT * FROM foobar WHERE NOT (THEID != 2) OR NOT (NAME != 'mary')");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left17 = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df1.collect())).toSet());
            Set $org_scalatest_assert_macro_right17 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"mary", BoxesRunTime.boxToInteger((int)2)}))}));
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left17, "===", (Object)$org_scalatest_assert_macro_right17, $org_scalatest_assert_macro_left17.$eq$eq$eq((Object)$org_scalatest_assert_macro_right17, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 371));
            Dataset df2 = (Dataset)this.sql().apply((Object)"SELECT * FROM foobar WHERE (THEID > 0 AND TRIM(NAME) = 'mary') OR (NAME = 'fred')");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left18 = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df2.collect())).toSet());
            Set $org_scalatest_assert_macro_right18 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"fred", BoxesRunTime.boxToInteger((int)1)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"mary", BoxesRunTime.boxToInteger((int)2)}))}));
            Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left18, "===", (Object)$org_scalatest_assert_macro_right18, $org_scalatest_assert_macro_left18.$eq$eq$eq((Object)$org_scalatest_assert_macro_right18, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 376));
            Object[] $org_scalatest_assert_macro_left19 = Predef$.MODULE$.refArrayOps((Object[])this.checkNotPushdown((Dataset<Row>)((Dataset)this.sql().apply((Object)"SELECT * FROM foobar WHERE (THEID + 1) < 2"))).collect());
            int $org_scalatest_assert_macro_right19 = 0;
            Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.lengthSizeMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left19), "size", (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef($org_scalatest_assert_macro_left19).size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right19), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 378));
            Object[] $org_scalatest_assert_macro_left20 = Predef$.MODULE$.refArrayOps((Object[])this.checkNotPushdown((Dataset<Row>)((Dataset)this.sql().apply((Object)"SELECT * FROM foobar WHERE (THEID + 2) != 4"))).collect());
            int $org_scalatest_assert_macro_right20 = 2;
            Bool $org_scalatest_assert_macro_expr20 = Bool$.MODULE$.lengthSizeMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left20), "size", (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef($org_scalatest_assert_macro_left20).size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right20), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr20, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 379));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 345));
        this.test("SELECT COUNT(1) WHERE (predicates)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((Dataset)this.sql().apply((Object)"SELECT COUNT(1) FROM foobar WHERE NAME = 'mary'")).collect())).toSet());
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}))}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 389));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 382));
        this.test("SELECT * WHERE (quoted strings)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((Dataset)this.sql().apply((Object)"select * from foobar")).where(this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"NAME"}))).$((Seq)Nil$.MODULE$).$eq$eq$eq((Object)"joe 'foo' \"bar\"")).collect())).size()));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 393));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 392));
        this.test("SELECT first field", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String[] names = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((Dataset)this.sql().apply((Object)"SELECT NAME FROM foobar")).collect())).map((Function1 & Serializable & scala.Serializable)x -> x.getString(0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).sortWith((Function2 & Serializable & scala.Serializable)(x$1, x$2) -> BoxesRunTime.boxToBoolean((boolean)JDBCSuite.$anonfun$new$7(x$1, x$2)));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])names)).size()));
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 398));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(names[0].equals("fred"), "names.apply(0).equals(\"fred\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 399));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(names[1].equals("joe 'foo' \"bar\""), "names.apply(1).equals(\"joe \\'foo\\' \\\"bar\\\"\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 400));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(names[2].equals("mary"), "names.apply(2).equals(\"mary\")", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 401));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 396));
        this.test("SELECT first field when fetchsize is two", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String[] names = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((Dataset)this.sql().apply((Object)"SELECT NAME FROM fetchtwo")).collect())).map((Function1 & Serializable & scala.Serializable)x -> x.getString(0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).sortWith((Function2 & Serializable & scala.Serializable)(x$3, x$4) -> BoxesRunTime.boxToBoolean((boolean)JDBCSuite.$anonfun$new$10(x$3, x$4)));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])names)).size()));
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 406));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(names[0].equals("fred"), "names.apply(0).equals(\"fred\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 407));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(names[1].equals("joe 'foo' \"bar\""), "names.apply(1).equals(\"joe \\'foo\\' \\\"bar\\\"\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 408));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(names[2].equals("mary"), "names.apply(2).equals(\"mary\")", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 409));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 404));
        this.test("SELECT second field", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            int[] ids = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((Dataset)this.sql().apply((Object)"SELECT THEID FROM foobar")).collect())).map((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToInteger((int)x.getInt(0)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).sortWith((Function2)(JFunction2.mcZII.sp & Serializable & scala.Serializable)(x$5, x$6) -> x$5 < x$6);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(ids)).size()));
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 414));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)ids[0]));
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 415));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)ids[1]));
            int $org_scalatest_assert_macro_right3 = 2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 416));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)ids[2]));
            int $org_scalatest_assert_macro_right4 = 3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 417));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 412));
        this.test("SELECT second field when fetchsize is two", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            int[] ids = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((Dataset)this.sql().apply((Object)"SELECT THEID FROM fetchtwo")).collect())).map((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToInteger((int)x.getInt(0)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).sortWith((Function2)(JFunction2.mcZII.sp & Serializable & scala.Serializable)(x$7, x$8) -> x$7 < x$8);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(ids)).size()));
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 422));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)ids[0]));
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 423));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)ids[1]));
            int $org_scalatest_assert_macro_right3 = 2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 424));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)ids[2]));
            int $org_scalatest_assert_macro_right4 = 3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 425));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 420));
        this.test("SELECT * partitioned", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Dataset df = (Dataset)this.sql().apply((Object)"SELECT * FROM parts");
            this.checkNumPartitions((Dataset<Row>)df, 3);
            Row[] $org_scalatest_assert_macro_left = (Row[])df.collect();
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 431));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 428));
        this.test("SELECT WHERE (simple predicates) partitioned", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Dataset df1 = (Dataset)this.sql().apply((Object)"SELECT * FROM parts WHERE THEID < 1");
            this.checkNumPartitions((Dataset<Row>)df1, 3);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((Row[])df1.collect()).length));
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 437));
            Dataset df2 = (Dataset)this.sql().apply((Object)"SELECT * FROM parts WHERE THEID != 2");
            this.checkNumPartitions((Dataset<Row>)df2, 3);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((Row[])df2.collect()).length));
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 441));
            Dataset df3 = (Dataset)this.sql().apply((Object)"SELECT THEID FROM parts WHERE THEID = 1");
            this.checkNumPartitions((Dataset<Row>)df3, 3);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((Row[])df3.collect()).length));
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 445));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 434));
        this.test("SELECT second field partitioned", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            int[] ids = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((Dataset)this.sql().apply((Object)"SELECT THEID FROM parts")).collect())).map((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToInteger((int)x.getInt(0)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).sortWith((Function2)(JFunction2.mcZII.sp & Serializable & scala.Serializable)(x$9, x$10) -> x$9 < x$10);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(ids)).size()));
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 450));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)ids[0]));
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 451));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)ids[1]));
            int $org_scalatest_assert_macro_right3 = 2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 452));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)ids[2]));
            int $org_scalatest_assert_macro_right4 = 3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 453));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 448));
        this.test("SPARK-34843: columnPartition should generate the correct stride size and also realign the first partition for better distribution", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            StructType schema = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("PartitionColumn", (DataType)DateType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
            int numPartitions = 1000;
            scala.collection.immutable.Map partitionConfig = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lowerBound"), (Object)"1930-01-01"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"upperBound"), (Object)"2020-12-31"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numPartitions"), (Object)Integer.toString(numPartitions)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partitionColumn"), (Object)"PartitionColumn")}));
            Partition[] partitions = JDBCRelation$.MODULE$.columnPartition(schema, org.apache.spark.sql.catalyst.analysis.package$.MODULE$.caseInsensitiveResolution(), TimeZone.getDefault().toZoneId().toString(), new JDBCOptions(this.url(), "table", partitionConfig));
            String firstPredicate = ((JDBCPartition)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitions)).head()).whereClause();
            String lastPredicate = ((JDBCPartition)partitions[numPartitions - 1]).whereClause();
            String $org_scalatest_assert_macro_left = firstPredicate;
            String $org_scalatest_assert_macro_right = "\"PartitionColumn\" < '1930-06-02' or \"PartitionColumn\" is null";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 481));
            String $org_scalatest_assert_macro_left2 = lastPredicate;
            String $org_scalatest_assert_macro_right2 = "\"PartitionColumn\" >= '2020-08-02'";
            String string3 = $org_scalatest_assert_macro_left2;
            String string4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 483));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 457));
        this.test("overflow of partition bound difference does not give negative stride", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Dataset df = (Dataset)this.sql().apply((Object)"SELECT * FROM partsoverflow");
            this.checkNumPartitions((Dataset<Row>)df, 3);
            Row[] $org_scalatest_assert_macro_left = (Row[])df.collect();
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 489));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 486));
        this.test("Register JDBC query with renamed fields", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(238).append("\n        |CREATE OR REPLACE TEMPORARY VIEW renamed\n        |USING org.apache.spark.sql.jdbc\n        |OPTIONS (url '").append(this.url()).append("', dbtable '(select NAME as NAME1, NAME as NAME2 from TEST.PEOPLE)',\n        |user 'testUser', password 'testPass')\n       ").toString())).stripMargin().replaceAll("\n", " "));
            Dataset df = (Dataset)this.sql().apply((Object)"SELECT * FROM renamed");
            Object[] $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])df.schema().fields());
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left), "size", (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef($org_scalatest_assert_macro_left).size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 503));
            String $org_scalatest_assert_macro_left2 = df.schema().fields()[0].name();
            String $org_scalatest_assert_macro_right2 = "NAME1";
            String string = $org_scalatest_assert_macro_left2;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 504));
            String $org_scalatest_assert_macro_left3 = df.schema().fields()[1].name();
            String $org_scalatest_assert_macro_right3 = "NAME2";
            String string3 = $org_scalatest_assert_macro_left3;
            String string4 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 505));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 492));
        this.test("Basic API", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((Row[])this.spark().read().jdbc(this.urlWithUserAndPass(), "TEST.PEOPLE", new Properties()).collect()).length));
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 509));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 508));
        this.test("Missing partition columns", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tempPeople"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String e;
            String $org_scalatest_assert_macro_left = e = ((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("\n             |CREATE OR REPLACE TEMPORARY VIEW tempPeople\n             |USING org.apache.spark.sql.jdbc\n             |OPTIONS (\n             |  url 'jdbc:h2:mem:testdb0;user=testUser;password=testPass',\n             |  dbtable 'TEST.PEOPLE',\n             |  lowerBound '0',\n             |  upperBound '52',\n             |  numPartitions '53',\n             |  fetchSize '10000' )\n           ")).stripMargin().replaceAll("\n", " ")), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 515))).getMessage();
            String $org_scalatest_assert_macro_right = "When reading JDBC data sources, users need to specify all or none for the following options: 'partitionColumn', 'lowerBound', 'upperBound', and 'numPartitions'";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 529));
        }), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 513));
        this.test("Basic API with FetchSize", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4).foreach((Function1 & Serializable & scala.Serializable)size -> JDBCSuite.$anonfun$new$30(this, BoxesRunTime.unboxToInt((Object)size))), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 535));
        this.test("Partitioning via JDBCPartitioningInfo API", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Dataset df = this.spark().read().jdbc(this.urlWithUserAndPass(), "TEST.PEOPLE", "THEID", 0L, 4L, 3, new Properties());
            this.checkNumPartitions((Dataset<Row>)df, 3);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((Row[])df.collect()).length));
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 547));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 544));
        this.test("Partitioning via list-of-where-clauses API", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String[] parts = (String[])((Object[])new String[]{"THEID < 2", "THEID >= 2"});
            Dataset df = this.spark().read().jdbc(this.urlWithUserAndPass(), "TEST.PEOPLE", parts, new Properties());
            this.checkNumPartitions((Dataset<Row>)df, 2);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((Row[])df.collect()).length));
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 554));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 550));
        this.test("Partitioning on column that might have null values.", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Dataset df = this.spark().read().jdbc(this.urlWithUserAndPass(), "TEST.EMP", "theid", 0L, 4L, 3, new Properties());
            this.checkNumPartitions((Dataset<Row>)df, 3);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((Row[])df.collect()).length));
            int $org_scalatest_assert_macro_right = 4;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 560));
            Dataset df2 = this.spark().read().jdbc(this.urlWithUserAndPass(), "TEST.EMP", "THEID", 0L, 4L, 3, new Properties());
            this.checkNumPartitions((Dataset<Row>)df2, 3);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((Row[])df2.collect()).length));
            int $org_scalatest_assert_macro_right2 = 4;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 564));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((Row[])this.spark().read().jdbc(this.urlWithUserAndPass(), "TEST.EMP", "\"Dept\"", 0L, 4L, 3, new Properties()).collect()).length));
            int $org_scalatest_assert_macro_right3 = 4;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 567));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 557));
        this.test("Partitioning on column where numPartitions is zero", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Dataset res = this.spark().read().jdbc(this.urlWithUserAndPass(), "TEST.seq", "id", 0L, 4L, 0, new Properties());
            this.checkNumPartitions((Dataset<Row>)res, 1);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)res.count()));
            int $org_scalatest_assert_macro_right = 8;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 583));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 572));
        this.test("Partitioning on column where numPartitions are more than the number of total rows", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Dataset res = this.spark().read().jdbc(this.urlWithUserAndPass(), "TEST.seq", "id", 1L, 5L, 10, new Properties());
            this.checkNumPartitions((Dataset<Row>)res, 4);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)res.count()));
            int $org_scalatest_assert_macro_right = 8;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 597));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 586));
        this.test("Partitioning on column where lowerBound is equal to upperBound", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Dataset res = this.spark().read().jdbc(this.urlWithUserAndPass(), "TEST.seq", "id", 5L, 5L, 4, new Properties());
            this.checkNumPartitions((Dataset<Row>)res, 1);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)res.count()));
            int $org_scalatest_assert_macro_right = 8;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 611));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 600));
        this.test("Partitioning on column where lowerBound is larger than upperBound", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String e;
            String $org_scalatest_assert_macro_left = e = ((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.spark().read().jdbc(this.urlWithUserAndPass(), "TEST.seq", "id", 5L, 1L, 3, new Properties()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 615))).getMessage();
            String $org_scalatest_assert_macro_right = "Operation not allowed: the lower bound of partitioning column is larger than the upper bound. Lower bound: 5; Upper bound: 1";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 626));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 614));
        this.test("SELECT * on partitioned table with a nullable partition column", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Dataset df = (Dataset)this.sql().apply((Object)"SELECT * FROM nullparts");
            this.checkNumPartitions((Dataset<Row>)df, 3);
            Row[] $org_scalatest_assert_macro_left = (Row[])df.collect();
            int $org_scalatest_assert_macro_right = 4;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 633));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 630));
        this.test("H2 integral types", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Row[] rows = (Row[])((Dataset)this.sql().apply((Object)"SELECT * FROM inttypes WHERE A IS NOT NULL")).collect();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)rows.length));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 638));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)rows[0].getInt(0)));
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 639));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)rows[0].getBoolean(1)));
            boolean $org_scalatest_assert_macro_right3 = false;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 640));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)rows[0].getInt(2)));
            int $org_scalatest_assert_macro_right4 = 3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 641));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)rows[0].getInt(3)));
            int $org_scalatest_assert_macro_right5 = 4;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 642));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)rows[0].getLong(4)));
            long $org_scalatest_assert_macro_right6 = 1234567890123L;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 643));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 636));
        this.test("H2 null entries", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Row[] rows = (Row[])((Dataset)this.sql().apply((Object)"SELECT * FROM inttypes WHERE A IS NULL")).collect();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)rows.length));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 648));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(rows[0].isNullAt(0), "rows.apply(0).isNullAt(0)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 649));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(rows[0].isNullAt(1), "rows.apply(0).isNullAt(1)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 650));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(rows[0].isNullAt(2), "rows.apply(0).isNullAt(2)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 651));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(rows[0].isNullAt(3), "rows.apply(0).isNullAt(3)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 652));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(rows[0].isNullAt(4), "rows.apply(0).isNullAt(4)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 653));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 646));
        this.test("H2 string types", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Row[] rows = (Row[])((Dataset)this.sql().apply((Object)"SELECT * FROM strtypes")).collect();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])rows[0].getAs(0))).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(this.testBytes())), "scala.Predef.byteArrayOps(rows.apply(0).getAs[Array[Byte]](0)).sameElements[Byte](scala.Predef.wrapByteArray(JDBCSuite.this.testBytes))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 658));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(rows[0].getString(1).equals("Sensitive"), "rows.apply(0).getString(1).equals(\"Sensitive\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 659));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(rows[0].getString(2).equals("Insensitive"), "rows.apply(0).getString(2).equals(\"Insensitive\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 660));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(rows[0].getString(3).equals("Twenty-byte CHAR    "), "rows.apply(0).getString(3).equals(\"Twenty-byte CHAR    \")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 661));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])rows[0].getAs(4))).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(this.testBytes())), "scala.Predef.byteArrayOps(rows.apply(0).getAs[Array[Byte]](4)).sameElements[Byte](scala.Predef.wrapByteArray(JDBCSuite.this.testBytes))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 662));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(rows[0].getString(5).equals("I am a clob!"), "rows.apply(0).getString(5).equals(\"I am a clob!\")", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 663));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 656));
        this.test("H2 time types", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Row[] rows = (Row[])((Dataset)this.sql().apply((Object)"SELECT * FROM timetypes")).collect();
            GregorianCalendar cal = new GregorianCalendar(Locale.ROOT);
            cal.setTime((Date)rows[0].getAs(0));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)cal.get(11)));
            int $org_scalatest_assert_macro_right = 12;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 670));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)cal.get(12)));
            int $org_scalatest_assert_macro_right2 = 34;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 671));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)cal.get(13)));
            int $org_scalatest_assert_macro_right3 = 56;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 672));
            cal.setTime((Date)rows[0].getAs(1));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)cal.get(1)));
            int $org_scalatest_assert_macro_right4 = 1996;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 674));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)cal.get(2)));
            int $org_scalatest_assert_macro_right5 = 0;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 675));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)cal.get(5)));
            int $org_scalatest_assert_macro_right6 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 676));
            cal.setTime((Date)rows[0].getAs(2));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)cal.get(1)));
            int $org_scalatest_assert_macro_right7 = 2002;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 678));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)cal.get(2)));
            int $org_scalatest_assert_macro_right8 = 1;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 679));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)cal.get(5)));
            int $org_scalatest_assert_macro_right9 = 20;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 680));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)cal.get(10)));
            int $org_scalatest_assert_macro_right10 = 11;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 681));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)cal.get(12)));
            int $org_scalatest_assert_macro_right11 = 22;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 682));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)cal.get(13)));
            int $org_scalatest_assert_macro_right12 = 33;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right12), $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right12), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 683));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left13 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)cal.get(14)));
            int $org_scalatest_assert_macro_right13 = 543;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right13), $org_scalatest_assert_macro_left13.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right13), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 684));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left14 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((Timestamp)rows[0].getAs(2)).getNanos()));
            int $org_scalatest_assert_macro_right14 = 543543000;
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right14), $org_scalatest_assert_macro_left14.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right14), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 685));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 666));
        this.test("SPARK-34357: test TIME types", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Row[] rows = (Row[])this.spark().read().jdbc(this.urlWithUserAndPass(), "TEST.TIMETYPES", new Properties()).collect();
            Row[] cachedRows = (Row[])this.spark().read().jdbc(this.urlWithUserAndPass(), "TEST.TIMETYPES", new Properties()).cache().collect();
            Timestamp expectedTimeAtEpoch = Timestamp.valueOf("1970-01-01 12:34:56.0");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(rows[0].getAs(0));
            Timestamp $org_scalatest_assert_macro_right = expectedTimeAtEpoch;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 694));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(rows[1].getAs(0));
            Timestamp $org_scalatest_assert_macro_right2 = expectedTimeAtEpoch;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 695));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(cachedRows[0].getAs(0));
            Timestamp $org_scalatest_assert_macro_right3 = expectedTimeAtEpoch;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 696));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 688));
        this.test("test DATE types", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Row[] rows = (Row[])this.spark().read().jdbc(this.urlWithUserAndPass(), "TEST.TIMETYPES", new Properties()).collect();
            Row[] cachedRows = (Row[])this.spark().read().jdbc(this.urlWithUserAndPass(), "TEST.TIMETYPES", new Properties()).cache().collect();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(rows[0].getAs(1));
            java.sql.Date $org_scalatest_assert_macro_right = java.sql.Date.valueOf("1996-01-01");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 704));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(rows[1].getAs(1));
            Null$ $org_scalatest_assert_macro_right2 = null;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", null, $org_scalatest_assert_macro_left2.$eq$eq$eq($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 705));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(cachedRows[0].getAs(1));
            java.sql.Date $org_scalatest_assert_macro_right3 = java.sql.Date.valueOf("1996-01-01");
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 706));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 699));
        this.test("test DATE types in cache", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mycached_date"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Row[] rows = (Row[])this.spark().read().jdbc(this.urlWithUserAndPass(), "TEST.TIMETYPES", new Properties()).collect();
            this.spark().read().jdbc(this.urlWithUserAndPass(), "TEST.TIMETYPES", new Properties()).cache().createOrReplaceTempView("mycached_date");
            Row[] cachedRows = (Row[])((Dataset)this.sql().apply((Object)"select * from mycached_date")).collect();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(rows[0].getAs(1));
            java.sql.Date $org_scalatest_assert_macro_right = java.sql.Date.valueOf("1996-01-01");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 715));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(cachedRows[0].getAs(1));
            java.sql.Date $org_scalatest_assert_macro_right2 = java.sql.Date.valueOf("1996-01-01");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 716));
        }), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 709));
        this.test("test types for null value", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Row[] rows = (Row[])this.spark().read().jdbc(this.urlWithUserAndPass(), "TEST.NULLTYPES", new Properties()).collect();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 14).forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> rows[0].isNullAt(i)), "scala.Predef.intWrapper(0).to(14).forall(((i: Int) => rows.apply(0).isNullAt(i)))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 723));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 720));
        this.test("H2 floating-point types", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Row[] rows = (Row[])((Dataset)this.sql().apply((Object)"SELECT * FROM flttypes")).collect();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)rows[0].getDouble(0)));
            double $org_scalatest_assert_macro_right = 1.0000000000000002;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 728));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)rows[0].getDouble(1)));
            double $org_scalatest_assert_macro_right2 = 1.0000001192092896;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 729));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(rows[0].getAs(2));
            BigDecimal $org_scalatest_assert_macro_right3 = new BigDecimal("123456789012345.543215432154321000");
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 730));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(rows[0].schema().fields()[2].dataType());
            DecimalType $org_scalatest_assert_macro_right4 = new DecimalType(38, 18);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 732));
            Row[] result = (Row[])((Dataset)this.sql().apply((Object)"SELECT C FROM flttypes where C > C - 1")).collect();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(result[0].getAs(0));
            BigDecimal $org_scalatest_assert_macro_right5 = new BigDecimal("123456789012345.543215432154321000");
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 734));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 726));
        this.test("SQL query as table name", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(224).append("\n        |CREATE OR REPLACE TEMPORARY VIEW hack\n        |USING org.apache.spark.sql.jdbc\n        |OPTIONS (url '").append(this.url()).append("', dbtable '(SELECT B, B*B FROM TEST.FLTTYPES)',\n        |         user 'testUser', password 'testPass')\n       ").toString())).stripMargin().replaceAll("\n", " "));
            Row[] rows = (Row[])((Dataset)this.sql().apply((Object)"SELECT * FROM hack")).collect();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)rows[0].getDouble(0)));
            double $org_scalatest_assert_macro_right = 1.0000001192092896;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 747));
            double $org_scalatest_assert_macro_left2 = package$.MODULE$.abs(rows[0].getDouble(1) - 1.0000002384185933);
            double $org_scalatest_assert_macro_right2 = 1.0E-12;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 < $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 749));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 738));
        this.test("Remap types via JdbcDialects", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            JdbcDialects$.MODULE$.registerDialect(this.testH2Dialect());
            Dataset df = this.spark().read().jdbc(this.urlWithUserAndPass(), "TEST.PEOPLE", new Properties());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(df.schema().exists((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)JDBCSuite.$anonfun$new$53(x$11))), "df.schema.exists(((x$11: org.apache.spark.sql.types.StructField) => x$11.dataType.!=(org.apache.spark.sql.types.StringType)))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 755));
            Row[] rows = (Row[])df.collect();
            Object $org_scalatest_assert_macro_left = rows[0].get(0);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool($org_scalatest_assert_macro_left, "isInstanceOf", "scala.Predef.String", $org_scalatest_assert_macro_left instanceof String, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 757));
            Object $org_scalatest_assert_macro_left2 = rows[0].get(1);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool($org_scalatest_assert_macro_left2, "isInstanceOf", "scala.Predef.String", $org_scalatest_assert_macro_left2 instanceof String, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 758));
            JdbcDialects$.MODULE$.unregisterDialect(this.testH2Dialect());
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 752));
        this.test("Map TINYINT to ByteType via JdbcDialects", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            JdbcDialects$.MODULE$.registerDialect(this.testH2DialectTinyInt());
            Dataset df = this.spark().read().jdbc(this.urlWithUserAndPass(), "test.inttypes", new Properties());
            Row[] rows = (Row[])df.collect();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)rows.length));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 766));
            Object $org_scalatest_assert_macro_left2 = rows[0].get(2);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool($org_scalatest_assert_macro_left2, "isInstanceOf", "scala.Byte", $org_scalatest_assert_macro_left2 instanceof Byte, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 767));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToByte((byte)rows[0].getByte(2)));
            int $org_scalatest_assert_macro_right2 = 3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 768));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(rows[1].isNullAt(2), "rows.apply(1).isNullAt(2)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 769));
            JdbcDialects$.MODULE$.unregisterDialect(this.testH2DialectTinyInt());
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 762));
        this.test("Default jdbc dialect registration", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            JdbcDialect $org_scalatest_assert_macro_left = JdbcDialects$.MODULE$.get("jdbc:mysql://127.0.0.1/db");
            MySQLDialect$ $org_scalatest_assert_macro_right = MySQLDialect$.MODULE$;
            JdbcDialect jdbcDialect = $org_scalatest_assert_macro_left;
            MySQLDialect$ mySQLDialect$ = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(jdbcDialect != null ? !jdbcDialect.equals(mySQLDialect$) : mySQLDialect$ != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 774));
            JdbcDialect $org_scalatest_assert_macro_left2 = JdbcDialects$.MODULE$.get("jdbc:postgresql://127.0.0.1/db");
            PostgresDialect$ $org_scalatest_assert_macro_right2 = PostgresDialect$.MODULE$;
            JdbcDialect jdbcDialect2 = $org_scalatest_assert_macro_left2;
            PostgresDialect$ postgresDialect$ = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(jdbcDialect2 != null ? !jdbcDialect2.equals(postgresDialect$) : postgresDialect$ != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 775));
            JdbcDialect $org_scalatest_assert_macro_left3 = JdbcDialects$.MODULE$.get("jdbc:db2://127.0.0.1/db");
            DB2Dialect$ $org_scalatest_assert_macro_right3 = DB2Dialect$.MODULE$;
            JdbcDialect jdbcDialect3 = $org_scalatest_assert_macro_left3;
            DB2Dialect$ dB2Dialect$ = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(jdbcDialect3 != null ? !jdbcDialect3.equals(dB2Dialect$) : dB2Dialect$ != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 776));
            JdbcDialect $org_scalatest_assert_macro_left4 = JdbcDialects$.MODULE$.get("jdbc:sqlserver://127.0.0.1/db");
            MsSqlServerDialect$ $org_scalatest_assert_macro_right4 = MsSqlServerDialect$.MODULE$;
            JdbcDialect jdbcDialect4 = $org_scalatest_assert_macro_left4;
            MsSqlServerDialect$ msSqlServerDialect$ = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(jdbcDialect4 != null ? !jdbcDialect4.equals(msSqlServerDialect$) : msSqlServerDialect$ != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 777));
            JdbcDialect $org_scalatest_assert_macro_left5 = JdbcDialects$.MODULE$.get("jdbc:derby:db");
            DerbyDialect$ $org_scalatest_assert_macro_right5 = DerbyDialect$.MODULE$;
            JdbcDialect jdbcDialect5 = $org_scalatest_assert_macro_left5;
            DerbyDialect$ derbyDialect$ = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(jdbcDialect5 != null ? !jdbcDialect5.equals(derbyDialect$) : derbyDialect$ != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 778));
            JdbcDialect $org_scalatest_assert_macro_left6 = JdbcDialects$.MODULE$.get("test.invalid");
            NoopDialect$ $org_scalatest_assert_macro_right6 = NoopDialect$.MODULE$;
            JdbcDialect jdbcDialect6 = $org_scalatest_assert_macro_left6;
            NoopDialect$ noopDialect$ = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(jdbcDialect6 != null ? !jdbcDialect6.equals(noopDialect$) : noopDialect$ != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 779));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 773));
        this.test("quote column names by jdbc dialect", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            JdbcDialect MySQL = JdbcDialects$.MODULE$.get("jdbc:mysql://127.0.0.1/db");
            JdbcDialect Postgres = JdbcDialects$.MODULE$.get("jdbc:postgresql://127.0.0.1/db");
            JdbcDialect Derby = JdbcDialects$.MODULE$.get("jdbc:derby:db");
            Seq columns = (Seq)new .colon.colon((Object)"abc", (List)new .colon.colon((Object)"key", (List)Nil$.MODULE$));
            Seq MySQLColumns = (Seq)columns.map((Function1 & Serializable & scala.Serializable)x$12 -> MySQL.quoteIdentifier(x$12), Seq$.MODULE$.canBuildFrom());
            Seq PostgresColumns = (Seq)columns.map((Function1 & Serializable & scala.Serializable)x$13 -> Postgres.quoteIdentifier(x$13), Seq$.MODULE$.canBuildFrom());
            Seq DerbyColumns = (Seq)columns.map((Function1 & Serializable & scala.Serializable)x$14 -> Derby.quoteIdentifier(x$14), Seq$.MODULE$.canBuildFrom());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(MySQLColumns);
            Seq $org_scalatest_assert_macro_right = (Seq)new .colon.colon((Object)"`abc`", (List)new .colon.colon((Object)"`key`", (List)Nil$.MODULE$));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 791));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(PostgresColumns);
            Seq $org_scalatest_assert_macro_right2 = (Seq)new .colon.colon((Object)"\"abc\"", (List)new .colon.colon((Object)"\"key\"", (List)Nil$.MODULE$));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 792));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(DerbyColumns);
            Seq $org_scalatest_assert_macro_right3 = (Seq)new .colon.colon((Object)"\"abc\"", (List)new .colon.colon((Object)"\"key\"", (List)Nil$.MODULE$));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 793));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 782));
        this.test("compile filters", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            ((IterableLike)new .colon.colon((Object)new Tuple2((Object)"col0", (Object)"col1"), (List)new .colon.colon((Object)new Tuple2((Object)"`col0`", (Object)"`col1`"), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String col0 = (String)tuple2._1();
                    String col1 = (String)tuple2._2();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(JDBCSuite.doCompileFilter$1((Filter)new EqualTo(col0, (Object)BoxesRunTime.boxToInteger((int)3))));
                    String $org_scalatest_assert_macro_right = "\"col0\" = 3";
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 801));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(JDBCSuite.doCompileFilter$1((Filter)new Not((Filter)new EqualTo(col1, (Object)"abc"))));
                    String $org_scalatest_assert_macro_right2 = "NOT (\"col1\" = 'abc')";
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 802));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(JDBCSuite.doCompileFilter$1((Filter)new And((Filter)new EqualTo(col0, (Object)BoxesRunTime.boxToInteger((int)0)), (Filter)new EqualTo(col1, (Object)"def"))));
                    String $org_scalatest_assert_macro_right3 = "(\"col0\" = 0) AND (\"col1\" = 'def')";
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 803));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(JDBCSuite.doCompileFilter$1((Filter)new Or((Filter)new EqualTo(col0, (Object)BoxesRunTime.boxToInteger((int)2)), (Filter)new EqualTo(col1, (Object)"ghi"))));
                    String $org_scalatest_assert_macro_right4 = "(\"col0\" = 2) OR (\"col1\" = 'ghi')";
                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 805));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(JDBCSuite.doCompileFilter$1((Filter)new LessThan(col0, (Object)BoxesRunTime.boxToInteger((int)5))));
                    String $org_scalatest_assert_macro_right5 = "\"col0\" < 5";
                    Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 807));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(JDBCSuite.doCompileFilter$1((Filter)new LessThan(col0, (Object)Timestamp.valueOf("1995-11-21 00:00:00.0"))));
                    String $org_scalatest_assert_macro_right6 = "\"col0\" < '1995-11-21 00:00:00.0'";
                    Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 808));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(JDBCSuite.doCompileFilter$1((Filter)new LessThan(col0, (Object)java.sql.Date.valueOf("1983-08-04"))));
                    String $org_scalatest_assert_macro_right7 = "\"col0\" < '1983-08-04'";
                    Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 810));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(JDBCSuite.doCompileFilter$1((Filter)new LessThanOrEqual(col0, (Object)BoxesRunTime.boxToInteger((int)5))));
                    String $org_scalatest_assert_macro_right8 = "\"col0\" <= 5";
                    Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 812));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(JDBCSuite.doCompileFilter$1((Filter)new GreaterThan(col0, (Object)BoxesRunTime.boxToInteger((int)3))));
                    String $org_scalatest_assert_macro_right9 = "\"col0\" > 3";
                    Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 813));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(JDBCSuite.doCompileFilter$1((Filter)new GreaterThanOrEqual(col0, (Object)BoxesRunTime.boxToInteger((int)3))));
                    String $org_scalatest_assert_macro_right10 = "\"col0\" >= 3";
                    Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 814));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(JDBCSuite.doCompileFilter$1((Filter)new In(col1, new Object[]{"jkl"})));
                    String $org_scalatest_assert_macro_right11 = "\"col1\" IN ('jkl')";
                    Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)$org_scalatest_assert_macro_right11, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 815));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.convertToEqualizer(JDBCSuite.doCompileFilter$1((Filter)new In(col1, (Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.Any()))));
                    String $org_scalatest_assert_macro_right12 = "CASE WHEN \"col1\" IS NULL THEN NULL ELSE FALSE END";
                    Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)$org_scalatest_assert_macro_right12, $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)$org_scalatest_assert_macro_right12, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 816));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left13 = this.convertToEqualizer(JDBCSuite.doCompileFilter$1((Filter)new Not((Filter)new In(col1, new Object[]{"mno", "pqr"}))));
                    String $org_scalatest_assert_macro_right13 = "NOT (\"col1\" IN ('mno', 'pqr'))";
                    Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "===", (Object)$org_scalatest_assert_macro_right13, $org_scalatest_assert_macro_left13.$eq$eq$eq((Object)$org_scalatest_assert_macro_right13, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 818));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left14 = this.convertToEqualizer(JDBCSuite.doCompileFilter$1((Filter)new IsNull(col1)));
                    String $org_scalatest_assert_macro_right14 = "\"col1\" IS NULL";
                    Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "===", (Object)$org_scalatest_assert_macro_right14, $org_scalatest_assert_macro_left14.$eq$eq$eq((Object)$org_scalatest_assert_macro_right14, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 820));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left15 = this.convertToEqualizer(JDBCSuite.doCompileFilter$1((Filter)new IsNotNull(col1)));
                    String $org_scalatest_assert_macro_right15 = "\"col1\" IS NOT NULL";
                    Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left15, "===", (Object)$org_scalatest_assert_macro_right15, $org_scalatest_assert_macro_left15.$eq$eq$eq((Object)$org_scalatest_assert_macro_right15, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 821));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left16 = this.convertToEqualizer(JDBCSuite.doCompileFilter$1((Filter)new And((Filter)new EqualNullSafe(col0, (Object)"abc"), (Filter)new EqualTo(col1, (Object)"def"))));
                    String $org_scalatest_assert_macro_right16 = "((\"col0\" = 'abc') OR (\"col0\" IS NULL AND 'abc' IS NULL)) AND (\"col1\" = 'def')";
                    Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left16, "===", (Object)$org_scalatest_assert_macro_right16, $org_scalatest_assert_macro_left16.$eq$eq$eq((Object)$org_scalatest_assert_macro_right16, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 822));
                }
                throw new MatchError((Object)tuple2);
            });
            String $org_scalatest_assert_macro_left = JDBCSuite.doCompileFilter$1((Filter)new EqualTo("col0.nested", (Object)BoxesRunTime.boxToInteger((int)3)));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 826));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 796));
        this.test("Dialect unregister", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            JdbcDialects$.MODULE$.unregisterDialect((JdbcDialect)H2Dialect$.MODULE$);
            try {
                JdbcDialects$.MODULE$.registerDialect(this.testH2Dialect());
                JdbcDialects$.MODULE$.unregisterDialect(this.testH2Dialect());
                JdbcDialect $org_scalatest_assert_macro_left = JdbcDialects$.MODULE$.get(this.urlWithUserAndPass());
                NoopDialect$ $org_scalatest_assert_macro_right = NoopDialect$.MODULE$;
                JdbcDialect jdbcDialect = $org_scalatest_assert_macro_left;
                NoopDialect$ noopDialect$ = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(jdbcDialect != null ? !jdbcDialect.equals(noopDialect$) : noopDialect$ != null), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 834));
            }
            finally {
                JdbcDialects$.MODULE$.registerDialect((JdbcDialect)H2Dialect$.MODULE$);
            }
            return assertion;
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 829));
        this.test("Aggregated dialects", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            AggregatedDialect agg = new AggregatedDialect((List)new .colon.colon((Object)new JdbcDialect(null){

                public boolean canHandle(String url) {
                    return url.startsWith("jdbc:h2:");
                }

                public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
                    if (sqlType % 2 == 0) {
                        return new Some((Object)LongType$.MODULE$);
                    }
                    return None$.MODULE$;
                }

                public String quoteIdentifier(String colName) {
                    return new StringBuilder(19).append("My ").append(colName).append(" quoteIdentifier").toString();
                }

                public String getTableExistsQuery(String table) {
                    return new StringBuilder(9).append("My ").append(table).append(" Table").toString();
                }

                public String getSchemaQuery(String table) {
                    return new StringBuilder(10).append("My ").append(table).append(" Schema").toString();
                }

                public Option<Object> isCascadingTruncateTable() {
                    return new Some((Object)BoxesRunTime.boxToBoolean((boolean)true));
                }
            }, (List)new .colon.colon((Object)this.testH2Dialect(), (List)Nil$.MODULE$)));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(agg.canHandle("jdbc:h2:xxx"), "agg.canHandle(\"jdbc:h2:xxx\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 861));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(agg.canHandle("jdbc:h2"), "agg.canHandle(\"jdbc:h2\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 862));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(agg.getCatalystType(0, "", 1, null));
            Some $org_scalatest_assert_macro_right = new Some((Object)LongType$.MODULE$);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 863));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(agg.getCatalystType(1, "", 1, null));
            Some $org_scalatest_assert_macro_right2 = new Some((Object)StringType$.MODULE$);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 864));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(agg.isCascadingTruncateTable());
            Some $org_scalatest_assert_macro_right3 = new Some((Object)BoxesRunTime.boxToBoolean((boolean)true));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 865));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(agg.quoteIdentifier("Dummy"));
            String $org_scalatest_assert_macro_right4 = "My Dummy quoteIdentifier";
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 866));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(agg.getTableExistsQuery("Dummy"));
            String $org_scalatest_assert_macro_right5 = "My Dummy Table";
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 867));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(agg.getSchemaQuery("Dummy"));
            String $org_scalatest_assert_macro_right6 = "My Dummy Schema";
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 868));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 840));
        this.test("Aggregated dialects: isCascadingTruncateTable", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.testDialects$1((List)new .colon.colon((Object)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)None$.MODULE$, (List)Nil$.MODULE$))), (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)));
            this.testDialects$1((List)new .colon.colon((Object)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)None$.MODULE$, (List)Nil$.MODULE$))), (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)));
            this.testDialects$1((List)new .colon.colon((Object)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)None$.MODULE$, (List)Nil$.MODULE$))), (Option)None$.MODULE$);
            this.testDialects$1((List)new .colon.colon((Object)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)Nil$.MODULE$)), (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)));
            this.testDialects$1((List)new .colon.colon((Object)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)Nil$.MODULE$)), (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)));
            this.testDialects$1((List)new .colon.colon((Object)None$.MODULE$, (List)new .colon.colon((Object)None$.MODULE$, (List)Nil$.MODULE$)), (Option)None$.MODULE$);
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 871));
        this.test("DB2Dialect type mapping", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            JdbcDialect db2Dialect = JdbcDialects$.MODULE$.get("jdbc:db2://127.0.0.1/db");
            String $org_scalatest_assert_macro_left = (String)db2Dialect.getJDBCType((DataType)StringType$.MODULE$).map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.databaseTypeDefinition()).get();
            String $org_scalatest_assert_macro_right = "CLOB";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 898));
            String $org_scalatest_assert_macro_left2 = (String)db2Dialect.getJDBCType((DataType)BooleanType$.MODULE$).map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.databaseTypeDefinition()).get();
            String $org_scalatest_assert_macro_right2 = "CHAR(1)";
            String string3 = $org_scalatest_assert_macro_left2;
            String string4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 899));
            String $org_scalatest_assert_macro_left3 = (String)db2Dialect.getJDBCType((DataType)ShortType$.MODULE$).map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.databaseTypeDefinition()).get();
            String $org_scalatest_assert_macro_right3 = "SMALLINT";
            String string5 = $org_scalatest_assert_macro_left3;
            String string6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 900));
            String $org_scalatest_assert_macro_left4 = (String)db2Dialect.getJDBCType((DataType)ByteType$.MODULE$).map((Function1 & Serializable & scala.Serializable)x$19 -> x$19.databaseTypeDefinition()).get();
            String $org_scalatest_assert_macro_right4 = "SMALLINT";
            String string7 = $org_scalatest_assert_macro_left4;
            String string8 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 901));
            Option $org_scalatest_assert_macro_left5 = db2Dialect.getCatalystType(7, "REAL", 1, null);
            Option $org_scalatest_assert_macro_right5 = Option$.MODULE$.apply((Object)FloatType$.MODULE$);
            Option option = $org_scalatest_assert_macro_left5;
            Option option2 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(option != null ? !option.equals(option2) : option2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 903));
            Option $org_scalatest_assert_macro_left6 = db2Dialect.getCatalystType(1111, "DECFLOAT", 1, null);
            Option $org_scalatest_assert_macro_right6 = Option$.MODULE$.apply((Object)new DecimalType(38, 18));
            Option option3 = $org_scalatest_assert_macro_left6;
            Option option4 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(option3 != null ? !option3.equals(option4) : option4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 904));
            Option $org_scalatest_assert_macro_left7 = db2Dialect.getCatalystType(1111, "XML", 1, null);
            Option $org_scalatest_assert_macro_right7 = Option$.MODULE$.apply((Object)StringType$.MODULE$);
            Option option5 = $org_scalatest_assert_macro_left7;
            Option option6 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right7, !(option5 != null ? !option5.equals(option6) : option6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 906));
            Option $org_scalatest_assert_macro_left8 = db2Dialect.getCatalystType(1111, "TIMESTAMP WITH TIME ZONE", 1, null);
            Option $org_scalatest_assert_macro_right8 = Option$.MODULE$.apply((Object)TimestampType$.MODULE$);
            Option option7 = $org_scalatest_assert_macro_left8;
            Option option8 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right8, !(option7 != null ? !option7.equals(option8) : option8 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 907));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 896));
        this.test("MySQLDialect catalyst type mapping", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            JdbcDialect mySqlDialect = JdbcDialects$.MODULE$.get("jdbc:mysql");
            MetadataBuilder metadata = new MetadataBuilder().putBoolean("isSigned", true);
            Option $org_scalatest_assert_macro_left = mySqlDialect.getCatalystType(-3, "BIT", 2, metadata);
            Some $org_scalatest_assert_macro_right = new Some((Object)LongType$.MODULE$);
            Option option = $org_scalatest_assert_macro_left;
            Some some = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 914));
            Metadata $org_scalatest_assert_macro_left2 = metadata.build();
            String $org_scalatest_assert_macro_right2 = "binarylong";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 916));
            Option $org_scalatest_assert_macro_left3 = mySqlDialect.getCatalystType(-3, "BIT", 1, metadata);
            None$ $org_scalatest_assert_macro_right3 = None$.MODULE$;
            Option option2 = $org_scalatest_assert_macro_left3;
            None$ none$ = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(option2 != null ? !option2.equals(none$) : none$ != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 917));
            Option $org_scalatest_assert_macro_left4 = mySqlDialect.getCatalystType(-7, "TINYINT", 1, metadata);
            Some $org_scalatest_assert_macro_right4 = new Some((Object)BooleanType$.MODULE$);
            Option option3 = $org_scalatest_assert_macro_left4;
            Some some2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(option3 != null ? !option3.equals(some2) : some2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 918));
            Option $org_scalatest_assert_macro_left5 = mySqlDialect.getCatalystType(-6, "TINYINT", 1, metadata);
            Some $org_scalatest_assert_macro_right5 = new Some((Object)ByteType$.MODULE$);
            Option option4 = $org_scalatest_assert_macro_left5;
            Some some3 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(option4 != null ? !option4.equals(some3) : some3 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 920));
            metadata.putBoolean("isSigned", false);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(mySqlDialect.getCatalystType(-6, "TINYINT", 1, metadata));
            Some $org_scalatest_assert_macro_right6 = new Some((Object)ShortType$.MODULE$);
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 923));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 911));
        this.test("SPARK-35446: MySQLDialect type mapping of float", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            JdbcDialect mySqlDialect = JdbcDialects$.MODULE$.get("jdbc:mysql://127.0.0.1/db");
            String $org_scalatest_assert_macro_left = (String)mySqlDialect.getJDBCType((DataType)FloatType$.MODULE$).map((Function1 & Serializable & scala.Serializable)x$20 -> x$20.databaseTypeDefinition()).get();
            String $org_scalatest_assert_macro_right = "FLOAT";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 929));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 927));
        this.test("PostgresDialect type mapping", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            JdbcDialect Postgres = JdbcDialects$.MODULE$.get("jdbc:postgresql://127.0.0.1/db");
            MetadataBuilder md = new MetadataBuilder().putLong("scale", 0L);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(Postgres.getCatalystType(1111, "json", 1, null));
            Some $org_scalatest_assert_macro_right = new Some((Object)StringType$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 935));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(Postgres.getCatalystType(1111, "jsonb", 1, null));
            Some $org_scalatest_assert_macro_right2 = new Some((Object)StringType$.MODULE$);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 936));
            Option $org_scalatest_assert_macro_left3 = Postgres.getCatalystType(2003, "_numeric", 0, md);
            Some $org_scalatest_assert_macro_right3 = new Some((Object)ArrayType$.MODULE$.apply((DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT()));
            Option option = $org_scalatest_assert_macro_left3;
            Some some = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 937));
            Option $org_scalatest_assert_macro_left4 = Postgres.getCatalystType(2003, "_bpchar", 64, md);
            Some $org_scalatest_assert_macro_right4 = new Some((Object)ArrayType$.MODULE$.apply((DataType)new CharType(64)));
            Option option2 = $org_scalatest_assert_macro_left4;
            Some some2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(option2 != null ? !option2.equals(some2) : some2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 939));
            String $org_scalatest_assert_macro_left5 = (String)Postgres.getJDBCType((DataType)FloatType$.MODULE$).map((Function1 & Serializable & scala.Serializable)x$21 -> x$21.databaseTypeDefinition()).get();
            String $org_scalatest_assert_macro_right5 = "FLOAT4";
            String string = $org_scalatest_assert_macro_left5;
            String string2 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 941));
            String $org_scalatest_assert_macro_left6 = (String)Postgres.getJDBCType((DataType)DoubleType$.MODULE$).map((Function1 & Serializable & scala.Serializable)x$22 -> x$22.databaseTypeDefinition()).get();
            String $org_scalatest_assert_macro_right6 = "FLOAT8";
            String string3 = $org_scalatest_assert_macro_left6;
            String string4 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 942));
            String $org_scalatest_assert_macro_left7 = (String)Postgres.getJDBCType((DataType)ByteType$.MODULE$).map((Function1 & Serializable & scala.Serializable)x$23 -> x$23.databaseTypeDefinition()).get();
            String $org_scalatest_assert_macro_right7 = "SMALLINT";
            String string5 = $org_scalatest_assert_macro_left7;
            String string6 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right7, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 943));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 932));
        this.test("DerbyDialect jdbc type mapping", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            JdbcDialect derbyDialect = JdbcDialects$.MODULE$.get("jdbc:derby:db");
            String $org_scalatest_assert_macro_left = (String)derbyDialect.getJDBCType((DataType)StringType$.MODULE$).map((Function1 & Serializable & scala.Serializable)x$24 -> x$24.databaseTypeDefinition()).get();
            String $org_scalatest_assert_macro_right = "CLOB";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 948));
            String $org_scalatest_assert_macro_left2 = (String)derbyDialect.getJDBCType((DataType)ByteType$.MODULE$).map((Function1 & Serializable & scala.Serializable)x$25 -> x$25.databaseTypeDefinition()).get();
            String $org_scalatest_assert_macro_right2 = "SMALLINT";
            String string3 = $org_scalatest_assert_macro_left2;
            String string4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 949));
            String $org_scalatest_assert_macro_left3 = (String)derbyDialect.getJDBCType((DataType)BooleanType$.MODULE$).map((Function1 & Serializable & scala.Serializable)x$26 -> x$26.databaseTypeDefinition()).get();
            String $org_scalatest_assert_macro_right3 = "BOOLEAN";
            String string5 = $org_scalatest_assert_macro_left3;
            String string6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 950));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 946));
        this.test("SPARK-39604: DerbyDialect catalyst type mapping", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            JdbcDialect derbyDialect = JdbcDialects$.MODULE$.get("jdbc:derby:db");
            MetadataBuilder metadata = new MetadataBuilder().putString("name", "test_column");
            Option $org_scalatest_assert_macro_left = derbyDialect.getCatalystType(7, "real", 0, metadata);
            Some $org_scalatest_assert_macro_right = new Some((Object)FloatType$.MODULE$);
            Option option = $org_scalatest_assert_macro_left;
            Some some = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 956));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 953));
        this.test("OracleDialect jdbc type mapping", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            JdbcDialect oracleDialect = JdbcDialects$.MODULE$.get("jdbc:oracle");
            MetadataBuilder metadata = new MetadataBuilder().putString("name", "test_column").putLong("scale", -127L);
            Option $org_scalatest_assert_macro_left = oracleDialect.getCatalystType(2, "float", 1, metadata);
            Some $org_scalatest_assert_macro_right = new Some((Object)new DecimalType(DecimalType$.MODULE$.MAX_PRECISION(), 10));
            Option option = $org_scalatest_assert_macro_left;
            Some some = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 963));
            Option $org_scalatest_assert_macro_left2 = oracleDialect.getCatalystType(2, "numeric", 0, null);
            Some $org_scalatest_assert_macro_right2 = new Some((Object)new DecimalType(DecimalType$.MODULE$.MAX_PRECISION(), 10));
            Option option2 = $org_scalatest_assert_macro_left2;
            Some some2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(option2 != null ? !option2.equals(some2) : some2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 965));
            Option $org_scalatest_assert_macro_left3 = oracleDialect.getCatalystType(OracleDialect$.MODULE$.BINARY_FLOAT(), "BINARY_FLOAT", 0, null);
            Some $org_scalatest_assert_macro_right3 = new Some((Object)FloatType$.MODULE$);
            Option option3 = $org_scalatest_assert_macro_left3;
            Some some3 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(option3 != null ? !option3.equals(some3) : some3 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 967));
            Option $org_scalatest_assert_macro_left4 = oracleDialect.getCatalystType(OracleDialect$.MODULE$.BINARY_DOUBLE(), "BINARY_DOUBLE", 0, null);
            Some $org_scalatest_assert_macro_right4 = new Some((Object)DoubleType$.MODULE$);
            Option option4 = $org_scalatest_assert_macro_left4;
            Some some4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(option4 != null ? !option4.equals(some4) : some4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 969));
            Option $org_scalatest_assert_macro_left5 = oracleDialect.getCatalystType(OracleDialect$.MODULE$.TIMESTAMPTZ(), "TIMESTAMP", 0, null);
            Some $org_scalatest_assert_macro_right5 = new Some((Object)TimestampType$.MODULE$);
            Option option5 = $org_scalatest_assert_macro_left5;
            Some some5 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(option5 != null ? !option5.equals(some5) : some5 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 971));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 960));
        this.test("SPARK-42469: OracleDialect Limit query test", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            JDBCOptions options = new JDBCOptions((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"url"), (Object)"jdbc:h2://host:port"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dbtable"), (Object)"test")})));
            String $org_scalatest_assert_macro_left = OracleDialect$.MODULE$.getJdbcSQLQueryBuilder(options).withColumns((String[])((Object[])new String[]{"a", "b"})).withLimit(123).build().trim();
            String $org_scalatest_assert_macro_right = "SELECT tab.* FROM (SELECT a,b FROM test    ) tab WHERE rownum <= 123";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 978));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 975));
        this.test("MsSqlServerDialect jdbc type mapping", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            JdbcDialect msSqlServerDialect = JdbcDialects$.MODULE$.get("jdbc:sqlserver");
            String $org_scalatest_assert_macro_left = (String)msSqlServerDialect.getJDBCType((DataType)TimestampType$.MODULE$).map((Function1 & Serializable & scala.Serializable)x$27 -> x$27.databaseTypeDefinition()).get();
            String $org_scalatest_assert_macro_right = "DATETIME";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 990));
            String $org_scalatest_assert_macro_left2 = (String)msSqlServerDialect.getJDBCType((DataType)StringType$.MODULE$).map((Function1 & Serializable & scala.Serializable)x$28 -> x$28.databaseTypeDefinition()).get();
            String $org_scalatest_assert_macro_right2 = "NVARCHAR(MAX)";
            String string3 = $org_scalatest_assert_macro_left2;
            String string4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 992));
            String $org_scalatest_assert_macro_left3 = (String)msSqlServerDialect.getJDBCType((DataType)BooleanType$.MODULE$).map((Function1 & Serializable & scala.Serializable)x$29 -> x$29.databaseTypeDefinition()).get();
            String $org_scalatest_assert_macro_right3 = "BIT";
            String string5 = $org_scalatest_assert_macro_left3;
            String string6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 994));
            String $org_scalatest_assert_macro_left4 = (String)msSqlServerDialect.getJDBCType((DataType)BinaryType$.MODULE$).map((Function1 & Serializable & scala.Serializable)x$30 -> x$30.databaseTypeDefinition()).get();
            String $org_scalatest_assert_macro_right4 = "VARBINARY(MAX)";
            String string7 = $org_scalatest_assert_macro_left4;
            String string8 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 996));
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)flag -> {
                this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_MSSQLSERVER_NUMERIC_MAPPING_ENABLED().key()), (Object)String.valueOf(BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)flag))))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    if (SQLConf$.MODULE$.get().legacyMsSqlServerNumericMappingEnabled()) {
                        Option $org_scalatest_assert_macro_left = msSqlServerDialect$1.getJDBCType((DataType)ShortType$.MODULE$).map((Function1 & Serializable & scala.Serializable)x$31 -> x$31.databaseTypeDefinition());
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1001));
                        return;
                    }
                    String $org_scalatest_assert_macro_left = (String)msSqlServerDialect$1.getJDBCType((DataType)ShortType$.MODULE$).map((Function1 & Serializable & scala.Serializable)x$32 -> x$32.databaseTypeDefinition()).get();
                    String $org_scalatest_assert_macro_right = "SMALLINT";
                    String string = $org_scalatest_assert_macro_left;
                    String string2 = $org_scalatest_assert_macro_right;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1003));
                });
                return BoxedUnit.UNIT;
            });
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 988));
        this.test("SPARK-28152: MsSqlServerDialect catalyst type mapping", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            JdbcDialect msSqlServerDialect = JdbcDialects$.MODULE$.get("jdbc:sqlserver");
            MetadataBuilder metadata = new MetadataBuilder().putLong("scale", 1L);
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)flag -> {
                this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_MSSQLSERVER_NUMERIC_MAPPING_ENABLED().key()), (Object)String.valueOf(BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)flag))))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    if (SQLConf$.MODULE$.get().legacyMsSqlServerNumericMappingEnabled()) {
                        Option $org_scalatest_assert_macro_left = msSqlServerDialect$2.getCatalystType(5, "SMALLINT", 1, metadata$1);
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1017));
                        Option $org_scalatest_assert_macro_left2 = msSqlServerDialect$2.getCatalystType(7, "REAL", 1, metadata$1);
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1019));
                        return;
                    }
                    DataType $org_scalatest_assert_macro_left = (DataType)msSqlServerDialect$2.getCatalystType(5, "SMALLINT", 1, metadata$1).get();
                    ShortType$ $org_scalatest_assert_macro_right = ShortType$.MODULE$;
                    DataType dataType = $org_scalatest_assert_macro_left;
                    ShortType$ shortType$ = $org_scalatest_assert_macro_right;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(dataType != null ? !dataType.equals(shortType$) : shortType$ != null), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1022));
                    DataType $org_scalatest_assert_macro_left3 = (DataType)msSqlServerDialect$2.getCatalystType(7, "REAL", 1, metadata$1).get();
                    FloatType$ $org_scalatest_assert_macro_right2 = FloatType$.MODULE$;
                    DataType dataType2 = $org_scalatest_assert_macro_left3;
                    FloatType$ floatType$ = $org_scalatest_assert_macro_right2;
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(dataType2 != null ? !dataType2.equals(floatType$) : floatType$ != null), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1024));
                });
                return BoxedUnit.UNIT;
            });
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1010));
        this.test("SPARK-42469: MsSqlServerDialect Limit query test", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            JDBCOptions options = new JDBCOptions((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"url"), (Object)"jdbc:h2://host:port"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dbtable"), (Object)"test")})));
            String $org_scalatest_assert_macro_left = MsSqlServerDialect$.MODULE$.getJdbcSQLQueryBuilder(options).withColumns((String[])((Object[])new String[]{"a", "b"})).withLimit(123).build().trim();
            String $org_scalatest_assert_macro_right = "SELECT TOP (123) a,b FROM test";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1034));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1031));
        this.test("SPARK-42534: DB2Dialect Limit query test", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            JDBCOptions options = new JDBCOptions((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"url"), (Object)"jdbc:db2://host:port"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dbtable"), (Object)"test")})));
            String $org_scalatest_assert_macro_left = DB2Dialect$.MODULE$.getJdbcSQLQueryBuilder(options).withColumns((String[])((Object[])new String[]{"a", "b"})).withLimit(123).build().trim();
            String $org_scalatest_assert_macro_right = "SELECT a,b FROM test      FETCH FIRST 123 ROWS ONLY";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1047));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1044));
        this.test("table exists query by jdbc dialect", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            JdbcDialect MySQL = JdbcDialects$.MODULE$.get("jdbc:mysql://127.0.0.1/db");
            JdbcDialect Postgres = JdbcDialects$.MODULE$.get("jdbc:postgresql://127.0.0.1/db");
            JdbcDialect db2 = JdbcDialects$.MODULE$.get("jdbc:db2://127.0.0.1/db");
            JdbcDialect h2 = JdbcDialects$.MODULE$.get(this.url());
            JdbcDialect derby = JdbcDialects$.MODULE$.get("jdbc:derby:db");
            String table = "weblogs";
            String defaultQuery = new StringBuilder(24).append("SELECT 1 FROM ").append(table).append(" WHERE 1=0").toString();
            String $org_scalatest_assert_macro_left = MySQL.getTableExistsQuery(table);
            String $org_scalatest_assert_macro_right = defaultQuery;
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1065));
            String $org_scalatest_assert_macro_left2 = Postgres.getTableExistsQuery(table);
            String $org_scalatest_assert_macro_right2 = defaultQuery;
            String string3 = $org_scalatest_assert_macro_left2;
            String string4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1066));
            String $org_scalatest_assert_macro_left3 = db2.getTableExistsQuery(table);
            String $org_scalatest_assert_macro_right3 = defaultQuery;
            String string5 = $org_scalatest_assert_macro_left3;
            String string6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1067));
            String $org_scalatest_assert_macro_left4 = h2.getTableExistsQuery(table);
            String $org_scalatest_assert_macro_right4 = defaultQuery;
            String string7 = $org_scalatest_assert_macro_left4;
            String string8 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1068));
            String $org_scalatest_assert_macro_left5 = derby.getTableExistsQuery(table);
            String $org_scalatest_assert_macro_right5 = defaultQuery;
            String string9 = $org_scalatest_assert_macro_left5;
            String string10 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(string9 != null ? !string9.equals(string10) : string10 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1069));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1057));
        this.test("truncate table query by jdbc dialect", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            JdbcDialect mysql = JdbcDialects$.MODULE$.get("jdbc:mysql://127.0.0.1/db");
            JdbcDialect postgres = JdbcDialects$.MODULE$.get("jdbc:postgresql://127.0.0.1/db");
            JdbcDialect db2 = JdbcDialects$.MODULE$.get("jdbc:db2://127.0.0.1/db");
            JdbcDialect h2 = JdbcDialects$.MODULE$.get(this.url());
            JdbcDialect derby = JdbcDialects$.MODULE$.get("jdbc:derby:db");
            JdbcDialect oracle = JdbcDialects$.MODULE$.get("jdbc:oracle://127.0.0.1/db");
            JdbcDialect teradata = JdbcDialects$.MODULE$.get("jdbc:teradata://127.0.0.1/db");
            String table = "weblogs";
            String defaultQuery = new StringBuilder(15).append("TRUNCATE TABLE ").append(table).toString();
            String postgresQuery = new StringBuilder(20).append("TRUNCATE TABLE ONLY ").append(table).toString();
            String teradataQuery = new StringBuilder(16).append("DELETE FROM ").append(table).append(" ALL").toString();
            String db2Query = new StringBuilder(25).append("TRUNCATE TABLE ").append(table).append(" IMMEDIATE").toString();
            ((IterableLike)new .colon.colon((Object)mysql, (List)new .colon.colon((Object)h2, (List)new .colon.colon((Object)derby, (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)dialect -> {
                String $org_scalatest_assert_macro_left = dialect.getTruncateQuery(table, (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)));
                String $org_scalatest_assert_macro_right = defaultQuery;
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1088));
            });
            String $org_scalatest_assert_macro_left = postgres.getTruncateQuery(table);
            String $org_scalatest_assert_macro_right = postgresQuery;
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1091));
            String $org_scalatest_assert_macro_left2 = oracle.getTruncateQuery(table);
            String $org_scalatest_assert_macro_right2 = defaultQuery;
            String string3 = $org_scalatest_assert_macro_left2;
            String string4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1092));
            String $org_scalatest_assert_macro_left3 = teradata.getTruncateQuery(table);
            String $org_scalatest_assert_macro_right3 = teradataQuery;
            String string5 = $org_scalatest_assert_macro_left3;
            String string6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1093));
            String $org_scalatest_assert_macro_left4 = db2.getTruncateQuery(table);
            String $org_scalatest_assert_macro_right4 = db2Query;
            String string7 = $org_scalatest_assert_macro_left4;
            String string8 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1094));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1072));
        this.test("SPARK-22880: Truncate table with CASCADE by jdbc dialect", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            JdbcDialect mysql = JdbcDialects$.MODULE$.get("jdbc:mysql://127.0.0.1/db");
            JdbcDialect postgres = JdbcDialects$.MODULE$.get("jdbc:postgresql://127.0.0.1/db");
            JdbcDialect db2 = JdbcDialects$.MODULE$.get("jdbc:db2://127.0.0.1/db");
            JdbcDialect h2 = JdbcDialects$.MODULE$.get(this.url());
            JdbcDialect derby = JdbcDialects$.MODULE$.get("jdbc:derby:db");
            JdbcDialect oracle = JdbcDialects$.MODULE$.get("jdbc:oracle://127.0.0.1/db");
            JdbcDialect teradata = JdbcDialects$.MODULE$.get("jdbc:teradata://127.0.0.1/db");
            String table = "weblogs";
            String defaultQuery = new StringBuilder(15).append("TRUNCATE TABLE ").append(table).toString();
            String postgresQuery = new StringBuilder(28).append("TRUNCATE TABLE ONLY ").append(table).append(" CASCADE").toString();
            String oracleQuery = new StringBuilder(23).append("TRUNCATE TABLE ").append(table).append(" CASCADE").toString();
            String teradataQuery = new StringBuilder(16).append("DELETE FROM ").append(table).append(" ALL").toString();
            String db2Query = new StringBuilder(25).append("TRUNCATE TABLE ").append(table).append(" IMMEDIATE").toString();
            ((IterableLike)new .colon.colon((Object)mysql, (List)new .colon.colon((Object)h2, (List)new .colon.colon((Object)derby, (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)dialect -> {
                String $org_scalatest_assert_macro_left = dialect.getTruncateQuery(table, (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)));
                String $org_scalatest_assert_macro_right = defaultQuery;
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1116));
            });
            String $org_scalatest_assert_macro_left = postgres.getTruncateQuery(table, (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)));
            String $org_scalatest_assert_macro_right = postgresQuery;
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1118));
            String $org_scalatest_assert_macro_left2 = oracle.getTruncateQuery(table, (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)));
            String $org_scalatest_assert_macro_right2 = oracleQuery;
            String string3 = $org_scalatest_assert_macro_left2;
            String string4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1119));
            String $org_scalatest_assert_macro_left3 = teradata.getTruncateQuery(table, (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)));
            String $org_scalatest_assert_macro_right3 = teradataQuery;
            String string5 = $org_scalatest_assert_macro_left3;
            String string6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1120));
            String $org_scalatest_assert_macro_left4 = db2.getTruncateQuery(table, (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)));
            String $org_scalatest_assert_macro_right4 = db2Query;
            String string7 = $org_scalatest_assert_macro_left4;
            String string8 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1121));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1097));
        this.test("Test DataFrame.where for Date and Timestamp", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Timestamp timestamp = Timestamp.valueOf("2001-02-20 11:22:33.543543");
            java.sql.Date date = java.sql.Date.valueOf("1995-01-01");
            Dataset jdbcDf = this.spark().read().jdbc(this.urlWithUserAndPass(), "TEST.TIMETYPES", new Properties());
            Row[] rows = (Row[])jdbcDf.where(this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"B"}))).$((Seq)Nil$.MODULE$).$greater((Object)date).$amp$amp((Object)this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"C"}))).$((Seq)Nil$.MODULE$).$greater((Object)timestamp))).collect();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(rows[0].getAs(1));
            java.sql.Date $org_scalatest_assert_macro_right = java.sql.Date.valueOf("1996-01-01");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1130));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(rows[0].getAs(2));
            Timestamp $org_scalatest_assert_macro_right2 = Timestamp.valueOf("2002-02-20 11:22:33.543543");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1131));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1124));
        this.test("SPARK-33867: Test DataFrame.where for LocalDate and Instant", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Instant timestamp = Instant.parse("2001-02-20T11:22:33.543543Z");
            LocalDate date = LocalDate.parse("1995-01-01");
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.DATETIME_JAVA8API_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Dataset jdbcDf = this.spark().read().jdbc(this.urlWithUserAndPass(), "TEST.TIMETYPES", new Properties());
                Row[] rows = (Row[])jdbcDf.where(this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"B"}))).$((Seq)Nil$.MODULE$).$greater((Object)date).$amp$amp((Object)this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"C"}))).$((Seq)Nil$.MODULE$).$greater((Object)timestamp))).collect();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(rows[0].getAs(1));
                LocalDate $org_scalatest_assert_macro_right = LocalDate.parse("1996-01-01");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1142));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(rows[0].getAs(2));
                Instant $org_scalatest_assert_macro_right2 = Instant.parse("2002-02-20T19:22:33.543543Z");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1144));
            });
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1135));
        this.test("test credentials in the properties are not in plan output", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Dataset df = (Dataset)this.sql().apply((Object)"SELECT * FROM parts");
            ExplainCommand explain = new ExplainCommand(df.queryExecution().logical(), (ExplainMode)ExtendedMode$.MODULE$);
            SessionState qual$1 = this.spark().sessionState();
            ExplainCommand x$1 = explain;
            Enumeration.Value x$2 = qual$1.executePlan$default$2();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])qual$1.executePlan((LogicalPlan)x$1, x$2).executedPlan().executeCollect())).foreach((Function1 & Serializable & scala.Serializable)r -> {
                String string = r.toString();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(new .colon.colon((Object)"testPass", (List)new .colon.colon((Object)"testUser", (List)Nil$.MODULE$)).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)string.contains(x$1))), "scala.collection.immutable.List.apply[String](\"testPass\", \"testUser\").exists({\n  <synthetic> val eta$0$1: String = r.toString();\n  ((x$1: CharSequence) => eta$0$1.contains(x$1))\n})", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1152));
            });
            return df.queryExecution().analyzed().collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof LogicalRelation) {
                        LogicalRelation logicalRelation = (LogicalRelation)A1;
                        String $org_scalatest_assert_macro_left = logicalRelation.relation().toString();
                        String $org_scalatest_assert_macro_right = "JDBCRelation(TEST.PEOPLE) [numPartitions=3]";
                        String string = $org_scalatest_assert_macro_left;
                        String string2 = $org_scalatest_assert_macro_right;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                        return (B1)Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1157));
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(LogicalPlan x1) {
                    LogicalPlan logicalPlan = x1;
                    return logicalPlan instanceof LogicalRelation;
                }
            });
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1148));
        this.test("test credentials in the connection url are not in the plan output", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Dataset df = this.spark().read().jdbc(this.urlWithUserAndPass(), "TEST.PEOPLE", new Properties());
            ExplainCommand explain = new ExplainCommand(df.queryExecution().logical(), (ExplainMode)ExtendedMode$.MODULE$);
            SessionState qual$2 = this.spark().sessionState();
            ExplainCommand x$3 = explain;
            Enumeration.Value x$4 = qual$2.executePlan$default$2();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])qual$2.executePlan((LogicalPlan)x$3, x$4).executedPlan().executeCollect())).foreach((Function1 & Serializable & scala.Serializable)r -> {
                String string = r.toString();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(new .colon.colon((Object)"testPass", (List)new .colon.colon((Object)"testUser", (List)Nil$.MODULE$)).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)string.contains(x$1))), "scala.collection.immutable.List.apply[String](\"testPass\", \"testUser\").exists({\n  <synthetic> val eta$0$2: String = r.toString();\n  ((x$1: CharSequence) => eta$0$2.contains(x$1))\n})", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1165));
            });
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1161));
        this.test("hide credentials in create and describe a persistent/temp table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String password = "testPass";
            String tableName = "tab1";
            ((IterableLike)new .colon.colon((Object)"TABLE", (List)new .colon.colon((Object)"TEMPORARY VIEW", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
                this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    Dataset df = (Dataset)$this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(226).append("\n             |CREATE ").append(tableType).append(" ").append(tableName$1).append("\n             |USING org.apache.spark.sql.jdbc\n             |OPTIONS (\n             | url '").append($this.urlWithUserAndPass()).append("',\n             | dbtable 'TEST.PEOPLE',\n             | user 'testUser',\n             | password '").append(password$1).append("')\n           ").toString())).stripMargin());
                    ExplainCommand explain = new ExplainCommand(df.queryExecution().logical(), (ExplainMode)ExtendedMode$.MODULE$);
                    SessionState qual$3 = $this.spark().sessionState();
                    ExplainCommand x$5 = explain;
                    Enumeration.Value x$6 = qual$3.executePlan$default$2();
                    new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])qual$3.executePlan((LogicalPlan)x$5, x$6).executedPlan().executeCollect())).foreach((Function1 & Serializable & scala.Serializable)r -> {
                        String $org_scalatest_assert_macro_left = r.toString();
                        String $org_scalatest_assert_macro_right = password$1;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1187));
                    });
                    new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((Dataset)$this.sql().apply((Object)new StringBuilder(15).append("DESC FORMATTED ").append(tableName$1).toString())).collect())).foreach((Function1 & Serializable & scala.Serializable)r -> {
                        String $org_scalatest_assert_macro_left = r.toString();
                        String $org_scalatest_assert_macro_right = password$1;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1191));
                    });
                });
                return BoxedUnit.UNIT;
            });
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1169));
        this.test("Hide credentials in show create table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String userName = "testUser";
            String password = "testPass";
            String tableName = "tab1";
            String dbTable = "TEST.PEOPLE";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(196).append("\n           |CREATE TABLE ").append(tableName).append("\n           |USING org.apache.spark.sql.jdbc\n           |OPTIONS (\n           | url '").append(this.urlWithUserAndPass()).append("',\n           | dbtable '").append(dbTable).append("',\n           | user '").append(userName).append("',\n           | password '").append(password).append("')\n         ").toString())).stripMargin());
                ShowCreateTableCommand show = new ShowCreateTableCommand(TableIdentifier$.MODULE$.apply(tableName), ShowCreateTable$.MODULE$.getoutputAttrs());
                SessionState qual$4 = this.spark().sessionState();
                ShowCreateTableCommand x$7 = show;
                Enumeration.Value x$8 = qual$4.executePlan$default$2();
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])qual$4.executePlan((LogicalPlan)x$7, x$8).executedPlan().executeCollectPublic())).foreach((Function1 & Serializable & scala.Serializable)r -> {
                    String $org_scalatest_assert_macro_left = r.toString();
                    String $org_scalatest_assert_macro_right = password;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1216));
                    String $org_scalatest_assert_macro_left2 = r.toString();
                    String $org_scalatest_assert_macro_right2 = dbTable;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1217));
                    String $org_scalatest_assert_macro_left3 = r.toString();
                    String $org_scalatest_assert_macro_right3 = userName;
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1218));
                });
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((Dataset)this.sql().apply((Object)new StringBuilder(18).append("SHOW CREATE TABLE ").append(tableName).toString())).collect())).foreach((Function1 & Serializable & scala.Serializable)r -> {
                    String $org_scalatest_assert_macro_left = r.toString();
                    String $org_scalatest_assert_macro_right = password;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1222));
                    String $org_scalatest_assert_macro_left2 = r.toString();
                    String $org_scalatest_assert_macro_right2 = dbTable;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1223));
                    String $org_scalatest_assert_macro_left3 = r.toString();
                    String $org_scalatest_assert_macro_right3 = userName;
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1224));
                });
                this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.SQL_OPTIONS_REDACTION_PATTERN().key()), (Object)"(?i)dbtable|user")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    SessionState qual$5 = this.spark().sessionState();
                    ShowCreateTableCommand x$9 = show;
                    Enumeration.Value x$10 = qual$5.executePlan$default$2();
                    new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])qual$5.executePlan((LogicalPlan)x$9, x$10).executedPlan().executeCollectPublic())).foreach((Function1 & Serializable & scala.Serializable)r -> {
                        String $org_scalatest_assert_macro_left = r.toString();
                        String $org_scalatest_assert_macro_right = password;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1229));
                        String $org_scalatest_assert_macro_left2 = r.toString();
                        String $org_scalatest_assert_macro_right2 = dbTable;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1230));
                        String $org_scalatest_assert_macro_left3 = r.toString();
                        String $org_scalatest_assert_macro_right3 = userName;
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1231));
                    });
                });
            });
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1197));
        this.test("Replace CatalogUtils.maskCredentials with SQLConf.get.redactOptions", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String password = "testPass";
            String tableName = "tab1";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(215).append("\n           |CREATE TABLE ").append(tableName).append("\n           |USING org.apache.spark.sql.jdbc\n           |OPTIONS (\n           | url '").append(this.urlWithUserAndPass()).append("',\n           | dbtable 'TEST.PEOPLE',\n           | user 'testUser',\n           | password '").append(password).append("')\n         ").toString())).stripMargin());
                Row[] storageProps = (Row[])((Dataset)this.sql().apply((Object)new StringBuilder(15).append("DESC FORMATTED ").append(tableName).toString())).filter("col_name = 'Storage Properties'").select("data_type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collect();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)storageProps.length));
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1255));
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])storageProps)).foreach((Function1 & Serializable & scala.Serializable)r -> {
                    String $org_scalatest_assert_macro_left = r.getString(0);
                    String $org_scalatest_assert_macro_right = new StringBuilder(4).append("url=").append(Utils$.MODULE$.REDACTION_REPLACEMENT_TEXT()).toString();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1257));
                    String $org_scalatest_assert_macro_left2 = r.getString(0);
                    String $org_scalatest_assert_macro_right2 = new StringBuilder(9).append("password=").append(Utils$.MODULE$.REDACTION_REPLACEMENT_TEXT()).toString();
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1258));
                });
                Row[] information = (Row[])((Dataset)this.sql().apply((Object)new StringBuilder(27).append("SHOW TABLE EXTENDED LIKE '").append(tableName).append("'").toString())).select("information", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collect();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)information.length));
                int $org_scalatest_assert_macro_right2 = 1;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1263));
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])information)).foreach((Function1 & Serializable & scala.Serializable)r -> {
                    String $org_scalatest_assert_macro_left = r.getString(0);
                    String $org_scalatest_assert_macro_right = new StringBuilder(4).append("url=").append(Utils$.MODULE$.REDACTION_REPLACEMENT_TEXT()).toString();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1265));
                    String $org_scalatest_assert_macro_left2 = r.getString(0);
                    String $org_scalatest_assert_macro_right2 = new StringBuilder(9).append("password=").append(Utils$.MODULE$.REDACTION_REPLACEMENT_TEXT()).toString();
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1266));
                });
                Row[] createTabStmt = (Row[])((Dataset)this.sql().apply((Object)new StringBuilder(18).append("SHOW CREATE TABLE ").append(tableName).toString())).select("createtab_stmt", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collect();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)createTabStmt.length));
                int $org_scalatest_assert_macro_right3 = 1;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1271));
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])createTabStmt)).foreach((Function1 & Serializable & scala.Serializable)r -> {
                    String $org_scalatest_assert_macro_left = r.getString(0);
                    String $org_scalatest_assert_macro_right = new StringBuilder(10).append("'url' = '").append(Utils$.MODULE$.REDACTION_REPLACEMENT_TEXT()).append("'").toString();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1273));
                    String $org_scalatest_assert_macro_left2 = r.getString(0);
                    String $org_scalatest_assert_macro_right2 = new StringBuilder(15).append("'password' = '").append(Utils$.MODULE$.REDACTION_REPLACEMENT_TEXT()).append("'").toString();
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1274));
                });
            });
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1237));
        this.test("SPARK 12941: The data type mapping for StringType to Oracle", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            JdbcDialect oracleDialect = JdbcDialects$.MODULE$.get("jdbc:oracle://127.0.0.1/db");
            String $org_scalatest_assert_macro_left = (String)oracleDialect.getJDBCType((DataType)StringType$.MODULE$).map((Function1 & Serializable & scala.Serializable)x$33 -> x$33.databaseTypeDefinition()).get();
            String $org_scalatest_assert_macro_right = "VARCHAR2(255)";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1281));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1279));
        this.test("SPARK-16625: General data types to be mapped to Oracle", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            JdbcDialect oracleDialect = JdbcDialects$.MODULE$.get("jdbc:oracle://127.0.0.1/db");
            String $org_scalatest_assert_macro_left = JDBCSuite.getJdbcType$1(oracleDialect, (DataType)BooleanType$.MODULE$);
            String $org_scalatest_assert_macro_right = "NUMBER(1)";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1293));
            String $org_scalatest_assert_macro_left2 = JDBCSuite.getJdbcType$1(oracleDialect, (DataType)IntegerType$.MODULE$);
            String $org_scalatest_assert_macro_right2 = "NUMBER(10)";
            String string3 = $org_scalatest_assert_macro_left2;
            String string4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1294));
            String $org_scalatest_assert_macro_left3 = JDBCSuite.getJdbcType$1(oracleDialect, (DataType)LongType$.MODULE$);
            String $org_scalatest_assert_macro_right3 = "NUMBER(19)";
            String string5 = $org_scalatest_assert_macro_left3;
            String string6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1295));
            String $org_scalatest_assert_macro_left4 = JDBCSuite.getJdbcType$1(oracleDialect, (DataType)FloatType$.MODULE$);
            String $org_scalatest_assert_macro_right4 = "NUMBER(19, 4)";
            String string7 = $org_scalatest_assert_macro_left4;
            String string8 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1296));
            String $org_scalatest_assert_macro_left5 = JDBCSuite.getJdbcType$1(oracleDialect, (DataType)DoubleType$.MODULE$);
            String $org_scalatest_assert_macro_right5 = "NUMBER(19, 4)";
            String string9 = $org_scalatest_assert_macro_left5;
            String string10 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(string9 != null ? !string9.equals(string10) : string10 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1297));
            String $org_scalatest_assert_macro_left6 = JDBCSuite.getJdbcType$1(oracleDialect, (DataType)ByteType$.MODULE$);
            String $org_scalatest_assert_macro_right6 = "NUMBER(3)";
            String string11 = $org_scalatest_assert_macro_left6;
            String string12 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(string11 != null ? !string11.equals(string12) : string12 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1298));
            String $org_scalatest_assert_macro_left7 = JDBCSuite.getJdbcType$1(oracleDialect, (DataType)ShortType$.MODULE$);
            String $org_scalatest_assert_macro_right7 = "NUMBER(5)";
            String string13 = $org_scalatest_assert_macro_left7;
            String string14 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right7, !(string13 != null ? !string13.equals(string14) : string14 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1299));
            String $org_scalatest_assert_macro_left8 = JDBCSuite.getJdbcType$1(oracleDialect, (DataType)StringType$.MODULE$);
            String $org_scalatest_assert_macro_right8 = "VARCHAR2(255)";
            String string15 = $org_scalatest_assert_macro_left8;
            String string16 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right8, !(string15 != null ? !string15.equals(string16) : string16 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1300));
            String $org_scalatest_assert_macro_left9 = JDBCSuite.getJdbcType$1(oracleDialect, (DataType)BinaryType$.MODULE$);
            String $org_scalatest_assert_macro_right9 = "BLOB";
            String string17 = $org_scalatest_assert_macro_left9;
            String string18 = $org_scalatest_assert_macro_right9;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right9, !(string17 != null ? !string17.equals(string18) : string18 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1301));
            String $org_scalatest_assert_macro_left10 = JDBCSuite.getJdbcType$1(oracleDialect, (DataType)DateType$.MODULE$);
            String $org_scalatest_assert_macro_right10 = "DATE";
            String string19 = $org_scalatest_assert_macro_left10;
            String string20 = $org_scalatest_assert_macro_right10;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "==", (Object)$org_scalatest_assert_macro_right10, !(string19 != null ? !string19.equals(string20) : string20 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1302));
            String $org_scalatest_assert_macro_left11 = JDBCSuite.getJdbcType$1(oracleDialect, (DataType)TimestampType$.MODULE$);
            String $org_scalatest_assert_macro_right11 = "TIMESTAMP";
            String string21 = $org_scalatest_assert_macro_left11;
            String string22 = $org_scalatest_assert_macro_right11;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "==", (Object)$org_scalatest_assert_macro_right11, !(string21 != null ? !string21.equals(string22) : string22 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1303));
            String $org_scalatest_assert_macro_left12 = JDBCSuite.getJdbcType$1(oracleDialect, (DataType)TimestampNTZType$.MODULE$);
            String $org_scalatest_assert_macro_right12 = "TIMESTAMP";
            String string23 = $org_scalatest_assert_macro_left12;
            String string24 = $org_scalatest_assert_macro_right12;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "==", (Object)$org_scalatest_assert_macro_right12, !(string23 != null ? !string23.equals(string24) : string24 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1304));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1285));
        this.test("SPARK-15916: JDBC filter operator push down should respect operator precedence", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String TRUE = "NAME != 'non_exists'";
            String FALSE1 = "THEID > 1000000000";
            String FALSE2 = "THEID < -1000000000";
            this.assertEmptyQuery(new StringBuilder(38).append("SELECT * FROM foobar WHERE (").append(TRUE).append(" OR ").append(FALSE1).append(") AND ").append(FALSE2).toString());
            this.assertEmptyQuery(new StringBuilder(38).append("SELECT * FROM foobar WHERE ").append(FALSE1).append(" AND (").append(FALSE2).append(" OR ").append(TRUE).append(")").toString());
            this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tempFrame"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                String jdbcPartitionWhereClause = new StringBuilder(4).append(FALSE1).append(" OR ").append(TRUE).toString();
                Dataset df = this.spark().read().jdbc(this.urlWithUserAndPass(), "TEST.PEOPLE", (String[])((Object[])new String[]{jdbcPartitionWhereClause}), new Properties());
                df.createOrReplaceTempView("tempFrame");
                this.assertEmptyQuery(new StringBuilder(30).append("SELECT * FROM tempFrame where ").append(FALSE2).toString());
            });
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1311));
        this.test("SPARK-16387: Reserved SQL words are not escaped by JDBC writer", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String schema;
            Dataset df = this.spark().createDataset((Seq)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)new .colon.colon((Object)"c", (List)Nil$.MODULE$))), this.testImplicits().newStringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"order"}));
            String $org_scalatest_assert_macro_left = schema = JdbcUtils$.MODULE$.schemaString(df.schema(), df.sqlContext().conf().caseSensitiveAnalysis(), "jdbc:mysql://localhost:3306/temp", JdbcUtils$.MODULE$.schemaString$default$4());
            String $org_scalatest_assert_macro_right = "`order` LONGTEXT";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1339));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1333));
        this.test("SPARK-18141: Predicates on quoted column names in the jdbc data source", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Object[] $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])((Dataset)this.sql().apply((Object)"SELECT * FROM mixedCaseCols WHERE Id < 1")).collect());
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left), "size", (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef($org_scalatest_assert_macro_left).size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1343));
            Object[] $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])((Dataset)this.sql().apply((Object)"SELECT * FROM mixedCaseCols WHERE Id <= 1")).collect());
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left2), "size", (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef($org_scalatest_assert_macro_left2).size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1344));
            Object[] $org_scalatest_assert_macro_left3 = Predef$.MODULE$.refArrayOps((Object[])((Dataset)this.sql().apply((Object)"SELECT * FROM mixedCaseCols WHERE Id > 1")).collect());
            int $org_scalatest_assert_macro_right3 = 2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left3), "size", (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef($org_scalatest_assert_macro_left3).size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1345));
            Object[] $org_scalatest_assert_macro_left4 = Predef$.MODULE$.refArrayOps((Object[])((Dataset)this.sql().apply((Object)"SELECT * FROM mixedCaseCols WHERE Id >= 1")).collect());
            int $org_scalatest_assert_macro_right4 = 3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left4), "size", (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef($org_scalatest_assert_macro_left4).size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1346));
            Object[] $org_scalatest_assert_macro_left5 = Predef$.MODULE$.refArrayOps((Object[])((Dataset)this.sql().apply((Object)"SELECT * FROM mixedCaseCols WHERE Id = 1")).collect());
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left5), "size", (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef($org_scalatest_assert_macro_left5).size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1347));
            Object[] $org_scalatest_assert_macro_left6 = Predef$.MODULE$.refArrayOps((Object[])((Dataset)this.sql().apply((Object)"SELECT * FROM mixedCaseCols WHERE Id != 2")).collect());
            int $org_scalatest_assert_macro_right6 = 2;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left6), "size", (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef($org_scalatest_assert_macro_left6).size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1348));
            Object[] $org_scalatest_assert_macro_left7 = Predef$.MODULE$.refArrayOps((Object[])((Dataset)this.sql().apply((Object)"SELECT * FROM mixedCaseCols WHERE Id <=> 2")).collect());
            int $org_scalatest_assert_macro_right7 = 1;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.lengthSizeMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left7), "size", (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef($org_scalatest_assert_macro_left7).size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1349));
            Object[] $org_scalatest_assert_macro_left8 = Predef$.MODULE$.refArrayOps((Object[])((Dataset)this.sql().apply((Object)"SELECT * FROM mixedCaseCols WHERE Name LIKE 'fr%'")).collect());
            int $org_scalatest_assert_macro_right8 = 1;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.lengthSizeMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left8), "size", (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef($org_scalatest_assert_macro_left8).size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1350));
            Object[] $org_scalatest_assert_macro_left9 = Predef$.MODULE$.refArrayOps((Object[])((Dataset)this.sql().apply((Object)"SELECT * FROM mixedCaseCols WHERE Name LIKE '%ed'")).collect());
            int $org_scalatest_assert_macro_right9 = 1;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.lengthSizeMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left9), "size", (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef($org_scalatest_assert_macro_left9).size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1351));
            Object[] $org_scalatest_assert_macro_left10 = Predef$.MODULE$.refArrayOps((Object[])((Dataset)this.sql().apply((Object)"SELECT * FROM mixedCaseCols WHERE Name LIKE '%re%'")).collect());
            int $org_scalatest_assert_macro_right10 = 1;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.lengthSizeMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left10), "size", (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef($org_scalatest_assert_macro_left10).size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1352));
            Object[] $org_scalatest_assert_macro_left11 = Predef$.MODULE$.refArrayOps((Object[])((Dataset)this.sql().apply((Object)"SELECT * FROM mixedCaseCols WHERE Name IS NULL")).collect());
            int $org_scalatest_assert_macro_right11 = 1;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.lengthSizeMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left11), "size", (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef($org_scalatest_assert_macro_left11).size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1353));
            Object[] $org_scalatest_assert_macro_left12 = Predef$.MODULE$.refArrayOps((Object[])((Dataset)this.sql().apply((Object)"SELECT * FROM mixedCaseCols WHERE Name IS NOT NULL")).collect());
            int $org_scalatest_assert_macro_right12 = 2;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.lengthSizeMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left12), "size", (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef($org_scalatest_assert_macro_left12).size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right12), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1354));
            Object[] $org_scalatest_assert_macro_left13 = Predef$.MODULE$.refArrayOps((Object[])((Dataset)this.sql().apply((Object)"SELECT * FROM mixedCaseCols")).filter(this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Name"}))).$((Seq)Nil$.MODULE$).isin((Seq)Nil$.MODULE$)).collect());
            int $org_scalatest_assert_macro_right13 = 0;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.lengthSizeMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left13), "size", (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef($org_scalatest_assert_macro_left13).size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right13), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1355));
            Object[] $org_scalatest_assert_macro_left14 = Predef$.MODULE$.refArrayOps((Object[])((Dataset)this.sql().apply((Object)"SELECT * FROM mixedCaseCols WHERE Name IN ('mary', 'fred')")).collect());
            int $org_scalatest_assert_macro_right14 = 2;
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.lengthSizeMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left14), "size", (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef($org_scalatest_assert_macro_left14).size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right14), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1356));
            Object[] $org_scalatest_assert_macro_left15 = Predef$.MODULE$.refArrayOps((Object[])((Dataset)this.sql().apply((Object)"SELECT * FROM mixedCaseCols WHERE Name NOT IN ('fred')")).collect());
            int $org_scalatest_assert_macro_right15 = 1;
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.lengthSizeMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left15), "size", (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef($org_scalatest_assert_macro_left15).size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right15), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1357));
            Object[] $org_scalatest_assert_macro_left16 = Predef$.MODULE$.refArrayOps((Object[])((Dataset)this.sql().apply((Object)"SELECT * FROM mixedCaseCols WHERE Id = 1 OR Name = 'mary'")).collect());
            int $org_scalatest_assert_macro_right16 = 2;
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.lengthSizeMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left16), "size", (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef($org_scalatest_assert_macro_left16).size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right16), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1358));
            Object[] $org_scalatest_assert_macro_left17 = Predef$.MODULE$.refArrayOps((Object[])((Dataset)this.sql().apply((Object)"SELECT * FROM mixedCaseCols WHERE Name = 'mary' AND Id = 2")).collect());
            int $org_scalatest_assert_macro_right17 = 1;
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.lengthSizeMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left17), "size", (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef($org_scalatest_assert_macro_left17).size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right17), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1359));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1342));
        this.test("SPARK-18419: Fix `asConnectionProperties` to filter case-insensitively", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            scala.collection.immutable.Map parameters = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"url"), (Object)"jdbc:mysql://localhost:3306/temp"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dbtable"), (Object)"t1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numPartitions"), (Object)"10")}));
            Properties $org_scalatest_assert_macro_left = new JDBCOptions(parameters).asConnectionProperties();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1367));
            Properties $org_scalatest_assert_macro_left2 = new JDBCOptions(CaseInsensitiveMap$.MODULE$.apply(parameters)).asConnectionProperties();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1368));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1362));
        this.test("SPARK-16848: jdbc API throws an exception for user specified schema", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String e2;
            String e1;
            StructType schema = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("name", (DataType)StringType$.MODULE$, false, this.defaultMetadata((DataType)StringType$.MODULE$)), (List)new .colon.colon((Object)new StructField("theid", (DataType)IntegerType$.MODULE$, false, this.defaultMetadata((DataType)IntegerType$.MODULE$)), (List)Nil$.MODULE$)));
            String[] parts = (String[])((Object[])new String[]{"THEID < 2", "THEID >= 2"});
            String $org_scalatest_assert_macro_left = e1 = ((AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.spark().read().schema(schema).jdbc(this.urlWithUserAndPass(), "TEST.PEOPLE", parts, new Properties()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1375))))).getMessage();
            String $org_scalatest_assert_macro_right = "User specified schema not supported with `jdbc`";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1378));
            String $org_scalatest_assert_macro_left2 = e2 = ((AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.spark().read().schema(schema).jdbc(this.urlWithUserAndPass(), "TEST.PEOPLE", new Properties()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1380))))).getMessage();
            String $org_scalatest_assert_macro_right2 = "User specified schema not supported with `jdbc`";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1383));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1371));
        this.test("jdbc API support custom schema", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String[] parts = (String[])((Object[])new String[]{"THEID < 2", "THEID >= 2"});
            String customSchema = "NAME VARCHAR(32), THEID INT";
            Properties props = new Properties();
            props.put("customSchema", customSchema);
            Dataset df = this.spark().read().jdbc(this.urlWithUserAndPass(), "TEST.PEOPLE", parts, props);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)df.schema().size()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1392));
            StructType structType = CatalystSqlParser$.MODULE$.parseTableSchema(customSchema);
            StructType expectedSchema = new StructType((StructField[])((TraversableOnce)structType.map((Function1 & Serializable & scala.Serializable)f -> new StructField(f.name(), f.dataType(), f.nullable(), this.defaultMetadata(f.dataType())), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(StructField.class)));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(df.schema());
            StructType $org_scalatest_assert_macro_right2 = CharVarcharUtils$.MODULE$.replaceCharVarcharWithStringInSchema(expectedSchema);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1396));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)df.count()));
            int $org_scalatest_assert_macro_right3 = 3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1397));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1386));
        this.test("jdbc API custom schema DDL-like strings.", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"people_view"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String customSchema = "NAME VARCHAR(32), THEID INT";
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(218).append("\n           |CREATE TEMPORARY VIEW people_view\n           |USING org.apache.spark.sql.jdbc\n           |OPTIONS (uRl '").append(this.url()).append("', DbTaBlE 'TEST.PEOPLE', User 'testUser', PassWord 'testPass',\n           |customSchema '").append(customSchema).append("')\n        ").toString())).stripMargin().replaceAll("\n", " "));
            Dataset df = (Dataset)this.sql().apply((Object)"select * from people_view");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)df.schema().length()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1411));
            StructType expectedSchema = new StructType((StructField[])((TraversableOnce)CatalystSqlParser$.MODULE$.parseTableSchema(customSchema).map((Function1 & Serializable & scala.Serializable)f -> new StructField(f.name(), f.dataType(), f.nullable(), this.defaultMetadata(f.dataType())), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(StructField.class)));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(df.schema());
            StructType $org_scalatest_assert_macro_right2 = CharVarcharUtils$.MODULE$.replaceCharVarcharWithStringInSchema(expectedSchema);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1415));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)df.count()));
            int $org_scalatest_assert_macro_right3 = 3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1416));
        }), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1400));
        this.test("SPARK-15648: teradataDialect StringType data mapping", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            JdbcDialect teradataDialect = JdbcDialects$.MODULE$.get("jdbc:teradata://127.0.0.1/db");
            String $org_scalatest_assert_macro_left = (String)teradataDialect.getJDBCType((DataType)StringType$.MODULE$).map((Function1 & Serializable & scala.Serializable)x$35 -> x$35.databaseTypeDefinition()).get();
            String $org_scalatest_assert_macro_right = "VARCHAR(255)";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1422));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1420));
        this.test("SPARK-15648: teradataDialect BooleanType data mapping", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            JdbcDialect teradataDialect = JdbcDialects$.MODULE$.get("jdbc:teradata://127.0.0.1/db");
            String $org_scalatest_assert_macro_left = (String)teradataDialect.getJDBCType((DataType)BooleanType$.MODULE$).map((Function1 & Serializable & scala.Serializable)x$36 -> x$36.databaseTypeDefinition()).get();
            String $org_scalatest_assert_macro_right = "CHAR(1)";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1428));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1426));
        this.test("SPARK-38846: TeradataDialect catalyst type mapping", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            JdbcDialect teradataDialect = JdbcDialects$.MODULE$.get("jdbc:teradata");
            MetadataBuilder metadata = new MetadataBuilder().putString("name", "test_column").putLong("scale", 0L);
            int flexiblePrecision = 40;
            Option $org_scalatest_assert_macro_left = teradataDialect.getCatalystType(2, "NUMBER", flexiblePrecision, metadata);
            Some $org_scalatest_assert_macro_right = new Some((Object)DecimalType$.MODULE$.SYSTEM_DEFAULT());
            Option option = $org_scalatest_assert_macro_left;
            Some some = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1437));
            int specifiedScale = 10;
            int specifiedPrecision = 10;
            metadata.putLong("scale", (long)specifiedScale);
            Option $org_scalatest_assert_macro_left2 = teradataDialect.getCatalystType(2, "NUMBER", specifiedPrecision, metadata);
            Some $org_scalatest_assert_macro_right2 = new Some((Object)new DecimalType(specifiedPrecision, specifiedScale));
            Option option2 = $org_scalatest_assert_macro_left2;
            Some some2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(option2 != null ? !option2.equals(some2) : some2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1443));
            Option $org_scalatest_assert_macro_left3 = teradataDialect.getCatalystType(2, "NUMBER", flexiblePrecision, metadata);
            Some $org_scalatest_assert_macro_right3 = new Some((Object)new DecimalType(DecimalType$.MODULE$.MAX_PRECISION(), specifiedScale));
            Option option3 = $org_scalatest_assert_macro_left3;
            Some some3 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(option3 != null ? !option3.equals(some3) : some3 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1446));
            metadata.putLong("scale", 0L);
            Option $org_scalatest_assert_macro_left4 = teradataDialect.getCatalystType(2, "NUMBER", specifiedPrecision, metadata);
            Some $org_scalatest_assert_macro_right4 = new Some((Object)new DecimalType(specifiedPrecision, 0));
            Option option4 = $org_scalatest_assert_macro_left4;
            Some some4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(option4 != null ? !option4.equals(some4) : some4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1450));
            Option $org_scalatest_assert_macro_left5 = teradataDialect.getCatalystType(2, "NUMBER", specifiedPrecision, null);
            Some $org_scalatest_assert_macro_right5 = new Some((Object)DecimalType$.MODULE$.SYSTEM_DEFAULT());
            Option option5 = $org_scalatest_assert_macro_left5;
            Some some5 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(option5 != null ? !option5.equals(some5) : some5 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1453));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1432));
        this.test("Checking metrics correctness with JDBC", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            long foobarCnt = this.spark().table("foobar").count();
            List<Tuple3<Object, Object, Object>> res = InputOutputMetricsHelper$.MODULE$.run((Dataset<Row>)((Dataset)this.sql().apply((Object)"SELECT * FROM foobar")).toDF());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(res);
            Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToLong((long)foobarCnt), (Object)BoxesRunTime.boxToLong((long)0L), (Object)BoxesRunTime.boxToLong((long)foobarCnt));
            List $org_scalatest_assert_macro_right = Nil$.MODULE$.$colon$colon((Object)tuple3);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1460));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1457));
        this.test("unsupported types", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkSQLException x$11 = (SparkSQLException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Row[])this.spark().read().jdbc(this.urlWithUserAndPass(), "TEST.TIMEZONE", new Properties()).collect(), ClassTag$.MODULE$.apply(SparkSQLException.class), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1465));
            String x$12 = "UNRECOGNIZED_SQL_TYPE";
            scala.collection.immutable.Map x$13 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"typeName"), (Object)"TIMESTAMP WITH TIME ZONE"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"jdbcType"), (Object)"TIMESTAMP_WITH_TIMEZONE")}));
            Option x$14 = this.checkError$default$3();
            boolean x$15 = this.checkError$default$5();
            QueryContext[] x$16 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$11, x$12, x$14, x$13, x$15, x$16);
            SparkSQLException x$17 = (SparkSQLException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Row[])this.spark().read().jdbc(this.urlWithUserAndPass(), "TEST.ARRAY_TABLE", new Properties()).collect(), ClassTag$.MODULE$.apply(SparkSQLException.class), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1472));
            String x$18 = "UNRECOGNIZED_SQL_TYPE";
            scala.collection.immutable.Map x$19 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"typeName"), (Object)"INTEGER ARRAY"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"jdbcType"), (Object)"ARRAY")}));
            Option x$20 = this.checkError$default$3();
            boolean x$21 = this.checkError$default$5();
            QueryContext[] x$22 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$17, x$18, x$20, x$19, x$21, x$22);
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1463));
        this.test("SPARK-19318: Connection properties keys should be case-sensitive.", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            scala.collection.immutable.Map parameters = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"url"), (Object)this.url()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dbTAblE"), (Object)"t1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"customKey"), (Object)"a-value")}));
            JDBCSuite.testJdbcOptions$1(new JDBCOptions(parameters));
            JDBCSuite.testJdbcOptions$1(new JDBCOptions(CaseInsensitiveMap$.MODULE$.apply(parameters)));
            CaseInsensitiveMap modifiedParameters = CaseInsensitiveMap$.MODULE$.apply(Predef$.MODULE$.Map().empty()).$plus$plus((TraversableOnce)parameters);
            JDBCSuite.testJdbcOptions$1(new JDBCOptions((scala.collection.immutable.Map)modifiedParameters));
            modifiedParameters = (scala.collection.immutable.Map)modifiedParameters.$minus((Object)"dbtable");
            Option $org_scalatest_assert_macro_left = modifiedParameters.get((Object)"dbTAblE");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1500));
            modifiedParameters = (scala.collection.immutable.Map)modifiedParameters.$minus((Object)"customkey");
            Option $org_scalatest_assert_macro_left2 = modifiedParameters.get((Object)"customKey");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1502));
            modifiedParameters = modifiedParameters.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"customKey"), (Object)"a-value"));
            modifiedParameters = modifiedParameters.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dbTable"), (Object)"t1"));
            JDBCSuite.testJdbcOptions$1(new JDBCOptions((scala.collection.immutable.Map)modifiedParameters));
            scala.collection.immutable.Map $org_scalatest_assert_macro_left3 = (scala.collection.immutable.Map)modifiedParameters.$minus$minus((GenTraversableOnce)parameters.keys());
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1506));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1479));
        this.test("SPARK-19318: jdbc data source options should be treated case-insensitive.", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Dataset df = this.spark().read().format("jdbc").option("Url", this.urlWithUserAndPass()).option("DbTaBle", "TEST.PEOPLE").load();
            long $org_scalatest_assert_macro_left = df.count();
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1514));
            this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"people_view"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(186).append("\n          |CREATE TEMPORARY VIEW people_view\n          |USING org.apache.spark.sql.jdbc\n          |OPTIONS (uRl '").append(this.url()).append("', DbTaBlE 'TEST.PEOPLE', User 'testUser', PassWord 'testPass')\n        ").toString())).stripMargin().replaceAll("\n", " "));
                long $org_scalatest_assert_macro_left = ((Dataset)this.sql().apply((Object)"select * from people_view")).count();
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1524));
            });
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1509));
        this.test("SPARK-21519: option sessionInitStatement, run SQL to initialize the database session.", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String e;
            String initSQL1 = "SET @MYTESTVAR 21519";
            Dataset df1 = this.spark().read().format("jdbc").option("url", this.urlWithUserAndPass()).option("dbtable", "(SELECT NVL(@MYTESTVAR, -1))").option("sessionInitStatement", initSQL1).load();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(df1.collect());
            Row[] $org_scalatest_assert_macro_right = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)21519)}))});
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1535));
            String initSQL2 = "SET SCHEMA DUMMY";
            Dataset df2 = this.spark().read().format("jdbc").option("url", this.urlWithUserAndPass()).option("dbtable", "TEST.PEOPLE").option("sessionInitStatement", initSQL2).load();
            String $org_scalatest_assert_macro_left2 = e = ((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Row[])df2.collect(), ClassTag$.MODULE$.apply(SparkException.class), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1543))).getMessage();
            String $org_scalatest_assert_macro_right2 = "Schema \"DUMMY\" not found";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1544));
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(297).append("\n         |CREATE OR REPLACE TEMPORARY VIEW test_sessionInitStatement\n         |USING org.apache.spark.sql.jdbc\n         |OPTIONS (url '").append(this.urlWithUserAndPass()).append("',\n         |dbtable '(SELECT NVL(@MYTESTVAR1, -1), NVL(@MYTESTVAR2, -1))',\n         |sessionInitStatement 'SET @MYTESTVAR1 21519; SET @MYTESTVAR2 1234')\n       ").toString())).stripMargin());
            Dataset df3 = (Dataset)this.sql().apply((Object)"SELECT * FROM test_sessionInitStatement");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(df3.collect());
            Row[] $org_scalatest_assert_macro_right3 = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)21519), BoxesRunTime.boxToInteger((int)1234)}))});
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1556));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1528));
        this.test("jdbc data source shouldn't have unnecessary metadata in its schema", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ObjectRef schema = ObjectRef.create((Object)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("NAME", (DataType)new VarcharType(32), true, this.defaultMetadata((DataType)new VarcharType(32))), (List)new .colon.colon((Object)new StructField("THEID", (DataType)IntegerType$.MODULE$, true, this.defaultMetadata((DataType)IntegerType$.MODULE$)), (List)Nil$.MODULE$))));
            schema.elem = CharVarcharUtils$.MODULE$.replaceCharVarcharWithStringInSchema((StructType)schema.elem);
            Dataset df = this.spark().read().format("jdbc").option("Url", this.urlWithUserAndPass()).option("DbTaBle", "TEST.PEOPLE").load();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(df.schema());
            StructType $org_scalatest_assert_macro_right = (StructType)schema.elem;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1568));
            this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"people_view"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(186).append("\n          |CREATE TEMPORARY VIEW people_view\n          |USING org.apache.spark.sql.jdbc\n          |OPTIONS (uRl '").append(this.url()).append("', DbTaBlE 'TEST.PEOPLE', User 'testUser', PassWord 'testPass')\n        ").toString())).stripMargin().replaceAll("\n", " "));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(((Dataset)this.sql().apply((Object)"select * from people_view")).schema());
                StructType $org_scalatest_assert_macro_right = (StructType)schema$2.elem;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1578));
            });
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1559));
        this.test("SPARK-23856 Spark jdbc setQueryTimeout option", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String errMsg;
            int numJoins = 100;
            String longRunningQuery = new StringBuilder(43).append("SELECT t0.NAME AS c0, ").append(((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numJoins).map((Function1 & Serializable & scala.Serializable)i -> JDBCSuite.$anonfun$new$165(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).mkString(", ")).append(" ").append("FROM test.people t0 ").append(((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numJoins).map((Function1 & Serializable & scala.Serializable)i -> JDBCSuite.$anonfun$new$166(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).mkString(" ")).toString();
            Dataset df = this.spark().read().format("jdbc").option("Url", this.urlWithUserAndPass()).option("dbtable", new StringBuilder(2).append("(").append(longRunningQuery).append(")").toString()).option("queryTimeout", 1L).load();
            String $org_scalatest_assert_macro_left = errMsg = ((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Row[])df.collect(), ClassTag$.MODULE$.apply(SparkException.class), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1592))).getMessage();
            String $org_scalatest_assert_macro_right = "Statement was canceled or the session timed out";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1595));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1582));
        this.test("SPARK-24327 verify and normalize a partition column based on a JDBC resolved schema", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.testJdbcPartitionColumn$1("THEID", "THEID");
            this.testJdbcPartitionColumn$1("\"THEID\"", "THEID");
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testJdbcPartitionColumn$1("ThEiD", "THEID"));
            this.testJdbcPartitionColumn$1("THE ID", "THE ID");
            this.testIncorrectJdbcPartitionColumn$1("NoExistingColumn");
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testIncorrectJdbcPartitionColumn$1(this.testH2Dialect().quoteIdentifier("ThEiD")));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1598));
        this.test("query JDBC option - negative tests", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String e5;
            String e4;
            String e3;
            String e2;
            String e1;
            String query = "SELECT * FROM  test.people WHERE theid = 1";
            String $org_scalatest_assert_macro_left = e1 = ((Throwable)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Dataset df = this.spark().read().format("jdbc").option("Url", this.urlWithUserAndPass()).option("query", query).option("dbtable", "test.people").load();
            }, ClassTag$.MODULE$.apply(RuntimeException.class), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1644))).getMessage();
            String $org_scalatest_assert_macro_right = "Both 'dbtable' and 'query' can not be specified at the same time.";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1651));
            Properties properties = new Properties();
            properties.setProperty(JDBCOptions$.MODULE$.JDBC_QUERY_STRING(), query);
            String $org_scalatest_assert_macro_left2 = e2 = ((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Row[])this.spark().read().jdbc(this.urlWithUserAndPass(), "TEST.PEOPLE", properties).collect(), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1656))).getMessage();
            String $org_scalatest_assert_macro_right2 = "Both 'dbtable' and 'query' can not be specified at the same time.";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1659));
            String $org_scalatest_assert_macro_left3 = e3 = ((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(222).append("\n         |CREATE OR REPLACE TEMPORARY VIEW queryOption\n         |USING org.apache.spark.sql.jdbc\n         |OPTIONS (url '").append(this.url()).append("', query '").append(query).append("', dbtable 'TEST.PEOPLE',\n         |         user 'testUser', password 'testPass')\n       ").toString())).stripMargin().replaceAll("\n", " ")), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1661))).getMessage();
            String $org_scalatest_assert_macro_right3 = "Both 'dbtable' and 'query' can not be specified at the same time.";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1670));
            String $org_scalatest_assert_macro_left4 = e4 = ((Throwable)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Dataset df = this.spark().read().format("jdbc").option("Url", this.urlWithUserAndPass()).option("query", "").load();
            }, ClassTag$.MODULE$.apply(RuntimeException.class), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1672))).getMessage();
            String $org_scalatest_assert_macro_right4 = "Option `query` can not be empty.";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.contains($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1678));
            String expectedErrorMsg = new StringOps(Predef$.MODULE$.augmentString("\n         |Options 'query' and 'partitionColumn' can not be specified together.\n         |Please define the query using `dbtable` option instead and make sure to qualify\n         |the partition columns using the supplied subquery alias to resolve any ambiguity.\n         |Example :\n         |spark.read.format(\"jdbc\")\n         |  .option(\"url\", jdbcUrl)\n         |  .option(\"dbtable\", \"(select c1, c2 from t1) as subq\")\n         |  .option(\"partitionColumn\", \"c1\")\n         |  .option(\"lowerBound\", \"1\")\n         |  .option(\"upperBound\", \"100\")\n         |  .option(\"numPartitions\", \"3\")\n         |  .load()\n     ")).stripMargin();
            String $org_scalatest_assert_macro_left5 = e5 = ((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(283).append("\n           |CREATE OR REPLACE TEMPORARY VIEW queryOption\n           |USING org.apache.spark.sql.jdbc\n           |OPTIONS (url '").append(this.url()).append("', query '").append(query).append("', user 'testUser', password 'testPass',\n           |         partitionColumn 'THEID', lowerBound '1', upperBound '4', numPartitions '3')\n       ").toString())).stripMargin().replaceAll("\n", " ")), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1696))).getMessage();
            String $org_scalatest_assert_macro_right5 = expectedErrorMsg;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.contains($org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1705));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1641));
        this.test("query JDBC option", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String query = "SELECT name, theid FROM  test.people WHERE theid = 1";
            Dataset df = this.spark().read().format("jdbc").option("Url", this.urlWithUserAndPass()).option("query", query).load();
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"fred", BoxesRunTime.boxToInteger((int)1)}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> df, (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row));
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(180).append("\n         |CREATE OR REPLACE TEMPORARY VIEW queryOption\n         |USING org.apache.spark.sql.jdbc\n         |OPTIONS (url '").append(this.url()).append("', query '").append(query).append("', user 'testUser', password 'testPass')\n       ").toString())).stripMargin().replaceAll("\n", " "));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"fred", BoxesRunTime.boxToInteger((int)1)}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"select name, theid from queryOption"), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row2));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1708));
        this.test("SPARK-22814 support date/timestamp types in partitionColumn", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalRelation logicalRelation;
            BaseRelation baseRelation;
            LogicalRelation logicalRelation2;
            BaseRelation baseRelation2;
            Seq expectedResult = (Seq)((TraversableLike)new .colon.colon((Object)new Tuple2((Object)"2018-07-06", (Object)"2018-07-06 05:50:00.0"), (List)new .colon.colon((Object)new Tuple2((Object)"2018-07-06", (Object)"2018-07-06 08:10:08.0"), (List)new .colon.colon((Object)new Tuple2((Object)"2018-07-08", (Object)"2018-07-08 13:32:01.0"), (List)new .colon.colon((Object)new Tuple2((Object)"2018-07-12", (Object)"2018-07-12 09:51:15.0"), (List)Nil$.MODULE$))))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    String date = (String)tuple2._1();
                    String timestamp = (String)tuple2._2();
                    return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{java.sql.Date.valueOf(date), Timestamp.valueOf(timestamp)}));
                }
                throw new MatchError((Object)tuple2);
            }, Seq$.MODULE$.canBuildFrom());
            Dataset df1 = this.spark().read().format("jdbc").option("url", this.urlWithUserAndPass()).option("dbtable", "TEST.DATETIME").option("partitionColumn", "d").option("lowerBound", "2018-07-06").option("upperBound", "2018-07-20").option("numPartitions", 3L).load();
            LogicalPlan logicalPlan = df1.logicalPlan();
            if (!(logicalPlan instanceof LogicalRelation) || !((baseRelation2 = (logicalRelation2 = (LogicalRelation)logicalPlan).relation()) instanceof JDBCRelation)) {
                throw new MatchError((Object)logicalPlan);
            }
            JDBCRelation jDBCRelation = (JDBCRelation)baseRelation2;
            Partition[] parts = jDBCRelation.parts();
            Set whereClauses = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parts)).map((Function1 & Serializable & scala.Serializable)x$41 -> ((JDBCPartition)x$41).whereClause(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSet();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(whereClauses);
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\"D\" < '2018-07-11' or \"D\" is null", "\"D\" >= '2018-07-11' AND \"D\" < '2018-07-15'", "\"D\" >= '2018-07-15'"}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1755));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> df1, (Seq<Row>)expectedResult);
            Dataset df2 = this.spark().read().format("jdbc").option("url", this.urlWithUserAndPass()).option("dbtable", "TEST.DATETIME").option("partitionColumn", "t").option("lowerBound", "2018-07-04 03:30:00.0").option("upperBound", "2018-07-27 14:11:05.0").option("numPartitions", 2L).load();
            LogicalPlan logicalPlan2 = df2.logicalPlan();
            if (!(logicalPlan2 instanceof LogicalRelation) || !((baseRelation = (logicalRelation = (LogicalRelation)logicalPlan2).relation()) instanceof JDBCRelation)) {
                throw new MatchError((Object)logicalPlan2);
            }
            JDBCRelation jDBCRelation2 = (JDBCRelation)baseRelation;
            Partition[] parts2 = jDBCRelation2.parts();
            Set whereClauses2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parts2)).map((Function1 & Serializable & scala.Serializable)x$42 -> ((JDBCPartition)x$42).whereClause(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSet();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(whereClauses2);
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\"T\" < '2018-07-15 20:50:32.5' or \"T\" is null", "\"T\" >= '2018-07-15 20:50:32.5'"}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1775));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> df2, (Seq<Row>)expectedResult);
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1732));
        this.test("throws an exception for unsupported partition column types", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String errMsg;
            String $org_scalatest_assert_macro_left = errMsg = ((AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.spark().read().format("jdbc").option("url", this.urlWithUserAndPass()).option("dbtable", "TEST.PEOPLE").option("partitionColumn", "name").option("lowerBound", "aaa").option("upperBound", "zzz").option("numPartitions", 2L).load(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1783))))).getMessage();
            String $org_scalatest_assert_macro_right = "Partition column type should be numeric, date, or timestamp, but string found.";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1793));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1782));
        this.test("SPARK-24288: Enable preventing predicate pushdown", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String table = "test.people";
            Dataset df = this.spark().read().format("jdbc").option("Url", this.urlWithUserAndPass()).option("dbTable", table).option("pushDownPredicate", false).load().filter("theid = 1").select("name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"theid"}));
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"fred", BoxesRunTime.boxToInteger((int)1)}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> this.checkNotPushdown((Dataset<Row>)df), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row));
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(175).append("\n         |CREATE OR REPLACE TEMPORARY VIEW predicateOption\n         |USING org.apache.spark.sql.jdbc\n         |OPTIONS (url '").append(this.urlWithUserAndPass()).append("', dbTable '").append(table).append("', pushDownPredicate 'false')\n       ").toString())).stripMargin().replaceAll("\n", " "));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"fred", BoxesRunTime.boxToInteger((int)1)}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> this.checkNotPushdown((Dataset<Row>)((Dataset)this.sql().apply((Object)"SELECT name, theid FROM predicateOption WHERE theid = 1"))), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row2));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1797));
        this.test("SPARK-36574: pushDownPredicate=false should prevent push down filters to JDBC data source", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            DataFrameReader df = this.spark().read().format("jdbc").option("Url", this.urlWithUserAndPass()).option("dbTable", "test.people");
            Dataset df1 = df.option("pushDownPredicate", false).load().filter("theid = 1").select("name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"theid"}));
            Dataset df2 = df.option("pushDownPredicate", true).load().filter("theid = 1").select("name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"theid"}));
            Dataset df3 = df.load().select("name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"theid"}));
            long $org_scalatest_assert_macro_left = this.getRowCount$1(df1);
            long $org_scalatest_assert_macro_right = df3.count();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1853));
            long $org_scalatest_assert_macro_left2 = this.getRowCount$1(df2);
            long $org_scalatest_assert_macro_right2 = df3.count();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "<", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 < $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1854));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1824));
        this.test("SPARK-26383 throw IllegalArgumentException if wrong kind of driver to the given url", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String e;
            String $org_scalatest_assert_macro_left = e = ((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> {
                scala.collection.immutable.Map opts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"url"), (Object)"jdbc:mysql://localhost/db"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dbtable"), (Object)"table"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"driver"), (Object)"org.postgresql.Driver")}));
                return this.spark().read().format("jdbc").options((Map)opts).load();
            }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1858))).getMessage();
            String $org_scalatest_assert_macro_right = "The driver could not open a JDBC connection. Check the URL: jdbc:mysql://localhost/db";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1866));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1857));
        this.test("support casting patterns for lower/upper bounds of TimestampType", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DateTimeTestUtils$.MODULE$.outstandingTimezonesIds().foreach((Function1 & Serializable & scala.Serializable)timeZone -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key()), (Object)timeZone)}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)new Tuple3((Object)"1972-07-04 03:30:00", (Object)"1972-07-15 20:50:32.5", (Object)"1972-07-27 14:11:05"), (List)new .colon.colon((Object)new Tuple3((Object)"2019-01-20 12:00:00.502", (Object)"2019-01-20 12:00:00.751", (Object)"2019-01-20 12:00:01.000"), (List)new .colon.colon((Object)new Tuple3((Object)"2019-01-20T00:00:00.123456", (Object)"2019-01-20 00:05:00.123456", (Object)"2019-01-20T00:10:00.123456"), (List)new .colon.colon((Object)new Tuple3((Object)"1500-01-20T00:00:00.123456", (Object)"1500-01-20 00:05:00.123456", (Object)"1500-01-20T00:10:00.123456"), (List)Nil$.MODULE$))))).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple3 tuple3 = x0$3;
                if (tuple3 != null) {
                    LogicalRelation logicalRelation;
                    String lower = (String)tuple3._1();
                    String middle = (String)tuple3._2();
                    String upper = (String)tuple3._3();
                    Dataset df = $this.spark().read().format("jdbc").option("url", $this.urlWithUserAndPass()).option("dbtable", "TEST.DATETIME").option("partitionColumn", "t").option("lowerBound", lower).option("upperBound", upper).option("numPartitions", 2L).load();
                    LogicalPlan logicalPlan = df.logicalPlan();
                    if (logicalPlan instanceof LogicalRelation && (logicalRelation = (LogicalRelation)logicalPlan).relation() instanceof JDBCRelation) {
                        JDBCRelation jdbcRelation = (JDBCRelation)logicalRelation.relation();
                        String[] whereClauses = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])jdbcRelation.parts())).map((Function1 & Serializable & scala.Serializable)x$45 -> ((JDBCPartition)x$45).whereClause(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])whereClauses)).toSet());
                        Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(23).append("\"T\" < '").append(middle).append("' or \"T\" is null").toString(), new StringBuilder(9).append("\"T\" >= '").append(middle).append("'").toString()}));
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1893));
                    }
                    throw new MatchError((Object)logicalPlan);
                }
                throw new MatchError((Object)tuple3);
            }));
            return BoxedUnit.UNIT;
        }), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1870));
        this.test("Add exception when isolationLevel is Illegal", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String e;
            String $org_scalatest_assert_macro_left = e = ((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.spark().read().format("jdbc").option("Url", this.urlWithUserAndPass()).option("dbTable", "test.people").option("isolationLevel", "test").load(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1903))).getMessage();
            String $org_scalatest_assert_macro_right = "Invalid value `test` for parameter `isolationLevel`. This can be `NONE`, `READ_UNCOMMITTED`, `READ_COMMITTED`, `REPEATABLE_READ` or `SERIALIZABLE`.";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1910));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1902));
        this.test("SPARK-28552: Case-insensitive database URLs in JdbcDialect", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(JdbcDialects$.MODULE$.get("jdbc:mysql://localhost/db"));
            MySQLDialect$ $org_scalatest_assert_macro_right = MySQLDialect$.MODULE$;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1916));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(JdbcDialects$.MODULE$.get("jdbc:MySQL://localhost/db"));
            MySQLDialect$ $org_scalatest_assert_macro_right2 = MySQLDialect$.MODULE$;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1917));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(JdbcDialects$.MODULE$.get("jdbc:postgresql://localhost/db"));
            PostgresDialect$ $org_scalatest_assert_macro_right3 = PostgresDialect$.MODULE$;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1918));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(JdbcDialects$.MODULE$.get("jdbc:postGresql://localhost/db"));
            PostgresDialect$ $org_scalatest_assert_macro_right4 = PostgresDialect$.MODULE$;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1919));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(JdbcDialects$.MODULE$.get("jdbc:db2://localhost/db"));
            DB2Dialect$ $org_scalatest_assert_macro_right5 = DB2Dialect$.MODULE$;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1920));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(JdbcDialects$.MODULE$.get("jdbc:DB2://localhost/db"));
            DB2Dialect$ $org_scalatest_assert_macro_right6 = DB2Dialect$.MODULE$;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1921));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(JdbcDialects$.MODULE$.get("jdbc:sqlserver://localhost/db"));
            MsSqlServerDialect$ $org_scalatest_assert_macro_right7 = MsSqlServerDialect$.MODULE$;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1922));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(JdbcDialects$.MODULE$.get("jdbc:sqlServer://localhost/db"));
            MsSqlServerDialect$ $org_scalatest_assert_macro_right8 = MsSqlServerDialect$.MODULE$;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1923));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(JdbcDialects$.MODULE$.get("jdbc:derby://localhost/db"));
            DerbyDialect$ $org_scalatest_assert_macro_right9 = DerbyDialect$.MODULE$;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1924));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(JdbcDialects$.MODULE$.get("jdbc:derBy://localhost/db"));
            DerbyDialect$ $org_scalatest_assert_macro_right10 = DerbyDialect$.MODULE$;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1925));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(JdbcDialects$.MODULE$.get("jdbc:oracle://localhost/db"));
            OracleDialect$ $org_scalatest_assert_macro_right11 = OracleDialect$.MODULE$;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)$org_scalatest_assert_macro_right11, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1926));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.convertToEqualizer(JdbcDialects$.MODULE$.get("jdbc:Oracle://localhost/db"));
            OracleDialect$ $org_scalatest_assert_macro_right12 = OracleDialect$.MODULE$;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)$org_scalatest_assert_macro_right12, $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)$org_scalatest_assert_macro_right12, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1927));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left13 = this.convertToEqualizer(JdbcDialects$.MODULE$.get("jdbc:teradata://localhost/db"));
            TeradataDialect$ $org_scalatest_assert_macro_right13 = TeradataDialect$.MODULE$;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "===", (Object)$org_scalatest_assert_macro_right13, $org_scalatest_assert_macro_left13.$eq$eq$eq((Object)$org_scalatest_assert_macro_right13, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1928));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left14 = this.convertToEqualizer(JdbcDialects$.MODULE$.get("jdbc:Teradata://localhost/db"));
            TeradataDialect$ $org_scalatest_assert_macro_right14 = TeradataDialect$.MODULE$;
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "===", (Object)$org_scalatest_assert_macro_right14, $org_scalatest_assert_macro_left14.$eq$eq$eq((Object)$org_scalatest_assert_macro_right14, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1929));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1915));
        this.test("SQLContext.jdbc (deprecated)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SQLContext sqlContext = this.spark().sqlContext();
            ObjectRef jdbcDF = ObjectRef.create((Object)sqlContext.jdbc(this.urlWithUserAndPass(), "TEST.PEOPLE"));
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"fred", BoxesRunTime.boxToInteger((int)1)}));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"mary", BoxesRunTime.boxToInteger((int)2)}));
            Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"joe 'foo' \"bar\"", BoxesRunTime.boxToInteger((int)3)}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)jdbcDF$1.elem, (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row3).$colon$colon((Object)row2).$colon$colon((Object)row));
            jdbcDF.elem = sqlContext.jdbc(this.urlWithUserAndPass(), "TEST.PEOPLE", "THEID", 0L, 4L, 3);
            this.checkNumPartitions((Dataset<Row>)((Dataset)jdbcDF.elem), 3);
            Row row4 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"fred", BoxesRunTime.boxToInteger((int)1)}));
            Row row5 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"mary", BoxesRunTime.boxToInteger((int)2)}));
            Row row6 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"joe 'foo' \"bar\"", BoxesRunTime.boxToInteger((int)3)}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)jdbcDF$1.elem, (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row6).$colon$colon((Object)row5).$colon$colon((Object)row4));
            String[] parts = (String[])((Object[])new String[]{"THEID = 2"});
            jdbcDF.elem = sqlContext.jdbc(this.urlWithUserAndPass(), "TEST.PEOPLE", parts);
            Row row7 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"mary", BoxesRunTime.boxToInteger((int)2)}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)jdbcDF$1.elem, (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row7));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1932));
        this.test("SPARK-32364: JDBCOption constructor", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            CaseInsensitiveMap params;
            CaseInsensitiveMap extraOptions = CaseInsensitiveMap$.MODULE$.apply((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"UrL"), (Object)"url1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dBTable"), (Object)"table1")})));
            Properties connectionProperties = new Properties();
            connectionProperties.put("url", "url2");
            connectionProperties.put("dbtable", "table2");
            CaseInsensitiveMap $org_scalatest_assert_macro_left = params = extraOptions.$plus$plus((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(connectionProperties).asScala());
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1954));
            Option $org_scalatest_assert_macro_left2 = params.get("uRl");
            String $org_scalatest_assert_macro_right2 = "url2";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1955));
            Option $org_scalatest_assert_macro_left3 = params.get("DbtaBle");
            String $org_scalatest_assert_macro_right3 = "table2";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1956));
            JDBCOptions options = new JDBCOptions(this.url(), "table3", (scala.collection.immutable.Map)params);
            Properties $org_scalatest_assert_macro_left4 = options.asProperties();
            int $org_scalatest_assert_macro_right4 = 2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1960));
            Object $org_scalatest_assert_macro_left5 = options.asProperties().get("url");
            String $org_scalatest_assert_macro_right5 = this.url();
            Object object = $org_scalatest_assert_macro_left5;
            String string = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(object != null ? !object.equals(string) : string != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1961));
            Object $org_scalatest_assert_macro_left6 = options.asProperties().get("dbtable");
            String $org_scalatest_assert_macro_right6 = "table3";
            Object object2 = $org_scalatest_assert_macro_left6;
            String string2 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(object2 != null ? !object2.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1962));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1946));
        this.test("SPARK-34379: Map JDBC RowID to StringType rather than LongType", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            ResultSetMetaData mockRsmd = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
            Mockito.when((Object)BoxesRunTime.boxToInteger((int)mockRsmd.getColumnCount())).thenReturn((Object)BoxesRunTime.boxToInteger((int)1));
            Mockito.when((Object)mockRsmd.getColumnLabel(ArgumentMatchers.anyInt())).thenReturn((Object)"rowid");
            Mockito.when((Object)BoxesRunTime.boxToInteger((int)mockRsmd.getColumnType(ArgumentMatchers.anyInt()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)-8));
            Mockito.when((Object)mockRsmd.getColumnTypeName(ArgumentMatchers.anyInt())).thenReturn((Object)"rowid");
            Mockito.when((Object)BoxesRunTime.boxToInteger((int)mockRsmd.getPrecision(ArgumentMatchers.anyInt()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)0));
            Mockito.when((Object)BoxesRunTime.boxToInteger((int)mockRsmd.getScale(ArgumentMatchers.anyInt()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)0));
            Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)mockRsmd.isSigned(ArgumentMatchers.anyInt()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
            Mockito.when((Object)BoxesRunTime.boxToInteger((int)mockRsmd.isNullable(ArgumentMatchers.anyInt()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)0));
            ResultSet mockRs = (ResultSet)Mockito.mock(ResultSet.class);
            Mockito.when((Object)mockRs.getMetaData()).thenReturn((Object)mockRsmd);
            JdbcDialect mockDialect = (JdbcDialect)Mockito.mock(JdbcDialect.class);
            Mockito.when((Object)mockDialect.getCatalystType(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString(), ArgumentMatchers.anyInt(), (MetadataBuilder)ArgumentMatchers.any())).thenReturn((Object)None$.MODULE$);
            StructType schema = JdbcUtils$.MODULE$.getSchema(mockRs, mockDialect, JdbcUtils$.MODULE$.getSchema$default$3(), JdbcUtils$.MODULE$.getSchema$default$4());
            StructField[] fields = schema.fields();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)fields.length));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1985));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(fields[0].dataType());
            StringType$ $org_scalatest_assert_macro_right2 = StringType$.MODULE$;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1986));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1965));
        this.test("SPARK-39339: Handle TimestampNTZType null values", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tableName = "timestamp_ntz_null_table";
            Dataset df = this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon(null, (List)Nil$.MODULE$), this.testImplicits().newLocalDateTimeEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}));
            df.write().format("jdbc").option("url", this.urlWithUserAndPass()).option("dbtable", tableName).save();
            DataFrameReader readDf = this.spark().read().format("jdbc").option("url", this.urlWithUserAndPass()).option("dbtable", tableName);
            Seq timestampTypes = (Seq)new .colon.colon((Object)SQLConf.TimestampTypes$.MODULE$.TIMESTAMP_NTZ().toString(), (List)new .colon.colon((Object)SQLConf.TimestampTypes$.MODULE$.TIMESTAMP_LTZ().toString(), (List)Nil$.MODULE$));
            timestampTypes.foreach((Function1 & Serializable & scala.Serializable)timestampType -> {
                JDBCSuite.$anonfun$new$211(this, readDf, timestampType);
                return BoxedUnit.UNIT;
            });
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1989));
        this.test("SPARK-39339: TimestampNTZType with different local time zones", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tableName = "timestamp_ntz_diff_tz_support_table";
            DateTimeTestUtils$.MODULE$.outstandingZoneIds().foreach((Function1 & Serializable & scala.Serializable)zoneId -> {
                DateTimeTestUtils$.MODULE$.withDefaultTimeZone(zoneId, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"1972-07-04 03:30:00", (List)new .colon.colon((Object)"2019-01-20 12:00:00.502", (List)new .colon.colon((Object)"2019-01-20T00:00:00.123456", (List)new .colon.colon((Object)"1500-01-20T00:00:00.123456", (List)Nil$.MODULE$))))).foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
                    JDBCSuite.$anonfun$new$218($this, tableName$4, x0$4);
                    return BoxedUnit.UNIT;
                }));
                return BoxedUnit.UNIT;
            });
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2024));
        this.test("SPARK-41990: Filter with composite name", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Dataset df = (Dataset)this.sql().apply((Object)"SELECT * FROM composite_name WHERE `last name` = 'smith'");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.collect())).toSet());
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"smith", BoxesRunTime.boxToInteger((int)1)}))}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2068));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2066));
        this.test("SPARK-45475: saving a table via JDBC should work with observe API", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String tableName = "test_table";
            Observation namedObservation = Observation$.MODULE$.apply("named");
            Dataset observed_df = this.spark().range(100L).observe(namedObservation, functions$.MODULE$.percentile_approx((Column)this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$), functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)0.5)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)100))).as("percentile_approx_val"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0]));
            observed_df.write().format("jdbc").option("url", this.urlWithUserAndPass()).option("dbtable", tableName).save();
            scala.collection.immutable.Map expected = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"percentile_approx_val"), (Object)BoxesRunTime.boxToInteger((int)49))}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(namedObservation.get());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right = expected;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2082));
        }, new Position("JDBCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2071));
    }
}

