/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.expressions.aggregate.AggregateFunc;
import org.apache.spark.sql.connector.expressions.aggregate.Count;
import org.apache.spark.sql.connector.expressions.aggregate.CountStar;
import org.apache.spark.sql.connector.expressions.aggregate.Max;
import org.apache.spark.sql.connector.expressions.aggregate.Min;
import org.apache.spark.sql.connector.expressions.aggregate.Sum;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRDD;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcDialects$;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.EqualNullSafe;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Not;
import org.apache.spark.sql.sources.Or;
import org.apache.spark.sql.sources.StringContains;
import org.apache.spark.sql.sources.StringEndsWith;
import org.apache.spark.sql.sources.StringStartsWith;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;

public final class JDBCRDD$
implements Logging,
Serializable {
    public static final JDBCRDD$ MODULE$ = new JDBCRDD$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public StructType resolveTable(JDBCOptions options) {
        String url = options.url();
        String table = options.tableOrQuery();
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(url);
        return this.getQueryOutputSchema(dialect.getSchemaQuery(table), options, dialect);
    }

    public StructType getQueryOutputSchema(String query, JDBCOptions options, JdbcDialect dialect) {
        StructType structType;
        try (Connection conn = (Connection)JdbcUtils$.MODULE$.createConnectionFactory(options).apply();
             PreparedStatement statement = conn.prepareStatement(query);){
            statement.setQueryTimeout(options.queryTimeout());
            try (ResultSet rs = statement.executeQuery();){
                structType = JdbcUtils$.MODULE$.getSchema(rs, dialect, true);
            }
        }
        return structType;
    }

    private StructType pruneSchema(StructType schema, String[] columns) {
        Map fieldMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()), (Function1 & Serializable)x -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)x.name()), x), ClassTag$.MODULE$.apply(Tuple2.class))));
        return new StructType((StructField[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])columns), (Function1 & Serializable)name -> (StructField)fieldMap.apply(name), ClassTag$.MODULE$.apply(StructField.class)));
    }

    /*
     * Enabled aggressive block sorting
     */
    public Option<String> compileFilter(Filter f, JdbcDialect dialect) {
        String string;
        boolean bl = false;
        In in = null;
        Filter filter = f;
        if (filter instanceof EqualTo) {
            EqualTo equalTo = (EqualTo)filter;
            String attr = equalTo.attribute();
            Object value = equalTo.value();
            string = new StringBuilder(3).append(JDBCRDD$.quote$1(attr, dialect)).append(" = ").append(dialect.compileValue(value)).toString();
            return Option$.MODULE$.apply((Object)string);
        }
        if (filter instanceof EqualNullSafe) {
            EqualNullSafe equalNullSafe = (EqualNullSafe)filter;
            String attr = equalNullSafe.attribute();
            Object value = equalNullSafe.value();
            String col = JDBCRDD$.quote$1(attr, dialect);
            string = new StringBuilder(0).append(new StringBuilder(26).append("(NOT (").append(col).append(" != ").append(dialect.compileValue(value)).append(" OR ").append(col).append(" IS NULL OR ").toString()).append(new StringBuilder(13).append(dialect.compileValue(value)).append(" IS NULL) OR ").toString()).append(new StringBuilder(24).append("(").append(col).append(" IS NULL AND ").append(dialect.compileValue(value)).append(" IS NULL))").toString()).toString();
            return Option$.MODULE$.apply((Object)string);
        }
        if (filter instanceof LessThan) {
            LessThan lessThan = (LessThan)filter;
            String attr = lessThan.attribute();
            Object value = lessThan.value();
            string = new StringBuilder(3).append(JDBCRDD$.quote$1(attr, dialect)).append(" < ").append(dialect.compileValue(value)).toString();
            return Option$.MODULE$.apply((Object)string);
        }
        if (filter instanceof GreaterThan) {
            GreaterThan greaterThan = (GreaterThan)filter;
            String attr = greaterThan.attribute();
            Object value = greaterThan.value();
            string = new StringBuilder(3).append(JDBCRDD$.quote$1(attr, dialect)).append(" > ").append(dialect.compileValue(value)).toString();
            return Option$.MODULE$.apply((Object)string);
        }
        if (filter instanceof LessThanOrEqual) {
            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)filter;
            String attr = lessThanOrEqual.attribute();
            Object value = lessThanOrEqual.value();
            string = new StringBuilder(4).append(JDBCRDD$.quote$1(attr, dialect)).append(" <= ").append(dialect.compileValue(value)).toString();
            return Option$.MODULE$.apply((Object)string);
        }
        if (filter instanceof GreaterThanOrEqual) {
            GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)filter;
            String attr = greaterThanOrEqual.attribute();
            Object value = greaterThanOrEqual.value();
            string = new StringBuilder(4).append(JDBCRDD$.quote$1(attr, dialect)).append(" >= ").append(dialect.compileValue(value)).toString();
            return Option$.MODULE$.apply((Object)string);
        }
        if (filter instanceof IsNull) {
            IsNull isNull = (IsNull)filter;
            String attr = isNull.attribute();
            string = new StringBuilder(8).append(JDBCRDD$.quote$1(attr, dialect)).append(" IS NULL").toString();
            return Option$.MODULE$.apply((Object)string);
        }
        if (filter instanceof IsNotNull) {
            IsNotNull isNotNull = (IsNotNull)filter;
            String attr = isNotNull.attribute();
            string = new StringBuilder(12).append(JDBCRDD$.quote$1(attr, dialect)).append(" IS NOT NULL").toString();
            return Option$.MODULE$.apply((Object)string);
        }
        if (filter instanceof StringStartsWith) {
            StringStartsWith stringStartsWith = (StringStartsWith)filter;
            String attr = stringStartsWith.attribute();
            String value = stringStartsWith.value();
            string = new StringBuilder(9).append(JDBCRDD$.quote$1(attr, dialect)).append(" LIKE '").append(value).append("%'").toString();
            return Option$.MODULE$.apply((Object)string);
        }
        if (filter instanceof StringEndsWith) {
            StringEndsWith stringEndsWith = (StringEndsWith)filter;
            String attr = stringEndsWith.attribute();
            String value = stringEndsWith.value();
            string = new StringBuilder(9).append(JDBCRDD$.quote$1(attr, dialect)).append(" LIKE '%").append(value).append("'").toString();
            return Option$.MODULE$.apply((Object)string);
        }
        if (filter instanceof StringContains) {
            StringContains stringContains = (StringContains)filter;
            String attr = stringContains.attribute();
            String value = stringContains.value();
            string = new StringBuilder(10).append(JDBCRDD$.quote$1(attr, dialect)).append(" LIKE '%").append(value).append("%'").toString();
            return Option$.MODULE$.apply((Object)string);
        }
        if (filter instanceof In) {
            bl = true;
            in = (In)filter;
            String attr = in.attribute();
            Object[] value = in.values();
            if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.genericArrayOps((Object)value))) {
                string = new StringBuilder(43).append("CASE WHEN ").append(JDBCRDD$.quote$1(attr, dialect)).append(" IS NULL THEN NULL ELSE FALSE END").toString();
                return Option$.MODULE$.apply((Object)string);
            }
        }
        if (bl) {
            String attr = in.attribute();
            Object[] value = in.values();
            string = new StringBuilder(6).append(JDBCRDD$.quote$1(attr, dialect)).append(" IN (").append(dialect.compileValue(value)).append(")").toString();
            return Option$.MODULE$.apply((Object)string);
        }
        if (filter instanceof Not) {
            Not not = (Not)filter;
            Filter f2 = not.child();
            string = (String)this.compileFilter(f2, dialect).map((Function1 & Serializable)p -> new StringBuilder(8).append("(NOT (").append((String)p).append("))").toString()).getOrElse((Function0 & Serializable)() -> null);
            return Option$.MODULE$.apply((Object)string);
        }
        if (filter instanceof Or) {
            Or or = (Or)filter;
            Filter f1 = or.left();
            Filter f2 = or.right();
            Seq or2 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Filter[]{f1, f2})).flatMap((Function1 & Serializable)x$1 -> MODULE$.compileFilter((Filter)x$1, dialect));
            string = or2.size() == 2 ? ((IterableOnceOps)or2.map((Function1 & Serializable)p -> new StringBuilder(2).append("(").append((String)p).append(")").toString())).mkString(" OR ") : null;
            return Option$.MODULE$.apply((Object)string);
        }
        if (!(filter instanceof And)) {
            string = null;
            return Option$.MODULE$.apply((Object)string);
        }
        And and = (And)filter;
        Filter f1 = and.left();
        Filter f2 = and.right();
        Seq and2 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Filter[]{f1, f2})).flatMap((Function1 & Serializable)x$2 -> MODULE$.compileFilter((Filter)x$2, dialect));
        string = and2.size() == 2 ? ((IterableOnceOps)and2.map((Function1 & Serializable)p -> new StringBuilder(2).append("(").append((String)p).append(")").toString())).mkString(" AND ") : null;
        return Option$.MODULE$.apply((Object)string);
    }

    public Option<Seq<String>> compileAggregates(Seq<AggregateFunc> aggregates, JdbcDialect dialect) {
        Some some;
        Object object = new Object();
        try {
            some = new Some(aggregates.map((Function1 & Serializable)x0$1 -> {
                String string;
                AggregateFunc aggregateFunc = x0$1;
                if (aggregateFunc instanceof Min) {
                    Min min = (Min)aggregateFunc;
                    if (min.column().fieldNames().length != 1) {
                        throw new NonLocalReturnControl(object, (Object)None$.MODULE$);
                    }
                    string = new StringBuilder(5).append("MIN(").append(JDBCRDD$.quote$2((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])min.column().fieldNames())), dialect)).append(")").toString();
                } else if (aggregateFunc instanceof Max) {
                    Max max = (Max)aggregateFunc;
                    if (max.column().fieldNames().length != 1) {
                        throw new NonLocalReturnControl(object, (Object)None$.MODULE$);
                    }
                    string = new StringBuilder(5).append("MAX(").append(JDBCRDD$.quote$2((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])max.column().fieldNames())), dialect)).append(")").toString();
                } else if (aggregateFunc instanceof Count) {
                    Count count = (Count)aggregateFunc;
                    if (count.column().fieldNames().length != 1) {
                        throw new NonLocalReturnControl(object, (Object)None$.MODULE$);
                    }
                    String distinct = count.isDistinct() ? "DISTINCT " : "";
                    String column = JDBCRDD$.quote$2((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])count.column().fieldNames())), dialect);
                    string = new StringBuilder(7).append("COUNT(").append(distinct).append(column).append(")").toString();
                } else if (aggregateFunc instanceof Sum) {
                    Sum sum = (Sum)aggregateFunc;
                    if (sum.column().fieldNames().length != 1) {
                        throw new NonLocalReturnControl(object, (Object)None$.MODULE$);
                    }
                    String distinct = sum.isDistinct() ? "DISTINCT " : "";
                    String column = JDBCRDD$.quote$2((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])sum.column().fieldNames())), dialect);
                    string = new StringBuilder(5).append("SUM(").append(distinct).append(column).append(")").toString();
                } else if (aggregateFunc instanceof CountStar) {
                    string = "COUNT(*)";
                } else {
                    throw new NonLocalReturnControl(object, (Object)None$.MODULE$);
                }
                return string;
            }));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                some = (Option)ex.value();
            }
            throw ex;
        }
        return some;
    }

    public RDD<InternalRow> scanTable(SparkContext sc, StructType schema, String[] requiredColumns, Filter[] filters, Partition[] parts, JDBCOptions options, Option<StructType> outputSchema, Option<String[]> groupByColumns) {
        String url = options.url();
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(url);
        String[] quotedColumns = groupByColumns.isEmpty() ? (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])requiredColumns), (Function1 & Serializable)colName -> dialect.quoteIdentifier((String)colName), ClassTag$.MODULE$.apply(String.class)) : requiredColumns;
        return new JDBCRDD(sc, JdbcUtils$.MODULE$.createConnectionFactory(options), (StructType)outputSchema.getOrElse((Function0 & Serializable)() -> MODULE$.pruneSchema(schema, requiredColumns)), quotedColumns, filters, parts, url, options, groupByColumns);
    }

    public Option<StructType> scanTable$default$7() {
        return None$.MODULE$;
    }

    public Option<String[]> scanTable$default$8() {
        return None$.MODULE$;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JDBCRDD$.class);
    }

    private static final String quote$1(String colName, JdbcDialect dialect$1) {
        return dialect$1.quoteIdentifier(colName);
    }

    private static final String quote$2(String colName, JdbcDialect dialect$2) {
        return dialect$2.quoteIdentifier(colName);
    }

    private JDBCRDD$() {
    }
}

