/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport$;
import org.apache.spark.sql.execution.datasources.parquet.SparkToParquetSchemaConverter;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.package$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t=e\u0001B\u00193\u0001\u0005CQa\u0016\u0001\u0005\u0002a+Aa\u0017\u0001\u00059\"Ia\u000e\u0001a\u0001\u0002\u0004%Ia\u001c\u0005\nm\u0002\u0001\r\u00111A\u0005\n]D\u0011B\u001f\u0001A\u0002\u0003\u0005\u000b\u0015\u00029\t\u0013m\u0004\u0001\u0019!a\u0001\n\u0013a\bbCA\u0003\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u000fA!\"a\u0003\u0001\u0001\u0004\u0005\t\u0015)\u0003~\u0011-\ti\u0001\u0001a\u0001\u0002\u0004%I!a\u0004\t\u0017\u0005}\u0001\u00011AA\u0002\u0013%\u0011\u0011\u0005\u0005\f\u0003K\u0001\u0001\u0019!A!B\u0013\t\t\u0002C\u0006\u0002(\u0001\u0001\r\u00111A\u0005\n\u0005%\u0002bCA\u0019\u0001\u0001\u0007\t\u0019!C\u0005\u0003gA1\"a\u000e\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002,!Y\u0011\u0011\b\u0001A\u0002\u0003\u0007I\u0011BA\u001e\u0011-\tI\u0006\u0001a\u0001\u0002\u0004%I!a\u0017\t\u0017\u0005}\u0003\u00011A\u0001B\u0003&\u0011Q\b\u0005\n\u0003C\u0002!\u0019!C\u0005\u0003GB\u0001\"!\u001c\u0001A\u0003%\u0011Q\r\u0005\n\u0003_\u0002!\u0019!C\u0005\u0003GB\u0001\"!\u001d\u0001A\u0003%\u0011Q\r\u0005\n\u0003g\u0002!\u0019!C\u0005\u0003kB\u0001\"a'\u0001A\u0003%\u0011q\u000f\u0005\n\u0003;\u0003!\u0019!C\u0005\u0003?C\u0001\"a*\u0001A\u0003%\u0011\u0011\u0015\u0005\n\u0003S\u0003!\u0019!C\u0005\u0003WC\u0001\"!.\u0001A\u0003%\u0011Q\u0016\u0005\n\u0003o\u0003!\u0019!C\u0005\u0003kB\u0001\"!/\u0001A\u0003%\u0011q\u000f\u0005\n\u0003w\u0003!\u0019!C\u0005\u0003WC\u0001\"!0\u0001A\u0003%\u0011Q\u0016\u0005\b\u0003\u007f\u0003A\u0011IAa\u0011\u001d\ty\u000f\u0001C!\u0003cDq!!>\u0001\t\u0003\n9\u0010C\u0004\u0002~\u0002!I!a@\t\u000f\t%\u0001\u0001\"\u0003\u0003\f!9!q\u0003\u0001\u0005\n\te\u0001b\u0002B\u0012\u0001\u0011\u0005!Q\u0005\u0005\b\u0005c\u0001A\u0011\u0002B\u001a\u0011\u001d\u0011y\u0004\u0001C\u0005\u0005\u0003BqA!\u0014\u0001\t\u0013\u0011y\u0005C\u0004\u0003T\u0001!IA!\u0016\b\u000f\tM$\u0007#\u0001\u0003v\u00191\u0011G\rE\u0001\u0005oBaa\u0016\u0017\u0005\u0002\t}\u0004\"\u0003BAY\t\u0007I\u0011\u0001BB\u0011!\u0011)\t\fQ\u0001\n\t}\u0003b\u0002BDY\u0011\u0005!\u0011\u0012\u0002\u0014!\u0006\u0014\u0018/^3u/JLG/Z*vaB|'\u000f\u001e\u0006\u0003gQ\nq\u0001]1scV,GO\u0003\u00026m\u0005YA-\u0019;bg>,(oY3t\u0015\t9\u0004(A\u0005fq\u0016\u001cW\u000f^5p]*\u0011\u0011HO\u0001\u0004gFd'BA\u001e=\u0003\u0015\u0019\b/\u0019:l\u0015\tid(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u007f\u0005\u0019qN]4\u0004\u0001M\u0019\u0001AQ)\u0011\u0007\rK5*D\u0001E\u0015\t)e)A\u0002ba&T!a\u0012%\u0002\r!\fGm\\8q\u0015\t\u0019D(\u0003\u0002K\t\naqK]5uKN+\b\u000f]8siB\u0011AjT\u0007\u0002\u001b*\u0011a\nO\u0001\tG\u0006$\u0018\r\\=ti&\u0011\u0001+\u0014\u0002\f\u0013:$XM\u001d8bYJ{w\u000f\u0005\u0002S+6\t1K\u0003\u0002Uu\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002W'\n9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001Z!\tQ\u0006!D\u00013\u0005-1\u0016\r\\;f/JLG/\u001a:\u0011\u000bu\u0003'\r[6\u000e\u0003yS\u0011aX\u0001\u0006g\u000e\fG.Y\u0005\u0003Cz\u0013\u0011BR;oGRLwN\u001c\u001a\u0011\u0005\r4W\"\u00013\u000b\u0005\u0015l\u0015aC3yaJ,7o]5p]NL!a\u001a3\u0003%M\u0003XmY5bY&TX\rZ$fiR,'o\u001d\t\u0003;&L!A\u001b0\u0003\u0007%sG\u000f\u0005\u0002^Y&\u0011QN\u0018\u0002\u0005+:LG/\u0001\u0004tG\",W.Y\u000b\u0002aB\u0011\u0011\u000f^\u0007\u0002e*\u00111\u000fO\u0001\u0006if\u0004Xm]\u0005\u0003kJ\u0014!b\u0015;sk\u000e$H+\u001f9f\u0003)\u00198\r[3nC~#S-\u001d\u000b\u0003WbDq!\u001f\u0003\u0002\u0002\u0003\u0007\u0001/A\u0002yIE\nqa]2iK6\f\u0007%\u0001\ts_>$h)[3mI^\u0013\u0018\u000e^3sgV\tQ\u0010\u0005\u0003^}\u0006\u0005\u0011BA@_\u0005\u0015\t%O]1z!\r\t\u0019AA\u0007\u0002\u0001\u0005!\"o\\8u\r&,G\u000eZ,sSR,'o]0%KF$2a[A\u0005\u0011\u001dIx!!AA\u0002u\f\u0011C]8pi\u001aKW\r\u001c3Xe&$XM]:!\u00039\u0011XmY8sI\u000e{gn];nKJ,\"!!\u0005\u0011\t\u0005M\u00111D\u0007\u0003\u0003+Q1!RA\f\u0015\r\tI\u0002S\u0001\u0003S>LA!!\b\u0002\u0016\tq!+Z2pe\u0012\u001cuN\\:v[\u0016\u0014\u0018A\u0005:fG>\u0014HmQ8ogVlWM]0%KF$2a[A\u0012\u0011!I(\"!AA\u0002\u0005E\u0011a\u0004:fG>\u0014HmQ8ogVlWM\u001d\u0011\u00021]\u0014\u0018\u000e^3MK\u001e\f7-\u001f)beF,X\r\u001e$pe6\fG/\u0006\u0002\u0002,A\u0019Q,!\f\n\u0007\u0005=bLA\u0004C_>dW-\u00198\u00029]\u0014\u0018\u000e^3MK\u001e\f7-\u001f)beF,X\r\u001e$pe6\fGo\u0018\u0013fcR\u00191.!\u000e\t\u0011el\u0011\u0011!a\u0001\u0003W\t\u0011d\u001e:ji\u0016dUmZ1dsB\u000b'/];fi\u001a{'/\\1uA\u0005\u0019r.\u001e;qkR$\u0016.\\3ti\u0006l\u0007\u000fV=qKV\u0011\u0011Q\b\t\u0005\u0003\u007f\t\tF\u0004\u0003\u0002B\u0005-c\u0002BA\"\u0003\u000fj!!!\u0012\u000b\u0005QC\u0014\u0002BA%\u0003\u000b\nqaU)M\u0007>tg-\u0003\u0003\u0002N\u0005=\u0013A\u0007)beF,X\r^(viB,H\u000fV5nKN$\u0018-\u001c9UsB,'\u0002BA%\u0003\u000bJA!a\u0015\u0002V\t)a+\u00197vK&\u0019\u0011q\u000b0\u0003\u0017\u0015sW/\\3sCRLwN\\\u0001\u0018_V$\b/\u001e;US6,7\u000f^1naRK\b/Z0%KF$2a[A/\u0011!I\b#!AA\u0002\u0005u\u0012\u0001F8viB,H\u000fV5nKN$\u0018-\u001c9UsB,\u0007%A\buS6,7\u000f^1na\n+hMZ3s+\t\t)\u0007\u0005\u0003^}\u0006\u001d\u0004cA/\u0002j%\u0019\u00111\u000e0\u0003\t\tKH/Z\u0001\u0011i&lWm\u001d;b[B\u0014UO\u001a4fe\u0002\nQ\u0002Z3dS6\fGNQ;gM\u0016\u0014\u0018A\u00043fG&l\u0017\r\u001c\"vM\u001a,'\u000fI\u0001\u0013I\u0006$X\r^5nKJ+'-Y:f\u001b>$W-\u0006\u0002\u0002xA!\u0011\u0011PA)\u001d\u0011\tY(a&\u000f\t\u0005u\u0014q\t\b\u0005\u0003\u007f\n)J\u0004\u0003\u0002\u0002\u0006Me\u0002BAB\u0003#sA!!\"\u0002\u0010:!\u0011qQAG\u001b\t\tIIC\u0002\u0002\f\u0002\u000ba\u0001\u0010:p_Rt\u0014\"A \n\u0005ur\u0014BA\u001e=\u0013\tI$(\u0003\u0002Uq%!\u0011\u0011TA(\u0003QaUmZ1ds\n+\u0007.\u0019<j_J\u0004v\u000e\\5ds\u0006\u0019B-\u0019;fi&lWMU3cCN,Wj\u001c3fA\u0005qA-\u0019;f%\u0016\u0014\u0017m]3Gk:\u001cWCAAQ!\u0015i\u00161\u00155i\u0013\r\t)K\u0018\u0002\n\rVt7\r^5p]F\nq\u0002Z1uKJ+'-Y:f\rVt7\rI\u0001\u0014i&lWm\u001d;b[B\u0014VMY1tK\u001a+hnY\u000b\u0003\u0003[\u0003r!XAR\u0003_\u000by\u000bE\u0002^\u0003cK1!a-_\u0005\u0011auN\\4\u0002)QLW.Z:uC6\u0004(+\u001a2bg\u00164UO\\2!\u0003=Ig\u000e^\u001d7%\u0016\u0014\u0017m]3N_\u0012,\u0017\u0001E5oif2$+\u001a2bg\u0016lu\u000eZ3!\u0003=Ig\u000e^\u001d7%\u0016\u0014\u0017m]3Gk:\u001c\u0017\u0001E5oif2$+\u001a2bg\u00164UO\\2!\u0003\u0011Ig.\u001b;\u0015\t\u0005\r\u0017Q\u001c\t\u0005\u0003\u000b\f9N\u0004\u0003\u0002H\u0006Mg\u0002BAe\u0003#tA!a3\u0002P:!\u00111QAg\u0013\t\u0019D(\u0003\u0002H\u0011&\u0011QIR\u0005\u0004\u0003+$\u0015\u0001D,sSR,7+\u001e9q_J$\u0018\u0002BAm\u00037\u0014Ab\u0016:ji\u0016\u001cuN\u001c;fqRT1!!6E\u0011\u001d\ty\u000e\ta\u0001\u0003C\fQbY8oM&<WO]1uS>t\u0007\u0003BAr\u0003Wl!!!:\u000b\t\u0005\u001d\u0018\u0011^\u0001\u0005G>tgM\u0003\u0002Hy%!\u0011Q^As\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u0006y\u0001O]3qCJ,gi\u001c:Xe&$X\rF\u0002l\u0003gDq!!\u0004\"\u0001\u0004\t\t\"A\u0003xe&$X\rF\u0002l\u0003sDa!a?#\u0001\u0004Y\u0015a\u0001:po\u0006YqO]5uK\u001aKW\r\u001c3t)\u001dY'\u0011\u0001B\u0002\u0005\u000bAa!a?$\u0001\u0004Y\u0005\"\u00028$\u0001\u0004\u0001\bB\u0002B\u0004G\u0001\u0007Q0\u0001\u0007gS\u0016dGm\u0016:ji\u0016\u00148/\u0001\u0006nC.,wK]5uKJ$B!!\u0001\u0003\u000e!9!q\u0002\u0013A\u0002\tE\u0011\u0001\u00033bi\u0006$\u0016\u0010]3\u0011\u0007E\u0014\u0019\"C\u0002\u0003\u0016I\u0014\u0001\u0002R1uCRK\b/Z\u0001\u0012[\u0006\\W\rR3dS6\fGn\u0016:ji\u0016\u0014HCBA\u0001\u00057\u0011y\u0002\u0003\u0004\u0003\u001e\u0015\u0002\r\u0001[\u0001\naJ,7-[:j_:DaA!\t&\u0001\u0004A\u0017!B:dC2,\u0017aD7bW\u0016\f%O]1z/JLG/\u001a:\u0015\t\u0005\u0005!q\u0005\u0005\b\u0005S1\u0003\u0019\u0001B\u0016\u0003%\t'O]1z)f\u0004X\rE\u0002r\u0005[I1Aa\fs\u0005%\t%O]1z)f\u0004X-A\u0007nC.,W*\u00199Xe&$XM\u001d\u000b\u0005\u0003\u0003\u0011)\u0004C\u0004\u00038\u001d\u0002\rA!\u000f\u0002\u000f5\f\u0007\u000fV=qKB\u0019\u0011Oa\u000f\n\u0007\tu\"OA\u0004NCB$\u0016\u0010]3\u0002\u001d\r|gn];nK6+7o]1hKR\u00191Na\u0011\t\u0011\t\u0015\u0003\u0006\"a\u0001\u0005\u000f\n\u0011A\u001a\t\u0005;\n%3.C\u0002\u0003Ly\u0013\u0001\u0002\u00102z]\u0006lWMP\u0001\rG>t7/^7f\u000fJ|W\u000f\u001d\u000b\u0004W\nE\u0003\u0002\u0003B#S\u0011\u0005\rAa\u0012\u0002\u0019\r|gn];nK\u001aKW\r\u001c3\u0015\r\t]#1\fB8)\rY'\u0011\f\u0005\t\u0005\u000bRC\u00111\u0001\u0003H!9!Q\f\u0016A\u0002\t}\u0013!\u00024jK2$\u0007\u0003\u0002B1\u0005SrAAa\u0019\u0003fA\u0019\u0011q\u00110\n\u0007\t\u001dd,\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005W\u0012iG\u0001\u0004TiJLgn\u001a\u0006\u0004\u0005Or\u0006B\u0002B9U\u0001\u0007\u0001.A\u0003j]\u0012,\u00070A\nQCJ\fX/\u001a;Xe&$XmU;qa>\u0014H\u000f\u0005\u0002[YM\u0019AF!\u001f\u0011\u0007u\u0013Y(C\u0002\u0003~y\u0013a!\u00118z%\u00164GC\u0001B;\u0003A\u0019\u0006+\u0011*L?J{ukX*D\u0011\u0016k\u0015)\u0006\u0002\u0003`\u0005\t2\u000bU!S\u0017~\u0013vjV0T\u0007\"+U*\u0011\u0011\u0002\u0013M,GoU2iK6\fG#B6\u0003\f\n5\u0005\"\u000281\u0001\u0004\u0001\bbBApa\u0001\u0007\u0011\u0011\u001d")
public class ParquetWriteSupport
extends WriteSupport<InternalRow>
implements Logging {
    private StructType schema;
    private Function2<SpecializedGetters, Object, BoxedUnit>[] rootFieldWriters;
    private RecordConsumer recordConsumer;
    private boolean writeLegacyParquetFormat;
    private Enumeration.Value outputTimestampType;
    private final byte[] timestampBuffer;
    private final byte[] decimalBuffer;
    private final Enumeration.Value datetimeRebaseMode;
    private final Function1<Object, Object> dateRebaseFunc;
    private final Function1<Object, Object> timestampRebaseFunc;
    private final Enumeration.Value int96RebaseMode;
    private final Function1<Object, Object> int96RebaseFunc;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static void setSchema(StructType structType, Configuration configuration) {
        ParquetWriteSupport$.MODULE$.setSchema(structType, configuration);
    }

    public static String SPARK_ROW_SCHEMA() {
        return ParquetWriteSupport$.MODULE$.SPARK_ROW_SCHEMA();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private StructType schema() {
        return this.schema;
    }

    private void schema_$eq(StructType x$1) {
        this.schema = x$1;
    }

    private Function2<SpecializedGetters, Object, BoxedUnit>[] rootFieldWriters() {
        return this.rootFieldWriters;
    }

    private void rootFieldWriters_$eq(Function2<SpecializedGetters, Object, BoxedUnit>[] x$1) {
        this.rootFieldWriters = x$1;
    }

    private RecordConsumer recordConsumer() {
        return this.recordConsumer;
    }

    private void recordConsumer_$eq(RecordConsumer x$1) {
        this.recordConsumer = x$1;
    }

    private boolean writeLegacyParquetFormat() {
        return this.writeLegacyParquetFormat;
    }

    private void writeLegacyParquetFormat_$eq(boolean x$1) {
        this.writeLegacyParquetFormat = x$1;
    }

    private Enumeration.Value outputTimestampType() {
        return this.outputTimestampType;
    }

    private void outputTimestampType_$eq(Enumeration.Value x$1) {
        this.outputTimestampType = x$1;
    }

    private byte[] timestampBuffer() {
        return this.timestampBuffer;
    }

    private byte[] decimalBuffer() {
        return this.decimalBuffer;
    }

    private Enumeration.Value datetimeRebaseMode() {
        return this.datetimeRebaseMode;
    }

    private Function1<Object, Object> dateRebaseFunc() {
        return this.dateRebaseFunc;
    }

    private Function1<Object, Object> timestampRebaseFunc() {
        return this.timestampRebaseFunc;
    }

    private Enumeration.Value int96RebaseMode() {
        return this.int96RebaseMode;
    }

    private Function1<Object, Object> int96RebaseFunc() {
        return this.int96RebaseFunc;
    }

    public WriteSupport.WriteContext init(Configuration configuration) {
        String schemaString = configuration.get(ParquetWriteSupport$.MODULE$.SPARK_ROW_SCHEMA());
        this.schema_$eq(StructType$.MODULE$.fromString(schemaString));
        Predef$.MODULE$.assert(configuration.get(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key()) != null);
        this.writeLegacyParquetFormat_$eq(StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(configuration.get(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key()))));
        String key = SQLConf$.MODULE$.PARQUET_OUTPUT_TIMESTAMP_TYPE().key();
        Predef$.MODULE$.assert(configuration.get(key) != null);
        this.outputTimestampType_$eq(SQLConf.ParquetOutputTimestampType$.MODULE$.withName(configuration.get(key)));
        this.rootFieldWriters_$eq((Function2[])((IterableOnceOps)((IterableOps)this.schema().map((Function1 & Serializable)x$6 -> x$6.dataType())).map((Function1 & Serializable)dataType -> this.makeWriter((DataType)dataType))).toArray(ClassTag$.MODULE$.apply(Function2.class)));
        MessageType messageType = new SparkToParquetSchemaConverter(configuration).convert(this.schema());
        Enumeration.Value value = this.datetimeRebaseMode();
        Enumeration.Value value2 = SQLConf.LegacyBehaviorPolicy$.MODULE$.LEGACY();
        Enumeration.Value value3 = this.int96RebaseMode();
        Enumeration.Value value4 = SQLConf.LegacyBehaviorPolicy$.MODULE$.LEGACY();
        scala.collection.immutable.Map metadata = (scala.collection.immutable.Map)((MapOps)((MapOps)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.SPARK_VERSION_METADATA_KEY()), (Object)org.apache.spark.package$.MODULE$.SPARK_VERSION_SHORT()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ParquetReadSupport$.MODULE$.SPARK_METADATA_KEY()), (Object)schemaString)}))).$plus$plus((IterableOnce)(!(value != null ? !value.equals(value2) : value2 != null) ? new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.SPARK_LEGACY_DATETIME()), (Object)"")) : None$.MODULE$))).$plus$plus((IterableOnce)(!(value3 != null ? !value3.equals(value4) : value4 != null) ? new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.SPARK_LEGACY_INT96()), (Object)"")) : None$.MODULE$));
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(134).append("Initialized Parquet WriteSupport with Catalyst schema:\n         |").append(this.schema().prettyJson()).append("\n         |and corresponding Parquet message type:\n         |").append(messageType).append("\n       ").toString())));
        return new WriteSupport.WriteContext(messageType, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)metadata).asJava());
    }

    public void prepareForWrite(RecordConsumer recordConsumer) {
        this.recordConsumer_$eq(recordConsumer);
    }

    public void write(InternalRow row) {
        this.consumeMessage((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.writeFields(row, this.schema(), this.rootFieldWriters()));
    }

    private void writeFields(InternalRow row, StructType schema, Function2<SpecializedGetters, Object, BoxedUnit>[] fieldWriters) {
        IntRef i = IntRef.create((int)0);
        while (i.elem < row.numFields()) {
            if (!row.isNullAt(i.elem)) {
                this.consumeField(schema.apply(i.elem).name(), i.elem, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> fieldWriters[i$1.elem].apply((Object)row, (Object)BoxesRunTime.boxToInteger((int)i$1.elem)));
            }
            ++i.elem;
        }
    }

    private Function2<SpecializedGetters, Object, BoxedUnit> makeWriter(DataType dataType2) {
        Function2 & Serializable intersect;
        block22: {
            while (true) {
                DecimalType decimalType;
                Option option;
                DataType dataType3;
                if (BooleanType$.MODULE$.equals(dataType3 = dataType2)) {
                    intersect = (Function2 & Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$1(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block22;
                }
                if (ByteType$.MODULE$.equals(dataType3)) {
                    intersect = (Function2 & Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$2(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block22;
                }
                if (ShortType$.MODULE$.equals(dataType3)) {
                    intersect = (Function2 & Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$3(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block22;
                }
                if (DateType$.MODULE$.equals(dataType3)) {
                    intersect = (Function2 & Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$4(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block22;
                }
                if (IntegerType$.MODULE$.equals(dataType3)) {
                    intersect = (Function2 & Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$5(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block22;
                }
                if (LongType$.MODULE$.equals(dataType3)) {
                    intersect = (Function2 & Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$6(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block22;
                }
                if (FloatType$.MODULE$.equals(dataType3)) {
                    intersect = (Function2 & Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$7(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block22;
                }
                if (DoubleType$.MODULE$.equals(dataType3)) {
                    intersect = (Function2 & Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$8(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block22;
                }
                if (StringType$.MODULE$.equals(dataType3)) {
                    intersect = (Function2 & Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$9(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block22;
                }
                if (TimestampType$.MODULE$.equals(dataType3)) {
                    Function2 & Serializable intersect2;
                    Enumeration.Value value = this.outputTimestampType();
                    Enumeration.Value value2 = SQLConf.ParquetOutputTimestampType$.MODULE$.INT96();
                    Enumeration.Value value3 = value;
                    if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                        intersect2 = (Function2 & Serializable)(row, ordinal) -> {
                            ParquetWriteSupport.$anonfun$makeWriter$10(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                            return BoxedUnit.UNIT;
                        };
                    } else {
                        Enumeration.Value value4 = SQLConf.ParquetOutputTimestampType$.MODULE$.TIMESTAMP_MICROS();
                        Enumeration.Value value5 = value;
                        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                            intersect2 = (Function2 & Serializable)(row, ordinal) -> {
                                ParquetWriteSupport.$anonfun$makeWriter$11(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                                return BoxedUnit.UNIT;
                            };
                        } else {
                            Enumeration.Value value6 = SQLConf.ParquetOutputTimestampType$.MODULE$.TIMESTAMP_MILLIS();
                            Enumeration.Value value7 = value;
                            if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                                intersect2 = (Function2 & Serializable)(row, ordinal) -> {
                                    ParquetWriteSupport.$anonfun$makeWriter$12(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                                    return BoxedUnit.UNIT;
                                };
                            } else {
                                throw new MatchError((Object)value);
                            }
                        }
                    }
                    intersect = intersect2;
                    break block22;
                }
                if (BinaryType$.MODULE$.equals(dataType3)) {
                    intersect = (Function2 & Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$13(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block22;
                }
                if (dataType3 instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType3)).isEmpty()) {
                    int precision = ((Tuple2)option.get())._1$mcI$sp();
                    int scale = ((Tuple2)option.get())._2$mcI$sp();
                    intersect = this.makeDecimalWriter(precision, scale);
                    break block22;
                }
                if (dataType3 instanceof StructType) {
                    StructType structType = (StructType)dataType3;
                    Function2[] fieldWriters = (Function2[])((IterableOnceOps)((IterableOps)structType.map((Function1 & Serializable)x$8 -> x$8.dataType())).map((Function1 & Serializable)dataType -> this.makeWriter((DataType)dataType))).toArray(ClassTag$.MODULE$.apply(Function2.class));
                    intersect = (Function2 & Serializable)(row, ordinal) -> {
                        this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.writeFields(row.getStruct(BoxesRunTime.unboxToInt((Object)ordinal), structType.length()), structType, fieldWriters));
                        return BoxedUnit.UNIT;
                    };
                    break block22;
                }
                if (dataType3 instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType3;
                    intersect = this.makeArrayWriter(arrayType);
                    break block22;
                }
                if (dataType3 instanceof MapType) {
                    MapType mapType = (MapType)dataType3;
                    intersect = this.makeMapWriter(mapType);
                    break block22;
                }
                if (!(dataType3 instanceof UserDefinedType)) break;
                UserDefinedType userDefinedType = (UserDefinedType)dataType3;
                dataType2 = userDefinedType.sqlType();
            }
            throw scala.sys.package$.MODULE$.error(new StringBuilder(23).append("Unsupported data type ").append(dataType2).append(".").toString());
        }
        return intersect;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Function2<SpecializedGetters, Object, BoxedUnit> makeDecimalWriter(int precision, int scale) {
        Predef$.MODULE$.assert(precision <= DecimalType$.MODULE$.MAX_PRECISION(), (Function0 & Serializable)() -> new StringBuilder(41).append("Decimal precision ").append(precision).append(" exceeds max precision ").append(DecimalType$.MODULE$.MAX_PRECISION()).toString());
        int numBytes = Decimal$.MODULE$.minBytesForPrecision()[precision];
        Function2 & Serializable int32Writer = (Function2 & Serializable)(row, ordinal) -> {
            ParquetWriteSupport.$anonfun$makeDecimalWriter$2(this, precision, scale, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
        Function2 & Serializable int64Writer = (Function2 & Serializable)(row, ordinal) -> {
            ParquetWriteSupport.$anonfun$makeDecimalWriter$3(this, precision, scale, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
        Function2 & Serializable binaryWriterUsingUnscaledLong = (Function2 & Serializable)(row, ordinal) -> {
            ParquetWriteSupport.$anonfun$makeDecimalWriter$4(this, precision, scale, numBytes, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
        Function2 & Serializable binaryWriterUsingUnscaledBytes = (Function2 & Serializable)(row, ordinal) -> {
            ParquetWriteSupport.$anonfun$makeDecimalWriter$5(this, precision, scale, numBytes, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = this.writeLegacyParquetFormat();
        if (!bl3) {
            bl = true;
            bl2 = bl3;
            if (precision <= Decimal$.MODULE$.MAX_INT_DIGITS()) {
                return int32Writer;
            }
        }
        if (bl && precision <= Decimal$.MODULE$.MAX_LONG_DIGITS()) {
            return int64Writer;
        }
        if (true != bl3) return binaryWriterUsingUnscaledBytes;
        if (precision > Decimal$.MODULE$.MAX_LONG_DIGITS()) return binaryWriterUsingUnscaledBytes;
        return binaryWriterUsingUnscaledLong;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Function2<SpecializedGetters, Object, BoxedUnit> makeArrayWriter(ArrayType arrayType) {
        boolean bl;
        Function2<SpecializedGetters, Object, BoxedUnit> elementWriter = this.makeWriter(arrayType.elementType());
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(this.writeLegacyParquetFormat(), arrayType.containsNull());
        if (sp2 != null && !(bl = sp2._1$mcZ$sp())) {
            return this.threeLevelArrayWriter$1("list", "element", elementWriter);
        }
        if (sp2 != null) {
            boolean bl2 = sp2._1$mcZ$sp();
            boolean bl3 = sp2._2$mcZ$sp();
            if (bl2 && bl3) {
                return this.threeLevelArrayWriter$1("bag", "array", elementWriter);
            }
        }
        if (sp2 == null) throw new MatchError((Object)sp2);
        boolean bl4 = sp2._1$mcZ$sp();
        boolean bl5 = sp2._2$mcZ$sp();
        if (true != bl4) throw new MatchError((Object)sp2);
        if (false != bl5) throw new MatchError((Object)sp2);
        return this.twoLevelArrayWriter$1("array", elementWriter);
    }

    private Function2<SpecializedGetters, Object, BoxedUnit> makeMapWriter(MapType mapType) {
        Function2<SpecializedGetters, Object, BoxedUnit> keyWriter = this.makeWriter(mapType.keyType());
        Function2<SpecializedGetters, Object, BoxedUnit> valueWriter = this.makeWriter(mapType.valueType());
        String repeatedGroupName = this.writeLegacyParquetFormat() ? "map" : "key_value";
        return (Function2 & Serializable)(row, ordinal) -> {
            ParquetWriteSupport.$anonfun$makeMapWriter$1(this, repeatedGroupName, keyWriter, valueWriter, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
    }

    private void consumeMessage(Function0<BoxedUnit> f) {
        this.recordConsumer().startMessage();
        f.apply$mcV$sp();
        this.recordConsumer().endMessage();
    }

    private void consumeGroup(Function0<BoxedUnit> f) {
        this.recordConsumer().startGroup();
        f.apply$mcV$sp();
        this.recordConsumer().endGroup();
    }

    private void consumeField(String field, int index, Function0<BoxedUnit> f) {
        this.recordConsumer().startField(field, index);
        f.apply$mcV$sp();
        this.recordConsumer().endField(field, index);
    }

    public static final /* synthetic */ void $anonfun$makeWriter$1(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addBoolean(row.getBoolean(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$2(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addInteger((int)row.getByte(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$3(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addInteger((int)row.getShort(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$4(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addInteger($this.dateRebaseFunc().apply$mcII$sp(row.getInt(ordinal)));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$5(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addInteger(row.getInt(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$6(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addLong(row.getLong(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$7(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addFloat(row.getFloat(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$8(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addDouble(row.getDouble(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$9(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])row.getUTF8String(ordinal).getBytes()));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$10(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        long micros = $this.int96RebaseFunc().apply$mcJJ$sp(row.getLong(ordinal));
        Tuple2 tuple2 = DateTimeUtils$.MODULE$.toJulianDay(micros);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int julianDay = tuple2._1$mcI$sp();
        long timeOfDayNanos = tuple2._2$mcJ$sp();
        Tuple2.mcIJ.sp sp2 = new Tuple2.mcIJ.sp(julianDay, timeOfDayNanos);
        Tuple2.mcIJ.sp sp3 = sp2;
        int julianDay2 = sp3._1$mcI$sp();
        long timeOfDayNanos2 = sp3._2$mcJ$sp();
        ByteBuffer buf = ByteBuffer.wrap($this.timestampBuffer());
        buf.order(ByteOrder.LITTLE_ENDIAN).putLong(timeOfDayNanos2).putInt(julianDay2);
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])$this.timestampBuffer()));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$11(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        long micros = row.getLong(ordinal);
        $this.recordConsumer().addLong($this.timestampRebaseFunc().apply$mcJJ$sp(micros));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$12(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        long micros = row.getLong(ordinal);
        long millis = DateTimeUtils$.MODULE$.microsToMillis($this.timestampRebaseFunc().apply$mcJJ$sp(micros));
        $this.recordConsumer().addLong(millis);
    }

    public static final /* synthetic */ void $anonfun$makeWriter$13(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])row.getBinary(ordinal)));
    }

    public static final /* synthetic */ void $anonfun$makeDecimalWriter$2(ParquetWriteSupport $this, int precision$1, int scale$1, SpecializedGetters row, int ordinal) {
        long unscaledLong = row.getDecimal(ordinal, precision$1, scale$1).toUnscaledLong();
        $this.recordConsumer().addInteger((int)unscaledLong);
    }

    public static final /* synthetic */ void $anonfun$makeDecimalWriter$3(ParquetWriteSupport $this, int precision$1, int scale$1, SpecializedGetters row, int ordinal) {
        long unscaledLong = row.getDecimal(ordinal, precision$1, scale$1).toUnscaledLong();
        $this.recordConsumer().addLong(unscaledLong);
    }

    public static final /* synthetic */ void $anonfun$makeDecimalWriter$4(ParquetWriteSupport $this, int precision$1, int scale$1, int numBytes$1, SpecializedGetters row, int ordinal) {
        long unscaled = row.getDecimal(ordinal, precision$1, scale$1).toUnscaledLong();
        int i = 0;
        int shift = 8 * (numBytes$1 - 1);
        while (i < numBytes$1) {
            $this.decimalBuffer()[i] = (byte)(unscaled >> shift);
            ++i;
            shift -= 8;
        }
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])$this.decimalBuffer(), (int)0, (int)numBytes$1));
    }

    public static final /* synthetic */ void $anonfun$makeDecimalWriter$5(ParquetWriteSupport $this, int precision$1, int scale$1, int numBytes$1, SpecializedGetters row, int ordinal) {
        byte[] byArray;
        Decimal decimal = row.getDecimal(ordinal, precision$1, scale$1);
        byte[] bytes = decimal.toJavaBigDecimal().unscaledValue().toByteArray();
        if (bytes.length == numBytes$1) {
            byArray = bytes;
        } else {
            byte signByte = BoxesRunTime.unboxToByte((Object)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.byteArrayOps(bytes))) < 0 ? (byte)-1 : 0;
            Arrays.fill($this.decimalBuffer(), 0, numBytes$1 - bytes.length, signByte);
            System.arraycopy(bytes, 0, $this.decimalBuffer(), numBytes$1 - bytes.length, bytes.length);
            byArray = $this.decimalBuffer();
        }
        byte[] fixedLengthBytes = byArray;
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])fixedLengthBytes, (int)0, (int)numBytes$1));
    }

    public static final /* synthetic */ void $anonfun$makeArrayWriter$1(ParquetWriteSupport $this, String repeatedGroupName$1, String elementFieldName$1, Function2 elementWriter$1, SpecializedGetters row, int ordinal) {
        ArrayData array = row.getArray(ordinal);
        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            block0: {
                if (array.numElements() <= 0) break block0;
                $this.consumeField(repeatedGroupName$1, 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    IntRef i = IntRef.create((int)0);
                    while (i.elem < array.numElements()) {
                        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                            block0: {
                                if (array.isNullAt(i$2.elem)) break block0;
                                $this.consumeField(elementFieldName$1, 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> elementWriter$1.apply((Object)array, (Object)BoxesRunTime.boxToInteger((int)i$2.elem)));
                            }
                        });
                        ++i.elem;
                    }
                });
            }
        });
    }

    private final Function2 threeLevelArrayWriter$1(String repeatedGroupName, String elementFieldName, Function2 elementWriter$1) {
        return (Function2 & Serializable)(row, ordinal) -> {
            ParquetWriteSupport.$anonfun$makeArrayWriter$1(this, repeatedGroupName, elementFieldName, elementWriter$1, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
    }

    public static final /* synthetic */ void $anonfun$makeArrayWriter$6(ParquetWriteSupport $this, String repeatedFieldName$1, Function2 elementWriter$1, SpecializedGetters row, int ordinal) {
        ArrayData array = row.getArray(ordinal);
        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            block0: {
                if (array.numElements() <= 0) break block0;
                $this.consumeField(repeatedFieldName$1, 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    for (int i = 0; i < array.numElements(); ++i) {
                        elementWriter$1.apply((Object)array, (Object)BoxesRunTime.boxToInteger((int)i));
                    }
                });
            }
        });
    }

    private final Function2 twoLevelArrayWriter$1(String repeatedFieldName, Function2 elementWriter$1) {
        return (Function2 & Serializable)(row, ordinal) -> {
            ParquetWriteSupport.$anonfun$makeArrayWriter$6(this, repeatedFieldName, elementWriter$1, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
    }

    public static final /* synthetic */ void $anonfun$makeMapWriter$1(ParquetWriteSupport $this, String repeatedGroupName$2, Function2 keyWriter$1, Function2 valueWriter$1, SpecializedGetters row, int ordinal) {
        MapData map = row.getMap(ordinal);
        ArrayData keyArray = map.keyArray();
        ArrayData valueArray = map.valueArray();
        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            block0: {
                if (map.numElements() <= 0) break block0;
                $this.consumeField(repeatedGroupName$2, 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    IntRef i = IntRef.create((int)0);
                    while (i.elem < map.numElements()) {
                        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                            block0: {
                                $this.consumeField("key", 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> keyWriter$1.apply((Object)keyArray, (Object)BoxesRunTime.boxToInteger((int)i$3.elem)));
                                if (map.valueArray().isNullAt(i$3.elem)) break block0;
                                $this.consumeField("value", 1, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> valueWriter$1.apply((Object)valueArray, (Object)BoxesRunTime.boxToInteger((int)i$3.elem)));
                            }
                        });
                        ++i.elem;
                    }
                });
            }
        });
    }

    public ParquetWriteSupport() {
        Logging.$init$((Logging)this);
        this.timestampBuffer = new byte[12];
        this.decimalBuffer = new byte[Decimal$.MODULE$.minBytesForPrecision()[DecimalType$.MODULE$.MAX_PRECISION()]];
        this.datetimeRebaseMode = SQLConf.LegacyBehaviorPolicy$.MODULE$.withName((String)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.PARQUET_REBASE_MODE_IN_WRITE()));
        this.dateRebaseFunc = DataSourceUtils$.MODULE$.creteDateRebaseFuncInWrite(this.datetimeRebaseMode(), "Parquet");
        this.timestampRebaseFunc = DataSourceUtils$.MODULE$.creteTimestampRebaseFuncInWrite(this.datetimeRebaseMode(), "Parquet");
        this.int96RebaseMode = SQLConf.LegacyBehaviorPolicy$.MODULE$.withName((String)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.PARQUET_INT96_REBASE_MODE_IN_WRITE()));
        this.int96RebaseFunc = DataSourceUtils$.MODULE$.creteTimestampRebaseFuncInWrite(this.int96RebaseMode(), "Parquet INT96");
    }
}

