/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.IOException;
import java.time.ZoneId;
import java.util.PrimitiveIterator;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.ValuesType;
import org.apache.parquet.column.page.DataPage;
import org.apache.parquet.column.page.DataPageV1;
import org.apache.parquet.column.page.DataPageV2;
import org.apache.parquet.column.page.DictionaryPage;
import org.apache.parquet.column.page.PageReader;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.spark.sql.execution.datasources.parquet.ParquetDictionary;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadState;
import org.apache.spark.sql.execution.datasources.parquet.ParquetVectorUpdater;
import org.apache.spark.sql.execution.datasources.parquet.ParquetVectorUpdaterFactory;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedPlainValuesReader;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedRleValuesReader;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedValuesReader;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.Decimal;

public class VectorizedColumnReader {
    private final Dictionary dictionary;
    private boolean isCurrentPageDictionaryEncoded;
    private ValuesReader dataColumn;
    private VectorizedRleValuesReader defColumn;
    private final ParquetVectorUpdaterFactory updaterFactory;
    private final ParquetReadState readState;
    private long pageFirstRowIndex;
    private final PageReader pageReader;
    private final ColumnDescriptor descriptor;
    private final LogicalTypeAnnotation logicalTypeAnnotation;
    private final String datetimeRebaseMode;

    public VectorizedColumnReader(ColumnDescriptor descriptor, LogicalTypeAnnotation logicalTypeAnnotation, PageReader pageReader, PrimitiveIterator.OfLong rowIndexes, ZoneId convertTz, String datetimeRebaseMode, String int96RebaseMode) throws IOException {
        this.descriptor = descriptor;
        this.pageReader = pageReader;
        this.readState = new ParquetReadState(descriptor.getMaxDefinitionLevel(), rowIndexes);
        this.logicalTypeAnnotation = logicalTypeAnnotation;
        this.updaterFactory = new ParquetVectorUpdaterFactory(logicalTypeAnnotation, convertTz, datetimeRebaseMode, int96RebaseMode);
        DictionaryPage dictionaryPage = pageReader.readDictionaryPage();
        if (dictionaryPage != null) {
            try {
                this.dictionary = dictionaryPage.getEncoding().initDictionary(descriptor, dictionaryPage);
                this.isCurrentPageDictionaryEncoded = true;
            }
            catch (IOException e) {
                throw new IOException("could not decode the dictionary for " + descriptor, e);
            }
        } else {
            this.dictionary = null;
            this.isCurrentPageDictionaryEncoded = false;
        }
        if (pageReader.getTotalValueCount() == 0L) {
            throw new IOException("totalValueCount == 0");
        }
        assert ("LEGACY".equals(datetimeRebaseMode) || "EXCEPTION".equals(datetimeRebaseMode) || "CORRECTED".equals(datetimeRebaseMode));
        this.datetimeRebaseMode = datetimeRebaseMode;
        assert ("LEGACY".equals(int96RebaseMode) || "EXCEPTION".equals(int96RebaseMode) || "CORRECTED".equals(int96RebaseMode));
    }

    private boolean isLazyDecodingSupported(PrimitiveType.PrimitiveTypeName typeName) {
        boolean isSupported = false;
        switch (typeName) {
            case INT32: {
                isSupported = !(this.logicalTypeAnnotation instanceof LogicalTypeAnnotation.DateLogicalTypeAnnotation) || "CORRECTED".equals(this.datetimeRebaseMode);
                break;
            }
            case INT64: {
                if (this.updaterFactory.isTimestampTypeMatched(LogicalTypeAnnotation.TimeUnit.MICROS)) {
                    isSupported = "CORRECTED".equals(this.datetimeRebaseMode);
                    break;
                }
                isSupported = !this.updaterFactory.isTimestampTypeMatched(LogicalTypeAnnotation.TimeUnit.MILLIS);
                break;
            }
            case FLOAT: 
            case DOUBLE: 
            case BINARY: {
                isSupported = true;
            }
        }
        return isSupported;
    }

    void readBatch(int total, WritableColumnVector column) throws IOException {
        WritableColumnVector dictionaryIds = null;
        ParquetVectorUpdater updater = this.updaterFactory.getUpdater(this.descriptor, column.dataType());
        if (this.dictionary != null) {
            dictionaryIds = column.reserveDictionaryIds(total);
        }
        this.readState.resetForNewBatch(total);
        while (this.readState.valuesToReadInBatch > 0) {
            if (this.readState.valuesToReadInPage == 0) {
                int pageValueCount = this.readPage();
                this.readState.resetForNewPage(pageValueCount, this.pageFirstRowIndex);
            }
            PrimitiveType.PrimitiveTypeName typeName = this.descriptor.getPrimitiveType().getPrimitiveTypeName();
            if (this.isCurrentPageDictionaryEncoded) {
                int startOffset = this.readState.offset;
                long startRowId = this.readState.rowId;
                this.defColumn.readIntegers(this.readState, dictionaryIds, column, (VectorizedValuesReader)this.dataColumn);
                if (column.hasDictionary() || startRowId == this.pageFirstRowIndex && this.isLazyDecodingSupported(typeName)) {
                    PrimitiveType primitiveType = this.descriptor.getPrimitiveType();
                    LogicalTypeAnnotation typeAnnotation = primitiveType.getLogicalTypeAnnotation();
                    boolean castLongToInt = typeAnnotation instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation && ((LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)typeAnnotation).getPrecision() <= Decimal.MAX_INT_DIGITS() && primitiveType.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT64;
                    boolean isUnsignedInt32 = this.updaterFactory.isUnsignedIntTypeMatched(32);
                    boolean isUnsignedInt64 = this.updaterFactory.isUnsignedIntTypeMatched(64);
                    boolean needTransform = castLongToInt || isUnsignedInt32 || isUnsignedInt64;
                    column.setDictionary(new ParquetDictionary(this.dictionary, needTransform));
                    continue;
                }
                updater.decodeDictionaryIds(this.readState.offset - startOffset, startOffset, column, dictionaryIds, this.dictionary);
                continue;
            }
            if (column.hasDictionary() && this.readState.offset != 0) {
                updater.decodeDictionaryIds(this.readState.offset, 0, column, dictionaryIds, this.dictionary);
            }
            column.setDictionary(null);
            VectorizedValuesReader valuesReader = (VectorizedValuesReader)this.dataColumn;
            this.defColumn.readBatch(this.readState, column, valuesReader, updater);
        }
    }

    private int readPage() {
        DataPage page = this.pageReader.readPage();
        this.pageFirstRowIndex = page.getFirstRowIndex().orElse(0L);
        return (Integer)page.accept((DataPage.Visitor)new DataPage.Visitor<Integer>(){

            public Integer visit(DataPageV1 dataPageV1) {
                try {
                    return VectorizedColumnReader.this.readPageV1(dataPageV1);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public Integer visit(DataPageV2 dataPageV2) {
                try {
                    return VectorizedColumnReader.this.readPageV2(dataPageV2);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private void initDataReader(int pageValueCount, Encoding dataEncoding, ByteBufferInputStream in) throws IOException {
        if (dataEncoding.usesDictionary()) {
            this.dataColumn = null;
            if (this.dictionary == null) {
                throw new IOException("could not read page in col " + this.descriptor + " as the dictionary was missing for encoding " + dataEncoding);
            }
            Encoding plainDict = Encoding.PLAIN_DICTIONARY;
            if (dataEncoding != plainDict && dataEncoding != Encoding.RLE_DICTIONARY) {
                throw new UnsupportedOperationException("Unsupported encoding: " + dataEncoding);
            }
            this.dataColumn = new VectorizedRleValuesReader();
            this.isCurrentPageDictionaryEncoded = true;
        } else {
            if (dataEncoding != Encoding.PLAIN) {
                throw new UnsupportedOperationException("Unsupported encoding: " + dataEncoding);
            }
            this.dataColumn = new VectorizedPlainValuesReader();
            this.isCurrentPageDictionaryEncoded = false;
        }
        try {
            this.dataColumn.initFromPage(pageValueCount, in);
        }
        catch (IOException e) {
            throw new IOException("could not read page in col " + this.descriptor, e);
        }
    }

    private int readPageV1(DataPageV1 page) throws IOException {
        if (page.getDlEncoding() != Encoding.RLE && this.descriptor.getMaxDefinitionLevel() != 0) {
            throw new UnsupportedOperationException("Unsupported encoding: " + page.getDlEncoding());
        }
        int pageValueCount = page.getValueCount();
        int bitWidth = BytesUtils.getWidthFromMaxInt((int)this.descriptor.getMaxDefinitionLevel());
        this.defColumn = new VectorizedRleValuesReader(bitWidth);
        try {
            BytesInput bytes = page.getBytes();
            ByteBufferInputStream in = bytes.toInputStream();
            page.getRlEncoding().getValuesReader(this.descriptor, ValuesType.REPETITION_LEVEL).initFromPage(pageValueCount, in);
            this.defColumn.initFromPage(pageValueCount, in);
            this.initDataReader(pageValueCount, page.getValueEncoding(), in);
            return pageValueCount;
        }
        catch (IOException e) {
            throw new IOException("could not read page " + page + " in col " + this.descriptor, e);
        }
    }

    private int readPageV2(DataPageV2 page) throws IOException {
        int pageValueCount = page.getValueCount();
        int bitWidth = BytesUtils.getWidthFromMaxInt((int)this.descriptor.getMaxDefinitionLevel());
        this.defColumn = new VectorizedRleValuesReader(bitWidth, false);
        this.defColumn.initFromPage(pageValueCount, page.getDefinitionLevels().toInputStream());
        try {
            this.initDataReader(pageValueCount, page.getDataEncoding(), page.getData().toInputStream());
            return pageValueCount;
        }
        catch (IOException e) {
            throw new IOException("could not read page " + page + " in col " + this.descriptor, e);
        }
    }
}

