/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URI;
import java.time.ZoneId;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.StatisticsCollectionSuite$;
import org.apache.spark.sql.StatisticsCollectionTestBase;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.catalog.CatalogColumnStat;
import org.apache.spark.sql.catalyst.catalog.CatalogColumnStat$;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat$;
import org.apache.spark.sql.catalyst.plans.logical.Join;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.OneRowRelation;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.plans.logical.Statistics$;
import org.apache.spark.sql.catalyst.util.DateTimeTestUtils$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.test.SQLTestData;
import org.apache.spark.sql.test.SQLTestUtils;
import org.apache.spark.sql.test.SharedSparkSession;
import org.apache.spark.sql.test.SharedSparkSessionBase;
import org.apache.spark.sql.test.TestSparkSession;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product13;
import scala.Some;
import scala.StringContext;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005=2Aa\u0001\u0003\u0001\u001b!)\u0001\u0004\u0001C\u00013!)1\u0004\u0001C\u00019\tI2\u000b^1uSN$\u0018nY:D_2dWm\u0019;j_:\u001cV/\u001b;f\u0015\t)a!A\u0002tc2T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\r\u0001aB\u0005\t\u0003\u001fAi\u0011\u0001B\u0005\u0003#\u0011\u0011Ad\u0015;bi&\u001cH/[2t\u0007>dG.Z2uS>tG+Z:u\u0005\u0006\u001cX\r\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\t\u0005!A/Z:u\u0013\t9BC\u0001\nTQ\u0006\u0014X\rZ*qCJ\\7+Z:tS>t\u0017A\u0002\u001fj]&$h\bF\u0001\u001b!\ty\u0001!\u0001\thKR\u001cF/\u0019;BiR\u0014h*Y7fgR\u0011Q$\f\t\u0004=\u001dRcBA\u0010&!\t\u00013%D\u0001\"\u0015\t\u0011C\"\u0001\u0004=e>|GO\u0010\u0006\u0002I\u0005)1oY1mC&\u0011aeI\u0001\u0007!J,G-\u001a4\n\u0005!J#aA*fi*\u0011ae\t\t\u0003=-J!\u0001L\u0015\u0003\rM#(/\u001b8h\u0011\u0015q#\u00011\u0001+\u0003%!\u0018M\u00197f\u001d\u0006lW\r")
public class StatisticsCollectionSuite
extends StatisticsCollectionTestBase
implements SharedSparkSession {
    private boolean enableAutoThreadAudit;
    private TestSparkSession org$apache$spark$sql$test$SharedSparkSessionBase$$_spark;

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$beforeAll() {
        SharedSparkSessionBase.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$afterAll() {
        SharedSparkSessionBase.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        SharedSparkSession.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        SharedSparkSession.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$beforeAll() {
        SQLTestUtils.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    @Override
    public SparkConf sparkConf() {
        return SharedSparkSessionBase.sparkConf$(this);
    }

    @Override
    public SparkSession spark() {
        return SharedSparkSessionBase.spark$(this);
    }

    @Override
    public SQLContext sqlContext() {
        return SharedSparkSessionBase.sqlContext$(this);
    }

    @Override
    public TestSparkSession createSparkSession() {
        return SharedSparkSessionBase.createSparkSession$(this);
    }

    @Override
    public void initializeSession() {
        SharedSparkSessionBase.initializeSession$(this);
    }

    @Override
    public void beforeEach() {
        SharedSparkSessionBase.beforeEach$(this);
    }

    @Override
    public void afterEach() {
        SharedSparkSessionBase.afterEach$(this);
    }

    @Override
    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSparkSession$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    @Override
    public TestSparkSession org$apache$spark$sql$test$SharedSparkSessionBase$$_spark() {
        return this.org$apache$spark$sql$test$SharedSparkSessionBase$$_spark;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSparkSessionBase$$_spark_$eq(TestSparkSession x$1) {
        this.org$apache$spark$sql$test$SharedSparkSessionBase$$_spark = x$1;
    }

    public Set<String> getStatAttrNames(String tableName) {
        AttributeMap queryStats = this.spark().table(tableName).queryExecution().optimizedPlan().stats().attributeStats();
        return ((IterableOnceOps)queryStats.map((Function1 & Serializable)x$3 -> ((NamedExpression)x$3._1()).name())).toSet();
    }

    private final void assertAnalyzeUnsupported$1(String analyzeCommand) {
        AnalysisException err = (AnalysisException)((Object)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)analyzeCommand), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66)));
        String $org_scalatest_assert_macro_left = err.message();
        String $org_scalatest_assert_macro_right = "ANALYZE TABLE is not supported";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
    }

    public static final /* synthetic */ void $anonfun$new$23(StatisticsCollectionSuite $this, Dataset df$2, LinkedHashMap s) {
        ((IterableOnceOps)s.zip((IterableOnce)df$2.schema())).foreach((Function1 & Serializable)x0$1 -> {
            StructField field;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x0$1;
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._1();
                    field = (StructField)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            String k = (String)tuple2._1();
            CatalogColumnStat v = (CatalogColumnStat)tuple2._2();
            Assertion assertion = (Assertion)$this.withClue(new StringBuilder(18).append("column ").append(k).append(" with type ").append(field.dataType()).toString(), (Function0 & Serializable)() -> {
                Option roundtrip;
                Option $org_scalatest_assert_macro_left = roundtrip = CatalogColumnStat$.MODULE$.fromMap("table_is_foo", field.name(), v.toMap(k));
                Some $org_scalatest_assert_macro_right = new Some((Object)v);
                Option option = $org_scalatest_assert_macro_left;
                Some some = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
            });
            return assertion;
        });
    }

    public static final /* synthetic */ void $anonfun$new$45(StatisticsCollectionSuite $this, String table$3, boolean autoUpdate$1, String initLocation$1, Option fetched1$1, File tableLoc$1, File newLocation) {
        $this.sql().apply((Object)new StringBuilder(28).append("ALTER TABLE ").append(table$3).append(" SET LOCATION '").append(newLocation.toURI().toString()).append("'").toString());
        if (autoUpdate$1) {
            Option<CatalogStatistics> fetched2 = $this.checkTableStats(table$3, true, (Option<Object>)None$.MODULE$);
            BigInt $org_scalatest_assert_macro_left = ((CatalogStatistics)fetched2.get()).sizeInBytes();
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), BoxesRunTime.equalsNumObject((Number)$org_scalatest_assert_macro_left, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
            Map $org_scalatest_assert_macro_left2 = ((CatalogStatistics)fetched2.get()).colStats();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 282));
            $this.sql().apply((Object)new StringBuilder(28).append("ALTER TABLE ").append(table$3).append(" SET LOCATION '").append(initLocation$1).append("'").toString());
            Option<CatalogStatistics> fetched3 = $this.checkTableStats(table$3, true, (Option<Object>)None$.MODULE$);
            BigInt $org_scalatest_assert_macro_left3 = ((CatalogStatistics)fetched3.get()).sizeInBytes();
            BigInt $org_scalatest_assert_macro_right2 = ((CatalogStatistics)fetched1$1.get()).sizeInBytes();
            BigInt bigInt = $org_scalatest_assert_macro_left3;
            BigInt bigInt2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(bigInt != null ? !bigInt.equals(bigInt2) : bigInt2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 287));
        } else {
            $this.checkTableStats(table$3, false, (Option<Object>)None$.MODULE$);
            $this.waitForTasksToFinish();
            Utils$.MODULE$.deleteRecursively(tableLoc$1);
        }
    }

    private final void checkTimestampStats$1(DataType t, TimeZone srcTimeZone, TimeZone dstTimeZone, Function1 checker, int start$1, long end$1) {
        String table = "time_table";
        String column = "T";
        TimeZone original = TimeZone.getDefault();
        try {
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{table}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                TimeZone.setDefault(srcTimeZone);
                this.spark().range((long)start$1, end$1).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.timestamp_seconds((Column)this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$)).cast(t).as(column)})).write().saveAsTable(table);
                this.sql().apply((Object)new StringBuilder(46).append("ANALYZE TABLE ").append(table).append(" COMPUTE STATISTICS FOR COLUMNS ").append(column).toString());
                TimeZone.setDefault(dstTimeZone);
                ColumnStat stats = ((CatalogColumnStat)((CatalogStatistics)this.getCatalogTable(table).stats().get()).colStats().apply((Object)column)).toPlanStat(column, t);
                checker.apply((Object)stats);
            });
        }
        finally {
            TimeZone.setDefault(original);
        }
    }

    public static final /* synthetic */ void $anonfun$new$70(int start$1, long end$1, ColumnStat stats) {
        int $org_scalatest_assert_macro_left = BoxesRunTime.unboxToInt((Object)stats.min().get());
        long $org_scalatest_assert_macro_right = TimeUnit.SECONDS.toDays(start$1);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), (long)$org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 463));
        int $org_scalatest_assert_macro_left2 = BoxesRunTime.unboxToInt((Object)stats.max().get());
        long $org_scalatest_assert_macro_right2 = TimeUnit.SECONDS.toDays(end$1 - 1L);
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), (long)$org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 464));
    }

    public static final /* synthetic */ void $anonfun$new$71(int start$1, long end$1, ColumnStat stats) {
        long $org_scalatest_assert_macro_left = BoxesRunTime.unboxToLong((Object)stats.min().get());
        long $org_scalatest_assert_macro_right = TimeUnit.SECONDS.toMicros(start$1);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 467));
        long $org_scalatest_assert_macro_left2 = BoxesRunTime.unboxToLong((Object)stats.max().get());
        long $org_scalatest_assert_macro_right2 = TimeUnit.SECONDS.toMicros(end$1 - 1L);
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 468));
    }

    public static final /* synthetic */ void $anonfun$new$69(StatisticsCollectionSuite $this, int start$1, long end$1, ZoneId zid) {
        TimeZone timeZone = TimeZone.getTimeZone(zid);
        $this.checkTimestampStats$1((DataType)DateType$.MODULE$, DateTimeUtils$.MODULE$.TimeZoneUTC(), timeZone, (Function1 & Serializable)stats -> {
            StatisticsCollectionSuite.$anonfun$new$70(start$1, end$1, stats);
            return BoxedUnit.UNIT;
        }, start$1, end$1);
        $this.checkTimestampStats$1((DataType)TimestampType$.MODULE$, DateTimeUtils$.MODULE$.TimeZoneUTC(), timeZone, (Function1 & Serializable)stats -> {
            StatisticsCollectionSuite.$anonfun$new$71(start$1, end$1, stats);
            return BoxedUnit.UNIT;
        }, start$1, end$1);
    }

    public static final /* synthetic */ void $anonfun$new$82(StatisticsCollectionSuite $this, String database) {
        $this.sql().apply((Object)new StringBuilder(28).append("CREATE VIEW ").append(database).append(".v AS SELECT 1 c").toString());
        $this.sql().apply((Object)new StringBuilder(14).append("CACHE TABLE ").append(database).append(".v").toString());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer($this.getStatAttrNames(new StringBuilder(2).append(database).append(".v").toString()));
        Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!==", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$bang$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 542));
        $this.sql().apply((Object)new StringBuilder(49).append("ANALYZE TABLE ").append(database).append(".v COMPUTE STATISTICS FOR COLUMNS c").toString());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer($this.getStatAttrNames(new StringBuilder(2).append(database).append(".v").toString()));
        Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 544));
    }

    private final Statistics getTableStats$1(String tableName) {
        return this.spark().table(tableName).queryExecution().optimizedPlan().stats();
    }

    public static final /* synthetic */ void $anonfun$new$84(StatisticsCollectionSuite $this, String database) {
        $this.sql().apply((Object)new StringBuilder(28).append("CREATE VIEW ").append(database).append(".v AS SELECT 1 c").toString());
        $this.sql().apply((Object)new StringBuilder(14).append("CACHE TABLE ").append(database).append(".v").toString());
        Statistics stats1 = $this.getTableStats$1(new StringBuilder(2).append(database).append(".v").toString());
        BigInt $org_scalatest_assert_macro_left = stats1.sizeInBytes();
        BigInt $org_scalatest_assert_macro_right = BigInt$.MODULE$.int2bigInt(0);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, ">", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$greater((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 558));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(stats1.rowCount());
        Some $org_scalatest_assert_macro_right2 = new Some((Object)BoxesRunTime.boxToInteger((int)1));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 559));
        $this.sql().apply((Object)new StringBuilder(16).append("UNCACHE TABLE ").append(database).append(".v").toString());
        $this.sql().apply((Object)new StringBuilder(19).append("CACHE LAZY TABLE ").append(database).append(".v").toString());
        Statistics stats2 = $this.getTableStats$1(new StringBuilder(2).append(database).append(".v").toString());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(stats2.sizeInBytes());
        BigInt $org_scalatest_assert_macro_right3 = new OneRowRelation().computeStats().sizeInBytes();
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 565));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(stats2.rowCount());
        None$ $org_scalatest_assert_macro_right4 = None$.MODULE$;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 566));
        $this.sql().apply((Object)new StringBuilder(42).append("ANALYZE TABLE ").append(database).append(".v COMPUTE STATISTICS NOSCAN").toString());
        Statistics stats3 = $this.getTableStats$1(new StringBuilder(2).append(database).append(".v").toString());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = $this.convertToEqualizer(stats3.sizeInBytes());
        BigInt $org_scalatest_assert_macro_right5 = new OneRowRelation().computeStats().sizeInBytes();
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 570));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = $this.convertToEqualizer(stats3.rowCount());
        None$ $org_scalatest_assert_macro_right6 = None$.MODULE$;
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 571));
        $this.sql().apply((Object)new StringBuilder(35).append("ANALYZE TABLE ").append(database).append(".v COMPUTE STATISTICS").toString());
        Statistics stats4 = $this.getTableStats$1(new StringBuilder(2).append(database).append(".v").toString());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = $this.convertToEqualizer(stats4.sizeInBytes());
        BigInt $org_scalatest_assert_macro_right7 = stats1.sizeInBytes();
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 575));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = $this.convertToEqualizer(stats4.rowCount());
        Some $org_scalatest_assert_macro_right8 = new Some((Object)BoxesRunTime.boxToInteger((int)1));
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 576));
    }

    public static final /* synthetic */ void $anonfun$new$90(StatisticsCollectionSuite $this, File tempDir) {
        String tableName = "t1";
        String stagingDirName = ".test-staging-dir";
        String tableLocation = new StringBuilder(1).append(tempDir.toURI()).append("/").append(tableName).toString();
        $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.AUTO_SIZE_UPDATE_ENABLED().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.exec.stagingdir"), (Object)stagingDirName)}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(50).append("CREATE TABLE ").append(tableName).append("(c1 BIGINT) USING PARQUET LOCATION '").append(tableLocation).append("'").toString());
            $this.sql().apply((Object)new StringBuilder(28).append("INSERT INTO TABLE ").append(tableName).append(" VALUES(1)").toString());
            File staging = new File(new URI(new StringBuilder(1).append(tableLocation).append("/").append(stagingDirName).toString()));
            Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> new PrintWriter(staging), (Function1 & Serializable)stagingWriter -> {
                stagingWriter.write("12");
                return BoxedUnit.UNIT;
            });
            File metadata = new File(new URI(new StringBuilder(10).append(tableLocation).append("/_metadata").toString()));
            Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> new PrintWriter(metadata), (Function1 & Serializable)metadataWriter -> {
                metadataWriter.write("1234");
                return BoxedUnit.UNIT;
            });
            $this.sql().apply((Object)new StringBuilder(28).append("INSERT INTO TABLE ").append(tableName).append(" VALUES(1)").toString());
            long stagingFileSize = staging.length();
            long metadataFileSize = metadata.length();
            long tableLocationSize = $this.getDataSize(new File(new URI(tableLocation)));
            Option<CatalogStatistics> stats = $this.checkTableStats(tableName, true, (Option<Object>)None$.MODULE$);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(((CatalogStatistics)stats.get()).sizeInBytes());
            long $org_scalatest_assert_macro_right = tableLocationSize - stagingFileSize - metadataFileSize;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 627));
        }));
    }

    public static final /* synthetic */ void $anonfun$new$106(StatisticsCollectionSuite $this, String database) {
        $this.spark().catalog().setCurrentDatabase(database);
        $this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "t2"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.spark().range(10L).write().saveAsTable("t1");
                $this.sql().apply((Object)new StringBuilder(26).append(new StringBuilder(51).append("CREATE EXTERNAL TABLE t2 USING parquet LOCATION '").append(dir.toURI()).append("' ").toString()).append("AS SELECT * FROM range(20)").toString());
                $this.withView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"v1", "v2"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    $this.sql().apply((Object)"CREATE VIEW v1 AS SELECT 1 c1");
                    $this.sql().apply((Object)"CREATE VIEW v2 AS SELECT 2 c2");
                    $this.sql().apply((Object)"CACHE TABLE v1");
                    $this.sql().apply((Object)"CACHE LAZY TABLE v2");
                    $this.sql().apply((Object)new StringBuilder(44).append("ANALYZE TABLES IN ").append(database$1).append(" COMPUTE STATISTICS NOSCAN").toString());
                    $this.checkTableStats("t1", true, (Option<Object>)None$.MODULE$);
                    $this.checkTableStats("t2", true, (Option<Object>)None$.MODULE$);
                    Option $org_scalatest_assert_macro_left = $this.getCatalogTable("v1").stats();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 699));
                    $this.checkOptimizedPlanStats((Dataset<Row>)$this.spark().table("v1"), BigInt$.MODULE$.int2bigInt(4), (Option<BigInt>)new Some((Object)BigInt$.MODULE$.int2bigInt(1)), (Seq<ColumnStat>)((Seq)scala.package$.MODULE$.Seq().empty()));
                    $this.checkOptimizedPlanStats((Dataset<Row>)$this.spark().table("v2"), BigInt$.MODULE$.int2bigInt(1), (Option<BigInt>)None$.MODULE$, (Seq<ColumnStat>)((Seq)scala.package$.MODULE$.Seq().empty()));
                    $this.sql().apply((Object)"ANALYZE TABLES COMPUTE STATISTICS");
                    $this.checkTableStats("t1", true, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)10)));
                    $this.checkTableStats("t2", true, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)20)));
                    $this.checkOptimizedPlanStats((Dataset<Row>)$this.spark().table("v1"), BigInt$.MODULE$.int2bigInt(4), (Option<BigInt>)new Some((Object)BigInt$.MODULE$.int2bigInt(1)), (Seq<ColumnStat>)((Seq)scala.package$.MODULE$.Seq().empty()));
                    $this.checkOptimizedPlanStats((Dataset<Row>)$this.spark().table("v2"), BigInt$.MODULE$.int2bigInt(4), (Option<BigInt>)new Some((Object)BigInt$.MODULE$.int2bigInt(1)), (Seq<ColumnStat>)((Seq)scala.package$.MODULE$.Seq().empty()));
                });
            });
            return BoxedUnit.UNIT;
        });
    }

    public StatisticsCollectionSuite() {
        SharedSparkSessionBase.$init$(this);
        SharedSparkSession.$init$(this);
        this.test("estimates the size of a limit 0 on outer join", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(StatisticsCollectionSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_StatisticsCollectionSuite$$typecreator10$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_StatisticsCollectionSuite$$typecreator10$1(StatisticsCollectionSuite $outer) {
                }
            }
            this.testImplicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"one", (Object)BoxesRunTime.boxToInteger((int)1)), new Tuple2((Object)"two", (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple2((Object)"three", (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple2((Object)"four", (Object)BoxesRunTime.boxToInteger((int)4))})), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_StatisticsCollectionSuite$$typecreator10$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"k", "v"})).createOrReplaceTempView("test");
            Dataset df1 = this.spark().table("test");
            Dataset df2 = this.spark().table("test").limit(0);
            Dataset df = df1.join(df2, (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"k"})), "left");
            Seq sizes = df.queryExecution().analyzed().collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof Join) {
                        Join join = (Join)A1;
                        object = join.stats().sizeInBytes();
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(LogicalPlan x1) {
                    LogicalPlan logicalPlan = x1;
                    boolean bl = logicalPlan instanceof Join;
                    return bl;
                }
            });
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)sizes.size()));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(32).append("number of Join nodes is wrong:\n ").append(df.queryExecution()).toString(), Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(sizes.head());
            BigInt $org_scalatest_assert_macro_right2 = scala.package$.MODULE$.BigInt().apply(128);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)new StringBuilder(46).append("expected exact size 96 for table 'test', got: ").append(sizes.head()).toString(), Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
        }), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
        this.test("analyzing views is not supported", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String tableName = "tbl";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.spark().range(10L).write().saveAsTable(tableName);
                String viewName = "view";
                this.withView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{viewName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    this.sql().apply((Object)new StringBuilder(30).append("CREATE VIEW ").append(viewName).append(" AS SELECT * FROM ").append(tableName).toString());
                    this.assertAnalyzeUnsupported$1(new StringBuilder(33).append("ANALYZE TABLE ").append(viewName).append(" COMPUTE STATISTICS").toString());
                    this.assertAnalyzeUnsupported$1(new StringBuilder(48).append("ANALYZE TABLE ").append(viewName).append(" COMPUTE STATISTICS FOR COLUMNS id").toString());
                });
            });
        }, new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
        this.test("statistics collection of a table with zero column", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String table_no_cols = "table_no_cols";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{table_no_cols}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                SparkContext qual$1 = this.sparkContext();
                Range.Inclusive x$12 = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10);
                int x$2 = qual$1.parallelize$default$2();
                RDD rddNoCols = qual$1.parallelize((Seq)x$12, x$2, (ClassTag)ClassTag$.MODULE$.Int()).map((Function1 & Serializable)x$1 -> Row$.MODULE$.empty(), ClassTag$.MODULE$.apply(Row.class));
                Dataset dfNoCols = this.spark().createDataFrame(rddNoCols, StructType$.MODULE$.apply((Seq)scala.package$.MODULE$.Seq().empty()));
                dfNoCols.write().format("json").saveAsTable(table_no_cols);
                this.sql().apply((Object)new StringBuilder(33).append("ANALYZE TABLE ").append(table_no_cols).append(" COMPUTE STATISTICS").toString());
                this.checkTableStats(table_no_cols, true, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)10)));
            });
        }, new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
        this.test("analyze empty table", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String table = "emptyTable";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{table}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                Dataset df = this.testImplicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().empty(), this.testImplicits().newIntEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"key"}));
                df.write().format("json").saveAsTable(table);
                this.sql().apply((Object)new StringBuilder(40).append("ANALYZE TABLE ").append(table).append(" COMPUTE STATISTICS noscan").toString());
                Option<CatalogStatistics> fetchedStats1 = this.checkTableStats(table, true, (Option<Object>)None$.MODULE$);
                BigInt $org_scalatest_assert_macro_left = ((CatalogStatistics)fetchedStats1.get()).sizeInBytes();
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), BoxesRunTime.equalsNumObject((Number)$org_scalatest_assert_macro_left, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
                this.sql().apply((Object)new StringBuilder(33).append("ANALYZE TABLE ").append(table).append(" COMPUTE STATISTICS").toString());
                Option<CatalogStatistics> fetchedStats2 = this.checkTableStats(table, true, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)));
                BigInt $org_scalatest_assert_macro_left2 = ((CatalogStatistics)fetchedStats2.get()).sizeInBytes();
                int $org_scalatest_assert_macro_right2 = 0;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), BoxesRunTime.equalsNumObject((Number)$org_scalatest_assert_macro_left2, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2)), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
                Tuple2 expectedColStat = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key"), (Object)new CatalogColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)IntegerType$.MODULE$.defaultSize())), (Option)new Some((Object)BoxesRunTime.boxToLong((long)IntegerType$.MODULE$.defaultSize())), CatalogColumnStat$.MODULE$.apply$default$7(), CatalogColumnStat$.MODULE$.apply$default$8()));
                scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"true", "false"})).foreach((Function1 & Serializable)histogramEnabled -> {
                    this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.HISTOGRAM_ENABLED().key()), (Object)histogramEnabled)}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.checkColStats((Dataset<Row>)df, (LinkedHashMap<String, CatalogColumnStat>)((LinkedHashMap)LinkedHashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{expectedColStat})))));
                    return BoxedUnit.UNIT;
                });
            });
        }, new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
        this.test("analyze column command - unsupported types and invalid columns", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String tableName = "column_stats_test1";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(StatisticsCollectionSuite.class.getClassLoader());
                public final class Org_apache_spark_sql_StatisticsCollectionSuite$$typecreator20$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("org")), (Symbols.SymbolApi)$m.staticPackage("org.apache")), (Symbols.SymbolApi)$m.staticPackage("org.apache.spark")), (Symbols.SymbolApi)$m.staticPackage("org.apache.spark.sql")), (Symbols.SymbolApi)$m.staticPackage("org.apache.spark.sql.test")), (Symbols.SymbolApi)$m.staticModule("org.apache.spark.sql.test.SQLTestData")), (Symbols.SymbolApi)$m.staticClass("org.apache.spark.sql.test.SQLTestData.ArrayData"), (List)Nil$.MODULE$);
                    }

                    public Org_apache_spark_sql_StatisticsCollectionSuite$$typecreator20$1(StatisticsCollectionSuite $outer) {
                    }
                }
                this.testImplicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SQLTestData.ArrayData[]{new SQLTestData.ArrayData((Seq<Object>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (Seq<Seq<Object>>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))}))))})), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_StatisticsCollectionSuite$$typecreator20$1(null)))).toDF().write().saveAsTable(tableName);
                AnalysisException err1 = (AnalysisException)((Object)((Object)((Object)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(50).append("ANALYZE TABLE ").append(tableName).append(" COMPUTE STATISTICS FOR COLUMNS data").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126)))));
                String $org_scalatest_assert_macro_left = err1.message();
                String $org_scalatest_assert_macro_right = "does not support statistics collection";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
                AnalysisException err2 = (AnalysisException)((Object)((Object)((Object)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(64).append("ANALYZE TABLE ").append(tableName).append(" COMPUTE STATISTICS FOR COLUMNS some_random_column").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132)))));
                String $org_scalatest_assert_macro_left2 = err2.message();
                String $org_scalatest_assert_macro_right2 = "does not exist";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
            });
        }, new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
        this.test("test table-level statistics for data source table", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String tableName = "tbl";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(44).append("CREATE TABLE ").append(tableName).append("(i INT, j STRING) USING parquet").toString());
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(StatisticsCollectionSuite.class.getClassLoader());
                public final class Org_apache_spark_sql_StatisticsCollectionSuite$$typecreator30$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_sql_StatisticsCollectionSuite$$typecreator30$1(StatisticsCollectionSuite $outer) {
                    }
                }
                this.testImplicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"a"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"b")})), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_StatisticsCollectionSuite$$typecreator30$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"i", "j"})).write().mode("overwrite").insertInto(tableName);
                this.sql().apply((Object)new StringBuilder(40).append("ANALYZE TABLE ").append(tableName).append(" COMPUTE STATISTICS noscan").toString());
                this.checkTableStats(tableName, true, (Option<Object>)None$.MODULE$);
                this.sql().apply((Object)new StringBuilder(33).append("ANALYZE TABLE ").append(tableName).append(" COMPUTE STATISTICS").toString());
                this.checkTableStats(tableName, true, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)2)));
            });
        }, new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
        this.test("SPARK-15392: DataFrame created from RDD should not be broadcasted", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            SparkContext qual$2 = this.sparkContext();
            long x$3 = 1L;
            long x$4 = 100L;
            long x$5 = qual$2.range$default$3();
            int x$6 = qual$2.range$default$4();
            RDD rdd = qual$2.range(1L, 100L, x$5, x$6).map((Function1 & Serializable)i -> Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)i)), BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)i))})), ClassTag$.MODULE$.apply(Row.class));
            Dataset df = this.spark().createDataFrame(rdd, new StructType().add("a", (DataType)LongType$.MODULE$).add("b", (DataType)LongType$.MODULE$));
            BigInt $org_scalatest_assert_macro_left = df.queryExecution().analyzed().stats().sizeInBytes();
            BigInt $org_scalatest_assert_macro_right = BigInt$.MODULE$.long2bigInt(this.spark().sessionState().conf().autoBroadcastJoinThreshold());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, ">", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$greater((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
            BigInt $org_scalatest_assert_macro_left2 = df.selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})).queryExecution().analyzed().stats().sizeInBytes();
            BigInt $org_scalatest_assert_macro_right2 = BigInt$.MODULE$.long2bigInt(this.spark().sessionState().conf().autoBroadcastJoinThreshold());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, ">", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$greater((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
        }, new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
        this.test("column stats round trip serialization", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(StatisticsCollectionSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_StatisticsCollectionSuite$$typecreator40$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple13"), (List)List$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("java.lang.Boolean").asType().toTypeConstructor(), $m.staticClass("java.lang.Byte").asType().toTypeConstructor(), $m.staticClass("java.lang.Short").asType().toTypeConstructor(), $m.staticClass("java.lang.Integer").asType().toTypeConstructor(), $m.staticClass("java.lang.Long").asType().toTypeConstructor(), $m.staticClass("java.lang.Double").asType().toTypeConstructor(), $m.staticClass("java.lang.Float").asType().toTypeConstructor(), $m.staticClass("java.math.BigDecimal").asType().toTypeConstructor(), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Byte").asType().toTypeConstructor(), (List)Nil$.MODULE$)), $m.staticClass("java.sql.Date").asType().toTypeConstructor(), $m.staticClass("java.sql.Timestamp").asType().toTypeConstructor(), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("scala")), (Symbols.SymbolApi)$m.staticModule("scala.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.package").asModule().moduleClass(), "Seq"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))})));
                }

                public Org_apache_spark_sql_StatisticsCollectionSuite$$typecreator40$1(StatisticsCollectionSuite $outer) {
                }
            }
            Dataset df = this.testImplicits().localSeqToDatasetHolder(this.data(), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_StatisticsCollectionSuite$$typecreator40$1(null)))).toDF((Seq)this.stats().keys().toSeq().$colon$plus((Object)"carray"));
            scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LinkedHashMap[]{this.stats(), this.statsWithHgms()})).foreach((Function1 & Serializable)s -> {
                StatisticsCollectionSuite.$anonfun$new$23(this, df, s);
                return BoxedUnit.UNIT;
            });
        }, new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
        this.test("SPARK-33812: column stats round trip serialization with splitting histogram property", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.HIVE_TABLE_PROPERTY_LENGTH_THRESHOLD().key()), (Object)"10")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.statsWithHgms().foreach((Function1 & Serializable)x0$2 -> {
            Option roundtrip;
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            CatalogColumnStat v = (CatalogColumnStat)tuple2._2();
            Option $org_scalatest_assert_macro_left = roundtrip = CatalogColumnStat$.MODULE$.fromMap("t", k, v.toMap(k));
            Some $org_scalatest_assert_macro_right = new Some((Object)v);
            Option option = $org_scalatest_assert_macro_left;
            Some some = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
            Assertion assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
            return assertion;
        })), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
        this.test("analyze column command - result verification", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            LinkedHashMap<String, CatalogColumnStat> $org_scalatest_assert_macro_left = this.stats();
            int $org_scalatest_assert_macro_right = ((Product13)this.data().head()).productArity() - 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool($org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(StatisticsCollectionSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_StatisticsCollectionSuite$$typecreator50$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple13"), (List)List$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("java.lang.Boolean").asType().toTypeConstructor(), $m.staticClass("java.lang.Byte").asType().toTypeConstructor(), $m.staticClass("java.lang.Short").asType().toTypeConstructor(), $m.staticClass("java.lang.Integer").asType().toTypeConstructor(), $m.staticClass("java.lang.Long").asType().toTypeConstructor(), $m.staticClass("java.lang.Double").asType().toTypeConstructor(), $m.staticClass("java.lang.Float").asType().toTypeConstructor(), $m.staticClass("java.math.BigDecimal").asType().toTypeConstructor(), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Byte").asType().toTypeConstructor(), (List)Nil$.MODULE$)), $m.staticClass("java.sql.Date").asType().toTypeConstructor(), $m.staticClass("java.sql.Timestamp").asType().toTypeConstructor(), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("scala")), (Symbols.SymbolApi)$m.staticModule("scala.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.package").asModule().moduleClass(), "Seq"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))})));
                }

                public Org_apache_spark_sql_StatisticsCollectionSuite$$typecreator50$1(StatisticsCollectionSuite $outer) {
                }
            }
            Dataset df = this.testImplicits().localSeqToDatasetHolder(this.data(), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_StatisticsCollectionSuite$$typecreator50$1(null)))).toDF((Seq)this.stats().keys().toSeq().$colon$plus((Object)"carray"));
            this.checkColStats((Dataset<Row>)df, this.stats());
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.HISTOGRAM_ENABLED().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.HISTOGRAM_NUM_BINS().key()), (Object)"2")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.checkColStats((Dataset<Row>)df, this.statsWithHgms()));
        }, new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
        this.test("column stats collection for null columns", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Seq dataTypes = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AtomicType[]{BooleanType$.MODULE$, ByteType$.MODULE$, ShortType$.MODULE$, IntegerType$.MODULE$, LongType$.MODULE$, DoubleType$.MODULE$, FloatType$.MODULE$, DecimalType$.MODULE$.SYSTEM_DEFAULT(), StringType$.MODULE$, BinaryType$.MODULE$, DateType$.MODULE$, TimestampType$.MODULE$})).zipWithIndex();
            Dataset df = (Dataset)this.sql().apply((Object)new StringBuilder(7).append("select ").append(((IterableOnceOps)dataTypes.map((Function1 & Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                DataType tpe = (DataType)tuple2._1();
                int idx = tuple2._2$mcI$sp();
                String string = new StringBuilder(21).append("cast(null as ").append(tpe.sql()).append(") as col").append(idx).toString();
                return string;
            })).mkString(", ")).toString());
            Seq expectedColStats = (Seq)dataTypes.map((Function1 & Serializable)x0$4 -> {
                Tuple2 tuple2 = x0$4;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                DataType tpe = (DataType)tuple2._1();
                int idx = tuple2._2$mcI$sp();
                Tuple2 tuple22 = new Tuple2((Object)new StringBuilder(3).append("col").append(idx).toString(), (Object)new CatalogColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(1)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)tpe.defaultSize())), (Option)new Some((Object)BoxesRunTime.boxToLong((long)tpe.defaultSize())), CatalogColumnStat$.MODULE$.apply$default$7(), CatalogColumnStat$.MODULE$.apply$default$8()));
                return tuple22;
            });
            scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"true", "false"})).foreach((Function1 & Serializable)histogramEnabled -> {
                this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.HISTOGRAM_ENABLED().key()), (Object)histogramEnabled)}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.checkColStats((Dataset<Row>)df, (LinkedHashMap<String, CatalogColumnStat>)((LinkedHashMap)LinkedHashMap$.MODULE$.apply(expectedColStats))));
                return BoxedUnit.UNIT;
            });
        }, new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 198));
        this.test("SPARK-25028: column stats collection for null partitioning columns", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String table = "analyze_partition_with_null";
            this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
                this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{table}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    $this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(146).append("\n             |CREATE TABLE ").append(table$2).append(" (value string, name string)\n             |USING PARQUET\n             |PARTITIONED BY (name)\n             |LOCATION '").append(dir.toURI()).append("'").toString())));
                    JavaUniverse $u = package$.MODULE$.universe();
                    JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(StatisticsCollectionSuite.class.getClassLoader());
                    public final class $typecreator60$1
                    extends TypeCreator {
                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                            Universe $u = $m$untyped.universe();
                            Mirror<U> $m = $m$untyped;
                            return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Null").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                        }

                        public $typecreator60$1(StatisticsCollectionSuite $outer) {
                        }
                    }
                    Dataset df = $this.testImplicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", null), new Tuple2((Object)"b", null)})), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new $typecreator60$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value", "name"}));
                    df.write().mode("overwrite").insertInto(table$2);
                    $this.sql().apply((Object)new StringBuilder(50).append("ANALYZE TABLE ").append(table$2).append(" PARTITION (name) COMPUTE STATISTICS").toString());
                    SessionCatalog qual$3 = $this.spark().sessionState().catalog();
                    TableIdentifier x$7 = TableIdentifier$.MODULE$.apply(table$2);
                    Option x$8 = qual$3.listPartitions$default$2();
                    Seq partitions = qual$3.listPartitions(x$7, x$8);
                    BigInt $org_scalatest_assert_macro_left = (BigInt)((CatalogStatistics)((CatalogTablePartition)partitions.head()).stats().get()).rowCount().get();
                    int $org_scalatest_assert_macro_right = 2;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), BoxesRunTime.equalsNumObject((Number)$org_scalatest_assert_macro_left, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
                });
                return BoxedUnit.UNIT;
            });
        }, new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 222));
        this.test("number format in statistics", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Seq numbers = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)scala.package$.MODULE$.BigInt().apply(0)), (Object)new Tuple2((Object)"0.0 B", (Object)"0")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)scala.package$.MODULE$.BigInt().apply(100)), (Object)new Tuple2((Object)"100.0 B", (Object)"100")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)scala.package$.MODULE$.BigInt().apply(2047)), (Object)new Tuple2((Object)"2047.0 B", (Object)"2.05E+3")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)scala.package$.MODULE$.BigInt().apply(2048)), (Object)new Tuple2((Object)"2.0 KiB", (Object)"2.05E+3")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)scala.package$.MODULE$.BigInt().apply(3333333)), (Object)new Tuple2((Object)"3.2 MiB", (Object)"3.33E+6")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)scala.package$.MODULE$.BigInt().apply(4444444444L)), (Object)new Tuple2((Object)"4.1 GiB", (Object)"4.44E+9")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)scala.package$.MODULE$.BigInt().apply(5555555555555L)), (Object)new Tuple2((Object)"5.1 TiB", (Object)"5.56E+12")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)scala.package$.MODULE$.BigInt().apply(6666666666666666L)), (Object)new Tuple2((Object)"5.9 PiB", (Object)"6.67E+15")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)scala.package$.MODULE$.BigInt().apply(1024L).$times(BigInt$.MODULE$.long2bigInt(0x1000000000000000L))), (Object)new Tuple2((Object)"1024.0 EiB", (Object)"1.18E+21")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)scala.package$.MODULE$.BigInt().apply(2048L).$times(BigInt$.MODULE$.long2bigInt(0x1000000000000000L))), (Object)new Tuple2((Object)"2.36E+21 B", (Object)"2.36E+21"))}));
            numbers.foreach((Function1 & Serializable)x0$5 -> {
                Tuple2 tuple2;
                BigInt input;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = x0$5;
                        if (tuple22 == null) break block2;
                        input = (BigInt)tuple22._1();
                        tuple2 = (Tuple2)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                String expectedSize = (String)tuple2._1();
                String expectedRows = (String)tuple2._2();
                Statistics stats = new Statistics(input, (Option)new Some((Object)input), Statistics$.MODULE$.apply$default$3(), Statistics$.MODULE$.apply$default$4());
                String expectedString = new StringBuilder(23).append("sizeInBytes=").append(expectedSize).append(", rowCount=").append(expectedRows).toString();
                String $org_scalatest_assert_macro_left = stats.simpleString();
                String $org_scalatest_assert_macro_right = expectedString;
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                Assertion assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 256));
                return assertion;
            });
        }, new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 240));
        this.test("change stats after set location command", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String table = "change_stats_set_location_table";
            File tableLoc = new File(this.spark().sessionState().catalog().defaultTablePath(TableIdentifier$.MODULE$.apply(table)));
            scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true})).foreach((Function1 & Serializable)autoUpdate -> {
                this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.AUTO_SIZE_UPDATE_ENABLED().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)autoUpdate)))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{table}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    $this.spark().range(100L).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{$this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$), $this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$).$percent((Object)BoxesRunTime.boxToInteger((int)5)).as("value")})).write().saveAsTable(table$3);
                    $this.sql().apply((Object)new StringBuilder(55).append("ANALYZE TABLE ").append(table$3).append(" COMPUTE STATISTICS FOR COLUMNS id, value").toString());
                    Option<CatalogStatistics> fetched1 = $this.checkTableStats(table$3, true, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)100)));
                    BigInt $org_scalatest_assert_macro_left = ((CatalogStatistics)fetched1.get()).sizeInBytes();
                    BigInt $org_scalatest_assert_macro_right = BigInt$.MODULE$.int2bigInt(0);
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, ">", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$greater((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 271));
                    Map $org_scalatest_assert_macro_left2 = ((CatalogStatistics)fetched1.get()).colStats();
                    int $org_scalatest_assert_macro_right2 = 2;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 272));
                    String initLocation = ((URI)$this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(table$3)).storage().locationUri().get()).toString();
                    $this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)newLocation -> {
                        StatisticsCollectionSuite.$anonfun$new$45($this, table$3, autoUpdate, initLocation, fetched1, tableLoc$1, newLocation);
                        return BoxedUnit.UNIT;
                    });
                }));
                return BoxedUnit.UNIT;
            });
        }, new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 260));
        this.test("change stats after insert command for datasource table", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String table = "change_stats_insert_datasource_table";
            scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true})).foreach((Function1 & Serializable)autoUpdate -> {
                this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.AUTO_SIZE_UPDATE_ENABLED().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)autoUpdate)))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{table}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    Assertion assertion;
                    $this.sql().apply((Object)new StringBuilder(45).append("CREATE TABLE ").append(table$4).append(" (i int, j string) USING PARQUET").toString());
                    $this.sql().apply((Object)new StringBuilder(50).append("ANALYZE TABLE ").append(table$4).append(" COMPUTE STATISTICS FOR COLUMNS i, j").toString());
                    Option<CatalogStatistics> fetched1 = $this.checkTableStats(table$4, true, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)));
                    BigInt $org_scalatest_assert_macro_left = ((CatalogStatistics)fetched1.get()).sizeInBytes();
                    int $org_scalatest_assert_macro_right = 0;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), BoxesRunTime.equalsNumObject((Number)$org_scalatest_assert_macro_left, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 309));
                    Map $org_scalatest_assert_macro_left2 = ((CatalogStatistics)fetched1.get()).colStats();
                    int $org_scalatest_assert_macro_right2 = 2;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 310));
                    $this.spark().table(table$4);
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool($this.isTableInCatalogCache(table$4), "StatisticsCollectionSuite.this.isTableInCatalogCache(table)", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314));
                    $this.sql().apply((Object)new StringBuilder(34).append("INSERT INTO TABLE ").append(table$4).append(" SELECT 1, 'abc'").toString());
                    if (autoUpdate) {
                        Option<CatalogStatistics> fetched2 = $this.checkTableStats(table$4, true, (Option<Object>)None$.MODULE$);
                        BigInt $org_scalatest_assert_macro_left3 = ((CatalogStatistics)fetched2.get()).sizeInBytes();
                        BigInt $org_scalatest_assert_macro_right3 = BigInt$.MODULE$.int2bigInt(0);
                        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, ">", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$greater((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 320));
                        Map $org_scalatest_assert_macro_left4 = ((CatalogStatistics)fetched2.get()).colStats();
                        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty(), Prettifier$.MODULE$.default());
                        assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 321));
                    } else {
                        assertion = $this.checkTableStats(table$4, false, (Option<Object>)None$.MODULE$);
                    }
                    Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.isTableInCatalogCache(table$4), "StatisticsCollectionSuite.this.isTableInCatalogCache(table)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 327));
                }));
                return BoxedUnit.UNIT;
            });
        }, new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 300));
        this.test("auto gather stats after insert command", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String table = "change_stats_insert_datasource_table";
            scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true})).foreach((Function1 & Serializable)autoUpdate -> {
                this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.AUTO_SIZE_UPDATE_ENABLED().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)autoUpdate)))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{table}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    $this.sql().apply((Object)new StringBuilder(45).append("CREATE TABLE ").append(table$5).append(" (i int, j string) USING PARQUET").toString());
                    $this.sql().apply((Object)new StringBuilder(34).append("INSERT INTO TABLE ").append(table$5).append(" SELECT 1, 'abc'").toString());
                    Option stats = $this.getCatalogTable(table$5).stats();
                    if (autoUpdate) {
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(stats.isDefined(), "stats.isDefined", Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 343));
                        BigInt $org_scalatest_assert_macro_left = ((CatalogStatistics)stats.get()).sizeInBytes();
                        BigInt $org_scalatest_assert_macro_right = BigInt$.MODULE$.int2bigInt(0);
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, ">=", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$greater$eq((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 344));
                    } else {
                        Option $org_scalatest_assert_macro_left = stats;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 346));
                    }
                }));
                return BoxedUnit.UNIT;
            });
        }, new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 333));
        this.test("invalidation of tableRelationCache after inserts", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String table = "invalidate_catalog_cache_table";
            scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true})).foreach((Function1 & Serializable)autoUpdate -> {
                this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.AUTO_SIZE_UPDATE_ENABLED().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)autoUpdate)))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{table}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    $this.spark().range(100L).write().saveAsTable(table$6);
                    $this.sql().apply((Object)new StringBuilder(33).append("ANALYZE TABLE ").append(table$6).append(" COMPUTE STATISTICS").toString());
                    $this.spark().table(table$6);
                    BigInt initialSizeInBytes = $this.getTableFromCatalogCache(table$6).stats().sizeInBytes();
                    $this.spark().range(100L).write().mode(SaveMode.Append).saveAsTable(table$6);
                    $this.spark().table(table$6);
                    BigInt $org_scalatest_assert_macro_left = $this.getTableFromCatalogCache(table$6).stats().sizeInBytes();
                    BigInt $org_scalatest_assert_macro_right = BigInt$.MODULE$.int2bigInt(2).$times(initialSizeInBytes);
                    BigInt bigInt = $org_scalatest_assert_macro_left;
                    BigInt bigInt2 = $org_scalatest_assert_macro_right;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(bigInt != null ? !bigInt.equals(bigInt2) : bigInt2 != null), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 364));
                }));
                return BoxedUnit.UNIT;
            });
        }, new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 353));
        this.test("invalidation of tableRelationCache after alter table add partition", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String table = "invalidate_catalog_cache_table";
            scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true})).foreach((Function1 & Serializable)autoUpdate -> {
                this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.AUTO_SIZE_UPDATE_ENABLED().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)autoUpdate)))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
                    $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{table$7}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                        String path = dir.getCanonicalPath();
                        $this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(143).append("\n              |CREATE TABLE ").append(table$7).append(" (col1 int, col2 int)\n              |USING PARQUET\n              |PARTITIONED BY (col2)\n              |LOCATION '").append(dir.toURI()).append("'").toString())));
                        $this.sql().apply((Object)new StringBuilder(33).append("ANALYZE TABLE ").append(table$7).append(" COMPUTE STATISTICS").toString());
                        $this.spark().table(table$7);
                        BigInt $org_scalatest_assert_macro_left = $this.getTableFromCatalogCache(table$7).stats().sizeInBytes();
                        int $org_scalatest_assert_macro_right = 0;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), BoxesRunTime.equalsNumObject((Number)$org_scalatest_assert_macro_left, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 384));
                        $this.spark().catalog().recoverPartitions(table$7);
                        JavaUniverse $u = package$.MODULE$.universe();
                        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(StatisticsCollectionSuite.class.getClassLoader());
                        public final class $typecreator70$1
                        extends TypeCreator {
                            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                                Universe $u = $m$untyped.universe();
                                Mirror<U> $m = $m$untyped;
                                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                            }

                            public $typecreator70$1(StatisticsCollectionSuite $outer) {
                            }
                        }
                        Dataset df = $this.testImplicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcII.sp(1, 2), new Tuple2.mcII.sp(1, 2)})), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new $typecreator70$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col2", "col1"}));
                        df.write().parquet(new StringBuilder(7).append(path).append("/col2=1").toString());
                        $this.sql().apply((Object)new StringBuilder(47).append("ALTER TABLE ").append(table$7).append(" ADD PARTITION (col2=1) LOCATION '").append(dir.toURI()).append("'").toString());
                        $this.spark().table(table$7);
                        LogicalPlan cachedTable = $this.getTableFromCatalogCache(table$7);
                        BigInt cachedTableSizeInBytes = cachedTable.stats().sizeInBytes();
                        long defaultSizeInBytes = $this.conf().defaultSizeInBytes();
                        if (autoUpdate$4) {
                            Bool bool;
                            BigInt $org_scalatest_assert_macro_left2 = cachedTableSizeInBytes;
                            long $org_scalatest_assert_macro_right2 = defaultSizeInBytes;
                            Bool $org_scalatest_assert_macro_left3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "!=", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), !BoxesRunTime.equalsNumObject((Number)$org_scalatest_assert_macro_left2, (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2)), Prettifier$.MODULE$.default());
                            if ($org_scalatest_assert_macro_left3.value()) {
                                BigInt $org_scalatest_assert_macro_left4 = cachedTableSizeInBytes;
                                BigInt $org_scalatest_assert_macro_right3 = BigInt$.MODULE$.int2bigInt(0);
                                bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, ">", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left4.$greater((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                            } else {
                                bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                            }
                            Bool $org_scalatest_assert_macro_right4 = bool;
                            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "&&", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left3.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
                            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 394));
                        } else {
                            BigInt $org_scalatest_assert_macro_left5 = cachedTableSizeInBytes;
                            long $org_scalatest_assert_macro_right5 = defaultSizeInBytes;
                            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right5), BoxesRunTime.equalsNumObject((Number)$org_scalatest_assert_macro_left5, (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right5)), Prettifier$.MODULE$.default());
                            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 396));
                        }
                    });
                    return BoxedUnit.UNIT;
                }));
                return BoxedUnit.UNIT;
            });
        }, new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 370));
        this.test("Simple queries must be working, if CBO is turned on", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CBO_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"TBL1", "TBL"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            Dataset df = this.spark().range(1000L).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "id")), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "id")).$times((Object)BoxesRunTime.boxToInteger((int)2)).as("FLD1"), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "id")).$times((Object)BoxesRunTime.boxToInteger((int)12)).as("FLD2"), functions$.MODULE$.lit((Object)"aaa").$plus((Object)SymbolLiteral.bootstrap("apply", "id")).as("fld3")}));
            df.write().mode(SaveMode.Overwrite).bucketBy(10, "id", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"FLD1", "FLD2"})).sortBy("id", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"FLD1", "FLD2"})).saveAsTable("TBL");
            this.sql().apply((Object)"ANALYZE TABLE TBL COMPUTE STATISTICS ");
            this.sql().apply((Object)"ANALYZE TABLE TBL COMPUTE STATISTICS FOR COLUMNS ID, FLD1, FLD2, FLD3");
            Dataset df2 = this.spark().sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |SELECT t1.id, t1.fld1, t1.fld2, t1.fld3\n             |FROM tbl t1\n             |JOIN tbl t2 on t1.id=t2.id\n             |WHERE  t1.fld3 IN (-123.23,321.23)\n          ")));
            df2.createTempView("TBL2");
            ((Dataset)this.sql().apply((Object)"SELECT * FROM tbl2 WHERE fld3 IN ('qqq', 'qwe')  ")).queryExecution().executedPlan();
        })), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 404));
        this.test("store and retrieve column stats in different time zones", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Tuple2.mcIJ.sp sp2 = new Tuple2.mcIJ.sp(0, TimeUnit.DAYS.toSeconds(2L));
            if (sp2 == null) {
                throw new MatchError((Object)sp2);
            }
            int start = sp2._1$mcI$sp();
            long end = sp2._2$mcJ$sp();
            Tuple2.mcIJ.sp sp3 = new Tuple2.mcIJ.sp(start, end);
            Tuple2.mcIJ.sp sp4 = sp3;
            int start2 = sp4._1$mcI$sp();
            long end2 = sp4._2$mcJ$sp();
            DateTimeTestUtils$.MODULE$.outstandingZoneIds().foreach((Function1 & Serializable)zid -> {
                StatisticsCollectionSuite.$anonfun$new$69(this, start2, end2, zid);
                return BoxedUnit.UNIT;
            });
        }, new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 432));
        this.test("analyzes column statistics in cached query", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"cachedQuery"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("CACHE TABLE cachedQuery AS\n          |  SELECT c0, avg(c1) AS v1, avg(c2) AS v2\n          |  FROM (SELECT id % 3 AS c0, id % 5 AS c1, 2 AS c2 FROM range(1, 30))\n          |  GROUP BY c0\n        ")));
            this.sql().apply((Object)"ANALYZE TABLE cachedQuery COMPUTE STATISTICS FOR COLUMNS v1");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.getStatAttrNames("cachedQuery"));
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"v1"}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 489));
            this.sql().apply((Object)"ANALYZE TABLE cachedQuery COMPUTE STATISTICS FOR COLUMNS c0, v2");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.getStatAttrNames("cachedQuery"));
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c0", "v1", "v2"}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 493));
        }), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 478));
        this.test("analyzes column statistics in cached local temporary view", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tempView"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            String errMsg;
            this.sql().apply((Object)"CREATE TEMPORARY VIEW tempView AS SELECT 1 id");
            String $org_scalatest_assert_macro_left = errMsg = ((AnalysisException)((Object)((Object)((Object)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"ANALYZE TABLE tempView COMPUTE STATISTICS FOR COLUMNS id"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 501)))))).getMessage();
            String $org_scalatest_assert_macro_right = "Temporary view `tempView` is not cached for analyzing columns";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 504));
            this.sql().apply((Object)"CACHE TABLE tempView");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.getStatAttrNames("tempView"));
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "!==", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$bang$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 508));
            this.sql().apply((Object)"ANALYZE TABLE tempView COMPUTE STATISTICS FOR COLUMNS id");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(this.getStatAttrNames("tempView"));
            Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 510));
        }), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 497));
        this.test("analyzes column statistics in cached global temporary view", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withGlobalTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"gTempView"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            String errMsg2;
            String errMsg1;
            String globalTempDB = this.spark().sharedState().globalTempViewManager().database();
            String $org_scalatest_assert_macro_left = errMsg1 = ((AnalysisException)((Object)((Object)((Object)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(58).append("ANALYZE TABLE ").append(globalTempDB).append(".gTempView COMPUTE STATISTICS FOR COLUMNS id").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 517)))))).getMessage();
            String $org_scalatest_assert_macro_right = new StringBuilder(25).append("Table or view not found: ").append(new StringBuilder(10).append(globalTempDB).append(".gTempView").toString()).toString();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 520));
            this.sql().apply((Object)"CREATE GLOBAL TEMP VIEW gTempView AS SELECT 1 id");
            String $org_scalatest_assert_macro_left2 = errMsg2 = ((AnalysisException)((Object)((Object)((Object)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(58).append("ANALYZE TABLE ").append(globalTempDB).append(".gTempView COMPUTE STATISTICS FOR COLUMNS id").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 524)))))).getMessage();
            String $org_scalatest_assert_macro_right2 = new StringBuilder(65).append("Temporary view `").append(globalTempDB).append("`.`gTempView` is not cached for analyzing columns").toString();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 527));
            this.sql().apply((Object)new StringBuilder(22).append("CACHE TABLE ").append(globalTempDB).append(".gTempView").toString());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(this.getStatAttrNames(new StringBuilder(10).append(globalTempDB).append(".gTempView").toString()));
            Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "!==", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$bang$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 532));
            this.sql().apply((Object)new StringBuilder(58).append("ANALYZE TABLE ").append(globalTempDB).append(".gTempView COMPUTE STATISTICS FOR COLUMNS id").toString());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(this.getStatAttrNames(new StringBuilder(10).append(globalTempDB).append(".gTempView").toString()));
            Set $org_scalatest_assert_macro_right4 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 534));
        }), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 514));
        this.test("analyzes column statistics in cached catalog view", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDatabase((Function1<String, BoxedUnit>)(Function1 & Serializable)database -> {
            StatisticsCollectionSuite.$anonfun$new$82(this, database);
            return BoxedUnit.UNIT;
        }), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 538));
        this.test("analyzes table statistics in cached catalog view", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDatabase((Function1<String, BoxedUnit>)(Function1 & Serializable)database -> {
            StatisticsCollectionSuite.$anonfun$new$84(this, database);
            return BoxedUnit.UNIT;
        }), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 548));
        this.test(new StringBuilder(44).append("CTAS should update statistics if ").append(SQLConf$.MODULE$.AUTO_SIZE_UPDATE_ENABLED().key()).append(" is enabled").toString(), (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String tableName = "spark_27694";
            scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true})).foreach((Function1 & Serializable)updateEnabled -> {
                this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.AUTO_SIZE_UPDATE_ENABLED().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)updateEnabled)))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    $this.sql().apply((Object)new StringBuilder(46).append("CREATE TABLE ").append(tableName$4).append(" USING parquet AS SELECT 'a', 'b'").toString());
                    CatalogTable catalogTable = $this.getCatalogTable(tableName$4);
                    if (updateEnabled) {
                        Option $org_scalatest_assert_macro_left = catalogTable.stats();
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 589));
                    } else {
                        Option $org_scalatest_assert_macro_left = catalogTable.stats();
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 591));
                    }
                }));
                return BoxedUnit.UNIT;
            });
        }, new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 580));
        this.test("Metadata files and temporary files should not be counted as data files", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)tempDir -> {
            StatisticsCollectionSuite.$anonfun$new$90(this, tempDir);
            return BoxedUnit.UNIT;
        }), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 598));
        scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, false})).foreach((Function1 & Serializable)caseSensitive -> {
            this.test(new StringBuilder(0).append("SPARK-30903: Fail fast on duplicate columns when analyze columns ").append(new StringBuilder(16).append("- caseSensitive=").append(BoxesRunTime.unboxToBoolean((Object)caseSensitive)).toString()).toString(), (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)caseSensitive)))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                String table = "test_table";
                $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{table}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    String errorMsg;
                    $this.sql().apply((Object)new StringBuilder(55).append("CREATE TABLE ").append(table).append(" (value string, name string) USING PARQUET").toString());
                    String dupCol = caseSensitive ? "value" : "VaLuE";
                    String $org_scalatest_assert_macro_left = errorMsg = ((AnalysisException)((Object)((Object)((Object)((Object)$this.intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(59).append("ANALYZE TABLE ").append(table).append(" COMPUTE STATISTICS FOR COLUMNS value, name, ").append(dupCol).toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 641))))))).getMessage();
                    String $org_scalatest_assert_macro_right = "Found duplicate column(s)";
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 644));
                });
            }), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 635));
            return BoxedUnit.UNIT;
        });
        this.test("SPARK-34119: Keep necessary stats after PruneFileSourcePartitions", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"SPARK_34119"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CBO_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.sql().apply((Object)new StringBuilder(55).append("CREATE TABLE SPARK_34119 using parquet PARTITIONED BY (p) AS ").append("(SELECT id, CAST(id % 5 AS STRING) AS p FROM range(10))").toString());
            this.sql().apply((Object)"ANALYZE TABLE SPARK_34119 COMPUTE STATISTICS FOR ALL COLUMNS");
            this.checkOptimizedPlanStats((Dataset<Row>)((Dataset)this.sql().apply((Object)"SELECT id FROM SPARK_34119")), BigInt$.MODULE$.long2bigInt(160L), (Option<BigInt>)new Some((Object)BigInt$.MODULE$.int2bigInt(10)), (Seq<ColumnStat>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ColumnStat[]{new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(10)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)9)), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)LongType$.MODULE$.defaultSize())), (Option)new Some((Object)BoxesRunTime.boxToLong((long)LongType$.MODULE$.defaultSize())), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8())}))));
            this.checkOptimizedPlanStats((Dataset<Row>)((Dataset)this.sql().apply((Object)"SELECT id FROM SPARK_34119 WHERE p = '2'")), BigInt$.MODULE$.long2bigInt(32L), (Option<BigInt>)new Some((Object)BigInt$.MODULE$.int2bigInt(2)), (Seq<ColumnStat>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ColumnStat[]{new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(2)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)9)), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)LongType$.MODULE$.defaultSize())), (Option)new Some((Object)BoxesRunTime.boxToLong((long)LongType$.MODULE$.defaultSize())), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8())}))));
        })), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 650));
        this.test("SPARK-33687: analyze all tables in a specific database", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            String errMsg;
            this.withTempDatabase((Function1<String, BoxedUnit>)(Function1 & Serializable)database -> {
                StatisticsCollectionSuite.$anonfun$new$106(this, database);
                return BoxedUnit.UNIT;
            });
            String $org_scalatest_assert_macro_left = errMsg = ((AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"ANALYZE TABLES IN db_not_exists COMPUTE STATISTICS"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 713))))).getMessage();
            String $org_scalatest_assert_macro_right = "Database 'db_not_exists' not found";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 716));
        }, new Position("StatisticsCollectionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 682));
        Statics.releaseFence();
    }
}

