/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.internal.config.UI$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.QueryTest$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.execution.CoalescedShuffleRead$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.adaptive.AQEShuffleReadExec;
import org.apache.spark.sql.execution.adaptive.AdaptiveSparkPlanExec;
import org.apache.spark.sql.execution.adaptive.QueryStageExec;
import org.apache.spark.sql.execution.adaptive.ShuffleQueryStageExec;
import org.apache.spark.sql.execution.exchange.ReusedExchangeExec;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.internal.SQLConf$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005!4AAD\b\u00015!)Q\u0005\u0001C\u0001M!I\u0011\u0006\u0001a\u0001\u0002\u0004%IA\u000b\u0005\nk\u0001\u0001\r\u00111A\u0005\nYB\u0011\u0002\u0010\u0001A\u0002\u0003\u0005\u000b\u0015B\u0016\t\u0013u\u0002\u0001\u0019!a\u0001\n\u0013Q\u0003\"\u0003 \u0001\u0001\u0004\u0005\r\u0011\"\u0003@\u0011%\t\u0005\u00011A\u0001B\u0003&1\u0006C\u0003C\u0001\u0011E3\tC\u0003E\u0001\u0011E3\tC\u0004F\u0001\t\u0007I\u0011\u0001$\t\r)\u0003\u0001\u0015!\u0003H\u0011\u0015Y\u0005\u0001\"\u0001M\u0011\u001da\u0006!%A\u0005\u0002u\u0013adQ8bY\u0016\u001c8-Z*ik\u001a4G.\u001a)beRLG/[8ogN+\u0018\u000e^3\u000b\u0005A\t\u0012!C3yK\u000e,H/[8o\u0015\t\u00112#A\u0002tc2T!\u0001F\u000b\u0002\u000bM\u0004\u0018M]6\u000b\u0005Y9\u0012AB1qC\u000eDWMC\u0001\u0019\u0003\ry'oZ\u0002\u0001'\r\u00011d\b\t\u00039ui\u0011aE\u0005\u0003=M\u0011Qb\u00159be.4UO\\*vSR,\u0007C\u0001\u0011$\u001b\u0005\t#B\u0001\u0012\u0018\u0003%\u00198-\u00197bi\u0016\u001cH/\u0003\u0002%C\t\t\")\u001a4pe\u0016\fe\u000eZ!gi\u0016\u0014\u0018\t\u001c7\u0002\rqJg.\u001b;?)\u00059\u0003C\u0001\u0015\u0001\u001b\u0005y\u0011AG8sS\u001eLg.\u00197BGRLg/Z*qCJ\\7+Z:tS>tW#A\u0016\u0011\u00071z\u0013'D\u0001.\u0015\u0005q\u0013!B:dC2\f\u0017B\u0001\u0019.\u0005\u0019y\u0005\u000f^5p]B\u0011!gM\u0007\u0002#%\u0011A'\u0005\u0002\r'B\f'o[*fgNLwN\\\u0001\u001f_JLw-\u001b8bY\u0006\u001bG/\u001b<f'B\f'o[*fgNLwN\\0%KF$\"a\u000e\u001e\u0011\u00051B\u0014BA\u001d.\u0005\u0011)f.\u001b;\t\u000fm\u001a\u0011\u0011!a\u0001W\u0005\u0019\u0001\u0010J\u0019\u00027=\u0014\u0018nZ5oC2\f5\r^5wKN\u0003\u0018M]6TKN\u001c\u0018n\u001c8!\u0003\u0001z'/[4j]\u0006d\u0017J\\:uC:$\u0018.\u0019;fIN\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0002I=\u0014\u0018nZ5oC2Len\u001d;b]RL\u0017\r^3e'B\f'o[*fgNLwN\\0%KF$\"a\u000e!\t\u000fm2\u0011\u0011!a\u0001W\u0005\tsN]5hS:\fG.\u00138ti\u0006tG/[1uK\u0012\u001c\u0006/\u0019:l'\u0016\u001c8/[8oA\u0005I!-\u001a4pe\u0016\fE\u000e\u001c\u000b\u0002o\u0005A\u0011M\u001a;fe\u0006cG.\u0001\nok6Le\u000e];u!\u0006\u0014H/\u001b;j_:\u001cX#A$\u0011\u00051B\u0015BA%.\u0005\rIe\u000e^\u0001\u0014]Vl\u0017J\u001c9viB\u000b'\u000f^5uS>t7\u000fI\u0001\u0011o&$\bn\u00159be.\u001cVm]:j_:$RaN'S)^CQA\u0014\u0007A\u0002=\u000b\u0011A\u001a\t\u0005YA\u000bt'\u0003\u0002R[\tIa)\u001e8di&|g.\r\u0005\u0006'2\u0001\raR\u0001\u001bi\u0006\u0014x-\u001a;Q_N$8\u000b[;gM2,\u0017J\u001c9viNK'0\u001a\u0005\u0006+2\u0001\rAV\u0001\u001c[&tg*^7Q_N$8\u000b[;gM2,\u0007+\u0019:uSRLwN\\:\u0011\u00071zs\tC\u0004Y\u0019A\u0005\t\u0019A-\u0002%\u0015t\u0017M\u00197f\u0013>+en\u0019:zaRLwN\u001c\t\u0003YiK!aW\u0017\u0003\u000f\t{w\u000e\\3b]\u0006Qr/\u001b;i'B\f'o[*fgNLwN\u001c\u0013eK\u001a\fW\u000f\u001c;%iU\taL\u000b\u0002Z?.\n\u0001\r\u0005\u0002bM6\t!M\u0003\u0002dI\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003K6\n!\"\u00198o_R\fG/[8o\u0013\t9'MA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class CoalesceShufflePartitionsSuite
extends SparkFunSuite {
    private Option<SparkSession> originalActiveSparkSession;
    private Option<SparkSession> originalInstantiatedSparkSession;
    private final int numInputPartitions;

    private Option<SparkSession> originalActiveSparkSession() {
        return this.originalActiveSparkSession;
    }

    private void originalActiveSparkSession_$eq(Option<SparkSession> x$1) {
        this.originalActiveSparkSession = x$1;
    }

    private Option<SparkSession> originalInstantiatedSparkSession() {
        return this.originalInstantiatedSparkSession;
    }

    private void originalInstantiatedSparkSession_$eq(Option<SparkSession> x$1) {
        this.originalInstantiatedSparkSession = x$1;
    }

    public void beforeAll() {
        super.beforeAll();
        this.originalActiveSparkSession_$eq((Option<SparkSession>)SparkSession$.MODULE$.getActiveSession());
        this.originalInstantiatedSparkSession_$eq((Option<SparkSession>)SparkSession$.MODULE$.getDefaultSession());
        SparkSession$.MODULE$.clearActiveSession();
        SparkSession$.MODULE$.clearDefaultSession();
    }

    public void afterAll() {
        try {
            this.originalActiveSparkSession().foreach((Function1 & Serializable)ctx -> {
                SparkSession$.MODULE$.setActiveSession(ctx);
                return BoxedUnit.UNIT;
            });
            this.originalInstantiatedSparkSession().foreach((Function1 & Serializable)ctx -> {
                SparkSession$.MODULE$.setDefaultSession(ctx);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            super.afterAll();
        }
    }

    public int numInputPartitions() {
        return this.numInputPartitions;
    }

    public void withSparkSession(Function1<SparkSession, BoxedUnit> f, int targetPostShuffleInputSize, Option<Object> minNumPostShufflePartitions, boolean enableIOEncryption) {
        SparkConf sparkConf;
        SparkConf sparkConf2 = new SparkConf(false).setMaster("local[*]").setAppName("test").set(UI$.MODULE$.UI_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)false)).set(org.apache.spark.internal.config.package$.MODULE$.IO_ENCRYPTION_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)enableIOEncryption)).set(SQLConf$.MODULE$.SHUFFLE_PARTITIONS().key(), "5").set(SQLConf$.MODULE$.COALESCE_PARTITIONS_INITIAL_PARTITION_NUM().key(), "5").set(SQLConf$.MODULE$.ADAPTIVE_EXECUTION_ENABLED().key(), "true").set(SQLConf$.MODULE$.FETCH_SHUFFLE_BLOCKS_IN_BATCH().key(), "true").set(SQLConf$.MODULE$.AUTO_BROADCASTJOIN_THRESHOLD().key(), "-1").set(SQLConf$.MODULE$.ADVISORY_PARTITION_SIZE_IN_BYTES().key(), Integer.toString(targetPostShuffleInputSize));
        Option<Object> option = minNumPostShufflePartitions;
        if (option instanceof Some) {
            Some some = (Some)option;
            int numPartitions = BoxesRunTime.unboxToInt((Object)some.value());
            sparkConf = sparkConf2.set(SQLConf$.MODULE$.COALESCE_PARTITIONS_MIN_PARTITION_NUM().key(), Integer.toString(numPartitions));
        } else if (None$.MODULE$.equals(option)) {
            sparkConf = sparkConf2.set(SQLConf$.MODULE$.COALESCE_PARTITIONS_MIN_PARTITION_NUM().key(), "1");
        } else {
            throw new MatchError(option);
        }
        SparkSession spark = SparkSession$.MODULE$.builder().config(sparkConf2).getOrCreate();
        try {
            f.apply((Object)spark);
        }
        finally {
            spark.stop();
        }
    }

    public boolean withSparkSession$default$4() {
        return false;
    }

    public static final /* synthetic */ void $anonfun$new$3(CoalesceShufflePartitionsSuite $this, Option minNumPostShufflePartitions$1, SparkSession spark) {
        Dataset df = spark.range(0L, 1000L, 1L, $this.numInputPartitions()).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id % 20 as key", "id as value"}));
        Dataset agg = df.groupBy("key", (Seq)Nil$.MODULE$).count();
        QueryTest$.MODULE$.checkAnswer((Dataset<Row>)agg, (Seq<Row>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(spark.range(0L, 20L).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "50 as cnt"})).collect()), QueryTest$.MODULE$.checkAnswer$default$3());
        SparkPlan finalPlan = ((AdaptiveSparkPlanExec)agg.queryExecution().executedPlan()).executedPlan();
        Seq shuffleReads = finalPlan.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                AQEShuffleReadExec aQEShuffleReadExec;
                A1 A1 = x1;
                Object object = A1 instanceof AQEShuffleReadExec && CoalescedShuffleRead$.MODULE$.unapply(aQEShuffleReadExec = (AQEShuffleReadExec)A1) ? aQEShuffleReadExec : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x1) {
                AQEShuffleReadExec aQEShuffleReadExec;
                SparkPlan sparkPlan2 = x1;
                boolean bl = sparkPlan2 instanceof AQEShuffleReadExec && CoalescedShuffleRead$.MODULE$.unapply(aQEShuffleReadExec = (AQEShuffleReadExec)sparkPlan2);
                return bl;
            }
        });
        Option option = minNumPostShufflePartitions$1;
        if (option instanceof Some) {
            Seq $org_scalatest_assert_macro_left = shuffleReads;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)shuffleReads.length()));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
            shuffleReads.foreach((Function1 & Serializable)read -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)read.outputPartitioning().numPartitions()));
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    public static final /* synthetic */ void $anonfun$new$6(CoalesceShufflePartitionsSuite $this, Option minNumPostShufflePartitions$1, SparkSession spark) {
        Dataset df1 = spark.range(0L, 1000L, 1L, $this.numInputPartitions()).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id % 500 as key1", "id as value1"}));
        Dataset df2 = spark.range(0L, 1000L, 1L, $this.numInputPartitions()).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id % 500 as key2", "id as value2"}));
        Dataset join = df1.join(df2, functions$.MODULE$.col("key1").$eq$eq$eq((Object)functions$.MODULE$.col("key2"))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("key1"), functions$.MODULE$.col("value2")}));
        Dataset expectedAnswer = spark.range(0L, 1000L).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id % 500 as key", "id as value"})).union(spark.range(0L, 1000L).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id % 500 as key", "id as value"})));
        QueryTest$.MODULE$.checkAnswer((Dataset<Row>)join, (Seq<Row>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(expectedAnswer.collect()), QueryTest$.MODULE$.checkAnswer$default$3());
        SparkPlan finalPlan = ((AdaptiveSparkPlanExec)join.queryExecution().executedPlan()).executedPlan();
        Seq shuffleReads = finalPlan.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                AQEShuffleReadExec aQEShuffleReadExec;
                A1 A1 = x2;
                Object object = A1 instanceof AQEShuffleReadExec && CoalescedShuffleRead$.MODULE$.unapply(aQEShuffleReadExec = (AQEShuffleReadExec)A1) ? aQEShuffleReadExec : function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x2) {
                AQEShuffleReadExec aQEShuffleReadExec;
                SparkPlan sparkPlan2 = x2;
                boolean bl = sparkPlan2 instanceof AQEShuffleReadExec && CoalescedShuffleRead$.MODULE$.unapply(aQEShuffleReadExec = (AQEShuffleReadExec)sparkPlan2);
                return bl;
            }
        });
        Option option = minNumPostShufflePartitions$1;
        if (option instanceof Some) {
            Seq $org_scalatest_assert_macro_left = shuffleReads;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)shuffleReads.length()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
            shuffleReads.foreach((Function1 & Serializable)read -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)read.outputPartitioning().numPartitions()));
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    public static final /* synthetic */ void $anonfun$new$9(CoalesceShufflePartitionsSuite $this, Option minNumPostShufflePartitions$1, SparkSession spark) {
        Dataset df1 = spark.range(0L, 1000L, 1L, $this.numInputPartitions()).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id % 500 as key1", "id as value1"})).groupBy("key1", (Seq)Nil$.MODULE$).count().toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"key1", "cnt1"}));
        Dataset df2 = spark.range(0L, 1000L, 1L, $this.numInputPartitions()).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id % 500 as key2", "id as value2"})).groupBy("key2", (Seq)Nil$.MODULE$).count().toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"key2", "cnt2"}));
        Dataset join = df1.join(df2, functions$.MODULE$.col("key1").$eq$eq$eq((Object)functions$.MODULE$.col("key2"))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("key1"), functions$.MODULE$.col("cnt2")}));
        Dataset expectedAnswer = spark.range(0L, 500L).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "2 as cnt"}));
        QueryTest$.MODULE$.checkAnswer((Dataset<Row>)join, (Seq<Row>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(expectedAnswer.collect()), QueryTest$.MODULE$.checkAnswer$default$3());
        SparkPlan finalPlan = ((AdaptiveSparkPlanExec)join.queryExecution().executedPlan()).executedPlan();
        Seq shuffleReads = finalPlan.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                AQEShuffleReadExec aQEShuffleReadExec;
                A1 A1 = x3;
                Object object = A1 instanceof AQEShuffleReadExec && CoalescedShuffleRead$.MODULE$.unapply(aQEShuffleReadExec = (AQEShuffleReadExec)A1) ? aQEShuffleReadExec : function1.apply(x3);
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x3) {
                AQEShuffleReadExec aQEShuffleReadExec;
                SparkPlan sparkPlan2 = x3;
                boolean bl = sparkPlan2 instanceof AQEShuffleReadExec && CoalescedShuffleRead$.MODULE$.unapply(aQEShuffleReadExec = (AQEShuffleReadExec)sparkPlan2);
                return bl;
            }
        });
        Option option = minNumPostShufflePartitions$1;
        if (option instanceof Some) {
            Seq $org_scalatest_assert_macro_left = shuffleReads;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 216));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)shuffleReads.length()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219));
            shuffleReads.foreach((Function1 & Serializable)read -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)read.outputPartitioning().numPartitions()));
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221));
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    public static final /* synthetic */ void $anonfun$new$12(CoalesceShufflePartitionsSuite $this, Option minNumPostShufflePartitions$1, SparkSession spark) {
        Dataset df1 = spark.range(0L, 1000L, 1L, $this.numInputPartitions()).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id % 500 as key1", "id as value1"})).groupBy("key1", (Seq)Nil$.MODULE$).count().toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"key1", "cnt1"}));
        Dataset df2 = spark.range(0L, 1000L, 1L, $this.numInputPartitions()).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id % 500 as key2", "id as value2"}));
        Dataset join = df1.join(df2, functions$.MODULE$.col("key1").$eq$eq$eq((Object)functions$.MODULE$.col("key2"))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("key1"), functions$.MODULE$.col("cnt1"), functions$.MODULE$.col("value2")}));
        Dataset expectedAnswer = spark.range(0L, 1000L).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id % 500 as key", "2 as cnt", "id as value"}));
        QueryTest$.MODULE$.checkAnswer((Dataset<Row>)join, (Seq<Row>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(expectedAnswer.collect()), QueryTest$.MODULE$.checkAnswer$default$3());
        SparkPlan finalPlan = ((AdaptiveSparkPlanExec)join.queryExecution().executedPlan()).executedPlan();
        Seq shuffleReads = finalPlan.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                AQEShuffleReadExec aQEShuffleReadExec;
                A1 A1 = x4;
                Object object = A1 instanceof AQEShuffleReadExec && CoalescedShuffleRead$.MODULE$.unapply(aQEShuffleReadExec = (AQEShuffleReadExec)A1) ? aQEShuffleReadExec : function1.apply(x4);
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x4) {
                AQEShuffleReadExec aQEShuffleReadExec;
                SparkPlan sparkPlan2 = x4;
                boolean bl = sparkPlan2 instanceof AQEShuffleReadExec && CoalescedShuffleRead$.MODULE$.unapply(aQEShuffleReadExec = (AQEShuffleReadExec)sparkPlan2);
                return bl;
            }
        });
        Option option = minNumPostShufflePartitions$1;
        if (option instanceof Some) {
            Seq $org_scalatest_assert_macro_left = shuffleReads;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 267));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)shuffleReads.length()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
            shuffleReads.foreach((Function1 & Serializable)read -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)read.outputPartitioning().numPartitions()));
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 272));
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    public static final /* synthetic */ void $anonfun$new$15(CoalesceShufflePartitionsSuite $this, SparkSession spark) {
        try {
            spark.range(1000L).write().bucketBy(30, "id", (Seq)Nil$.MODULE$).saveAsTable("t");
            Dataset df1 = spark.read().table("t");
            Dataset df2 = spark.range(0L, 1000L, 1L, $this.numInputPartitions()).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id % 500 as key2", "id as value2"}));
            Dataset join = df1.join(df2, functions$.MODULE$.col("id").$eq$eq$eq((Object)functions$.MODULE$.col("key2"))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("id"), functions$.MODULE$.col("value2")}));
            Dataset expectedAnswer = spark.range(0L, 500L).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id % 500", "id as value"})).union(spark.range(500L, 1000L).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id % 500", "id as value"})));
            QueryTest$.MODULE$.checkAnswer((Dataset<Row>)join, (Seq<Row>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(expectedAnswer.collect()), QueryTest$.MODULE$.checkAnswer$default$3());
            SparkPlan finalPlan = ((AdaptiveSparkPlanExec)join.queryExecution().executedPlan()).executedPlan();
            Seq shuffleReads = finalPlan.collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                    AQEShuffleReadExec aQEShuffleReadExec;
                    A1 A1 = x5;
                    Object object = A1 instanceof AQEShuffleReadExec && CoalescedShuffleRead$.MODULE$.unapply(aQEShuffleReadExec = (AQEShuffleReadExec)A1) ? aQEShuffleReadExec : function1.apply(x5);
                    return (B1)object;
                }

                public final boolean isDefinedAt(SparkPlan x5) {
                    AQEShuffleReadExec aQEShuffleReadExec;
                    SparkPlan sparkPlan2 = x5;
                    boolean bl = sparkPlan2 instanceof AQEShuffleReadExec && CoalescedShuffleRead$.MODULE$.unapply(aQEShuffleReadExec = (AQEShuffleReadExec)sparkPlan2);
                    return bl;
                }
            });
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)shuffleReads.length()));
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 306));
        }
        finally {
            spark.sql("drop table t");
        }
    }

    public static final /* synthetic */ void $anonfun$new$1(CoalesceShufflePartitionsSuite $this, Option minNumPostShufflePartitions) {
        String string;
        Option option = minNumPostShufflePartitions;
        if (option instanceof Some) {
            Some some = (Some)option;
            int numPartitions = BoxesRunTime.unboxToInt((Object)some.value());
            string = new StringBuilder(31).append("(minNumPostShufflePartitions: ").append(numPartitions).append(")").toString();
        } else if (None$.MODULE$.equals(option)) {
            string = "";
        } else {
            throw new MatchError((Object)option);
        }
        String testNameNote = string;
        $this.test(new StringBuilder(54).append("determining the number of reducers: aggregate operator").append(testNameNote).toString(), (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Function1 & Serializable test = (Function1 & Serializable)spark -> {
                CoalesceShufflePartitionsSuite.$anonfun$new$3($this, minNumPostShufflePartitions, spark);
                return BoxedUnit.UNIT;
            };
            $this.withSparkSession((Function1<SparkSession, BoxedUnit>)test, 2000, (Option<Object>)minNumPostShufflePartitions, $this.withSparkSession$default$4());
        }, new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
        $this.test(new StringBuilder(49).append("determining the number of reducers: join operator").append(testNameNote).toString(), (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Function1 & Serializable test = (Function1 & Serializable)spark -> {
                CoalesceShufflePartitionsSuite.$anonfun$new$6($this, minNumPostShufflePartitions, spark);
                return BoxedUnit.UNIT;
            };
            $this.withSparkSession((Function1<SparkSession, BoxedUnit>)test, 16384, (Option<Object>)minNumPostShufflePartitions, $this.withSparkSession$default$4());
        }, new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
        $this.test(new StringBuilder(51).append("determining the number of reducers: complex query 1").append(testNameNote).toString(), (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Function1 & Serializable test = (Function1 & Serializable)spark -> {
                CoalesceShufflePartitionsSuite.$anonfun$new$9($this, minNumPostShufflePartitions, spark);
                return BoxedUnit.UNIT;
            };
            $this.withSparkSession((Function1<SparkSession, BoxedUnit>)test, 16384, (Option<Object>)minNumPostShufflePartitions, $this.withSparkSession$default$4());
        }, new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
        $this.test(new StringBuilder(51).append("determining the number of reducers: complex query 2").append(testNameNote).toString(), (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Function1 & Serializable test = (Function1 & Serializable)spark -> {
                CoalesceShufflePartitionsSuite.$anonfun$new$12($this, minNumPostShufflePartitions, spark);
                return BoxedUnit.UNIT;
            };
            $this.withSparkSession((Function1<SparkSession, BoxedUnit>)test, 12000, (Option<Object>)minNumPostShufflePartitions, $this.withSparkSession$default$4());
        }, new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229));
        $this.test(new StringBuilder(60).append("determining the number of reducers: plan already partitioned").append(testNameNote).toString(), (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Function1 & Serializable test = (Function1 & Serializable)spark -> {
                CoalesceShufflePartitionsSuite.$anonfun$new$15($this, spark);
                return BoxedUnit.UNIT;
            };
            $this.withSparkSession((Function1<SparkSession, BoxedUnit>)test, 12000, (Option<Object>)minNumPostShufflePartitions, $this.withSparkSession$default$4());
        }, new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 280));
    }

    public static final /* synthetic */ void $anonfun$new$17(SparkSession spark) {
        Seq reusedStages;
        Seq leafStages;
        Seq level1Stages;
        spark.sql("SET spark.sql.exchange.reuse=true");
        Dataset df = spark.range(0L, 6L, 1L).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id AS key", "id AS value"}));
        Dataset resultDf = df.join(df, "key").join(df, "key");
        QueryTest$.MODULE$.checkAnswer((Dataset<Row>)resultDf, (Seq<Row>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable)i -> Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))}))), QueryTest$.MODULE$.checkAnswer$default$3());
        SparkPlan finalPlan = ((AdaptiveSparkPlanExec)resultDf.queryExecution().executedPlan()).executedPlan();
        Seq $org_scalatest_assert_macro_left = finalPlan.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x6, Function1<A1, B1> function1) {
                Object object;
                ShuffleQueryStageExec shuffleQueryStageExec;
                SparkPlan r;
                A1 A1 = x6;
                if (A1 instanceof ShuffleQueryStageExec && (r = (shuffleQueryStageExec = (ShuffleQueryStageExec)A1).plan()) instanceof ReusedExchangeExec) {
                    ReusedExchangeExec reusedExchangeExec = (ReusedExchangeExec)r;
                    object = reusedExchangeExec;
                } else {
                    object = function1.apply(x6);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x6) {
                ShuffleQueryStageExec shuffleQueryStageExec;
                SparkPlan r;
                SparkPlan sparkPlan2 = x6;
                boolean bl = sparkPlan2 instanceof ShuffleQueryStageExec && (r = (shuffleQueryStageExec = (ShuffleQueryStageExec)sparkPlan2).plan()) instanceof ReusedExchangeExec;
                return bl;
            }
        });
        int $org_scalatest_assert_macro_right = 2;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 329));
        Seq $org_scalatest_assert_macro_left2 = finalPlan.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x7, Function1<A1, B1> function1) {
                AQEShuffleReadExec aQEShuffleReadExec;
                A1 A1 = x7;
                Object object = A1 instanceof AQEShuffleReadExec && CoalescedShuffleRead$.MODULE$.unapply(aQEShuffleReadExec = (AQEShuffleReadExec)A1) ? aQEShuffleReadExec : function1.apply(x7);
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x7) {
                AQEShuffleReadExec aQEShuffleReadExec;
                SparkPlan sparkPlan2 = x7;
                boolean bl = sparkPlan2 instanceof AQEShuffleReadExec && CoalescedShuffleRead$.MODULE$.unapply(aQEShuffleReadExec = (AQEShuffleReadExec)sparkPlan2);
                return bl;
            }
        });
        int $org_scalatest_assert_macro_right2 = 3;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 332));
        Dataset grouped = df.groupBy("key", (Seq)Nil$.MODULE$).agg(functions$.MODULE$.max("value").as("value"), (Seq)Nil$.MODULE$);
        Dataset resultDf2 = grouped.groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("key").$plus((Object)BoxesRunTime.boxToInteger((int)1))})).max((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"})).union(grouped.groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("key").$plus((Object)BoxesRunTime.boxToInteger((int)2))})).max((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"})));
        Row row = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)0)}));
        Row row2 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)0)}));
        Row row3 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1)}));
        Row row4 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)1)}));
        Row row5 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)2)}));
        Row row6 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)2)}));
        Row row7 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)3)}));
        Row row8 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)3)}));
        Row row9 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)4)}));
        Row row10 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)4)}));
        Row row11 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)5)}));
        Row row12 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7), BoxesRunTime.boxToInteger((int)5)}));
        QueryTest$.MODULE$.checkAnswer((Dataset<Row>)resultDf2, (Seq<Row>)package$.MODULE$.Nil().$colon$colon((Object)row12).$colon$colon((Object)row11).$colon$colon((Object)row10).$colon$colon((Object)row9).$colon$colon((Object)row8).$colon$colon((Object)row7).$colon$colon((Object)row6).$colon$colon((Object)row5).$colon$colon((Object)row4).$colon$colon((Object)row3).$colon$colon((Object)row2).$colon$colon((Object)row), QueryTest$.MODULE$.checkAnswer$default$3());
        SparkPlan finalPlan2 = ((AdaptiveSparkPlanExec)resultDf2.queryExecution().executedPlan()).executedPlan();
        Seq $org_scalatest_assert_macro_left3 = level1Stages = finalPlan2.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x8, Function1<A1, B1> function1) {
                QueryStageExec queryStageExec;
                A1 A1 = x8;
                Object object = A1 instanceof QueryStageExec ? (queryStageExec = (QueryStageExec)A1) : function1.apply(x8);
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x8) {
                SparkPlan sparkPlan2 = x8;
                boolean bl = sparkPlan2 instanceof QueryStageExec;
                return bl;
            }
        });
        int $org_scalatest_assert_macro_right3 = 2;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 356));
        Seq $org_scalatest_assert_macro_left4 = finalPlan2.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x9, Function1<A1, B1> function1) {
                AQEShuffleReadExec aQEShuffleReadExec;
                A1 A1 = x9;
                Object object = A1 instanceof AQEShuffleReadExec && CoalescedShuffleRead$.MODULE$.unapply(aQEShuffleReadExec = (AQEShuffleReadExec)A1) ? aQEShuffleReadExec : function1.apply(x9);
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x9) {
                AQEShuffleReadExec aQEShuffleReadExec;
                SparkPlan sparkPlan2 = x9;
                boolean bl = sparkPlan2 instanceof AQEShuffleReadExec && CoalescedShuffleRead$.MODULE$.unapply(aQEShuffleReadExec = (AQEShuffleReadExec)sparkPlan2);
                return bl;
            }
        });
        int $org_scalatest_assert_macro_right4 = 2;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"finalPlan2", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 358));
        level1Stages.foreach((Function1 & Serializable)qs -> {
            Seq $org_scalatest_assert_macro_left = qs.plan().collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x10, Function1<A1, B1> function1) {
                    AQEShuffleReadExec aQEShuffleReadExec;
                    A1 A1 = x10;
                    Object object = A1 instanceof AQEShuffleReadExec && CoalescedShuffleRead$.MODULE$.unapply(aQEShuffleReadExec = (AQEShuffleReadExec)A1) ? aQEShuffleReadExec : function1.apply(x10);
                    return (B1)object;
                }

                public final boolean isDefinedAt(SparkPlan x10) {
                    AQEShuffleReadExec aQEShuffleReadExec;
                    SparkPlan sparkPlan2 = x10;
                    boolean bl = sparkPlan2 instanceof AQEShuffleReadExec && CoalescedShuffleRead$.MODULE$.unapply(aQEShuffleReadExec = (AQEShuffleReadExec)sparkPlan2);
                    return bl;
                }
            });
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(33).append("Wrong CoalescedShuffleRead below ").append(qs.simpleString(3)).toString(), Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 364));
        });
        Seq $org_scalatest_assert_macro_left5 = leafStages = (Seq)level1Stages.flatMap((Function1 & Serializable)stage -> {
            void var1_1;
            Seq children;
            Seq $org_scalatest_assert_macro_left = children = stage.plan().collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x11, Function1<A1, B1> function1) {
                    QueryStageExec queryStageExec;
                    A1 A1 = x11;
                    Object object = A1 instanceof QueryStageExec ? (queryStageExec = (QueryStageExec)A1) : function1.apply(x11);
                    return (B1)object;
                }

                public final boolean isDefinedAt(SparkPlan x11) {
                    SparkPlan sparkPlan2 = x11;
                    boolean bl = sparkPlan2 instanceof QueryStageExec;
                    return bl;
                }
            });
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 372));
            return var1_1;
        });
        int $org_scalatest_assert_macro_right5 = 2;
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 375));
        Seq $org_scalatest_assert_macro_left6 = reusedStages = (Seq)level1Stages.flatMap((Function1 & Serializable)stage -> stage.plan().collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x12, Function1<A1, B1> function1) {
                Object object;
                ShuffleQueryStageExec shuffleQueryStageExec;
                SparkPlan r;
                A1 A1 = x12;
                if (A1 instanceof ShuffleQueryStageExec && (r = (shuffleQueryStageExec = (ShuffleQueryStageExec)A1).plan()) instanceof ReusedExchangeExec) {
                    ReusedExchangeExec reusedExchangeExec = (ReusedExchangeExec)r;
                    object = reusedExchangeExec;
                } else {
                    object = function1.apply(x12);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x12) {
                ShuffleQueryStageExec shuffleQueryStageExec;
                SparkPlan r;
                SparkPlan sparkPlan2 = x12;
                boolean bl = sparkPlan2 instanceof ShuffleQueryStageExec && (r = (shuffleQueryStageExec = (ShuffleQueryStageExec)sparkPlan2).plan()) instanceof ReusedExchangeExec;
                return bl;
            }
        }));
        int $org_scalatest_assert_macro_right6 = 1;
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 382));
    }

    public static final /* synthetic */ void $anonfun$new$23(SparkSession spark) {
        Dataset ds = spark.range(3L);
        Dataset resultDf = ds.repartition(2, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{ds.col("id")})).toDF();
        QueryTest$.MODULE$.checkAnswer((Dataset<Row>)resultDf, (Seq<Row>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})).map((Function1 & Serializable)i -> Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))})))), QueryTest$.MODULE$.checkAnswer$default$3());
        SparkPlan finalPlan = ((AdaptiveSparkPlanExec)resultDf.queryExecution().executedPlan()).executedPlan();
        Seq $org_scalatest_assert_macro_left = finalPlan.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x13, Function1<A1, B1> function1) {
                AQEShuffleReadExec aQEShuffleReadExec;
                A1 A1 = x13;
                Object object = A1 instanceof AQEShuffleReadExec && CoalescedShuffleRead$.MODULE$.unapply(aQEShuffleReadExec = (AQEShuffleReadExec)A1) ? aQEShuffleReadExec : function1.apply(x13);
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x13) {
                AQEShuffleReadExec aQEShuffleReadExec;
                SparkPlan sparkPlan2 = x13;
                boolean bl = sparkPlan2 instanceof AQEShuffleReadExec && CoalescedShuffleRead$.MODULE$.unapply(aQEShuffleReadExec = (AQEShuffleReadExec)sparkPlan2);
                return bl;
            }
        });
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 396));
    }

    public static final /* synthetic */ void $anonfun$new$26(SparkSession spark) {
        Dataset df1 = spark.range(3L).join(spark.range(3L), "id").toDF();
        Dataset df2 = spark.range(3L).groupBy((Seq)Nil$.MODULE$).sum((Seq)Nil$.MODULE$);
        Dataset resultDf = df1.union(df2);
        QueryTest$.MODULE$.checkAnswer((Dataset<Row>)resultDf, (Seq<Row>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3})).map((Function1 & Serializable)i -> Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))})))), QueryTest$.MODULE$.checkAnswer$default$3());
        SparkPlan finalPlan = ((AdaptiveSparkPlanExec)resultDf.queryExecution().executedPlan()).executedPlan();
        Seq $org_scalatest_assert_macro_left = finalPlan.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x14, Function1<A1, B1> function1) {
                AQEShuffleReadExec aQEShuffleReadExec;
                A1 A1 = x14;
                Object object = A1 instanceof AQEShuffleReadExec && CoalescedShuffleRead$.MODULE$.unapply(aQEShuffleReadExec = (AQEShuffleReadExec)A1) ? aQEShuffleReadExec : function1.apply(x14);
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x14) {
                AQEShuffleReadExec aQEShuffleReadExec;
                SparkPlan sparkPlan2 = x14;
                boolean bl = sparkPlan2 instanceof AQEShuffleReadExec && CoalescedShuffleRead$.MODULE$.unapply(aQEShuffleReadExec = (AQEShuffleReadExec)sparkPlan2);
                return bl;
            }
        });
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 417));
    }

    public static final /* synthetic */ void $anonfun$new$29(CoalesceShufflePartitionsSuite $this, SparkSession spark) {
        Dataset ds = spark.range(0L, 100L, 1L, $this.numInputPartitions());
        Dataset resultDf = ds.repartition((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{ds.col("id")}));
        resultDf.collect();
        SparkPlan finalPlan = ((AdaptiveSparkPlanExec)resultDf.queryExecution().executedPlan()).executedPlan();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(finalPlan.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x15, Function1<A1, B1> function1) {
                AQEShuffleReadExec aQEShuffleReadExec;
                A1 A1 = x15;
                Object object = A1 instanceof AQEShuffleReadExec && CoalescedShuffleRead$.MODULE$.unapply(aQEShuffleReadExec = (AQEShuffleReadExec)A1) ? aQEShuffleReadExec : function1.apply(x15);
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x15) {
                AQEShuffleReadExec aQEShuffleReadExec;
                SparkPlan sparkPlan2 = x15;
                boolean bl = sparkPlan2 instanceof AQEShuffleReadExec && CoalescedShuffleRead$.MODULE$.unapply(aQEShuffleReadExec = (AQEShuffleReadExec)sparkPlan2);
                return bl;
            }
        }).isDefinedAt(0), "finalPlan.collect[org.apache.spark.sql.execution.adaptive.AQEShuffleReadExec](({\n  @SerialVersionUID(value = 0) final <synthetic> class $anonfun extends scala.runtime.AbstractPartialFunction[org.apache.spark.sql.execution.SparkPlan,org.apache.spark.sql.execution.adaptive.AQEShuffleReadExec] with java.io.Serializable {\n    def <init>(): <$anon: org.apache.spark.sql.execution.SparkPlan => org.apache.spark.sql.execution.adaptive.AQEShuffleReadExec> = {\n      $anonfun.super.<init>();\n      ()\n    };\n    final override def applyOrElse[A1 <: org.apache.spark.sql.execution.SparkPlan, B1 >: org.apache.spark.sql.execution.adaptive.AQEShuffleReadExec](x15: A1, default: A1 => B1): B1 = ((x15.asInstanceOf[org.apache.spark.sql.execution.SparkPlan]: org.apache.spark.sql.execution.SparkPlan): org.apache.spark.sql.execution.SparkPlan @unchecked) match {\n      case (r @ CoalescedShuffleRead.unapply(<unapply-selector>) <unapply> ()) => r\n      case (defaultCase$ @ _) => default.apply(x15)\n    };\n    final def isDefinedAt(x15: org.apache.spark.sql.execution.SparkPlan): Boolean = ((x15.asInstanceOf[org.apache.spark.sql.execution.SparkPlan]: org.apache.spark.sql.execution.SparkPlan): org.apache.spark.sql.execution.SparkPlan @unchecked) match {\n      case (r @ CoalescedShuffleRead.unapply(<unapply-selector>) <unapply> ()) => true\n      case (defaultCase$ @ _) => false\n    }\n  };\n  new $anonfun()\n}: PartialFunction[org.apache.spark.sql.execution.SparkPlan,org.apache.spark.sql.execution.adaptive.AQEShuffleReadExec])).isDefinedAt(0)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 433));
    }

    public CoalesceShufflePartitionsSuite() {
        this.numInputPartitions = 10;
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{new Some((Object)BoxesRunTime.boxToInteger((int)5)), None$.MODULE$})).foreach((Function1 & Serializable)minNumPostShufflePartitions -> {
            CoalesceShufflePartitionsSuite.$anonfun$new$1(this, minNumPostShufflePartitions);
            return BoxedUnit.UNIT;
        });
        this.test("SPARK-24705 adaptive query execution works correctly when exchange reuse enabled", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Function1 & Serializable test = (Function1 & Serializable)spark -> {
                CoalesceShufflePartitionsSuite.$anonfun$new$17(spark);
                return BoxedUnit.UNIT;
            };
            this.withSparkSession((Function1<SparkSession, BoxedUnit>)test, 400, (Option<Object>)None$.MODULE$, this.withSparkSession$default$4());
        }, new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 315));
        this.test("Do not reduce the number of shuffle partition for repartition", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Function1 & Serializable test = (Function1 & Serializable)spark -> {
                CoalesceShufflePartitionsSuite.$anonfun$new$23(spark);
                return BoxedUnit.UNIT;
            };
            this.withSparkSession((Function1<SparkSession, BoxedUnit>)test, 200, (Option<Object>)None$.MODULE$, this.withSparkSession$default$4());
        }, new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 387));
        this.test("Union two datasets with different pre-shuffle partition number", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Function1 & Serializable test = (Function1 & Serializable)spark -> {
                CoalesceShufflePartitionsSuite.$anonfun$new$26(spark);
                return BoxedUnit.UNIT;
            };
            this.withSparkSession((Function1<SparkSession, BoxedUnit>)test, 100, (Option<Object>)None$.MODULE$, this.withSparkSession$default$4());
        }, new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 404));
        this.test("SPARK-34790: enable IO encryption in AQE partition coalescing", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Function1 & Serializable test = (Function1 & Serializable)spark -> {
                CoalesceShufflePartitionsSuite.$anonfun$new$29(this, spark);
                return BoxedUnit.UNIT;
            };
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, false})).foreach((Function1 & Serializable)enableIOEncryption -> {
                this.withSparkSession((Function1<SparkSession, BoxedUnit>)test, Integer.MAX_VALUE, (Option<Object>)None$.MODULE$, BoxesRunTime.unboxToBoolean((Object)enableIOEncryption));
                return BoxedUnit.UNIT;
            });
        }, new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 425));
    }
}

