/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Properties;
import org.apache.spark.HashPartitioner;
import org.apache.spark.Partitioner;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.ShuffleDependency$;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContextImpl;
import org.apache.spark.TaskContextImpl$;
import org.apache.spark.internal.config.Tests$;
import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.rdd.RDD;
import org.apache.spark.serializer.SerializationStream;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.sql.LocalSparkSession;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.ClosableByteArrayInputStream;
import org.apache.spark.sql.execution.PartitionIdPassthrough;
import org.apache.spark.sql.execution.ShuffledRowRDD;
import org.apache.spark.sql.execution.UnsafeRowSerializer;
import org.apache.spark.sql.execution.UnsafeRowSerializer$;
import org.apache.spark.sql.execution.metric.SQLShuffleReadMetricsReporter$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.ShuffleBlockId;
import org.apache.spark.util.collection.ExternalSorter;
import org.apache.spark.util.collection.ExternalSorter$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u00013A\u0001B\u0003\u0001!!)\u0011\u0004\u0001C\u00015!)Q\u0004\u0001C\u0005=!)!\b\u0001C\u0005w\tARK\\:bM\u0016\u0014vn^*fe&\fG.\u001b>feN+\u0018\u000e^3\u000b\u0005\u00199\u0011!C3yK\u000e,H/[8o\u0015\tA\u0011\"A\u0002tc2T!AC\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u00051i\u0011AB1qC\u000eDWMC\u0001\u000f\u0003\ry'oZ\u0002\u0001'\r\u0001\u0011#\u0006\t\u0003%Mi\u0011!C\u0005\u0003)%\u0011Qb\u00159be.4UO\\*vSR,\u0007C\u0001\f\u0018\u001b\u00059\u0011B\u0001\r\b\u0005EaunY1m'B\f'o[*fgNLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0001\"\u0001\b\u0001\u000e\u0003\u0015\t1\u0002^8V]N\fg-\u001a*poR\u0019qd\n\u0017\u0011\u0005\u0001*S\"A\u0011\u000b\u0005\t\u001a\u0013aC3yaJ,7o]5p]NT!\u0001J\u0004\u0002\u0011\r\fG/\u00197zgRL!AJ\u0011\u0003\u0013Us7/\u00194f%><\b\"\u0002\u0015\u0003\u0001\u0004I\u0013a\u0001:poB\u0011aCK\u0005\u0003W\u001d\u00111AU8x\u0011\u0015i#\u00011\u0001/\u0003\u0019\u00198\r[3nCB\u0019qF\r\u001b\u000e\u0003AR\u0011!M\u0001\u0006g\u000e\fG.Y\u0005\u0003gA\u0012Q!\u0011:sCf\u0004\"!\u000e\u001d\u000e\u0003YR!aN\u0004\u0002\u000bQL\b/Z:\n\u0005e2$\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002%Ut7/\u00194f%><8i\u001c8wKJ$XM\u001d\u000b\u0003y}\u0002BaL\u001f*?%\u0011a\b\r\u0002\n\rVt7\r^5p]FBQ!L\u0002A\u00029\u0002")
public class UnsafeRowSerializerSuite
extends SparkFunSuite
implements LocalSparkSession {
    private transient SparkSession spark;

    @Override
    public /* synthetic */ void org$apache$spark$sql$LocalSparkSession$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$LocalSparkSession$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    @Override
    public void beforeAll() {
        LocalSparkSession.beforeAll$(this);
    }

    @Override
    public void afterEach() {
        LocalSparkSession.afterEach$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    private UnsafeRow toUnsafeRow(Row row, DataType[] schema) {
        Function1<Row, UnsafeRow> converter = this.unsafeRowConverter(schema);
        return (UnsafeRow)converter.apply((Object)row);
    }

    private Function1<Row, UnsafeRow> unsafeRowConverter(DataType[] schema) {
        UnsafeProjection converter = UnsafeProjection$.MODULE$.create(schema);
        return (Function1 & Serializable)row -> converter.apply((InternalRow)CatalystTypeConverters$.MODULE$.convertToCatalyst(row));
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$8(Function1 converter$2, int i) {
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)i), converter$2.apply((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}))));
    }

    public UnsafeRowSerializerSuite() {
        LocalSparkSession.$init$(this);
        this.test("toUnsafeRow() test helper method", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Row row = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", BoxesRunTime.boxToInteger((int)123)}));
            UnsafeRow unsafeRow = this.toUnsafeRow(row, (DataType[])((Object[])new DataType[]{StringType$.MODULE$, IntegerType$.MODULE$}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(row.getString(0));
            String $org_scalatest_assert_macro_right = unsafeRow.getUTF8String(0).toString();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowSerializerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)row.getInt(1)));
            int $org_scalatest_assert_macro_right2 = unsafeRow.getInt(1);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowSerializerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
        }, new Position("UnsafeRowSerializerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
        this.test("basic row serialization", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Seq rows = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", BoxesRunTime.boxToInteger((int)1)})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"World", BoxesRunTime.boxToInteger((int)2)}))}));
            Seq unsafeRows = (Seq)rows.map((Function1 & Serializable)row -> this.toUnsafeRow((Row)row, (DataType[])((Object[])new DataType[]{StringType$.MODULE$, IntegerType$.MODULE$})));
            SerializerInstance serializer = new UnsafeRowSerializer(2, UnsafeRowSerializer$.MODULE$.$lessinit$greater$default$2()).newInstance();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            SerializationStream serializerStream = serializer.serializeStream((OutputStream)baos);
            unsafeRows.foreach((Function1 & Serializable)unsafeRow -> {
                serializerStream.writeKey((Object)BoxesRunTime.boxToInteger((int)0), (ClassTag)ClassTag$.MODULE$.Int());
                return serializerStream.writeValue(unsafeRow, ClassTag$.MODULE$.apply(UnsafeRow.class));
            });
            serializerStream.close();
            ClosableByteArrayInputStream input = new ClosableByteArrayInputStream(baos.toByteArray());
            Iterator deserializerIter = serializer.deserializeStream((InputStream)input).asKeyValueIterator();
            unsafeRows.foreach((Function1 & Serializable)expectedRow -> {
                UnsafeRow actualRow = (UnsafeRow)((Tuple2)deserializerIter.next())._2();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)expectedRow.getSizeInBytes()));
                int $org_scalatest_assert_macro_right = actualRow.getSizeInBytes();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowSerializerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(expectedRow.getString(0));
                String $org_scalatest_assert_macro_right2 = actualRow.getString(0);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowSerializerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)expectedRow.getInt(1)));
                int $org_scalatest_assert_macro_right3 = actualRow.getInt(1);
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowSerializerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
            });
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(deserializerIter.hasNext(), "deserializerIter.hasNext", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowSerializerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(input.closed(), "input.closed", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowSerializerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
        }, new Position("UnsafeRowSerializerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        this.test("close empty input stream", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ClosableByteArrayInputStream input = new ClosableByteArrayInputStream((byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()));
            SerializerInstance serializer = new UnsafeRowSerializer(2, UnsafeRowSerializer$.MODULE$.$lessinit$greater$default$2()).newInstance();
            Iterator deserializerIter = serializer.deserializeStream((InputStream)input).asKeyValueIterator();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(deserializerIter.hasNext(), "deserializerIter.hasNext", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowSerializerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(input.closed(), "input.closed", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowSerializerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
        }, new Position("UnsafeRowSerializerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        this.test("SPARK-10466: external sorter spilling with unsafe row serializer", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TaskContextImpl taskContext;
            SparkConf conf = new SparkConf().set(org.apache.spark.internal.config.package$.MODULE$.SHUFFLE_SPILL_INITIAL_MEM_THRESHOLD(), (Object)BoxesRunTime.boxToLong((long)1L)).set(org.apache.spark.internal.config.package$.MODULE$.SHUFFLE_SORT_BYPASS_MERGE_THRESHOLD(), (Object)BoxesRunTime.boxToInteger((int)0)).set(Tests$.MODULE$.TEST_MEMORY(), (Object)BoxesRunTime.boxToLong((long)80000L));
            this.spark_$eq(SparkSession$.MODULE$.builder().master("local").appName("test").config(conf).getOrCreate());
            File outputFile = File.createTempFile("test-unsafe-row-serializer-spill", "");
            outputFile.deleteOnExit();
            Function1<Row, UnsafeRow> converter = this.unsafeRowConverter((DataType[])((Object[])new DataType[]{IntegerType$.MODULE$}));
            Iterator data = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10000).iterator().map((Function1 & Serializable)i -> UnsafeRowSerializerSuite.$anonfun$new$8(converter, BoxesRunTime.unboxToInt((Object)i)));
            TaskMemoryManager taskMemoryManager = new TaskMemoryManager(this.spark().sparkContext().env().memoryManager(), 0L);
            TaskContextImpl x$1 = taskContext = new TaskContextImpl(0, 0, 0, 0L, 0, taskMemoryManager, new Properties(), null, TaskContextImpl$.MODULE$.$lessinit$greater$default$9(), TaskContextImpl$.MODULE$.$lessinit$greater$default$10());
            Some x$2 = new Some((Object)new HashPartitioner(10));
            UnsafeRowSerializer x$3 = new UnsafeRowSerializer(1, UnsafeRowSerializer$.MODULE$.$lessinit$greater$default$2());
            None$ x$4 = ExternalSorter$.MODULE$.$lessinit$greater$default$2();
            None$ x$5 = ExternalSorter$.MODULE$.$lessinit$greater$default$4();
            ExternalSorter sorter = new ExternalSorter((TaskContext)x$1, (Option)x$4, (Option)x$2, (Option)x$5, (Serializer)x$3);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)sorter.numSpills()));
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowSerializerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
            sorter.insertAll(data);
            int $org_scalatest_assert_macro_left2 = sorter.numSpills();
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 > $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowSerializerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
            return sorter.writePartitionedFile((BlockId)new ShuffleBlockId(0, 0L, 0), outputFile);
        }, new Position("UnsafeRowSerializerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
        this.test("SPARK-10403: unsafe row serializer with SortShuffleManager", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcJ.sp & Serializable)() -> {
            SparkConf conf = new SparkConf().set(org.apache.spark.internal.config.package$.MODULE$.SHUFFLE_MANAGER(), (Object)"sort");
            this.spark_$eq(SparkSession$.MODULE$.builder().master("local").appName("test").config(conf).getOrCreate());
            Row row = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", BoxesRunTime.boxToInteger((int)123)}));
            UnsafeRow unsafeRow = this.toUnsafeRow(row, (DataType[])((Object[])new DataType[]{StringType$.MODULE$, IntegerType$.MODULE$}));
            SparkContext qual$1 = this.spark().sparkContext();
            Seq x$6 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)unsafeRow), new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)unsafeRow), new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)unsafeRow)}));
            int x$7 = qual$1.parallelize$default$2();
            RDD rowsRDD = qual$1.parallelize(x$6, x$7, ClassTag$.MODULE$.apply(Tuple2.class));
            ShuffleDependency dependency = new ShuffleDependency(rowsRDD, (Partitioner)new PartitionIdPassthrough(2), (Serializer)new UnsafeRowSerializer(2, UnsafeRowSerializer$.MODULE$.$lessinit$greater$default$2()), (Option)ShuffleDependency$.MODULE$.$lessinit$greater$default$4(), (Option)ShuffleDependency$.MODULE$.$lessinit$greater$default$5(), ShuffleDependency$.MODULE$.$lessinit$greater$default$6(), ShuffleDependency$.MODULE$.$lessinit$greater$default$7(), (ClassTag)ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(InternalRow.class), ClassTag$.MODULE$.apply(InternalRow.class));
            ShuffledRowRDD shuffled = new ShuffledRowRDD(dependency, SQLShuffleReadMetricsReporter$.MODULE$.createShuffleReadMetrics(this.spark().sparkContext()));
            return shuffled.count();
        }, new Position("UnsafeRowSerializerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
    }
}

