/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.aggregate;

import java.io.Serializable;
import java.util.Properties;
import java.util.Random;
import org.apache.spark.LocalSparkContext;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.TaskContextImpl;
import org.apache.spark.TaskContextImpl$;
import org.apache.spark.memory.MemoryManager;
import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.memory.TestMemoryManager;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.aggregate.AggregationBufferEntry;
import org.apache.spark.sql.execution.aggregate.ObjectAggregationMap;
import org.apache.spark.sql.execution.aggregate.SortBasedAggregator;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.KVIterator;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.StrictOptimizedLinearSeqOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005!4A\u0001D\u0007\u00015!)!\u0005\u0001C\u0001G!)a\u0005\u0001C!O!)a\u0006\u0001C!O!9q\u0006\u0001b\u0001\n\u0013\u0001\u0004BB\u001d\u0001A\u0003%\u0011\u0007C\u0003;\u0001\u0011%1\bC\u0003C\u0001\u0011%1\tC\u0003H\u0001\u0011%1\tC\u0003I\u0001\u0011%\u0011\nC\u0003V\u0001\u0011%a\u000bC\u0003\\\u0001\u0011\u0005AL\u0001\u0010T_J$()Y:fI\u0006;wM]3hCRLwN\\*u_J,7+^5uK*\u0011abD\u0001\nC\u001e<'/Z4bi\u0016T!\u0001E\t\u0002\u0013\u0015DXmY;uS>t'B\u0001\n\u0014\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003)U\tQa\u001d9be.T!AF\f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0012aA8sO\u000e\u00011c\u0001\u0001\u001c?A\u0011A$H\u0007\u0002'%\u0011ad\u0005\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005q\u0001\u0013BA\u0011\u0014\u0005EaunY1m'B\f'o[\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0011\u0002\"!\n\u0001\u000e\u00035\t\u0011BY3g_J,\u0017\t\u001c7\u0015\u0003!\u0002\"!\u000b\u0017\u000e\u0003)R\u0011aK\u0001\u0006g\u000e\fG.Y\u0005\u0003[)\u0012A!\u00168ji\u0006A\u0011M\u001a;fe\u0006cG.\u0001\u0003sC:$W#A\u0019\u0011\u0005I:T\"A\u001a\u000b\u0005Q*\u0014\u0001B;uS2T\u0011AN\u0001\u0005U\u00064\u0018-\u0003\u00029g\t1!+\u00198e_6\fQA]1oI\u0002\n!d\u0019:fCR,g*Z<BO\u001e\u0014XmZ1uS>t')\u001e4gKJ$\u0012\u0001\u0010\t\u0003{\u0001k\u0011A\u0010\u0006\u0003\u007fE\t\u0001bY1uC2L8\u000f^\u0005\u0003\u0003z\u00121\"\u00138uKJt\u0017\r\u001c*po\u0006qQ\u000f\u001d3bi\u0016Le\u000e];u%><X#\u0001#\u0011\u000b%*E\b\u0010\u0015\n\u0005\u0019S#!\u0003$v]\u000e$\u0018n\u001c83\u00039iWM]4f\u0003\u001e<')\u001e4gKJ\fqb\u0019:fCR,WK\\:bM\u0016\u0014vn\u001e\u000b\u0003\u0015B\u0003\"a\u0013(\u000e\u00031S!!\u0014 \u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0003\u001f2\u0013\u0011\"\u00168tC\u001a,'k\\<\t\u000bEK\u0001\u0019\u0001*\u0002\u00159,Xn\u00144GS\u0016dG\r\u0005\u0002*'&\u0011AK\u000b\u0002\u0004\u0013:$\u0018\u0001\u0003:b]\u0012|Wn\u0013,\u0015\u0007!:\u0016\fC\u0003Y\u0015\u0001\u0007!*\u0001\u0005j]B,HOU8x\u0011\u0015Q&\u00021\u0001K\u0003\u00159'o\\;q\u0003u\u0019'/Z1uKN{'\u000f^3e\u0003\u001e<')\u001e4gKJLE/\u001a:bi>\u0014HCA/d!\u0011q\u0016M\u0013&\u000e\u0003}S!\u0001Y\n\u0002\rUt7/\u00194f\u0013\t\u0011wL\u0001\u0006L-&#XM]1u_JDQ\u0001Z\u0006A\u0002\u0015\fq\u0001[1tQ6\u000b\u0007\u000f\u0005\u0002&M&\u0011q-\u0004\u0002\u0015\u001f\nTWm\u0019;BO\u001e\u0014XmZ1uS>tW*\u00199")
public class SortBasedAggregationStoreSuite
extends SparkFunSuite
implements LocalSparkContext {
    private final Random rand;
    private transient SparkContext sc;

    public /* synthetic */ void org$apache$spark$LocalSparkContext$$super$beforeAll() {
        super.beforeAll();
    }

    public /* synthetic */ void org$apache$spark$LocalSparkContext$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    public void afterEach() {
        LocalSparkContext.afterEach$((LocalSparkContext)this);
    }

    public void resetSparkContext() {
        LocalSparkContext.resetSparkContext$((LocalSparkContext)this);
    }

    public SparkContext sc() {
        return this.sc;
    }

    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    public void beforeAll() {
        LocalSparkContext.beforeAll$((LocalSparkContext)this);
        SparkConf conf = new SparkConf();
        this.sc_$eq(new SparkContext("local[2, 4]", "test", conf));
        TaskMemoryManager taskManager = new TaskMemoryManager((MemoryManager)new TestMemoryManager(conf), 0L);
        TaskContext$.MODULE$.setTaskContext((TaskContext)new TaskContextImpl(0, 0, 0, 0L, 0, taskManager, new Properties(), null, TaskContextImpl$.MODULE$.$lessinit$greater$default$9(), TaskContextImpl$.MODULE$.$lessinit$greater$default$10()));
    }

    public void afterAll() {
        try {
            TaskContext$.MODULE$.unset();
        }
        finally {
            super.afterAll();
        }
    }

    private Random rand() {
        return this.rand;
    }

    /*
     * WARNING - void declaration
     */
    private InternalRow createNewAggregationBuffer() {
        void var1_1;
        UnsafeRow buffer = this.createUnsafeRow(1);
        buffer.setInt(0, 0);
        return var1_1;
    }

    private Function2<InternalRow, InternalRow, BoxedUnit> updateInputRow() {
        return (Function2 & Serializable)(buffer, input) -> {
            buffer.setInt(0, buffer.getInt(0) ^ input.getInt(0));
            return BoxedUnit.UNIT;
        };
    }

    private Function2<InternalRow, InternalRow, BoxedUnit> mergeAggBuffer() {
        return this.updateInputRow();
    }

    /*
     * WARNING - void declaration
     */
    private UnsafeRow createUnsafeRow(int numOfField) {
        void var3_3;
        byte[] buffer = new byte[1024];
        UnsafeRow row = new UnsafeRow(numOfField);
        row.pointTo(buffer, 1024);
        return var3_3;
    }

    private void randomKV(UnsafeRow inputRow, UnsafeRow group) {
        inputRow.setInt(0, this.rand().nextInt(100000));
        inputRow.setInt(1, this.rand().nextInt(10000));
        group.setInt(0, inputRow.getInt(1) % 100);
    }

    public KVIterator<UnsafeRow, UnsafeRow> createSortedAggBufferIterator(ObjectAggregationMap hashMap) {
        Iterator sortedIterator = ((StrictOptimizedLinearSeqOps)hashMap.iterator().toList().sortBy((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)SortBasedAggregationStoreSuite.$anonfun$createSortedAggBufferIterator$1(x$3)), (Ordering)Ordering.Int$.MODULE$)).iterator();
        return new KVIterator<UnsafeRow, UnsafeRow>(null, sortedIterator){
            private UnsafeRow key;
            private UnsafeRow value;
            private final Iterator sortedIterator$1;

            private UnsafeRow key() {
                return this.key;
            }

            private void key_$eq(UnsafeRow x$1) {
                this.key = x$1;
            }

            private UnsafeRow value() {
                return this.value;
            }

            private void value_$eq(UnsafeRow x$1) {
                this.value = x$1;
            }

            public boolean next() {
                boolean bl;
                if (this.sortedIterator$1.hasNext()) {
                    AggregationBufferEntry kv = (AggregationBufferEntry)this.sortedIterator$1.next();
                    this.key_$eq(kv.groupingKey());
                    this.value_$eq((UnsafeRow)kv.aggregationBuffer());
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }

            public UnsafeRow getKey() {
                return this.key();
            }

            public UnsafeRow getValue() {
                return this.value();
            }

            public void close() {
            }
            {
                this.sortedIterator$1 = sortedIterator$1;
                this.key = null;
                this.value = null;
            }
        };
    }

    public static final /* synthetic */ int $anonfun$createSortedAggBufferIterator$1(AggregationBufferEntry x$3) {
        return x$3.groupingKey().getInt(0);
    }

    public SortBasedAggregationStoreSuite() {
        LocalSparkContext.$init$((LocalSparkContext)this);
        this.rand = new Random();
        this.test("merge input kv iterator and aggregation buffer iterator", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            StructType inputSchema = StructType$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("b", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
            StructType groupingSchema = StructType$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("b", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
            UnsafeRow inputRow = this.createUnsafeRow(2);
            UnsafeRow group = this.createUnsafeRow(1);
            HashMap expected = new HashMap();
            ObjectAggregationMap hashMap = new ObjectAggregationMap();
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 5000).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> {
                this.randomKV(inputRow, group);
                expected.put((Object)BoxesRunTime.boxToInteger((int)group.getInt(0)), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)expected.getOrElse((Object)BoxesRunTime.boxToInteger((int)group.getInt(0)), (Function0)(JFunction0.mcI.sp & Serializable)() -> 0)) ^ inputRow.getInt(0))));
                if (hashMap.getAggregationBuffer(group) == null) {
                    hashMap.putAggregationBuffer(group.copy(), this.createNewAggregationBuffer());
                }
                this.updateInputRow().apply((Object)hashMap.getAggregationBuffer(group), (Object)inputRow);
            });
            SortBasedAggregator store = new SortBasedAggregator(this.createSortedAggBufferIterator(hashMap), inputSchema, groupingSchema, this.updateInputRow(), this.mergeAggBuffer(), (Function0 & Serializable)() -> this.createNewAggregationBuffer());
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(5000), 100000).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> {
                this.randomKV(inputRow, group);
                expected.put((Object)BoxesRunTime.boxToInteger((int)group.getInt(0)), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)expected.getOrElse((Object)BoxesRunTime.boxToInteger((int)group.getInt(0)), (Function0)(JFunction0.mcI.sp & Serializable)() -> 0)) ^ inputRow.getInt(0))));
                store.addInput(group, inputRow);
            });
            Iterator iter = store.destructiveIterator();
            while (iter.hasNext()) {
                AggregationBufferEntry agg = (AggregationBufferEntry)iter.next();
                int $org_scalatest_assert_macro_left = agg.aggregationBuffer().getInt(0);
                int $org_scalatest_assert_macro_right = BoxesRunTime.unboxToInt((Object)expected.apply((Object)BoxesRunTime.boxToInteger((int)agg.groupingKey().getInt(0))));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SortBasedAggregationStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
            }
        }, new Position("SortBasedAggregationStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
    }
}

