/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.orc;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.URI;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.orc.TypeDescription;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.QueryTest;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.execution.datasources.orc.OrcColumnVector;
import org.apache.spark.sql.execution.datasources.orc.OrcColumnarBatchReader;
import org.apache.spark.sql.execution.datasources.parquet.SpecificParquetRecordReaderBase;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.test.SQLTestData;
import org.apache.spark.sql.test.SQLTestData$internalImplicits$;
import org.apache.spark.sql.test.SQLTestUtils;
import org.apache.spark.sql.test.SQLTestUtilsBase;
import org.apache.spark.sql.test.SQLTestUtilsBase$testImplicits$;
import org.apache.spark.sql.test.SharedSparkSession;
import org.apache.spark.sql.test.SharedSparkSessionBase;
import org.apache.spark.sql.test.TestSparkSession;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.scalatest.concurrent.AbstractPatienceConfiguration;
import org.scalatest.concurrent.AbstractPatienceConfiguration$PatienceConfig$;
import org.scalatest.concurrent.Eventually;
import org.scalatest.concurrent.PatienceConfiguration;
import org.scalatest.concurrent.ScaledTimeSpans;
import org.scalatest.enablers.Retrying;
import org.scalatest.funsuite.AnyFunSuiteLike;
import org.scalatest.time.Span;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005I3AAC\u0006\u00015!)Q\u0005\u0001C\u0001M!9\u0011\u0006\u0001b\u0001\n\u0013Q\u0003BB\u0019\u0001A\u0003%1\u0006C\u00043\u0001\t\u0007I\u0011\u0002\u0016\t\rM\u0002\u0001\u0015!\u0003,\u0011\u001d!\u0004A1A\u0005\nUBa\u0001\u0010\u0001!\u0002\u00131\u0004bB\u001f\u0001\u0005\u0004%IA\u0010\u0005\u0007#\u0002\u0001\u000b\u0011B \u00037=\u00138mQ8mk6t\u0017M\u001d\"bi\u000eD'+Z1eKJ\u001cV/\u001b;f\u0015\taQ\"A\u0002pe\u000eT!AD\b\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u0003!E\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005I\u0019\u0012aA:rY*\u0011A#F\u0001\u0006gB\f'o\u001b\u0006\u0003-]\ta!\u00199bG\",'\"\u0001\r\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001Yr\u0004\u0005\u0002\u001d;5\t\u0011#\u0003\u0002\u001f#\tI\u0011+^3ssR+7\u000f\u001e\t\u0003A\rj\u0011!\t\u0006\u0003EE\tA\u0001^3ti&\u0011A%\t\u0002\u0013'\"\f'/\u001a3Ta\u0006\u00148nU3tg&|g.\u0001\u0004=S:LGO\u0010\u000b\u0002OA\u0011\u0001\u0006A\u0007\u0002\u0017\u0005QA-\u0019;b'\u000eDW-\\1\u0016\u0003-\u0002\"\u0001L\u0018\u000e\u00035R!AL\t\u0002\u000bQL\b/Z:\n\u0005Aj#AC*ueV\u001cG\u000fV=qK\u0006YA-\u0019;b'\u000eDW-\\1!\u0003=\u0001\u0018M\u001d;ji&|gnU2iK6\f\u0017\u0001\u00059beRLG/[8o'\u000eDW-\\1!\u0003=\u0001\u0018M\u001d;ji&|gNV1mk\u0016\u001cX#\u0001\u001c\u0011\u0005]RT\"\u0001\u001d\u000b\u0005e\n\u0012\u0001C2bi\u0006d\u0017p\u001d;\n\u0005mB$aC%oi\u0016\u0014h.\u00197S_^\f\u0001\u0003]1si&$\u0018n\u001c8WC2,Xm\u001d\u0011\u0002#=\u00148MR5mKN\u001b\u0007.Z7b\u0019&\u001cH/F\u0001@!\r\u0001u)S\u0007\u0002\u0003*\u0011!iQ\u0001\nS6lW\u000f^1cY\u0016T!\u0001R#\u0002\u0015\r|G\u000e\\3di&|gNC\u0001G\u0003\u0015\u00198-\u00197b\u0013\tA\u0015IA\u0002TKF\u0004\"AS(\u000e\u0003-S!\u0001T'\u0002\t1\fgn\u001a\u0006\u0002\u001d\u0006!!.\u0019<b\u0013\t\u00016J\u0001\u0004TiJLgnZ\u0001\u0013_J\u001cg)\u001b7f'\u000eDW-\\1MSN$\b\u0005")
public class OrcColumnarBatchReaderSuite
extends QueryTest
implements SharedSparkSession {
    private final StructType dataSchema;
    private final StructType partitionSchema;
    private final InternalRow partitionValues;
    private final Seq<String> orcFileSchemaList;
    private boolean enableAutoThreadAudit;
    private TestSparkSession org$apache$spark$sql$test$SharedSparkSessionBase$$_spark;
    private boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    private Function1<String, Dataset<Row>> sql;
    private volatile SQLTestUtilsBase$testImplicits$ testImplicits$module;
    private volatile SQLTestData$internalImplicits$ internalImplicits$module;
    private Dataset<Row> emptyTestData;
    private Dataset<Row> testData;
    private Dataset<Row> testData2;
    private Dataset<Row> testData3;
    private Dataset<Row> negativeData;
    private Dataset<Row> largeAndSmallInts;
    private Dataset<Row> decimalData;
    private Dataset<Row> binaryData;
    private Dataset<Row> upperCaseData;
    private Dataset<Row> lowerCaseData;
    private Dataset<Row> lowerCaseDataWithDuplicates;
    private RDD<SQLTestData.ArrayData> arrayData;
    private RDD<SQLTestData.MapData> mapData;
    private RDD<SQLTestData.IntervalData> calendarIntervalData;
    private RDD<SQLTestData.StringData> repeatedData;
    private RDD<SQLTestData.StringData> nullableRepeatedData;
    private Dataset<Row> nullInts;
    private Dataset<Row> allNulls;
    private Dataset<Row> nullStrings;
    private Dataset<Row> tableName;
    private RDD<String> unparsedStrings;
    private RDD<SQLTestData.IntField> withEmptyParts;
    private Dataset<Row> person;
    private Dataset<Row> salary;
    private Dataset<Row> complexData;
    private Dataset<Row> courseSales;
    private Dataset<Row> trainingSales;
    private Dataset<Row> intervalData;
    private AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    private volatile AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig$module;
    private volatile int bitmap$0;

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$beforeAll() {
        SharedSparkSessionBase.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$afterAll() {
        SharedSparkSessionBase.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        SharedSparkSession.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        SharedSparkSession.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$beforeAll() {
        SQLTestUtils.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    @Override
    public SparkConf sparkConf() {
        return SharedSparkSessionBase.sparkConf$(this);
    }

    @Override
    public SparkSession spark() {
        return SharedSparkSessionBase.spark$(this);
    }

    @Override
    public SQLContext sqlContext() {
        return SharedSparkSessionBase.sqlContext$(this);
    }

    @Override
    public TestSparkSession createSparkSession() {
        return SharedSparkSessionBase.createSparkSession$(this);
    }

    @Override
    public void initializeSession() {
        SharedSparkSessionBase.initializeSession$(this);
    }

    @Override
    public void beforeEach() {
        SharedSparkSessionBase.beforeEach$(this);
    }

    @Override
    public void afterEach() {
        SharedSparkSessionBase.afterEach$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$withTempDir(Function1 f) {
        super.withTempDir(f);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$test(String testName, Seq testTags, Function0 testFun, Position pos) {
        AnyFunSuiteLike.test$((AnyFunSuiteLike)this, (String)testName, (Seq)testTags, (Function0)testFun, (Position)pos);
    }

    @Override
    public void withTempDir(Function1<File, BoxedUnit> f) {
        SQLTestUtils.withTempDir$(this, f);
    }

    @Override
    public void testWithWholeStageCodegenOnAndOff(String testName, Function1<String, BoxedUnit> f) {
        SQLTestUtils.testWithWholeStageCodegenOnAndOff$(this, testName, f);
    }

    @Override
    public void setupTestData() {
        SQLTestUtils.setupTestData$(this);
    }

    @Override
    public void testQuietly(String name, Function0<BoxedUnit> f) {
        SQLTestUtils.testQuietly$(this, name, f);
    }

    @Override
    public void test(String testName, Seq<Tag> testTags, Function0<Object> testFun, Position pos) {
        SQLTestUtils.test$(this, testName, testTags, testFun, pos);
    }

    @Override
    public void testWithUninterruptibleThread(String name, boolean quietly, Function0<BoxedUnit> body) {
        SQLTestUtils.testWithUninterruptibleThread$(this, name, quietly, body);
    }

    @Override
    public boolean testWithUninterruptibleThread$default$2() {
        return SQLTestUtils.testWithUninterruptibleThread$default$2$(this);
    }

    @Override
    public void withResourceTempPath(String resourcePath, Function1<File, BoxedUnit> f) {
        SQLTestUtils.withResourceTempPath$(this, resourcePath, f);
    }

    @Override
    public void waitForTasksToFinish() {
        SQLTestUtils.waitForTasksToFinish$(this);
    }

    @Override
    public void withTempPaths(int numPaths, Function1<Seq<File>, BoxedUnit> f) {
        SQLTestUtils.withTempPaths$(this, numPaths, f);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtilsBase$$super$withSQLConf(Seq pairs, Function0 f) {
        SQLHelper.withSQLConf$((SQLHelper)this, (Seq)pairs, (Function0)f);
    }

    @Override
    public SparkContext sparkContext() {
        return SQLTestUtilsBase.sparkContext$(this);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withUserDefinedFunction(Seq<Tuple2<String, Object>> functions2, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withUserDefinedFunction$(this, functions2, f);
    }

    @Override
    public void withTempView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withTempView$(this, viewNames, f);
    }

    @Override
    public void withGlobalTempView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withGlobalTempView$(this, viewNames, f);
    }

    @Override
    public void withTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withTable$(this, tableNames, f);
    }

    @Override
    public void withView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withView$(this, viewNames, f);
    }

    @Override
    public void withCache(Seq<String> cacheNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withCache$(this, cacheNames, f);
    }

    @Override
    public void uncacheTable(String tableName) {
        SQLTestUtilsBase.uncacheTable$(this, tableName);
    }

    @Override
    public void withTempDatabase(Function1<String, BoxedUnit> f) {
        SQLTestUtilsBase.withTempDatabase$(this, f);
    }

    @Override
    public void withDatabase(Seq<String> dbNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withDatabase$(this, dbNames, f);
    }

    @Override
    public void withNamespace(Seq<String> namespaces, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withNamespace$(this, namespaces, f);
    }

    @Override
    public void withLocale(String language, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withLocale$(this, language, f);
    }

    @Override
    public void activateDatabase(String db, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.activateDatabase$(this, db, f);
    }

    @Override
    public Dataset<Row> stripSparkFilter(Dataset<Row> df) {
        return SQLTestUtilsBase.stripSparkFilter$(this, df);
    }

    @Override
    public Dataset<Row> logicalPlanToSparkQuery(LogicalPlan plan) {
        return SQLTestUtilsBase.logicalPlanToSparkQuery$(this, plan);
    }

    @Override
    public URI makeQualifiedPath(String path) {
        return SQLTestUtilsBase.makeQualifiedPath$(this, path);
    }

    @Override
    public String testFile(String fileName) {
        return SQLTestUtilsBase.testFile$(this, fileName);
    }

    @Override
    public long getLocalDirSize(File file) {
        return SQLTestUtilsBase.getLocalDirSize$(this, file);
    }

    @Override
    public void loadTestData() {
        SQLTestData.loadTestData$(this);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, PatienceConfiguration.Interval interval, Function0<T> fun, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, (PatienceConfiguration.Interval)interval, fun, retrying, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Interval interval, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Interval)interval, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public <T> T eventually(Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public AbstractPatienceConfiguration.PatienceConfig patienceConfig() {
        return PatienceConfiguration.patienceConfig$((PatienceConfiguration)this);
    }

    public PatienceConfiguration.Timeout timeout(Span value) {
        return PatienceConfiguration.timeout$((PatienceConfiguration)this, (Span)value);
    }

    public PatienceConfiguration.Interval interval(Span value) {
        return PatienceConfiguration.interval$((PatienceConfiguration)this, (Span)value);
    }

    public final Span scaled(Span span) {
        return ScaledTimeSpans.scaled$((ScaledTimeSpans)this, (Span)span);
    }

    public double spanScaleFactor() {
        return ScaledTimeSpans.spanScaleFactor$((ScaledTimeSpans)this);
    }

    @Override
    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSparkSession$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    @Override
    public TestSparkSession org$apache$spark$sql$test$SharedSparkSessionBase$$_spark() {
        return this.org$apache$spark$sql$test$SharedSparkSessionBase$$_spark;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSparkSessionBase$$_spark_$eq(TestSparkSession x$1) {
        this.org$apache$spark$sql$test$SharedSparkSessionBase$$_spark = x$1;
    }

    @Override
    public boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests() {
        return this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    }

    @Override
    public void org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests_$eq(boolean x$1) {
        this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests = x$1;
    }

    private Function1<String, Dataset<Row>> sql$lzycompute() {
        OrcColumnarBatchReaderSuite orcColumnarBatchReaderSuite = this;
        synchronized (orcColumnarBatchReaderSuite) {
            if ((this.bitmap$0 & 1) == 0) {
                this.sql = SQLTestUtilsBase.sql$(this);
                this.bitmap$0 |= 1;
            }
        }
        return this.sql;
    }

    @Override
    public Function1<String, Dataset<Row>> sql() {
        return (this.bitmap$0 & 1) == 0 ? this.sql$lzycompute() : this.sql;
    }

    @Override
    public SQLTestUtilsBase$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public SQLTestData$internalImplicits$ org$apache$spark$sql$test$SQLTestData$$internalImplicits() {
        if (this.internalImplicits$module == null) {
            this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute$1();
        }
        return this.internalImplicits$module;
    }

    private Dataset<Row> emptyTestData$lzycompute() {
        OrcColumnarBatchReaderSuite orcColumnarBatchReaderSuite = this;
        synchronized (orcColumnarBatchReaderSuite) {
            if ((this.bitmap$0 & 2) == 0) {
                this.emptyTestData = SQLTestData.emptyTestData$(this);
                this.bitmap$0 |= 2;
            }
        }
        return this.emptyTestData;
    }

    @Override
    public Dataset<Row> emptyTestData() {
        return (this.bitmap$0 & 2) == 0 ? this.emptyTestData$lzycompute() : this.emptyTestData;
    }

    private Dataset<Row> testData$lzycompute() {
        OrcColumnarBatchReaderSuite orcColumnarBatchReaderSuite = this;
        synchronized (orcColumnarBatchReaderSuite) {
            if ((this.bitmap$0 & 4) == 0) {
                this.testData = SQLTestData.testData$(this);
                this.bitmap$0 |= 4;
            }
        }
        return this.testData;
    }

    @Override
    public Dataset<Row> testData() {
        return (this.bitmap$0 & 4) == 0 ? this.testData$lzycompute() : this.testData;
    }

    private Dataset<Row> testData2$lzycompute() {
        OrcColumnarBatchReaderSuite orcColumnarBatchReaderSuite = this;
        synchronized (orcColumnarBatchReaderSuite) {
            if ((this.bitmap$0 & 8) == 0) {
                this.testData2 = SQLTestData.testData2$(this);
                this.bitmap$0 |= 8;
            }
        }
        return this.testData2;
    }

    @Override
    public Dataset<Row> testData2() {
        return (this.bitmap$0 & 8) == 0 ? this.testData2$lzycompute() : this.testData2;
    }

    private Dataset<Row> testData3$lzycompute() {
        OrcColumnarBatchReaderSuite orcColumnarBatchReaderSuite = this;
        synchronized (orcColumnarBatchReaderSuite) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.testData3 = SQLTestData.testData3$(this);
                this.bitmap$0 |= 0x10;
            }
        }
        return this.testData3;
    }

    @Override
    public Dataset<Row> testData3() {
        return (this.bitmap$0 & 0x10) == 0 ? this.testData3$lzycompute() : this.testData3;
    }

    private Dataset<Row> negativeData$lzycompute() {
        OrcColumnarBatchReaderSuite orcColumnarBatchReaderSuite = this;
        synchronized (orcColumnarBatchReaderSuite) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.negativeData = SQLTestData.negativeData$(this);
                this.bitmap$0 |= 0x20;
            }
        }
        return this.negativeData;
    }

    @Override
    public Dataset<Row> negativeData() {
        return (this.bitmap$0 & 0x20) == 0 ? this.negativeData$lzycompute() : this.negativeData;
    }

    private Dataset<Row> largeAndSmallInts$lzycompute() {
        OrcColumnarBatchReaderSuite orcColumnarBatchReaderSuite = this;
        synchronized (orcColumnarBatchReaderSuite) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.largeAndSmallInts = SQLTestData.largeAndSmallInts$(this);
                this.bitmap$0 |= 0x40;
            }
        }
        return this.largeAndSmallInts;
    }

    @Override
    public Dataset<Row> largeAndSmallInts() {
        return (this.bitmap$0 & 0x40) == 0 ? this.largeAndSmallInts$lzycompute() : this.largeAndSmallInts;
    }

    private Dataset<Row> decimalData$lzycompute() {
        OrcColumnarBatchReaderSuite orcColumnarBatchReaderSuite = this;
        synchronized (orcColumnarBatchReaderSuite) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.decimalData = SQLTestData.decimalData$(this);
                this.bitmap$0 |= 0x80;
            }
        }
        return this.decimalData;
    }

    @Override
    public Dataset<Row> decimalData() {
        return (this.bitmap$0 & 0x80) == 0 ? this.decimalData$lzycompute() : this.decimalData;
    }

    private Dataset<Row> binaryData$lzycompute() {
        OrcColumnarBatchReaderSuite orcColumnarBatchReaderSuite = this;
        synchronized (orcColumnarBatchReaderSuite) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.binaryData = SQLTestData.binaryData$(this);
                this.bitmap$0 |= 0x100;
            }
        }
        return this.binaryData;
    }

    @Override
    public Dataset<Row> binaryData() {
        return (this.bitmap$0 & 0x100) == 0 ? this.binaryData$lzycompute() : this.binaryData;
    }

    private Dataset<Row> upperCaseData$lzycompute() {
        OrcColumnarBatchReaderSuite orcColumnarBatchReaderSuite = this;
        synchronized (orcColumnarBatchReaderSuite) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.upperCaseData = SQLTestData.upperCaseData$(this);
                this.bitmap$0 |= 0x200;
            }
        }
        return this.upperCaseData;
    }

    @Override
    public Dataset<Row> upperCaseData() {
        return (this.bitmap$0 & 0x200) == 0 ? this.upperCaseData$lzycompute() : this.upperCaseData;
    }

    private Dataset<Row> lowerCaseData$lzycompute() {
        OrcColumnarBatchReaderSuite orcColumnarBatchReaderSuite = this;
        synchronized (orcColumnarBatchReaderSuite) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.lowerCaseData = SQLTestData.lowerCaseData$(this);
                this.bitmap$0 |= 0x400;
            }
        }
        return this.lowerCaseData;
    }

    @Override
    public Dataset<Row> lowerCaseData() {
        return (this.bitmap$0 & 0x400) == 0 ? this.lowerCaseData$lzycompute() : this.lowerCaseData;
    }

    private Dataset<Row> lowerCaseDataWithDuplicates$lzycompute() {
        OrcColumnarBatchReaderSuite orcColumnarBatchReaderSuite = this;
        synchronized (orcColumnarBatchReaderSuite) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.lowerCaseDataWithDuplicates = SQLTestData.lowerCaseDataWithDuplicates$(this);
                this.bitmap$0 |= 0x800;
            }
        }
        return this.lowerCaseDataWithDuplicates;
    }

    @Override
    public Dataset<Row> lowerCaseDataWithDuplicates() {
        return (this.bitmap$0 & 0x800) == 0 ? this.lowerCaseDataWithDuplicates$lzycompute() : this.lowerCaseDataWithDuplicates;
    }

    private RDD<SQLTestData.ArrayData> arrayData$lzycompute() {
        OrcColumnarBatchReaderSuite orcColumnarBatchReaderSuite = this;
        synchronized (orcColumnarBatchReaderSuite) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.arrayData = SQLTestData.arrayData$(this);
                this.bitmap$0 |= 0x1000;
            }
        }
        return this.arrayData;
    }

    @Override
    public RDD<SQLTestData.ArrayData> arrayData() {
        return (this.bitmap$0 & 0x1000) == 0 ? this.arrayData$lzycompute() : this.arrayData;
    }

    private RDD<SQLTestData.MapData> mapData$lzycompute() {
        OrcColumnarBatchReaderSuite orcColumnarBatchReaderSuite = this;
        synchronized (orcColumnarBatchReaderSuite) {
            if ((this.bitmap$0 & 0x2000) == 0) {
                this.mapData = SQLTestData.mapData$(this);
                this.bitmap$0 |= 0x2000;
            }
        }
        return this.mapData;
    }

    @Override
    public RDD<SQLTestData.MapData> mapData() {
        return (this.bitmap$0 & 0x2000) == 0 ? this.mapData$lzycompute() : this.mapData;
    }

    private RDD<SQLTestData.IntervalData> calendarIntervalData$lzycompute() {
        OrcColumnarBatchReaderSuite orcColumnarBatchReaderSuite = this;
        synchronized (orcColumnarBatchReaderSuite) {
            if ((this.bitmap$0 & 0x4000) == 0) {
                this.calendarIntervalData = SQLTestData.calendarIntervalData$(this);
                this.bitmap$0 |= 0x4000;
            }
        }
        return this.calendarIntervalData;
    }

    @Override
    public RDD<SQLTestData.IntervalData> calendarIntervalData() {
        return (this.bitmap$0 & 0x4000) == 0 ? this.calendarIntervalData$lzycompute() : this.calendarIntervalData;
    }

    private RDD<SQLTestData.StringData> repeatedData$lzycompute() {
        OrcColumnarBatchReaderSuite orcColumnarBatchReaderSuite = this;
        synchronized (orcColumnarBatchReaderSuite) {
            if ((this.bitmap$0 & 0x8000) == 0) {
                this.repeatedData = SQLTestData.repeatedData$(this);
                this.bitmap$0 |= 0x8000;
            }
        }
        return this.repeatedData;
    }

    @Override
    public RDD<SQLTestData.StringData> repeatedData() {
        return (this.bitmap$0 & 0x8000) == 0 ? this.repeatedData$lzycompute() : this.repeatedData;
    }

    private RDD<SQLTestData.StringData> nullableRepeatedData$lzycompute() {
        OrcColumnarBatchReaderSuite orcColumnarBatchReaderSuite = this;
        synchronized (orcColumnarBatchReaderSuite) {
            if ((this.bitmap$0 & 0x10000) == 0) {
                this.nullableRepeatedData = SQLTestData.nullableRepeatedData$(this);
                this.bitmap$0 |= 0x10000;
            }
        }
        return this.nullableRepeatedData;
    }

    @Override
    public RDD<SQLTestData.StringData> nullableRepeatedData() {
        return (this.bitmap$0 & 0x10000) == 0 ? this.nullableRepeatedData$lzycompute() : this.nullableRepeatedData;
    }

    private Dataset<Row> nullInts$lzycompute() {
        OrcColumnarBatchReaderSuite orcColumnarBatchReaderSuite = this;
        synchronized (orcColumnarBatchReaderSuite) {
            if ((this.bitmap$0 & 0x20000) == 0) {
                this.nullInts = SQLTestData.nullInts$(this);
                this.bitmap$0 |= 0x20000;
            }
        }
        return this.nullInts;
    }

    @Override
    public Dataset<Row> nullInts() {
        return (this.bitmap$0 & 0x20000) == 0 ? this.nullInts$lzycompute() : this.nullInts;
    }

    private Dataset<Row> allNulls$lzycompute() {
        OrcColumnarBatchReaderSuite orcColumnarBatchReaderSuite = this;
        synchronized (orcColumnarBatchReaderSuite) {
            if ((this.bitmap$0 & 0x40000) == 0) {
                this.allNulls = SQLTestData.allNulls$(this);
                this.bitmap$0 |= 0x40000;
            }
        }
        return this.allNulls;
    }

    @Override
    public Dataset<Row> allNulls() {
        return (this.bitmap$0 & 0x40000) == 0 ? this.allNulls$lzycompute() : this.allNulls;
    }

    private Dataset<Row> nullStrings$lzycompute() {
        OrcColumnarBatchReaderSuite orcColumnarBatchReaderSuite = this;
        synchronized (orcColumnarBatchReaderSuite) {
            if ((this.bitmap$0 & 0x80000) == 0) {
                this.nullStrings = SQLTestData.nullStrings$(this);
                this.bitmap$0 |= 0x80000;
            }
        }
        return this.nullStrings;
    }

    @Override
    public Dataset<Row> nullStrings() {
        return (this.bitmap$0 & 0x80000) == 0 ? this.nullStrings$lzycompute() : this.nullStrings;
    }

    private Dataset<Row> tableName$lzycompute() {
        OrcColumnarBatchReaderSuite orcColumnarBatchReaderSuite = this;
        synchronized (orcColumnarBatchReaderSuite) {
            if ((this.bitmap$0 & 0x100000) == 0) {
                this.tableName = SQLTestData.tableName$(this);
                this.bitmap$0 |= 0x100000;
            }
        }
        return this.tableName;
    }

    @Override
    public Dataset<Row> tableName() {
        return (this.bitmap$0 & 0x100000) == 0 ? this.tableName$lzycompute() : this.tableName;
    }

    private RDD<String> unparsedStrings$lzycompute() {
        OrcColumnarBatchReaderSuite orcColumnarBatchReaderSuite = this;
        synchronized (orcColumnarBatchReaderSuite) {
            if ((this.bitmap$0 & 0x200000) == 0) {
                this.unparsedStrings = SQLTestData.unparsedStrings$(this);
                this.bitmap$0 |= 0x200000;
            }
        }
        return this.unparsedStrings;
    }

    @Override
    public RDD<String> unparsedStrings() {
        return (this.bitmap$0 & 0x200000) == 0 ? this.unparsedStrings$lzycompute() : this.unparsedStrings;
    }

    private RDD<SQLTestData.IntField> withEmptyParts$lzycompute() {
        OrcColumnarBatchReaderSuite orcColumnarBatchReaderSuite = this;
        synchronized (orcColumnarBatchReaderSuite) {
            if ((this.bitmap$0 & 0x400000) == 0) {
                this.withEmptyParts = SQLTestData.withEmptyParts$(this);
                this.bitmap$0 |= 0x400000;
            }
        }
        return this.withEmptyParts;
    }

    @Override
    public RDD<SQLTestData.IntField> withEmptyParts() {
        return (this.bitmap$0 & 0x400000) == 0 ? this.withEmptyParts$lzycompute() : this.withEmptyParts;
    }

    private Dataset<Row> person$lzycompute() {
        OrcColumnarBatchReaderSuite orcColumnarBatchReaderSuite = this;
        synchronized (orcColumnarBatchReaderSuite) {
            if ((this.bitmap$0 & 0x800000) == 0) {
                this.person = SQLTestData.person$(this);
                this.bitmap$0 |= 0x800000;
            }
        }
        return this.person;
    }

    @Override
    public Dataset<Row> person() {
        return (this.bitmap$0 & 0x800000) == 0 ? this.person$lzycompute() : this.person;
    }

    private Dataset<Row> salary$lzycompute() {
        OrcColumnarBatchReaderSuite orcColumnarBatchReaderSuite = this;
        synchronized (orcColumnarBatchReaderSuite) {
            if ((this.bitmap$0 & 0x1000000) == 0) {
                this.salary = SQLTestData.salary$(this);
                this.bitmap$0 |= 0x1000000;
            }
        }
        return this.salary;
    }

    @Override
    public Dataset<Row> salary() {
        return (this.bitmap$0 & 0x1000000) == 0 ? this.salary$lzycompute() : this.salary;
    }

    private Dataset<Row> complexData$lzycompute() {
        OrcColumnarBatchReaderSuite orcColumnarBatchReaderSuite = this;
        synchronized (orcColumnarBatchReaderSuite) {
            if ((this.bitmap$0 & 0x2000000) == 0) {
                this.complexData = SQLTestData.complexData$(this);
                this.bitmap$0 |= 0x2000000;
            }
        }
        return this.complexData;
    }

    @Override
    public Dataset<Row> complexData() {
        return (this.bitmap$0 & 0x2000000) == 0 ? this.complexData$lzycompute() : this.complexData;
    }

    private Dataset<Row> courseSales$lzycompute() {
        OrcColumnarBatchReaderSuite orcColumnarBatchReaderSuite = this;
        synchronized (orcColumnarBatchReaderSuite) {
            if ((this.bitmap$0 & 0x4000000) == 0) {
                this.courseSales = SQLTestData.courseSales$(this);
                this.bitmap$0 |= 0x4000000;
            }
        }
        return this.courseSales;
    }

    @Override
    public Dataset<Row> courseSales() {
        return (this.bitmap$0 & 0x4000000) == 0 ? this.courseSales$lzycompute() : this.courseSales;
    }

    private Dataset<Row> trainingSales$lzycompute() {
        OrcColumnarBatchReaderSuite orcColumnarBatchReaderSuite = this;
        synchronized (orcColumnarBatchReaderSuite) {
            if ((this.bitmap$0 & 0x8000000) == 0) {
                this.trainingSales = SQLTestData.trainingSales$(this);
                this.bitmap$0 |= 0x8000000;
            }
        }
        return this.trainingSales;
    }

    @Override
    public Dataset<Row> trainingSales() {
        return (this.bitmap$0 & 0x8000000) == 0 ? this.trainingSales$lzycompute() : this.trainingSales;
    }

    private Dataset<Row> intervalData$lzycompute() {
        OrcColumnarBatchReaderSuite orcColumnarBatchReaderSuite = this;
        synchronized (orcColumnarBatchReaderSuite) {
            if ((this.bitmap$0 & 0x10000000) == 0) {
                this.intervalData = SQLTestData.intervalData$(this);
                this.bitmap$0 |= 0x10000000;
            }
        }
        return this.intervalData;
    }

    @Override
    public Dataset<Row> intervalData() {
        return (this.bitmap$0 & 0x10000000) == 0 ? this.intervalData$lzycompute() : this.intervalData;
    }

    public AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig() {
        return this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    }

    public final void org$scalatest$concurrent$PatienceConfiguration$_setter_$org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig_$eq(AbstractPatienceConfiguration.PatienceConfig x$1) {
        this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig = x$1;
    }

    public AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig() {
        if (this.PatienceConfig$module == null) {
            this.PatienceConfig$lzycompute$1();
        }
        return this.PatienceConfig$module;
    }

    private StructType dataSchema() {
        return this.dataSchema;
    }

    private StructType partitionSchema() {
        return this.partitionSchema;
    }

    private InternalRow partitionValues() {
        return this.partitionValues;
    }

    private Seq<String> orcFileSchemaList() {
        return this.orcFileSchemaList;
    }

    private final void testImplicits$lzycompute$1() {
        OrcColumnarBatchReaderSuite orcColumnarBatchReaderSuite = this;
        synchronized (orcColumnarBatchReaderSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new SQLTestUtilsBase$testImplicits$(this);
            }
        }
    }

    private final void org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute$1() {
        OrcColumnarBatchReaderSuite orcColumnarBatchReaderSuite = this;
        synchronized (orcColumnarBatchReaderSuite) {
            if (this.internalImplicits$module == null) {
                this.internalImplicits$module = new SQLTestData$internalImplicits$(this);
            }
        }
    }

    private final void PatienceConfig$lzycompute$1() {
        OrcColumnarBatchReaderSuite orcColumnarBatchReaderSuite = this;
        synchronized (orcColumnarBatchReaderSuite) {
            if (this.PatienceConfig$module == null) {
                this.PatienceConfig$module = new AbstractPatienceConfiguration$PatienceConfig$((AbstractPatienceConfiguration)this);
            }
        }
    }

    private final OrcColumnarBatchReader getReader$1(int[] requestedDataColIds, int[] requestedPartitionColIds, StructField[] resultFields, TypeDescription orcFileSchema$1) {
        OrcColumnarBatchReader reader = new OrcColumnarBatchReader(4096);
        reader.initBatch(orcFileSchema$1, resultFields, requestedDataColIds, requestedPartitionColIds, this.partitionValues());
        return reader;
    }

    public static final /* synthetic */ void $anonfun$new$1(OrcColumnarBatchReaderSuite $this, String x0$1) {
        String string = x0$1;
        TypeDescription orcFileSchema = TypeDescription.fromString((String)string);
        Field isConstant = WritableColumnVector.class.getDeclaredField("isConstant");
        isConstant.setAccessible(true);
        $this.test(new StringBuilder(30).append("all partitions are requested: ").append(string).toString(), (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            int[] requestedDataColIds = new int[]{0, 1, 0, 0};
            int[] requestedPartitionColIds = new int[]{-1, -1, 0, 1};
            OrcColumnarBatchReader reader = $this.getReader$1(requestedDataColIds, requestedPartitionColIds, (StructField[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])$this.dataSchema().fields()), (Object)$this.partitionSchema().fields(), ClassTag$.MODULE$.apply(StructField.class)), orcFileSchema);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(reader.requestedDataColIds);
            int[] $org_scalatest_assert_macro_right = new int[]{0, 1, -1, -1};
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcColumnarBatchReaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
        }, new Position("OrcColumnarBatchReaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        $this.test(new StringBuilder(62).append("initBatch should initialize requested partition columns only: ").append(string).toString(), (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            int[] requestedDataColIds = new int[]{0, -1};
            int[] requestedPartitionColIds = new int[]{-1, 0};
            OrcColumnarBatchReader reader = $this.getReader$1(requestedDataColIds, requestedPartitionColIds, (StructField[])((Object[])new StructField[]{$this.dataSchema().fields()[0], $this.partitionSchema().fields()[0]}), orcFileSchema);
            ColumnarBatch batch = reader.columnarBatch;
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)batch.numCols()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcColumnarBatchReaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
            ColumnVector $org_scalatest_assert_macro_left2 = batch.column(0);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.execution.datasources.orc.OrcColumnVector", $org_scalatest_assert_macro_left2 instanceof OrcColumnVector, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcColumnarBatchReaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
            ColumnVector $org_scalatest_assert_macro_left3 = batch.column(1);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.execution.vectorized.OnHeapColumnVector", $org_scalatest_assert_macro_left3 instanceof OnHeapColumnVector, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcColumnarBatchReaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
            OnHeapColumnVector p1 = (OnHeapColumnVector)batch.column(1);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(BoxesRunTime.unboxToBoolean((Object)isConstant.get(p1)), "isConstant.get(p1).asInstanceOf[Boolean]", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcColumnarBatchReaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(p1.getUTF8String(0));
            UTF8String $org_scalatest_assert_macro_right2 = $this.partitionValues().getUTF8String(0);
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcColumnarBatchReaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        }, new Position("OrcColumnarBatchReaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$5(OrcColumnarBatchReaderSuite $this, File dir) {
        $this.testImplicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), $this.testImplicits().newIntEncoder()).toDF().repartition(1).write().orc(dir.getCanonicalPath());
        Seq dataTypes = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, BooleanType$.MODULE$, ByteType$.MODULE$, BinaryType$.MODULE$, ShortType$.MODULE$, IntegerType$.MODULE$, LongType$.MODULE$, FloatType$.MODULE$, DoubleType$.MODULE$, new DecimalType(25, 5), DateType$.MODULE$, TimestampType$.MODULE$}));
        Seq constantValues = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{UTF8String.fromString((String)"a string"), BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToByte((byte)((byte)1)), "Spark SQL".getBytes(), BoxesRunTime.boxToShort((short)((short)2)), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToLong((long)Long.MAX_VALUE), BoxesRunTime.boxToFloat((float)((float)0.25)), BoxesRunTime.boxToDouble((double)0.75), Decimal$.MODULE$.apply("1234.23456"), BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.fromJavaDate(Date.valueOf("2015-01-01"))), BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.fromJavaTimestamp(Timestamp.valueOf("2015-01-01 23:50:59.123")))}));
        ((IterableOnceOps)dataTypes.zip((IterableOnce)constantValues)).foreach((Function1 & Serializable)x0$2 -> {
            Assertion assertion;
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                AtomicType dt = (AtomicType)tuple2._1();
                Object v = tuple2._2();
                StructField structField = new StructField("col1", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                StructField structField2 = new StructField("pcol", (DataType)dt, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                StructType schema = StructType$.MODULE$.apply((Seq)package$.MODULE$.Nil().$colon$colon((Object)structField2).$colon$colon((Object)structField));
                GenericInternalRow partitionValues = new GenericInternalRow(new Object[]{v});
                File file = new File((String)SpecificParquetRecordReaderBase.listDirectory((File)dir).get(0));
                FileSplit fileSplit = new FileSplit(new Path(file.getCanonicalPath()), 0L, file.length(), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
                Configuration taskConf = $this.sqlContext().sessionState().newHadoopConf();
                TypeDescription orcFileSchema = TypeDescription.fromString((String)schema.simpleString());
                OrcColumnarBatchReader vectorizedReader = new OrcColumnarBatchReader(4096);
                TaskAttemptID attemptId = new TaskAttemptID(new TaskID(new JobID(), TaskType.MAP, 0), 0);
                TaskAttemptContextImpl taskAttemptContext = new TaskAttemptContextImpl(taskConf, attemptId);
                try {
                    Object $org_scalatest_assert_macro_right;
                    Object $org_scalatest_assert_macro_left;
                    vectorizedReader.initialize((InputSplit)fileSplit, (TaskAttemptContext)taskAttemptContext);
                    vectorizedReader.initBatch(orcFileSchema, (StructField[])schema.toArray(ClassTag$.MODULE$.apply(StructField.class)), new int[]{0, -1}, new int[]{-1, 0}, (InternalRow)partitionValues);
                    vectorizedReader.nextKeyValue();
                    InternalRow row = vectorizedReader.getCurrentValue().getRow(0);
                    Object actual = row.copy().get(1, (DataType)dt);
                    Object expected = v;
                    if (dt instanceof BinaryType) {
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.wrapByteArray((byte[])actual).sameElements((IterableOnce)Predef$.MODULE$.wrapByteArray((byte[])expected)), "scala.Predef.wrapByteArray(actual.asInstanceOf[Array[Byte]]).sameElements[Byte](scala.Predef.wrapByteArray(expected.asInstanceOf[Array[Byte]]))", Prettifier$.MODULE$.default());
                        assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcColumnarBatchReaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
                    }
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", $org_scalatest_assert_macro_right, BoxesRunTime.equals((Object)($org_scalatest_assert_macro_left = actual), (Object)($org_scalatest_assert_macro_right = expected)), Prettifier$.MODULE$.default());
                    assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcColumnarBatchReaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
                }
                finally {
                    vectorizedReader.close();
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Assertion assertion2 = assertion;
            return assertion2;
        });
    }

    public OrcColumnarBatchReaderSuite() {
        ScaledTimeSpans.$init$((ScaledTimeSpans)this);
        AbstractPatienceConfiguration.$init$((AbstractPatienceConfiguration)this);
        PatienceConfiguration.$init$((PatienceConfiguration)this);
        Eventually.$init$((Eventually)this);
        SQLTestData.$init$(this);
        SQLTestUtilsBase.$init$(this);
        SQLTestUtils.$init$(this);
        SharedSparkSessionBase.$init$(this);
        SharedSparkSession.$init$(this);
        this.dataSchema = StructType$.MODULE$.fromDDL("col1 int, col2 int");
        this.partitionSchema = StructType$.MODULE$.fromDDL("p1 string, p2 string");
        this.partitionValues = InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{UTF8String.fromString((String)"partValue1"), UTF8String.fromString((String)"partValue2")}));
        this.orcFileSchemaList = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"struct<col1:int,col2:int>", "struct<col1:int,col2:int,p1:string,p2:string>", "struct<col1:int,col2:int,p1:string>", "struct<col1:int,col2:int,p2:string>"}));
        this.orcFileSchemaList().foreach((Function1 & Serializable)x0$1 -> {
            OrcColumnarBatchReaderSuite.$anonfun$new$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
        this.test("SPARK-33593: partition column types", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            OrcColumnarBatchReaderSuite.$anonfun$new$5(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("OrcColumnarBatchReaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
        Statics.releaseFence();
    }
}

