/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.orc;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.orc.OrcConf;
import org.apache.orc.OrcFile;
import org.apache.orc.mapred.OrcStruct;
import org.apache.orc.mapreduce.OrcInputFormat;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.execution.datasources.RecordReaderIterator;
import org.apache.spark.sql.execution.datasources.orc.AllDataTypesWithNonPrimitiveType;
import org.apache.spark.sql.execution.datasources.orc.BinaryData;
import org.apache.spark.sql.execution.datasources.orc.Contact;
import org.apache.spark.sql.execution.datasources.orc.OrcQueryTest$;
import org.apache.spark.sql.execution.datasources.orc.OrcTest;
import org.apache.spark.sql.execution.datasources.orc.Person;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TestUDT;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Symbol;
import scala.Tuple1;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple5;
import scala.Tuple8;
import scala.collection.ArrayOps$;
import scala.collection.IndexedSeqOps;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.math.BigDecimal;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005i1QAA\u0002\u0002\u0002IAQa\u0006\u0001\u0005\u0002a\u0011Ab\u0014:d#V,'/\u001f+fgRT!\u0001B\u0003\u0002\u0007=\u00148M\u0003\u0002\u0007\u000f\u0005YA-\u0019;bg>,(oY3t\u0015\tA\u0011\"A\u0005fq\u0016\u001cW\u000f^5p]*\u0011!bC\u0001\u0004gFd'B\u0001\u0007\u000e\u0003\u0015\u0019\b/\u0019:l\u0015\tqq\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002!\u0005\u0019qN]4\u0004\u0001M\u0011\u0001a\u0005\t\u0003)Ui\u0011aA\u0005\u0003-\r\u0011qa\u0014:d)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u00023A\u0011A\u0003\u0001")
public abstract class OrcQueryTest
extends OrcTest {
    public static final /* synthetic */ Tuple8 $anonfun$new$2(int i) {
        return new Tuple8((Object)String.valueOf(BoxesRunTime.boxToInteger((int)i)), (Object)BoxesRunTime.boxToInteger((int)i), (Object)BoxesRunTime.boxToLong((long)i), (Object)BoxesRunTime.boxToFloat((float)i), (Object)BoxesRunTime.boxToDouble((double)i), (Object)BoxesRunTime.boxToShort((short)((short)i)), (Object)BoxesRunTime.boxToByte((byte)((byte)i)), (Object)BoxesRunTime.boxToBoolean((i % 2 == 0 ? 1 : 0) != 0));
    }

    public static final /* synthetic */ void $anonfun$new$3(OrcQueryTest $this, IndexedSeq data$1, String file) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OrcQueryTest.class.getClassLoader());
        public final class Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator10$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple8"), (List)List$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), $m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("scala.Long").asType().toTypeConstructor(), $m.staticClass("scala.Float").asType().toTypeConstructor(), $m.staticClass("scala.Double").asType().toTypeConstructor(), $m.staticClass("scala.Short").asType().toTypeConstructor(), $m.staticClass("scala.Byte").asType().toTypeConstructor(), $m.staticClass("scala.Boolean").asType().toTypeConstructor()})));
            }

            public Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator10$1(OrcQueryTest $outer) {
            }
        }
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().read().orc(file), (scala.collection.immutable.Seq<Row>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq($this.testImplicits().localSeqToDatasetHolder((scala.collection.immutable.Seq)data$1, $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator10$1(null)))).toDF().collect()));
    }

    public static final /* synthetic */ void $anonfun$new$6(OrcQueryTest $this, String file) {
        byte[] bytes = (byte[])((Row)$this.spark().read().orc(file).head()).getAs(0);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(new String(bytes, StandardCharsets.UTF_8));
        String $org_scalatest_assert_macro_right = "test";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
    }

    public static final /* synthetic */ Option $anonfun$new$9(int x$1) {
        return Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)x$1)).filter((Function1)(JFunction1.mcZI.sp & Serializable)x$2 -> x$2 % 3 == 0);
    }

    public static final /* synthetic */ AllDataTypesWithNonPrimitiveType $anonfun$new$8(int i2) {
        return new AllDataTypesWithNonPrimitiveType(String.valueOf(BoxesRunTime.boxToInteger((int)i2)), i2, i2, i2, i2, (short)i2, (byte)i2, i2 % 2 == 0, (scala.collection.immutable.Seq<Object>)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), i2), (scala.collection.immutable.Seq<Option<Object>>)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), i2).map((Function1 & Serializable)x$1 -> OrcQueryTest.$anonfun$new$9(BoxesRunTime.unboxToInt((Object)x$1))), (Map<Object, Object>)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), i2).map((Function1 & Serializable)i -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToInt((Object)i)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Map<Object, Option<Object>>)((Map)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), i2).map((Function1 & Serializable)i -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))), (Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToInt((Object)i))))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)i2)), (Object)None$.MODULE$))), (Tuple2<scala.collection.immutable.Seq<Object>, Tuple2<Object, String>>)new Tuple2((Object)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), i2), (Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)i2), (Object)String.valueOf(BoxesRunTime.boxToInteger((int)i2)))));
    }

    public static final /* synthetic */ void $anonfun$new$13(OrcQueryTest $this, scala.collection.immutable.Seq data$2, String file) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OrcQueryTest.class.getClassLoader());
        public final class Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator22$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.execution.datasources.orc.AllDataTypesWithNonPrimitiveType").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator22$1(OrcQueryTest $outer) {
            }
        }
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().read().orc(file), (scala.collection.immutable.Seq<Row>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq($this.testImplicits().localSeqToDatasetHolder(data$2, $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator22$1(null)))).toDF().collect()));
    }

    public static final /* synthetic */ void $anonfun$new$16(OrcQueryTest $this, File path) {
        scala.collection.immutable.Seq data = (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)new TestUDT.MyDenseVector(new double[]{0.25, 2.25, 4.25}))}));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OrcQueryTest.class.getClassLoader());
        public final class Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator33$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("org.apache.spark.sql.types").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("org.apache.spark.sql.types.TestUDT")), (Symbols.SymbolApi)$m.staticClass("org.apache.spark.sql.types.TestUDT.MyDenseVector"), (List)Nil$.MODULE$), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator33$1(OrcQueryTest $outer) {
            }
        }
        Dataset udtDF = $this.testImplicits().localSeqToDatasetHolder(data, $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator33$1(null)))).toDF((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "vectors"}));
        udtDF.write().orc(path.getAbsolutePath());
        Dataset readBack = $this.spark().read().schema(udtDF.schema()).orc(path.getAbsolutePath());
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> udtDF, (Dataset<Row>)readBack);
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$19(int i) {
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)i), (Object)new StringBuilder(4).append("val_").append(i).toString());
    }

    public static final /* synthetic */ Contact $anonfun$new$24(int m) {
        return new Contact(new StringBuilder(8).append("contact_").append(m).toString(), new StringBuilder(6).append("phone_").append(m).toString());
    }

    public static final /* synthetic */ Person $anonfun$new$23(int i) {
        return new Person(new StringBuilder(5).append("name_").append(i).toString(), i, (scala.collection.immutable.Seq<Contact>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 1).map((Function1 & Serializable)m -> OrcQueryTest.$anonfun$new$24(BoxesRunTime.unboxToInt((Object)m))));
    }

    public static final /* synthetic */ boolean $anonfun$new$35(File x$6) {
        return x$6.getName().endsWith(".zlib.orc");
    }

    public static final /* synthetic */ void $anonfun$new$34(OrcQueryTest $this, File file) {
        $this.spark().range(0L, 10L).write().option(OrcConf.COMPRESS.getAttribute(), "ZLIB").orc(file.getCanonicalPath());
        Option maybeOrcFile = ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])file.listFiles()), (Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)OrcQueryTest.$anonfun$new$35(x$6)));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(maybeOrcFile.isDefined(), "maybeOrcFile.isDefined", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
        Path orcFilePath = new Path(((File)maybeOrcFile.get()).getAbsolutePath());
        OrcFile.ReaderOptions conf = OrcFile.readerOptions((Configuration)new Configuration());
        Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> OrcFile.createReader((Path)orcFilePath, (OrcFile.ReaderOptions)conf), (Function1 & Serializable)reader -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer("ZLIB");
            String $org_scalatest_assert_macro_right = reader.getCompressionKind().name();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
        });
    }

    public static final /* synthetic */ boolean $anonfun$new$39(File x$7) {
        return x$7.getName().endsWith(".zlib.orc");
    }

    public static final /* synthetic */ void $anonfun$new$38(OrcQueryTest $this, File file) {
        $this.spark().range(0L, 10L).write().option("compression", "ZLIB").option(OrcConf.COMPRESS.getAttribute(), "SNAPPY").orc(file.getCanonicalPath());
        Option maybeOrcFile = ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])file.listFiles()), (Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)OrcQueryTest.$anonfun$new$39(x$7)));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(maybeOrcFile.isDefined(), "maybeOrcFile.isDefined", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
        Path orcFilePath = new Path(((File)maybeOrcFile.get()).getAbsolutePath());
        OrcFile.ReaderOptions conf = OrcFile.readerOptions((Configuration)new Configuration());
        Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> OrcFile.createReader((Path)orcFilePath, (OrcFile.ReaderOptions)conf), (Function1 & Serializable)reader -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer("ZLIB");
            String $org_scalatest_assert_macro_right = reader.getCompressionKind().name();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
        });
    }

    public static final /* synthetic */ boolean $anonfun$new$44(File x$8) {
        return x$8.getName().endsWith(".zlib.orc");
    }

    public static final /* synthetic */ void $anonfun$new$43(OrcQueryTest $this, File file) {
        $this.spark().range(0L, 10L).write().option("compression", "ZLIB").orc(file.getCanonicalPath());
        Option maybeOrcFile = ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])file.listFiles()), (Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)OrcQueryTest.$anonfun$new$44(x$8)));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(maybeOrcFile.isDefined(), "maybeOrcFile.isDefined", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229));
        Path orcFilePath = new Path(((File)maybeOrcFile.get()).getAbsolutePath());
        OrcFile.ReaderOptions conf = OrcFile.readerOptions((Configuration)new Configuration());
        Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> OrcFile.createReader((Path)orcFilePath, (OrcFile.ReaderOptions)conf), (Function1 & Serializable)reader -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer("ZLIB");
            String $org_scalatest_assert_macro_right = reader.getCompressionKind().name();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234));
        });
    }

    public static final /* synthetic */ boolean $anonfun$new$48(File x$9) {
        return x$9.getName().endsWith(".snappy.orc");
    }

    public static final /* synthetic */ void $anonfun$new$47(OrcQueryTest $this, File file) {
        $this.spark().range(0L, 10L).write().option("compression", "SNAPPY").orc(file.getCanonicalPath());
        Option maybeOrcFile = ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])file.listFiles()), (Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)OrcQueryTest.$anonfun$new$48(x$9)));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(maybeOrcFile.isDefined(), "maybeOrcFile.isDefined", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 244));
        Path orcFilePath = new Path(((File)maybeOrcFile.get()).getAbsolutePath());
        OrcFile.ReaderOptions conf = OrcFile.readerOptions((Configuration)new Configuration());
        Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> OrcFile.createReader((Path)orcFilePath, (OrcFile.ReaderOptions)conf), (Function1 & Serializable)reader -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer("SNAPPY");
            String $org_scalatest_assert_macro_right = reader.getCompressionKind().name();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 249));
        });
    }

    public static final /* synthetic */ boolean $anonfun$new$52(File x$10) {
        return x$10.getName().endsWith(".orc");
    }

    public static final /* synthetic */ void $anonfun$new$51(OrcQueryTest $this, File file) {
        $this.spark().range(0L, 10L).write().option("compression", "NONE").orc(file.getCanonicalPath());
        Option maybeOrcFile = ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])file.listFiles()), (Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)OrcQueryTest.$anonfun$new$52(x$10)));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(maybeOrcFile.isDefined(), "maybeOrcFile.isDefined", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 259));
        Path orcFilePath = new Path(((File)maybeOrcFile.get()).getAbsolutePath());
        OrcFile.ReaderOptions conf = OrcFile.readerOptions((Configuration)new Configuration());
        Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> OrcFile.createReader((Path)orcFilePath, (OrcFile.ReaderOptions)conf), (Function1 & Serializable)reader -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer("NONE");
            String $org_scalatest_assert_macro_right = reader.getCompressionKind().name();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 264));
        });
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$56(int i) {
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)i), (Object)Integer.toString(i));
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$63(int i) {
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)i), (Object)Integer.toString(i));
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$71(int i) {
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)i), (Object)Integer.toString(i));
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$76(int i) {
        None$ maybeInt = i % 2 == 0 ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)i));
        return new Tuple2((Object)maybeInt, (Object)Integer.toString(i));
    }

    public static final /* synthetic */ boolean $anonfun$new$78(Attribute x$13) {
        String string = x$13.name();
        String string2 = "_1";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ Tuple1 $anonfun$new$82(int i) {
        return new Tuple1((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)i), (Object)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(4).append("val_").append(i).toString()}))));
    }

    public static final /* synthetic */ Tuple1 $anonfun$new$87(int i) {
        return new Tuple1((Object)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)i)), (Object)new StringBuilder(4).append("val_").append(i).toString())})));
    }

    public static final /* synthetic */ Tuple1 $anonfun$new$92(int _1) {
        return new Tuple1.mcI.sp(_1);
    }

    public static final /* synthetic */ Tuple3 $anonfun$new$97(int i) {
        return new Tuple3((Object)"same", (Object)new StringBuilder(4).append("run_").append(i / 100).toString(), (Object)BoxesRunTime.boxToInteger((int)1));
    }

    public static final /* synthetic */ void $anonfun$new$103(OrcQueryTest $this, File dir) {
        String path = dir.getCanonicalPath();
        $this.spark().range(0L, 10L).select((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{$this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "id")).as("Acol")})).write().orc(path);
        $this.spark().read().orc(path).schema().apply("Acol");
        $this.intercept((Function0 & Serializable)() -> $this.spark().read().orc(path).schema().apply("acol"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 375));
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().read().orc(path).select("acol", (scala.collection.immutable.Seq)Nil$.MODULE$).sort("acol", (scala.collection.immutable.Seq)Nil$.MODULE$), (scala.collection.immutable.Seq<Row>)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable)x$16 -> Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)x$16))}))));
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$110(int i) {
        None$ maybeInt = i % 2 == 0 ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)i));
        None$ nullValue = None$.MODULE$;
        return new Tuple2((Object)maybeInt, (Object)nullValue);
    }

    private final void checkPredicate$1(Column pred, scala.collection.immutable.Seq answer, Dataset df$1) {
        Dataset<Row> sourceDf = this.stripSparkFilter((Dataset<Row>)df$1.where(pred));
        scala.collection.immutable.Set data = Predef$.MODULE$.wrapRefArray((Object[])sourceDf.collect()).toSet();
        scala.collection.immutable.Set expectedData = answer.toSet();
        long $org_scalatest_assert_macro_left = sourceDf.count();
        int $org_scalatest_assert_macro_right = 10;
        Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Bool $org_scalatest_assert_macro_right2 = $org_scalatest_assert_macro_left2.value() ? Bool$.MODULE$.simpleMacroBool(expectedData.subsetOf((Set)data), "expectedData.subsetOf(data)", Prettifier$.MODULE$.default()) : Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(36).append("No data was filtered for predicate: ").append(pred).toString(), Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 413));
    }

    public static final /* synthetic */ Tuple1 $anonfun$new$126(int i) {
        return new Tuple1((Object)new int[]{i});
    }

    public static final /* synthetic */ void $anonfun$new$127(OrcQueryTest $this, IndexedSeq data$8, String file) {
        Dataset actual = $this.spark().read().orc(file).where("_1 is not null");
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OrcQueryTest.class.getClassLoader());
        public final class Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator76$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple1"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
            }

            public Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator76$1(OrcQueryTest $outer) {
            }
        }
        Dataset expected = $this.testImplicits().localSeqToDatasetHolder((scala.collection.immutable.Seq)data$8, $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator76$1(null)))).toDF();
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> actual, (Dataset<Row>)expected);
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$131(int x$29) {
        return new Tuple2.mcZZ.sp(true, false);
    }

    public static final /* synthetic */ void $anonfun$new$132(OrcQueryTest $this, String file) {
        Dataset df = $this.spark().read().orc(file).where("_2 == true");
        long actual = $this.stripSparkFilter((Dataset<Row>)df).count();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)actual));
        int $org_scalatest_assert_macro_right = 0;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 457));
    }

    public static final /* synthetic */ Tuple1 $anonfun$new$135(int i) {
        return new Tuple1((Object)scala.package$.MODULE$.BigDecimal().valueOf((long)i));
    }

    public static final /* synthetic */ Tuple1 $anonfun$new$138(String timeString$1, int i) {
        long milliseconds = Timestamp.valueOf(timeString$1).getTime() + (long)(i * 3600);
        return new Tuple1((Object)new Timestamp(milliseconds));
    }

    public static final /* synthetic */ boolean $anonfun$new$145(File x$30) {
        return x$30.getName().endsWith(".snappy.orc");
    }

    public static final /* synthetic */ void $anonfun$new$144(String path) {
        Configuration conf = new Configuration();
        conf.set(OrcConf.INCLUDE_COLUMNS.getAttribute(), "");
        conf.setBoolean("hive.io.file.read.all.columns", false);
        File file = (File)Option$.MODULE$.option2Iterable(ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])new File(path).listFiles()), (Function1 & Serializable)x$30 -> BoxesRunTime.boxToBoolean((boolean)OrcQueryTest.$anonfun$new$145(x$30)))).head();
        FileSplit split = new FileSplit(new Path(file.toURI()), 0L, file.length(), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
        TaskAttemptID attemptId = new TaskAttemptID(new TaskID(new JobID(), TaskType.MAP, 0), 0);
        TaskAttemptContextImpl hadoopAttemptContext = new TaskAttemptContextImpl(conf, attemptId);
        OrcInputFormat oif = new OrcInputFormat();
        RecordReader orcRecordReader = oif.createRecordReader((InputSplit)split, (TaskAttemptContext)hadoopAttemptContext);
        try (RecordReaderIterator recordsIterator = new RecordReaderIterator(orcRecordReader);){
            String $org_scalatest_assert_macro_left = ((OrcStruct)recordsIterator.next()).toString();
            String $org_scalatest_assert_macro_right = "{null, null}";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 519));
        }
    }

    public static final /* synthetic */ Tuple1 $anonfun$new$147(int _1) {
        return new Tuple1.mcI.sp(_1);
    }

    public static final /* synthetic */ Tuple1 $anonfun$new$148(int _1) {
        return new Tuple1.mcI.sp(_1);
    }

    public static final /* synthetic */ void $anonfun$new$150(OrcQueryTest $this, File dir) {
        String basePath = dir.getCanonicalPath();
        $this.spark().range(1L).toDF((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})).write().orc(new Path(basePath, "first").toString());
        $this.spark().range(1L, 2L).toDF((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})).write().orc(new Path(basePath, "second").toString());
        $this.spark().range(2L, 3L).toDF((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})).write().json(new Path(basePath, "third").toString());
        Dataset df = $this.spark().read().orc((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new Path(basePath, "first").toString(), new Path(basePath, "second").toString(), new Path(basePath, "third").toString()}));
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> df, (scala.collection.immutable.Seq<Row>)((scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)})), Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}))}))));
    }

    private final void testIgnoreCorruptFiles$1() {
        this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            OrcQueryTest.$anonfun$new$150(this, dir);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$152(OrcQueryTest $this, File dir) {
        String basePath = dir.getCanonicalPath();
        $this.spark().range(1L).toDF((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})).write().orc(new Path(basePath, "first").toString());
        $this.spark().range(1L, 2L).toDF((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})).write().orc(new Path(basePath, "second").toString());
        $this.spark().range(2L, 3L).toDF((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})).write().json(new Path(basePath, "third").toString());
        Dataset df = $this.spark().read().schema("a long").orc((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new Path(basePath, "first").toString(), new Path(basePath, "second").toString(), new Path(basePath, "third").toString()}));
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> df, (scala.collection.immutable.Seq<Row>)((scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)})), Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}))}))));
    }

    private final void testIgnoreCorruptFilesWithoutSchemaInfer$1() {
        this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            OrcQueryTest.$anonfun$new$152(this, dir);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$154(OrcQueryTest $this, File dir) {
        String basePath = dir.getCanonicalPath();
        $this.spark().range(1L).toDF((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})).write().json(new Path(basePath, "first").toString());
        $this.spark().range(1L, 2L).toDF((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})).write().json(new Path(basePath, "second").toString());
        Dataset df = $this.spark().read().orc((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new Path(basePath, "first").toString(), new Path(basePath, "second").toString()}));
        long $org_scalatest_assert_macro_left = df.count();
        int $org_scalatest_assert_macro_right = 0;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 572));
    }

    private final void testAllCorruptFiles$1() {
        this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            OrcQueryTest.$anonfun$new$154(this, dir);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$155(OrcQueryTest $this, File dir) {
        String basePath = dir.getCanonicalPath();
        $this.spark().range(1L).toDF((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})).write().json(new Path(basePath, "first").toString());
        $this.spark().range(1L, 2L).toDF((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})).write().json(new Path(basePath, "second").toString());
        Dataset df = $this.spark().read().schema("a long").orc((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new Path(basePath, "first").toString(), new Path(basePath, "second").toString()}));
        long $org_scalatest_assert_macro_left = df.count();
        int $org_scalatest_assert_macro_right = 0;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 584));
    }

    private final void testAllCorruptFilesWithoutSchemaInfer$1() {
        this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            OrcQueryTest.$anonfun$new$155(this, dir);
            return BoxedUnit.UNIT;
        });
    }

    public OrcQueryTest() {
        this.test("Read/write All Types", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            public final class Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator11$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple8"), (List)List$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), $m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("scala.Long").asType().toTypeConstructor(), $m.staticClass("scala.Float").asType().toTypeConstructor(), $m.staticClass("scala.Double").asType().toTypeConstructor(), $m.staticClass("scala.Short").asType().toTypeConstructor(), $m.staticClass("scala.Byte").asType().toTypeConstructor(), $m.staticClass("scala.Boolean").asType().toTypeConstructor()})));
                }

                public Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator11$1(OrcQueryTest $outer) {
                }
            }
            IndexedSeq data = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 255).map((Function1 & Serializable)i -> OrcQueryTest.$anonfun$new$2(BoxesRunTime.unboxToInt((Object)i)));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OrcQueryTest.class.getClassLoader());
            this.withOrcFile(data, (Function1<String, BoxedUnit>)(Function1 & Serializable)file -> {
                OrcQueryTest.$anonfun$new$3(this, data, file);
                return BoxedUnit.UNIT;
            }, ClassTag$.MODULE$.apply(Tuple8.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator11$1(null)));
        }, new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        this.test("Read/write binary data", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            public final class Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator12$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.sql.execution.datasources.orc.BinaryData").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator12$1(OrcQueryTest $outer) {
                }
            }
            BinaryData binaryData = new BinaryData("test".getBytes(StandardCharsets.UTF_8));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OrcQueryTest.class.getClassLoader());
            this.withOrcFile(scala.package$.MODULE$.Nil().$colon$colon((Object)binaryData), (Function1<String, BoxedUnit>)(Function1 & Serializable)file -> {
                OrcQueryTest.$anonfun$new$6(this, file);
                return BoxedUnit.UNIT;
            }, ClassTag$.MODULE$.apply(BinaryData.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator12$1(null)));
        }, new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
        this.test("Read/write all types with non-primitive type", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            IndexedSeq data = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 255).map((Function1 & Serializable)i -> OrcQueryTest.$anonfun$new$8(BoxesRunTime.unboxToInt((Object)i)));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OrcQueryTest.class.getClassLoader());
            public final class Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator23$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.sql.execution.datasources.orc.AllDataTypesWithNonPrimitiveType").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator23$1(OrcQueryTest $outer) {
                }
            }
            this.withOrcFile(data, (Function1<String, BoxedUnit>)((Function1 & Serializable)arg_0 -> OrcQueryTest.$anonfun$new$13$adapted(this, (scala.collection.immutable.Seq)data, arg_0)), ClassTag$.MODULE$.apply(AllDataTypesWithNonPrimitiveType.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator23$1(null)));
        }, new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
        this.test("Read/write UserDefinedType", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)path -> {
            OrcQueryTest.$anonfun$new$16(this, path);
            return BoxedUnit.UNIT;
        }), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
        this.test("Creating case class RDD table", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            IndexedSeq data = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 100).map((Function1 & Serializable)i -> OrcQueryTest.$anonfun$new$19(BoxesRunTime.unboxToInt((Object)i)));
            SparkContext qual$1 = this.sparkContext();
            IndexedSeq x$1 = data;
            int x$2 = qual$1.parallelize$default$2();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OrcQueryTest.class.getClassLoader());
            public final class Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator43$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator43$1(OrcQueryTest $outer) {
                }
            }
            this.testImplicits().rddToDatasetHolder(qual$1.parallelize((scala.collection.immutable.Seq)x$1, x$2, ClassTag$.MODULE$.apply(Tuple2.class)), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator43$1(null)))).toDF().createOrReplaceTempView("t");
            this.withTempView((scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OrcQueryTest.class.getClassLoader());
                public final class Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator53$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator53$1(OrcQueryTest $outer) {
                    }
                }
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM t"), (scala.collection.immutable.Seq<Row>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(this.testImplicits().localSeqToDatasetHolder((scala.collection.immutable.Seq)data, this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator53$1(null)))).toDF().collect()));
            });
        }, new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
        this.test("Simple selection form ORC table", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            public final class Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator54$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.sql.execution.datasources.orc.Person").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator54$1(OrcQueryTest $outer) {
                }
            }
            IndexedSeq data = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable)i -> OrcQueryTest.$anonfun$new$23(BoxesRunTime.unboxToInt((Object)i)));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OrcQueryTest.class.getClassLoader());
            this.withOrcTable(data, "t", this.withOrcTable$default$3(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)((Dataset)this.sql().apply((Object)"SELECT name FROM t WHERE age <= 5")).count()));
                int $org_scalatest_assert_macro_right = 5;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
                this.assertResult(BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToLong((long)((Dataset)this.sql().apply((Object)"SELECT name, contacts FROM t where age > 5")).rdd().flatMap((Function1 & Serializable)x$3 -> (Seq)x$3.getAs("contacts"), ClassTag$.MODULE$.Any()).count()), Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
                Dataset df = (Dataset)this.sql().apply((Object)"SELECT name, contacts FROM t WHERE age > 5 AND age < 8");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)df.count()));
                int $org_scalatest_assert_macro_right2 = 2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
                this.assertResult(BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToLong((long)df.rdd().flatMap((Function1 & Serializable)x$4 -> (Seq)x$4.getAs("contacts"), ClassTag$.MODULE$.Any()).count()), Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
                Dataset df2 = (Dataset)this.sql().apply((Object)"SELECT name, contacts FROM t WHERE age < 2 OR age > 8");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)df2.count()));
                int $org_scalatest_assert_macro_right3 = 3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
                this.assertResult(BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToLong((long)df2.rdd().flatMap((Function1 & Serializable)x$5 -> (Seq)x$5.getAs("contacts"), ClassTag$.MODULE$.Any()).count()), Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
            }, ClassTag$.MODULE$.apply(Person.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator54$1(null)));
        }, new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
        this.test("save and load case class RDD with `None`s as orc", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            public final class Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator55$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$m.staticClass("scala.Float").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$m.staticClass("scala.Boolean").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$))))));
                }

                public Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator55$1(OrcQueryTest $outer) {
                }
            }
            Tuple5 tuple5 = new Tuple5((Object)Option$.MODULE$.empty(), (Object)Option$.MODULE$.empty(), (Object)Option$.MODULE$.empty(), (Object)Option$.MODULE$.empty(), (Object)Option$.MODULE$.empty());
            List data = scala.package$.MODULE$.Nil().$colon$colon((Object)tuple5);
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OrcQueryTest.class.getClassLoader());
            this.withOrcFile(data, (Function1<String, BoxedUnit>)(Function1 & Serializable)file -> {
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().read().orc(file), Row$.MODULE$.apply((scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().fill(5, (Function0 & Serializable)() -> null)));
                return BoxedUnit.UNIT;
            }, ClassTag$.MODULE$.apply(Tuple5.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator55$1(null)));
        }, new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
        this.test("SPARK-16610: Respect orc.compress (i.e., OrcConf.COMPRESS) when compression is unset", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)file -> {
                OrcQueryTest.$anonfun$new$34(this, file);
                return BoxedUnit.UNIT;
            });
            this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)file -> {
                OrcQueryTest.$anonfun$new$38(this, file);
                return BoxedUnit.UNIT;
            });
        }, new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
        this.test("Compression options for writing to an ORC file (SNAPPY, ZLIB and NONE)", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)file -> {
                OrcQueryTest.$anonfun$new$43(this, file);
                return BoxedUnit.UNIT;
            });
            this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)file -> {
                OrcQueryTest.$anonfun$new$47(this, file);
                return BoxedUnit.UNIT;
            });
            this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)file -> {
                OrcQueryTest.$anonfun$new$51(this, file);
                return BoxedUnit.UNIT;
            });
        }, new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 222));
        this.test("simple select queries", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            public final class Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator56$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator56$1(OrcQueryTest $outer) {
                }
            }
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OrcQueryTest.class.getClassLoader());
            this.withOrcTable(RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable)i -> OrcQueryTest.$anonfun$new$56(BoxesRunTime.unboxToInt((Object)i))), "t", this.withOrcTable$default$3(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT `_1` FROM t where t.`_1` > 5"), (scala.collection.immutable.Seq<Row>)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(6), 10).map((Function1 & Serializable)x$11 -> Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)x$11))}))));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT `_1` FROM t as tmp where tmp.`_1` < 5"), (scala.collection.immutable.Seq<Row>)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable)x$12 -> Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)x$12))}))));
            }, ClassTag$.MODULE$.apply(Tuple2.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator56$1(null)));
        }, new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 269));
        this.test("appending", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            public final class Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator58$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator58$1(OrcQueryTest $outer) {
                }
            }
            IndexedSeq data = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable)i -> OrcQueryTest.$anonfun$new$63(BoxesRunTime.unboxToInt((Object)i)));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OrcQueryTest.class.getClassLoader());
            public final class Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator57$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator57$1(OrcQueryTest $outer) {
                }
            }
            this.spark().createDataFrame((scala.collection.immutable.Seq)data, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator57$1(null))).toDF((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c1", "c2"})).createOrReplaceTempView("tmp");
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(OrcQueryTest.class.getClassLoader());
            this.withOrcFile(data, (Function1<String, BoxedUnit>)(Function1 & Serializable)file -> {
                this.withTempView((scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    $this.spark().read().orc(file).createOrReplaceTempView("t");
                    $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), (scala.collection.immutable.Seq<Row>)((scala.collection.immutable.Seq)data$4.map((Function1 & Serializable)tuple -> Row$.MODULE$.fromTuple(tuple))));
                    $this.sql().apply((Object)"INSERT INTO TABLE t SELECT * FROM tmp");
                    $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), (scala.collection.immutable.Seq<Row>)((scala.collection.immutable.Seq)((IndexedSeqOps)data$4.$plus$plus((IterableOnce)data$4)).map((Function1 & Serializable)tuple -> Row$.MODULE$.fromTuple(tuple))));
                });
                return BoxedUnit.UNIT;
            }, ClassTag$.MODULE$.apply(Tuple2.class), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator58$1(null)));
            this.spark().sessionState().catalog().dropTable(TableIdentifier$.MODULE$.apply("tmp"), true, false);
        }, new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
        this.test("overwriting", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            public final class Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator60$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator60$1(OrcQueryTest $outer) {
                }
            }
            IndexedSeq data = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable)i -> OrcQueryTest.$anonfun$new$71(BoxesRunTime.unboxToInt((Object)i)));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OrcQueryTest.class.getClassLoader());
            public final class Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator59$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator59$1(OrcQueryTest $outer) {
                }
            }
            this.spark().createDataFrame((scala.collection.immutable.Seq)data, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator59$1(null))).toDF((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c1", "c2"})).createOrReplaceTempView("tmp");
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(OrcQueryTest.class.getClassLoader());
            this.withOrcTable(data, "t", this.withOrcTable$default$3(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)"INSERT OVERWRITE TABLE t SELECT * FROM tmp");
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> this.spark().table("t"), (scala.collection.immutable.Seq<Row>)((scala.collection.immutable.Seq)data.map((Function1 & Serializable)tuple -> Row$.MODULE$.fromTuple(tuple))));
            }, ClassTag$.MODULE$.apply(Tuple2.class), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator60$1(null)));
            this.spark().sessionState().catalog().dropTable(TableIdentifier$.MODULE$.apply("tmp"), true, false);
        }, new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 300));
        this.test("self-join", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            public final class Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator61$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator61$1(OrcQueryTest $outer) {
                }
            }
            IndexedSeq data = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 4).map((Function1 & Serializable)i -> OrcQueryTest.$anonfun$new$76(BoxesRunTime.unboxToInt((Object)i)));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OrcQueryTest.class.getClassLoader());
            this.withOrcTable(data, "t", this.withOrcTable$default$3(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                Dataset selfJoin = (Dataset)this.sql().apply((Object)"SELECT * FROM t x JOIN t y WHERE x.`_1` = y.`_1`");
                scala.collection.immutable.Seq queryOutput = selfJoin.queryExecution().analyzed().output();
                this.assertResult(BoxesRunTime.boxToInteger((int)4), "Field count mismatches", BoxesRunTime.boxToInteger((int)queryOutput.size()), Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 324));
                this.assertResult(BoxesRunTime.boxToInteger((int)2), new StringBuilder(41).append("Duplicated expression ID in query plan:\n ").append(selfJoin).toString(), BoxesRunTime.boxToInteger((int)((SeqOps)((IterableOps)queryOutput.filter((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)OrcQueryTest.$anonfun$new$78(x$13)))).map((Function1 & Serializable)x$14 -> x$14.exprId())).size()), Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 325));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> selfJoin, (scala.collection.immutable.Seq<Row>)((scala.collection.immutable.Seq)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1", BoxesRunTime.boxToInteger((int)1), "1"})), Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "3", BoxesRunTime.boxToInteger((int)3), "3"}))}))));
            }, ClassTag$.MODULE$.apply(Tuple2.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator61$1(null)));
        }, new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 313));
        this.test("nested data - struct with array field", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            public final class Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator62$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple1"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.Seq"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$)), (List)Nil$.MODULE$))), (List)Nil$.MODULE$));
                }

                public Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator62$1(OrcQueryTest $outer) {
                }
            }
            IndexedSeq data = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable)i -> OrcQueryTest.$anonfun$new$82(BoxesRunTime.unboxToInt((Object)i)));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OrcQueryTest.class.getClassLoader());
            this.withOrcTable(data, "t", this.withOrcTable$default$3(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT `_1`.`_2`[0] FROM t"), (scala.collection.immutable.Seq<Row>)((scala.collection.immutable.Seq)data.map((Function1 & Serializable)x0$1 -> {
                SeqOps seqOps;
                scala.collection.immutable.Seq seq;
                Tuple2 tuple2;
                Tuple1 tuple1 = x0$1;
                if (tuple1 == null || (tuple2 = (Tuple2)tuple1._1()) == null || (seq = (scala.collection.immutable.Seq)tuple2._2()) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = scala.package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) != 0) {
                    throw new MatchError((Object)tuple1);
                }
                String string = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                Row row = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{string}));
                return row;
            }))), ClassTag$.MODULE$.apply(Tuple1.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator62$1(null)));
        }, new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 333));
        this.test("nested data - array of struct", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            public final class Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator63$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple1"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.Seq"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$))), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
                }

                public Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator63$1(OrcQueryTest $outer) {
                }
            }
            IndexedSeq data = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable)i -> OrcQueryTest.$anonfun$new$87(BoxesRunTime.unboxToInt((Object)i)));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OrcQueryTest.class.getClassLoader());
            this.withOrcTable(data, "t", this.withOrcTable$default$3(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT `_1`[0].`_2` FROM t"), (scala.collection.immutable.Seq<Row>)((scala.collection.immutable.Seq)data.map((Function1 & Serializable)x0$2 -> {
                Tuple2 tuple2;
                SeqOps seqOps;
                scala.collection.immutable.Seq seq;
                Tuple1 tuple1 = x0$2;
                if (tuple1 == null || (seq = (scala.collection.immutable.Seq)tuple1._1()) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = scala.package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) != 0 || (tuple2 = (Tuple2)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) == null) {
                    throw new MatchError((Object)tuple1);
                }
                String string = (String)tuple2._2();
                Row row = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{string}));
                return row;
            }))), ClassTag$.MODULE$.apply(Tuple1.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator63$1(null)));
        }, new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 342));
        this.test("columns only referenced by pushed down filters should remain", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OrcQueryTest.class.getClassLoader());
            public final class Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator64$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple1"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                }

                public Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator64$1(OrcQueryTest $outer) {
                }
            }
            this.withOrcTable(RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable)_1 -> OrcQueryTest.$anonfun$new$92(BoxesRunTime.unboxToInt((Object)_1))), "t", this.withOrcTable$default$3(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT `_1` FROM t WHERE `_1` < 10"), (scala.collection.immutable.Seq<Row>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 9).map((Function1 & Serializable)x$15 -> Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)x$15))})))), ClassTag$.MODULE$.apply(Tuple1.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator64$1(null)));
        }, new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 351));
        this.test("SPARK-5309 strings stored using dictionary compression in orc", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            public final class Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator65$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator65$1(OrcQueryTest $outer) {
                }
            }
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OrcQueryTest.class.getClassLoader());
            this.withOrcTable(RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 1000).map((Function1 & Serializable)i -> OrcQueryTest.$anonfun$new$97(BoxesRunTime.unboxToInt((Object)i))), "t", this.withOrcTable$default$3(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT `_1`, `_2`, SUM(`_3`) FROM t GROUP BY `_1`, `_2`"), (scala.collection.immutable.Seq<Row>)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable)i -> Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"same", new StringBuilder(4).append("run_").append(BoxesRunTime.unboxToInt((Object)i)).toString(), BoxesRunTime.boxToInteger((int)100)}))));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT `_1`, `_2`, SUM(`_3`) FROM t WHERE `_2` = 'run_5' GROUP BY `_1`, `_2`"), (scala.collection.immutable.Seq<Row>)((scala.collection.immutable.Seq)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"same", "run_5", BoxesRunTime.boxToInteger((int)100)}))}))));
            }, ClassTag$.MODULE$.apply(Tuple3.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator65$1(null)));
        }, new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 357));
        this.test("SPARK-9170: Don't implicitly lowercase of user-provided columns", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            OrcQueryTest.$anonfun$new$103(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 369));
        this.test("SPARK-10623 Enable ORC PPD", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            this.withSQLConf((scala.collection.immutable.Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_FILTER_PUSHDOWN_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                String path = dir.getCanonicalPath();
                IndexedSeq data = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable)i -> OrcQueryTest.$anonfun$new$110(BoxesRunTime.unboxToInt((Object)i)));
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OrcQueryTest.class.getClassLoader());
                public final class $typecreator66$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
                    }

                    public $typecreator66$1(OrcQueryTest $outer) {
                    }
                }
                $this.spark().createDataFrame((scala.collection.immutable.Seq)data, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new $typecreator66$1(null))).toDF((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})).repartition(10).write().orc(path);
                Dataset df = $this.spark().read().orc(path);
                $this.checkPredicate$1($this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)5)), (scala.collection.immutable.Seq)((List)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5}))).map((Function1 & Serializable)x$17 -> Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)x$17)), null}))), df);
                $this.checkPredicate$1($this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "a")).$less$eq$greater((Object)BoxesRunTime.boxToInteger((int)5)), (scala.collection.immutable.Seq)((List)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5}))).map((Function1 & Serializable)x$18 -> Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)x$18)), null}))), df);
                $this.checkPredicate$1($this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "a")).$less((Object)BoxesRunTime.boxToInteger((int)5)), (scala.collection.immutable.Seq)((List)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 3}))).map((Function1 & Serializable)x$19 -> Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)x$19)), null}))), df);
                $this.checkPredicate$1($this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "a")).$less$eq((Object)BoxesRunTime.boxToInteger((int)5)), (scala.collection.immutable.Seq)((List)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 3, 5}))).map((Function1 & Serializable)x$20 -> Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)x$20)), null}))), df);
                $this.checkPredicate$1($this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater((Object)BoxesRunTime.boxToInteger((int)5)), (scala.collection.immutable.Seq)((List)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7, 9}))).map((Function1 & Serializable)x$21 -> Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)x$21)), null}))), df);
                $this.checkPredicate$1($this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater$eq((Object)BoxesRunTime.boxToInteger((int)5)), (scala.collection.immutable.Seq)((List)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5, 7, 9}))).map((Function1 & Serializable)x$22 -> Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)x$22)), null}))), df);
                $this.checkPredicate$1($this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "a")).isNull(), (scala.collection.immutable.Seq)((List)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Null$[]{null}))).map((Function1 & Serializable)x$23 -> {
                    Object[] objectArray = new Object[2];
                    objectArray[0] = null;
                    objectArray[1] = null;
                    return Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)objectArray));
                }), df);
                $this.checkPredicate$1($this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "b")).isNotNull(), (scala.collection.immutable.Seq)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$), df);
                $this.checkPredicate$1($this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "a")).isin((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)7)})), (scala.collection.immutable.Seq)((List)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 5, 7}))).map((Function1 & Serializable)x$24 -> Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)x$24)), null}))), df);
                $this.checkPredicate$1($this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater((Object)BoxesRunTime.boxToInteger((int)0)).$amp$amp((Object)$this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "a")).$less((Object)BoxesRunTime.boxToInteger((int)3))), (scala.collection.immutable.Seq)((List)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}))).map((Function1 & Serializable)x$25 -> Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)x$25)), null}))), df);
                $this.checkPredicate$1($this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "a")).$less((Object)BoxesRunTime.boxToInteger((int)1)).$bar$bar((Object)$this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater((Object)BoxesRunTime.boxToInteger((int)8))), (scala.collection.immutable.Seq)((List)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{9}))).map((Function1 & Serializable)x$26 -> Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)x$26)), null}))), df);
                $this.checkPredicate$1($this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater((Object)BoxesRunTime.boxToInteger((int)3)).unary_$bang(), (scala.collection.immutable.Seq)((List)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 3}))).map((Function1 & Serializable)x$27 -> Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)x$27)), null}))), df);
                $this.checkPredicate$1($this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater((Object)BoxesRunTime.boxToInteger((int)0)).$amp$amp((Object)$this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "a")).$less((Object)BoxesRunTime.boxToInteger((int)3))).unary_$bang(), (scala.collection.immutable.Seq)((List)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 5, 7, 9}))).map((Function1 & Serializable)x$28 -> Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)x$28)), null}))), df);
            });
            return BoxedUnit.UNIT;
        }), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 383));
        this.test("SPARK-14962 Produce correct results on array type with isnotnull", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((scala.collection.immutable.Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_FILTER_PUSHDOWN_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            public final class Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator77$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple1"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
                }

                public Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator77$1(OrcQueryTest $outer) {
                }
            }
            IndexedSeq data = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable)i -> OrcQueryTest.$anonfun$new$126(BoxesRunTime.unboxToInt((Object)i)));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OrcQueryTest.class.getClassLoader());
            this.withOrcFile(data, (Function1<String, BoxedUnit>)(Function1 & Serializable)file -> {
                OrcQueryTest.$anonfun$new$127(this, data, file);
                return BoxedUnit.UNIT;
            }, ClassTag$.MODULE$.apply(Tuple1.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator77$1(null)));
        }), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 435));
        this.test("SPARK-15198 Support for pushing down filters for boolean types", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((scala.collection.immutable.Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_FILTER_PUSHDOWN_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            public final class Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator78$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Boolean").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Boolean").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator78$1(OrcQueryTest $outer) {
                }
            }
            IndexedSeq data = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable)x$29 -> OrcQueryTest.$anonfun$new$131(BoxesRunTime.unboxToInt((Object)x$29)));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OrcQueryTest.class.getClassLoader());
            this.withOrcFile(data, (Function1<String, BoxedUnit>)(Function1 & Serializable)file -> {
                OrcQueryTest.$anonfun$new$132(this, file);
                return BoxedUnit.UNIT;
            }, ClassTag$.MODULE$.apply(Tuple2.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator78$1(null)));
        }), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 449));
        this.test("Support for pushing down filters for decimal types", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((scala.collection.immutable.Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_FILTER_PUSHDOWN_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            IndexedSeq data = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable)i -> OrcQueryTest.$anonfun$new$135(BoxesRunTime.unboxToInt((Object)i)));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OrcQueryTest.class.getClassLoader());
            public final class Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator79$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple1"), (List)new .colon.colon((Object)$m.staticClass("scala.math.BigDecimal").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                }

                public Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator79$1(OrcQueryTest $outer) {
                }
            }
            this.checkPredicatePushDown((Dataset<Row>)this.spark().createDataFrame((scala.collection.immutable.Seq)data, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator79$1(null))).toDF((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), 10, "a == 2");
        }), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 462));
        this.test("Support for pushing down filters for timestamp types", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((scala.collection.immutable.Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_FILTER_PUSHDOWN_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            String timeString = "2015-08-20 14:57:00";
            IndexedSeq data = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable)i -> OrcQueryTest.$anonfun$new$138(timeString, BoxesRunTime.unboxToInt((Object)i)));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OrcQueryTest.class.getClassLoader());
            public final class Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator80$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple1"), (List)new .colon.colon((Object)$m.staticClass("java.sql.Timestamp").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                }

                public Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator80$1(OrcQueryTest $outer) {
                }
            }
            this.checkPredicatePushDown((Dataset<Row>)this.spark().createDataFrame((scala.collection.immutable.Seq)data, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator80$1(null))).toDF((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), 10, new StringBuilder(7).append("a == '").append(timeString).append("'").toString());
        }), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 469));
        this.test("column nullability and comment - write and then read", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            StructType schema = new StructType().add("cl1", (DataType)IntegerType$.MODULE$, false, "test").add("cl2", (DataType)IntegerType$.MODULE$, true).add("cl3", (DataType)IntegerType$.MODULE$, true);
            Row row = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), null, BoxesRunTime.boxToInteger((int)4)}));
            SparkContext qual$2 = this.sparkContext();
            Row row2 = row;
            List x$3 = scala.package$.MODULE$.Nil().$colon$colon((Object)row2);
            int x$4 = qual$2.parallelize$default$2();
            Dataset df = this.spark().createDataFrame(qual$2.parallelize((scala.collection.immutable.Seq)x$3, x$4, ClassTag$.MODULE$.apply(Row.class)), schema);
            String tableName = "tab";
            this.withTable((scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                df.write().format("orc").mode("overwrite").saveAsTable(tableName);
                Row row = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"cl1", "test"}));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> ((Dataset)this.sql().apply((Object)new StringBuilder(5).append("desc ").append(tableName).toString())).select("col_name", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"comment"})).where(this.testImplicits().StringToColumn(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"comment"}))).$((scala.collection.immutable.Seq)Nil$.MODULE$).$eq$eq$eq((Object)"test")), (scala.collection.immutable.Seq<Row>)scala.package$.MODULE$.Nil().$colon$colon((Object)row));
                StructField[] expectedFields = (StructField[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()), (Function1 & Serializable)f -> {
                    boolean x$5 = true;
                    String x$6 = f.copy$default$1();
                    DataType x$7 = f.copy$default$2();
                    Metadata x$8 = f.copy$default$4();
                    return f.copy(x$6, x$7, true, x$8);
                }, ClassTag$.MODULE$.apply(StructField.class));
                StructType $org_scalatest_assert_macro_left = this.spark().table(tableName).schema();
                StructType $org_scalatest_assert_macro_right = schema.copy(expectedFields);
                StructType structType = $org_scalatest_assert_macro_left;
                StructType structType2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 497));
            });
        }, new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 480));
        this.test("Empty schema does not read data from ORC file", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            public final class Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator81$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator81$1(OrcQueryTest $outer) {
                }
            }
            scala.collection.immutable.Seq data = (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcII.sp(1, 1), new Tuple2.mcII.sp(2, 2)}));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OrcQueryTest.class.getClassLoader());
            this.withOrcFile(data, (Function1<String, BoxedUnit>)(Function1 & Serializable)path -> {
                OrcQueryTest.$anonfun$new$144(path);
                return BoxedUnit.UNIT;
            }, ClassTag$.MODULE$.apply(Tuple2.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator81$1(null)));
        }, new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 501));
        this.test("read from multiple orc input paths", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            File path1 = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            File path2 = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OrcQueryTest.class.getClassLoader());
            public final class Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator82$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple1"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                }

                public Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator82$1(OrcQueryTest $outer) {
                }
            }
            this.makeOrcFile(RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable)_1 -> OrcQueryTest.$anonfun$new$147(BoxesRunTime.unboxToInt((Object)_1))), path1, ClassTag$.MODULE$.apply(Tuple1.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator82$1(null)));
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(OrcQueryTest.class.getClassLoader());
            public final class Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator83$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple1"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                }

                public Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator83$1(OrcQueryTest $outer) {
                }
            }
            this.makeOrcFile(RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable)_1 -> OrcQueryTest.$anonfun$new$148(BoxesRunTime.unboxToInt((Object)_1))), path2, ClassTag$.MODULE$.apply(Tuple1.class), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_execution_datasources_orc_OrcQueryTest$$typecreator83$1(null)));
            Dataset df = this.spark().read().orc((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{path1.getCanonicalPath(), path2.getCanonicalPath()}));
            long $org_scalatest_assert_macro_left = df.count();
            int $org_scalatest_assert_macro_right = 20;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 532));
        }, new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 526));
        this.test("Enabling/disabling ignoreCorruptFiles", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.withSQLConf((scala.collection.immutable.Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.IGNORE_CORRUPT_FILES().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                String m1;
                this.testIgnoreCorruptFiles$1();
                this.testIgnoreCorruptFilesWithoutSchemaInfer$1();
                String $org_scalatest_assert_macro_left = m1 = ((AnalysisException)((Object)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.testAllCorruptFiles$1(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 591)))))).getMessage();
                String $org_scalatest_assert_macro_right = "Unable to infer schema for ORC";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 594));
                this.testAllCorruptFilesWithoutSchemaInfer$1();
            });
            this.withSQLConf((scala.collection.immutable.Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.IGNORE_CORRUPT_FILES().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                SparkException e1 = (SparkException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.testIgnoreCorruptFiles$1(), ClassTag$.MODULE$.apply(SparkException.class), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 599));
                String $org_scalatest_assert_macro_left = e1.getMessage();
                String $org_scalatest_assert_macro_right = "Malformed ORC file";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 602));
                SparkException e2 = (SparkException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.testIgnoreCorruptFilesWithoutSchemaInfer$1(), ClassTag$.MODULE$.apply(SparkException.class), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 603));
                String $org_scalatest_assert_macro_left2 = e2.getMessage();
                String $org_scalatest_assert_macro_right2 = "Malformed ORC file";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 606));
                SparkException e3 = (SparkException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.testAllCorruptFiles$1(), ClassTag$.MODULE$.apply(SparkException.class), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 607));
                String $org_scalatest_assert_macro_left3 = e3.getMessage();
                String $org_scalatest_assert_macro_right3 = "Could not read footer for file";
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 610));
                SparkException e4 = (SparkException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.testAllCorruptFilesWithoutSchemaInfer$1(), ClassTag$.MODULE$.apply(SparkException.class), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 611));
                String $org_scalatest_assert_macro_left4 = e4.getMessage();
                String $org_scalatest_assert_macro_right4 = "Malformed ORC file";
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.contains($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 614));
            });
        }, new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 535));
        this.test("SPARK-27160 Predicate pushdown correctness on DecimalType for ORC", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            this.withSQLConf((scala.collection.immutable.Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_FILTER_PUSHDOWN_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                String path = dir.getCanonicalPath();
                $this.testImplicits().localSeqToDatasetHolder((scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BigDecimal[]{scala.package$.MODULE$.BigDecimal().apply(0.1), scala.package$.MODULE$.BigDecimal().apply(0.2), scala.package$.MODULE$.BigDecimal().apply(-0.3)})), $this.testImplicits().newScalaDecimalEncoder()).toDF((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x"})).write().orc(path);
                Dataset df = $this.spark().read().orc(path);
                $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> df.filter("x >= 0.1"), (scala.collection.immutable.Seq<Row>)((scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)0.1)})), Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)0.2)}))}))));
                $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> df.filter("x > 0.1"), (scala.collection.immutable.Seq<Row>)((scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)0.2)}))}))));
                $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> df.filter("x <= 0.15"), (scala.collection.immutable.Seq<Row>)((scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)0.1)})), Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)-0.3)}))}))));
                $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> df.filter("x < 0.1"), (scala.collection.immutable.Seq<Row>)((scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)-0.3)}))}))));
                $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> df.filter("x == 0.2"), (scala.collection.immutable.Seq<Row>)((scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)0.2)}))}))));
            });
            return BoxedUnit.UNIT;
        }), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 618));
    }

    public static final /* synthetic */ Object $anonfun$new$13$adapted(OrcQueryTest $this, scala.collection.immutable.Seq data$2, String file) {
        OrcQueryTest.$anonfun$new$13($this, data$2, file);
        return BoxedUnit.UNIT;
    }
}

