/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.execution.streaming.CreateAtomicTestManager;
import org.apache.spark.sql.execution.streaming.CreateAtomicTestManager$;
import org.apache.spark.sql.execution.streaming.state.ByteArrayPair;
import org.apache.spark.sql.execution.streaming.state.RocksDB;
import org.apache.spark.sql.execution.streaming.state.RocksDB$;
import org.apache.spark.sql.execution.streaming.state.RocksDBCheckpointMetadata;
import org.apache.spark.sql.execution.streaming.state.RocksDBCheckpointMetadata$;
import org.apache.spark.sql.execution.streaming.state.RocksDBConf;
import org.apache.spark.sql.execution.streaming.state.RocksDBConf$;
import org.apache.spark.sql.execution.streaming.state.RocksDBFileManager;
import org.apache.spark.sql.execution.streaming.state.RocksDBFileManager$;
import org.apache.spark.sql.execution.streaming.state.RocksDBLogFile;
import org.apache.spark.sql.execution.streaming.state.RocksDBMetrics;
import org.apache.spark.sql.execution.streaming.state.RocksDBNativeHistogram;
import org.apache.spark.sql.execution.streaming.state.RocksDBSstFile;
import org.apache.spark.sql.execution.streaming.state.RocksDBSuite$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IndexedSeqOps;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.NumericRange;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.Null$;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t\u0015a\u0001\u0002\r\u001a\u0001!BQ!\f\u0001\u0005\u00029BQ!\r\u0001\u0005\u0002IBqa\u001b\u0001\u0012\u0002\u0013\u0005A\u000eC\u0004z\u0001E\u0005I\u0011\u0001>\t\u000fy\u0004\u0011\u0013!C\u0001\u007f\"9\u0011q\u0001\u0001\u0005\u0002\u0005%\u0001bBA\u0019\u0001\u0011\u0005\u00111\u0007\u0005\b\u0003\u000f\u0002A\u0011AA%\u0011\u001d\tY\u0006\u0001C\u0002\u0003;Bq!a\u001d\u0001\t\u0007\t)\bC\u0004\u0002\b\u0002!\u0019!!#\t\u000f\u0005\u001d\u0005\u0001\"\u0001\u0002\u0010\"9\u0011Q\u0014\u0001\u0005\u0002\u0005}\u0005bBAV\u0001\u0011\u0005\u0011Q\u0016\u0005\b\u0003W\u0003A\u0011AA[\u000f\u001d\tI,\u0007E\u0001\u0003w3a\u0001G\r\t\u0002\u0005u\u0006BB\u0017\u0012\t\u0003\tY\rC\u0006\u0002NF\u0001\r\u00111A\u0005\u0002\u0005=\u0007bCAi#\u0001\u0007\t\u0019!C\u0001\u0003'D!\"!7\u0012\u0001\u0004\u0005\t\u0015)\u0003I\u0011\u001d\t\u0019/\u0005C\u0001\u0003KD\u0011\"!>\u0012\u0003\u0003%I!a>\u0003\u0019I{7m[:E\u0005N+\u0018\u000e^3\u000b\u0005iY\u0012!B:uCR,'B\u0001\u000f\u001e\u0003%\u0019HO]3b[&twM\u0003\u0002\u001f?\u0005IQ\r_3dkRLwN\u001c\u0006\u0003A\u0005\n1a]9m\u0015\t\u00113%A\u0003ta\u0006\u00148N\u0003\u0002%K\u00051\u0011\r]1dQ\u0016T\u0011AJ\u0001\u0004_J<7\u0001A\n\u0003\u0001%\u0002\"AK\u0016\u000e\u0003\u0005J!\u0001L\u0011\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f\u0003\u0019a\u0014N\\5u}Q\tq\u0006\u0005\u00021\u00015\t\u0011$\u0001\u0004xSRDGIQ\u000b\u0003g]\"R\u0001N&Y;\n$\"!N\"\u0011\u0005Y:D\u0002\u0001\u0003\u0006q\t\u0011\r!\u000f\u0002\u0002)F\u0011!\b\u0011\t\u0003wyj\u0011\u0001\u0010\u0006\u0002{\u0005)1oY1mC&\u0011q\b\u0010\u0002\b\u001d>$\b.\u001b8h!\tY\u0014)\u0003\u0002Cy\t\u0019\u0011I\\=\t\u000b\u0011\u0013\u0001\u0019A#\u0002\t\u0019,hn\u0019\t\u0005w\u0019CU'\u0003\u0002Hy\tIa)\u001e8di&|g.\r\t\u0003a%K!AS\r\u0003\u000fI{7m[:E\u0005\")AJ\u0001a\u0001\u001b\u0006I!/Z7pi\u0016$\u0015N\u001d\t\u0003\u001dVs!aT*\u0011\u0005AcT\"A)\u000b\u0005I;\u0013A\u0002\u001fs_>$h(\u0003\u0002Uy\u00051\u0001K]3eK\u001aL!AV,\u0003\rM#(/\u001b8h\u0015\t!F\bC\u0004Z\u0005A\u0005\t\u0019\u0001.\u0002\u000fY,'o]5p]B\u00111hW\u0005\u00039r\u00121!\u00138u\u0011\u001dq&\u0001%AA\u0002}\u000bAaY8oMB\u0011\u0001\u0007Y\u0005\u0003Cf\u00111BU8dWN$%iQ8oM\"91M\u0001I\u0001\u0002\u0004!\u0017A\u00035bI>|\u0007oQ8oMB\u0011Q-[\u0007\u0002M*\u0011al\u001a\u0006\u0003Q\u000e\na\u0001[1e_>\u0004\u0018B\u00016g\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u0006\u0001r/\u001b;i\t\n#C-\u001a4bk2$HEM\u000b\u0003[b,\u0012A\u001c\u0016\u00035>\\\u0013\u0001\u001d\t\u0003cZl\u0011A\u001d\u0006\u0003gR\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005Ud\u0014AC1o]>$\u0018\r^5p]&\u0011qO\u001d\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,G!\u0002\u001d\u0004\u0005\u0004I\u0014\u0001E<ji\"$%\t\n3fM\u0006,H\u000e\u001e\u00134+\tYX0F\u0001}U\tyv\u000eB\u00039\t\t\u0007\u0011(\u0001\txSRDGI\u0011\u0013eK\u001a\fW\u000f\u001c;%iU!\u0011\u0011AA\u0003+\t\t\u0019A\u000b\u0002e_\u0012)\u0001(\u0002b\u0001s\u0005iq-\u001a8fe\u0006$XMR5mKN$b!a\u0003\u0002\u0012\u0005U\u0001cA\u001e\u0002\u000e%\u0019\u0011q\u0002\u001f\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u0003'1\u0001\u0019A'\u0002\u0007\u0011L'\u000fC\u0004\u0002\u0018\u0019\u0001\r!!\u0007\u0002\u001b\u0019LG.\u001a+p\u0019\u0016tw\r\u001e5t!\u0019\tY\"!\n\u0002,9!\u0011QDA\u0011\u001d\r\u0001\u0016qD\u0005\u0002{%\u0019\u00111\u0005\u001f\u0002\u000fA\f7m[1hK&!\u0011qEA\u0015\u0005\r\u0019V-\u001d\u0006\u0004\u0003Ga\u0004#B\u001e\u0002.5S\u0016bAA\u0018y\t1A+\u001e9mKJ\n1c]1wK\u000eCWmY6q_&tGOR5mKN$\"\"a\u0003\u00026\u0005}\u0012\u0011IA\"\u0011\u001d\t9d\u0002a\u0001\u0003s\t1BZ5mK6\u000bg.Y4feB\u0019\u0001'a\u000f\n\u0007\u0005u\u0012D\u0001\nS_\u000e\\7\u000f\u0012\"GS2,W*\u00198bO\u0016\u0014\bbBA\f\u000f\u0001\u0007\u0011\u0011\u0004\u0005\u00063\u001e\u0001\rA\u0017\u0005\u0007\u0003\u000b:\u0001\u0019\u0001.\u0002\u000f9,XnS3zg\u0006aBn\\1e\u0003:$g+\u001a:jMf\u001c\u0005.Z2la>Lg\u000e\u001e$jY\u0016\u001cH\u0003DA\u0006\u0003\u0017\ni%!\u0015\u0002T\u0005]\u0003bBA\u001c\u0011\u0001\u0007\u0011\u0011\b\u0005\u0007\u0003\u001fB\u0001\u0019A'\u0002\u001fY,'/\u001b4jG\u0006$\u0018n\u001c8ESJDQ!\u0017\u0005A\u0002iCq!!\u0016\t\u0001\u0004\tI\"A\u0007fqB,7\r^3e\r&dWm\u001d\u0005\u0007\u00033B\u0001\u0019\u0001.\u0002\u001f\u0015D\b/Z2uK\u0012tU/\\&fsN\fa\u0001^8GS2,G\u0003BA0\u0003_\u0002B!!\u0019\u0002l5\u0011\u00111\r\u0006\u0005\u0003K\n9'\u0001\u0002j_*\u0011\u0011\u0011N\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002n\u0005\r$\u0001\u0002$jY\u0016Da!!\u001d\n\u0001\u0004i\u0015\u0001\u00029bi\"\fq\u0001^8BeJ\f\u0017\u0010\u0006\u0003\u0002x\u0005\r\u0005#B\u001e\u0002z\u0005u\u0014bAA>y\t)\u0011I\u001d:bsB\u00191(a \n\u0007\u0005\u0005EH\u0001\u0003CsR,\u0007BBAC\u0015\u0001\u0007Q*A\u0002tiJ\fQ\u0001^8TiJ$2!TAF\u0011\u001d\tii\u0003a\u0001\u0003o\nQAY=uKN$B!!%\u0002\u0014B)1(!\fN\u001b\"9\u0011Q\u0013\u0007A\u0002\u0005]\u0015AA6w!\r\u0001\u0014\u0011T\u0005\u0004\u00037K\"!\u0004\"zi\u0016\f%O]1z!\u0006L'/\u0001\u0005ji\u0016\u0014\u0018\r^8s)\u0011\t\t+a*\u0011\r\u0005m\u00111UAI\u0013\u0011\t)+!\u000b\u0003\u0011%#XM]1u_JDa!!+\u000e\u0001\u0004A\u0015A\u00013c\u0003%a\u0017n\u001d;GS2,7\u000f\u0006\u0003\u00020\u0006E\u0006CBA\u000e\u0003K\ty\u0006C\u0004\u00024:\u0001\r!a\u0018\u0002\t\u0019LG.\u001a\u000b\u0005\u0003_\u000b9\f\u0003\u0004\u00024>\u0001\r!T\u0001\r%>\u001c7n\u001d#C'VLG/\u001a\t\u0003aE\u0019R!EA`\u0003\u000b\u00042aOAa\u0013\r\t\u0019\r\u0010\u0002\u0007\u0003:L(+\u001a4\u0011\t\u0005\u0005\u0014qY\u0005\u0005\u0003\u0013\f\u0019G\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0006\u0002\u0002<\u0006I1/\u001b8hY\u0016$xN\\\u000b\u0002\u0011\u0006i1/\u001b8hY\u0016$xN\\0%KF$B!a\u0003\u0002V\"A\u0011q\u001b\u000b\u0002\u0002\u0003\u0007\u0001*A\u0002yIE\n!b]5oO2,Go\u001c8!Q\r)\u0012Q\u001c\t\u0004w\u0005}\u0017bAAqy\tAao\u001c7bi&dW-A\bxSRD7+\u001b8hY\u0016$xN\u001c#C+\u0011\t9/a;\u0015\t\u0005%\u0018Q\u001e\t\u0004m\u0005-H!\u0002\u001d\u0017\u0005\u0004I\u0004b\u0002#\u0017\t\u0003\u0007\u0011q\u001e\t\u0006w\u0005E\u0018\u0011^\u0005\u0004\u0003gd$\u0001\u0003\u001fcs:\fW.\u001a \u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u0005e\b\u0003BA~\u0005\u0003i!!!@\u000b\t\u0005}\u0018qM\u0001\u0005Y\u0006tw-\u0003\u0003\u0003\u0004\u0005u(AB(cU\u0016\u001cG\u000f")
public class RocksDBSuite
extends SparkFunSuite {
    public static <T> T withSingletonDB(Function0<T> function0) {
        return RocksDBSuite$.MODULE$.withSingletonDB(function0);
    }

    public static void singleton_$eq(RocksDB rocksDB) {
        RocksDBSuite$.MODULE$.singleton_$eq(rocksDB);
    }

    public static RocksDB singleton() {
        return RocksDBSuite$.MODULE$.singleton();
    }

    public <T> T withDB(String remoteDir, int version, RocksDBConf conf, Configuration hadoopConf, Function1<RocksDB, T> func) {
        Object object;
        try (RocksDB db = null;){
            String x$8 = remoteDir;
            RocksDBConf x$9 = conf;
            Configuration x$10 = hadoopConf;
            String x$11 = new StringBuilder(9).append("[Thread-").append(Thread.currentThread().getId()).append("]").toString();
            File x$12 = RocksDB$.MODULE$.$lessinit$greater$default$3();
            db = new RocksDB(x$8, x$9, x$12, x$10, x$11);
            db.load((long)version);
            object = func.apply((Object)db);
        }
        return (T)object;
    }

    public <T> int withDB$default$2() {
        return 0;
    }

    public <T> RocksDBConf withDB$default$3() {
        RocksDBConf qual$1 = RocksDBConf$.MODULE$.apply();
        boolean x$1 = false;
        int x$2 = 100;
        long x$3 = qual$1.copy$default$3();
        long x$4 = qual$1.copy$default$4();
        long x$5 = qual$1.copy$default$5();
        boolean x$6 = qual$1.copy$default$6();
        int x$7 = qual$1.copy$default$7();
        return qual$1.copy(100, false, x$3, x$4, x$5, x$6, x$7);
    }

    public <T> Configuration withDB$default$4() {
        return new Configuration();
    }

    public void generateFiles(String dir, Seq<Tuple2<String, Object>> fileToLengths) {
        fileToLengths.foreach((Function1 & Serializable)x0$1 -> {
            RocksDBSuite.$anonfun$generateFiles$1(dir, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void saveCheckpointFiles(RocksDBFileManager fileManager, Seq<Tuple2<String, Object>> fileToLengths, int version, int numKeys) {
        String checkpointDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).getAbsolutePath();
        this.generateFiles(checkpointDir, fileToLengths);
        fileManager.saveCheckpointToDfs(this.toFile(checkpointDir), (long)version, (long)numKeys);
    }

    public void loadAndVerifyCheckpointFiles(RocksDBFileManager fileManager, String verificationDir, int version, Seq<Tuple2<String, Object>> expectedFiles, int expectedNumKeys) {
        RocksDBCheckpointMetadata metadata = fileManager.loadCheckpointFromDfs((long)version, this.toFile(verificationDir));
        Set filesAndLengths = (Set)((IterableOnceOps)this.listFiles(verificationDir).map((Function1 & Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.getName()), (Object)BoxesRunTime.boxToLong((long)f.length())))).toSet().$plus$plus((IterableOnce)((IterableOnceOps)this.listFiles(new StringBuilder(8).append(verificationDir).append("/archive").toString()).map((Function1 & Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(8).append("archive/").append(f.getName()).toString()), (Object)BoxesRunTime.boxToLong((long)f.length())))).toSet());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(filesAndLengths);
        Set $org_scalatest_assert_macro_right = expectedFiles.toSet();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 503));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)metadata.numKeys()));
        int $org_scalatest_assert_macro_right2 = expectedNumKeys;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 504));
    }

    public File toFile(String path) {
        return new File(path);
    }

    public byte[] toArray(String str) {
        return str != null ? str.getBytes() : null;
    }

    public String toStr(byte[] bytes) {
        return bytes != null ? new String(bytes) : null;
    }

    public Tuple2<String, String> toStr(ByteArrayPair kv) {
        return new Tuple2((Object)this.toStr(kv.key()), (Object)this.toStr(kv.value()));
    }

    public Iterator<Tuple2<String, String>> iterator(RocksDB db) {
        return db.iterator().map((Function1 & Serializable)kv -> this.toStr((ByteArrayPair)kv));
    }

    public Seq<File> listFiles(File file2) {
        if (!file2.exists()) {
            return (Seq)package$.MODULE$.Seq().empty();
        }
        return Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])file2.listFiles()), (Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)RocksDBSuite.$anonfun$listFiles$1(file))));
    }

    public Seq<File> listFiles(String file) {
        return this.listFiles(new File(file));
    }

    public static final /* synthetic */ long $anonfun$new$2(RocksDBSuite $this, RocksDB db) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(db.get($this.toArray("a")));
        Null$ $org_scalatest_assert_macro_right = null;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
        Iterator<Tuple2<String, String>> $org_scalatest_assert_macro_left2 = $this.iterator(db);
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
        db.put($this.toArray("a"), $this.toArray("1"));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer($this.toStr(db.get($this.toArray("a"))));
        String $org_scalatest_assert_macro_right2 = "1";
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
        return db.commit();
    }

    private final void testOps$1(boolean compactOnCommit) {
        String remoteDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).toString();
        new File(remoteDir).delete();
        RocksDBConf qual$1 = RocksDBConf$.MODULE$.apply();
        boolean x$1 = compactOnCommit;
        int x$2 = qual$1.copy$default$1();
        long x$3 = qual$1.copy$default$3();
        long x$4 = qual$1.copy$default$4();
        long x$5 = qual$1.copy$default$5();
        boolean x$6 = qual$1.copy$default$6();
        int x$7 = qual$1.copy$default$7();
        RocksDBConf conf = qual$1.copy(x$2, x$1, x$3, x$4, x$5, x$6, x$7);
        String x$8 = remoteDir;
        RocksDBConf x$9 = conf;
        int x$10 = this.withDB$default$2();
        Configuration x$11 = this.withDB$default$4();
        Function1 & Serializable x$12 = (Function1 & Serializable)db -> BoxesRunTime.boxToLong((long)RocksDBSuite.$anonfun$new$2(this, db));
        this.withDB(x$8, x$10, x$9, x$11, x$12);
        String x$13 = remoteDir;
        RocksDBConf x$14 = conf;
        boolean x$15 = false;
        Configuration x$16 = this.withDB$default$4();
        Function1 & Serializable x$17 = (Function1 & Serializable)db -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.toStr(db.get(this.toArray("a"))));
            Null$ $org_scalatest_assert_macro_right = null;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
            Iterator<Tuple2<String, String>> $org_scalatest_assert_macro_left2 = this.iterator((RocksDB)db);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
        };
        this.withDB(x$13, 0, x$14, x$16, x$17);
        String x$18 = remoteDir;
        RocksDBConf x$19 = conf;
        boolean x$20 = true;
        Configuration x$21 = this.withDB$default$4();
        Function1 & Serializable x$22 = (Function1 & Serializable)db -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.toStr(db.get(this.toArray("a"))));
            String $org_scalatest_assert_macro_right = "1";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(db.iterator().map((Function1 & Serializable)kv -> this.toStr((ByteArrayPair)kv)).toSet());
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)"1")}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
            db.put(this.toArray("b"), this.toArray("2"));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(this.toStr(db.get(this.toArray("b"))));
            String $org_scalatest_assert_macro_right3 = "2";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(db.iterator().map((Function1 & Serializable)kv -> this.toStr((ByteArrayPair)kv)).toSet());
            Set $org_scalatest_assert_macro_right4 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)"1"), new Tuple2((Object)"b", (Object)"2")}));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        };
        this.withDB(x$18, 1, x$19, x$21, x$22);
        String x$23 = remoteDir;
        RocksDBConf x$24 = conf;
        boolean x$25 = true;
        Configuration x$26 = this.withDB$default$4();
        Function1 & Serializable x$27 = (Function1 & Serializable)db -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.toStr(db.get(this.toArray("a"))));
            String $org_scalatest_assert_macro_right = "1";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(db.get(this.toArray("b")));
            Null$ $org_scalatest_assert_macro_right2 = null;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", null, $org_scalatest_assert_macro_left2.$eq$eq$eq($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(db.iterator().map((Function1 & Serializable)kv -> this.toStr((ByteArrayPair)kv)).toSet());
            Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)"1")}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
            db.put(this.toArray("b"), this.toArray("2"));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(this.toStr(db.get(this.toArray("b"))));
            String $org_scalatest_assert_macro_right4 = "2";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
            db.commit();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(db.iterator().map((Function1 & Serializable)kv -> this.toStr((ByteArrayPair)kv)).toSet());
            Set $org_scalatest_assert_macro_right5 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)"1"), new Tuple2((Object)"b", (Object)"2")}));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
        };
        this.withDB(x$23, 1, x$24, x$26, x$27);
        String x$28 = remoteDir;
        RocksDBConf x$29 = conf;
        boolean x$30 = true;
        Configuration x$31 = this.withDB$default$4();
        Function1 & Serializable x$32 = (Function1 & Serializable)db -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.toStr(db.get(this.toArray("a"))));
            String $org_scalatest_assert_macro_right = "1";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(db.get(this.toArray("b")));
            Null$ $org_scalatest_assert_macro_right2 = null;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", null, $org_scalatest_assert_macro_left2.$eq$eq$eq($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
        };
        this.withDB(x$28, 1, x$29, x$31, x$32);
        String x$33 = remoteDir;
        RocksDBConf x$34 = conf;
        int x$35 = 2;
        Configuration x$36 = this.withDB$default$4();
        Function1 & Serializable x$37 = (Function1 & Serializable)db -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.toStr(db.get(this.toArray("b"))));
            String $org_scalatest_assert_macro_right = "2";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(db.iterator().map((Function1 & Serializable)kv -> this.toStr((ByteArrayPair)kv)).toSet());
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)"1"), new Tuple2((Object)"b", (Object)"2")}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
            db.load(1L);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(this.toStr(db.get(this.toArray("b"))));
            Null$ $org_scalatest_assert_macro_right3 = null;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", null, $org_scalatest_assert_macro_left3.$eq$eq$eq($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(db.iterator().map((Function1 & Serializable)kv -> this.toStr((ByteArrayPair)kv)).toSet());
            Set $org_scalatest_assert_macro_right4 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)"1")}));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
        };
        this.withDB(x$33, 2, x$34, x$36, x$37);
    }

    public static final /* synthetic */ boolean $anonfun$new$17(File x$1) {
        return x$1.getName().endsWith(".zip");
    }

    private final Seq versionsPresent$1(String remoteDir$1) {
        return Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])this.toFile(remoteDir$1).listFiles()), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)RocksDBSuite.$anonfun$new$17(x$1)))), (Function1 & Serializable)x$2 -> StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(x$2.getName()), ".zip"), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$3))), (ClassTag)ClassTag$.MODULE$.Long())), (Ordering)Ordering.Long$.MODULE$));
    }

    public static final /* synthetic */ String $anonfun$new$24(long x$4) {
        return Long.toString(x$4);
    }

    public static final /* synthetic */ Assertion $anonfun$new$22(RocksDBSuite $this, RocksDB db$1, long version) {
        db$1.load(version);
        Set data = db$1.iterator().map((Function1 & Serializable)kv -> $this.toStr((ByteArrayPair)kv)).toSet();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(data);
        Set $org_scalatest_assert_macro_right = ((IterableOnceOps)((IndexedSeqOps)new RichLong(Predef$.MODULE$.longWrapper(1L)).to((Object)BoxesRunTime.boxToLong((long)version)).map((Function1 & Serializable)x$4 -> RocksDBSuite.$anonfun$new$24(BoxesRunTime.unboxToLong((Object)x$4)))).map((Function1 & Serializable)x -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x), x))).toSet();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
    }

    public static final /* synthetic */ void $anonfun$new$20(RocksDBSuite $this, String remoteDir$1, RocksDB db) {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 50).foreach((Function1)(JFunction1.mcJI.sp & Serializable)version -> {
            db.put($this.toArray(Integer.toString(version)), $this.toArray(Integer.toString(version)));
            return db.commit();
        });
        Predef$.MODULE$.require($this.convertToEqualizer($this.versionsPresent$1(remoteDir$1)).$eq$eq$eq((Object)new RichLong(Predef$.MODULE$.longWrapper(1L)).to((Object)BoxesRunTime.boxToLong((long)50L)), Equality$.MODULE$.default()));
        File sstDir = new File(remoteDir$1, "SSTs");
        int numSstFiles = $this.listFiles(sstDir).length();
        db.cleanup();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer($this.versionsPresent$1(remoteDir$1));
        NumericRange.Inclusive $org_scalatest_assert_macro_right = new RichLong(Predef$.MODULE$.longWrapper(41L)).to((Object)BoxesRunTime.boxToLong((long)50L));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
        int $org_scalatest_assert_macro_left2 = $this.listFiles(sstDir).length();
        int $org_scalatest_assert_macro_right2 = numSstFiles;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 < $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
        $this.versionsPresent$1(remoteDir$1).foreach((Function1 & Serializable)version -> RocksDBSuite.$anonfun$new$22($this, db, BoxesRunTime.unboxToLong((Object)version)));
    }

    public static final /* synthetic */ String $anonfun$new$29(long x$5) {
        return Long.toString(x$5);
    }

    private final int numRemoteSSTFiles$1(String sstDir$1) {
        return this.listFiles(sstDir$1).length();
    }

    private final int numRemoteLogFiles$1(String logDir$1) {
        return this.listFiles(logDir$1).length();
    }

    public static final /* synthetic */ void $anonfun$new$36(RocksDBSuite $this, File dir) {
        String dfsRootDir = dir.getAbsolutePath();
        String verificationDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).getAbsolutePath();
        RocksDBFileManager fileManager = new RocksDBFileManager(dfsRootDir, Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()), new Configuration(), RocksDBFileManager$.MODULE$.$lessinit$greater$default$4());
        String sstDir = new StringBuilder(5).append(dfsRootDir).append("/SSTs").toString();
        String logDir = new StringBuilder(5).append(dfsRootDir).append("/logs").toString();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)fileManager.getLatestVersion()));
        int $org_scalatest_assert_macro_right = 0;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
        $this.intercept((Function0 & Serializable)() -> fileManager.loadCheckpointFromDfs(1L, Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2())), ClassTag$.MODULE$.apply(FileNotFoundException.class), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
        Seq cpFiles1 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sst-file1.sst"), (Object)BoxesRunTime.boxToInteger((int)10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sst-file2.sst"), (Object)BoxesRunTime.boxToInteger((int)20)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"other-file1"), (Object)BoxesRunTime.boxToInteger((int)100)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"other-file2"), (Object)BoxesRunTime.boxToInteger((int)200)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"archive/00001.log"), (Object)BoxesRunTime.boxToInteger((int)1000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"archive/00002.log"), (Object)BoxesRunTime.boxToInteger((int)2000))}));
        $this.saveCheckpointFiles(fileManager, (Seq<Tuple2<String, Object>>)cpFiles1, 1, 101);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)fileManager.getLatestVersion()));
        int $org_scalatest_assert_macro_right2 = 1;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
        int $org_scalatest_assert_macro_left3 = $this.numRemoteSSTFiles$1(sstDir);
        int $org_scalatest_assert_macro_right3 = 2;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
        int $org_scalatest_assert_macro_left4 = $this.numRemoteLogFiles$1(logDir);
        int $org_scalatest_assert_macro_right4 = 2;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
        $this.generateFiles(verificationDir, (Seq<Tuple2<String, Object>>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sst-file1.sst"), (Object)BoxesRunTime.boxToInteger((int)11)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"other-file1"), (Object)BoxesRunTime.boxToInteger((int)101)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"archive/00001.log"), (Object)BoxesRunTime.boxToInteger((int)1001)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"random-sst-file.sst"), (Object)BoxesRunTime.boxToInteger((int)100)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"random-other-file"), (Object)BoxesRunTime.boxToInteger((int)9)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"00005.log"), (Object)BoxesRunTime.boxToInteger((int)101)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"archive/00007.log"), (Object)BoxesRunTime.boxToInteger((int)101))}))));
        $this.loadAndVerifyCheckpointFiles(fileManager, verificationDir, 1, (Seq<Tuple2<String, Object>>)cpFiles1, 101);
        Seq cpFiles1_ = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sst-file1.sst"), (Object)BoxesRunTime.boxToInteger((int)10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sst-file2.sst"), (Object)BoxesRunTime.boxToInteger((int)25)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sst-file3.sst"), (Object)BoxesRunTime.boxToInteger((int)30)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"other-file1"), (Object)BoxesRunTime.boxToInteger((int)100)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"other-file2"), (Object)BoxesRunTime.boxToInteger((int)210)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"other-file3"), (Object)BoxesRunTime.boxToInteger((int)300)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"archive/00001.log"), (Object)BoxesRunTime.boxToInteger((int)1000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"archive/00002.log"), (Object)BoxesRunTime.boxToInteger((int)2500)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"archive/00003.log"), (Object)BoxesRunTime.boxToInteger((int)3000))}));
        $this.saveCheckpointFiles(fileManager, (Seq<Tuple2<String, Object>>)cpFiles1_, 1, 1001);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)$this.numRemoteSSTFiles$1(sstDir)));
        int $org_scalatest_assert_macro_right5 = 4;
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"shouldn't copy same files again", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)$this.numRemoteLogFiles$1(logDir)));
        int $org_scalatest_assert_macro_right6 = 4;
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"shouldn't copy same files again", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 231));
        $this.loadAndVerifyCheckpointFiles(fileManager, verificationDir, 1, (Seq<Tuple2<String, Object>>)cpFiles1_, 1001);
        Seq cpFiles2 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sst-file4.sst"), (Object)BoxesRunTime.boxToInteger((int)40)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"other-file4"), (Object)BoxesRunTime.boxToInteger((int)400)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"archive/00004.log"), (Object)BoxesRunTime.boxToInteger((int)4000))}));
        $this.saveCheckpointFiles(fileManager, (Seq<Tuple2<String, Object>>)cpFiles2, 2, 1501);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)$this.numRemoteSSTFiles$1(sstDir)));
        int $org_scalatest_assert_macro_right7 = 5;
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)$this.numRemoteLogFiles$1(logDir)));
        int $org_scalatest_assert_macro_right8 = 5;
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
        $this.loadAndVerifyCheckpointFiles(fileManager, verificationDir, 2, (Seq<Tuple2<String, Object>>)cpFiles2, 1501);
        $this.loadAndVerifyCheckpointFiles(fileManager, verificationDir, 1, (Seq<Tuple2<String, Object>>)cpFiles1_, 1001);
        $this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.loadAndVerifyCheckpointFiles(fileManager, verificationDir, 3, (Seq<Tuple2<String, Object>>)package$.MODULE$.Nil(), 1001), ClassTag$.MODULE$.apply(FileNotFoundException.class), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 249));
        Predef$.MODULE$.require($this.toFile(verificationDir).list().length > 0);
        $this.loadAndVerifyCheckpointFiles(fileManager, verificationDir, 0, (Seq<Tuple2<String, Object>>)package$.MODULE$.Nil(), 0);
    }

    public static final /* synthetic */ long $anonfun$new$44(RocksDBSuite $this, RocksDB db) {
        db.load(0L);
        IllegalStateException ex = (IllegalStateException)$this.intercept((Function0 & Serializable)() -> (RocksDB)ThreadUtils$.MODULE$.runInNewThread("concurrent-test-thread-1", ThreadUtils$.MODULE$.runInNewThread$default$2(), (Function0 & Serializable)() -> db.load(0L)), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 286));
        String $org_scalatest_assert_macro_left = ex.getMessage();
        String $org_scalatest_assert_macro_right = "Thread holding the lock has trace:";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 290));
        String $org_scalatest_assert_macro_left2 = ex.getMessage();
        String $org_scalatest_assert_macro_right2 = "runInNewThread";
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 291));
        db.commit();
        ThreadUtils$.MODULE$.runInNewThread("concurrent-test-thread-2", ThreadUtils$.MODULE$.runInNewThread$default$2(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> {
            db.load(1L);
            return db.commit();
        });
        db.load(2L);
        $this.intercept((Function0 & Serializable)() -> (RocksDB)ThreadUtils$.MODULE$.runInNewThread("concurrent-test-thread-2", ThreadUtils$.MODULE$.runInNewThread$default$2(), (Function0 & Serializable)() -> db.load(2L)), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 302));
        db.rollback();
        return BoxesRunTime.unboxToLong((Object)ThreadUtils$.MODULE$.runInNewThread("concurrent-test-thread-3", ThreadUtils$.MODULE$.runInNewThread$default$2(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> {
            db.load(1L);
            return db.commit();
        }));
    }

    public static final /* synthetic */ Nothing$ $anonfun$new$55(int i) {
        RocksDBSuite$.MODULE$.singleton().load(0L);
        throw new Exception("fail this task to test lock release");
    }

    public static final /* synthetic */ void $anonfun$new$57(String json$1, RocksDBCheckpointMetadata metadata$1, File dir) {
        File file = new File(dir, "json");
        FileUtils.write((File)file, (CharSequence)new StringBuilder(3).append("v1\n").append(json$1).toString(), (Charset)Charset.defaultCharset());
        RocksDBCheckpointMetadata $org_scalatest_assert_macro_left = metadata$1;
        RocksDBCheckpointMetadata $org_scalatest_assert_macro_right = RocksDBCheckpointMetadata$.MODULE$.readFromFile(file);
        RocksDBCheckpointMetadata rocksDBCheckpointMetadata = $org_scalatest_assert_macro_left;
        RocksDBCheckpointMetadata rocksDBCheckpointMetadata2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(rocksDBCheckpointMetadata != null ? !rocksDBCheckpointMetadata.equals(rocksDBCheckpointMetadata2) : rocksDBCheckpointMetadata2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 346));
    }

    private final void checkJsonRoundtrip$1(RocksDBCheckpointMetadata metadata, String json) {
        String $org_scalatest_assert_macro_left = metadata.json();
        String $org_scalatest_assert_macro_right = json;
        String string = $org_scalatest_assert_macro_left;
        String string2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 342));
        this.withTempDir((Function1 & Serializable)dir -> {
            RocksDBSuite.$anonfun$new$57(json, metadata, dir);
            return BoxedUnit.UNIT;
        });
    }

    private final void verifyMetrics$1(long putCount, long getCount, boolean iterCountPositive, RocksDBMetrics metrics) {
        Assertion assertion;
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)((RocksDBNativeHistogram)metrics.nativeOpsHistograms().apply((Object)"put")).count()));
        long $org_scalatest_assert_macro_right = putCount;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"invalid put count", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 372));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)((RocksDBNativeHistogram)metrics.nativeOpsHistograms().apply((Object)"get")).count()));
        long $org_scalatest_assert_macro_right2 = getCount;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"invalid get count", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 373));
        if (iterCountPositive) {
            long $org_scalatest_assert_macro_left3 = BoxesRunTime.unboxToLong((Object)metrics.nativeOpsMetrics().apply((Object)"totalBytesReadThroughIterator"));
            int $org_scalatest_assert_macro_right3 = 0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 > (long)$org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 375));
        } else {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(metrics.nativeOpsMetrics().apply((Object)"totalBytesReadThroughIterator"));
            int $org_scalatest_assert_macro_right4 = 0;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 377));
        }
        long $org_scalatest_assert_macro_left5 = BoxesRunTime.unboxToLong((Object)metrics.nativeOpsMetrics().apply((Object)"totalBytesRead"));
        int $org_scalatest_assert_macro_right5 = 0;
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left5), ">=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 >= (long)$org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 381));
        long $org_scalatest_assert_macro_left6 = BoxesRunTime.unboxToLong((Object)metrics.nativeOpsMetrics().apply((Object)"totalBytesWritten"));
        long $org_scalatest_assert_macro_right6 = putCount * 1L;
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left6), ">=", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 >= $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 382));
        RocksDBNativeHistogram $org_scalatest_assert_macro_left7 = (RocksDBNativeHistogram)metrics.nativeOpsHistograms().apply((Object)"compaction");
        Object $org_scalatest_assert_macro_right7 = null;
        RocksDBNativeHistogram rocksDBNativeHistogram = $org_scalatest_assert_macro_left7;
        Object var34_25 = null;
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "!=", null, rocksDBNativeHistogram == null ? var34_25 != null : !rocksDBNativeHistogram.equals(var34_25), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 384));
        long $org_scalatest_assert_macro_left8 = BoxesRunTime.unboxToLong((Object)metrics.nativeOpsMetrics().apply((Object)"readBlockCacheMissCount"));
        int $org_scalatest_assert_macro_right8 = 0;
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left8), ">=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8 >= (long)$org_scalatest_assert_macro_right8, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 385));
        long $org_scalatest_assert_macro_left9 = BoxesRunTime.unboxToLong((Object)metrics.nativeOpsMetrics().apply((Object)"readBlockCacheHitCount"));
        int $org_scalatest_assert_macro_right9 = 0;
        Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left9), ">=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9 >= (long)$org_scalatest_assert_macro_right9, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 386));
        long $org_scalatest_assert_macro_left10 = BoxesRunTime.unboxToLong((Object)metrics.nativeOpsMetrics().apply((Object)"writerStallDuration"));
        int $org_scalatest_assert_macro_right10 = 0;
        Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left10), ">=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10 >= (long)$org_scalatest_assert_macro_right10, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 388));
        long $org_scalatest_assert_macro_left11 = BoxesRunTime.unboxToLong((Object)metrics.nativeOpsMetrics().apply((Object)"totalBytesReadByCompaction"));
        int $org_scalatest_assert_macro_right11 = 0;
        Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left11), ">=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left11 >= (long)$org_scalatest_assert_macro_right11, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 389));
        long $org_scalatest_assert_macro_left12 = BoxesRunTime.unboxToLong((Object)metrics.nativeOpsMetrics().apply((Object)"totalBytesWrittenByCompaction"));
        int $org_scalatest_assert_macro_right12 = 0;
        Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left12), ">=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right12), $org_scalatest_assert_macro_left12 >= (long)$org_scalatest_assert_macro_right12, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 390));
    }

    private static final boolean verifyMetrics$default$3$1() {
        return false;
    }

    public static final /* synthetic */ void $anonfun$new$60(RocksDBSuite $this, RocksDB db) {
        long x$37 = 0L;
        long x$38 = 0L;
        RocksDBMetrics x$39 = db.metrics();
        boolean x$40 = RocksDBSuite.verifyMetrics$default$3$1();
        $this.verifyMetrics$1(0L, 0L, x$40, x$39);
        db.load(0L);
        db.put($this.toArray("a"), $this.toArray("1"));
        db.get($this.toArray("a"));
        db.get($this.toArray("b"));
        db.commit();
        long x$41 = 1L;
        long x$42 = 2L;
        RocksDBMetrics x$43 = db.metrics();
        boolean x$44 = RocksDBSuite.verifyMetrics$default$3$1();
        $this.verifyMetrics$1(1L, 2L, x$44, x$43);
        db.load(1L);
        db.put($this.toArray("b"), $this.toArray("2"));
        db.get($this.toArray("a"));
        db.get($this.toArray("c"));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer($this.iterator(db).toSet());
        Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)"1"), new Tuple2((Object)"b", (Object)"2")}));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 408));
        db.commit();
        $this.verifyMetrics$1(1L, 3L, true, db.metrics());
    }

    public static final /* synthetic */ void $anonfun$new$59(RocksDBSuite $this, File dir) {
        String remoteDir = dir.getCanonicalPath();
        $this.withDB(remoteDir, $this.withDB$default$2(), $this.withDB$default$3(), $this.withDB$default$4(), (Function1 & Serializable)db -> {
            RocksDBSuite.$anonfun$new$60($this, db);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$62(RocksDBSuite $this, RocksDB db) {
        long x$56 = 0L;
        long x$57 = 0L;
        RocksDBMetrics x$58 = db.metrics();
        boolean x$59 = RocksDBSuite.verifyMetrics$default$3$1();
        $this.verifyMetrics$1(0L, 0L, x$59, x$58);
        db.load(0L);
        db.put($this.toArray("a"), $this.toArray("1"));
        db.commit();
        long x$60 = 1L;
        long x$61 = 1L;
        RocksDBMetrics x$62 = db.metrics();
        boolean x$63 = RocksDBSuite.verifyMetrics$default$3$1();
        $this.verifyMetrics$1(1L, 1L, x$63, x$62);
        db.load(1L);
        db.put($this.toArray("b"), $this.toArray("2"));
        db.get($this.toArray("a"));
        db.commit();
        long x$64 = 2L;
        long x$65 = 3L;
        RocksDBMetrics x$66 = db.metrics();
        boolean x$67 = RocksDBSuite.verifyMetrics$default$3$1();
        $this.verifyMetrics$1(2L, 3L, x$67, x$66);
    }

    public static final /* synthetic */ void $anonfun$new$61(RocksDBSuite $this, File dir) {
        String remoteDir;
        String x$52 = remoteDir = dir.getCanonicalPath();
        RocksDBConf qual$4 = RocksDBConf$.MODULE$.apply();
        boolean x$45 = false;
        int x$46 = qual$4.copy$default$1();
        boolean x$47 = qual$4.copy$default$2();
        long x$48 = qual$4.copy$default$3();
        long x$49 = qual$4.copy$default$4();
        long x$50 = qual$4.copy$default$5();
        int x$51 = qual$4.copy$default$7();
        RocksDBConf x$53 = qual$4.copy(x$46, x$47, x$48, x$49, x$50, false, x$51);
        int x$54 = $this.withDB$default$2();
        Configuration x$55 = $this.withDB$default$4();
        Function1 & Serializable x$68 = (Function1 & Serializable)db -> {
            RocksDBSuite.$anonfun$new$62($this, db);
            return BoxedUnit.UNIT;
        };
        $this.withDB(x$52, x$54, x$53, x$55, x$68);
    }

    public static final /* synthetic */ void $anonfun$new$63(RocksDBSuite $this, File dir) {
        String remoteDir;
        String x$76 = remoteDir = dir.getCanonicalPath();
        RocksDBConf qual$5 = RocksDBConf$.MODULE$.apply();
        boolean x$69 = true;
        int x$70 = qual$5.copy$default$1();
        long x$71 = qual$5.copy$default$3();
        long x$72 = qual$5.copy$default$4();
        long x$73 = qual$5.copy$default$5();
        boolean x$74 = qual$5.copy$default$6();
        int x$75 = qual$5.copy$default$7();
        RocksDBConf x$77 = qual$5.copy(x$70, true, x$71, x$72, x$73, x$74, x$75);
        int x$78 = $this.withDB$default$2();
        Configuration x$79 = $this.withDB$default$4();
        Function1 & Serializable x$80 = (Function1 & Serializable)db -> {
            db.load(0L);
            db.put($this.toArray("a"), $this.toArray("5"));
            db.put($this.toArray("b"), $this.toArray("5"));
            db.commit();
            db.load(1L);
            db.put($this.toArray("a"), $this.toArray("10"));
            db.put($this.toArray("b"), $this.toArray("25"));
            db.commit();
            RocksDBMetrics metrics = db.metrics();
            long $org_scalatest_assert_macro_left = ((RocksDBNativeHistogram)metrics.nativeOpsHistograms().apply((Object)"compaction")).count();
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 449));
            long $org_scalatest_assert_macro_left2 = BoxesRunTime.unboxToLong((Object)metrics.nativeOpsMetrics().apply((Object)"totalBytesReadByCompaction"));
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 > (long)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 450));
            long $org_scalatest_assert_macro_left3 = BoxesRunTime.unboxToLong((Object)metrics.nativeOpsMetrics().apply((Object)"totalBytesWrittenByCompaction"));
            int $org_scalatest_assert_macro_right3 = 0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 > (long)$org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 451));
        };
        $this.withDB(x$76, x$78, x$77, x$79, x$80);
    }

    public static final /* synthetic */ void $anonfun$generateFiles$1(String dir$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String fileName = (String)tuple2._1();
        int length = tuple2._2$mcI$sp();
        File file = new File(dir$1, fileName);
        FileUtils.write((File)file, (CharSequence)StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("a"), length));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$listFiles$1(File file) {
        return !file.getName().endsWith("crc") && !file.isDirectory();
    }

    public RocksDBSuite() {
        this.test("RocksDB: get, put, iterator, commit, load", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true})).foreach((Function1 & Serializable)compactOnCommit -> {
            this.withClue(new StringBuilder(18).append("compactOnCommit = ").append(BoxesRunTime.unboxToBoolean((Object)compactOnCommit)).toString(), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.testOps$1(BoxesRunTime.unboxToBoolean((Object)compactOnCommit)));
            return BoxedUnit.UNIT;
        }), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 36));
        this.test("RocksDB: cleanup old files", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String remoteDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).toString();
            RocksDBConf qual$1 = RocksDBConf$.MODULE$.apply();
            boolean x$1 = true;
            int x$2 = 10;
            long x$3 = qual$1.copy$default$3();
            long x$4 = qual$1.copy$default$4();
            long x$5 = qual$1.copy$default$5();
            boolean x$6 = qual$1.copy$default$6();
            int x$7 = qual$1.copy$default$7();
            RocksDBConf conf = qual$1.copy(10, true, x$3, x$4, x$5, x$6, x$7);
            String x$8 = remoteDir;
            RocksDBConf x$9 = conf;
            int x$10 = this.withDB$default$2();
            Configuration x$11 = this.withDB$default$4();
            Function1 & Serializable x$12 = (Function1 & Serializable)db -> {
                RocksDBSuite.$anonfun$new$20(this, remoteDir, db);
                return BoxedUnit.UNIT;
            };
            this.withDB(x$8, x$10, x$9, x$11, x$12);
        }, new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        this.test("RocksDB: handle commit failures and aborts", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Configuration hadoopConf = new Configuration();
            hadoopConf.set(SQLConf$.MODULE$.STREAMING_CHECKPOINT_FILE_MANAGER_CLASS().parent().key(), CreateAtomicTestManager.class.getName());
            String remoteDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).getAbsolutePath();
            RocksDBConf qual$2 = RocksDBConf$.MODULE$.apply();
            boolean x$13 = true;
            int x$14 = qual$2.copy$default$1();
            long x$15 = qual$2.copy$default$3();
            long x$16 = qual$2.copy$default$4();
            long x$17 = qual$2.copy$default$5();
            boolean x$18 = qual$2.copy$default$6();
            int x$19 = qual$2.copy$default$7();
            RocksDBConf conf = qual$2.copy(x$14, true, x$15, x$16, x$17, x$18, x$19);
            String x$20 = remoteDir;
            RocksDBConf x$21 = conf;
            Configuration x$22 = hadoopConf;
            int x$23 = this.withDB$default$2();
            Function1 & Serializable x$24 = (Function1 & Serializable)db -> {
                CreateAtomicTestManager$.MODULE$.shouldFailInCreateAtomic_$eq(false);
                RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).foreach((Function1)(JFunction1.mcJI.sp & Serializable)version -> {
                    db.put(this.toArray(Integer.toString(version)), this.toArray(Integer.toString(version)));
                    return db.commit();
                });
                Set version10Data = ((IterableOnceOps)((IndexedSeqOps)new RichLong(Predef$.MODULE$.longWrapper(1L)).to((Object)BoxesRunTime.boxToLong((long)10L)).map((Function1 & Serializable)x$5 -> RocksDBSuite.$anonfun$new$29(BoxesRunTime.unboxToLong((Object)x$5)))).map((Function1 & Serializable)x -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x), x))).toSet();
                CreateAtomicTestManager$.MODULE$.shouldFailInCreateAtomic_$eq(true);
                db.put(this.toArray("11"), this.toArray("11"));
                this.intercept((Function0)(JFunction0.mcJ.sp & Serializable)() -> BoxesRunTime.unboxToLong((Object)org.apache.spark.sql.catalyst.util.package$.MODULE$.quietly((Function0)(JFunction0.mcJ.sp & Serializable)() -> db.commit())), ClassTag$.MODULE$.apply(IOException.class), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(db.load(10L).iterator().map((Function1 & Serializable)kv -> this.toStr((ByteArrayPair)kv)).toSet());
                Set $org_scalatest_assert_macro_right = version10Data;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
                CreateAtomicTestManager$.MODULE$.shouldFailInCreateAtomic_$eq(false);
                db.load(10L);
                db.put(this.toArray("11"), this.toArray("11"));
                db.rollback();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(db.load(10L).iterator().map((Function1 & Serializable)kv -> this.toStr((ByteArrayPair)kv)).toSet());
                Set $org_scalatest_assert_macro_right2 = version10Data;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
            };
            return (Assertion)this.withDB(x$20, x$23, x$21, x$22, x$24);
        }, new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
        this.test("RocksDBFileManager: upload only new immutable files", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1 & Serializable)dir -> {
            RocksDBSuite.$anonfun$new$36(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
        this.test("RocksDBFileManager: error writing [version].zip cancels the output stream", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (Assertion)org.apache.spark.sql.catalyst.util.package$.MODULE$.quietly((Function0 & Serializable)() -> {
            Configuration hadoopConf = new Configuration();
            hadoopConf.set(SQLConf$.MODULE$.STREAMING_CHECKPOINT_FILE_MANAGER_CLASS().parent().key(), CreateAtomicTestManager.class.getName());
            String dfsRootDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).getAbsolutePath();
            RocksDBFileManager fileManager = new RocksDBFileManager(dfsRootDir, Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()), hadoopConf, RocksDBFileManager$.MODULE$.$lessinit$greater$default$4());
            Seq cpFiles = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sst-file1.sst"), (Object)BoxesRunTime.boxToInteger((int)10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sst-file2.sst"), (Object)BoxesRunTime.boxToInteger((int)20)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"other-file1"), (Object)BoxesRunTime.boxToInteger((int)100))}));
            CreateAtomicTestManager$.MODULE$.shouldFailInCreateAtomic_$eq(true);
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.saveCheckpointFiles(fileManager, (Seq<Tuple2<String, Object>>)cpFiles, 1, 101), ClassTag$.MODULE$.apply(IOException.class), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 269));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(CreateAtomicTestManager$.MODULE$.cancelCalledInCreateAtomic(), "org.apache.spark.sql.execution.streaming.CreateAtomicTestManager.cancelCalledInCreateAtomic", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 272));
        }), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 259));
        this.test("disallow concurrent updates to the same RocksDB instance", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcJ.sp & Serializable)() -> BoxesRunTime.unboxToLong((Object)org.apache.spark.sql.catalyst.util.package$.MODULE$.quietly((Function0)(JFunction0.mcJ.sp & Serializable)() -> {
            String x$32 = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).toString();
            RocksDBConf qual$3 = RocksDBConf$.MODULE$.apply();
            long x$25 = 20L;
            int x$26 = qual$3.copy$default$1();
            boolean x$27 = qual$3.copy$default$2();
            long x$28 = qual$3.copy$default$3();
            long x$29 = qual$3.copy$default$4();
            boolean x$30 = qual$3.copy$default$6();
            int x$31 = qual$3.copy$default$7();
            RocksDBConf x$33 = qual$3.copy(x$26, x$27, x$28, x$29, 20L, x$30, x$31);
            int x$34 = this.withDB$default$2();
            Configuration x$35 = this.withDB$default$4();
            Function1 & Serializable x$36 = (Function1 & Serializable)db -> BoxesRunTime.boxToLong((long)RocksDBSuite.$anonfun$new$44(this, db));
            return BoxesRunTime.unboxToLong(this.withDB(x$32, x$34, x$33, x$35, x$36));
        })), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276));
        this.test("ensure concurrent access lock is released after Spark task completes", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Object t;
            SparkConf conf = new SparkConf().setAppName("test").setMaster("local");
            SparkContext sc = new SparkContext(conf);
            try {
                t = RocksDBSuite$.MODULE$.withSingletonDB((Function0 & Serializable)() -> {
                    org.apache.spark.sql.catalyst.util.package$.MODULE$.quietly((Function0 & Serializable)() -> (Exception)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable)() -> sc.makeRDD((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 1), 1, (ClassTag)ClassTag$.MODULE$.Int()).map((Function1 & Serializable)i -> RocksDBSuite.$anonfun$new$55(BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.Nothing()).count(), ClassTag$.MODULE$.apply(Exception.class), new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 324)));
                    return RocksDBSuite$.MODULE$.singleton().load(0L);
                });
            }
            finally {
                sc.stop();
            }
            return t;
        }, new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 316));
        this.test("checkpoint metadata serde roundtrip", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Seq sstFiles = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new RocksDBSstFile[]{new RocksDBSstFile("00001.sst", "00001-uuid.sst", 12345678901234L)}));
            Seq logFiles = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new RocksDBLogFile[]{new RocksDBLogFile("00001.log", "00001-uuid.log", 12345678901234L)}));
            this.checkJsonRoundtrip$1(RocksDBCheckpointMetadata$.MODULE$.apply((Seq)package$.MODULE$.Seq().empty(), 0L), "{\"sstFiles\":[],\"numKeys\":0}");
            this.checkJsonRoundtrip$1(RocksDBCheckpointMetadata$.MODULE$.apply(sstFiles, 12345678901234L), "{\"sstFiles\":[{\"localFileName\":\"00001.sst\",\"dfsSstFileName\":\"00001-uuid.sst\",\"sizeBytes\":12345678901234}],\"numKeys\":12345678901234}");
            this.checkJsonRoundtrip$1(new RocksDBCheckpointMetadata(sstFiles, logFiles, 12345678901234L), "{\"sstFiles\":[{\"localFileName\":\"00001.sst\",\"dfsSstFileName\":\"00001-uuid.sst\",\"sizeBytes\":12345678901234}],\"logFiles\":[{\"localFileName\":\"00001.log\",\"dfsLogFileName\":\"00001-uuid.log\",\"sizeBytes\":12345678901234}],\"numKeys\":12345678901234}");
        }, new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 340));
        this.test("SPARK-36236: reset RocksDB metrics whenever a new version is loaded", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.withTempDir((Function1 & Serializable)dir -> {
                RocksDBSuite.$anonfun$new$59(this, dir);
                return BoxedUnit.UNIT;
            });
            this.withTempDir((Function1 & Serializable)dir -> {
                RocksDBSuite.$anonfun$new$61(this, dir);
                return BoxedUnit.UNIT;
            });
            this.withTempDir((Function1 & Serializable)dir -> {
                RocksDBSuite.$anonfun$new$63(this, dir);
                return BoxedUnit.UNIT;
            });
        }, new Position("RocksDBSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 369));
    }
}

