/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.spark.rdd.RDD;
import org.apache.spark.scheduler.ExecutorCacheTaskLocation;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.exchange.ShuffleExchangeExec;
import org.apache.spark.sql.execution.streaming.MemoryStream;
import org.apache.spark.sql.execution.streaming.MemoryStream$;
import org.apache.spark.sql.execution.streaming.StatefulOperatorStateInfo;
import org.apache.spark.sql.execution.streaming.StreamExecution;
import org.apache.spark.sql.execution.streaming.StreamingSymmetricHashJoinExec;
import org.apache.spark.sql.execution.streaming.StreamingSymmetricHashJoinHelper$;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef;
import org.apache.spark.sql.execution.streaming.state.StateStoreProviderId;
import org.apache.spark.sql.execution.streaming.state.StateStoreProviderId$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.streaming.StreamTest;
import org.apache.spark.sql.streaming.StreamingInnerJoinSuite$;
import org.apache.spark.sql.streaming.StreamingJoinSuite;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.streaming.Trigger;
import org.apache.spark.util.Clock;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple6;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0005Y1AAA\u0002\u0001\u001d!)1\u0003\u0001C\u0001)\t92\u000b\u001e:fC6LgnZ%o]\u0016\u0014(j\\5o'VLG/\u001a\u0006\u0003\t\u0015\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\u00199\u0011aA:rY*\u0011\u0001\"C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0015-\ta!\u00199bG\",'\"\u0001\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001y\u0001C\u0001\t\u0012\u001b\u0005\u0019\u0011B\u0001\n\u0004\u0005I\u0019FO]3b[&twMS8j]N+\u0018\u000e^3\u0002\rqJg.\u001b;?)\u0005)\u0002C\u0001\t\u0001\u0001")
public class StreamingInnerJoinSuite
extends StreamingJoinSuite {
    public static final /* synthetic */ Seq $anonfun$new$13(Seq storeNames$1, int partIndex) {
        return (Seq)storeNames$1.map((Function1 & Serializable)storeName -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)partIndex), storeName)), (Object)new StringBuilder(6).append("host-").append(partIndex).append("-").append((String)storeName).toString()));
    }

    public static final /* synthetic */ void $anonfun$new$15(StreamingInnerJoinSuite $this, StatefulOperatorStateInfo stateInfo$1, StateStoreCoordinatorRef coordinatorRef$1, Tuple2 x0$1) {
        String hostName;
        Tuple2 tuple2;
        block3: {
            Tuple2 tuple22;
            block2: {
                tuple22 = x0$1;
                if (tuple22 == null) break block2;
                tuple2 = (Tuple2)tuple22._1();
                hostName = (String)tuple22._2();
                if (tuple2 != null) break block3;
            }
            throw new MatchError((Object)tuple22);
        }
        int partIndex = tuple2._1$mcI$sp();
        String storeName = (String)tuple2._2();
        StateStoreProviderId providerId = StateStoreProviderId$.MODULE$.apply(stateInfo$1, partIndex, storeName);
        coordinatorRef$1.reportActiveInstance(providerId, hostName, new StringBuilder(5).append("exec-").append(hostName).toString(), (Seq)scala.package$.MODULE$.Seq().empty());
        Predef$.MODULE$.require($this.convertToEqualizer(coordinatorRef$1.getLocation(providerId)).$eq$eq$eq((Object)new Some((Object)new ExecutorCacheTaskLocation(hostName, new StringBuilder(5).append("exec-").append(hostName).toString()).toString()), Equality$.MODULE$.default()));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ String $anonfun$new$16(int x$7) {
        return Integer.toString(x$7);
    }

    public static final /* synthetic */ Assertion $anonfun$new$18(StreamingInnerJoinSuite $this, Seq storeNames$1, Map partitionAndStoreNameToLocation$1, RDD rdd$1, int partIndex) {
        Set expectedLocations = ((IterableOnceOps)storeNames$1.map((Function1 & Serializable)storeName -> {
            String hostName = (String)partitionAndStoreNameToLocation$1.apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)partIndex), storeName));
            return new ExecutorCacheTaskLocation(hostName, new StringBuilder(5).append("exec-").append(hostName).toString()).toString();
        })).toSet();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(rdd$1.preferredLocations(rdd$1.partitions()[partIndex]).toSet());
        Set $org_scalatest_assert_macro_right = expectedLocations;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingJoinSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 549));
    }

    public static final /* synthetic */ void $anonfun$new$12(StreamingInnerJoinSuite $this, File tempDir) {
        UUID queryId = UUID.randomUUID();
        int opId = 0;
        String path = Utils$.MODULE$.createDirectory(tempDir.getAbsolutePath(), Float.toString(Random$.MODULE$.nextFloat())).toString();
        StatefulOperatorStateInfo stateInfo = new StatefulOperatorStateInfo(path, queryId, (long)opId, 0L, 5);
        SQLContext sqlContext = $this.spark().sqlContext();
        StateStoreCoordinatorRef coordinatorRef = sqlContext.streams().stateStoreCoordinator();
        int numPartitions = 5;
        Seq storeNames = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"name1", "name2"}));
        Map partitionAndStoreNameToLocation = ((IterableOnceOps)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numPartitions).flatMap((Function1 & Serializable)partIndex -> StreamingInnerJoinSuite.$anonfun$new$13(storeNames, BoxesRunTime.unboxToInt((Object)partIndex)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        partitionAndStoreNameToLocation.foreach((Function1 & Serializable)x0$1 -> {
            StreamingInnerJoinSuite.$anonfun$new$15($this, stateInfo, coordinatorRef, x0$1);
            return BoxedUnit.UNIT;
        });
        RDD rdd1 = $this.spark().sparkContext().makeRDD((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10), numPartitions, (ClassTag)ClassTag$.MODULE$.Int());
        RDD rdd2 = $this.spark().sparkContext().makeRDD((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable)x$7 -> StreamingInnerJoinSuite.$anonfun$new$16(BoxesRunTime.unboxToInt((Object)x$7))), numPartitions, ClassTag$.MODULE$.apply(String.class));
        RDD rdd = StreamingSymmetricHashJoinHelper$.MODULE$.StateStoreAwareZipPartitionsHelper(rdd1, (ClassTag)ClassTag$.MODULE$.Int()).stateStoreAwareZipPartitions(rdd2, stateInfo, storeNames, coordinatorRef, (Function3 & Serializable)(x$8, left, right) -> left.zip((IterableOnce)right), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Tuple2.class));
        Predef$.MODULE$.require($this.convertToEqualizer(BoxesRunTime.boxToInteger((int)rdd.partitions().length)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)numPartitions), Equality$.MODULE$.default()));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numPartitions).foreach((Function1 & Serializable)partIndex -> StreamingInnerJoinSuite.$anonfun$new$18($this, storeNames, partitionAndStoreNameToLocation, rdd, BoxesRunTime.unboxToInt((Object)partIndex)));
    }

    public StreamingInnerJoinSuite() {
        this.test("stream stream inner join on non-time column", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            MemoryStream input1 = MemoryStream$.MODULE$.apply(this.testImplicits().newIntEncoder(), this.sqlContext());
            MemoryStream input2 = MemoryStream$.MODULE$.apply(this.testImplicits().newIntEncoder(), this.sqlContext());
            Dataset df1 = input1.toDF().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "value")).as("key"), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "value")).$times((Object)BoxesRunTime.boxToInteger((int)2)).as("leftValue")}));
            Dataset df2 = input2.toDF().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "value")).as("key"), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "value")).$times((Object)BoxesRunTime.boxToInteger((int)3)).as("rightValue")}));
            Dataset joined = df1.join(df2, "key");
            StreamTest.StreamAction[] streamActionArray = new StreamTest.StreamAction[17];
            streamActionArray[0] = this.AddData().apply(input1, ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}));
            streamActionArray[1] = this.CheckAnswer().apply((Seq<Row>)Nil$.MODULE$);
            streamActionArray[2] = this.AddData().apply(input2, ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 10}));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(StreamingInnerJoinSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator5$3
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator5$3(StreamingInnerJoinSuite $outer) {
                }
            }
            streamActionArray[3] = this.CheckNewAnswer().apply(new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)3)), Nil$.MODULE$, this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator5$3(null))));
            streamActionArray[4] = this.AddData().apply(input1, ScalaRunTime$.MODULE$.wrapIntArray(new int[]{10}));
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(StreamingInnerJoinSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator10$2
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator10$2(StreamingInnerJoinSuite $outer) {
                }
            }
            streamActionArray[5] = this.CheckNewAnswer().apply(new Tuple3((Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)20), (Object)BoxesRunTime.boxToInteger((int)30)), Nil$.MODULE$, this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator10$2(null))));
            streamActionArray[6] = this.AddData().apply(input2, ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}));
            JavaUniverse $u3 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(StreamingInnerJoinSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator15$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator15$1(StreamingInnerJoinSuite $outer) {
                }
            }
            streamActionArray[7] = this.CheckNewAnswer().apply(new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)3)), Nil$.MODULE$, this.testImplicits().newProductEncoder(((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator15$1(null))));
            streamActionArray[8] = this.StopStream();
            streamActionArray[9] = new StreamTest.StartStream(this, this.StartStream().apply$default$1(), this.StartStream().apply$default$2(), this.StartStream().apply$default$3(), this.StartStream().apply$default$4());
            streamActionArray[10] = this.AddData().apply(input1, ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}));
            JavaUniverse $u4 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m4 = package$.MODULE$.universe().runtimeMirror(StreamingInnerJoinSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator20$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator20$1(StreamingInnerJoinSuite $outer) {
                }
            }
            streamActionArray[11] = this.CheckNewAnswer().apply(new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)3)), ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)3))}), this.testImplicits().newProductEncoder(((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator20$1(null))));
            streamActionArray[12] = this.StopStream();
            streamActionArray[13] = new StreamTest.StartStream(this, this.StartStream().apply$default$1(), this.StartStream().apply$default$2(), this.StartStream().apply$default$3(), this.StartStream().apply$default$4());
            streamActionArray[14] = this.AddData().apply(input1, ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100}));
            streamActionArray[15] = this.AddData().apply(input2, ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100}));
            JavaUniverse $u5 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m5 = package$.MODULE$.universe().runtimeMirror(StreamingInnerJoinSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator25$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator25$1(StreamingInnerJoinSuite $outer) {
                }
            }
            streamActionArray[16] = this.CheckNewAnswer().apply(new Tuple3((Object)BoxesRunTime.boxToInteger((int)100), (Object)BoxesRunTime.boxToInteger((int)200), (Object)BoxesRunTime.boxToInteger((int)300)), Nil$.MODULE$, this.testImplicits().newProductEncoder(((TypeTags)$u5).TypeTag().apply((Mirror)$m5, (TypeCreator)new Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator25$1(null))));
            this.testStream(joined, this.testStream$default$2(), (Seq<StreamTest.StreamAction>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])streamActionArray));
        }, new Position("StreamingJoinSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 213));
        this.test("stream stream inner join on windows - without watermark", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            MemoryStream input1 = MemoryStream$.MODULE$.apply(this.testImplicits().newIntEncoder(), this.sqlContext());
            MemoryStream input2 = MemoryStream$.MODULE$.apply(this.testImplicits().newIntEncoder(), this.sqlContext());
            Dataset df1 = input1.toDF().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "value")).as("key"), functions$.MODULE$.timestamp_seconds((Column)this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$)).as("timestamp"), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "value")).$times((Object)BoxesRunTime.boxToInteger((int)2)).as("leftValue")})).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "key")), functions$.MODULE$.window((Column)this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "timestamp")), "10 second"), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "leftValue"))}));
            Dataset df2 = input2.toDF().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "value")).as("key"), functions$.MODULE$.timestamp_seconds((Column)this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$)).as("timestamp"), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "value")).$times((Object)BoxesRunTime.boxToInteger((int)3)).as("rightValue")})).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "key")), functions$.MODULE$.window((Column)this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "timestamp")), "10 second"), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "rightValue"))}));
            Dataset joined = df1.join(df2, (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"key", "window"}))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "key")), this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"window.end"}))).$((Seq)Nil$.MODULE$).cast("long"), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "leftValue")), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "rightValue"))}));
            StreamTest.StreamAction[] streamActionArray = new StreamTest.StreamAction[20];
            streamActionArray[0] = this.AddData().apply(input1, ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}));
            streamActionArray[1] = this.CheckNewAnswer().apply();
            streamActionArray[2] = this.AddData().apply(input2, ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(StreamingInnerJoinSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator30$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
                }

                public Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator30$1(StreamingInnerJoinSuite $outer) {
                }
            }
            streamActionArray[3] = this.CheckNewAnswer().apply(new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)3)), Nil$.MODULE$, this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator30$1(null))));
            streamActionArray[4] = this.StopStream();
            streamActionArray[5] = new StreamTest.StartStream(this, this.StartStream().apply$default$1(), this.StartStream().apply$default$2(), this.StartStream().apply$default$3(), this.StartStream().apply$default$4());
            streamActionArray[6] = this.AddData().apply(input1, ScalaRunTime$.MODULE$.wrapIntArray(new int[]{25}));
            streamActionArray[7] = this.CheckNewAnswer().apply();
            streamActionArray[8] = this.StopStream();
            streamActionArray[9] = new StreamTest.StartStream(this, this.StartStream().apply$default$1(), this.StartStream().apply$default$2(), this.StartStream().apply$default$3(), this.StartStream().apply$default$4());
            streamActionArray[10] = this.AddData().apply(input2, ScalaRunTime$.MODULE$.wrapIntArray(new int[]{25}));
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(StreamingInnerJoinSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator35$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
                }

                public Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator35$1(StreamingInnerJoinSuite $outer) {
                }
            }
            streamActionArray[11] = this.CheckNewAnswer().apply(new Tuple4((Object)BoxesRunTime.boxToInteger((int)25), (Object)BoxesRunTime.boxToInteger((int)30), (Object)BoxesRunTime.boxToInteger((int)50), (Object)BoxesRunTime.boxToInteger((int)75)), Nil$.MODULE$, this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator35$1(null))));
            streamActionArray[12] = this.AddData().apply(input1, ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}));
            JavaUniverse $u3 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(StreamingInnerJoinSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator40$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
                }

                public Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator40$1(StreamingInnerJoinSuite $outer) {
                }
            }
            streamActionArray[13] = this.CheckNewAnswer().apply(new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)3)), Nil$.MODULE$, this.testImplicits().newProductEncoder(((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator40$1(null))));
            streamActionArray[14] = this.StopStream();
            streamActionArray[15] = new StreamTest.StartStream(this, this.StartStream().apply$default$1(), this.StartStream().apply$default$2(), this.StartStream().apply$default$3(), this.StartStream().apply$default$4());
            streamActionArray[16] = this.AddData().apply(input1, ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5}));
            streamActionArray[17] = this.CheckNewAnswer().apply();
            streamActionArray[18] = this.AddData().apply(input2, ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5}));
            JavaUniverse $u4 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m4 = package$.MODULE$.universe().runtimeMirror(StreamingInnerJoinSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator45$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
                }

                public Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator45$1(StreamingInnerJoinSuite $outer) {
                }
            }
            streamActionArray[19] = this.CheckNewAnswer().apply(new Tuple4((Object)BoxesRunTime.boxToInteger((int)5), (Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)15)), Nil$.MODULE$, this.testImplicits().newProductEncoder(((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator45$1(null))));
            this.testStream(joined, this.testStream$default$2(), (Seq<StreamTest.StreamAction>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])streamActionArray));
        }, new Position("StreamingJoinSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
        this.test("stream stream inner join on windows - with watermark", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            MemoryStream input1 = MemoryStream$.MODULE$.apply(this.testImplicits().newIntEncoder(), this.sqlContext());
            MemoryStream input2 = MemoryStream$.MODULE$.apply(this.testImplicits().newIntEncoder(), this.sqlContext());
            Dataset df1 = input1.toDF().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "value")).as("key"), functions$.MODULE$.timestamp_seconds((Column)this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$)).as("timestamp"), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "value")).$times((Object)BoxesRunTime.boxToInteger((int)2)).as("leftValue")})).withWatermark("timestamp", "10 seconds").select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "key")), functions$.MODULE$.window((Column)this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "timestamp")), "10 second"), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "leftValue"))}));
            Dataset df2 = input2.toDF().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "value")).as("key"), functions$.MODULE$.timestamp_seconds((Column)this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$)).as("timestamp"), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "value")).$times((Object)BoxesRunTime.boxToInteger((int)3)).as("rightValue")})).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "key")), functions$.MODULE$.window((Column)this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "timestamp")), "10 second"), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "rightValue"))}));
            Dataset joined = df1.join(df2, (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"key", "window"}))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "key")), this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"window.end"}))).$((Seq)Nil$.MODULE$).cast("long"), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "leftValue")), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "rightValue"))}));
            StreamTest.StreamAction[] streamActionArray = new StreamTest.StreamAction[22];
            streamActionArray[0] = this.AddData().apply(input1, ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}));
            streamActionArray[1] = this.CheckAnswer().apply((Seq<Row>)Nil$.MODULE$);
            streamActionArray[2] = this.assertNumStateRows(1L, 1L, this.assertNumStateRows$default$3());
            streamActionArray[3] = this.AddData().apply(input2, ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(StreamingInnerJoinSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator50$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
                }

                public Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator50$1(StreamingInnerJoinSuite $outer) {
                }
            }
            streamActionArray[4] = this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)3))}), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator50$1(null))));
            streamActionArray[5] = this.assertNumStateRows(2L, 1L, this.assertNumStateRows$default$3());
            streamActionArray[6] = this.StopStream();
            streamActionArray[7] = new StreamTest.StartStream(this, this.StartStream().apply$default$1(), this.StartStream().apply$default$2(), this.StartStream().apply$default$3(), this.StartStream().apply$default$4());
            streamActionArray[8] = this.AddData().apply(input1, ScalaRunTime$.MODULE$.wrapIntArray(new int[]{25}));
            streamActionArray[9] = this.CheckNewAnswer().apply();
            streamActionArray[10] = this.assertNumStateRows(1L, 1L, this.assertNumStateRows$default$3());
            streamActionArray[11] = this.AddData().apply(input2, ScalaRunTime$.MODULE$.wrapIntArray(new int[]{25}));
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(StreamingInnerJoinSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator55$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
                }

                public Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator55$1(StreamingInnerJoinSuite $outer) {
                }
            }
            streamActionArray[12] = this.CheckNewAnswer().apply(new Tuple4((Object)BoxesRunTime.boxToInteger((int)25), (Object)BoxesRunTime.boxToInteger((int)30), (Object)BoxesRunTime.boxToInteger((int)50), (Object)BoxesRunTime.boxToInteger((int)75)), Nil$.MODULE$, this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator55$1(null))));
            streamActionArray[13] = this.assertNumStateRows(2L, 1L, this.assertNumStateRows$default$3());
            streamActionArray[14] = this.StopStream();
            streamActionArray[15] = new StreamTest.StartStream(this, this.StartStream().apply$default$1(), this.StartStream().apply$default$2(), this.StartStream().apply$default$3(), this.StartStream().apply$default$4());
            streamActionArray[16] = this.AddData().apply(input2, ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}));
            streamActionArray[17] = this.CheckNewAnswer().apply();
            streamActionArray[18] = this.assertNumStateRows(2L, 0L, this.assertNumStateRows$default$3());
            streamActionArray[19] = this.AddData().apply(input1, ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5}));
            streamActionArray[20] = this.CheckNewAnswer().apply();
            streamActionArray[21] = this.assertNumStateRows(2L, 0L, 1L);
            this.testStream(joined, this.testStream$default$2(), (Seq<StreamTest.StreamAction>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])streamActionArray));
        }, new Position("StreamingJoinSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 283));
        this.test("stream stream inner join with time range - with watermark - one side condition", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(StreamingInnerJoinSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator60$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator60$1(StreamingInnerJoinSuite $outer) {
                }
            }
            MemoryStream leftInput = MemoryStream$.MODULE$.apply(this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator60$1(null))), this.sqlContext());
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(StreamingInnerJoinSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator65$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator65$1(StreamingInnerJoinSuite $outer) {
                }
            }
            MemoryStream rightInput = MemoryStream$.MODULE$.apply(this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator65$1(null))), this.sqlContext());
            Dataset df1 = leftInput.toDF().toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"leftKey", "time"})).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "leftKey")), functions$.MODULE$.timestamp_seconds((Column)this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"time"}))).$((Seq)Nil$.MODULE$)).as("leftTime"), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "leftKey")).$times((Object)BoxesRunTime.boxToInteger((int)2)).as("leftValue")})).withWatermark("leftTime", "10 seconds");
            Dataset df2 = rightInput.toDF().toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"rightKey", "time"})).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "rightKey")), functions$.MODULE$.timestamp_seconds((Column)this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"time"}))).$((Seq)Nil$.MODULE$)).as("rightTime"), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "rightKey")).$times((Object)BoxesRunTime.boxToInteger((int)3)).as("rightValue")})).withWatermark("rightTime", "10 seconds");
            Dataset joined = df1.join(df2, functions$.MODULE$.expr("leftKey = rightKey AND leftTime < rightTime - interval 5 seconds")).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "leftKey")), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "leftTime")).cast("int"), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "rightTime")).cast("int")}));
            StreamTest.StreamAction[] streamActionArray = new StreamTest.StreamAction[19];
            streamActionArray[0] = this.AddData().apply(leftInput, ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcII.sp(1, 5)}));
            streamActionArray[1] = this.CheckAnswer().apply((Seq<Row>)Nil$.MODULE$);
            streamActionArray[2] = this.AddData().apply(rightInput, ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcII.sp(1, 11)}));
            JavaUniverse $u3 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(StreamingInnerJoinSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator70$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator70$1(StreamingInnerJoinSuite $outer) {
                }
            }
            streamActionArray[3] = this.CheckNewAnswer().apply(new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)5), (Object)BoxesRunTime.boxToInteger((int)11)), Nil$.MODULE$, this.testImplicits().newProductEncoder(((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator70$1(null))));
            streamActionArray[4] = this.AddData().apply(rightInput, ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcII.sp(1, 10)}));
            streamActionArray[5] = this.CheckNewAnswer().apply();
            streamActionArray[6] = this.assertNumStateRows(3L, 3L, this.assertNumStateRows$default$3());
            streamActionArray[7] = this.AddData().apply(leftInput, ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcII.sp(1, 3), new Tuple2.mcII.sp(1, 30)}));
            JavaUniverse $u4 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m4 = package$.MODULE$.universe().runtimeMirror(StreamingInnerJoinSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator75$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator75$1(StreamingInnerJoinSuite $outer) {
                }
            }
            streamActionArray[8] = this.CheckNewAnswer().apply(new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)10)), ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)11))}), this.testImplicits().newProductEncoder(((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator75$1(null))));
            streamActionArray[9] = this.assertNumStateRows(5L, 2L, this.assertNumStateRows$default$3());
            streamActionArray[10] = this.AddData().apply(rightInput, ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcII.sp(0, 30)}));
            streamActionArray[11] = this.CheckNewAnswer().apply();
            streamActionArray[12] = this.assertNumStateRows(4L, 1L, this.assertNumStateRows$default$3());
            streamActionArray[13] = this.AddData().apply(rightInput, ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcII.sp(1, 20), new Tuple2.mcII.sp(1, 21), new Tuple2.mcII.sp(1, 28)}));
            JavaUniverse $u5 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m5 = package$.MODULE$.universe().runtimeMirror(StreamingInnerJoinSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator80$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator80$1(StreamingInnerJoinSuite $outer) {
                }
            }
            streamActionArray[14] = this.CheckNewAnswer().apply(new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)21)), ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)5), (Object)BoxesRunTime.boxToInteger((int)21)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)28)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)5), (Object)BoxesRunTime.boxToInteger((int)28))}), this.testImplicits().newProductEncoder(((TypeTags)$u5).TypeTag().apply((Mirror)$m5, (TypeCreator)new Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator80$1(null))));
            streamActionArray[15] = this.assertNumStateRows(5L, 1L, 1L);
            streamActionArray[16] = this.AddData().apply(leftInput, ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcII.sp(1, 20), new Tuple2.mcII.sp(1, 21)}));
            JavaUniverse $u6 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m6 = package$.MODULE$.universe().runtimeMirror(StreamingInnerJoinSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator85$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator85$1(StreamingInnerJoinSuite $outer) {
                }
            }
            streamActionArray[17] = this.CheckNewAnswer().apply(new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)21), (Object)BoxesRunTime.boxToInteger((int)28)), Nil$.MODULE$, this.testImplicits().newProductEncoder(((TypeTags)$u6).TypeTag().apply((Mirror)$m6, (TypeCreator)new Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator85$1(null))));
            streamActionArray[18] = this.assertNumStateRows(6L, 1L, 1L);
            this.testStream(joined, this.testStream$default$2(), (Seq<StreamTest.StreamAction>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])streamActionArray));
        }, new Position("StreamingJoinSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 332));
        this.test("stream stream inner join with time range - with watermark - two side conditions", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(StreamingInnerJoinSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator90$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator90$1(StreamingInnerJoinSuite $outer) {
                }
            }
            MemoryStream leftInput = MemoryStream$.MODULE$.apply(this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator90$1(null))), this.sqlContext());
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(StreamingInnerJoinSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator95$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator95$1(StreamingInnerJoinSuite $outer) {
                }
            }
            MemoryStream rightInput = MemoryStream$.MODULE$.apply(this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator95$1(null))), this.sqlContext());
            Dataset df1 = leftInput.toDF().toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"leftKey", "time"})).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "leftKey")), functions$.MODULE$.timestamp_seconds((Column)this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"time"}))).$((Seq)Nil$.MODULE$)).as("leftTime"), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "leftKey")).$times((Object)BoxesRunTime.boxToInteger((int)2)).as("leftValue")})).withWatermark("leftTime", "20 seconds");
            Dataset df2 = rightInput.toDF().toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"rightKey", "time"})).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "rightKey")), functions$.MODULE$.timestamp_seconds((Column)this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"time"}))).$((Seq)Nil$.MODULE$)).as("rightTime"), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "rightKey")).$times((Object)BoxesRunTime.boxToInteger((int)3)).as("rightValue")})).withWatermark("rightTime", "30 seconds");
            Column condition = functions$.MODULE$.expr("leftKey = rightKey AND leftTime BETWEEN rightTime - interval 10 seconds AND rightTime + interval 5 seconds");
            Dataset joined = df1.join(df2, condition).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "leftKey")), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "leftTime")).cast("int"), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "rightTime")).cast("int")}));
            StreamTest.StreamAction[] streamActionArray = new StreamTest.StreamAction[19];
            streamActionArray[0] = this.AddData().apply(leftInput, ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcII.sp(1, 20)}));
            streamActionArray[1] = this.CheckAnswer().apply((Seq<Row>)Nil$.MODULE$);
            streamActionArray[2] = this.AddData().apply(rightInput, ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcII.sp(1, 14), new Tuple2.mcII.sp(1, 15), new Tuple2.mcII.sp(1, 25), new Tuple2.mcII.sp(1, 26), new Tuple2.mcII.sp(1, 30), new Tuple2.mcII.sp(1, 31)}));
            JavaUniverse $u3 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(StreamingInnerJoinSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator100$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator100$1(StreamingInnerJoinSuite $outer) {
                }
            }
            streamActionArray[3] = this.CheckNewAnswer().apply(new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)20), (Object)BoxesRunTime.boxToInteger((int)15)), ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)20), (Object)BoxesRunTime.boxToInteger((int)25)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)20), (Object)BoxesRunTime.boxToInteger((int)26)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)20), (Object)BoxesRunTime.boxToInteger((int)30))}), this.testImplicits().newProductEncoder(((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator100$1(null))));
            streamActionArray[4] = this.assertNumStateRows(7L, 7L, this.assertNumStateRows$default$3());
            streamActionArray[5] = this.AddData().apply(rightInput, ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcII.sp(1, 60)}));
            streamActionArray[6] = this.CheckNewAnswer().apply();
            streamActionArray[7] = this.AddData().apply(leftInput, ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcII.sp(1, 49), new Tuple2.mcII.sp(1, 50), new Tuple2.mcII.sp(1, 65), new Tuple2.mcII.sp(1, 66)}));
            JavaUniverse $u4 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m4 = package$.MODULE$.universe().runtimeMirror(StreamingInnerJoinSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator105$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator105$1(StreamingInnerJoinSuite $outer) {
                }
            }
            streamActionArray[8] = this.CheckNewAnswer().apply(new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)50), (Object)BoxesRunTime.boxToInteger((int)60)), ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)65), (Object)BoxesRunTime.boxToInteger((int)60))}), this.testImplicits().newProductEncoder(((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator105$1(null))));
            streamActionArray[9] = this.assertNumStateRows(10L, 5L, this.assertNumStateRows$default$3());
            streamActionArray[10] = this.AddData().apply(leftInput, ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcII.sp(1, 30), new Tuple2.mcII.sp(1, 31)}));
            JavaUniverse $u5 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m5 = package$.MODULE$.universe().runtimeMirror(StreamingInnerJoinSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator110$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator110$1(StreamingInnerJoinSuite $outer) {
                }
            }
            streamActionArray[11] = this.CheckNewAnswer().apply(new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)31), (Object)BoxesRunTime.boxToInteger((int)26)), ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)31), (Object)BoxesRunTime.boxToInteger((int)30)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)31), (Object)BoxesRunTime.boxToInteger((int)31))}), this.testImplicits().newProductEncoder(((TypeTags)$u5).TypeTag().apply((Mirror)$m5, (TypeCreator)new Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator110$1(null))));
            streamActionArray[12] = this.assertNumStateRows(11L, 1L, 1L);
            streamActionArray[13] = this.AddData().apply(rightInput, ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcII.sp(1, 80)}));
            streamActionArray[14] = this.CheckNewAnswer().apply();
            streamActionArray[15] = this.assertNumStateRows(6L, 1L, this.assertNumStateRows$default$3());
            streamActionArray[16] = this.AddData().apply(rightInput, ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcII.sp(1, 46), new Tuple2.mcII.sp(1, 50)}));
            JavaUniverse $u6 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m6 = package$.MODULE$.universe().runtimeMirror(StreamingInnerJoinSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator115$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator115$1(StreamingInnerJoinSuite $outer) {
                }
            }
            streamActionArray[17] = this.CheckNewAnswer().apply(new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)49), (Object)BoxesRunTime.boxToInteger((int)50)), ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)50), (Object)BoxesRunTime.boxToInteger((int)50))}), this.testImplicits().newProductEncoder(((TypeTags)$u6).TypeTag().apply((Mirror)$m6, (TypeCreator)new Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator115$1(null))));
            streamActionArray[18] = this.assertNumStateRows(7L, 1L, 1L);
            this.testStream(joined, this.testStream$default$2(), (Seq<StreamTest.StreamAction>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])streamActionArray));
        }, new Position("StreamingJoinSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 391));
        this.testQuietly("stream stream inner join without equality predicate", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            MemoryStream input1 = MemoryStream$.MODULE$.apply(this.testImplicits().newIntEncoder(), this.sqlContext());
            MemoryStream input2 = MemoryStream$.MODULE$.apply(this.testImplicits().newIntEncoder(), this.sqlContext());
            Dataset df1 = input1.toDF().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "value")).as("leftKey"), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "value")).$times((Object)BoxesRunTime.boxToInteger((int)2)).as("leftValue")}));
            Dataset df2 = input2.toDF().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "value")).as("rightKey"), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "value")).$times((Object)BoxesRunTime.boxToInteger((int)3)).as("rightValue")}));
            Dataset joined = df1.join(df2, functions$.MODULE$.expr("leftKey < rightKey"));
            Exception e = (Exception)this.intercept((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
                StreamingQuery q = joined.writeStream().format("memory").queryName("test").start();
                input1.addData((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}));
                return q.awaitTermination(10000L);
            }, ClassTag$.MODULE$.apply(Exception.class), new Position("StreamingJoinSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 482));
            String $org_scalatest_assert_macro_left = e.toString();
            String $org_scalatest_assert_macro_right = "Stream-stream join without equality predicate is not supported";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingJoinSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 487));
        });
        this.test("stream stream self join", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            MemoryStream input = MemoryStream$.MODULE$.apply(this.testImplicits().newIntEncoder(), this.sqlContext());
            Dataset df = input.toDF();
            Dataset join = df.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "value")).$percent((Object)BoxesRunTime.boxToInteger((int)5)).as("key"), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "value"))})).join(df.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "value")).$percent((Object)BoxesRunTime.boxToInteger((int)5)).as("key"), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "value"))})), "key");
            StreamTest.StreamAction[] streamActionArray = new StreamTest.StreamAction[6];
            streamActionArray[0] = this.AddData().apply(input, ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(StreamingInnerJoinSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator120$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator120$1(StreamingInnerJoinSuite $outer) {
                }
            }
            streamActionArray[1] = this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)2))}), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator120$1(null))));
            streamActionArray[2] = this.StopStream();
            streamActionArray[3] = new StreamTest.StartStream(this, this.StartStream().apply$default$1(), this.StartStream().apply$default$2(), this.StartStream().apply$default$3(), this.StartStream().apply$default$4());
            streamActionArray[4] = this.AddData().apply(input, ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 6}));
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(StreamingInnerJoinSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator125$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator125$1(StreamingInnerJoinSuite $outer) {
                }
            }
            streamActionArray[5] = this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)6)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)6), (Object)BoxesRunTime.boxToInteger((int)1)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)6), (Object)BoxesRunTime.boxToInteger((int)6))}), this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator125$1(null))));
            this.testStream(join, this.testStream$default$2(), (Seq<StreamTest.StreamAction>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])streamActionArray));
        }, new Position("StreamingJoinSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 490));
        this.test("locality preferences of StateStoreAwareZippedRDD", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)tempDir -> {
            StreamingInnerJoinSuite.$anonfun$new$12(this, tempDir);
            return BoxedUnit.UNIT;
        }), new Position("StreamingJoinSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 511));
        this.test("join between three streams", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            MemoryStream input1 = MemoryStream$.MODULE$.apply(this.testImplicits().newIntEncoder(), this.sqlContext());
            MemoryStream input2 = MemoryStream$.MODULE$.apply(this.testImplicits().newIntEncoder(), this.sqlContext());
            MemoryStream input3 = MemoryStream$.MODULE$.apply(this.testImplicits().newIntEncoder(), this.sqlContext());
            Dataset df1 = input1.toDF().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "value")).as("leftKey"), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "value")).$times((Object)BoxesRunTime.boxToInteger((int)2)).as("leftValue")}));
            Dataset df2 = input2.toDF().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "value")).as("middleKey"), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "value")).$times((Object)BoxesRunTime.boxToInteger((int)3)).as("middleValue")}));
            Dataset df3 = input3.toDF().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "value")).as("rightKey"), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "value")).$times((Object)BoxesRunTime.boxToInteger((int)5)).as("rightValue")}));
            Dataset joined = df1.join(df2, functions$.MODULE$.expr("leftKey = middleKey")).join(df3, functions$.MODULE$.expr("rightKey = middleKey"));
            StreamTest.StreamAction[] streamActionArray = new StreamTest.StreamAction[4];
            streamActionArray[0] = this.AddData().apply(input1, ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 5}));
            streamActionArray[1] = this.AddData().apply(input2, ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 5, 10}));
            streamActionArray[2] = this.AddData().apply(input3, ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5, 10}));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(StreamingInnerJoinSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator130$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple6"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)))))));
                }

                public Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator130$1(StreamingInnerJoinSuite $outer) {
                }
            }
            streamActionArray[3] = this.CheckNewAnswer().apply(new Tuple6((Object)BoxesRunTime.boxToInteger((int)5), (Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)5), (Object)BoxesRunTime.boxToInteger((int)15), (Object)BoxesRunTime.boxToInteger((int)5), (Object)BoxesRunTime.boxToInteger((int)25)), Nil$.MODULE$, this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator130$1(null))));
            this.testStream(joined, this.testStream$default$2(), (Seq<StreamTest.StreamAction>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])streamActionArray));
        }, new Position("StreamingJoinSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 554));
        this.test("streaming join should require HashClusteredDistribution from children", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            MemoryStream input1 = MemoryStream$.MODULE$.apply(this.testImplicits().newIntEncoder(), this.sqlContext());
            MemoryStream input2 = MemoryStream$.MODULE$.apply(this.testImplicits().newIntEncoder(), this.sqlContext());
            Dataset df1 = input1.toDF().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "value")).as((Symbol)SymbolLiteral.bootstrap("apply", "a")), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "value")).$times((Object)BoxesRunTime.boxToInteger((int)2)).as((Symbol)SymbolLiteral.bootstrap("apply", "b"))}));
            Dataset df2 = input2.toDF().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "value")).as((Symbol)SymbolLiteral.bootstrap("apply", "a")), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "value")).$times((Object)BoxesRunTime.boxToInteger((int)2)).as((Symbol)SymbolLiteral.bootstrap("apply", "b"))})).repartition((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "b"))}));
            Dataset joined = df1.join(df2, (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"}))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "a"))}));
            this.testStream(joined, this.testStream$default$2(), (Seq<StreamTest.StreamAction>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{this.AddData().apply(input1, RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 1000)), this.AddData().apply(input2, RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 1000)), this.CheckAnswer().apply(RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 1000), this.testImplicits().newIntEncoder()), this.Execute().apply((Function1<StreamExecution, Object>)(Function1 & Serializable)query -> {
                Seq $org_scalatest_assert_macro_left = query.lastExecution().executedPlan().collect((PartialFunction)new Serializable(null){
                    private static final long serialVersionUID = 0L;

                    /*
                     * Enabled aggressive block sorting
                     */
                    public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (A1 instanceof StreamingSymmetricHashJoinExec) {
                            ShuffleExchangeExec shuffleExchangeExec;
                            StreamingSymmetricHashJoinExec streamingSymmetricHashJoinExec = (StreamingSymmetricHashJoinExec)A1;
                            SparkPlan sparkPlan2 = streamingSymmetricHashJoinExec.right();
                            if (streamingSymmetricHashJoinExec.left() instanceof ShuffleExchangeExec && sparkPlan2 instanceof ShuffleExchangeExec && (shuffleExchangeExec = (ShuffleExchangeExec)sparkPlan2).child() instanceof ShuffleExchangeExec) {
                                object = streamingSymmetricHashJoinExec;
                                return (B1)object;
                            }
                        }
                        object = function1.apply(x1);
                        return (B1)object;
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean isDefinedAt(SparkPlan x1) {
                        SparkPlan sparkPlan2 = x1;
                        if (!(sparkPlan2 instanceof StreamingSymmetricHashJoinExec)) return false;
                        StreamingSymmetricHashJoinExec streamingSymmetricHashJoinExec = (StreamingSymmetricHashJoinExec)sparkPlan2;
                        SparkPlan sparkPlan3 = streamingSymmetricHashJoinExec.right();
                        if (!(streamingSymmetricHashJoinExec.left() instanceof ShuffleExchangeExec)) return false;
                        if (!(sparkPlan3 instanceof ShuffleExchangeExec)) return false;
                        ShuffleExchangeExec shuffleExchangeExec = (ShuffleExchangeExec)sparkPlan3;
                        if (!(shuffleExchangeExec.child() instanceof ShuffleExchangeExec)) return false;
                        return true;
                    }
                });
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingJoinSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 586));
            })}));
        }, new Position("StreamingJoinSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 572));
        this.test("SPARK-26187 restore the stream-stream inner join query from Spark 2.4", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(StreamingInnerJoinSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator135$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator135$1(StreamingInnerJoinSuite $outer) {
                }
            }
            MemoryStream inputStream = MemoryStream$.MODULE$.apply(this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator135$1(null))), this.sqlContext());
            Dataset df = inputStream.toDS().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("_1").as("value"), functions$.MODULE$.timestamp_seconds((Column)this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"_2"}))).$((Seq)Nil$.MODULE$)).as("timestamp")}));
            Dataset leftStream = df.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("value").as("leftId"), functions$.MODULE$.col("timestamp").as("leftTime")}));
            Dataset rightStream = df.where(functions$.MODULE$.col("value").$percent((Object)BoxesRunTime.boxToInteger((int)2)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)0))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("value").as("rightId"), functions$.MODULE$.col("timestamp").as("rightTime")}));
            Dataset query2 = leftStream.withWatermark("leftTime", "5 seconds").join(rightStream.withWatermark("rightTime", "5 seconds"), functions$.MODULE$.expr("rightId = leftId AND rightTime >= leftTime AND rightTime <= leftTime + interval 5 seconds"), "inner").select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("leftId"), functions$.MODULE$.col("leftTime").cast("int"), functions$.MODULE$.col("rightId"), functions$.MODULE$.col("rightTime").cast("int")}));
            URI resourceUri = this.getClass().getResource("/structured-streaming/checkpoint-version-2.4.0-streaming-join/").toURI();
            File checkpointDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).getCanonicalFile();
            FileUtils.copyDirectory((File)new File(resourceUri), (File)checkpointDir);
            inputStream.addData((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcIJ.sp(1, 1L), new Tuple2.mcIJ.sp(2, 2L), new Tuple2.mcIJ.sp(3, 3L), new Tuple2.mcIJ.sp(4, 4L), new Tuple2.mcIJ.sp(5, 5L)}));
            StreamTest.StreamAction[] streamActionArray = new StreamTest.StreamAction[5];
            String x$1 = checkpointDir.getAbsolutePath();
            Trigger x$2 = this.StartStream().apply$default$1();
            Clock x$3 = this.StartStream().apply$default$2();
            Map<String, String> x$4 = this.StartStream().apply$default$3();
            streamActionArray[0] = new StreamTest.StartStream(this, x$2, x$3, x$4, x$1);
            streamActionArray[1] = this.AddData().apply(inputStream, ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcIJ.sp(6, 6L), new Tuple2.mcIJ.sp(7, 7L), new Tuple2.mcIJ.sp(8, 8L), new Tuple2.mcIJ.sp(9, 9L), new Tuple2.mcIJ.sp(10, 10L)}));
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(StreamingInnerJoinSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator140$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
                }

                public Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator140$1(StreamingInnerJoinSuite $outer) {
                }
            }
            streamActionArray[2] = this.CheckNewAnswer().apply(new Tuple4((Object)BoxesRunTime.boxToInteger((int)6), (Object)BoxesRunTime.boxToLong((long)6L), (Object)BoxesRunTime.boxToInteger((int)6), (Object)BoxesRunTime.boxToLong((long)6L)), ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4((Object)BoxesRunTime.boxToInteger((int)8), (Object)BoxesRunTime.boxToLong((long)8L), (Object)BoxesRunTime.boxToInteger((int)8), (Object)BoxesRunTime.boxToLong((long)8L)), new Tuple4((Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToLong((long)10L), (Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToLong((long)10L))}), this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator140$1(null))));
            streamActionArray[3] = this.assertNumStateRows(11L, 6L, this.assertNumStateRows$default$3());
            streamActionArray[4] = this.Execute().apply((Function1<StreamExecution, Object>)(Function1 & Serializable)query -> {
                Seq f;
                Seq $org_scalatest_assert_macro_left = f = query.lastExecution().executedPlan().collect((PartialFunction)new Serializable(null){
                    private static final long serialVersionUID = 0L;

                    public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                        StreamingSymmetricHashJoinExec streamingSymmetricHashJoinExec;
                        A1 A1 = x2;
                        Object object = A1 instanceof StreamingSymmetricHashJoinExec ? (streamingSymmetricHashJoinExec = (StreamingSymmetricHashJoinExec)A1) : function1.apply(x2);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(SparkPlan x2) {
                        SparkPlan sparkPlan2 = x2;
                        boolean bl = sparkPlan2 instanceof StreamingSymmetricHashJoinExec;
                        return bl;
                    }
                });
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingJoinSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 644));
                int $org_scalatest_assert_macro_left2 = ((StreamingSymmetricHashJoinExec)f.head()).stateFormatVersion();
                int $org_scalatest_assert_macro_right2 = 1;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingJoinSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 645));
            });
            this.testStream(query2, this.testStream$default$2(), (Seq<StreamTest.StreamAction>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])streamActionArray));
        }, new Position("StreamingJoinSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 593));
        this.test("SPARK-35896: metrics in StateOperatorProgress are output correctly", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            MemoryStream input1 = MemoryStream$.MODULE$.apply(this.testImplicits().newIntEncoder(), this.sqlContext());
            MemoryStream input2 = MemoryStream$.MODULE$.apply(this.testImplicits().newIntEncoder(), this.sqlContext());
            Dataset df1 = input1.toDF().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "value")).as("key"), functions$.MODULE$.timestamp_seconds((Column)this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$)).as("timestamp"), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "value")).$times((Object)BoxesRunTime.boxToInteger((int)2)).as("leftValue")})).withWatermark("timestamp", "10 seconds").select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "key")), functions$.MODULE$.window((Column)this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "timestamp")), "10 second"), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "leftValue"))}));
            Dataset df2 = input2.toDF().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "value")).as("key"), functions$.MODULE$.timestamp_seconds((Column)this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$)).as("timestamp"), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "value")).$times((Object)BoxesRunTime.boxToInteger((int)3)).as("rightValue")})).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "key")), functions$.MODULE$.window((Column)this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "timestamp")), "10 second"), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "rightValue"))}));
            Dataset joined = df1.join(df2, (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"key", "window"}))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "key")), this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"window.end"}))).$((Seq)Nil$.MODULE$).cast("long"), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "leftValue")), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "rightValue"))}));
            StreamTest.StreamAction[] streamActionArray = new StreamTest.StreamAction[13];
            Map x$5 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.SHUFFLE_PARTITIONS().key()), (Object)"3")}));
            Trigger x$6 = this.StartStream().apply$default$1();
            Clock x$7 = this.StartStream().apply$default$2();
            String x$8 = this.StartStream().apply$default$4();
            streamActionArray[0] = new StreamTest.StartStream(this, x$6, x$7, (Map<String, String>)x$5, x$8);
            streamActionArray[1] = this.AddData().apply(input1, ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}));
            streamActionArray[2] = this.CheckAnswer().apply((Seq<Row>)Nil$.MODULE$);
            streamActionArray[3] = this.assertStateOperatorProgressMetric("symmetricHashJoin", 3L, 12L, this.assertStateOperatorProgressMetric$default$4());
            streamActionArray[4] = this.AddData().apply(input2, ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(StreamingInnerJoinSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator145$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
                }

                public Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator145$1(StreamingInnerJoinSuite $outer) {
                }
            }
            streamActionArray[5] = this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)3))}), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator145$1(null))));
            streamActionArray[6] = this.assertNumStateRows((Seq<Object>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{2L}))), (Seq<Object>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{1L}))), (Seq<Object>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{0L}))), (Option<Seq<Object>>)new Some((Object)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{0L}))));
            streamActionArray[7] = this.AddData().apply(input1, ScalaRunTime$.MODULE$.wrapIntArray(new int[]{25}));
            streamActionArray[8] = this.CheckNewAnswer().apply();
            streamActionArray[9] = this.assertNumStateRows((Seq<Object>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{1L}))), (Seq<Object>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{1L}))), (Seq<Object>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{0L}))), (Option<Seq<Object>>)new Some((Object)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{2L}))));
            streamActionArray[10] = this.AddData().apply(input2, ScalaRunTime$.MODULE$.wrapIntArray(new int[]{25}));
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(StreamingInnerJoinSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator150$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
                }

                public Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator150$1(StreamingInnerJoinSuite $outer) {
                }
            }
            streamActionArray[11] = this.CheckNewAnswer().apply(new Tuple4((Object)BoxesRunTime.boxToInteger((int)25), (Object)BoxesRunTime.boxToInteger((int)30), (Object)BoxesRunTime.boxToInteger((int)50), (Object)BoxesRunTime.boxToInteger((int)75)), Nil$.MODULE$, this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_streaming_StreamingInnerJoinSuite$$typecreator150$1(null))));
            streamActionArray[12] = this.assertNumStateRows((Seq<Object>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{2L}))), (Seq<Object>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{1L}))), (Seq<Object>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{0L}))), (Option<Seq<Object>>)new Some((Object)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{0L}))));
            this.testStream(joined, this.testStream$default$2(), (Seq<StreamTest.StreamAction>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])streamActionArray));
        }, new Position("StreamingJoinSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 650));
    }
}

