/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.window;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.catalyst.expressions.MutableProjection;
import org.apache.spark.sql.catalyst.expressions.SpecificInternalRow;
import org.apache.spark.sql.catalyst.expressions.aggregate.ImperativeAggregate;
import org.apache.spark.sql.execution.window.AggregateProcessor$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001drA\u0002\n\u0014\u0011\u0003\u0019rD\u0002\u0004\"'!\u00051C\t\u0005\u0006S\u0005!\ta\u000b\u0005\u0006Y\u0005!\t!\f\u0004\u0006CM\u00111c\f\u0005\ta\u0011\u0011\t\u0011)A\u0005c!AA\b\u0002B\u0001B\u0003%Q\b\u0003\u0005A\t\t\u0005\t\u0015!\u0003>\u0011!\tEA!A!\u0002\u0013i\u0004\u0002\u0003\"\u0005\u0005\u0003\u0005\u000b\u0011B\"\t\u0011)#!\u0011!Q\u0001\n-CQ!\u000b\u0003\u0005\u00029Ca!\u0016\u0003!\u0002\u00131\u0006BB-\u0005A\u0003%!\f\u0003\u0004^\t\u0001\u0006IA\u0018\u0005\u0006C\u0012!\tA\u0019\u0005\u0006Q\u0012!\t!\u001b\u0005\u0006a\u0012!\t!]\u0001\u0013\u0003\u001e<'/Z4bi\u0016\u0004&o\\2fgN|'O\u0003\u0002\u0015+\u00051q/\u001b8e_^T!AF\f\u0002\u0013\u0015DXmY;uS>t'B\u0001\r\u001a\u0003\r\u0019\u0018\u000f\u001c\u0006\u00035m\tQa\u001d9be.T!\u0001H\u000f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0012aA8sOB\u0011\u0001%A\u0007\u0002'\t\u0011\u0012iZ4sK\u001e\fG/\u001a)s_\u000e,7o]8s'\t\t1\u0005\u0005\u0002%O5\tQEC\u0001'\u0003\u0015\u00198-\u00197b\u0013\tASE\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\tq$A\u0003baBd\u0017\u0010\u0006\u0004/ijd\u00181\u0004\t\u0003A\u0011\u0019\"\u0001B\u0012\u0002\u0019\t,hMZ3s'\u000eDW-\\1\u0011\u0007\u0011\u0012D'\u0003\u00024K\t)\u0011I\u001d:bsB\u0011QGO\u0007\u0002m)\u0011q\u0007O\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002:/\u0005A1-\u0019;bYf\u001cH/\u0003\u0002<m\t\u0011\u0012\t\u001e;sS\n,H/\u001a*fM\u0016\u0014XM\\2f\u0003EIg.\u001b;jC2\u0004&o\u001c6fGRLwN\u001c\t\u0003kyJ!a\u0010\u001c\u0003#5+H/\u00192mKB\u0013xN[3di&|g.\u0001\tva\u0012\fG/\u001a)s_*,7\r^5p]\u0006\u0011RM^1mk\u0006$X\r\u0015:pU\u0016\u001cG/[8o\u0003-IW\u000e]3sCRLg/Z:\u0011\u0007\u0011\u0012D\t\u0005\u0002F\u00116\taI\u0003\u0002Hm\u0005I\u0011mZ4sK\u001e\fG/Z\u0005\u0003\u0013\u001a\u00131#S7qKJ\fG/\u001b<f\u0003\u001e<'/Z4bi\u0016\f!\u0003\u001e:bG.\u0004\u0016M\u001d;ji&|gnU5{KB\u0011A\u0005T\u0005\u0003\u001b\u0016\u0012qAQ8pY\u0016\fg\u000eF\u0004/\u001fB\u000b&k\u0015+\t\u000bAZ\u0001\u0019A\u0019\t\u000bqZ\u0001\u0019A\u001f\t\u000b\u0001[\u0001\u0019A\u001f\t\u000b\u0005[\u0001\u0019A\u001f\t\u000b\t[\u0001\u0019A\"\t\u000b)[\u0001\u0019A&\u0002\t)|\u0017N\u001c\t\u0003k]K!\u0001\u0017\u001c\u0003\u0013){\u0017N\\3e%><\u0018A\u00048v[&k\u0007/\u001a:bi&4Xm\u001d\t\u0003ImK!\u0001X\u0013\u0003\u0007%sG/\u0001\u0004ck\u001a4WM\u001d\t\u0003k}K!\u0001\u0019\u001c\u0003'M\u0003XmY5gS\u000eLe\u000e^3s]\u0006d'k\\<\u0002\u0015%t\u0017\u000e^5bY&TX\r\u0006\u0002dMB\u0011A\u0005Z\u0005\u0003K\u0016\u0012A!\u00168ji\")qm\u0004a\u00015\u0006!1/\u001b>f\u0003\u0019)\b\u000fZ1uKR\u00111M\u001b\u0005\u0006WB\u0001\r\u0001\\\u0001\u0006S:\u0004X\u000f\u001e\t\u0003[:l\u0011\u0001O\u0005\u0003_b\u00121\"\u00138uKJt\u0017\r\u001c*po\u0006AQM^1mk\u0006$X\r\u0006\u0002de\")1/\u0005a\u0001Y\u00061A/\u0019:hKRDQ!^\u0002A\u0002Y\f\u0011BZ;oGRLwN\\:\u0011\u0007\u0011\u0012t\u000f\u0005\u00026q&\u0011\u0011P\u000e\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007\"B>\u0004\u0001\u0004Q\u0016aB8sI&t\u0017\r\u001c\u0005\u0006{\u000e\u0001\rA`\u0001\u0010S:\u0004X\u000f^!uiJL'-\u001e;fgB)q0a\u0004\u0002\u00169!\u0011\u0011AA\u0006\u001d\u0011\t\u0019!!\u0003\u000e\u0005\u0005\u0015!bAA\u0004U\u00051AH]8pizJ\u0011AJ\u0005\u0004\u0003\u001b)\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003#\t\u0019BA\u0002TKFT1!!\u0004&!\r)\u0014qC\u0005\u0004\u000331$!C!uiJL'-\u001e;f\u0011\u001d\tib\u0001a\u0001\u0003?\tAC\\3x\u001bV$\u0018M\u00197f!J|'.Z2uS>t\u0007c\u0002\u0013\u0002\"\u0005\u0015b0P\u0005\u0004\u0003G)#!\u0003$v]\u000e$\u0018n\u001c83!\u0011y\u0018qB<")
public final class AggregateProcessor {
    private final MutableProjection initialProjection;
    private final MutableProjection updateProjection;
    private final MutableProjection evaluateProjection;
    private final ImperativeAggregate[] imperatives;
    private final boolean trackPartitionSize;
    private final JoinedRow join;
    private final int numImperatives;
    private final SpecificInternalRow buffer;

    public static AggregateProcessor apply(Expression[] expressionArray, int n, Seq<Attribute> seq, Function2<Seq<Expression>, Seq<Attribute>, MutableProjection> function2) {
        return AggregateProcessor$.MODULE$.apply(expressionArray, n, seq, function2);
    }

    public void initialize(int size) {
        if (this.trackPartitionSize) {
            this.buffer.setInt(0, size);
        }
        this.initialProjection.apply((Object)this.buffer);
        for (int i = 0; i < this.numImperatives; ++i) {
            this.imperatives[i].initialize((InternalRow)this.buffer);
        }
    }

    public void update(InternalRow input) {
        this.updateProjection.apply((Object)this.join.apply((InternalRow)this.buffer, input));
        for (int i = 0; i < this.numImperatives; ++i) {
            this.imperatives[i].update((InternalRow)this.buffer, input);
        }
    }

    public void evaluate(InternalRow target) {
        this.evaluateProjection.target(target).apply((Object)this.buffer);
    }

    public AggregateProcessor(AttributeReference[] bufferSchema, MutableProjection initialProjection, MutableProjection updateProjection, MutableProjection evaluateProjection, ImperativeAggregate[] imperatives, boolean trackPartitionSize) {
        this.initialProjection = initialProjection;
        this.updateProjection = updateProjection;
        this.evaluateProjection = evaluateProjection;
        this.imperatives = imperatives;
        this.trackPartitionSize = trackPartitionSize;
        this.join = new JoinedRow();
        this.numImperatives = imperatives.length;
        this.buffer = new SpecificInternalRow((Seq)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])bufferSchema)).map((Function1 & Serializable)x$3 -> x$3.dataType()));
        initialProjection.target((InternalRow)this.buffer);
        updateProjection.target((InternalRow)this.buffer);
    }
}

