/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.RuntimeConfig;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.streaming.EventTimeWatermarkExec;
import org.apache.spark.sql.execution.streaming.MultipleWatermarkPolicy;
import org.apache.spark.sql.execution.streaming.WatermarkTracker$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005\rf\u0001\u0002\u0010 \u00012B\u0001\u0002\u0013\u0001\u0003\u0016\u0004%\t!\u0013\u0005\t\u001d\u0002\u0011\t\u0012)A\u0005\u0015\")q\n\u0001C\u0001!\"91\u000b\u0001b\u0001\n\u0013!\u0006BB2\u0001A\u0003%Q\u000bC\u0004e\u0001\u0001\u0007I\u0011B3\t\u000f\u0019\u0004\u0001\u0019!C\u0005O\"1Q\u000e\u0001Q!\n\u0001DQA\u001c\u0001\u0005\u0002=DQA\u001d\u0001\u0005\u0002MDQA\u001f\u0001\u0005\u0002\u0015Dqa\u001f\u0001\u0002\u0002\u0013\u0005A\u0010C\u0004\u007f\u0001E\u0005I\u0011A@\t\u0013\u0005U\u0001!!A\u0005B\u0005]\u0001\"CA\u0015\u0001\u0005\u0005I\u0011AA\u0016\u0011%\ti\u0003AA\u0001\n\u0003\ty\u0003C\u0005\u0002:\u0001\t\t\u0011\"\u0011\u0002<!I\u0011Q\t\u0001\u0002\u0002\u0013\u0005\u0011q\t\u0005\n\u0003#\u0002\u0011\u0011!C!\u0003'B\u0011\"a\u0016\u0001\u0003\u0003%\t%!\u0017\t\u0013\u0005m\u0003!!A\u0005B\u0005u\u0003\"CA0\u0001\u0005\u0005I\u0011IA1\u000f\u001d\t)g\bE\u0001\u0003O2aAH\u0010\t\u0002\u0005%\u0004BB(\u0019\t\u0003\t)\bC\u0004\u0002xa!\t!!\u001f\t\u0013\u0005]\u0004$!A\u0005\u0002\u0006\u001d\u0005\"CAF1\u0005\u0005I\u0011QAG\u0011%\tI\nGA\u0001\n\u0013\tYJ\u0001\tXCR,'/\\1sWR\u0013\u0018mY6fe*\u0011\u0001%I\u0001\ngR\u0014X-Y7j]\u001eT!AI\u0012\u0002\u0013\u0015DXmY;uS>t'B\u0001\u0013&\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003M\u001d\nQa\u001d9be.T!\u0001K\u0015\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0013aA8sO\u000e\u00011#\u0002\u0001.geb\u0004C\u0001\u00182\u001b\u0005y#\"\u0001\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iz#AB!osJ+g\r\u0005\u00025o5\tQG\u0003\u00027K\u0005A\u0011N\u001c;fe:\fG.\u0003\u00029k\t9Aj\\4hS:<\u0007C\u0001\u0018;\u0013\tYtFA\u0004Qe>$Wo\u0019;\u0011\u0005u*eB\u0001 D\u001d\ty$)D\u0001A\u0015\t\t5&\u0001\u0004=e>|GOP\u0005\u0002a%\u0011AiL\u0001\ba\u0006\u001c7.Y4f\u0013\t1uI\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002E_\u00051\u0001o\u001c7jGf,\u0012A\u0013\t\u0003\u00172k\u0011aH\u0005\u0003\u001b~\u0011q#T;mi&\u0004H.Z,bi\u0016\u0014X.\u0019:l!>d\u0017nY=\u0002\u000fA|G.[2zA\u00051A(\u001b8jiz\"\"!\u0015*\u0011\u0005-\u0003\u0001\"\u0002%\u0004\u0001\u0004Q\u0015AF8qKJ\fGo\u001c:U_^\u000bG/\u001a:nCJ\\W*\u00199\u0016\u0003U\u0003BAV.^A6\tqK\u0003\u0002Y3\u00069Q.\u001e;bE2,'B\u0001.0\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u00039^\u0013q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0002/=&\u0011ql\f\u0002\u0004\u0013:$\bC\u0001\u0018b\u0013\t\u0011wF\u0001\u0003M_:<\u0017aF8qKJ\fGo\u001c:U_^\u000bG/\u001a:nCJ\\W*\u00199!\u0003E9Gn\u001c2bY^\u000bG/\u001a:nCJ\\Wj]\u000b\u0002A\u0006)r\r\\8cC2<\u0016\r^3s[\u0006\u00148.T:`I\u0015\fHC\u00015l!\tq\u0013.\u0003\u0002k_\t!QK\\5u\u0011\u001daw!!AA\u0002\u0001\f1\u0001\u001f\u00132\u0003I9Gn\u001c2bY^\u000bG/\u001a:nCJ\\Wj\u001d\u0011\u0002\u0019M,GoV1uKJl\u0017M]6\u0015\u0005!\u0004\b\"B9\n\u0001\u0004\u0001\u0017A\u00048fo^\u000bG/\u001a:nCJ\\Wj]\u0001\u0010kB$\u0017\r^3XCR,'/\\1sWR\u0011\u0001\u000e\u001e\u0005\u0006k*\u0001\rA^\u0001\rKb,7-\u001e;fIBc\u0017M\u001c\t\u0003obl\u0011!I\u0005\u0003s\u0006\u0012\u0011b\u00159be.\u0004F.\u00198\u0002!\r,(O]3oi^\u000bG/\u001a:nCJ\\\u0017\u0001B2paf$\"!U?\t\u000f!c\u0001\u0013!a\u0001\u0015\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u0001U\rQ\u00151A\u0016\u0003\u0003\u000b\u0001B!a\u0002\u0002\u00125\u0011\u0011\u0011\u0002\u0006\u0005\u0003\u0017\ti!A\u0005v]\u000eDWmY6fI*\u0019\u0011qB\u0018\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0014\u0005%!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!!\u0007\u0011\t\u0005m\u0011QE\u0007\u0003\u0003;QA!a\b\u0002\"\u0005!A.\u00198h\u0015\t\t\u0019#\u0001\u0003kCZ\f\u0017\u0002BA\u0014\u0003;\u0011aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLX#A/\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011\u0011GA\u001c!\rq\u00131G\u0005\u0004\u0003ky#aA!os\"9A\u000eEA\u0001\u0002\u0004i\u0016a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005u\u0002CBA \u0003\u0003\n\t$D\u0001Z\u0013\r\t\u0019%\u0017\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002J\u0005=\u0003c\u0001\u0018\u0002L%\u0019\u0011QJ\u0018\u0003\u000f\t{w\u000e\\3b]\"AANEA\u0001\u0002\u0004\t\t$\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA\r\u0003+Bq\u0001\\\n\u0002\u0002\u0003\u0007Q,\u0001\u0005iCND7i\u001c3f)\u0005i\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005e\u0011AB3rk\u0006d7\u000f\u0006\u0003\u0002J\u0005\r\u0004\u0002\u00037\u0017\u0003\u0003\u0005\r!!\r\u0002!]\u000bG/\u001a:nCJ\\GK]1dW\u0016\u0014\bCA&\u0019'\u0011AR&a\u001b\u0011\t\u00055\u00141O\u0007\u0003\u0003_RA!!\u001d\u0002\"\u0005\u0011\u0011n\\\u0005\u0004\r\u0006=DCAA4\u0003\u0015\t\u0007\u000f\u001d7z)\r\t\u00161\u0010\u0005\b\u0003{R\u0002\u0019AA@\u0003\u0011\u0019wN\u001c4\u0011\t\u0005\u0005\u00151Q\u0007\u0002G%\u0019\u0011QQ\u0012\u0003\u001bI+h\u000e^5nK\u000e{gNZ5h)\r\t\u0016\u0011\u0012\u0005\u0006\u0011n\u0001\rAS\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\ty)!&\u0011\t9\n\tJS\u0005\u0004\u0003'{#AB(qi&|g\u000e\u0003\u0005\u0002\u0018r\t\t\u00111\u0001R\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0003;\u0003B!a\u0007\u0002 &!\u0011\u0011UA\u000f\u0005\u0019y%M[3di\u0002")
public class WatermarkTracker
implements Logging,
Product,
Serializable {
    private final MultipleWatermarkPolicy policy;
    private final HashMap<Object, Object> operatorToWatermarkMap;
    private long globalWatermarkMs;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Option<MultipleWatermarkPolicy> unapply(WatermarkTracker watermarkTracker) {
        return WatermarkTracker$.MODULE$.unapply(watermarkTracker);
    }

    public static WatermarkTracker apply(MultipleWatermarkPolicy multipleWatermarkPolicy) {
        return WatermarkTracker$.MODULE$.apply(multipleWatermarkPolicy);
    }

    public static WatermarkTracker apply(RuntimeConfig runtimeConfig) {
        return WatermarkTracker$.MODULE$.apply(runtimeConfig);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public MultipleWatermarkPolicy policy() {
        return this.policy;
    }

    private HashMap<Object, Object> operatorToWatermarkMap() {
        return this.operatorToWatermarkMap;
    }

    private long globalWatermarkMs() {
        return this.globalWatermarkMs;
    }

    private void globalWatermarkMs_$eq(long x$1) {
        this.globalWatermarkMs = x$1;
    }

    public synchronized void setWatermark(long newWatermarkMs) {
        this.globalWatermarkMs_$eq(newWatermarkMs);
    }

    public synchronized void updateWatermark(SparkPlan executedPlan) {
        Seq watermarkOperators = executedPlan.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof EventTimeWatermarkExec) {
                    EventTimeWatermarkExec eventTimeWatermarkExec = (EventTimeWatermarkExec)A1;
                    object = eventTimeWatermarkExec;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x1) {
                SparkPlan sparkPlan = x1;
                boolean bl = sparkPlan instanceof EventTimeWatermarkExec;
                return bl;
            }
        });
        if (watermarkOperators.isEmpty()) {
            return;
        }
        ((IterableOnceOps)watermarkOperators.zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                EventTimeWatermarkExec e = (EventTimeWatermarkExec)tuple2._1();
                int index = tuple2._2$mcI$sp();
                if (e.eventTimeStats().value().count() > 0L) {
                    this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(28).append("Observed event time stats ").append(index).append(": ").append(e.eventTimeStats().value()).toString());
                    long newWatermarkMs = e.eventTimeStats().value().max() - e.delayMs();
                    Option prevWatermarkMs = this.operatorToWatermarkMap().get((Object)BoxesRunTime.boxToInteger((int)index));
                    return prevWatermarkMs.isEmpty() || newWatermarkMs > BoxesRunTime.unboxToLong((Object)prevWatermarkMs.get()) ? this.operatorToWatermarkMap().put((Object)BoxesRunTime.boxToInteger((int)index), (Object)BoxesRunTime.boxToLong((long)newWatermarkMs)) : BoxedUnit.UNIT;
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            int index = tuple2._2$mcI$sp();
            return !this.operatorToWatermarkMap().isDefinedAt((Object)BoxesRunTime.boxToInteger((int)index)) ? this.operatorToWatermarkMap().put((Object)BoxesRunTime.boxToInteger((int)index), (Object)BoxesRunTime.boxToLong((long)0L)) : BoxedUnit.UNIT;
        });
        long chosenGlobalWatermark = this.policy().chooseGlobalWatermark((Seq<Object>)this.operatorToWatermarkMap().values().toSeq());
        if (chosenGlobalWatermark > this.globalWatermarkMs()) {
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("Updating event-time watermark from ").append(this.globalWatermarkMs()).append(" to ").append(chosenGlobalWatermark).append(" ms").toString());
            this.globalWatermarkMs_$eq(chosenGlobalWatermark);
        } else {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(37).append("Event time watermark didn't move: ").append(chosenGlobalWatermark).append(" < ").append(this.globalWatermarkMs()).toString());
        }
    }

    public synchronized long currentWatermark() {
        return this.globalWatermarkMs();
    }

    public WatermarkTracker copy(MultipleWatermarkPolicy policy) {
        return new WatermarkTracker(policy);
    }

    public MultipleWatermarkPolicy copy$default$1() {
        return this.policy();
    }

    public String productPrefix() {
        return "WatermarkTracker";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.policy();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof WatermarkTracker;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "policy";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof WatermarkTracker)) return false;
        boolean bl = true;
        if (!bl) return false;
        WatermarkTracker watermarkTracker = (WatermarkTracker)x$1;
        MultipleWatermarkPolicy multipleWatermarkPolicy = this.policy();
        MultipleWatermarkPolicy multipleWatermarkPolicy2 = watermarkTracker.policy();
        if (multipleWatermarkPolicy == null) {
            if (multipleWatermarkPolicy2 != null) {
                return false;
            }
        } else if (!multipleWatermarkPolicy.equals(multipleWatermarkPolicy2)) return false;
        if (!watermarkTracker.canEqual(this)) return false;
        return true;
    }

    public WatermarkTracker(MultipleWatermarkPolicy policy) {
        this.policy = policy;
        Logging.$init$((Logging)this);
        Product.$init$((Product)this);
        this.operatorToWatermarkMap = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.globalWatermarkMs = 0L;
    }
}

