/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.adaptive;

import java.io.Serializable;
import org.apache.commons.io.FileUtils;
import org.apache.spark.MapOutputStatistics;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.optimizer.BuildSide;
import org.apache.spark.sql.catalyst.plans.Cross$;
import org.apache.spark.sql.catalyst.plans.Inner$;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.LeftAnti$;
import org.apache.spark.sql.catalyst.plans.LeftOuter$;
import org.apache.spark.sql.catalyst.plans.LeftSemi$;
import org.apache.spark.sql.catalyst.plans.RightOuter$;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.execution.CoalescedPartitionSpec;
import org.apache.spark.sql.execution.CoalescedPartitionSpec$;
import org.apache.spark.sql.execution.PartialReducerPartitionSpec;
import org.apache.spark.sql.execution.ShufflePartitionSpec;
import org.apache.spark.sql.execution.SortExec;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.adaptive.AQEShuffleReadExec$;
import org.apache.spark.sql.execution.adaptive.AQEShuffleReadRule;
import org.apache.spark.sql.execution.adaptive.OptimizeSkewedJoin$ShuffleStage$;
import org.apache.spark.sql.execution.adaptive.ShufflePartitionsUtil$;
import org.apache.spark.sql.execution.adaptive.ShuffleQueryStageExec;
import org.apache.spark.sql.execution.exchange.ENSURE_REQUIREMENTS$;
import org.apache.spark.sql.execution.exchange.ShuffleExchangeLike;
import org.apache.spark.sql.execution.exchange.ShuffleOrigin;
import org.apache.spark.sql.execution.joins.ShuffledHashJoinExec;
import org.apache.spark.sql.execution.joins.SortMergeJoinExec;
import org.apache.spark.sql.internal.SQLConf$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class OptimizeSkewedJoin$
extends Rule<SparkPlan>
implements AQEShuffleReadRule {
    public static final OptimizeSkewedJoin$ MODULE$ = new OptimizeSkewedJoin$();
    private static final Seq<ShuffleOrigin> supportedShuffleOrigins;

    static {
        AQEShuffleReadRule.$init$(MODULE$);
        supportedShuffleOrigins = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ENSURE_REQUIREMENTS$[]{ENSURE_REQUIREMENTS$.MODULE$}));
    }

    @Override
    public boolean isSupported(ShuffleExchangeLike shuffle) {
        return AQEShuffleReadRule.isSupported$(this, shuffle);
    }

    @Override
    public Seq<ShuffleOrigin> supportedShuffleOrigins() {
        return supportedShuffleOrigins;
    }

    public long getSkewThreshold(long medianSize) {
        return RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(BoxesRunTime.unboxToLong((Object)this.conf().getConf(SQLConf$.MODULE$.SKEW_JOIN_SKEWED_PARTITION_THRESHOLD()))), medianSize * (long)BoxesRunTime.unboxToInt((Object)this.conf().getConf(SQLConf$.MODULE$.SKEW_JOIN_SKEWED_PARTITION_FACTOR())));
    }

    private long medianSize(long[] sizes) {
        int numPartitions = sizes.length;
        long[] bytes = (long[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.longArrayOps(sizes), (Ordering)Ordering.Long$.MODULE$);
        int n = numPartitions;
        switch (n) {
            default: 
        }
        return numPartitions % 2 == 0 ? scala.math.package$.MODULE$.max((bytes[numPartitions / 2] + bytes[numPartitions / 2 - 1]) / 2L, 1L) : scala.math.package$.MODULE$.max(bytes[numPartitions / 2], 1L);
    }

    private long targetSize(long[] sizes, long skewThreshold) {
        long advisorySize = BoxesRunTime.unboxToLong((Object)this.conf().getConf(SQLConf$.MODULE$.ADVISORY_PARTITION_SIZE_IN_BYTES()));
        long[] nonSkewSizes = (long[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.longArrayOps(sizes), (Function1)(JFunction1.mcZJ.sp & Serializable)x$1 -> x$1 <= skewThreshold);
        return ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.longArrayOps(nonSkewSizes)) ? advisorySize : scala.math.package$.MODULE$.max(advisorySize, BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.wrapLongArray(nonSkewSizes).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / (long)nonSkewSizes.length);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean canSplitLeftSide(JoinType joinType) {
        JoinType joinType2 = joinType;
        Inner$ inner$ = Inner$.MODULE$;
        if (joinType2 == null) {
            if (inner$ == null) return true;
        } else if (joinType2.equals(inner$)) return true;
        JoinType joinType3 = joinType;
        Cross$ cross$ = Cross$.MODULE$;
        if (joinType3 == null) {
            if (cross$ == null) return true;
        } else if (joinType3.equals(cross$)) return true;
        JoinType joinType4 = joinType;
        LeftSemi$ leftSemi$ = LeftSemi$.MODULE$;
        if (joinType4 == null) {
            if (leftSemi$ == null) return true;
        } else if (joinType4.equals(leftSemi$)) return true;
        JoinType joinType5 = joinType;
        LeftAnti$ leftAnti$ = LeftAnti$.MODULE$;
        if (joinType5 == null) {
            if (leftAnti$ == null) return true;
        } else if (joinType5.equals(leftAnti$)) return true;
        JoinType joinType6 = joinType;
        LeftOuter$ leftOuter$ = LeftOuter$.MODULE$;
        if (joinType6 != null) {
            if (!joinType6.equals(leftOuter$)) return false;
            return true;
        }
        if (leftOuter$ == null) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean canSplitRightSide(JoinType joinType) {
        JoinType joinType2 = joinType;
        Inner$ inner$ = Inner$.MODULE$;
        if (joinType2 == null) {
            if (inner$ == null) return true;
        } else if (joinType2.equals(inner$)) return true;
        JoinType joinType3 = joinType;
        Cross$ cross$ = Cross$.MODULE$;
        if (joinType3 == null) {
            if (cross$ == null) return true;
        } else if (joinType3.equals(cross$)) return true;
        JoinType joinType4 = joinType;
        RightOuter$ rightOuter$ = RightOuter$.MODULE$;
        if (joinType4 != null) {
            if (!joinType4.equals(rightOuter$)) return false;
            return true;
        }
        if (rightOuter$ == null) return true;
        return false;
    }

    private String getSizeInfo(long medianSize, long[] sizes) {
        return new StringBuilder(0).append(new StringBuilder(49).append("median size: ").append(medianSize).append(", max size: ").append(Predef$.MODULE$.wrapLongArray(sizes).max((Ordering)Ordering.Long$.MODULE$)).append(", min size: ").append(Predef$.MODULE$.wrapLongArray(sizes).min((Ordering)Ordering.Long$.MODULE$)).append(", avg size: ").toString()).append(BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.wrapLongArray(sizes).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / (long)sizes.length).toString();
    }

    public Option<Tuple2<SparkPlan, SparkPlan>> org$apache$spark$sql$execution$adaptive$OptimizeSkewedJoin$$tryOptimizeJoinChildren(ShuffleQueryStageExec left, ShuffleQueryStageExec right, JoinType joinType) {
        long[] rightSizes;
        boolean canSplitLeft = this.canSplitLeftSide(joinType);
        boolean canSplitRight = this.canSplitRightSide(joinType);
        if (!canSplitLeft && !canSplitRight) {
            return None$.MODULE$;
        }
        long[] leftSizes = ((MapOutputStatistics)left.mapStats().get()).bytesByPartitionId();
        Predef$.MODULE$.assert(leftSizes.length == (rightSizes = ((MapOutputStatistics)right.mapStats().get()).bytesByPartitionId()).length);
        int numPartitions = leftSizes.length;
        long leftMedSize = this.medianSize(leftSizes);
        long rightMedSize = this.medianSize(rightSizes);
        this.logDebug((Function0 & Serializable)() -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(148).append("\n         |Optimizing skewed join.\n         |Left side partitions size info:\n         |").append(MODULE$.getSizeInfo(leftMedSize, leftSizes)).append("\n         |Right side partitions size info:\n         |").append(MODULE$.getSizeInfo(rightMedSize, rightSizes)).append("\n      ").toString())));
        long leftSkewThreshold = this.getSkewThreshold(leftMedSize);
        long rightSkewThreshold = this.getSkewThreshold(rightMedSize);
        long leftTargetSize = this.targetSize(leftSizes, leftSkewThreshold);
        long rightTargetSize = this.targetSize(rightSizes, rightSkewThreshold);
        ArrayBuffer leftSidePartitions = ArrayBuffer$.MODULE$.empty();
        ArrayBuffer rightSidePartitions = ArrayBuffer$.MODULE$.empty();
        IntRef numSkewedLeft = IntRef.create((int)0);
        IntRef numSkewedRight = IntRef.create((int)0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numPartitions).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)partitionIndex -> {
            Seq seq;
            Seq leftParts;
            Seq seq2;
            long leftSize = leftSizes[partitionIndex];
            boolean isLeftSkew = canSplitLeft && leftSize > leftSkewThreshold;
            long rightSize = rightSizes[partitionIndex];
            boolean isRightSkew = canSplitRight && rightSize > rightSkewThreshold;
            Seq leftNoSkewPartitionSpec = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CoalescedPartitionSpec[]{CoalescedPartitionSpec$.MODULE$.apply(partitionIndex, partitionIndex + 1, leftSize)}));
            Seq rightNoSkewPartitionSpec = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CoalescedPartitionSpec[]{CoalescedPartitionSpec$.MODULE$.apply(partitionIndex, partitionIndex + 1, rightSize)}));
            if (isLeftSkew) {
                Option<Seq<PartialReducerPartitionSpec>> skewSpecs = ShufflePartitionsUtil$.MODULE$.createSkewPartitionSpecs(((MapOutputStatistics)left.mapStats().get()).shuffleId(), partitionIndex, leftTargetSize);
                if (skewSpecs.isDefined()) {
                    MODULE$.logDebug((Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(21).append("Left side partition ").append(partitionIndex).append(" ").toString()).append(new StringBuilder(14).append("(").append(FileUtils.byteCountToDisplaySize((long)leftSize)).append(") is skewed, ").toString()).append(new StringBuilder(21).append("split it into ").append(((SeqOps)skewSpecs.get()).length()).append(" parts.").toString()).toString());
                    ++numSkewedLeft$1.elem;
                }
                seq2 = (Seq)skewSpecs.getOrElse((Function0 & Serializable)() -> leftNoSkewPartitionSpec);
            } else {
                seq2 = leftParts = leftNoSkewPartitionSpec;
            }
            if (isRightSkew) {
                Option<Seq<PartialReducerPartitionSpec>> skewSpecs = ShufflePartitionsUtil$.MODULE$.createSkewPartitionSpecs(((MapOutputStatistics)right.mapStats().get()).shuffleId(), partitionIndex, rightTargetSize);
                if (skewSpecs.isDefined()) {
                    MODULE$.logDebug((Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(22).append("Right side partition ").append(partitionIndex).append(" ").toString()).append(new StringBuilder(14).append("(").append(FileUtils.byteCountToDisplaySize((long)rightSize)).append(") is skewed, ").toString()).append(new StringBuilder(21).append("split it into ").append(((SeqOps)skewSpecs.get()).length()).append(" parts.").toString()).toString());
                    ++numSkewedRight$1.elem;
                }
                seq = (Seq)skewSpecs.getOrElse((Function0 & Serializable)() -> rightNoSkewPartitionSpec);
            } else {
                seq = rightNoSkewPartitionSpec;
            }
            Seq rightParts = seq;
            leftParts.foreach((Function1 & Serializable)leftSidePartition -> {
                rightParts.foreach((Function1 & Serializable)rightSidePartition -> {
                    leftSidePartitions$1.$plus$eq((Object)leftSidePartition);
                    return (ArrayBuffer)rightSidePartitions$1.$plus$eq(rightSidePartition);
                });
                return BoxedUnit.UNIT;
            });
        });
        this.logDebug((Function0 & Serializable)() -> new StringBuilder(42).append("number of skewed partitions: left ").append(numSkewedLeft$1.elem).append(", right ").append(numSkewedRight$1.elem).toString());
        return numSkewedLeft.elem > 0 || numSkewedRight.elem > 0 ? new Some((Object)new Tuple2((Object)AQEShuffleReadExec$.MODULE$.apply(left, (Seq<ShufflePartitionSpec>)leftSidePartitions.toSeq()), (Object)AQEShuffleReadExec$.MODULE$.apply(right, (Seq<ShufflePartitionSpec>)rightSidePartitions.toSeq()))) : None$.MODULE$;
    }

    public SparkPlan optimizeSkewJoin(SparkPlan plan) {
        return (SparkPlan)plan.transformUp((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof SortMergeJoinExec) {
                    ShuffleQueryStageExec left;
                    Option<ShuffleQueryStageExec> option;
                    SortExec sortExec;
                    SparkPlan sparkPlan;
                    SortMergeJoinExec sortMergeJoinExec = (SortMergeJoinExec)A1;
                    JoinType joinType = sortMergeJoinExec.joinType();
                    SparkPlan s1 = sortMergeJoinExec.left();
                    SparkPlan s2 = sortMergeJoinExec.right();
                    boolean bl = sortMergeJoinExec.isSkewJoin();
                    if (s1 instanceof SortExec && (sparkPlan = (sortExec = (SortExec)s1).child()) != null && !(option = OptimizeSkewedJoin$ShuffleStage$.MODULE$.unapply(sparkPlan)).isEmpty() && (left = (ShuffleQueryStageExec)option.get()) != null) {
                        ShuffleQueryStageExec right;
                        Option<ShuffleQueryStageExec> option2;
                        SortExec sortExec2;
                        SparkPlan sparkPlan2;
                        ShuffleQueryStageExec shuffleQueryStageExec = left;
                        if (s2 instanceof SortExec && (sparkPlan2 = (sortExec2 = (SortExec)s2).child()) != null && !(option2 = OptimizeSkewedJoin$ShuffleStage$.MODULE$.unapply(sparkPlan2)).isEmpty() && (right = (ShuffleQueryStageExec)option2.get()) != null) {
                            ShuffleQueryStageExec shuffleQueryStageExec2 = right;
                            if (!bl) {
                                SortMergeJoinExec sortMergeJoinExec2;
                                Option<Tuple2<SparkPlan, SparkPlan>> newChildren = OptimizeSkewedJoin$.MODULE$.org$apache$spark$sql$execution$adaptive$OptimizeSkewedJoin$$tryOptimizeJoinChildren(shuffleQueryStageExec, shuffleQueryStageExec2, joinType);
                                if (newChildren.isDefined()) {
                                    Tuple2 tuple2 = (Tuple2)newChildren.get();
                                    if (tuple2 == null) throw new MatchError((Object)tuple2);
                                    SparkPlan newLeft = (SparkPlan)tuple2._1();
                                    SparkPlan newRight = (SparkPlan)tuple2._2();
                                    Tuple2 tuple22 = new Tuple2((Object)newLeft, (Object)newRight);
                                    Tuple2 tuple23 = tuple22;
                                    SparkPlan newLeft2 = (SparkPlan)tuple23._1();
                                    SparkPlan newRight2 = (SparkPlan)tuple23._2();
                                    SparkPlan x$1 = newLeft2;
                                    Seq<SortOrder> x$2 = sortExec.copy$default$1();
                                    boolean x$3 = sortExec.copy$default$2();
                                    int x$4 = sortExec.copy$default$4();
                                    SortExec x$9 = sortExec.copy(x$2, x$3, x$1, x$4);
                                    SparkPlan x$5 = newRight2;
                                    Seq<SortOrder> x$6 = sortExec2.copy$default$1();
                                    boolean x$7 = sortExec2.copy$default$2();
                                    int x$8 = sortExec2.copy$default$4();
                                    SortExec x$10 = sortExec2.copy(x$6, x$7, x$5, x$8);
                                    boolean x$11 = true;
                                    Seq<Expression> x$12 = sortMergeJoinExec.copy$default$1();
                                    Seq<Expression> x$13 = sortMergeJoinExec.copy$default$2();
                                    JoinType x$14 = sortMergeJoinExec.copy$default$3();
                                    Option<Expression> x$15 = sortMergeJoinExec.copy$default$4();
                                    sortMergeJoinExec2 = sortMergeJoinExec.copy(x$12, x$13, x$14, x$15, x$9, x$10, true);
                                } else {
                                    sortMergeJoinExec2 = sortMergeJoinExec;
                                }
                                object = sortMergeJoinExec2;
                                return (B1)object;
                            }
                        }
                    }
                }
                if (A1 instanceof ShuffledHashJoinExec) {
                    ShuffleQueryStageExec left;
                    Option<ShuffleQueryStageExec> option;
                    ShuffledHashJoinExec shuffledHashJoinExec = (ShuffledHashJoinExec)A1;
                    JoinType joinType = shuffledHashJoinExec.joinType();
                    SparkPlan sparkPlan = shuffledHashJoinExec.left();
                    SparkPlan sparkPlan3 = shuffledHashJoinExec.right();
                    boolean bl = shuffledHashJoinExec.isSkewJoin();
                    if (sparkPlan != null && !(option = OptimizeSkewedJoin$ShuffleStage$.MODULE$.unapply(sparkPlan)).isEmpty() && (left = (ShuffleQueryStageExec)option.get()) != null) {
                        ShuffleQueryStageExec right;
                        Option<ShuffleQueryStageExec> option3;
                        ShuffleQueryStageExec shuffleQueryStageExec = left;
                        if (sparkPlan3 != null && !(option3 = OptimizeSkewedJoin$ShuffleStage$.MODULE$.unapply(sparkPlan3)).isEmpty() && (right = (ShuffleQueryStageExec)option3.get()) != null) {
                            ShuffleQueryStageExec shuffleQueryStageExec3 = right;
                            if (!bl) {
                                ShuffledHashJoinExec shuffledHashJoinExec2;
                                Option<Tuple2<SparkPlan, SparkPlan>> newChildren = OptimizeSkewedJoin$.MODULE$.org$apache$spark$sql$execution$adaptive$OptimizeSkewedJoin$$tryOptimizeJoinChildren(shuffleQueryStageExec, shuffleQueryStageExec3, joinType);
                                if (newChildren.isDefined()) {
                                    Tuple2 tuple2 = (Tuple2)newChildren.get();
                                    if (tuple2 == null) throw new MatchError((Object)tuple2);
                                    SparkPlan newLeft = (SparkPlan)tuple2._1();
                                    SparkPlan newRight = (SparkPlan)tuple2._2();
                                    Tuple2 tuple24 = new Tuple2((Object)newLeft, (Object)newRight);
                                    Tuple2 tuple25 = tuple24;
                                    SparkPlan newLeft3 = (SparkPlan)tuple25._1();
                                    SparkPlan newRight3 = (SparkPlan)tuple25._2();
                                    SparkPlan x$16 = newLeft3;
                                    SparkPlan x$17 = newRight3;
                                    boolean x$18 = true;
                                    Seq<Expression> x$19 = shuffledHashJoinExec.copy$default$1();
                                    Seq<Expression> x$20 = shuffledHashJoinExec.copy$default$2();
                                    JoinType x$21 = shuffledHashJoinExec.copy$default$3();
                                    BuildSide x$22 = shuffledHashJoinExec.copy$default$4();
                                    Option<Expression> x$23 = shuffledHashJoinExec.copy$default$5();
                                    shuffledHashJoinExec2 = shuffledHashJoinExec.copy(x$19, x$20, x$21, x$22, x$23, x$16, x$17, true);
                                } else {
                                    shuffledHashJoinExec2 = shuffledHashJoinExec;
                                }
                                object = shuffledHashJoinExec2;
                                return (B1)object;
                            }
                        }
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(SparkPlan x1) {
                SparkPlan sparkPlan = x1;
                if (sparkPlan instanceof SortMergeJoinExec) {
                    ShuffleQueryStageExec right;
                    Option<ShuffleQueryStageExec> option;
                    SortExec sortExec;
                    SparkPlan sparkPlan2;
                    ShuffleQueryStageExec left;
                    Option<ShuffleQueryStageExec> option2;
                    SortExec sortExec2;
                    SparkPlan sparkPlan3;
                    SortMergeJoinExec sortMergeJoinExec = (SortMergeJoinExec)sparkPlan;
                    SparkPlan s1 = sortMergeJoinExec.left();
                    SparkPlan s2 = sortMergeJoinExec.right();
                    boolean bl = sortMergeJoinExec.isSkewJoin();
                    if (s1 instanceof SortExec && (sparkPlan3 = (sortExec2 = (SortExec)s1).child()) != null && !(option2 = OptimizeSkewedJoin$ShuffleStage$.MODULE$.unapply(sparkPlan3)).isEmpty() && (left = (ShuffleQueryStageExec)option2.get()) != null && s2 instanceof SortExec && (sparkPlan2 = (sortExec = (SortExec)s2).child()) != null && !(option = OptimizeSkewedJoin$ShuffleStage$.MODULE$.unapply(sparkPlan2)).isEmpty() && (right = (ShuffleQueryStageExec)option.get()) != null && !bl) {
                        return true;
                    }
                }
                if (!(sparkPlan instanceof ShuffledHashJoinExec)) return false;
                ShuffledHashJoinExec shuffledHashJoinExec = (ShuffledHashJoinExec)sparkPlan;
                SparkPlan sparkPlan4 = shuffledHashJoinExec.left();
                SparkPlan sparkPlan5 = shuffledHashJoinExec.right();
                boolean bl = shuffledHashJoinExec.isSkewJoin();
                if (sparkPlan4 == null) return false;
                Option<ShuffleQueryStageExec> option = OptimizeSkewedJoin$ShuffleStage$.MODULE$.unapply(sparkPlan4);
                if (option.isEmpty()) return false;
                ShuffleQueryStageExec left = (ShuffleQueryStageExec)option.get();
                if (left == null) return false;
                if (sparkPlan5 == null) return false;
                Option<ShuffleQueryStageExec> option3 = OptimizeSkewedJoin$ShuffleStage$.MODULE$.unapply(sparkPlan5);
                if (option3.isEmpty()) return false;
                ShuffleQueryStageExec right = (ShuffleQueryStageExec)option3.get();
                if (right == null) return false;
                if (false != bl) return false;
                return true;
            }
        });
    }

    public SparkPlan apply(SparkPlan plan) {
        if (!BoxesRunTime.unboxToBoolean((Object)this.conf().getConf(SQLConf$.MODULE$.SKEW_JOIN_ENABLED()))) {
            return plan;
        }
        Seq shuffleStages = OptimizeSkewedJoin$.collectShuffleStages$1(plan);
        return shuffleStages.length() == 2 ? this.optimizeSkewJoin(plan) : plan;
    }

    private static final Seq collectShuffleStages$1(SparkPlan plan2) {
        Seq seq;
        SparkPlan sparkPlan = plan2;
        if (sparkPlan instanceof ShuffleQueryStageExec) {
            ShuffleQueryStageExec shuffleQueryStageExec = (ShuffleQueryStageExec)sparkPlan;
            seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ShuffleQueryStageExec[]{shuffleQueryStageExec}));
        } else {
            seq = (Seq)plan2.children().flatMap((Function1 & Serializable)plan -> OptimizeSkewedJoin$.collectShuffleStages$1(plan));
        }
        return seq;
    }

    private OptimizeSkewedJoin$() {
    }
}

