/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.csv;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.csv.CSVHeaderChecker;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.catalyst.csv.UnivocityParser;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.util.CompressionCodecs$;
import org.apache.spark.sql.execution.datasources.CodecStreams$;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.TextBasedFileFormat;
import org.apache.spark.sql.execution.datasources.csv.CSVDataSource;
import org.apache.spark.sql.execution.datasources.csv.CSVDataSource$;
import org.apache.spark.sql.execution.datasources.csv.CsvOutputWriter;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.AnsiIntervalType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Ud\u0001B\u0006\r\u0001mAQA\n\u0001\u0005\u0002\u001dBQA\u000b\u0001\u0005B-BQ!\u000f\u0001\u0005BiBQ\u0001\u0016\u0001\u0005BUCQa\u001c\u0001\u0005BADq!!\u0001\u0001\t\u0003\n\u0019\u0001\u0003\u0004\u0002N\u0001!\te\u000b\u0005\b\u0003\u001f\u0002A\u0011IA)\u0011\u001d\tI\u0006\u0001C!\u00037Bq!a\u001a\u0001\t\u0003\nIGA\u0007D'Z3\u0015\u000e\\3G_Jl\u0017\r\u001e\u0006\u0003\u001b9\t1aY:w\u0015\ty\u0001#A\u0006eCR\f7o\\;sG\u0016\u001c(BA\t\u0013\u0003%)\u00070Z2vi&|gN\u0003\u0002\u0014)\u0005\u00191/\u001d7\u000b\u0005U1\u0012!B:qCJ\\'BA\f\u0019\u0003\u0019\t\u0007/Y2iK*\t\u0011$A\u0002pe\u001e\u001c\u0001aE\u0002\u00019\u0001\u0002\"!\b\u0010\u000e\u00039I!a\b\b\u0003'Q+\u0007\u0010\u001e\"bg\u0016$g)\u001b7f\r>\u0014X.\u0019;\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0005\r\u0012\u0012aB:pkJ\u001cWm]\u0005\u0003K\t\u0012!\u0003R1uCN{WO]2f%\u0016<\u0017n\u001d;fe\u00061A(\u001b8jiz\"\u0012\u0001\u000b\t\u0003S\u0001i\u0011\u0001D\u0001\ng\"|'\u000f\u001e(b[\u0016$\u0012\u0001\f\t\u0003[Yr!A\f\u001b\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0005ER\u0012A\u0002\u001fs_>$hHC\u00014\u0003\u0015\u00198-\u00197b\u0013\t)$'\u0001\u0004Qe\u0016$WMZ\u0005\u0003oa\u0012aa\u0015;sS:<'BA\u001b3\u0003-I7o\u00159mSR\f'\r\\3\u0015\tmzTI\u0013\t\u0003yuj\u0011AM\u0005\u0003}I\u0012qAQ8pY\u0016\fg\u000eC\u0003A\u0007\u0001\u0007\u0011)\u0001\u0007ta\u0006\u00148nU3tg&|g\u000e\u0005\u0002C\u00076\t!#\u0003\u0002E%\ta1\u000b]1sWN+7o]5p]\")ai\u0001a\u0001\u000f\u00069q\u000e\u001d;j_:\u001c\b\u0003B\u0017IY1J!!\u0013\u001d\u0003\u00075\u000b\u0007\u000fC\u0003L\u0007\u0001\u0007A*\u0001\u0003qCRD\u0007CA'S\u001b\u0005q%BA(Q\u0003\t17O\u0003\u0002R-\u00051\u0001.\u00193p_BL!a\u0015(\u0003\tA\u000bG\u000f[\u0001\fS:4WM]*dQ\u0016l\u0017\r\u0006\u0003W?\u0002\f\u0007c\u0001\u001fX3&\u0011\u0001L\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005ikV\"A.\u000b\u0005q\u0013\u0012!\u0002;za\u0016\u001c\u0018B\u00010\\\u0005)\u0019FO];diRK\b/\u001a\u0005\u0006\u0001\u0012\u0001\r!\u0011\u0005\u0006\r\u0012\u0001\ra\u0012\u0005\u0006E\u0012\u0001\raY\u0001\u0006M&dWm\u001d\t\u0004I&dgBA3h\u001d\tyc-C\u00014\u0013\tA''A\u0004qC\u000e\\\u0017mZ3\n\u0005)\\'aA*fc*\u0011\u0001N\r\t\u0003\u001b6L!A\u001c(\u0003\u0015\u0019KG.Z*uCR,8/\u0001\u0007qe\u0016\u0004\u0018M]3Xe&$X\rF\u0003riVlh\u0010\u0005\u0002\u001ee&\u00111O\u0004\u0002\u0014\u001fV$\b/\u001e;Xe&$XM\u001d$bGR|'/\u001f\u0005\u0006\u0001\u0016\u0001\r!\u0011\u0005\u0006m\u0016\u0001\ra^\u0001\u0004U>\u0014\u0007C\u0001=|\u001b\u0005I(B\u0001>Q\u0003%i\u0017\r\u001d:fIV\u001cW-\u0003\u0002}s\n\u0019!j\u001c2\t\u000b\u0019+\u0001\u0019A$\t\u000b},\u0001\u0019A-\u0002\u0015\u0011\fG/Y*dQ\u0016l\u0017-A\u0006ck&dGMU3bI\u0016\u0014H\u0003EA\u0003\u0003G\t)#a\n\u0002,\u0005=\u00121HA\u001f!\u001da\u0014qAA\u0006\u0003#I1!!\u00033\u0005%1UO\\2uS>t\u0017\u0007E\u0002\u001e\u0003\u001bI1!a\u0004\u000f\u0005=\u0001\u0016M\u001d;ji&|g.\u001a3GS2,\u0007#\u00023\u0002\u0014\u0005]\u0011bAA\u000bW\nA\u0011\n^3sCR|'\u000f\u0005\u0003\u0002\u001a\u0005}QBAA\u000e\u0015\r\tiBE\u0001\tG\u0006$\u0018\r\\=ti&!\u0011\u0011EA\u000e\u0005-Ie\u000e^3s]\u0006d'k\\<\t\u000b\u00013\u0001\u0019A!\t\u000b}4\u0001\u0019A-\t\r\u0005%b\u00011\u0001Z\u0003=\u0001\u0018M\u001d;ji&|gnU2iK6\f\u0007BBA\u0017\r\u0001\u0007\u0011,\u0001\bsKF,\u0018N]3e'\u000eDW-\\1\t\u000f\u0005Eb\u00011\u0001\u00024\u00059a-\u001b7uKJ\u001c\b\u0003\u00023j\u0003k\u00012!IA\u001c\u0013\r\tID\t\u0002\u0007\r&dG/\u001a:\t\u000b\u00193\u0001\u0019A$\t\u000f\u0005}b\u00011\u0001\u0002B\u0005Q\u0001.\u00193p_B\u001cuN\u001c4\u0011\t\u0005\r\u0013\u0011J\u0007\u0003\u0003\u000bR1!a\u0012Q\u0003\u0011\u0019wN\u001c4\n\t\u0005-\u0013Q\t\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\u0011Q|7\u000b\u001e:j]\u001e\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003'\u00022\u0001PA+\u0013\r\t9F\r\u0002\u0004\u0013:$\u0018AB3rk\u0006d7\u000fF\u0002<\u0003;Bq!a\u0018\n\u0001\u0004\t\t'A\u0003pi\",'\u000fE\u0002=\u0003GJ1!!\u001a3\u0005\r\te._\u0001\u0010gV\u0004\bo\u001c:u\t\u0006$\u0018\rV=qKR\u00191(a\u001b\t\u000f\u00055$\u00021\u0001\u0002p\u0005AA-\u0019;b)f\u0004X\rE\u0002[\u0003cJ1!a\u001d\\\u0005!!\u0015\r^1UsB,\u0007")
public class CSVFileFormat
extends TextBasedFileFormat
implements DataSourceRegister {
    @Override
    public String shortName() {
        return "csv";
    }

    @Override
    public boolean isSplitable(SparkSession sparkSession, Map<String, String> options, Path path) {
        CSVOptions parsedOptions = new CSVOptions(options, sparkSession.sessionState().conf().csvColumnPruning(), sparkSession.sessionState().conf().sessionLocalTimeZone());
        CSVDataSource csvDataSource = CSVDataSource$.MODULE$.apply(parsedOptions);
        return csvDataSource.isSplitable() && super.isSplitable(sparkSession, options, path);
    }

    @Override
    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        CSVOptions parsedOptions = new CSVOptions(options, sparkSession.sessionState().conf().csvColumnPruning(), sparkSession.sessionState().conf().sessionLocalTimeZone());
        return CSVDataSource$.MODULE$.apply(parsedOptions).inferSchema(sparkSession, files, parsedOptions);
    }

    @Override
    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        Configuration conf = job.getConfiguration();
        CSVOptions csvOptions = new CSVOptions(options, sparkSession.sessionState().conf().csvColumnPruning(), sparkSession.sessionState().conf().sessionLocalTimeZone());
        csvOptions.compressionCodec().foreach((Function1 & Serializable)codec -> {
            CompressionCodecs$.MODULE$.setCodecConfiguration(conf, codec);
            return BoxedUnit.UNIT;
        });
        return new OutputWriterFactory(null, csvOptions){
            private final CSVOptions csvOptions$1;

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new CsvOutputWriter(path, dataSchema, context, this.csvOptions$1);
            }

            public String getFileExtension(TaskAttemptContext context) {
                return new StringBuilder(4).append(".csv").append(CodecStreams$.MODULE$.getCompressionExtension((JobContext)context)).toString();
            }
            {
                this.csvOptions$1 = csvOptions$1;
            }
        };
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        boolean columnPruning = sparkSession.sessionState().conf().csvColumnPruning() && !requiredSchema.exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CSVFileFormat.$anonfun$buildReader$1(sparkSession, x$1)));
        CSVOptions parsedOptions = new CSVOptions(options, columnPruning, sparkSession.sessionState().conf().sessionLocalTimeZone(), sparkSession.sessionState().conf().columnNameOfCorruptRecord());
        ExprUtils$.MODULE$.verifyColumnNameOfCorruptRecord(dataSchema, parsedOptions.columnNameOfCorruptRecord());
        Seq actualFilters = (Seq)filters.filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])x$2.references()), (Object)parsedOptions.columnNameOfCorruptRecord())));
        return (Function1 & Serializable)file -> {
            Configuration conf = ((SerializableConfiguration)broadcastedHadoopConf.value()).value();
            StructType actualDataSchema = StructType$.MODULE$.apply((Seq)dataSchema.filterNot((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)CSVFileFormat.$anonfun$buildReader$4(parsedOptions, x$3))));
            StructType actualRequiredSchema = StructType$.MODULE$.apply((Seq)requiredSchema.filterNot((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)CSVFileFormat.$anonfun$buildReader$5(parsedOptions, x$4))));
            UnivocityParser parser = new UnivocityParser(actualDataSchema, actualRequiredSchema, parsedOptions, actualFilters);
            StructType schema = columnPruning ? actualRequiredSchema : actualDataSchema;
            boolean isStartOfFile = file.start() == 0L;
            CSVHeaderChecker headerChecker = new CSVHeaderChecker(schema, parsedOptions, new StringBuilder(10).append("CSV file: ").append(file.filePath()).toString(), isStartOfFile);
            return CSVDataSource$.MODULE$.apply(parsedOptions).readFile(conf, (PartitionedFile)file, parser, headerChecker, requiredSchema);
        };
    }

    public String toString() {
        return "CSV";
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof CSVFileFormat;
    }

    @Override
    public boolean supportDataType(DataType dataType) {
        boolean bl;
        DataType dataType2 = dataType;
        if (dataType2 instanceof AnsiIntervalType) {
            bl = false;
        } else if (dataType2 instanceof AtomicType) {
            bl = true;
        } else if (dataType2 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            bl = this.supportDataType(userDefinedType.sqlType());
        } else {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$buildReader$1(SparkSession sparkSession$1, StructField x$1) {
        String string = x$1.name();
        String string2 = sparkSession$1.sessionState().conf().columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$buildReader$4(CSVOptions parsedOptions$1, StructField x$3) {
        String string = x$3.name();
        String string2 = parsedOptions$1.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$buildReader$5(CSVOptions parsedOptions$1, StructField x$4) {
        String string = x$4.name();
        String string2 = parsedOptions$1.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }
}

