/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.And$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.AttributeSet$;
import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.CreateNamedStruct;
import org.apache.spark.sql.catalyst.expressions.CreateStruct$;
import org.apache.spark.sql.catalyst.expressions.Equality$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionSet;
import org.apache.spark.sql.catalyst.expressions.ExpressionSet$;
import org.apache.spark.sql.catalyst.expressions.FileSourceMetadataAttribute$;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.InSet;
import org.apache.spark.sql.catalyst.expressions.IsNaN;
import org.apache.spark.sql.catalyst.expressions.IsNull;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.Or;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.SubqueryExpression$;
import org.apache.spark.sql.catalyst.planning.ScanOperation$;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.execution.FileSourceScanExec;
import org.apache.spark.sql.execution.FileSourceScanExec$;
import org.apache.spark.sql.execution.FilterExec;
import org.apache.spark.sql.execution.ProjectExec;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.SparkStrategy;
import org.apache.spark.sql.execution.datasources.BucketingUtils$;
import org.apache.spark.sql.execution.datasources.DataSourceStrategy$;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.FileFormat$;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.collection.BitSet;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class FileSourceStrategy$
extends SparkStrategy
implements PredicateHelper {
    public static final FileSourceStrategy$ MODULE$ = new FileSourceStrategy$();

    static {
        AliasHelper.$init$((AliasHelper)MODULE$);
        PredicateHelper.$init$((PredicateHelper)MODULE$);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$((PredicateHelper)this, expressions, op);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$((PredicateHelper)this, (Expression)expr);
    }

    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$((PredicateHelper)this, output, nonNullAttrExprIds);
    }

    public boolean isLikelySelective(Expression e) {
        return PredicateHelper.isLikelySelective$((PredicateHelper)this, (Expression)e);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap2) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap2);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap2) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap2);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    private boolean shouldPruneBuckets(Option<BucketSpec> bucketSpec) {
        boolean bl;
        Option<BucketSpec> option = bucketSpec;
        if (option instanceof Some) {
            Some some = (Some)option;
            BucketSpec spec = (BucketSpec)some.value();
            bl = spec.bucketColumnNames().length() == 1 && spec.numBuckets() > 1;
        } else if (None$.MODULE$.equals(option)) {
            bl = false;
        } else {
            throw new MatchError(option);
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BitSet getExpressionBuckets(Expression expr, String bucketColumnName, int numBuckets) {
        Expression a;
        IsNull isNull;
        Expression a2;
        BinaryComparison binaryComparison;
        Option option;
        boolean bl = false;
        IsNaN isNaN = null;
        Expression expression = expr;
        if (expression instanceof BinaryComparison && !(option = Equality$.MODULE$.unapply(binaryComparison = (BinaryComparison)expression)).isEmpty()) {
            Expression a3 = (Expression)((Tuple2)option.get())._1();
            Expression expression2 = (Expression)((Tuple2)option.get())._2();
            if (a3 instanceof Attribute) {
                Attribute attribute = (Attribute)a3;
                if (expression2 instanceof Literal) {
                    Literal literal = (Literal)expression2;
                    Object v = literal.value();
                    String string = attribute.name();
                    String string2 = bucketColumnName;
                    if (string == null) {
                        if (string2 == null) return FileSourceStrategy$.getBucketSetFromValue$1(attribute, v, numBuckets);
                    } else if (string.equals(string2)) {
                        return FileSourceStrategy$.getBucketSetFromValue$1(attribute, v, numBuckets);
                    }
                }
            }
        }
        if (expression instanceof In) {
            In in = (In)expression;
            Expression a4 = in.value();
            Seq list = in.list();
            if (a4 instanceof Attribute) {
                Attribute attribute = (Attribute)a4;
                if (list.forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FileSourceStrategy$.$anonfun$getExpressionBuckets$3(x$1)))) {
                    String string = attribute.name();
                    String string3 = bucketColumnName;
                    if (string == null) {
                        if (string3 == null) return FileSourceStrategy$.getBucketSetFromIterable$1(attribute, (Iterable)list.map((Function1 & Serializable)e -> e.eval(org.apache.spark.sql.catalyst.expressions.package$.MODULE$.EmptyRow())), numBuckets);
                    } else if (string.equals(string3)) {
                        return FileSourceStrategy$.getBucketSetFromIterable$1(attribute, (Iterable)list.map((Function1 & Serializable)e -> e.eval(org.apache.spark.sql.catalyst.expressions.package$.MODULE$.EmptyRow())), numBuckets);
                    }
                }
            }
        }
        if (expression instanceof InSet) {
            InSet inSet = (InSet)expression;
            Expression a5 = inSet.child();
            Set hset = inSet.hset();
            if (a5 instanceof Attribute) {
                Attribute attribute = (Attribute)a5;
                String string = attribute.name();
                String string4 = bucketColumnName;
                if (string == null) {
                    if (string4 == null) return FileSourceStrategy$.getBucketSetFromIterable$1(attribute, (Iterable)hset, numBuckets);
                } else if (string.equals(string4)) {
                    return FileSourceStrategy$.getBucketSetFromIterable$1(attribute, (Iterable)hset, numBuckets);
                }
            }
        }
        if (expression instanceof IsNull && (a2 = (isNull = (IsNull)expression).child()) instanceof Attribute) {
            Attribute attribute = (Attribute)a2;
            String string = attribute.name();
            String string5 = bucketColumnName;
            if (string == null) {
                if (string5 == null) return FileSourceStrategy$.getBucketSetFromValue$1(attribute, null, numBuckets);
            } else if (string.equals(string5)) {
                return FileSourceStrategy$.getBucketSetFromValue$1(attribute, null, numBuckets);
            }
        }
        if (expression instanceof IsNaN) {
            bl = true;
            isNaN = (IsNaN)expression;
            Expression a6 = isNaN.child();
            if (a6 instanceof Attribute) {
                Attribute attribute = (Attribute)a6;
                String string = attribute.name();
                String string6 = bucketColumnName;
                if (!(string != null ? !string.equals(string6) : string6 != null)) {
                    DataType dataType = attribute.dataType();
                    FloatType$ floatType$ = FloatType$.MODULE$;
                    if (dataType == null) {
                        if (floatType$ == null) return FileSourceStrategy$.getBucketSetFromValue$1(attribute, BoxesRunTime.boxToFloat((float)Float.NaN), numBuckets);
                    } else if (dataType.equals(floatType$)) {
                        return FileSourceStrategy$.getBucketSetFromValue$1(attribute, BoxesRunTime.boxToFloat((float)Float.NaN), numBuckets);
                    }
                }
            }
        }
        if (bl && (a = isNaN.child()) instanceof Attribute) {
            Attribute attribute = (Attribute)a;
            String string = attribute.name();
            String string7 = bucketColumnName;
            if (!(string != null ? !string.equals(string7) : string7 != null)) {
                DataType dataType = attribute.dataType();
                DoubleType$ doubleType$ = DoubleType$.MODULE$;
                if (dataType == null) {
                    if (doubleType$ == null) return FileSourceStrategy$.getBucketSetFromValue$1(attribute, BoxesRunTime.boxToDouble((double)Double.NaN), numBuckets);
                } else if (dataType.equals(doubleType$)) {
                    return FileSourceStrategy$.getBucketSetFromValue$1(attribute, BoxesRunTime.boxToDouble((double)Double.NaN), numBuckets);
                }
            }
        }
        if (expression instanceof And) {
            And and = (And)expression;
            Expression left = and.left();
            Expression right = and.right();
            return this.getExpressionBuckets(left, bucketColumnName, numBuckets).$amp(this.getExpressionBuckets(right, bucketColumnName, numBuckets));
        }
        if (expression instanceof Or) {
            Or or = (Or)expression;
            Expression left = or.left();
            Expression right = or.right();
            return this.getExpressionBuckets(left, bucketColumnName, numBuckets).$bar(this.getExpressionBuckets(right, bucketColumnName, numBuckets));
        }
        BitSet matchedBuckets = new BitSet(numBuckets);
        matchedBuckets.setUntil(numBuckets);
        return matchedBuckets;
    }

    private Option<BitSet> genBucketSet(Seq<Expression> normalizedFilters, BucketSpec bucketSpec) {
        if (normalizedFilters.isEmpty()) {
            return None$.MODULE$;
        }
        String bucketColumnName = (String)bucketSpec.bucketColumnNames().head();
        int numBuckets = bucketSpec.numBuckets();
        Expression normalizedFiltersAndExpr = (Expression)normalizedFilters.reduce((Function2)And$.MODULE$);
        BitSet matchedBuckets = this.getExpressionBuckets(normalizedFiltersAndExpr, bucketColumnName, numBuckets);
        int numBucketsSelected = matchedBuckets.cardinality();
        this.logInfo((Function0 & Serializable)() -> new StringBuilder(24).append("Pruned ").append(numBuckets - numBucketsSelected).append(" out of ").append(numBuckets).append(" buckets.").toString());
        return numBucketsSelected == numBuckets ? None$.MODULE$ : new Some((Object)matchedBuckets);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Seq<SparkPlan> apply(LogicalPlan plan) {
        SparkPlan withProjections;
        LogicalPlan logicalPlan2 = plan;
        if (logicalPlan2 == null) return package$.MODULE$.Nil();
        Option option = ScanOperation$.MODULE$.unapply(logicalPlan2);
        if (option.isEmpty()) return package$.MODULE$.Nil();
        Seq projects = (Seq)((Tuple3)option.get())._1();
        Seq filters = (Seq)((Tuple3)option.get())._2();
        LogicalPlan l = (LogicalPlan)((Tuple3)option.get())._3();
        if (!(l instanceof LogicalRelation)) return package$.MODULE$.Nil();
        LogicalRelation logicalRelation = (LogicalRelation)l;
        BaseRelation fsRelation = logicalRelation.relation();
        Option<CatalogTable> table = logicalRelation.catalogTable();
        if (!(fsRelation instanceof HadoopFsRelation)) return package$.MODULE$.Nil();
        HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)fsRelation;
        ExpressionSet filterSet = ExpressionSet$.MODULE$.apply((IterableOnce)filters);
        Seq<Expression> normalizedFilters = DataSourceStrategy$.MODULE$.normalizeExprs((Seq<Expression>)((Seq)filters.filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.deterministic()))), logicalRelation.output());
        Seq partitionColumns = logicalRelation.resolve(hadoopFsRelation.partitionSchema(), hadoopFsRelation.sparkSession().sessionState().analyzer().resolver());
        AttributeSet partitionSet = AttributeSet$.MODULE$.apply((Iterable)partitionColumns);
        ExpressionSet partitionKeyFilters = DataSourceStrategy$.MODULE$.getPushedDownFilters((Seq<Expression>)partitionColumns, normalizedFilters);
        Seq normalizedFiltersWithoutSubqueries = (Seq)normalizedFilters.filterNot((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)SubqueryExpression$.MODULE$.hasSubquery(e)));
        Option<BucketSpec> bucketSpec = hadoopFsRelation.bucketSpec();
        Option<BitSet> bucketSet = this.shouldPruneBuckets(bucketSpec) ? this.genBucketSet((Seq<Expression>)normalizedFiltersWithoutSubqueries, (BucketSpec)bucketSpec.get()) : None$.MODULE$;
        Seq dataColumns = logicalRelation.resolve(hadoopFsRelation.dataSchema(), hadoopFsRelation.sparkSession().sessionState().analyzer().resolver());
        Seq dataColumnsWithoutPartitionCols = (Seq)dataColumns.filterNot((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)partitionColumns.contains(elem)));
        Seq dataFilters = (Seq)normalizedFiltersWithoutSubqueries.flatMap((Function1 & Serializable)f -> f.references().intersect(partitionSet).nonEmpty() ? MODULE$.extractPredicatesWithinOutputSet((Expression)f, AttributeSet$.MODULE$.apply((Iterable)dataColumnsWithoutPartitionCols)) : new Option<Expression>(f));
        boolean supportNestedPredicatePushdown = DataSourceUtils$.MODULE$.supportNestedPredicatePushdown(hadoopFsRelation);
        Seq pushedFilters = (Seq)dataFilters.flatMap((Function1 & Serializable)x$3 -> DataSourceStrategy$.MODULE$.translateFilter((Expression)x$3, supportNestedPredicatePushdown));
        this.logInfo((Function0 & Serializable)() -> new StringBuilder(16).append("Pushed Filters: ").append(pushedFilters.mkString(",")).toString());
        ExpressionSet afterScanFilters = filterSet.$minus$minus((IterableOnce)partitionKeyFilters.filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)FileSourceStrategy$.$anonfun$apply$7(x$4))));
        this.logInfo((Function0 & Serializable)() -> new StringBuilder(19).append("Post-Scan Filters: ").append(afterScanFilters.mkString(",")).toString());
        AttributeSet filterAttributes = AttributeSet$.MODULE$.apply((Iterable)afterScanFilters);
        Seq requiredExpressions = (Seq)filterAttributes.toSeq().$plus$plus((IterableOnce)projects);
        AttributeSet requiredAttributes = AttributeSet$.MODULE$.apply((Iterable)requiredExpressions);
        Seq readDataColumns = (Seq)((IterableOps)dataColumns.filter((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)requiredAttributes.contains(elem)))).filterNot((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)partitionColumns.contains(elem)));
        StructType outputSchema = org.apache.spark.sql.catalyst.expressions.package$.MODULE$.AttributeSeq(readDataColumns).toStructType();
        this.logInfo((Function0 & Serializable)() -> new StringBuilder(20).append("Output Data Schema: ").append(outputSchema.simpleString(5)).toString());
        Option metadataStructOpt = logicalRelation.output().collectFirst((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends AttributeReference, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                Option option;
                A1 A1 = x1;
                if (A1 != null && !(option = FileSourceMetadataAttribute$.MODULE$.unapply(A1)).isEmpty()) {
                    AttributeReference attr = (AttributeReference)option.get();
                    object = attr;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(AttributeReference x1) {
                Option option;
                AttributeReference attributeReference = x1;
                boolean bl = attributeReference != null && !(option = FileSourceMetadataAttribute$.MODULE$.unapply(attributeReference)).isEmpty();
                return bl;
            }
        });
        Seq metadataColumns2 = (Seq)metadataStructOpt.map((Function1 & Serializable)metadataStruct -> ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])((StructType)metadataStruct.dataType()).fields()), (Function1 & Serializable)field -> FileSourceMetadataAttribute$.MODULE$.apply(field.name(), field.dataType(), FileSourceMetadataAttribute$.MODULE$.apply$default$3()), ClassTag$.MODULE$.apply(AttributeReference.class))))).getOrElse((Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().empty());
        Seq outputAttributes = (Seq)((IterableOps)readDataColumns.$plus$plus((IterableOnce)partitionColumns)).$plus$plus((IterableOnce)metadataColumns2);
        FileSourceScanExec scan = new FileSourceScanExec(hadoopFsRelation, (Seq<Attribute>)outputAttributes, outputSchema, (Seq<Expression>)partitionKeyFilters.toSeq(), bucketSet, (Option<Object>)None$.MODULE$, (Seq<Expression>)dataFilters, (Option<TableIdentifier>)table.map((Function1 & Serializable)x$5 -> x$5.identifier()), FileSourceScanExec$.MODULE$.apply$default$9());
        SparkPlan withMetadataProjections = (SparkPlan)metadataStructOpt.map((Function1 & Serializable)metadataStruct -> {
            CreateNamedStruct x$1 = CreateStruct$.MODULE$.apply(metadataColumns2);
            String x$2 = FileFormat$.MODULE$.METADATA_NAME();
            ExprId x$3 = metadataStruct.exprId();
            Seq x$4 = Alias$.MODULE$.apply$default$4((Expression)x$1, x$2);
            Option x$5 = Alias$.MODULE$.apply$default$5((Expression)x$1, x$2);
            Seq x$6 = Alias$.MODULE$.apply$default$6((Expression)x$1, x$2);
            Alias metadataAlias = new Alias((Expression)x$1, x$2, x$3, x$4, x$5, x$6);
            return new ProjectExec((Seq<NamedExpression>)((Seq)((SeqOps)scan.output().dropRight(metadataColumns2.length())).$colon$plus((Object)metadataAlias)), scan);
        }).getOrElse((Function0 & Serializable)() -> scan);
        Option afterScanFilter = afterScanFilters.toSeq().reduceOption((Function2)And$.MODULE$);
        SparkPlan withFilter = (SparkPlan)afterScanFilter.map((Function1 & Serializable)x$6 -> new FilterExec((Expression)x$6, withMetadataProjections)).getOrElse((Function0 & Serializable)() -> withMetadataProjections);
        Seq seq = projects;
        Seq seq2 = withFilter.output();
        SparkPlan sparkPlan = withProjections = !(seq != null ? !seq.equals(seq2) : seq2 != null) ? withFilter : new ProjectExec((Seq<NamedExpression>)projects, withFilter);
        return package$.MODULE$.Nil().$colon$colon((Object)sparkPlan);
    }

    private static final int getBucketNumber$1(Attribute attr, Object v, int numBuckets$1) {
        return BucketingUtils$.MODULE$.getBucketIdFromValue(attr, numBuckets$1, v);
    }

    /*
     * WARNING - void declaration
     */
    private static final BitSet getBucketSetFromIterable$1(Attribute attr, Iterable iter, int numBuckets$1) {
        void var3_3;
        BitSet matchedBuckets = new BitSet(numBuckets$1);
        ((IterableOnceOps)iter.map((Function1 & Serializable)v -> BoxesRunTime.boxToInteger((int)FileSourceStrategy$.getBucketNumber$1(attr, v, numBuckets$1)))).foreach((Function1)(JFunction1.mcVI.sp & Serializable)bucketNum -> matchedBuckets.set(bucketNum));
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private static final BitSet getBucketSetFromValue$1(Attribute attr, Object v, int numBuckets$1) {
        void var3_3;
        BitSet matchedBuckets = new BitSet(numBuckets$1);
        matchedBuckets.set(FileSourceStrategy$.getBucketNumber$1(attr, v, numBuckets$1));
        return var3_3;
    }

    public static final /* synthetic */ boolean $anonfun$getExpressionBuckets$3(Expression x$1) {
        return x$1 instanceof Literal;
    }

    public static final /* synthetic */ boolean $anonfun$apply$7(Expression x$4) {
        return x$4.references().nonEmpty();
    }

    private FileSourceStrategy$() {
    }
}

