/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.SparkUpgradeException;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.InputFileBlockHolder$;
import org.apache.spark.sql.connector.metric.CustomTaskMetric;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.SchemaColumnConvertNotSupportedException;
import org.apache.spark.sql.execution.datasources.v2.PartitionedFileReader;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Option;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005e4AAD\b\u0001=!AA\t\u0001B\u0001B\u0003%Q\tC\u0003V\u0001\u0011\u0005a\u000bC\u0004Z\u0001\u0001\u0007I\u0011\u0002.\t\u000fm\u0003\u0001\u0019!C\u00059\"1!\r\u0001Q!\nECqa\u0019\u0001C\u0002\u0013%A\r\u0003\u0004k\u0001\u0001\u0006I!\u001a\u0005\u0006W\u0002!I\u0001\u001c\u0005\u0006a\u0002!I\u0001\u001c\u0005\u0006c\u0002!\tE\u001d\u0005\u0006g\u0002!\t\u0005\u001e\u0005\u0006k\u0002!\tE\u001e\u0005\u0006o\u0002!I\u0001\u001f\u0002\u0014\r&dW\rU1si&$\u0018n\u001c8SK\u0006$WM\u001d\u0006\u0003!E\t!A\u001e\u001a\u000b\u0005I\u0019\u0012a\u00033bi\u0006\u001cx.\u001e:dKNT!\u0001F\u000b\u0002\u0013\u0015DXmY;uS>t'B\u0001\f\u0018\u0003\r\u0019\u0018\u000f\u001c\u0006\u00031e\tQa\u001d9be.T!AG\u000e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0012aA8sO\u000e\u0001QCA\u00103'\u0011\u0001\u0001\u0005\u000b \u0011\u0005\u00052S\"\u0001\u0012\u000b\u0005\r\"\u0013\u0001\u00027b]\u001eT\u0011!J\u0001\u0005U\u00064\u0018-\u0003\u0002(E\t1qJ\u00196fGR\u00042!\u000b\u00181\u001b\u0005Q#BA\u0016-\u0003\u0011\u0011X-\u00193\u000b\u00055*\u0012!C2p]:,7\r^8s\u0013\ty#FA\bQCJ$\u0018\u000e^5p]J+\u0017\rZ3s!\t\t$\u0007\u0004\u0001\u0005\u000bM\u0002!\u0019\u0001\u001b\u0003\u0003Q\u000b\"!N\u001e\u0011\u0005YJT\"A\u001c\u000b\u0003a\nQa]2bY\u0006L!AO\u001c\u0003\u000f9{G\u000f[5oOB\u0011a\u0007P\u0005\u0003{]\u00121!\u00118z!\ty$)D\u0001A\u0015\t\tu#\u0001\u0005j]R,'O\\1m\u0013\t\u0019\u0005IA\u0004M_\u001e<\u0017N\\4\u0002\u000fI,\u0017\rZ3sgB\u0019aIT)\u000f\u0005\u001dceB\u0001%L\u001b\u0005I%B\u0001&\u001e\u0003\u0019a$o\\8u}%\t\u0001(\u0003\u0002No\u00059\u0001/Y2lC\u001e,\u0017BA(Q\u0005!IE/\u001a:bi>\u0014(BA'8!\r\u00116\u000bM\u0007\u0002\u001f%\u0011Ak\u0004\u0002\u0016!\u0006\u0014H/\u001b;j_:,GMR5mKJ+\u0017\rZ3s\u0003\u0019a\u0014N\\5u}Q\u0011q\u000b\u0017\t\u0004%\u0002\u0001\u0004\"\u0002#\u0003\u0001\u0004)\u0015!D2veJ,g\u000e\u001e*fC\u0012,'/F\u0001R\u0003E\u0019WO\u001d:f]R\u0014V-\u00193fe~#S-\u001d\u000b\u0003;\u0002\u0004\"A\u000e0\n\u0005};$\u0001B+oSRDq!\u0019\u0003\u0002\u0002\u0003\u0007\u0011+A\u0002yIE\nabY;se\u0016tGOU3bI\u0016\u0014\b%A\u0004tc2\u001cuN\u001c4\u0016\u0003\u0015\u0004\"A\u001a5\u000e\u0003\u001dT!!Q\u000b\n\u0005%<'aB*R\u0019\u000e{gNZ\u0001\tgFd7i\u001c8gA\u0005\u0011\u0012n\u001a8pe\u0016l\u0015n]:j]\u001e4\u0015\u000e\\3t+\u0005i\u0007C\u0001\u001co\u0013\tywGA\u0004C_>dW-\u00198\u0002%%<gn\u001c:f\u0007>\u0014(/\u001e9u\r&dWm]\u0001\u0005]\u0016DH\u000fF\u0001n\u0003\r9W\r\u001e\u000b\u0002a\u0005)1\r\\8tKR\tQ,A\u0007hKRtU\r\u001f;SK\u0006$WM\u001d\u000b\u0002#\u0002")
public class FilePartitionReader<T>
implements PartitionReader<T>,
Logging {
    private final Iterator<PartitionedFileReader<T>> readers;
    private PartitionedFileReader<T> currentReader;
    private final SQLConf sqlConf;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public CustomTaskMetric[] currentMetricsValues() {
        return super.currentMetricsValues();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private PartitionedFileReader<T> currentReader() {
        return this.currentReader;
    }

    private void currentReader_$eq(PartitionedFileReader<T> x$1) {
        this.currentReader = x$1;
    }

    private SQLConf sqlConf() {
        return this.sqlConf;
    }

    private boolean ignoreMissingFiles() {
        return this.sqlConf().ignoreMissingFiles();
    }

    private boolean ignoreCorruptFiles() {
        return this.sqlConf().ignoreCorruptFiles();
    }

    public boolean next() {
        boolean bl;
        boolean hasNext;
        boolean bl2;
        if (this.currentReader() == null) {
            if (this.readers.hasNext()) {
                try {
                    this.currentReader_$eq(this.getNextReader());
                }
                catch (Throwable throwable) {
                    boolean bl3 = false;
                    FileNotFoundException fileNotFoundException = null;
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof FileNotFoundException) {
                        bl3 = true;
                        fileNotFoundException = (FileNotFoundException)throwable2;
                        if (this.ignoreMissingFiles()) {
                            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Skipped missing file.", fileNotFoundException);
                            this.currentReader_$eq(null);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                    }
                    if (bl3 && !this.ignoreMissingFiles()) {
                        throw QueryExecutionErrors$.MODULE$.fileNotFoundError(fileNotFoundException);
                    }
                    boolean bl4 = throwable2 instanceof RuntimeException ? true : throwable2 instanceof IOException;
                    if (bl4 && this.ignoreCorruptFiles()) {
                        this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Skipped the rest of the content in the corrupted file.", throwable2);
                        this.currentReader_$eq(null);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    throw throwable;
                }
            } else {
                return false;
            }
        }
        try {
            bl2 = this.currentReader() != null && this.currentReader().next();
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (throwable3 instanceof SchemaColumnConvertNotSupportedException) {
                SchemaColumnConvertNotSupportedException schemaColumnConvertNotSupportedException = (SchemaColumnConvertNotSupportedException)throwable3;
                throw QueryExecutionErrors$.MODULE$.unsupportedSchemaColumnConvertError(this.currentReader().file().filePath(), schemaColumnConvertNotSupportedException.getColumn(), schemaColumnConvertNotSupportedException.getLogicalType(), schemaColumnConvertNotSupportedException.getPhysicalType(), (Exception)schemaColumnConvertNotSupportedException);
            }
            boolean bl5 = throwable3 instanceof RuntimeException ? true : throwable3 instanceof IOException;
            if (!bl5 || !this.ignoreCorruptFiles()) {
                Option option;
                if (throwable3 instanceof SparkUpgradeException) {
                    SparkUpgradeException sparkUpgradeException = (SparkUpgradeException)throwable3;
                    throw sparkUpgradeException;
                }
                if (throwable3 != null && !(option = NonFatal$.MODULE$.unapply(throwable3)).isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    Throwable throwable4 = e.getCause();
                    if (throwable4 instanceof SparkUpgradeException) {
                        SparkUpgradeException sparkUpgradeException = (SparkUpgradeException)throwable4;
                        throw sparkUpgradeException;
                    }
                    throw QueryExecutionErrors$.MODULE$.cannotReadFilesError(e, this.currentReader().file().filePath());
                }
                throw throwable;
            }
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(55).append("Skipped the rest of the content in the corrupted file: ").append(this.currentReader()).toString(), throwable3);
            boolean bl6 = false;
            bl2 = hasNext = bl6;
        }
        if (hasNext) {
            bl = true;
        } else {
            this.close();
            this.currentReader_$eq(null);
            bl = this.next();
        }
        return bl;
    }

    public T get() {
        return this.currentReader().get();
    }

    public void close() {
        if (this.currentReader() != null) {
            this.currentReader().close();
        }
        InputFileBlockHolder$.MODULE$.unset();
    }

    /*
     * WARNING - void declaration
     */
    private PartitionedFileReader<T> getNextReader() {
        void var1_1;
        PartitionedFileReader reader = (PartitionedFileReader)this.readers.next();
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(13).append("Reading file ").append(reader).toString());
        PartitionedFile file = reader.file();
        InputFileBlockHolder$.MODULE$.set(file.filePath(), file.start(), file.length());
        return var1_1;
    }

    public FilePartitionReader(Iterator<PartitionedFileReader<T>> readers) {
        this.readers = readers;
        Logging.$init$((Logging)this);
        this.currentReader = null;
        this.sqlConf = SQLConf$.MODULE$.get();
    }
}

