/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.internal.config.UI$;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.sql.util.ExecutionListenerBus;
import org.apache.spark.util.ThreadUtils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.compatible.Assertion;
import org.scalatest.concurrent.AbstractPatienceConfiguration;
import org.scalatest.concurrent.AbstractPatienceConfiguration$PatienceConfig$;
import org.scalatest.concurrent.Eventually;
import org.scalatest.concurrent.PatienceConfiguration;
import org.scalatest.concurrent.ScaledTimeSpans;
import org.scalatest.enablers.Retrying;
import org.scalatest.enablers.Retrying$;
import org.scalatest.time.Span;
import org.scalatest.time.SpanSugar$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005)2Aa\u0001\u0003\u0001\u001b!)a\u0004\u0001C\u0001?!)!\u0005\u0001C!G\tA2\u000b]1sWN+7o]5p]\n+\u0018\u000e\u001c3feN+\u0018\u000e^3\u000b\u0005\u00151\u0011aA:rY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001q!\u0003\u0007\t\u0003\u001fAi\u0011AB\u0005\u0003#\u0019\u0011Qb\u00159be.4UO\\*vSR,\u0007CA\n\u0017\u001b\u0005!\"BA\u000b\u000b\u0003%\u00198-\u00197bi\u0016\u001cH/\u0003\u0002\u0018)\t\u0011\")\u001a4pe\u0016\fe\u000eZ!gi\u0016\u0014X)Y2i!\tIB$D\u0001\u001b\u0015\tYB#\u0001\u0006d_:\u001cWO\u001d:f]RL!!\b\u000e\u0003\u0015\u00153XM\u001c;vC2d\u00170\u0001\u0004=S:LGO\u0010\u000b\u0002AA\u0011\u0011\u0005A\u0007\u0002\t\u0005I\u0011M\u001a;fe\u0016\u000b7\r\u001b\u000b\u0002IA\u0011Q\u0005K\u0007\u0002M)\tq%A\u0003tG\u0006d\u0017-\u0003\u0002*M\t!QK\\5u\u0001")
public class SparkSessionBuilderSuite
extends SparkFunSuite
implements Eventually {
    private AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    private volatile AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig$module;

    public <T> T eventually(PatienceConfiguration.Timeout timeout, PatienceConfiguration.Interval interval, Function0<T> fun, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, (PatienceConfiguration.Interval)interval, fun, retrying, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Interval interval, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Interval)interval, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public <T> T eventually(Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public AbstractPatienceConfiguration.PatienceConfig patienceConfig() {
        return PatienceConfiguration.patienceConfig$((PatienceConfiguration)this);
    }

    public PatienceConfiguration.Timeout timeout(Span value) {
        return PatienceConfiguration.timeout$((PatienceConfiguration)this, (Span)value);
    }

    public PatienceConfiguration.Interval interval(Span value) {
        return PatienceConfiguration.interval$((PatienceConfiguration)this, (Span)value);
    }

    public final Span scaled(Span span) {
        return ScaledTimeSpans.scaled$((ScaledTimeSpans)this, (Span)span);
    }

    public double spanScaleFactor() {
        return ScaledTimeSpans.spanScaleFactor$((ScaledTimeSpans)this);
    }

    public AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig() {
        return this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    }

    public final void org$scalatest$concurrent$PatienceConfiguration$_setter_$org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig_$eq(AbstractPatienceConfiguration.PatienceConfig x$1) {
        this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig = x$1;
    }

    public AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig() {
        if (this.PatienceConfig$module == null) {
            this.PatienceConfig$lzycompute$1();
        }
        return this.PatienceConfig$module;
    }

    public void afterEach() {
        SparkSession$.MODULE$.getActiveSession().foreach((Function1 & Serializable)x$1 -> {
            x$1.stop();
            return BoxedUnit.UNIT;
        });
        SparkSession$.MODULE$.clearActiveSession();
        SparkSession$.MODULE$.getDefaultSession().foreach((Function1 & Serializable)x$2 -> {
            x$2.stop();
            return BoxedUnit.UNIT;
        });
        SparkSession$.MODULE$.clearDefaultSession();
    }

    private final void PatienceConfig$lzycompute$1() {
        SparkSessionBuilderSuite sparkSessionBuilderSuite = this;
        synchronized (sparkSessionBuilderSuite) {
            if (this.PatienceConfig$module == null) {
                this.PatienceConfig$module = new AbstractPatienceConfiguration$PatienceConfig$((AbstractPatienceConfiguration)this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$new$2(SparkListenerInterface x$3) {
        return x$3 instanceof ExecutionListenerBus;
    }

    private static final int listenersNum$1(SparkSession spark$1) {
        return ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(spark$1.sparkContext().listenerBus().listeners()).asScala()).count((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SparkSessionBuilderSuite.$anonfun$new$2(x$3)));
    }

    public static final /* synthetic */ void $anonfun$new$26(Long v) {
        SparkSession$.MODULE$.builder().master("local").getOrCreate();
    }

    public static final /* synthetic */ void $anonfun$new$28(Long v) {
        SparkSession$.MODULE$.builder().master("local").config(org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_ALLOW_SPARK_CONTEXT().key(), true).getOrCreate().stop();
    }

    public static final /* synthetic */ boolean $anonfun$new$36(String msg$1, LogEvent x$5) {
        return x$5.getMessage().getFormattedMessage().contains(msg$1);
    }

    public static final /* synthetic */ boolean $anonfun$new$39(String msg$2, LogEvent x$6) {
        return x$6.getMessage().getFormattedMessage().contains(msg$2);
    }

    public static final /* synthetic */ boolean $anonfun$new$44(String msg$3, LogEvent x$7) {
        return x$7.getMessage().getFormattedMessage().contains(msg$3);
    }

    public SparkSessionBuilderSuite() {
        ScaledTimeSpans.$init$((ScaledTimeSpans)this);
        AbstractPatienceConfiguration.$init$((AbstractPatienceConfiguration)this);
        PatienceConfiguration.$init$((PatienceConfiguration)this);
        Eventually.$init$((Eventually)this);
        this.test("SPARK-34087: Fix memory leak of ExecutionListenerBus", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkSession spark = SparkSession$.MODULE$.builder().master("local").getOrCreate();
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> {
                spark.cloneSession();
                SparkSession$.MODULE$.clearActiveSession();
            });
            return (Assertion)this.eventually(this.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(10).seconds()), this.interval(SpanSugar$.MODULE$.convertIntToGrainOfTime(1).seconds()), (Function0 & Serializable)() -> {
                System.gc();
                int $org_scalatest_assert_macro_left = SparkSessionBuilderSuite.listenersNum$1(spark);
                int $org_scalatest_assert_macro_right = 11;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
            }, Retrying$.MODULE$.retryingNatureOfT(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
        this.test("create with config options and propagate them to SparkContext and SparkSession", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkSession session = SparkSession$.MODULE$.builder().master("local").config(UI$.MODULE$.UI_ENABLED().key(), false).config("some-config", "v2").getOrCreate();
            String $org_scalatest_assert_macro_left = session.sparkContext().conf().get("some-config");
            String $org_scalatest_assert_macro_right = "v2";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
            String $org_scalatest_assert_macro_left2 = session.conf().get("some-config");
            String $org_scalatest_assert_macro_right2 = "v2";
            String string3 = $org_scalatest_assert_macro_left2;
            String string4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        this.test("use global default session", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkSession session = SparkSession$.MODULE$.builder().master("local").getOrCreate();
            SparkSession $org_scalatest_assert_macro_left = SparkSession$.MODULE$.builder().getOrCreate();
            SparkSession $org_scalatest_assert_macro_right = session;
            SparkSession sparkSession = $org_scalatest_assert_macro_left;
            SparkSession sparkSession2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(sparkSession != null ? !sparkSession.equals(sparkSession2) : sparkSession2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
        this.test("sets default and active session", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Option $org_scalatest_assert_macro_left = SparkSession$.MODULE$.getDefaultSession();
            None$ $org_scalatest_assert_macro_right = None$.MODULE$;
            Option option = $org_scalatest_assert_macro_left;
            None$ none$ = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(none$) : none$ != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
            Option $org_scalatest_assert_macro_left2 = SparkSession$.MODULE$.getActiveSession();
            None$ $org_scalatest_assert_macro_right2 = None$.MODULE$;
            Option option2 = $org_scalatest_assert_macro_left2;
            None$ none$2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(option2 != null ? !option2.equals(none$2) : none$2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
            SparkSession session = SparkSession$.MODULE$.builder().master("local").getOrCreate();
            Option $org_scalatest_assert_macro_left3 = SparkSession$.MODULE$.getDefaultSession();
            Some $org_scalatest_assert_macro_right3 = new Some((Object)session);
            Option option3 = $org_scalatest_assert_macro_left3;
            Some some = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(option3 != null ? !option3.equals(some) : some != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
            Option $org_scalatest_assert_macro_left4 = SparkSession$.MODULE$.getActiveSession();
            Some $org_scalatest_assert_macro_right4 = new Some((Object)session);
            Option option4 = $org_scalatest_assert_macro_left4;
            Some some2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(option4 != null ? !option4.equals(some2) : some2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        this.test("get active or default session", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SparkSession session = SparkSession$.MODULE$.builder().master("local").getOrCreate();
            SparkSession $org_scalatest_assert_macro_left = SparkSession$.MODULE$.active();
            SparkSession $org_scalatest_assert_macro_right = session;
            SparkSession sparkSession = $org_scalatest_assert_macro_left;
            SparkSession sparkSession2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(sparkSession != null ? !sparkSession.equals(sparkSession2) : sparkSession2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
            SparkSession$.MODULE$.clearActiveSession();
            SparkSession $org_scalatest_assert_macro_left2 = SparkSession$.MODULE$.active();
            SparkSession $org_scalatest_assert_macro_right2 = session;
            SparkSession sparkSession3 = $org_scalatest_assert_macro_left2;
            SparkSession sparkSession4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(sparkSession3 != null ? !sparkSession3.equals(sparkSession4) : sparkSession4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
            SparkSession$.MODULE$.clearDefaultSession();
            this.intercept((Function0 & Serializable)() -> SparkSession$.MODULE$.active(), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
            session.stop();
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
        this.test("config options are propagated to existing SparkSession", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkSession session1 = SparkSession$.MODULE$.builder().master("local").config("spark-config1", "a").getOrCreate();
            String $org_scalatest_assert_macro_left = session1.conf().get("spark-config1");
            String $org_scalatest_assert_macro_right = "a";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
            SparkSession session2 = SparkSession$.MODULE$.builder().config("spark-config1", "b").getOrCreate();
            SparkSession $org_scalatest_assert_macro_left2 = session1;
            SparkSession $org_scalatest_assert_macro_right2 = session2;
            SparkSession sparkSession = $org_scalatest_assert_macro_left2;
            SparkSession sparkSession2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(sparkSession != null ? !sparkSession.equals(sparkSession2) : sparkSession2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
            String $org_scalatest_assert_macro_left3 = session1.conf().get("spark-config1");
            String $org_scalatest_assert_macro_right3 = "b";
            String string3 = $org_scalatest_assert_macro_left3;
            String string4 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
        this.test("use session from active thread session and propagate config options", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkSession defaultSession = SparkSession$.MODULE$.builder().master("local").getOrCreate();
            SparkSession activeSession = defaultSession.newSession();
            SparkSession$.MODULE$.setActiveSession(activeSession);
            SparkSession session = SparkSession$.MODULE$.builder().config("spark-config2", "a").getOrCreate();
            SparkSession $org_scalatest_assert_macro_left = activeSession;
            SparkSession $org_scalatest_assert_macro_right = defaultSession;
            SparkSession sparkSession = $org_scalatest_assert_macro_left;
            SparkSession sparkSession2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", (Object)$org_scalatest_assert_macro_right, sparkSession == null ? sparkSession2 != null : !sparkSession.equals(sparkSession2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
            SparkSession $org_scalatest_assert_macro_left2 = session;
            SparkSession $org_scalatest_assert_macro_right2 = activeSession;
            SparkSession sparkSession3 = $org_scalatest_assert_macro_left2;
            SparkSession sparkSession4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(sparkSession3 != null ? !sparkSession3.equals(sparkSession4) : sparkSession4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
            String $org_scalatest_assert_macro_left3 = session.conf().get("spark-config2");
            String $org_scalatest_assert_macro_right3 = "a";
            String string = $org_scalatest_assert_macro_left3;
            String string2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
            SQLConf $org_scalatest_assert_macro_left4 = session.sessionState().conf();
            SQLConf $org_scalatest_assert_macro_right4 = SQLConf$.MODULE$.get();
            SQLConf sQLConf = $org_scalatest_assert_macro_left4;
            SQLConf sQLConf2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(sQLConf != null ? !sQLConf.equals(sQLConf2) : sQLConf2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
            String $org_scalatest_assert_macro_left5 = SQLConf$.MODULE$.get().getConfString("spark-config2");
            String $org_scalatest_assert_macro_right5 = "a";
            String string3 = $org_scalatest_assert_macro_left5;
            String string4 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
            SparkSession$.MODULE$.clearActiveSession();
            SparkSession $org_scalatest_assert_macro_left6 = SparkSession$.MODULE$.builder().getOrCreate();
            SparkSession $org_scalatest_assert_macro_right6 = defaultSession;
            SparkSession sparkSession5 = $org_scalatest_assert_macro_left6;
            SparkSession sparkSession6 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(sparkSession5 != null ? !sparkSession5.equals(sparkSession6) : sparkSession6 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
        this.test("create a new session if the default session has been stopped", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkSession newSession;
            SparkSession defaultSession = SparkSession$.MODULE$.builder().master("local").getOrCreate();
            SparkSession$.MODULE$.setDefaultSession(defaultSession);
            defaultSession.stop();
            SparkSession $org_scalatest_assert_macro_left = newSession = SparkSession$.MODULE$.builder().master("local").getOrCreate();
            SparkSession $org_scalatest_assert_macro_right = defaultSession;
            SparkSession sparkSession = $org_scalatest_assert_macro_left;
            SparkSession sparkSession2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", (Object)$org_scalatest_assert_macro_right, sparkSession == null ? sparkSession2 != null : !sparkSession.equals(sparkSession2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
        this.test("create a new session if the active thread session has been stopped", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkSession newSession;
            SparkSession activeSession = SparkSession$.MODULE$.builder().master("local").getOrCreate();
            SparkSession$.MODULE$.setActiveSession(activeSession);
            activeSession.stop();
            SparkSession $org_scalatest_assert_macro_left = newSession = SparkSession$.MODULE$.builder().master("local").getOrCreate();
            SparkSession $org_scalatest_assert_macro_right = activeSession;
            SparkSession sparkSession = $org_scalatest_assert_macro_left;
            SparkSession sparkSession2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", (Object)$org_scalatest_assert_macro_right, sparkSession == null ? sparkSession2 != null : !sparkSession.equals(sparkSession2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
        this.test("create SparkContext first then SparkSession", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkConf conf = new SparkConf().setAppName("test").setMaster("local").set("key1", "value1");
            SparkContext sparkContext2 = new SparkContext(conf);
            SparkSession session = SparkSession$.MODULE$.builder().config("key2", "value2").getOrCreate();
            String $org_scalatest_assert_macro_left = session.conf().get("key1");
            String $org_scalatest_assert_macro_right = "value1";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
            String $org_scalatest_assert_macro_left2 = session.conf().get("key2");
            String $org_scalatest_assert_macro_right2 = "value2";
            String string3 = $org_scalatest_assert_macro_left2;
            String string4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
            SparkContext $org_scalatest_assert_macro_left3 = session.sparkContext();
            SparkContext $org_scalatest_assert_macro_right3 = sparkContext2;
            SparkContext sparkContext = $org_scalatest_assert_macro_left3;
            SparkContext sparkContext3 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(sparkContext != null ? !sparkContext.equals(sparkContext3) : sparkContext3 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
            SparkConf $org_scalatest_assert_macro_left4 = sparkContext2.conf();
            String $org_scalatest_assert_macro_right4 = "key2";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.contains($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
            String $org_scalatest_assert_macro_left5 = sparkContext2.conf().get("key1");
            String $org_scalatest_assert_macro_right5 = "value1";
            String string5 = $org_scalatest_assert_macro_left5;
            String string6 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
        this.test("create SparkContext first then pass context to SparkSession", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkConf conf = new SparkConf().setAppName("test").setMaster("local").set("key1", "value1");
            SparkContext newSC = new SparkContext(conf);
            SparkSession session = SparkSession$.MODULE$.builder().sparkContext(newSC).config("key2", "value2").getOrCreate();
            String $org_scalatest_assert_macro_left = session.conf().get("key1");
            String $org_scalatest_assert_macro_right = "value1";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
            String $org_scalatest_assert_macro_left2 = session.conf().get("key2");
            String $org_scalatest_assert_macro_right2 = "value2";
            String string3 = $org_scalatest_assert_macro_left2;
            String string4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
            SparkContext $org_scalatest_assert_macro_left3 = session.sparkContext();
            SparkContext $org_scalatest_assert_macro_right3 = newSC;
            SparkContext sparkContext = $org_scalatest_assert_macro_left3;
            SparkContext sparkContext2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(sparkContext != null ? !sparkContext.equals(sparkContext2) : sparkContext2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
            String $org_scalatest_assert_macro_left4 = session.sparkContext().conf().get("key1");
            String $org_scalatest_assert_macro_right4 = "value1";
            String string5 = $org_scalatest_assert_macro_left4;
            String string6 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
            SparkConf $org_scalatest_assert_macro_left5 = session.sparkContext().conf();
            String $org_scalatest_assert_macro_right5 = "key2";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.contains($org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
            String $org_scalatest_assert_macro_left6 = session.sparkContext().conf().get("spark.app.name");
            String $org_scalatest_assert_macro_right6 = "test";
            String string7 = $org_scalatest_assert_macro_left6;
            String string8 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
        this.test("SPARK-15887: hive-site.xml should be loaded", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkSession session = SparkSession$.MODULE$.builder().master("local").getOrCreate();
            String $org_scalatest_assert_macro_left = session.sessionState().newHadoopConf().get("hive.in.test");
            String $org_scalatest_assert_macro_right = "true";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
            String $org_scalatest_assert_macro_left2 = session.sparkContext().hadoopConfiguration().get("hive.in.test");
            String $org_scalatest_assert_macro_right2 = "true";
            String string3 = $org_scalatest_assert_macro_left2;
            String string4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
        this.test("SPARK-15991: Set global Hadoop conf", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Assertion assertion;
            SparkSession session = SparkSession$.MODULE$.builder().master("local").getOrCreate();
            String mySpecialKey = "my.special.key.15991";
            String mySpecialValue = "msv";
            try {
                session.sparkContext().hadoopConfiguration().set(mySpecialKey, mySpecialValue);
                String $org_scalatest_assert_macro_left = session.sessionState().newHadoopConf().get(mySpecialKey);
                String $org_scalatest_assert_macro_right = mySpecialValue;
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
            }
            finally {
                session.sparkContext().hadoopConfiguration().unset(mySpecialKey);
            }
            return assertion;
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
        this.test("SPARK-31234: RESET command will not change static sql configs and spark context conf values in SessionState", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkSession session = SparkSession$.MODULE$.builder().master("local").config(StaticSQLConf$.MODULE$.GLOBAL_TEMP_DATABASE().key(), "globalTempDB-SPARK-31234").config("spark.app.name", "test-app-SPARK-31234").getOrCreate();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(session.sessionState().conf().getConfString("spark.app.name"));
            String $org_scalatest_assert_macro_right = "test-app-SPARK-31234";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(session.sessionState().conf().getConf(StaticSQLConf$.MODULE$.GLOBAL_TEMP_DATABASE()));
            String $org_scalatest_assert_macro_right2 = "globaltempdb-spark-31234";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
            session.sql("RESET");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(session.sessionState().conf().getConfString("spark.app.name"));
            String $org_scalatest_assert_macro_right3 = "test-app-SPARK-31234";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(session.sessionState().conf().getConf(StaticSQLConf$.MODULE$.GLOBAL_TEMP_DATABASE()));
            String $org_scalatest_assert_macro_right4 = "globaltempdb-spark-31234";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
        this.test("SPARK-31354: SparkContext only register one SparkSession ApplicationEnd listener", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkConf conf = new SparkConf().setMaster("local").setAppName("test-app-SPARK-31354-1");
            SparkContext context = new SparkContext(conf);
            SparkSession$.MODULE$.builder().sparkContext(context).master("local").getOrCreate();
            int postFirstCreation = context.listenerBus().listeners().size();
            SparkSession$.MODULE$.clearActiveSession();
            SparkSession$.MODULE$.clearDefaultSession();
            SparkSession$.MODULE$.builder().sparkContext(context).master("local").getOrCreate();
            int postSecondCreation = context.listenerBus().listeners().size();
            SparkSession$.MODULE$.clearActiveSession();
            SparkSession$.MODULE$.clearDefaultSession();
            int $org_scalatest_assert_macro_left = postFirstCreation;
            int $org_scalatest_assert_macro_right = postSecondCreation;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 231));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
        this.test("SPARK-31532: should not propagate static sql configs to the existing active/default SparkSession", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkSession session = SparkSession$.MODULE$.builder().master("local").config(StaticSQLConf$.MODULE$.GLOBAL_TEMP_DATABASE().key(), "globalTempDB-SPARK-31532").config("spark.app.name", "test-app-SPARK-31532").getOrCreate();
            SparkSession session1 = SparkSession$.MODULE$.builder().config(StaticSQLConf$.MODULE$.GLOBAL_TEMP_DATABASE().key(), "globalTempDB-SPARK-31532-1").getOrCreate();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(session.conf().get(StaticSQLConf$.MODULE$.GLOBAL_TEMP_DATABASE()));
            String $org_scalatest_assert_macro_right = "globaltempdb-spark-31532";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 246));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(session1.conf().get(StaticSQLConf$.MODULE$.GLOBAL_TEMP_DATABASE()));
            String $org_scalatest_assert_macro_right2 = "globaltempdb-spark-31532";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
            SparkSession$.MODULE$.clearActiveSession();
            SparkSession session2 = SparkSession$.MODULE$.builder().config(StaticSQLConf$.MODULE$.WAREHOUSE_PATH().key(), "SPARK-31532-db").config(StaticSQLConf$.MODULE$.GLOBAL_TEMP_DATABASE().key(), "globalTempDB-SPARK-31532-2").getOrCreate();
            String $org_scalatest_assert_macro_left3 = (String)session.conf().get(StaticSQLConf$.MODULE$.WAREHOUSE_PATH());
            String $org_scalatest_assert_macro_right3 = "SPARK-31532-db";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 257));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(session.conf().get(StaticSQLConf$.MODULE$.WAREHOUSE_PATH()));
            String $org_scalatest_assert_macro_right4 = (String)session2.conf().get(StaticSQLConf$.MODULE$.WAREHOUSE_PATH());
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 258));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(session2.conf().get(StaticSQLConf$.MODULE$.GLOBAL_TEMP_DATABASE()));
            String $org_scalatest_assert_macro_right5 = "globaltempdb-spark-31532";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 259));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
        this.test("SPARK-31532: propagate static sql configs if no existing SparkSession", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkConf conf = new SparkConf().setMaster("local").setAppName("test-app-SPARK-31532-2").set(StaticSQLConf$.MODULE$.GLOBAL_TEMP_DATABASE().key(), "globaltempdb-spark-31532").set(StaticSQLConf$.MODULE$.WAREHOUSE_PATH().key(), "SPARK-31532-db");
            SparkContext$.MODULE$.getOrCreate(conf);
            SparkSession session = SparkSession$.MODULE$.builder().config(StaticSQLConf$.MODULE$.GLOBAL_TEMP_DATABASE().key(), "globalTempDB-SPARK-31532-2").config(StaticSQLConf$.MODULE$.WAREHOUSE_PATH().key(), "SPARK-31532-db-2").getOrCreate();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(session.conf().get("spark.app.name"));
            String $org_scalatest_assert_macro_right = "test-app-SPARK-31532-2";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(session.conf().get(StaticSQLConf$.MODULE$.GLOBAL_TEMP_DATABASE()));
            String $org_scalatest_assert_macro_right2 = "globaltempdb-spark-31532-2";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 277));
            String $org_scalatest_assert_macro_left3 = (String)session.conf().get(StaticSQLConf$.MODULE$.WAREHOUSE_PATH());
            String $org_scalatest_assert_macro_right3 = "SPARK-31532-db-2";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 278));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 262));
        this.test("SPARK-32062: reset listenerRegistered in SparkSession", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            SparkConf conf = new SparkConf().setMaster("local").setAppName(new StringBuilder(17).append("test-SPARK-32062-").append(i).toString());
            SparkContext context = new SparkContext(conf);
            int beforeListenerSize = context.listenerBus().listeners().size();
            SparkSession$.MODULE$.builder().sparkContext(context).getOrCreate();
            int afterListenerSize = context.listenerBus().listeners().size();
            int $org_scalatest_assert_macro_left = beforeListenerSize + 1;
            int $org_scalatest_assert_macro_right = afterListenerSize;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 293));
            context.stop();
        }), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
        this.test("SPARK-32160: Disallow to create SparkSession in executors", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String error;
            SparkSession session = SparkSession$.MODULE$.builder().master("local-cluster[3, 1, 1024]").getOrCreate();
            String $org_scalatest_assert_macro_left = error = ((Throwable)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> session.range(1L).foreach((Function1 & Serializable)v -> {
                SparkSessionBuilderSuite.$anonfun$new$26(v);
                return BoxedUnit.UNIT;
            }), ClassTag$.MODULE$.apply(SparkException.class), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 301))).getMessage();
            String $org_scalatest_assert_macro_right = "SparkSession should only be created and accessed on the driver.";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 308));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 298));
        this.test("SPARK-32160: Allow to create SparkSession in executors if the config is set", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SparkSession session = SparkSession$.MODULE$.builder().master("local-cluster[3, 1, 1024]").getOrCreate();
            session.range(1L).foreach((Function1 & Serializable)v -> {
                SparkSessionBuilderSuite.$anonfun$new$28(v);
                return BoxedUnit.UNIT;
            });
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 311));
        this.test("SPARK-32991: Use conf in shared state as the original configuration for RESET", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String wh = "spark.sql.warehouse.dir";
            String td = "spark.sql.globalTempDatabase";
            String custom = "spark.sql.custom";
            SparkConf conf = new SparkConf().setMaster("local").setAppName("SPARK-32991").set(wh, "./data1").set(td, "bob");
            SparkContext sc = new SparkContext(conf);
            SparkSession spark = SparkSession$.MODULE$.builder().config(wh, "./data2").config(td, "alice").config(custom, "kyao").getOrCreate();
            String sharedWH = spark.sharedState().conf().get(wh);
            String sharedTD = spark.sharedState().conf().get(td);
            String $org_scalatest_assert_macro_left = sharedWH;
            String $org_scalatest_assert_macro_right = "data2";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"The warehouse dir in shared state should be determined by the 1st created spark session", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 344));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(sharedTD);
            String $org_scalatest_assert_macro_right2 = "alice";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Static sql configs in shared state should be determined by the 1st created spark session", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 346));
            Option $org_scalatest_assert_macro_left3 = spark.sharedState().conf().getOption(custom);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"Dynamic sql configs is session specific", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 348));
            String $org_scalatest_assert_macro_left4 = spark.conf().get(wh);
            String $org_scalatest_assert_macro_right3 = sharedWH;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left4.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"The warehouse dir in session conf and shared state conf should be consistent", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 351));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(spark.conf().get(td));
            String $org_scalatest_assert_macro_right4 = sharedTD;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"Static sql configs in session conf and shared state conf should be consistent", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 353));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(spark.conf().get(custom));
            String $org_scalatest_assert_macro_right5 = "kyao";
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"Dynamic sql configs is session specific", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 355));
            spark.sql("RESET");
            String $org_scalatest_assert_macro_left7 = spark.conf().get(wh);
            String $org_scalatest_assert_macro_right6 = sharedWH;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "contains", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left7.contains($org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"The warehouse dir in shared state should be respect after RESET", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 359));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(spark.conf().get(td));
            String $org_scalatest_assert_macro_right7 = sharedTD;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"Static sql configs in shared state should be respect after RESET", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 361));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(spark.conf().get(custom));
            String $org_scalatest_assert_macro_right8 = "kyao";
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"Dynamic sql configs in session initial map should be respect after RESET", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 363));
            SparkSession spark2 = SparkSession$.MODULE$.builder().config(wh, "./data3").config(custom, "kyaoo").getOrCreate();
            String $org_scalatest_assert_macro_left10 = spark2.conf().get(wh);
            String $org_scalatest_assert_macro_right9 = sharedWH;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "contains", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left10.contains($org_scalatest_assert_macro_right9), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 369));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(spark2.conf().get(td));
            String $org_scalatest_assert_macro_right10 = sharedTD;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 370));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.convertToEqualizer(spark2.conf().get(custom));
            String $org_scalatest_assert_macro_right11 = "kyaoo";
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)$org_scalatest_assert_macro_right11, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 371));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 321));
        this.test("SPARK-32991: RESET should work properly with multi threads", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String wh = "spark.sql.warehouse.dir";
            String td = "spark.sql.globalTempDatabase";
            String custom = "spark.sql.custom";
            SparkSession spark = (SparkSession)ThreadUtils$.MODULE$.runInNewThread("new session 0", false, (Function0 & Serializable)() -> SparkSession$.MODULE$.builder().master("local").config(wh, "./data0").config(td, "bob").config(custom, "c0").getOrCreate());
            spark.sql(new StringBuilder(7).append("SET ").append(custom).append("=c1").toString());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(spark.conf().get(custom));
            String $org_scalatest_assert_macro_right = "c1";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 388));
            spark.sql("RESET");
            String $org_scalatest_assert_macro_left2 = spark.conf().get(wh);
            String $org_scalatest_assert_macro_right2 = "data0";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"The warehouse dir in shared state should be respect after RESET", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 390));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(spark.conf().get(td));
            String $org_scalatest_assert_macro_right3 = "bob";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"Static sql configs in shared state should be respect after RESET", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 392));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(spark.conf().get(custom));
            String $org_scalatest_assert_macro_right4 = "c0";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"Dynamic sql configs in shared state should be respect after RESET", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 394));
            SparkSession spark1 = (SparkSession)ThreadUtils$.MODULE$.runInNewThread("new session 1", false, (Function0 & Serializable)() -> SparkSession$.MODULE$.builder().getOrCreate());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(spark);
            SparkSession $org_scalatest_assert_macro_right5 = spark1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 401));
            SparkSession$.MODULE$.clearDefaultSession();
            SparkSession spark2 = (SparkSession)ThreadUtils$.MODULE$.runInNewThread("new session 2", false, (Function0 & Serializable)() -> SparkSession$.MODULE$.builder().master("local").config(wh, "./data1").config(td, "alice").config(custom, "c2").getOrCreate());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(spark2);
            SparkSession $org_scalatest_assert_macro_right6 = spark;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "!==", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$bang$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 415));
            spark2.sql(new StringBuilder(7).append("SET ").append(custom).append("=c1").toString());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(spark2.conf().get(custom));
            String $org_scalatest_assert_macro_right7 = "c1";
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 417));
            spark2.sql("RESET");
            String $org_scalatest_assert_macro_left8 = spark2.conf().get(wh);
            String $org_scalatest_assert_macro_right8 = "data1";
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "contains", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.contains($org_scalatest_assert_macro_right8), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 419));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(spark2.conf().get(td));
            String $org_scalatest_assert_macro_right9 = "alice";
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 420));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(spark2.conf().get(custom));
            String $org_scalatest_assert_macro_right10 = "c2";
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 421));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 374));
        this.test("SPARK-33944: warning setting hive.metastore.warehouse.dir using session options", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String msg = "Not allowing to set hive.metastore.warehouse.dir in SparkSession's options";
            SparkFunSuite.LogAppender logAppender = new SparkFunSuite.LogAppender((SparkFunSuite)this, msg, this.LogAppender().$lessinit$greater$default$2());
            this.withLogAppender((AbstractAppender)logAppender, this.withLogAppender$default$2(), this.withLogAppender$default$3(), (Function0)(JFunction0.mcV.sp & Serializable)() -> SparkSession$.MODULE$.builder().master("local").config("hive.metastore.warehouse.dir", "any").getOrCreate().sharedState());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(logAppender.loggingEvents().exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)SparkSessionBuilderSuite.$anonfun$new$36(msg, x$5))), "logAppender.loggingEvents.exists(((x$5: org.apache.logging.log4j.core.LogEvent) => x$5.getMessage().getFormattedMessage().contains(msg)))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 435));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 425));
        this.test("SPARK-33944: no warning setting spark.sql.warehouse.dir using session options", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String msg = "Not allowing to set hive.metastore.warehouse.dir in SparkSession's options";
            SparkFunSuite.LogAppender logAppender = new SparkFunSuite.LogAppender((SparkFunSuite)this, msg, this.LogAppender().$lessinit$greater$default$2());
            this.withLogAppender((AbstractAppender)logAppender, this.withLogAppender$default$2(), this.withLogAppender$default$3(), (Function0)(JFunction0.mcV.sp & Serializable)() -> SparkSession$.MODULE$.builder().master("local").config("spark.sql.warehouse.dir", "any").getOrCreate().sharedState());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(logAppender.loggingEvents().exists((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)SparkSessionBuilderSuite.$anonfun$new$39(msg, x$6))), "logAppender.loggingEvents.exists(((x$6: org.apache.logging.log4j.core.LogEvent) => x$6.getMessage().getFormattedMessage().contains(msg)))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 448));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 438));
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{".", "..", "dir0", "dir0/dir1", "/dir0/dir1", "./dir0"})).foreach((Function1 & Serializable)pathStr -> {
            this.test(new StringBuilder(72).append("SPARK-34558: warehouse path (").append(pathStr).append(") should be qualified for spark/hadoop conf").toString(), (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
                Path path = new Path(pathStr);
                SparkConf conf = new SparkConf().set(StaticSQLConf$.MODULE$.WAREHOUSE_PATH(), (Object)pathStr);
                SparkSession session = SparkSession$.MODULE$.builder().master("local").config(conf).getOrCreate();
                Configuration hadoopConf = session.sessionState().newHadoopConf();
                String expected = path.getFileSystem(hadoopConf).makeQualified(path).toString();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(hadoopConf.get("hive.metastore.warehouse.dir"));
                String $org_scalatest_assert_macro_right = expected;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 462));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(session.conf().get(StaticSQLConf$.MODULE$.WAREHOUSE_PATH()));
                String $org_scalatest_assert_macro_right2 = expected;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 463));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(session.sessionState().conf().warehousePath());
                String $org_scalatest_assert_macro_right3 = expected;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 464));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(session.sharedState().conf().get(StaticSQLConf$.MODULE$.WAREHOUSE_PATH()));
                String $org_scalatest_assert_macro_right4 = expected;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 467));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = $this.convertToEqualizer(session.sharedState().hadoopConf().get("hive.metastore.warehouse.dir"));
                String $org_scalatest_assert_macro_right5 = expected;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 468));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = $this.convertToEqualizer(session.sparkContext().conf().get(StaticSQLConf$.MODULE$.WAREHOUSE_PATH()));
                String $org_scalatest_assert_macro_right6 = expected;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 471));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = $this.convertToEqualizer(session.sparkContext().hadoopConfiguration().get("hive.metastore.warehouse.dir"));
                String $org_scalatest_assert_macro_right7 = expected;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 472));
            }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 452));
            return BoxedUnit.UNIT;
        });
        this.test("SPARK-34558: Create a working SparkSession with a broken FileSystem", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String msg = "Cannot qualify the warehouse path, leaving it unqualified";
            SparkFunSuite.LogAppender logAppender = new SparkFunSuite.LogAppender((SparkFunSuite)this, msg, this.LogAppender().$lessinit$greater$default$2());
            this.withLogAppender((AbstractAppender)logAppender, this.withLogAppender$default$2(), this.withLogAppender$default$3(), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                SparkSession session = SparkSession$.MODULE$.builder().master("local").config(StaticSQLConf$.MODULE$.WAREHOUSE_PATH().key(), "unknown:///mydir").getOrCreate();
                session.sql("SELECT 1").collect();
            });
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(logAppender.loggingEvents().exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)SparkSessionBuilderSuite.$anonfun$new$44(msg, x$7))), "logAppender.loggingEvents.exists(((x$7: org.apache.logging.log4j.core.LogEvent) => x$7.getMessage().getFormattedMessage().contains(msg)))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 488));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 477));
        this.test("SPARK-37727: Show ignored configurations in debug level logs", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SparkSession$.MODULE$.builder().master("local").getOrCreate();
            SparkFunSuite.LogAppender logAppender = new SparkFunSuite.LogAppender((SparkFunSuite)this, this.LogAppender().$lessinit$greater$default$1(), this.LogAppender().$lessinit$greater$default$2());
            logAppender.setThreshold(Level.DEBUG);
            SparkFunSuite.LogAppender x$1 = logAppender;
            Some x$2 = new Some((Object)Level.DEBUG);
            Seq x$3 = this.withLogAppender$default$2();
            JFunction0.mcV.sp & Serializable x$4 = (JFunction0.mcV.sp & Serializable)() -> SparkSession$.MODULE$.builder().config("spark.sql.warehouse.dir", "2").config("spark.abc", "abcb").config("spark.abcd", "abcb4").getOrCreate();
            this.withLogAppender((AbstractAppender)x$1, x$3, (Option)x$2, (Function0)x$4);
            ArrayBuffer logs = (ArrayBuffer)logAppender.loggingEvents().map((Function1 & Serializable)x$8 -> x$8.getMessage().getFormattedMessage());
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Ignored static SQL configurations", "spark.sql.warehouse.dir=2", "Configurations that might not take effect", "spark.abcd=abcb4", "spark.abc=abcb"})).foreach((Function1 & Serializable)msg -> {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(logs.exists((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.contains(msg))), "logs.exists(((x$9: String) => x$9.contains(msg)))", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(19).append((String)msg).append(" did not exist in:\n").append(logs.mkString("\n")).toString(), Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 512));
            });
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 491));
        this.test("SPARK-37727: Hide the same configuration already explicitly set in logs", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkSession$.MODULE$.builder().master("local").config("spark.abc", "abc").getOrCreate();
            SparkFunSuite.LogAppender logAppender = new SparkFunSuite.LogAppender((SparkFunSuite)this, this.LogAppender().$lessinit$greater$default$1(), this.LogAppender().$lessinit$greater$default$2());
            logAppender.setThreshold(Level.DEBUG);
            SparkFunSuite.LogAppender x$5 = logAppender;
            Some x$6 = new Some((Object)Level.DEBUG);
            Seq x$7 = this.withLogAppender$default$2();
            JFunction0.mcV.sp & Serializable x$8 = (JFunction0.mcV.sp & Serializable)() -> {
                SparkSession$.MODULE$.builder().config("spark.abc", "abc").getOrCreate();
                SparkSession$.MODULE$.builder().config("spark.abc.new", "abc").getOrCreate();
                SparkSession$.MODULE$.builder().config("spark.abc.new", "abc").getOrCreate();
            };
            this.withLogAppender((AbstractAppender)x$5, x$7, (Option)x$6, (Function0)x$8);
            ArrayBuffer logs = (ArrayBuffer)logAppender.loggingEvents().map((Function1 & Serializable)x$10 -> x$10.getMessage().getFormattedMessage());
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Using an existing Spark session; only runtime SQL configurations will take effect", "Configurations that might not take effect", "spark.abc.new=abc"})).foreach((Function1 & Serializable)msg -> {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(logs.exists((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.contains(msg))), "logs.exists(((x$11: String) => x$11.contains(msg)))", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(19).append((String)msg).append(" did not exist in:\n").append(logs.mkString("\n")).toString(), Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 536));
            });
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(logs.exists((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12.contains("spark.abc=abc"))), "logs.exists(((x$12: String) => x$12.contains(\"spark.abc=abc\")))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(28).append("'spark.abc=abc' existed in:\n").append(logs.mkString("\n")).toString(), Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 539));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 516));
        this.test("SPARK-37727: Hide runtime SQL configurations in logs", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkSession$.MODULE$.builder().master("local").getOrCreate();
            SparkFunSuite.LogAppender logAppender = new SparkFunSuite.LogAppender((SparkFunSuite)this, this.LogAppender().$lessinit$greater$default$1(), this.LogAppender().$lessinit$greater$default$2());
            logAppender.setThreshold(Level.DEBUG);
            SparkFunSuite.LogAppender x$9 = logAppender;
            Some x$10 = new Some((Object)Level.DEBUG);
            Seq x$11 = this.withLogAppender$default$2();
            JFunction0.mcV.sp & Serializable x$12 = (JFunction0.mcV.sp & Serializable)() -> {
                SparkSession$.MODULE$.builder().config("spark.sql.ansi.enabled", "true").getOrCreate();
                SparkSession$.MODULE$.builder().config("spark.buffer.size", "1234").getOrCreate();
                SparkSession$.MODULE$.builder().config("spark.sql.source.abc", "abc").getOrCreate();
                SparkSession$.MODULE$.builder().config("spark.sql.warehouse.dir", "xyz").getOrCreate();
            };
            this.withLogAppender((AbstractAppender)x$9, x$11, (Option)x$10, (Function0)x$12);
            ArrayBuffer logs = (ArrayBuffer)logAppender.loggingEvents().map((Function1 & Serializable)x$13 -> x$13.getMessage().getFormattedMessage());
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"spark.buffer.size=1234", "spark.sql.source.abc=abc", "spark.sql.warehouse.dir=xyz"})).foreach((Function1 & Serializable)msg -> {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(logs.exists((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)x$14.contains(msg))), "logs.exists(((x$14: String) => x$14.contains(msg)))", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(19).append((String)msg).append(" did not exist in:\n").append(logs.mkString("\n")).toString(), Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 566));
            });
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(logs.exists((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)x$15.contains("spark.sql.ansi.enabled\""))), "logs.exists(((x$15: String) => x$15.contains(\"spark.sql.ansi.enabled\\\"\")))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(37).append("'spark.sql.ansi.enabled' existed in:\n").append(logs.mkString("\n")).toString(), Prettifier$.MODULE$.default(), new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 569));
        }, new Position("SparkSessionBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 544));
        Statics.releaseFence();
    }
}

