/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.columnar.BOOLEAN$;
import org.apache.spark.sql.execution.columnar.BYTE$;
import org.apache.spark.sql.execution.columnar.BooleanColumnStats;
import org.apache.spark.sql.execution.columnar.ByteColumnStats;
import org.apache.spark.sql.execution.columnar.CALENDAR_INTERVAL$;
import org.apache.spark.sql.execution.columnar.COMPACT_DECIMAL;
import org.apache.spark.sql.execution.columnar.ColumnStats;
import org.apache.spark.sql.execution.columnar.ColumnType;
import org.apache.spark.sql.execution.columnar.ColumnarTestUtils$;
import org.apache.spark.sql.execution.columnar.DOUBLE$;
import org.apache.spark.sql.execution.columnar.DecimalColumnStats;
import org.apache.spark.sql.execution.columnar.DoubleColumnStats;
import org.apache.spark.sql.execution.columnar.FLOAT$;
import org.apache.spark.sql.execution.columnar.FloatColumnStats;
import org.apache.spark.sql.execution.columnar.INT$;
import org.apache.spark.sql.execution.columnar.IntColumnStats;
import org.apache.spark.sql.execution.columnar.IntervalColumnStats;
import org.apache.spark.sql.execution.columnar.LONG$;
import org.apache.spark.sql.execution.columnar.LongColumnStats;
import org.apache.spark.sql.execution.columnar.NativeColumnType;
import org.apache.spark.sql.execution.columnar.SHORT$;
import org.apache.spark.sql.execution.columnar.STRING$;
import org.apache.spark.sql.execution.columnar.ShortColumnStats;
import org.apache.spark.sql.execution.columnar.StringColumnStats;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.compatible.Assertion;
import scala.Double$;
import scala.Float$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u00014A!\u0002\u0004\u0001'!)\u0001\u0004\u0001C\u00013!)A\u0004\u0001C\u0001;!)A\u000b\u0001C\u0001+\")!\f\u0001C\u00017\n\u00012i\u001c7v[:\u001cF/\u0019;t'VLG/\u001a\u0006\u0003\u000f!\t\u0001bY8mk6t\u0017M\u001d\u0006\u0003\u0013)\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005-a\u0011aA:rY*\u0011QBD\u0001\u0006gB\f'o\u001b\u0006\u0003\u001fA\ta!\u00199bG\",'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001!\u0002CA\u000b\u0017\u001b\u0005a\u0011BA\f\r\u00055\u0019\u0006/\u0019:l\rVt7+^5uK\u00061A(\u001b8jiz\"\u0012A\u0007\t\u00037\u0001i\u0011AB\u0001\u0010i\u0016\u001cHoQ8mk6t7\u000b^1ugV\u0019ad\u0011\u001b\u0015\t})S\b\u0014\t\u0003A\rj\u0011!\t\u0006\u0002E\u0005)1oY1mC&\u0011A%\t\u0002\u0005+:LG\u000fC\u0003'\u0005\u0001\u0007q%\u0001\td_2,XN\\*uCR\u001c8\t\\1tgB\u0019\u0001f\f\u001a\u000f\u0005%j\u0003C\u0001\u0016\"\u001b\u0005Y#B\u0001\u0017\u0013\u0003\u0019a$o\\8u}%\u0011a&I\u0001\u0007!J,G-\u001a4\n\u0005A\n$!B\"mCN\u001c(B\u0001\u0018\"!\t\u0019D\u0007\u0004\u0001\u0005\u000bU\u0012!\u0019\u0001\u001c\u0003\u0003U\u000b\"a\u000e\u001e\u0011\u0005\u0001B\u0014BA\u001d\"\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"aG\u001e\n\u0005q2!aC\"pYVlgn\u0015;biNDQA\u0010\u0002A\u0002}\n!bY8mk6tG+\u001f9f!\rY\u0002IQ\u0005\u0003\u0003\u001a\u0011\u0001CT1uSZ,7i\u001c7v[:$\u0016\u0010]3\u0011\u0005M\u001aE!\u0002#\u0003\u0005\u0004)%!\u0001+\u0012\u0005]2\u0005CA$K\u001b\u0005A%BA%\u000b\u0003\u0015!\u0018\u0010]3t\u0013\tY\u0005J\u0001\u0006Bi>l\u0017n\u0019+za\u0016DQ!\u0014\u0002A\u00029\u000b\u0011#\u001b8ji&\fGn\u0015;bi&\u001cH/[2t!\r\u0001s*U\u0005\u0003!\u0006\u0012Q!\u0011:sCf\u0004\"\u0001\t*\n\u0005M\u000b#aA!os\u00061B/Z:u\t\u0016\u001c\u0017.\\1m\u0007>dW/\u001c8Ti\u0006$8/F\u0002W1f#\"aH,\t\u000b5\u001b\u0001\u0019\u0001(\u0005\u000b\u0011\u001b!\u0019A#\u0005\u000bU\u001a!\u0019\u0001\u001c\u0002/Q,7\u000f^%oi\u0016\u0014h/\u00197D_2,XN\\*uCR\u001cXc\u0001/_?R\u0011q$\u0018\u0005\u0006\u001b\u0012\u0001\rA\u0014\u0003\u0006\t\u0012\u0011\r!\u0012\u0003\u0006k\u0011\u0011\rA\u000e")
public class ColumnStatsSuite
extends SparkFunSuite {
    public <T extends AtomicType, U extends ColumnStats> void testColumnStats(Class<U> columnStatsClass, NativeColumnType<T> columnType, Object[] initialStatistics) {
        String columnStatsName = columnStatsClass.getSimpleName();
        this.test(new StringBuilder(7).append(columnStatsName).append(": empty").toString(), (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            ColumnStats columnStats = (ColumnStats)columnStatsClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.genericArrayOps((Object)columnStats.collectedStatistics()), (IterableOnce)Predef$.MODULE$.genericWrapArray((Object)initialStatistics))), (Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Object actual = tuple2._1();
                Object expected = tuple2._2();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(actual);
                Object $org_scalatest_assert_macro_right = expected;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertion assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
                return assertion;
            });
        }, new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
        this.test(new StringBuilder(11).append(columnStatsName).append(": non-empty").toString(), (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ColumnStats columnStats = (ColumnStats)columnStatsClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            Seq rows = (Seq)((IterableOps)package$.MODULE$.Seq().fill(10, (Function0 & Serializable)() -> ColumnarTestUtils$.MODULE$.makeRandomRow((ColumnType<?>)columnType, (Seq<ColumnType<?>>)Nil$.MODULE$))).$plus$plus((IterableOnce)package$.MODULE$.Seq().fill(10, (Function0 & Serializable)() -> ColumnarTestUtils$.MODULE$.makeNullRow(1)));
            rows.foreach((Function1 & Serializable)x$1 -> {
                columnStats.gatherStats(x$1, 0);
                return BoxedUnit.UNIT;
            });
            Seq values = (Seq)((IterableOps)rows.take(10)).map((Function1 & Serializable)x$2 -> x$2.get(0, (DataType)columnType.dataType()));
            Ordering ordering2 = columnType.dataType().ordering();
            Object[] stats = columnStats.collectedStatistics();
            this.assertResult(values.min(ordering2), "Wrong lower bound", stats[0], Prettifier$.MODULE$.default(), new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
            this.assertResult(values.max(ordering2), "Wrong upper bound", stats[1], Prettifier$.MODULE$.default(), new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
            this.assertResult(BoxesRunTime.boxToInteger((int)10), "Wrong null count", stats[2], Prettifier$.MODULE$.default(), new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
            this.assertResult(BoxesRunTime.boxToInteger((int)20), "Wrong row count", stats[3], Prettifier$.MODULE$.default(), new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
            return this.assertResult(stats[4], "Wrong size in bytes", ((IterableOnceOps)rows.map((Function1 & Serializable)row -> BoxesRunTime.boxToInteger((int)ColumnStatsSuite.$anonfun$testColumnStats$8(columnType, row)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$), Prettifier$.MODULE$.default(), new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
        }, new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
    }

    public <T extends AtomicType, U extends ColumnStats> void testDecimalColumnStats(Object[] initialStatistics) {
        String columnStatsName = DecimalColumnStats.class.getSimpleName();
        COMPACT_DECIMAL columnType = new COMPACT_DECIMAL(15, 10);
        this.test(new StringBuilder(7).append(columnStatsName).append(": empty").toString(), (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            DecimalColumnStats columnStats = new DecimalColumnStats(15, 10);
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.genericArrayOps((Object)columnStats.collectedStatistics()), (IterableOnce)Predef$.MODULE$.genericWrapArray((Object)initialStatistics))), (Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Object actual = tuple2._1();
                Object expected = tuple2._2();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(actual);
                Object $org_scalatest_assert_macro_right = expected;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertion assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
                return assertion;
            });
        }, new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
        this.test(new StringBuilder(11).append(columnStatsName).append(": non-empty").toString(), (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            DecimalColumnStats columnStats = new DecimalColumnStats(15, 10);
            Seq rows = (Seq)((IterableOps)package$.MODULE$.Seq().fill(10, (Function0 & Serializable)() -> ColumnarTestUtils$.MODULE$.makeRandomRow((ColumnType<?>)columnType, (Seq<ColumnType<?>>)Nil$.MODULE$))).$plus$plus((IterableOnce)package$.MODULE$.Seq().fill(10, (Function0 & Serializable)() -> ColumnarTestUtils$.MODULE$.makeNullRow(1)));
            rows.foreach((Function1 & Serializable)x$3 -> {
                columnStats.gatherStats(x$3, 0);
                return BoxedUnit.UNIT;
            });
            Seq values = (Seq)((IterableOps)rows.take(10)).map((Function1 & Serializable)x$4 -> x$4.get(0, (DataType)columnType.dataType()));
            Decimal.DecimalIsFractional$ ordering2 = ((DecimalType)columnType.dataType()).ordering();
            Object[] stats = columnStats.collectedStatistics();
            this.assertResult(values.min((Ordering)ordering2), "Wrong lower bound", stats[0], Prettifier$.MODULE$.default(), new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
            this.assertResult(values.max((Ordering)ordering2), "Wrong upper bound", stats[1], Prettifier$.MODULE$.default(), new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
            this.assertResult(BoxesRunTime.boxToInteger((int)10), "Wrong null count", stats[2], Prettifier$.MODULE$.default(), new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
            this.assertResult(BoxesRunTime.boxToInteger((int)20), "Wrong row count", stats[3], Prettifier$.MODULE$.default(), new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
            return this.assertResult(stats[4], "Wrong size in bytes", ((IterableOnceOps)rows.map((Function1 & Serializable)row -> BoxesRunTime.boxToInteger((int)ColumnStatsSuite.$anonfun$testDecimalColumnStats$8(columnType, row)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$), Prettifier$.MODULE$.default(), new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
        }, new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
    }

    public <T extends AtomicType, U extends ColumnStats> void testIntervalColumnStats(Object[] initialStatistics) {
        String columnStatsName = IntervalColumnStats.class.getSimpleName();
        CALENDAR_INTERVAL$ columnType = CALENDAR_INTERVAL$.MODULE$;
        this.test(new StringBuilder(7).append(columnStatsName).append(": empty").toString(), (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            IntervalColumnStats columnStats = new IntervalColumnStats();
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.genericArrayOps((Object)columnStats.collectedStatistics()), (IterableOnce)Predef$.MODULE$.genericWrapArray((Object)initialStatistics))), (Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Object actual = tuple2._1();
                Object expected = tuple2._2();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(actual);
                Object $org_scalatest_assert_macro_right = expected;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertion assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
                return assertion;
            });
        }, new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
        this.test(new StringBuilder(11).append(columnStatsName).append(": non-empty").toString(), (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            IntervalColumnStats columnStats = new IntervalColumnStats();
            Seq rows = (Seq)((IterableOps)package$.MODULE$.Seq().fill(10, (Function0 & Serializable)() -> ColumnarTestUtils$.MODULE$.makeRandomRow((ColumnType<?>)columnType, (Seq<ColumnType<?>>)Nil$.MODULE$))).$plus$plus((IterableOnce)package$.MODULE$.Seq().fill(10, (Function0 & Serializable)() -> ColumnarTestUtils$.MODULE$.makeNullRow(1)));
            rows.foreach((Function1 & Serializable)x$5 -> {
                columnStats.gatherStats(x$5, 0);
                return BoxedUnit.UNIT;
            });
            Object[] stats = columnStats.collectedStatistics();
            this.assertResult(BoxesRunTime.boxToInteger((int)10), "Wrong null count", stats[2], Prettifier$.MODULE$.default(), new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
            this.assertResult(BoxesRunTime.boxToInteger((int)20), "Wrong row count", stats[3], Prettifier$.MODULE$.default(), new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
            return this.assertResult(stats[4], "Wrong size in bytes", ((IterableOnceOps)rows.map((Function1 & Serializable)row -> BoxesRunTime.boxToInteger((int)ColumnStatsSuite.$anonfun$testIntervalColumnStats$7(columnType, row)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$), Prettifier$.MODULE$.default(), new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
        }, new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
    }

    public static final /* synthetic */ int $anonfun$testColumnStats$8(NativeColumnType columnType$1, InternalRow row) {
        return row.isNullAt(0) ? 4 : columnType$1.actualSize(row, 0);
    }

    public static final /* synthetic */ int $anonfun$testDecimalColumnStats$8(COMPACT_DECIMAL columnType$2, InternalRow row) {
        return row.isNullAt(0) ? 4 : columnType$2.actualSize(row, 0);
    }

    public static final /* synthetic */ int $anonfun$testIntervalColumnStats$7(CALENDAR_INTERVAL$ columnType$3, InternalRow row) {
        return row.isNullAt(0) ? 4 : columnType$3.actualSize(row, 0);
    }

    public ColumnStatsSuite() {
        this.testColumnStats((Class)BooleanColumnStats.class, (NativeColumnType)BOOLEAN$.MODULE$, new Object[]{BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToInteger((int)0)});
        this.testColumnStats((Class)ByteColumnStats.class, (NativeColumnType)BYTE$.MODULE$, new Object[]{BoxesRunTime.boxToByte((byte)127), BoxesRunTime.boxToByte((byte)-128), BoxesRunTime.boxToInteger((int)0)});
        this.testColumnStats((Class)ShortColumnStats.class, (NativeColumnType)SHORT$.MODULE$, new Object[]{BoxesRunTime.boxToShort((short)Short.MAX_VALUE), BoxesRunTime.boxToShort((short)Short.MIN_VALUE), BoxesRunTime.boxToInteger((int)0)});
        this.testColumnStats((Class)IntColumnStats.class, (NativeColumnType)INT$.MODULE$, new Object[]{BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE), BoxesRunTime.boxToInteger((int)Integer.MIN_VALUE), BoxesRunTime.boxToInteger((int)0)});
        this.testColumnStats((Class)LongColumnStats.class, (NativeColumnType)LONG$.MODULE$, new Object[]{BoxesRunTime.boxToLong((long)Long.MAX_VALUE), BoxesRunTime.boxToLong((long)Long.MIN_VALUE), BoxesRunTime.boxToInteger((int)0)});
        this.testColumnStats((Class)FloatColumnStats.class, (NativeColumnType)FLOAT$.MODULE$, new Object[]{BoxesRunTime.boxToFloat((float)Float.MAX_VALUE), BoxesRunTime.boxToFloat((float)Float$.MODULE$.MinValue()), BoxesRunTime.boxToInteger((int)0)});
        this.testColumnStats((Class)DoubleColumnStats.class, (NativeColumnType)DOUBLE$.MODULE$, new Object[]{BoxesRunTime.boxToDouble((double)Double.MAX_VALUE), BoxesRunTime.boxToDouble((double)Double$.MODULE$.MinValue()), BoxesRunTime.boxToInteger((int)0)});
        this.testColumnStats((Class)StringColumnStats.class, (NativeColumnType)STRING$.MODULE$, new Object[]{null, null, BoxesRunTime.boxToInteger((int)0)});
        this.testDecimalColumnStats(new Object[]{null, null, BoxesRunTime.boxToInteger((int)0)});
        this.testIntervalColumnStats(new Object[]{null, null, BoxesRunTime.boxToInteger((int)0)});
    }
}

