/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.execution.columnar.ARRAY;
import org.apache.spark.sql.execution.columnar.BINARY$;
import org.apache.spark.sql.execution.columnar.BOOLEAN$;
import org.apache.spark.sql.execution.columnar.BYTE$;
import org.apache.spark.sql.execution.columnar.CALENDAR_INTERVAL$;
import org.apache.spark.sql.execution.columnar.COMPACT_DECIMAL;
import org.apache.spark.sql.execution.columnar.ColumnType;
import org.apache.spark.sql.execution.columnar.ColumnarTestUtils$;
import org.apache.spark.sql.execution.columnar.DOUBLE$;
import org.apache.spark.sql.execution.columnar.FLOAT$;
import org.apache.spark.sql.execution.columnar.INT$;
import org.apache.spark.sql.execution.columnar.LARGE_DECIMAL;
import org.apache.spark.sql.execution.columnar.LONG$;
import org.apache.spark.sql.execution.columnar.MAP;
import org.apache.spark.sql.execution.columnar.SHORT$;
import org.apache.spark.sql.execution.columnar.STRING$;
import org.apache.spark.sql.execution.columnar.STRUCT;
import org.apache.spark.sql.execution.columnar.TestNullableColumnBuilder;
import org.apache.spark.sql.execution.columnar.TestNullableColumnBuilder$;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005M2Aa\u0001\u0003\u0001#!)a\u0003\u0001C\u0001/!)!\u0004\u0001C\u00017\tQb*\u001e7mC\ndWmQ8mk6t')^5mI\u0016\u00148+^5uK*\u0011QAB\u0001\tG>dW/\u001c8be*\u0011q\u0001C\u0001\nKb,7-\u001e;j_:T!!\u0003\u0006\u0002\u0007M\fHN\u0003\u0002\f\u0019\u0005)1\u000f]1sW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\n\u0011\u0005M!R\"\u0001\u0006\n\u0005UQ!!D*qCJ\\g)\u001e8Tk&$X-\u0001\u0004=S:LGO\u0010\u000b\u00021A\u0011\u0011\u0004A\u0007\u0002\t\u0005IB/Z:u\u001dVdG.\u00192mK\u000e{G.^7o\u0005VLG\u000eZ3s+\ta\"\u0006\u0006\u0002\u001eGA\u0011a$I\u0007\u0002?)\t\u0001%A\u0003tG\u0006d\u0017-\u0003\u0002#?\t!QK\\5u\u0011\u0015!#\u00011\u0001&\u0003)\u0019w\u000e\\;n]RK\b/\u001a\t\u00043\u0019B\u0013BA\u0014\u0005\u0005)\u0019u\u000e\\;n]RK\b/\u001a\t\u0003S)b\u0001\u0001B\u0003,\u0005\t\u0007AFA\u0004Km6$\u0016\u0010]3\u0012\u00055\u0002\u0004C\u0001\u0010/\u0013\tysDA\u0004O_RD\u0017N\\4\u0011\u0005y\t\u0014B\u0001\u001a \u0005\r\te.\u001f")
public class NullableColumnBuilderSuite
extends SparkFunSuite {
    public <JvmType> void testNullableColumnBuilder(ColumnType<JvmType> columnType) {
        String typeName = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(columnType.getClass().getSimpleName()), "$");
        DataType dataType = columnType.dataType();
        UnsafeProjection proj = UnsafeProjection$.MODULE$.create((DataType[])((Object[])new DataType[]{dataType}));
        Function1 converter = CatalystTypeConverters$.MODULE$.createToScalaConverter(dataType);
        this.test(new StringBuilder(29).append(typeName).append(" column builder: empty column").toString(), (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TestNullableColumnBuilder columnBuilder = TestNullableColumnBuilder$.MODULE$.apply(columnType, TestNullableColumnBuilder$.MODULE$.apply$default$2());
            ByteBuffer buffer = columnBuilder.build();
            this.assertResult(BoxesRunTime.boxToInteger((int)0), "Wrong null count", BoxesRunTime.boxToInteger((int)buffer.getInt()), Prettifier$.MODULE$.default(), new Position("NullableColumnBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(buffer.hasRemaining(), "buffer.hasRemaining()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("NullableColumnBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
        }, new Position("NullableColumnBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
        this.test(new StringBuilder(40).append(typeName).append(" column builder: buffer size auto growth").toString(), (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TestNullableColumnBuilder columnBuilder = TestNullableColumnBuilder$.MODULE$.apply(columnType, TestNullableColumnBuilder$.MODULE$.apply$default$2());
            InternalRow randomRow = ColumnarTestUtils$.MODULE$.makeRandomRow(columnType, (Seq<ColumnType<?>>)Nil$.MODULE$);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 4).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> columnBuilder.appendFrom((InternalRow)proj.apply(randomRow), 0));
            ByteBuffer buffer = columnBuilder.build();
            return this.assertResult(BoxesRunTime.boxToInteger((int)0), "Wrong null count", BoxesRunTime.boxToInteger((int)buffer.getInt()), Prettifier$.MODULE$.default(), new Position("NullableColumnBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        }, new Position("NullableColumnBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        this.test(new StringBuilder(28).append(typeName).append(" column builder: null values").toString(), (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TestNullableColumnBuilder columnBuilder = TestNullableColumnBuilder$.MODULE$.apply(columnType, TestNullableColumnBuilder$.MODULE$.apply$default$2());
            InternalRow randomRow = ColumnarTestUtils$.MODULE$.makeRandomRow(columnType, (Seq<ColumnType<?>>)Nil$.MODULE$);
            GenericInternalRow nullRow = ColumnarTestUtils$.MODULE$.makeNullRow(1);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 4).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$3 -> {
                columnBuilder.appendFrom((InternalRow)proj.apply(randomRow), 0);
                columnBuilder.appendFrom((InternalRow)proj.apply((InternalRow)nullRow), 0);
            });
            ByteBuffer buffer = columnBuilder.build();
            this.assertResult(BoxesRunTime.boxToInteger((int)4), "Wrong null count", BoxesRunTime.boxToInteger((int)buffer.getInt()), Prettifier$.MODULE$.default(), new Position("NullableColumnBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 7).by(2).foreach((Function1 & Serializable)x$4 -> this.assertResult(BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)x$4)), "Wrong null position", BoxesRunTime.boxToInteger((int)buffer.getInt()), Prettifier$.MODULE$.default(), new Position("NullableColumnBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95)));
            GenericInternalRow actual = new GenericInternalRow(new Object[1]);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 4).foreach((Function1 & Serializable)x$5 -> NullableColumnBuilderSuite.$anonfun$testNullableColumnBuilder$7(this, columnType, buffer, actual, converter, dataType, randomRow, BoxesRunTime.unboxToInt((Object)x$5)));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(buffer.hasRemaining(), "buffer.hasRemaining()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("NullableColumnBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        }, new Position("NullableColumnBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
    }

    public static final /* synthetic */ Assertion $anonfun$testNullableColumnBuilder$7(NullableColumnBuilderSuite $this, ColumnType columnType$1, ByteBuffer buffer$1, GenericInternalRow actual$1, Function1 converter$1, DataType dataType$1, InternalRow randomRow$2, int x$5) {
        columnType$1.extract(buffer$1, (InternalRow)actual$1, 0);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(converter$1.apply(actual$1.get(0, dataType$1)));
        Object $org_scalatest_assert_macro_right = converter$1.apply(randomRow$2.get(0, dataType$1));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Extracted value didn't equal to the original one", Prettifier$.MODULE$.default(), new Position("NullableColumnBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
    }

    public NullableColumnBuilderSuite() {
        ColumnType[] columnTypeArray = new ColumnType[15];
        columnTypeArray[0] = BOOLEAN$.MODULE$;
        columnTypeArray[1] = BYTE$.MODULE$;
        columnTypeArray[2] = SHORT$.MODULE$;
        columnTypeArray[3] = INT$.MODULE$;
        columnTypeArray[4] = LONG$.MODULE$;
        columnTypeArray[5] = FLOAT$.MODULE$;
        columnTypeArray[6] = DOUBLE$.MODULE$;
        columnTypeArray[7] = STRING$.MODULE$;
        columnTypeArray[8] = BINARY$.MODULE$;
        columnTypeArray[9] = new COMPACT_DECIMAL(15, 10);
        columnTypeArray[10] = new LARGE_DECIMAL(20, 10);
        StructField structField = new StructField("a", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        columnTypeArray[11] = new STRUCT(StructType$.MODULE$.apply((Seq)package$.MODULE$.Nil().$colon$colon((Object)structField)));
        columnTypeArray[12] = new ARRAY(ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$));
        columnTypeArray[13] = new MAP(MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$));
        columnTypeArray[14] = CALENDAR_INTERVAL$.MODULE$;
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])columnTypeArray)).foreach((Function1 & Serializable)x$1 -> {
            this.testNullableColumnBuilder(x$1);
            return BoxedUnit.UNIT;
        });
    }
}

