/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command.v1;

import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.QueryTest;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t2qAA\u0002\u0011\u0002\u0007\u0005!\u0003C\u0003\u001b\u0001\u0011\u00051DA\fTQ><\b+\u0019:uSRLwN\\:Tk&$XMQ1tK*\u0011A!B\u0001\u0003mFR!AB\u0004\u0002\u000f\r|W.\\1oI*\u0011\u0001\"C\u0001\nKb,7-\u001e;j_:T!AC\u0006\u0002\u0007M\fHN\u0003\u0002\r\u001b\u0005)1\u000f]1sW*\u0011abD\u0001\u0007CB\f7\r[3\u000b\u0003A\t1a\u001c:h\u0007\u0001\u00192\u0001A\n\u0018!\t!R#D\u0001\n\u0013\t1\u0012BA\u0005Rk\u0016\u0014\u0018\u0010V3tiB\u0011\u0001$G\u0007\u0002\u000b%\u0011!!B\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0015\u0003q\u0001\"!\b\u0011\u000e\u0003yQ\u0011aH\u0001\u0006g\u000e\fG.Y\u0005\u0003Cy\u0011A!\u00168ji\u0002")
public interface ShowPartitionsSuiteBase
extends org.apache.spark.sql.execution.command.ShowPartitionsSuiteBase {
    public static void $init$(ShowPartitionsSuiteBase $this) {
        $this.test("show everything in the default database", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String table = "dateTable";
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{table}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.createDateTable(table);
                Row row = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"year=2015/month=1"}));
                Row row2 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"year=2015/month=2"}));
                Row row3 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"year=2016/month=2"}));
                Row row4 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"year=2016/month=3"}));
                $this.runShowPartitionsSql(new StringBuilder(24).append("show partitions default.").append(table).toString(), (Seq<Row>)package$.MODULE$.Nil().$colon$colon((Object)row4).$colon$colon((Object)row3).$colon$colon((Object)row2).$colon$colon((Object)row));
            });
        }, new Position("ShowPartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 32));
        $this.test("show partitions of a view", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String table = "dateTable";
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{table}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.createDateTable(table);
                String view = "view1";
                $this.withView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{view}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    String errMsg;
                    $this.sql().apply((Object)new StringBuilder(30).append("CREATE VIEW ").append(view).append(" as select * from ").append(table).toString());
                    String $org_scalatest_assert_macro_left = errMsg = ((AnalysisException)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(16).append("SHOW PARTITIONS ").append(view).toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ShowPartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54))).getMessage();
                    String $org_scalatest_assert_macro_right = "'SHOW PARTITIONS' expects a table";
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ShowPartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
                });
            });
        }, new Position("ShowPartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
        $this.test("show partitions of a temporary view", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String viewName = "test_view";
            $this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{viewName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                String errMsg;
                $this.spark().range(10L).createTempView(viewName);
                String $org_scalatest_assert_macro_left = errMsg = ((AnalysisException)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(16).append("SHOW PARTITIONS ").append(viewName).toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ShowPartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66))).getMessage();
                String $org_scalatest_assert_macro_right = "'SHOW PARTITIONS' expects a table";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ShowPartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
            });
        }, new Position("ShowPartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        $this.test("SPARK-33591: null as a partition value", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = "part_table";
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(56).append("CREATE TABLE ").append(t).append(" (col1 INT, p1 STRING) ").append($this.defaultUsing()).append(" PARTITIONED BY (p1)").toString());
                $this.sql().apply((Object)new StringBuilder(49).append("INSERT INTO TABLE ").append(t).append(" PARTITION (p1 = null) SELECT 0").toString());
                ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(16).append("SHOW PARTITIONS ").append(t).toString()), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"p1=__HIVE_DEFAULT_PARTITION__"})));
                ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(38).append("SHOW PARTITIONS ").append(t).append(" PARTITION (p1 = null)").toString()), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"p1=__HIVE_DEFAULT_PARTITION__"})));
            });
        }, new Position("ShowPartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
    }
}

