/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.csv;

import java.io.File;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import org.apache.spark.benchmark.Benchmark;
import org.apache.spark.benchmark.Benchmark$;
import org.apache.spark.benchmark.BenchmarkBase;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Column$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.execution.benchmark.SqlBasedBenchmark;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class CSVBenchmark$
extends BenchmarkBase
implements SqlBasedBenchmark {
    public static final CSVBenchmark$ MODULE$ = new CSVBenchmark$();
    private static SparkSession spark;
    private static String sparkHome;
    private static volatile boolean bitmap$0;

    static {
        SQLHelper.$init$((SQLHelper)MODULE$);
        SqlBasedBenchmark.$init$(MODULE$);
    }

    @Override
    public SparkSession getSparkSession() {
        return SqlBasedBenchmark.getSparkSession$(this);
    }

    @Override
    public final void codegenBenchmark(String name, long cardinality, Function0<BoxedUnit> f) {
        SqlBasedBenchmark.codegenBenchmark$(this, name, cardinality, f);
    }

    @Override
    public SqlBasedBenchmark.DatasetToBenchmark DatasetToBenchmark(Dataset<?> ds) {
        return SqlBasedBenchmark.DatasetToBenchmark$(this, ds);
    }

    @Override
    public void prepareDataInfo(Benchmark benchmark) {
        SqlBasedBenchmark.prepareDataInfo$(this, benchmark);
    }

    @Override
    public StructType writeWideRow(String path, int rowsNum, int numCols) {
        return SqlBasedBenchmark.writeWideRow$(this, path, rowsNum, numCols);
    }

    @Override
    public void afterAll() {
        SqlBasedBenchmark.afterAll$(this);
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$((SQLHelper)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    @Override
    public SparkSession spark() {
        return spark;
    }

    @Override
    public void org$apache$spark$sql$execution$benchmark$SqlBasedBenchmark$_setter_$spark_$eq(SparkSession x$1) {
        spark = x$1;
    }

    private String sparkHome$lzycompute() {
        CSVBenchmark$ cSVBenchmark$ = this;
        synchronized (cSVBenchmark$) {
            if (!bitmap$0) {
                sparkHome = SQLHelper.sparkHome$((SQLHelper)this);
                bitmap$0 = true;
            }
        }
        return sparkHome;
    }

    public String sparkHome() {
        return !bitmap$0 ? this.sparkHome$lzycompute() : sparkHome;
    }

    private void quotedValuesBenchmark(int rowsNum, int numIters) {
        String x$1 = "Parsing quoted values";
        long x$2 = rowsNum;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, x$3);
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)path -> {
            CSVBenchmark$.$anonfun$quotedValuesBenchmark$1(rowsNum, benchmark, numIters, path);
            return BoxedUnit.UNIT;
        });
    }

    private void multiColumnsBenchmark(int rowsNum, int numIters) {
        int colsNum = 1000;
        String x$1 = new StringBuilder(23).append("Wide rows with ").append(colsNum).append(" columns").toString();
        long x$2 = rowsNum;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, x$3);
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)path -> {
            CSVBenchmark$.$anonfun$multiColumnsBenchmark$1(colsNum, rowsNum, benchmark, numIters, path);
            return BoxedUnit.UNIT;
        });
    }

    private void countBenchmark(int rowsNum, int numIters) {
        int colsNum = 10;
        String x$1 = new StringBuilder(29).append("Count a dataset with ").append(colsNum).append(" columns").toString();
        long x$2 = rowsNum;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, x$3);
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)path -> {
            CSVBenchmark$.$anonfun$countBenchmark$1(colsNum, rowsNum, benchmark, numIters, path);
            return BoxedUnit.UNIT;
        });
    }

    private void datetimeBenchmark(int rowsNum, int numIters) {
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)path -> {
            CSVBenchmark$.$anonfun$datetimeBenchmark$5(this, rowsNum, numIters, path);
            return BoxedUnit.UNIT;
        });
    }

    private void filtersPushdownBenchmark(int rowsNum, int numIters) {
        String x$1 = "Filters pushdown";
        long x$2 = rowsNum;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, x$3);
        int colsNum = 100;
        Seq fields = (Seq)package$.MODULE$.Seq().tabulate(colsNum, (Function1 & Serializable)i -> CSVBenchmark$.$anonfun$filtersPushdownBenchmark$1(BoxesRunTime.unboxToInt((Object)i)));
        StructField structField = new StructField("key", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructType schema = StructType$.MODULE$.apply((Seq)fields.$plus$colon((Object)structField));
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)path -> {
            CSVBenchmark$.$anonfun$filtersPushdownBenchmark$3(this, rowsNum, schema, benchmark, numIters, colsNum, path);
            return BoxedUnit.UNIT;
        });
    }

    public void runBenchmarkSuite(String[] mainArgs) {
        this.runBenchmark("Benchmark to measure CSV read/write performance", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int numIters = 3;
            MODULE$.quotedValuesBenchmark(50000, numIters);
            MODULE$.multiColumnsBenchmark(1000000, numIters);
            MODULE$.countBenchmark(10000000, numIters);
            MODULE$.datetimeBenchmark(10000000, numIters);
            MODULE$.filtersPushdownBenchmark(100000, numIters);
        });
    }

    public static final /* synthetic */ String $anonfun$quotedValuesBenchmark$2(int i) {
        return new StringBuilder(2).append("\"").append(i).append("\"").toString();
    }

    public static final /* synthetic */ void $anonfun$quotedValuesBenchmark$1(int rowsNum$1, Benchmark benchmark$1, int numIters$1, File path) {
        String str = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10000).map((Function1 & Serializable)i -> CSVBenchmark$.$anonfun$quotedValuesBenchmark$2(BoxesRunTime.unboxToInt((Object)i))).mkString(",");
        MODULE$.spark().range((long)rowsNum$1).map((Function1 & Serializable)x$1 -> str, MODULE$.spark().implicits().newStringEncoder()).write().option("header", true).csv(path.getAbsolutePath());
        StructType schema = new StructType().add("value", (DataType)StringType$.MODULE$);
        Dataset ds = MODULE$.spark().read().option("header", true).schema(schema).csv(path.getAbsolutePath());
        benchmark$1.addCase("One quoted string", numIters$1, (Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> MODULE$.DatasetToBenchmark(ds).noop());
        benchmark$1.run();
    }

    public static final /* synthetic */ StructField $anonfun$multiColumnsBenchmark$2(int i) {
        return new StructField(new StringBuilder(3).append("col").append(i).toString(), (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
    }

    public static final /* synthetic */ String $anonfun$multiColumnsBenchmark$3(int i) {
        return Integer.toString(i);
    }

    public static final /* synthetic */ Column $anonfun$multiColumnsBenchmark$4(int i) {
        return functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)i)).as(new StringBuilder(3).append("col").append(i).toString());
    }

    public static final /* synthetic */ StructField $anonfun$multiColumnsBenchmark$10(int i) {
        return new StructField(new StringBuilder(3).append("col").append(i).toString(), (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
    }

    public static final /* synthetic */ void $anonfun$multiColumnsBenchmark$1(int colsNum$1, int rowsNum$2, Benchmark benchmark$2, int numIters$2, File path) {
        Seq fields = (Seq)package$.MODULE$.Seq().tabulate(colsNum$1, (Function1 & Serializable)i -> CSVBenchmark$.$anonfun$multiColumnsBenchmark$2(BoxesRunTime.unboxToInt((Object)i)));
        StructType schema = StructType$.MODULE$.apply(fields);
        String values = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), colsNum$1).map((Function1 & Serializable)i -> CSVBenchmark$.$anonfun$multiColumnsBenchmark$3(BoxesRunTime.unboxToInt((Object)i))).mkString(",");
        String[] columnNames = schema.fieldNames();
        MODULE$.spark().range((long)rowsNum$2).select((Seq)package$.MODULE$.Seq().tabulate(colsNum$1, (Function1 & Serializable)i -> CSVBenchmark$.$anonfun$multiColumnsBenchmark$4(BoxesRunTime.unboxToInt((Object)i)))).write().option("header", true).csv(path.getAbsolutePath());
        Dataset ds = MODULE$.spark().read().schema(schema).csv(path.getAbsolutePath());
        benchmark$2.addCase(new StringBuilder(15).append("Select ").append(colsNum$1).append(" columns").toString(), numIters$2, (Function1)(JFunction1.mcVI.sp & Serializable)x$3 -> MODULE$.DatasetToBenchmark(ds.select("*", (Seq)Nil$.MODULE$)).noop());
        Column[] cols100 = (Column[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.refArrayOps((Object[])columnNames), 100)), (Function1 & Serializable)x$4 -> Column$.MODULE$.apply(x$4), ClassTag$.MODULE$.apply(Column.class));
        benchmark$2.addCase("Select 100 columns", numIters$2, (Function1)(JFunction1.mcVI.sp & Serializable)x$5 -> MODULE$.DatasetToBenchmark(ds.select((Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)cols100))).noop());
        benchmark$2.addCase("Select one column", numIters$2, (Function1)(JFunction1.mcVI.sp & Serializable)x$6 -> MODULE$.DatasetToBenchmark(ds.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{MODULE$.spark().implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$)}))).noop());
        benchmark$2.addCase("count()", numIters$2, (Function1)(JFunction1.mcVI.sp & Serializable)x$7 -> ds.count());
        StructField structField = new StructField("col0", (DataType)DateType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructType schemaErr1 = StructType$.MODULE$.apply((Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), colsNum$1).map((Function1 & Serializable)i -> CSVBenchmark$.$anonfun$multiColumnsBenchmark$10(BoxesRunTime.unboxToInt((Object)i))).$plus$colon((Object)structField));
        Dataset dsErr1 = MODULE$.spark().read().schema(schemaErr1).csv(path.getAbsolutePath());
        benchmark$2.addCase("Select 100 columns, one bad input field", numIters$2, (Function1)(JFunction1.mcVI.sp & Serializable)x$8 -> MODULE$.DatasetToBenchmark(dsErr1.select((Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)cols100))).noop());
        String badRecColName = "badRecord";
        StructType schemaErr2 = schemaErr1.add(new StructField(badRecColName, (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()));
        Dataset dsErr2 = MODULE$.spark().read().schema(schemaErr2).option("columnNameOfCorruptRecord", badRecColName).csv(path.getAbsolutePath());
        benchmark$2.addCase("Select 100 columns, corrupt record field", numIters$2, (Function1)(JFunction1.mcVI.sp & Serializable)x$9 -> {
            Column column = Column$.MODULE$.apply(badRecColName);
            MODULE$.DatasetToBenchmark(dsErr2.select((Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.$plus$colon$extension(Predef$.MODULE$.refArrayOps((Object[])cols100), (Object)column, ClassTag$.MODULE$.apply(Column.class))))).noop();
        });
        benchmark$2.run();
    }

    public static final /* synthetic */ StructField $anonfun$countBenchmark$2(int i) {
        return new StructField(new StringBuilder(3).append("col").append(i).toString(), (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
    }

    public static final /* synthetic */ Column $anonfun$countBenchmark$3(int i) {
        return functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)i)).as(new StringBuilder(3).append("col").append(i).toString());
    }

    public static final /* synthetic */ boolean $anonfun$countBenchmark$5(Row x$11) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$countBenchmark$7(Row x$13) {
        return true;
    }

    public static final /* synthetic */ void $anonfun$countBenchmark$1(int colsNum$2, int rowsNum$3, Benchmark benchmark$3, int numIters$3, File path) {
        Seq fields = (Seq)package$.MODULE$.Seq().tabulate(colsNum$2, (Function1 & Serializable)i -> CSVBenchmark$.$anonfun$countBenchmark$2(BoxesRunTime.unboxToInt((Object)i)));
        StructType schema = StructType$.MODULE$.apply(fields);
        MODULE$.spark().range((long)rowsNum$3).select((Seq)package$.MODULE$.Seq().tabulate(colsNum$2, (Function1 & Serializable)i -> CSVBenchmark$.$anonfun$countBenchmark$3(BoxesRunTime.unboxToInt((Object)i)))).write().csv(path.getAbsolutePath());
        Dataset ds = MODULE$.spark().read().schema(schema).csv(path.getAbsolutePath());
        benchmark$3.addCase(new StringBuilder(25).append("Select ").append(colsNum$2).append(" columns + count()").toString(), numIters$3, (Function1)(JFunction1.mcVI.sp & Serializable)x$10 -> ds.select("*", (Seq)Nil$.MODULE$).filter((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)CSVBenchmark$.$anonfun$countBenchmark$5(x$11))).count());
        benchmark$3.addCase("Select 1 column + count()", numIters$3, (Function1)(JFunction1.mcVI.sp & Serializable)x$12 -> ds.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{MODULE$.spark().implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$)})).filter((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)CSVBenchmark$.$anonfun$countBenchmark$7(x$13))).count());
        benchmark$3.addCase("count()", numIters$3, (Function1)(JFunction1.mcVI.sp & Serializable)x$14 -> ds.count());
        benchmark$3.run();
    }

    private final Dataset timestamps$1(int rowsNum$4) {
        return this.spark().range(0L, (long)rowsNum$4, 1L, 1).mapPartitions((Function1 & Serializable)iter -> iter.map((Function1 & Serializable)x$15 -> Instant.ofEpochSecond(Predef$.MODULE$.Long2long(x$15))), this.spark().implicits().newInstantEncoder()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.spark().implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).as("timestamp")}));
    }

    private final Dataset dates$1(int rowsNum$4) {
        return this.spark().range(0L, (long)rowsNum$4, 1L, 1).mapPartitions((Function1 & Serializable)iter -> iter.map((Function1 & Serializable)d -> LocalDate.ofEpochDay(Predef$.MODULE$.Long2long(d) % 36500L)), this.spark().implicits().newLocalDateEncoder()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.spark().implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).as("date")}));
    }

    private static final Dataset timestampStr$1(int rowsNum$4) {
        return MODULE$.spark().range(0L, (long)rowsNum$4, 1L, 1).mapPartitions((Function1 & Serializable)iter -> iter.map((Function1 & Serializable)i -> StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(new StringBuilder(21).append("1970-01-01T01:02:03.").append(Predef$.MODULE$.Long2long(i) % 200L).append("Z").toString()), ".0Z")), MODULE$.spark().implicits().newStringEncoder()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{MODULE$.spark().implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).as("timestamp")})).as(MODULE$.spark().implicits().newStringEncoder());
    }

    private static final Dataset dateStr$1(int rowsNum$4) {
        return MODULE$.spark().range(0L, (long)rowsNum$4, 1L, 1).mapPartitions((Function1 & Serializable)iter -> iter.map((Function1 & Serializable)i -> LocalDate.ofEpochDay(Predef$.MODULE$.Long2long(i) % 1000L * 365L).toString()), MODULE$.spark().implicits().newStringEncoder()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{MODULE$.spark().implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).as("date")})).as(MODULE$.spark().implicits().newStringEncoder());
    }

    public static final /* synthetic */ void $anonfun$datetimeBenchmark$5(CSVBenchmark$ $this, int rowsNum$4, int numIters$4, File path) {
        String timestampDir = new File(path, "timestamp").getAbsolutePath();
        String dateDir = new File(path, "date").getAbsolutePath();
        String x$1 = "Write dates and timestamps";
        long x$2 = rowsNum$4;
        Option x$3 = MODULE$.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark writeBench = new Benchmark("Write dates and timestamps", x$2, x$4, x$5, x$6, x$7, x$3);
        writeBench.addCase("Create a dataset of timestamps", numIters$4, (Function1)(JFunction1.mcVI.sp & Serializable)x$16 -> MODULE$.DatasetToBenchmark($this.timestamps$1(rowsNum$4)).noop());
        writeBench.addCase("to_csv(timestamp)", numIters$4, (Function1)(JFunction1.mcVI.sp & Serializable)x$17 -> MODULE$.DatasetToBenchmark($this.timestamps$1(rowsNum$4).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.to_csv(functions$.MODULE$.struct((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{MODULE$.spark().implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"timestamp"}))).$((Seq)Nil$.MODULE$)})))}))).noop());
        writeBench.addCase("write timestamps to files", numIters$4, (Function1)(JFunction1.mcVI.sp & Serializable)x$18 -> $this.timestamps$1(rowsNum$4).write().option("header", true).mode("overwrite").csv(timestampDir));
        writeBench.addCase("Create a dataset of dates", numIters$4, (Function1)(JFunction1.mcVI.sp & Serializable)x$19 -> MODULE$.DatasetToBenchmark($this.dates$1(rowsNum$4)).noop());
        writeBench.addCase("to_csv(date)", numIters$4, (Function1)(JFunction1.mcVI.sp & Serializable)x$20 -> MODULE$.DatasetToBenchmark($this.dates$1(rowsNum$4).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.to_csv(functions$.MODULE$.struct((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{MODULE$.spark().implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"date"}))).$((Seq)Nil$.MODULE$)})))}))).noop());
        writeBench.addCase("write dates to files", numIters$4, (Function1)(JFunction1.mcVI.sp & Serializable)x$21 -> $this.dates$1(rowsNum$4).write().option("header", true).mode("overwrite").csv(dateDir));
        writeBench.run();
        String x$8 = "Read dates and timestamps";
        long x$9 = rowsNum$4;
        Option x$10 = MODULE$.output();
        int x$11 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$12 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$13 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$14 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark readBench = new Benchmark("Read dates and timestamps", x$9, x$11, x$12, x$13, x$14, x$10);
        StructType tsSchema = new StructType().add("timestamp", (DataType)TimestampType$.MODULE$);
        readBench.addCase("read timestamp text from files", numIters$4, (Function1)(JFunction1.mcVI.sp & Serializable)x$22 -> MODULE$.DatasetToBenchmark(MODULE$.spark().read().text(timestampDir)).noop());
        readBench.addCase("read timestamps from files", numIters$4, (Function1)(JFunction1.mcVI.sp & Serializable)x$23 -> {
            Dataset ds = MODULE$.spark().read().option("header", true).schema(tsSchema).csv(timestampDir);
            MODULE$.DatasetToBenchmark(ds).noop();
        });
        readBench.addCase("infer timestamps from files", numIters$4, (Function1)(JFunction1.mcVI.sp & Serializable)x$24 -> {
            Dataset ds = MODULE$.spark().read().option("header", true).option("inferSchema", true).csv(timestampDir);
            MODULE$.DatasetToBenchmark(ds).noop();
        });
        StructType dateSchema = new StructType().add("date", (DataType)DateType$.MODULE$);
        readBench.addCase("read date text from files", numIters$4, (Function1)(JFunction1.mcVI.sp & Serializable)x$25 -> MODULE$.DatasetToBenchmark(MODULE$.spark().read().text(dateDir)).noop());
        readBench.addCase("read date from files", numIters$4, (Function1)(JFunction1.mcVI.sp & Serializable)x$26 -> {
            Dataset ds = MODULE$.spark().read().option("header", true).schema(dateSchema).csv(dateDir);
            MODULE$.DatasetToBenchmark(ds).noop();
        });
        readBench.addCase("infer date from files", numIters$4, (Function1)(JFunction1.mcVI.sp & Serializable)x$27 -> {
            Dataset ds = MODULE$.spark().read().option("header", true).option("inferSchema", true).csv(dateDir);
            MODULE$.DatasetToBenchmark(ds).noop();
        });
        readBench.addCase("timestamp strings", numIters$4, (Function1)(JFunction1.mcVI.sp & Serializable)x$28 -> MODULE$.DatasetToBenchmark(CSVBenchmark$.timestampStr$1(rowsNum$4)).noop());
        readBench.addCase("parse timestamps from Dataset[String]", numIters$4, (Function1)(JFunction1.mcVI.sp & Serializable)x$29 -> {
            Dataset ds = MODULE$.spark().read().option("header", false).schema(tsSchema).csv(CSVBenchmark$.timestampStr$1(rowsNum$4));
            MODULE$.DatasetToBenchmark(ds).noop();
        });
        readBench.addCase("infer timestamps from Dataset[String]", numIters$4, (Function1)(JFunction1.mcVI.sp & Serializable)x$30 -> {
            Dataset ds = MODULE$.spark().read().option("header", false).option("inferSchema", true).csv(CSVBenchmark$.timestampStr$1(rowsNum$4));
            MODULE$.DatasetToBenchmark(ds).noop();
        });
        readBench.addCase("date strings", numIters$4, (Function1)(JFunction1.mcVI.sp & Serializable)x$31 -> MODULE$.DatasetToBenchmark(CSVBenchmark$.dateStr$1(rowsNum$4)).noop());
        readBench.addCase("parse dates from Dataset[String]", numIters$4, (Function1)(JFunction1.mcVI.sp & Serializable)x$32 -> {
            Dataset ds = MODULE$.spark().read().option("header", false).schema(dateSchema).csv(CSVBenchmark$.dateStr$1(rowsNum$4));
            MODULE$.DatasetToBenchmark(ds).noop();
        });
        readBench.addCase("from_csv(timestamp)", numIters$4, (Function1)(JFunction1.mcVI.sp & Serializable)x$33 -> {
            Dataset ds = CSVBenchmark$.timestampStr$1(rowsNum$4).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.from_csv((Column)MODULE$.spark().implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"timestamp"}))).$((Seq)Nil$.MODULE$), tsSchema, Predef$.MODULE$.Map().empty())}));
            MODULE$.DatasetToBenchmark(ds).noop();
        });
        readBench.addCase("from_csv(date)", numIters$4, (Function1)(JFunction1.mcVI.sp & Serializable)x$34 -> {
            Dataset ds = CSVBenchmark$.dateStr$1(rowsNum$4).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.from_csv((Column)MODULE$.spark().implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"date"}))).$((Seq)Nil$.MODULE$), dateSchema, Predef$.MODULE$.Map().empty())}));
            MODULE$.DatasetToBenchmark(ds).noop();
        });
        readBench.run();
    }

    public static final /* synthetic */ StructField $anonfun$filtersPushdownBenchmark$1(int i) {
        return new StructField(new StringBuilder(3).append("col").append(i).toString(), (DataType)TimestampType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
    }

    public static final /* synthetic */ Column $anonfun$filtersPushdownBenchmark$2(int i) {
        return functions$.MODULE$.lit((Object)Instant.ofEpochSecond(i * 12345678)).as(new StringBuilder(3).append("col").append(i).toString());
    }

    private final Seq columns$1(int colsNum$3) {
        Seq ts = (Seq)package$.MODULE$.Seq().tabulate(colsNum$3, (Function1 & Serializable)i -> CSVBenchmark$.$anonfun$filtersPushdownBenchmark$2(BoxesRunTime.unboxToInt((Object)i)));
        Column column = this.spark().implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$).$percent((Object)BoxesRunTime.boxToInteger((int)1000)).as("key");
        return (Seq)ts.$plus$colon((Object)column);
    }

    private static final Dataset readback$1(StructType schema$1, File path$1) {
        return MODULE$.spark().read().option("header", true).schema(schema$1).csv(path$1.getAbsolutePath());
    }

    private static final void withFilter$1(boolean configEnabled, StructType schema$1, File path$1) {
        MODULE$.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CSV_FILTER_PUSHDOWN_ENABLED().key()), (Object)Boolean.toString(configEnabled))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> MODULE$.DatasetToBenchmark(CSVBenchmark$.readback$1(schema$1, path$1).filter(MODULE$.spark().implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"key"}))).$((Seq)Nil$.MODULE$).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)0)))).noop());
    }

    public static final /* synthetic */ void $anonfun$filtersPushdownBenchmark$3(CSVBenchmark$ $this, int rowsNum$5, StructType schema$1, Benchmark benchmark$4, int numIters$5, int colsNum$3, File path) {
        MODULE$.spark().range((long)rowsNum$5).select($this.columns$1(colsNum$3)).write().option("header", true).csv(path.getAbsolutePath());
        benchmark$4.addCase("w/o filters", numIters$5, (Function1)(JFunction1.mcVI.sp & Serializable)x$35 -> MODULE$.DatasetToBenchmark(CSVBenchmark$.readback$1(schema$1, path)).noop());
        benchmark$4.addCase("pushdown disabled", numIters$5, (Function1)(JFunction1.mcVI.sp & Serializable)x$36 -> CSVBenchmark$.withFilter$1(false, schema$1, path));
        benchmark$4.addCase("w/ filters", numIters$5, (Function1)(JFunction1.mcVI.sp & Serializable)x$37 -> CSVBenchmark$.withFilter$1(true, schema$1, path));
        benchmark$4.run();
    }

    private CSVBenchmark$() {
    }
}

