/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Random;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.datasources.parquet.ParquetCompatibilityTest;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedDeltaBinaryPackedReader;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.test.SQLTestUtils;
import org.apache.spark.sql.test.SharedSparkSession;
import org.apache.spark.sql.test.SharedSparkSessionBase;
import org.apache.spark.sql.test.TestSparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegralType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\tma!B\u0013'\u0003\u0003)\u0004\"B!\u0001\t\u0003\u0011\u0005b\u0002*\u0001\u0001\u0004%\tb\u0015\u0005\b/\u0002\u0001\r\u0011\"\u0005Y\u0011\u0019q\u0006\u0001)Q\u0005)\"9q\f\u0001a\u0001\n#\u0019\u0006b\u00021\u0001\u0001\u0004%\t\"\u0019\u0005\u0007G\u0002\u0001\u000b\u0015\u0002+\t\u0013\u0011\u0004\u0001\u0019!a\u0001\n#)\u0007\"C5\u0001\u0001\u0004\u0005\r\u0011\"\u0005k\u0011%a\u0007\u00011A\u0001B\u0003&a\rC\u0005n\u0001\u0001\u0007\t\u0019!C\t]\"IQ\u000f\u0001a\u0001\u0002\u0004%\tB\u001e\u0005\nq\u0002\u0001\r\u0011!Q!\n=D\u0011\"\u001f\u0001A\u0002\u0003\u0007I\u0011\u0003>\t\u0017\u0005%\u0001\u00011AA\u0002\u0013E\u00111\u0002\u0005\u000b\u0003\u001f\u0001\u0001\u0019!A!B\u0013Y\bbCA\t\u0001\u0001\u0007\t\u0019!C\t\u0003'A1\"!\n\u0001\u0001\u0004\u0005\r\u0011\"\u0005\u0002(!Y\u00111\u0006\u0001A\u0002\u0003\u0005\u000b\u0015BA\u000b\u0011\u001d\ti\u0003\u0001D\t\u0003_Aq!!\u0010\u0001\r#\ty\u0004C\u0004\u0002>\u00011\t\"a\u0013\t\u000f\u0005M\u0003A\"\u0005\u0002V!9\u0011q\u000b\u0001\u0007\u0012\u0005e\u0003bBA0\u0001\u0019E\u0011\u0011\r\u0005\b\u0003G\u0002a\u0011CA1\u0011\u001d\t)\u0007\u0001D\t\u0003CBq!a\u001a\u0001\r#\tI\u0007C\u0004\u0002x\u00011\t\"!\u001f\t\u000f\u0005u\u0004A\"\u0005\u0002\u0000!9\u0011Q\u0011\u0001\u0007\u0012\u0005\u001d\u0005bBAI\u0001\u0019E\u00111\u0013\u0005\b\u0003C\u0003a\u0011CAR\u0011\u001d\t\u0019\f\u0001C)\u0003+Bq!!.\u0001\t\u0013\t9\fC\u0004\u0003\u0014\u0001!IA!\u0006\u00033A\u000b'/];fi\u0012+G\u000e^1F]\u000e|G-\u001b8h'VLG/\u001a\u0006\u0003O!\nq\u0001]1scV,GO\u0003\u0002*U\u0005YA-\u0019;bg>,(oY3t\u0015\tYC&A\u0005fq\u0016\u001cW\u000f^5p]*\u0011QFL\u0001\u0004gFd'BA\u00181\u0003\u0015\u0019\b/\u0019:l\u0015\t\t$'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002g\u0005\u0019qN]4\u0004\u0001U\u0011aGR\n\u0004\u0001]Z\u0004C\u0001\u001d:\u001b\u00051\u0013B\u0001\u001e'\u0005a\u0001\u0016M]9vKR\u001cu.\u001c9bi&\u0014\u0017\u000e\\5usR+7\u000f\u001e\t\u0003y}j\u0011!\u0010\u0006\u0003}1\nA\u0001^3ti&\u0011\u0001)\u0010\u0002\u0013'\"\f'/\u001a3Ta\u0006\u00148nU3tg&|g.\u0001\u0004=S:LGO\u0010\u000b\u0002\u0007B\u0019\u0001\b\u0001#\u0011\u0005\u00153E\u0002\u0001\u0003\u0006\u000f\u0002\u0011\r\u0001\u0013\u0002\u0002)F\u0011\u0011j\u0014\t\u0003\u00156k\u0011a\u0013\u0006\u0002\u0019\u0006)1oY1mC&\u0011aj\u0013\u0002\b\u001d>$\b.\u001b8h!\tQ\u0005+\u0003\u0002R\u0017\n\u0019\u0011I\\=\u0002\u0013\tdwnY6TSj,W#\u0001+\u0011\u0005)+\u0016B\u0001,L\u0005\rIe\u000e^\u0001\u000eE2|7m[*ju\u0016|F%Z9\u0015\u0005ec\u0006C\u0001&[\u0013\tY6J\u0001\u0003V]&$\bbB/\u0004\u0003\u0003\u0005\r\u0001V\u0001\u0004q\u0012\n\u0014A\u00032m_\u000e\\7+\u001b>fA\u0005aQ.\u001b8j\u00052|7m\u001b(v[\u0006\u0001R.\u001b8j\u00052|7m\u001b(v[~#S-\u001d\u000b\u00033\nDq!\u0018\u0004\u0002\u0002\u0003\u0007A+A\u0007nS:L'\t\\8dW:+X\u000eI\u0001\u0007e\u0016\fG-\u001a:\u0016\u0003\u0019\u0004\"\u0001O4\n\u0005!4#!\t,fGR|'/\u001b>fI\u0012+G\u000e^1CS:\f'/\u001f)bG.,GMU3bI\u0016\u0014\u0018A\u0003:fC\u0012,'o\u0018\u0013fcR\u0011\u0011l\u001b\u0005\b;&\t\t\u00111\u0001g\u0003\u001d\u0011X-\u00193fe\u0002\nAc\u001e:ji\u0006\u0014G.Z\"pYVlgNV3di>\u0014X#A8\u0011\u0005A\u001cX\"A9\u000b\u0005IT\u0013A\u0003<fGR|'/\u001b>fI&\u0011A/\u001d\u0002\u0015/JLG/\u00192mK\u000e{G.^7o-\u0016\u001cGo\u001c:\u00021]\u0014\u0018\u000e^1cY\u0016\u001cu\u000e\\;n]Z+7\r^8s?\u0012*\u0017\u000f\u0006\u0002Zo\"9Q\fDA\u0001\u0002\u0004y\u0017!F<sSR\f'\r\\3D_2,XN\u001c,fGR|'\u000fI\u0001\u0007oJLG/\u001a:\u0016\u0003m\u00042\u0001`A\u0003\u001b\u0005i(B\u0001@\u0000\u0003\u00191\u0018\r\\;fg*!\u0011\u0011AA\u0002\u0003\u0019\u0019w\u000e\\;n]*\u0011q\u0005M\u0005\u0004\u0003\u000fi(\u0001\u0004,bYV,7o\u0016:ji\u0016\u0014\u0018AC<sSR,'o\u0018\u0013fcR\u0019\u0011,!\u0004\t\u000fu{\u0011\u0011!a\u0001w\u00069qO]5uKJ\u0004\u0013A\u0002:b]\u0012|W.\u0006\u0002\u0002\u0016A!\u0011qCA\u0011\u001b\t\tIB\u0003\u0003\u0002\u001c\u0005u\u0011\u0001B;uS2T!!a\b\u0002\t)\fg/Y\u0005\u0005\u0003G\tIB\u0001\u0004SC:$w.\\\u0001\u000be\u0006tGm\\7`I\u0015\fHcA-\u0002*!AQLEA\u0001\u0002\u0004\t)\"A\u0004sC:$w.\u001c\u0011\u0002\u001f\u001d,Go\u00159be.\u001c\u0016\u000f\u001c+za\u0016,\"!!\r\u0011\t\u0005M\u0012\u0011H\u0007\u0003\u0003kQ1!a\u000e-\u0003\u0015!\u0018\u0010]3t\u0013\u0011\tY$!\u000e\u0003\u0019%sG/Z4sC2$\u0016\u0010]3\u0002\u0013]\u0014\u0018\u000e^3ECR\fGcA-\u0002B!9\u00111I\u000bA\u0002\u0005\u0015\u0013\u0001\u00023bi\u0006\u0004BASA$\t&\u0019\u0011\u0011J&\u0003\u000b\u0005\u0013(/Y=\u0015\u000be\u000bi%a\u0014\t\u000f\u0005\rc\u00031\u0001\u0002F!1\u0011\u0011\u000b\fA\u0002Q\u000ba\u0001\\3oORD\u0017\u0001E5oSR4\u0016\r\\;fg^\u0013\u0018\u000e^3s)\u0005I\u0016AD1mY>\u001cG)\u0019;b\u0003J\u0014\u0018-\u001f\u000b\u0005\u0003\u000b\nY\u0006\u0003\u0004\u0002^a\u0001\r\u0001V\u0001\u0005g&TX-A\u0007hKRtU\r\u001f;SC:$w.\\\u000b\u0002\t\u0006yq-\u001a;UsB,W*\u001b8WC2,X-A\bhKR$\u0016\u0010]3NCb4\u0016\r\\;f\u0003!\u0011X-\u00193ECR\fGcB-\u0002l\u0005=\u00141\u000f\u0005\u0007\u0003[b\u0002\u0019\u0001+\u0002\u000bQ|G/\u00197\t\r\u0005ED\u00041\u0001p\u00031\u0019w\u000e\\;n]Z+7\r^8s\u0011\u0019\t)\b\ba\u0001)\u0006)!o\\<JI\u0006!1o[5q)\rI\u00161\u0010\u0005\u0007\u0003[j\u0002\u0019\u0001+\u0002%I,\u0017\r\u001a#bi\u00064%o\\7WK\u000e$xN\u001d\u000b\u0006\t\u0006\u0005\u00151\u0011\u0005\u0007\u0003cr\u0002\u0019A8\t\r\u0005Ud\u00041\u0001U\u00035)7\u000f^5nCR,GmU5{KR!\u0011\u0011RAH!\rQ\u00151R\u0005\u0004\u0003\u001b[%A\u0002#pk\ndW\r\u0003\u0004\u0002R}\u0001\r\u0001V\u0001\tg\u0016$h+\u00197vKR9\u0011,!&\u0002\u001a\u0006u\u0005bBALA\u0001\u0007\u0011QI\u0001\u0004CJ\u0014\bBBANA\u0001\u0007A+A\u0003j]\u0012,\u0007\u0010\u0003\u0004\u0002 \u0002\u0002\r\u0001V\u0001\u0006m\u0006dW/Z\u0001\u000eG>l\u0007/\u0019:f-\u0006dW/Z:\u0015\r\u0005\u0015\u00161VAX!\rQ\u0015qU\u0005\u0004\u0003S[%a\u0002\"p_2,\u0017M\u001c\u0005\u0007\u0003[\u000b\u0003\u0019\u0001+\u0002\u0011\u0015D\b/Z2uK\u0012Da!!-\"\u0001\u0004!\u0015AB1diV\fG.\u0001\u0006cK\u001a|'/Z#bG\"\f!c\u001d5pk2$wK]5uK\u0006sGMU3bIR\u0019\u0011,!/\t\u000f\u0005\r3\u00051\u0001\u0002F!*1%!0\u0002PB)!*a0\u0002D&\u0019\u0011\u0011Y&\u0003\rQD'o\\<t!\u0011\t)-a3\u000e\u0005\u0005\u001d'\u0002BAe\u0003;\t!![8\n\t\u00055\u0017q\u0019\u0002\f\u0013>+\u0005pY3qi&|g.M\u0004\u001f\u0003#\f9O!\u0005\u0011\t\u0005M\u0017\u0011\u001d\b\u0005\u0003+\fi\u000eE\u0002\u0002X.k!!!7\u000b\u0007\u0005mG'\u0001\u0004=e>|GOP\u0005\u0004\u0003?\\\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002d\u0006\u0015(AB*ue&twMC\u0002\u0002`.\u000b\u0014bIAu\u0003_\u00149!!=\u0016\t\u0005-\u0018Q^\u000b\u0003\u0003#$aa\u0012\u001bC\u0002\u0005]\u0018\u0002BAy\u0003g\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\n$bAA{\u0017\u00061A\u000f\u001b:poN\f2!SA}!\u0011\tYP!\u0001\u000f\u0007)\u000bi0C\u0002\u0002\u0000.\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0003\u0004\t\u0015!!\u0003+ie><\u0018M\u00197f\u0015\r\typS\u0019\nG\t%!1\u0002B\u0007\u0003kt1A\u0013B\u0006\u0013\r\t)pS\u0019\u0006E)[%q\u0002\u0002\u0006g\u000e\fG.Y\u0019\u0004M\u0005\r\u0017AE:i_VdGMU3bI\u0006sGm\u0016:ji\u0016$R!\u0017B\f\u00053Aq!a\u0011%\u0001\u0004\t)\u0005\u0003\u0004\u0002R\u0011\u0002\r\u0001\u0016")
public abstract class ParquetDeltaEncodingSuite<T>
extends ParquetCompatibilityTest
implements SharedSparkSession {
    private int blockSize;
    private int miniBlockNum;
    private VectorizedDeltaBinaryPackedReader reader;
    private WritableColumnVector writableColumnVector;
    private ValuesWriter writer;
    private Random random;
    private boolean enableAutoThreadAudit;
    private TestSparkSession org$apache$spark$sql$test$SharedSparkSessionBase$$_spark;

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$beforeAll() {
        SharedSparkSessionBase.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$afterAll() {
        SharedSparkSessionBase.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        SharedSparkSession.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        SharedSparkSession.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$beforeAll() {
        SQLTestUtils.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    @Override
    public SparkConf sparkConf() {
        return SharedSparkSessionBase.sparkConf$(this);
    }

    @Override
    public SparkSession spark() {
        return SharedSparkSessionBase.spark$(this);
    }

    @Override
    public SQLContext sqlContext() {
        return SharedSparkSessionBase.sqlContext$(this);
    }

    @Override
    public TestSparkSession createSparkSession() {
        return SharedSparkSessionBase.createSparkSession$(this);
    }

    @Override
    public void initializeSession() {
        SharedSparkSessionBase.initializeSession$(this);
    }

    @Override
    public void afterEach() {
        SharedSparkSessionBase.afterEach$(this);
    }

    @Override
    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSparkSession$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    @Override
    public TestSparkSession org$apache$spark$sql$test$SharedSparkSessionBase$$_spark() {
        return this.org$apache$spark$sql$test$SharedSparkSessionBase$$_spark;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSparkSessionBase$$_spark_$eq(TestSparkSession x$1) {
        this.org$apache$spark$sql$test$SharedSparkSessionBase$$_spark = x$1;
    }

    public int blockSize() {
        return this.blockSize;
    }

    public void blockSize_$eq(int x$1) {
        this.blockSize = x$1;
    }

    public int miniBlockNum() {
        return this.miniBlockNum;
    }

    public void miniBlockNum_$eq(int x$1) {
        this.miniBlockNum = x$1;
    }

    public VectorizedDeltaBinaryPackedReader reader() {
        return this.reader;
    }

    public void reader_$eq(VectorizedDeltaBinaryPackedReader x$1) {
        this.reader = x$1;
    }

    public WritableColumnVector writableColumnVector() {
        return this.writableColumnVector;
    }

    public void writableColumnVector_$eq(WritableColumnVector x$1) {
        this.writableColumnVector = x$1;
    }

    public ValuesWriter writer() {
        return this.writer;
    }

    public void writer_$eq(ValuesWriter x$1) {
        this.writer = x$1;
    }

    public Random random() {
        return this.random;
    }

    public void random_$eq(Random x$1) {
        this.random = x$1;
    }

    public abstract IntegralType getSparkSqlType();

    public abstract void writeData(Object var1);

    public abstract void writeData(Object var1, int var2);

    public abstract void initValuesWriter();

    public abstract Object allocDataArray(int var1);

    public abstract T getNextRandom();

    public abstract T getTypeMinValue();

    public abstract T getTypeMaxValue();

    public abstract void readData(int var1, WritableColumnVector var2, int var3);

    public abstract void skip(int var1);

    public abstract T readDataFromVector(WritableColumnVector var1, int var2);

    public abstract double estimatedSize(int var1);

    public abstract void setValue(Object var1, int var2, int var3);

    public abstract boolean compareValues(int var1, T var2);

    @Override
    public void beforeEach() {
        this.random_$eq(new Random(0L));
        this.initValuesWriter();
        SharedSparkSession.beforeAll$(this);
    }

    private void shouldWriteAndRead(Object data) throws IOException {
        this.shouldReadAndWrite(data, ScalaRunTime$.MODULE$.array_length(data));
    }

    private void shouldReadAndWrite(Object data, int length) {
        this.writeData(data, length);
        this.reader_$eq(new VectorizedDeltaBinaryPackedReader());
        byte[] page = this.writer().getBytes().toByteArray();
        double $org_scalatest_assert_macro_left = this.estimatedSize(length);
        int $org_scalatest_assert_macro_right = page.length;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), ">=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left >= (double)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetDeltaEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238));
        this.writableColumnVector_$eq((WritableColumnVector)new OnHeapColumnVector(ScalaRunTime$.MODULE$.array_length(data), (DataType)this.getSparkSqlType()));
        this.reader().initFromPage(100, ByteBufferInputStream.wrap((ByteBuffer[])new ByteBuffer[]{ByteBuffer.wrap(page)}));
        this.readData(length, this.writableColumnVector(), 0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), length).foreach((Function1 & Serializable)i -> ParquetDeltaEncodingSuite.$anonfun$shouldReadAndWrite$1(this, data, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Object $anonfun$new$25(ParquetDeltaEncodingSuite $this, int i) {
        BoxedUnit boxedUnit;
        if (i % 3 == 0) {
            $this.skip(1);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            $this.readData(1, $this.writableColumnVector(), i);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool($this.compareValues(i * 32, $this.readDataFromVector($this.writableColumnVector(), i)), "ParquetDeltaEncodingSuite.this.compareValues(i.*(32), ParquetDeltaEncodingSuite.this.readDataFromVector(ParquetDeltaEncodingSuite.this.writableColumnVector, i))", Prettifier$.MODULE$.default());
            boxedUnit = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetDeltaEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
        }
        return boxedUnit;
    }

    public static final /* synthetic */ Assertion $anonfun$shouldReadAndWrite$1(ParquetDeltaEncodingSuite $this, Object data$14, int i) {
        Object $org_scalatest_assert_macro_right;
        Object $org_scalatest_assert_macro_left;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", $org_scalatest_assert_macro_right, BoxesRunTime.equals((Object)($org_scalatest_assert_macro_left = ScalaRunTime$.MODULE$.array_apply(data$14, i)), $org_scalatest_assert_macro_right = $this.readDataFromVector($this.writableColumnVector(), i)), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetDeltaEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 243));
    }

    public ParquetDeltaEncodingSuite() {
        SharedSparkSessionBase.$init$(this);
        SharedSparkSession.$init$(this);
        this.blockSize = 128;
        this.miniBlockNum = 4;
        this.test("read when data is aligned with block", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Object data = this.allocDataArray(5 * this.blockSize());
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.blockSize() * 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> ScalaRunTime$.MODULE$.array_update(data, i, this.getNextRandom()));
            this.shouldWriteAndRead(data);
        }, new Position("ParquetDeltaEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
        this.test("read when block is not fully written", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Object data = this.allocDataArray(this.blockSize() - 3);
            ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.genericArrayOps(data)).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> ScalaRunTime$.MODULE$.array_update(data, i, this.getNextRandom()));
            this.shouldWriteAndRead(data);
        }, new Position("ParquetDeltaEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
        this.test("read when mini block is not fully written", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            int miniBlockSize = this.blockSize() / this.miniBlockNum();
            Object data = this.allocDataArray(miniBlockSize - 3);
            ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.genericArrayOps(data)).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> ScalaRunTime$.MODULE$.array_update(data, i, this.getNextRandom()));
            this.shouldWriteAndRead(data);
        }, new Position("ParquetDeltaEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
        this.test("read with negative deltas", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Object data = this.allocDataArray(this.blockSize());
            ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.genericArrayOps(data)).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.setValue(data, i, 10 - (i * 32 - this.random().nextInt(6))));
            this.shouldWriteAndRead(data);
        }, new Position("ParquetDeltaEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
        this.test("read when deltas are same", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Object data = this.allocDataArray(2 * this.blockSize());
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.blockSize()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.setValue(data, i, i * 32));
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(this.blockSize()), 2 * this.blockSize()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.setValue(data, i, 0));
            this.shouldWriteAndRead(data);
        }, new Position("ParquetDeltaEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
        this.test("read when values are same", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Object data = this.allocDataArray(2 * this.blockSize());
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.blockSize()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.setValue(data, i, 3));
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(this.blockSize()), 2 * this.blockSize()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.setValue(data, i, 0));
            this.shouldWriteAndRead(data);
        }, new Position("ParquetDeltaEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
        this.test("read when delta is 0 for each block", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Object data = this.allocDataArray(5 * this.blockSize() + 1);
            ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.genericArrayOps(data)).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.setValue(data, i, (i - 1) / this.blockSize()));
            this.shouldWriteAndRead(data);
        }, new Position("ParquetDeltaEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
        this.test("read when data is not aligned with block", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Object data = this.allocDataArray(5 * this.blockSize() + 3);
            ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.genericArrayOps(data)).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.setValue(data, i, this.random().nextInt(20) - 10));
            this.shouldWriteAndRead(data);
        }, new Position("ParquetDeltaEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
        this.test("read max min value", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Object data = this.allocDataArray(10);
            ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.genericArrayOps(data)).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                if (i % 2 == 0) {
                    ScalaRunTime$.MODULE$.array_update(data, i, this.getTypeMinValue());
                } else {
                    ScalaRunTime$.MODULE$.array_update(data, i, this.getTypeMaxValue());
                }
            });
            this.shouldWriteAndRead(data);
        }, new Position("ParquetDeltaEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
        this.test("throw exception when read more than written", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            BoxedUnit boxedUnit;
            Object data = this.allocDataArray(5 * this.blockSize() + 1);
            ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.genericArrayOps(data)).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.setValue(data, i, i * 32));
            this.shouldWriteAndRead(data);
            try {
                this.readData(1, this.writableColumnVector(), ScalaRunTime$.MODULE$.array_length(data));
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (ParquetDecodingException e) {
                String $org_scalatest_assert_macro_left = e.getMessage();
                String $org_scalatest_assert_macro_right = "No more values to read.";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "startsWith", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.startsWith($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                boxedUnit = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetDeltaEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
            }
            return boxedUnit;
        }, new Position("ParquetDeltaEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
        this.test("skip()", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Object data = this.allocDataArray(5 * this.blockSize() + 1);
            ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.genericArrayOps(data)).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.setValue(data, i, i * 32));
            this.writeData(data);
            this.reader_$eq(new VectorizedDeltaBinaryPackedReader());
            this.reader().initFromPage(100, this.writer().getBytes().toInputStream());
            this.writableColumnVector_$eq((WritableColumnVector)new OnHeapColumnVector(ScalaRunTime$.MODULE$.array_length(data), (DataType)this.getSparkSqlType()));
            ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.genericArrayOps(data)).foreach((Function1 & Serializable)i -> ParquetDeltaEncodingSuite.$anonfun$new$25(this, BoxesRunTime.unboxToInt((Object)i)));
        }, new Position("ParquetDeltaEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
        this.test("SkipN()", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Object data = this.allocDataArray(5 * this.blockSize() + 1);
            ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.genericArrayOps(data)).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.setValue(data, i, i * 32));
            this.writeData(data);
            this.reader_$eq(new VectorizedDeltaBinaryPackedReader());
            this.reader().initFromPage(100, this.writer().getBytes().toInputStream());
            this.writableColumnVector_$eq((WritableColumnVector)new OnHeapColumnVector(ScalaRunTime$.MODULE$.array_length(data), (DataType)this.getSparkSqlType()));
            int skipCount = 0;
            for (int i2 = 0; i2 < ScalaRunTime$.MODULE$.array_length(data); i2 += skipCount + 1) {
                skipCount = (ScalaRunTime$.MODULE$.array_length(data) - i2) / 2;
                this.readData(1, this.writableColumnVector(), i2);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.compareValues(i2 * 32, this.readDataFromVector(this.writableColumnVector(), i2)), "ParquetDeltaEncodingSuite.this.compareValues(i.*(32), ParquetDeltaEncodingSuite.this.readDataFromVector(ParquetDeltaEncodingSuite.this.writableColumnVector, i))", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetDeltaEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 208));
                this.skip(skipCount);
            }
        }, new Position("ParquetDeltaEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
        this.test("random data test", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            int maxSize = 1000;
            Object data = this.allocDataArray(maxSize);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 100000).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)round -> {
                int size = this.random().nextInt(maxSize);
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), size).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> ScalaRunTime$.MODULE$.array_update(data, i, this.getNextRandom()));
                this.shouldReadAndWrite(data, size);
                this.writer().reset();
            });
        }, new Position("ParquetDeltaEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 215));
        Statics.releaseFence();
    }
}

